/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.util;

import hec.dataui.tx.util.PhotoViewer;
import hec.map.LocalRect;
import hec.util.PhotoViewerInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Observer;
import javax.swing.ImageIcon;

public class PhotoViewerIcon
extends ImageIcon {
    PhotoViewer photoViewer;
    PhotoViewerInfo _photoViewerInfo;
    Component _parent;

    public PhotoViewerIcon(Component parent, PhotoViewerInfo photoViewerInfo) {
        this._parent = parent;
        this._photoViewerInfo = (PhotoViewerInfo)photoViewerInfo.clone();
        this.photoViewer = new PhotoViewer(parent, photoViewerInfo);
    }

    public PhotoViewerInfo getPhotoViewerInfo() {
        return this._photoViewerInfo;
    }

    public PhotoViewer getPhotoViewer() {
        return this.photoViewer;
    }

    public boolean haveImage() {
        if (this.photoViewer == null) {
            return false;
        }
        return this.photoViewer.haveImage();
    }

    @Override
    public int getIconHeight() {
        return this.photoViewer.getHeight();
    }

    @Override
    public int getIconWidth() {
        return this.photoViewer.getWidth();
    }

    @Override
    public Image getImage() {
        return this.photoViewer.getImage();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.photoViewer.paint(g, x, y);
        g.setColor(Color.black);
        g.drawRect(x - 1, y - 1, this.getIconWidth() + 1, this.getIconHeight() + 1);
    }

    public LocalRect getMapRectangle() {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        LocalRect rect = new LocalRect();
        rect.l = -(w / 2);
        rect.r = w + rect.l;
        rect.t = -(h / 2);
        rect.b = h + rect.t;
        return rect;
    }

    public hec.geometry.LocalRect getRectangle() {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        hec.geometry.LocalRect rect = new hec.geometry.LocalRect();
        rect.l = -(w / 2);
        rect.r = w + rect.l;
        rect.t = -(h / 2);
        rect.b = h + rect.t;
        return rect;
    }

    public void addObserver(Observer o) {
        this.photoViewer.addObserver(o);
    }

    public void removeObserver(Observer o) {
        this.photoViewer.removeObserver(o);
    }

    public void done() {
        this.photoViewer.done();
    }
}

