/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.util;

import hec.dataui.tx.util.PhotoViewer;
import hec.heclib.util.HecTime;
import hec.util.PhotoViewerInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.util.RMAFilenameFilter;

public class PhotoViewerJFrame
extends JFrame
implements Observer {
    protected PhotoViewer photoViewer;
    protected PhotoViewerInfo _photoViewerInfo;
    protected boolean _exitOnClose = false;
    protected PhotoViewerInfo _currentImage = null;
    protected boolean _moreImages = true;
    protected JButton _nextButton = null;
    protected boolean _paused = false;
    protected boolean _recording = false;
    protected int _numberReadErrors = 0;
    protected JMenuBar mb = null;
    protected JRadioButtonMenuItem _defaultSizeMenu;
    protected JRadioButtonMenuItem _size1Menu;
    protected JRadioButtonMenuItem _size2Menu;
    protected JRadioButtonMenuItem _size3Menu;
    protected JRadioButtonMenuItem _size4Menu;
    protected JRadioButtonMenuItem _size5Menu;
    protected ButtonGroup _sizeGroup;
    protected String _pausedTitle = "";
    protected String _imageTitle = "";
    protected ButtonCmdPanel cmdPanel = null;
    public int height = 0;
    public int width = 0;
    public int status = 0;

    public PhotoViewerJFrame(PhotoViewerInfo photoViewerInfo) {
        super(photoViewerInfo.name);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.photoViewer = new PhotoViewer();
        this.getContentPane().add(this.photoViewer);
        this.addListeners();
        this.setPhotoViewerInfo(photoViewerInfo);
    }

    public PhotoViewerJFrame(PhotoViewerInfo photoViewerInfo, boolean addMenu) {
        super(photoViewerInfo.name);
        if (addMenu) {
            this.addMenu();
        }
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.photoViewer = new PhotoViewer();
        this.getContentPane().add(this.photoViewer);
        this.addListeners();
        this.setPhotoViewerInfo(photoViewerInfo);
    }

    public PhotoViewerJFrame(PhotoViewerInfo firstImageInfo, int numberImages) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.photoViewer = new PhotoViewer();
        this.cmdPanel = new ButtonCmdPanel(12);
        this._nextButton = this.cmdPanel.getButton("OK");
        this._nextButton.setText("Next");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.photoViewer, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        PhotoViewerJFrame.this.nextImage();
                        break;
                    }
                    case 4: {
                        PhotoViewerJFrame.this.done();
                    }
                }
            }
        });
        this.addListeners();
        this.setPhotoViewerInfo(firstImageInfo);
        this.getNextImage();
    }

    protected void addListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (PhotoViewerJFrame.this.photoViewer != null && PhotoViewerJFrame.this.isVisible()) {
                    Dimension d = PhotoViewerJFrame.this.getSize();
                    Insets insets = PhotoViewerJFrame.this.getInsets();
                    int newHeight = d.height - (insets.top + insets.bottom);
                    if (PhotoViewerJFrame.this.mb != null) {
                        newHeight -= PhotoViewerJFrame.this.mb.getHeight();
                    }
                    if (PhotoViewerJFrame.this.cmdPanel != null) {
                        newHeight -= PhotoViewerJFrame.this.cmdPanel.getHeight();
                    }
                    int newWidth = d.width - (insets.right + insets.left);
                    if (newHeight != PhotoViewerJFrame.this.height || newWidth != PhotoViewerJFrame.this.width) {
                        PhotoViewerJFrame.this.height = newHeight;
                        PhotoViewerJFrame.this.width = newWidth;
                        PhotoViewerJFrame.this.photoViewer.resizeImage(PhotoViewerJFrame.this.width, PhotoViewerJFrame.this.height);
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PhotoViewerJFrame.this.done();
            }
        });
    }

    public void setFrameSize() {
        if (this.photoViewer != null) {
            this.pack();
            Insets insets = this.getInsets();
            int height = this.photoViewer.getHeight() + insets.top + insets.bottom;
            JMenuBar mb = this.getJMenuBar();
            if (mb != null) {
                height += mb.getHeight();
            }
            if (this.cmdPanel != null) {
                height += this.cmdPanel.getHeight();
            }
            int width = this.photoViewer.getWidth() + insets.left + insets.right;
            this.setSize(width, height);
            this.invalidate();
            this.validate();
        }
    }

    protected void setPhotoViewerInfo(PhotoViewerInfo photoViewerInfo) {
        this._photoViewerInfo = photoViewerInfo;
        this._imageTitle = this._photoViewerInfo.name;
        if (photoViewerInfo.xSize != 1.0 || photoViewerInfo.ySize != 1.0) {
            this.photoViewer.setImageSize(photoViewerInfo.xSize, photoViewerInfo.ySize);
        }
        if (photoViewerInfo.refreshInterval > 0.0) {
            this.photoViewer.showTime(true);
            this.photoViewer.addObserver(this);
        }
        this.status = this.photoViewer.init(this, photoViewerInfo.url, photoViewerInfo.bufferedImage, photoViewerInfo.refreshInterval, photoViewerInfo.fade);
        this.setFrameSize();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this.cmdPanel != null) {
            try {
                this.cmdPanel.revalidate();
                this.cmdPanel.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addMenu() {
        this.mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                PhotoViewerJFrame.this.photoViewer.setPaused(true);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                PhotoViewerJFrame.this.photoViewer.setPaused(PhotoViewerJFrame.this._paused);
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                PhotoViewerJFrame.this.photoViewer.setPaused(PhotoViewerJFrame.this._paused);
            }
        });
        this.mb.add(menu);
        JMenuItem menuItem = new JMenuItem("Pause");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean paused = !PhotoViewerJFrame.this._paused;
                PhotoViewerJFrame.this.setPaused(paused);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.photoViewer.setPaused(true);
                PhotoViewerJFrame.this.saveImage();
                PhotoViewerJFrame.this.photoViewer.setPaused(PhotoViewerJFrame.this._paused);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Record...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.recordImage();
            }
        });
        menu.add(menuItem);
        this._sizeGroup = new ButtonGroup();
        JMenu resizeMenu = new JMenu("Resize");
        this._defaultSizeMenu = new JRadioButtonMenuItem("Defualt");
        this._defaultSizeMenu.setSelected(true);
        this._defaultSizeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.resize(0);
            }
        });
        this._sizeGroup.add(this._defaultSizeMenu);
        resizeMenu.add(this._defaultSizeMenu);
        this._size1Menu = new JRadioButtonMenuItem("1.25");
        this._size1Menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.resize(1);
            }
        });
        this._sizeGroup.add(this._size1Menu);
        resizeMenu.add(this._size1Menu);
        this._size2Menu = new JRadioButtonMenuItem("1.00");
        this._size2Menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.resize(2);
            }
        });
        this._sizeGroup.add(this._size2Menu);
        resizeMenu.add(this._size2Menu);
        this._size3Menu = new JRadioButtonMenuItem(" .75");
        this._size3Menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.resize(3);
            }
        });
        this._sizeGroup.add(this._size3Menu);
        resizeMenu.add(this._size3Menu);
        this._size4Menu = new JRadioButtonMenuItem(" .50");
        this._size4Menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.resize(4);
            }
        });
        this._sizeGroup.add(this._size4Menu);
        resizeMenu.add(this._size4Menu);
        this._size5Menu = new JRadioButtonMenuItem(" .25");
        this._size5Menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.resize(5);
            }
        });
        this._sizeGroup.add(this._size5Menu);
        resizeMenu.add(this._size5Menu);
        menu.add(resizeMenu);
        menu.addSeparator();
        menuItem = new JMenuItem("Close");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerJFrame.this.done();
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(this.mb);
    }

    public void setPaused(boolean paused) {
        this._paused = paused;
        this.photoViewer.setPaused(this._paused);
        this._pausedTitle = this._paused ? "   Paused" : "";
        this.setTitle(this._imageTitle + this._pausedTitle);
    }

    public void saveImage() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String picturedirectory = preferences.get("picturedirectory", "");
        JFileChooser chooser = picturedirectory.length() > 0 ? new JFileChooser(picturedirectory) : new JFileChooser();
        chooser.setFileFilter((FileFilter)new RMAFilenameFilter("jpg", "*.jpg"));
        chooser.showSaveDialog(null);
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        File curDir = chooser.getCurrentDirectory();
        preferences.put("configdirectory", curDir.getAbsolutePath());
        Object output = file.getAbsolutePath();
        if (!((String)output).toLowerCase().endsWith(".jpg")) {
            output = (String)output + ".jpg";
        }
        this.photoViewer.resizeAndWrite((String)output, 100, -1.0, -1.0);
    }

    public void setExitOnClose(boolean exitOnClose) {
        this._exitOnClose = exitOnClose;
    }

    public PhotoViewer getPhotoViewer() {
        return this.photoViewer;
    }

    public void addObserver(Observer o) {
        this.photoViewer.addObserver(o);
    }

    public void removeObserver(Observer o) {
        this.photoViewer.removeObserver(o);
    }

    public Dimension getPhotoSize() {
        Dimension d = new Dimension();
        d.setSize(this.photoViewer.getWidth(), this.photoViewer.getHeight());
        return d;
    }

    public void done() {
        if (this.photoViewer != null) {
            this.photoViewer.stop();
        }
        this.photoViewer.done();
        if (this._exitOnClose) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    protected void resize(int fractionNumber) {
        if (fractionNumber == 0) {
            this.photoViewer.setImageSize(this._photoViewerInfo.xSize, this._photoViewerInfo.ySize);
        } else if (fractionNumber == 1) {
            this.photoViewer.setImageSize(1.25, 1.25);
        } else if (fractionNumber == 2) {
            this.photoViewer.setImageSize(1.0, 1.0);
        } else if (fractionNumber == 3) {
            this.photoViewer.setImageSize(0.75, 0.75);
        } else if (fractionNumber == 4) {
            this.photoViewer.setImageSize(0.5, 0.5);
        } else if (fractionNumber == 5) {
            this.photoViewer.setImageSize(0.25, 0.25);
        }
        this.photoViewer.scaleImage(false);
        this.setFrameSize();
    }

    protected void getNextImage() {
        if (this.photoViewer.getObserver() != null) {
            ActionEvent event = new ActionEvent(this, 1001, "nextImage");
            this.photoViewer.getObserver().notifyObservers((Object)event);
        }
    }

    public void addNextImage(PhotoViewerInfo nextImage, boolean moreImages) {
        this._currentImage = nextImage;
        this._moreImages = moreImages;
    }

    public void nextImage() {
        if (this._currentImage == null) {
            System.out.println("WAIT");
            this.getNextImage();
            if (this._currentImage == null) {
                System.out.println("Error");
                return;
            }
        }
        this._imageTitle = this._currentImage.name;
        this.setTitle(this._currentImage.name + this._pausedTitle);
        Dimension d = this.getPhotoSize();
        this._currentImage.xSize = d.getWidth();
        this._currentImage.ySize = d.getHeight();
        this.setPhotoViewerInfo(this._currentImage);
        if (!this._moreImages) {
            if (this._nextButton != null) {
                this._nextButton.setEnabled(false);
            }
        } else {
            this.getNextImage();
        }
    }

    protected void recordImage() {
        if (this._recording) {
            this._recording = false;
            int numb = this.photoViewer.setRecording("", this._recording);
            JOptionPane.showMessageDialog(null, "Recording stopped.");
            return;
        }
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String picturedirectory = preferences.get("picturedirectory", "");
        JFileChooser chooser = picturedirectory.length() > 0 ? new JFileChooser(picturedirectory) : new JFileChooser();
        chooser.setDialogTitle("Enter directory to save in");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.showSaveDialog(null);
        File dir = chooser.getSelectedFile();
        if (dir == null) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
        preferences.put("picturedirectory", dir.getAbsolutePath());
        this._recording = true;
        String outdir = dir.getAbsolutePath() + "/";
        this.photoViewer.setRecording(outdir, this._recording);
        JOptionPane.showMessageDialog(null, "Recording to directory " + outdir);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this._photoViewerInfo.refreshInterval > 0.0) {
            if (arg instanceof ActionEvent) {
                ActionEvent event = (ActionEvent)arg;
                String eventName = event.getActionCommand();
                if (eventName.compareTo("imageUpdated") == 0) {
                    this._numberReadErrors = 0;
                } else if (eventName.compareTo("errorGetImage") == 0) {
                    ++this._numberReadErrors;
                }
            }
            HecTime time = this.photoViewer.getLastReadTime();
            StringBuffer title = new StringBuffer();
            title.append(this._photoViewerInfo.name);
            title.append(": ");
            title.append(time.toString(-1));
            this._imageTitle = title.toString();
            title.append(this._pausedTitle);
            if (this._numberReadErrors > 3) {
                title.append("   Stalled");
            }
            this.setTitle(title.toString());
        }
    }
}

