/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.util;

import hec.dataui.tx.util.PhotoViewer;
import hec.dataui.tx.util.ViewerBabySitter;
import hec.util.PhotoViewerInfo;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import rma.swing.ButtonCmdPanel;

public class PhotoViewerMultipleFrame
extends JFrame
implements Observer {
    final Vector<PhotoViewer> _photoViewerScreens = new Vector(9);
    protected PhotoViewerInfo _photoViewerInfo;
    protected boolean _exitOnClose = true;
    protected PhotoViewerInfo _currentImage = null;
    protected boolean _moreImages = true;
    protected JButton _nextButton = null;
    protected boolean _paused = false;
    protected int _numberReadErrors = 0;
    protected JMenuBar mb = null;
    protected int _numberScreens;
    protected boolean _showTimes = true;
    protected boolean _sleeping = false;
    protected ButtonGroup _sizeGroup;
    protected String _pausedTitle = "";
    protected String _imageTitle = "";
    protected ButtonCmdPanel cmdPanel = null;
    public int height = 0;
    public int width = 0;
    public int status = 0;
    protected Thread sitterThread = null;
    protected ViewerBabySitter babySit = null;

    public PhotoViewerMultipleFrame(Vector<PhotoViewerInfo> photoViewerInfo) {
        if (photoViewerInfo.size() <= 4) {
            this._numberScreens = 4;
            this.getContentPane().setLayout(new GridLayout(2, 2));
        } else if (photoViewerInfo.size() <= 6) {
            this._numberScreens = 6;
            this.getContentPane().setLayout(new GridLayout(3, 2));
        } else if (photoViewerInfo.size() <= 9) {
            this._numberScreens = 9;
            this.getContentPane().setLayout(new GridLayout(3, 3));
        } else if (photoViewerInfo.size() <= 12) {
            this._numberScreens = 12;
            this.getContentPane().setLayout(new GridLayout(3, 4));
        } else {
            this._numberScreens = 16;
            this.getContentPane().setLayout(new GridLayout(4, 4));
        }
        this.addMenu();
        this.init(photoViewerInfo);
        this.addListeners();
        this.setExtendedState(6);
    }

    protected void init(Vector<PhotoViewerInfo> photoViewerInfo) {
        int i;
        for (i = 0; i < photoViewerInfo.size(); ++i) {
            PhotoViewerInfo info = photoViewerInfo.get(i);
            PhotoViewer pv = new PhotoViewer(null, info);
            pv.setPaused(true);
            pv.showTime(true);
            this._photoViewerScreens.add(pv);
            this.getContentPane().add(pv);
        }
        for (i = 0; i < this._photoViewerScreens.size(); ++i) {
            PhotoViewer pv = this._photoViewerScreens.get(i);
            pv.setPaused(false);
        }
        this.babySit = new ViewerBabySitter(this._photoViewerScreens);
        this.sitterThread = new Thread(this.babySit);
        this.sitterThread.start();
    }

    protected void addListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                block5: {
                    Dimension d;
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    if (!PhotoViewerMultipleFrame.this.isVisible()) break block5;
                                    d = PhotoViewerMultipleFrame.this.getSize();
                                    if (PhotoViewerMultipleFrame.this._numberScreens != 4) break block6;
                                    Dimension d3 = new Dimension(d.width / 2, d.height / 2);
                                    for (int i = 0; i < PhotoViewerMultipleFrame.this._photoViewerScreens.size(); ++i) {
                                        PhotoViewer pv = PhotoViewerMultipleFrame.this._photoViewerScreens.get(i);
                                        pv.sizeImage(d3.width, d3.height);
                                    }
                                    break block5;
                                }
                                if (PhotoViewerMultipleFrame.this._numberScreens != 6) break block7;
                                Dimension d3 = new Dimension(d.width / 2, d.height / 3);
                                for (int i = 0; i < PhotoViewerMultipleFrame.this._photoViewerScreens.size(); ++i) {
                                    PhotoViewer pv = PhotoViewerMultipleFrame.this._photoViewerScreens.get(i);
                                    pv.sizeImage(d3.width, d3.height);
                                }
                                break block5;
                            }
                            if (PhotoViewerMultipleFrame.this._numberScreens != 9) break block8;
                            Dimension d3 = new Dimension(d.width / 3, d.height / 3);
                            for (int i = 0; i < PhotoViewerMultipleFrame.this._photoViewerScreens.size(); ++i) {
                                PhotoViewer pv = PhotoViewerMultipleFrame.this._photoViewerScreens.get(i);
                                pv.sizeImage(d3.width, d3.height);
                            }
                            break block5;
                        }
                        if (PhotoViewerMultipleFrame.this._numberScreens != 12) break block9;
                        Dimension d3 = new Dimension(d.width / 4, d.height / 3);
                        for (int i = 0; i < PhotoViewerMultipleFrame.this._photoViewerScreens.size(); ++i) {
                            PhotoViewer pv = PhotoViewerMultipleFrame.this._photoViewerScreens.get(i);
                            pv.sizeImage(d3.width, d3.height);
                        }
                        break block5;
                    }
                    if (PhotoViewerMultipleFrame.this._numberScreens != 16) break block5;
                    Dimension d3 = new Dimension(d.width / 4, d.height / 4);
                    for (int i = 0; i < PhotoViewerMultipleFrame.this._photoViewerScreens.size(); ++i) {
                        PhotoViewer pv = PhotoViewerMultipleFrame.this._photoViewerScreens.get(i);
                        pv.sizeImage(d3.width, d3.height);
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PhotoViewerMultipleFrame.this.done();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                PhotoViewerMultipleFrame.this.timeToWake();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                PhotoViewerMultipleFrame.this.timeToSleep();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                PhotoViewerMultipleFrame.this.timeToSleep();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                PhotoViewerMultipleFrame.this.timeToWake();
            }
        });
    }

    protected void timeToSleep() {
        if (this.babySit != null) {
            this.babySit.goToSleep();
            this.babySit = null;
            this.sitterThread.stop();
        }
        for (int i = 0; i < this._photoViewerScreens.size(); ++i) {
            PhotoViewer pv = this._photoViewerScreens.get(i);
            pv.setPaused(true);
        }
        this._sleeping = true;
        System.out.println("Sleeping");
    }

    protected void timeToWake() {
        for (int i = 0; i < this._photoViewerScreens.size(); ++i) {
            PhotoViewer pv = this._photoViewerScreens.get(i);
            pv.setPaused(false);
        }
        this._sleeping = false;
        if (this.babySit == null) {
            this.babySit = new ViewerBabySitter(this._photoViewerScreens);
            this.sitterThread = new Thread(this.babySit);
            this.sitterThread.start();
        }
        System.out.println("Okay, okay... I'm awake now!");
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this.cmdPanel != null) {
            this.cmdPanel.repaint();
        }
    }

    public void addMenu() {
        this.mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                PhotoViewerMultipleFrame.this.setPaused(true);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                PhotoViewerMultipleFrame.this.setPaused(PhotoViewerMultipleFrame.this._paused);
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                PhotoViewerMultipleFrame.this.setPaused(PhotoViewerMultipleFrame.this._paused);
            }
        });
        this.mb.add(menu);
        JMenuItem menuItem = new JMenuItem("Pause");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean paused = !PhotoViewerMultipleFrame.this._paused;
                PhotoViewerMultipleFrame.this.setPaused(paused);
                PhotoViewerMultipleFrame.this._paused = paused;
                PhotoViewerMultipleFrame.this.setTitle();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Show Times");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showTimes = !PhotoViewerMultipleFrame.this._showTimes;
                PhotoViewerMultipleFrame.this.setShowTimes(showTimes);
                PhotoViewerMultipleFrame.this._showTimes = showTimes;
                PhotoViewerMultipleFrame.this.setTitle();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Close");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoViewerMultipleFrame.this.done();
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(this.mb);
    }

    public void setShowTimes(boolean showTimes) {
        for (int i = 0; i < this._photoViewerScreens.size(); ++i) {
            PhotoViewer pv = this._photoViewerScreens.get(i);
            pv.showTime(showTimes);
        }
    }

    public void setPaused(boolean paused) {
        for (int i = 0; i < this._photoViewerScreens.size(); ++i) {
            PhotoViewer pv = this._photoViewerScreens.get(i);
            pv.setPaused(paused);
        }
    }

    protected void setTitle() {
        this._pausedTitle = this._paused ? "   Paused" : "";
        this.setTitle(this._imageTitle + this._pausedTitle);
    }

    public void setExitOnClose(boolean exitOnClose) {
        this._exitOnClose = exitOnClose;
    }

    public void done() {
        for (int i = 0; i < this._photoViewerScreens.size(); ++i) {
            PhotoViewer pv = this._photoViewerScreens.get(i);
            pv.done();
        }
        if (this._exitOnClose) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
    }
}

