/*
 * Decompiled with CFR 0.152.
 */
package hec.db;

import hec.db.DataAccessFactory;
import hec.db.DataAccessFactoryLoader;
import hec.db.DbConnection;
import hec.db.DbPluginNotFoundException;
import hec.db.InvalidDbConnectionException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

public final class ConnectionFactory {
    private static final Map<DbConnection, DataAccessFactory> DATA_ACCESS_FACTORIES = new ConcurrentHashMap<DbConnection, DataAccessFactory>();

    private ConnectionFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static DataAccessFactory newInstance(DbConnection dbConnection) throws DbPluginNotFoundException {
        return ConnectionFactory.newInstance(dbConnection, null);
    }

    public static DataAccessFactory newInstance(DbConnection dbConnection, Object additionalData) throws DbPluginNotFoundException {
        DataAccessFactory dataAccessFactory;
        if (dbConnection.isValid() && (dataAccessFactory = DATA_ACCESS_FACTORIES.get(dbConnection)) != null) {
            return dataAccessFactory;
        }
        dataAccessFactory = ConnectionFactory.getDataAccessFactoryFromService(dbConnection, additionalData);
        if (dataAccessFactory == null) {
            throw new DbPluginNotFoundException(dbConnection.getPluginKey());
        }
        return dataAccessFactory;
    }

    private static DataAccessFactory getDataAccessFactoryFromService(DbConnection dbConnection, Object extraMetaData) throws DbPluginNotFoundException {
        String pluginKey = dbConnection.getPluginKey();
        Lookup lookup = Lookups.forPath((String)pluginKey);
        DataAccessFactoryLoader dataAccessFactoryLoader = (DataAccessFactoryLoader)lookup.lookup(DataAccessFactoryLoader.class);
        if (dataAccessFactoryLoader == null) {
            throw new DbPluginNotFoundException("Could not find the DataAccessFactoryLoader service implementation.", pluginKey);
        }
        dataAccessFactoryLoader.loadFactory(dbConnection, extraMetaData);
        return DATA_ACCESS_FACTORIES.get(dbConnection);
    }

    public static DataAccessFactory getInstance(DbConnection dbConnection) {
        DataAccessFactory dataAccessFactory = null;
        if (dbConnection.isValid()) {
            dataAccessFactory = DATA_ACCESS_FACTORIES.get(dbConnection);
        }
        return dataAccessFactory;
    }

    public static void setInstance(DbConnection dbConnection, DataAccessFactory factory) {
        DATA_ACCESS_FACTORIES.put(dbConnection, factory);
    }

    public static void updateInstance(DbConnection dbConnection, DataAccessFactory dataAccessFactory) throws InvalidDbConnectionException {
        if (!dbConnection.isValid()) {
            throw new InvalidDbConnectionException(dbConnection);
        }
        Set<Map.Entry<DbConnection, DataAccessFactory>> entrySet = DATA_ACCESS_FACTORIES.entrySet();
        for (Map.Entry<DbConnection, DataAccessFactory> entry : entrySet) {
            if (!entry.getValue().equals(dataAccessFactory)) continue;
            DATA_ACCESS_FACTORIES.remove(entry.getKey());
            break;
        }
        ConnectionFactory.setInstance(dbConnection, dataAccessFactory);
    }

    public static DataAccessFactory removeInstance(DbConnection dbConnection) throws InvalidDbConnectionException {
        if (!dbConnection.isValid()) {
            throw new InvalidDbConnectionException(dbConnection);
        }
        return DATA_ACCESS_FACTORIES.remove(dbConnection);
    }

    public static Collection<DataAccessFactory> getInstances() {
        Collection<DataAccessFactory> factoryCollection = DATA_ACCESS_FACTORIES.values();
        return Collections.unmodifiableCollection(factoryCollection);
    }

    public static void shutdown() {
        Collection<DataAccessFactory> instances = ConnectionFactory.getInstances();
        for (DataAccessFactory dataAccessFactory : instances) {
            dataAccessFactory.close();
        }
    }
}

