/*
 * Decompiled with CFR 0.152.
 */
package hec.db;

import hec.db.DataAccessObject;
import hec.db.DbConnection;
import hec.db.DbConnectionException;
import hec.db.DbIoException;
import hec.db.StatelessDao;
import hec.db.cwms.DataAccessKey;
import java.sql.Connection;
import java.sql.Savepoint;

public interface DataAccessFactory {
    public String getOfficeId() throws DbConnectionException, DbIoException;

    public String getOfficeName() throws DbConnectionException, DbIoException;

    public boolean isConnected();

    public void connect(String var1) throws DbConnectionException;

    default public void connect() throws DbConnectionException {
        this.connect(null);
    }

    public void close();

    public DbConnection getDbConnection();

    public <T extends StatelessDao> T getDao(Class<T> var1);

    public <T extends DataAccessObject> T getDao(Class<T> var1, Connection var2) throws DbConnectionException;

    @Deprecated
    public Connection getPooledConnection() throws DbConnectionException;

    @Deprecated
    public Connection getPooledConnection(String var1) throws DbConnectionException;

    @Deprecated
    public void closeConnection(Connection var1, boolean var2);

    @Deprecated
    public void closeConnection(Connection var1, TransactionControl var2, Savepoint var3);

    public DataAccessKey getDataAccessKey(String var1) throws DbConnectionException;

    public void closeResource(DataAccessKey var1, boolean var2);

    public void closeResource(DataAccessKey var1, TransactionControl var2, Savepoint var3);

    public String getDataSourceUrl() throws DbConnectionException;

    public boolean isWritable();

    public void commitResource(DataAccessKey var1) throws DbIoException;

    public static enum TransactionControl {
        Commit,
        NoCommit,
        Rollback;

    }
}

