/*
 * Decompiled with CFR 0.152.
 */
package hec.db;

import java.util.Objects;
import java.util.Optional;

public class DbConnection
implements Cloneable {
    public static final String DB_PLUGIN = "db.plugin";
    public static final String DB_RMI_DAEMON = "db-rmi-daemon";
    public static final String DB_RMI_CLIENT = "db-rmi-client";
    public static final String DB_ORACLE = "db-oracle";
    public static final String DB_RADAR = "db-radar";
    private static boolean _sAssignDefaultUserKey = false;
    private final String _pluginKey;
    private String _securityClassName;
    private boolean _showSecurityLogin;
    private boolean _alwaysShowSecurityLogin;
    private String _databaseUrl = null;
    private String _userName;
    private String _sessionOfficeId;
    private String _sessionKey;
    private String _friendlyName;
    private boolean _singleServerMode;
    private boolean _assignDefaultUserKey = _sAssignDefaultUserKey;

    public DbConnection(String pluginKey) {
        this._pluginKey = pluginKey;
    }

    public static void initDefaultUserKey(boolean bUserKey) {
        _sAssignDefaultUserKey = bUserKey;
    }

    public void setSingleServerMode(boolean singleServerMode) {
        this._singleServerMode = singleServerMode;
    }

    public boolean isSingleServerMode() {
        return this._singleServerMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbConnection that = (DbConnection)o;
        return (this.getPluginKey() == null || that.getPluginKey() == null ? Objects.equals(this.getPluginKey(), that.getPluginKey()) : this.getPluginKey().equalsIgnoreCase(that.getPluginKey())) && (this.getDatabaseUrl() == null || that.getDatabaseUrl() == null ? Objects.equals(this.getDatabaseUrl(), that.getDatabaseUrl()) : this.getDatabaseUrl().equalsIgnoreCase(that.getDatabaseUrl())) && (this.getSessionOfficeId() == null || that.getSessionOfficeId() == null ? Objects.equals(this.getSessionOfficeId(), that.getSessionOfficeId()) : this.getSessionOfficeId().equalsIgnoreCase(that.getSessionOfficeId()));
    }

    public int hashCode() {
        return Objects.hash(this.getPluginKey() == null ? Integer.valueOf(0) : this.getPluginKey().toLowerCase(), this.getDatabaseUrl() == null ? Integer.valueOf(0) : this.getDatabaseUrl().toLowerCase(), this.getSessionOfficeId() == null ? Integer.valueOf(0) : this.getSessionOfficeId().toLowerCase());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setDatabaseUrl(String databaseUrl) {
        this._databaseUrl = databaseUrl;
    }

    public String getDatabaseUrl() {
        return this._databaseUrl;
    }

    public String getPluginKey() {
        return this._pluginKey;
    }

    public void setSecurityClassName(String securityClassName) {
        this._securityClassName = securityClassName;
    }

    public String getSecurityClassName() {
        return this._securityClassName;
    }

    public void setShowSecurityLogin(boolean b) {
        this._showSecurityLogin = b;
    }

    public boolean getShowSecurityLogin() {
        return this._showSecurityLogin;
    }

    public void setAlwaysShowSecurityLogin(boolean b) {
        this._alwaysShowSecurityLogin = b;
    }

    public boolean getAlwaysShowSecurityLogin() {
        return this._alwaysShowSecurityLogin;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public String getUserName() {
        return this._userName;
    }

    public boolean isValid() {
        return this._pluginKey != null && this._pluginKey.length() > 0 && this._databaseUrl != null && this._databaseUrl.length() > 0;
    }

    public void setAssignDefaultUserKey(boolean tf) {
        this._assignDefaultUserKey = tf;
    }

    public boolean getAssignDefaultUserKey() {
        return this._assignDefaultUserKey;
    }

    public String getSessionOfficeId() {
        return this._sessionOfficeId;
    }

    public void setSessionOfficeId(String officeId) {
        this._sessionOfficeId = officeId;
    }

    public final void setSessionKey(String sessionKey) {
        this._sessionKey = sessionKey;
    }

    public final String getSessionKey() {
        return this._sessionKey;
    }

    public final Optional<String> getFriendlyName() {
        return Optional.ofNullable(this._friendlyName);
    }

    public void setFriendlyName(String friendlyName) {
        this._friendlyName = friendlyName;
    }
}

