/*
 * Decompiled with CFR 0.152.
 */
package hec.db;

import hec.db.DbConnection;
import hec.db.DbException;

public class InvalidDbConnectionException
extends DbException {
    private static final long serialVersionUID = 4683472816094334039L;
    private final DbConnection _dbConnection;

    public InvalidDbConnectionException(DbConnection dbConnection) {
        super(dbConnection.getPluginKey());
        this._dbConnection = dbConnection;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this._dbConnection.getDatabaseUrl() == null) {
            sb.append("Database url is undefined for plugin, ");
            sb.append(this._dbConnection.getPluginKey());
            sb.append(".");
        } else {
            sb.append("Database url, ");
            sb.append(this._dbConnection.getDatabaseUrl());
            sb.append(", is invalid for plugin, ");
            sb.append(this._dbConnection.getPluginKey());
            sb.append(".");
        }
        return sb.toString();
    }
}

