/*
 * Decompiled with CFR 0.152.
 */
package hec.db.cwms;

import com.google.common.flogger.FluentLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import rma.util.RMAIO;

public final class DbiProperties {
    private static int MESSAGE_LEVEL = 0;
    public static final int MESSAGE_LEVEL_OFF = 0;
    public static final int MESSAGE_LEVEL_SEVERE = 1;
    public static final int MESSAGE_LEVEL_INFO = 2;
    public static final int MESSAGE_LEVEL_DEBUG = 3;
    public static final int MESSAGE_LEVEL_FINE = 4;
    public static final int MESSAGE_LEVEL_FINER = 5;
    public static boolean TRACE_ON = false;
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String DBI_FILENAME = System.getProperty("dbi.properties.path", RMAIO.getPropertyFilePath((String)"dbi.properties"));
    private static boolean loaded = false;

    private DbiProperties() {
        throw new AssertionError((Object)"Utility class");
    }

    public static void load() {
        if (!loaded) {
            Properties prop = System.getProperties();
            DbiProperties.loadFromFile(prop);
            System.setProperties(prop);
            loaded = true;
            MESSAGE_LEVEL = DbiProperties.getMessageLevel();
            TRACE_ON = Boolean.parseBoolean(System.getProperty("dbi.trace", "false"));
        }
    }

    public static int getMessageLevel() {
        MESSAGE_LEVEL = RMAIO.parseInt((String)System.getProperty("cwms.dbi.message_level", Integer.toString(0)));
        return MESSAGE_LEVEL;
    }

    public static void setMessageLevel(int messageLevel) {
        if (messageLevel < 0) {
            messageLevel = 0;
        }
        System.setProperty("cwms.dbi.message_level", Integer.toString(messageLevel));
        MESSAGE_LEVEL = messageLevel;
    }

    public static String getDbiPropertiesFilePath() {
        return DBI_FILENAME;
    }

    private static void loadFromFile(Properties prop) {
        try {
            Path path = Paths.get(DBI_FILENAME, new String[0]);
            ((FluentLogger.Api)LOGGER.atInfo()).log("Loading DbiProperties from " + path.toAbsolutePath());
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                prop.load(bufferedReader);
            }
        }
        catch (IOException | RuntimeException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Unable read access to DbiProperties path: " + DbiProperties.getDbiPropertiesFilePath());
        }
    }

    public static String getProperty(String key) {
        if (!loaded) {
            DbiProperties.load();
        }
        return System.getProperty(key);
    }

    public static String getProperty(String key, String defaultVal) {
        if (!loaded) {
            DbiProperties.load();
        }
        return System.getProperty(key, defaultVal);
    }
}

