/*
 * Decompiled with CFR 0.152.
 */
package hec.db.cwms;

import hec.data.meta.CatalogTemplate;
import hec.data.meta.OrderBy;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.List;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;
import usace.cwms.db.dao.util.OracleTypeMap;

public final class TimeSeriesIdentifierCatalogQuery {
    public static final String LOCAL_REGULAR_TIMEZONE = "lrts_timezone";
    public static final int TIMESERIES_ID_IDX = 2;
    public static final int LOCAL_REGULAR_TIMEZONE_IDX = 4;
    public static final int USER_PRIVILEGE_RW = 6;
    private static final String CATALOG = "cwms_cat.cat_ts_desc";
    private static final String OFFICE_ID = "db_office_id";
    private static final String BASE_LOCATION_ID = "base_location_id";
    private static final String TIMESERIES_ID = "cwms_ts_id";
    private static final String INTERVAL_UTC_OFFSET = "interval_utc_offset";
    private static final String ACTIVE_FLAG = "ts_active_flag";
    private static final String USER_PRIVILEGES = "user_privileges";
    private static final String TIMESERIES_ID_HEADER = "Time Series ID";
    private static final int OFFICE_ID_IDX = 0;
    private static final int USER_PRIVILEGE_R = 2;
    private static final int INTERVAL_UTC_OFFSET_IDX = 3;
    private static final int ACTIVE_FLAG_IDX = 5;
    private static final int USER_PRIVILEGES_IDX = 6;
    private static final String[] COLUMNS = new String[]{"db_office_id", "base_location_id", "cwms_ts_id", "interval_utc_offset", "lrts_timezone", "ts_active_flag", "user_privileges"};
    private static final String[] COLUMN_HEADERS = new String[]{"", "", "Time Series ID"};
    private static final String[] ORDER_BY_STRING_ARRAY = new String[]{"base_location_id", "cwms_ts_id", "interval_utc_offset"};
    private static final OrderBy ORDER_BY = new OrderBy(ORDER_BY_STRING_ARRAY);
    private static final boolean[] VISIBLE_COLUMNS = new boolean[]{false, false, true, false, false, false, false};

    private TimeSeriesIdentifierCatalogQuery() {
        throw new AssertionError((Object)"Utility class");
    }

    public static CatalogTemplate getTimeSeriesIdentifierCatalogTemplate() {
        try {
            return new CatalogTemplate(CATALOG, COLUMNS, COLUMN_HEADERS, VISIBLE_COLUMNS, false, null, ORDER_BY);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error producing TimeSeriesIdentifier catalog template", e);
        }
    }

    public static TimeSeriesIdentifier convertToIdentifier(List<String> list) throws DataSetIllegalArgumentException {
        int minUtcIntervalOffset;
        if (list.size() != COLUMNS.length) {
            throw new DataSetIllegalArgumentException("Not enough column metadata to build a valid TimeSeriesIdentifier");
        }
        String officeId = list.get(0);
        String strDesc = list.get(2);
        String strMinUtcIntervalOffset = list.get(3);
        String strActive = list.get(5);
        String strUserPrivileges = list.get(6);
        int secUtcIntervalOffset = minUtcIntervalOffset = (int)Math.round(Double.parseDouble(strMinUtcIntervalOffset));
        if (IntervalOffset.isDefined((int)minUtcIntervalOffset)) {
            secUtcIntervalOffset = minUtcIntervalOffset * 60;
        }
        IntervalOffset intervalOfset = IntervalOffset.fromSeconds((int)secUtcIntervalOffset);
        ZoneId zoneId = OracleTypeMap.toZoneId((String)list.get(4), (String)strDesc);
        boolean active = Boolean.parseBoolean(strActive);
        int privilege = Integer.parseInt(strUserPrivileges);
        return TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(officeId), (String)strDesc, (IntervalOffset)intervalOfset, (ZoneId)zoneId, (boolean)active, (int)privilege);
    }
}

