/*
 * Decompiled with CFR 0.152.
 */
package hec.db.cwms;

import com.google.common.flogger.FluentLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import rma.util.RMAIO;

public final class WcdsProperties {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static int WCDS_DEBUG = 0;
    private static boolean CONVERT_UNIT_AND_TZ = false;
    private static final String WCDS_FILENAME = RMAIO.getPropertyFilePath((String)"cwms.properties");
    private static boolean loaded = false;

    private WcdsProperties() {
        throw new AssertionError((Object)"Utility class");
    }

    public static int getWcdsDebug() {
        if (!loaded) {
            WcdsProperties.load();
        }
        return WCDS_DEBUG;
    }

    public static boolean convertUnitsAndTimeZone() {
        if (!loaded) {
            WcdsProperties.load();
        }
        return CONVERT_UNIT_AND_TZ;
    }

    public static void load() {
        if (!WcdsProperties.isLoaded()) {
            Properties prop = System.getProperties();
            WcdsProperties.loadFromFile(prop);
            System.setProperties(prop);
            loaded = true;
            WCDS_DEBUG = RMAIO.parseInt((String)System.getProperty("cwms.debug", "0"));
            CONVERT_UNIT_AND_TZ = Boolean.parseBoolean(System.getProperty("cwms.convert.unit.and.timezone", "true"));
        }
    }

    private static void loadFromFile(Properties prop) {
        block8: {
            try {
                File file = new File(WCDS_FILENAME);
                if (file.canRead()) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("Loading WcdsProperties from " + file.getAbsolutePath());
                    try (FileInputStream fis = new FileInputStream(file);){
                        prop.load(fis);
                        break block8;
                    }
                }
                ((FluentLogger.Api)LOGGER.atWarning()).log("No read access to WcdsProperties path: " + WCDS_FILENAME);
            }
            catch (IOException | RuntimeException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Unable read access to WcdsProperties path: " + WCDS_FILENAME);
            }
        }
    }

    public static String getProperty(String key) {
        if (!loaded) {
            WcdsProperties.load();
        }
        return System.getProperty(key);
    }

    public static String getProperty(String key, String defaultVal) {
        if (!loaded) {
            WcdsProperties.load();
        }
        return System.getProperty(key, defaultVal);
    }

    public static boolean isLoaded() {
        return loaded;
    }

    static {
        WcdsProperties.load();
    }
}

