/*
 * Decompiled with CFR 0.152.
 */
package hec.db.cwms.message;

import hec.db.DataAccessFactory;
import hec.db.DbIoException;
import hec.db.JmsDao;
import hec.db.cwms.CwmsJmsDao;
import hec.db.cwms.message.GenericMessageListener;
import hec.db.cwms.message.MessageClassProperties;
import hec.jms.GenericMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageListener;
import usace.cwms.db.dao.util.connection.CwmsDbConnectionProvider;

public final class MessageReceiver<M> {
    private static final Logger LOGGER = Logger.getLogger(MessageReceiver.class.getName());
    private final List<M> _messageTypes = new ArrayList<M>();
    private final CwmsJmsDao _jmsDao;
    private final CwmsDbConnectionProvider _cwmsDbConnectionProvider;
    private final Set<GenericMessageListener<M>> _messageListeners = new HashSet<GenericMessageListener<M>>();
    private final Map<Class<M>, MessageClassProperties> _messageClasses = new HashMap<Class<M>, MessageClassProperties>();
    private final Map<String, MessageListener> _queueMap = new HashMap<String, MessageListener>();
    private final Map<String, Object> _requiredMapValues = new HashMap<String, Object>();

    private MessageReceiver(CwmsJmsDao jmsDao, CwmsDbConnectionProvider cwmsDbConnectionProvider, List<Class<M>> messageClasses, Map<String, Object> requiredMapValues) {
        this._jmsDao = jmsDao;
        this._cwmsDbConnectionProvider = cwmsDbConnectionProvider;
        this._requiredMapValues.putAll(requiredMapValues);
        this.parseClasses(messageClasses);
    }

    public static <M extends GenericMessage> MessageReceiver<M> create(DataAccessFactory dataAccessFactory, Class<M> clazz) {
        return MessageReceiver.create(dataAccessFactory, Collections.singletonList(clazz), Collections.emptyMap());
    }

    public static <M extends GenericMessage> MessageReceiver<M> create(DataAccessFactory dataAccessFactory, List<Class<M>> messageClasses) {
        return MessageReceiver.create(dataAccessFactory, messageClasses, Collections.emptyMap());
    }

    public static <M extends GenericMessage> MessageReceiver<M> create(DataAccessFactory dataAccessFactory, Class<M> clazz, Map<String, Object> requiredMapValues) {
        return MessageReceiver.create(dataAccessFactory, Collections.singletonList(clazz), requiredMapValues);
    }

    public static <M extends GenericMessage> MessageReceiver<M> create(DataAccessFactory dataAccessFactory, List<Class<M>> messageClasses, Map<String, Object> requiredMapValues) {
        for (Class<M> clazz : messageClasses) {
            try {
                String className = clazz.getName();
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.FINER, "Error loading message type class for de-serializing AQ/JMS messages", e);
            }
        }
        CwmsJmsDao jmsDao = dataAccessFactory.getDao(CwmsJmsDao.class);
        return new MessageReceiver<M>(jmsDao, dataAccessFactory::getPooledConnection, messageClasses, requiredMapValues);
    }

    @Deprecated
    public static <M extends GenericMessage> MessageReceiver<M> create(JmsDao jmsDao, Class<M> clazz) {
        return MessageReceiver.create(jmsDao, Collections.singletonList(clazz), Collections.emptyMap());
    }

    @Deprecated
    public static <M extends GenericMessage> MessageReceiver<M> create(JmsDao jmsDao, List<Class<M>> messageClasses) {
        return MessageReceiver.create(jmsDao, messageClasses, Collections.emptyMap());
    }

    @Deprecated
    public static <M extends GenericMessage> MessageReceiver<M> create(JmsDao jmsDao, Class<M> clazz, Map<String, Object> requiredMapValues) {
        return MessageReceiver.create(jmsDao, Collections.singletonList(clazz), requiredMapValues);
    }

    @Deprecated
    public static <M extends GenericMessage> MessageReceiver<M> create(JmsDao jmsDao, List<Class<M>> messageClasses, Map<String, Object> requiredMapValues) {
        for (Class<M> clazz : messageClasses) {
            try {
                String className = clazz.getName();
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.FINER, "Error loading message type class for de-serializing AQ/JMS messages", e);
            }
        }
        return new MessageReceiver<M>(jmsDao.getCwmsJmsDao(), jmsDao, messageClasses, requiredMapValues);
    }

    public void setRequiredMapValues(Map<String, Object> requiredMapValues) {
        this._requiredMapValues.clear();
        this._requiredMapValues.putAll(requiredMapValues);
    }

    public Map<String, Object> getRequiredMapValues() {
        return this._requiredMapValues;
    }

    private void parseClasses(List<Class<M>> messageClasses) {
        for (Class<M> messageClass : messageClasses) {
            this._messageClasses.put(messageClass, this.createMessageClassProperties(messageClass));
        }
    }

    private MessageClassProperties createMessageClassProperties(Class<M> messageClass) {
        messageClass.getDeclaredMethods();
        String classType = GenericMessage.getClassType(messageClass);
        String classSubType = GenericMessage.getClassSubType(messageClass);
        Set requiredMapKeys = GenericMessage.getRequiredMapKeys(messageClass);
        return new MessageClassProperties(classType, classSubType, requiredMapKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGenericMessageListener(GenericMessageListener<M> listener) {
        Set<GenericMessageListener<M>> set = this._messageListeners;
        synchronized (set) {
            this._messageListeners.add(listener);
            this._messageListeners.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGenericMessageListener(GenericMessageListener<M> listener) {
        Set<GenericMessageListener<M>> set = this._messageListeners;
        synchronized (set) {
            this._messageListeners.remove(listener);
            this._messageListeners.notify();
        }
    }

    public void subscribeToQueue(String queueName) throws DbIoException {
        if (this._queueMap.containsKey(queueName)) {
            return;
        }
        MessageListener messageListener = message -> {
            if (!(message instanceof MapMessage)) {
                throw new UnsupportedOperationException("Only MapMessages are supported");
            }
            this.onMapMessage((MapMessage)message);
        };
        this._jmsDao.addMessageListener(this._cwmsDbConnectionProvider, queueName, messageListener);
        this._queueMap.put(queueName, messageListener);
    }

    public void unsubscribeFromQueue(String queueName) throws DbIoException {
        MessageListener messageListener = this._queueMap.get(queueName);
        if (messageListener == null) {
            return;
        }
        this._jmsDao.removeMessageListener(queueName, messageListener);
        this._queueMap.remove(queueName);
    }

    public void closeConnections() {
        this._jmsDao.closeSubscribers();
    }

    private M newMessage(MapMessage message) throws JMSException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        M encapsulatedMessage = null;
        for (Class<M> clazz : this._messageClasses.keySet()) {
            if (!this.verifyClassType(clazz, message) || !this.verifyClassSubType(clazz, message) || !this.verifyRequiredKeys(clazz, message) || !this.verifyRequiredValues(message)) continue;
            Class[] parameterTypes = new Class[]{MapMessage.class};
            Constructor<M> constructor = clazz.getConstructor(parameterTypes);
            encapsulatedMessage = constructor.newInstance(message);
            break;
        }
        return encapsulatedMessage;
    }

    private boolean verifyRequiredValues(MapMessage message) throws JMSException {
        if (this._requiredMapValues.isEmpty()) {
            return true;
        }
        Set<Map.Entry<String, Object>> entrySet = this._requiredMapValues.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            Object messageObject;
            String key = entry.getKey();
            if (key == null) continue;
            if (!message.itemExists(key)) {
                return false;
            }
            Object value = entry.getValue();
            if (value == null || !value.equals(messageObject = message.getObject(key))) continue;
            return true;
        }
        return false;
    }

    private boolean verifyRequiredKeys(Class<M> classType, MapMessage message) throws JMSException {
        MessageClassProperties messageClassProperties = this._messageClasses.get(classType);
        Set<String> requiredMapKeys = messageClassProperties.getRequiredMapKeys();
        if (requiredMapKeys == null || requiredMapKeys.isEmpty()) {
            return true;
        }
        for (String key : requiredMapKeys) {
            if (message.itemExists(key)) continue;
            return false;
        }
        return true;
    }

    private boolean verifyClassSubType(Class<M> classType, MapMessage message) throws JMSException {
        MessageClassProperties messageClassProperties = this._messageClasses.get(classType);
        String classSubType = messageClassProperties.getClassSubType();
        if (classSubType == null) {
            return true;
        }
        String messageSubType = message.getString("subtype");
        return classSubType.equals(messageSubType);
    }

    private boolean verifyClassType(Class<M> clazz, MapMessage message) throws JMSException {
        MessageClassProperties classProperties = this._messageClasses.get(clazz);
        String classType = classProperties.getClassType();
        if (classType == null) {
            return true;
        }
        String messageType = message.getString("type");
        return classType.equals(messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMapMessage(MapMessage message) {
        try {
            M encapsulatedMessage = this.newMessage(message);
            if (encapsulatedMessage == null) {
                return;
            }
            Collection<Object> collection = this._messageTypes;
            synchronized (collection) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    List<String> standardNames = Arrays.asList("millis", "type", "subtype", "reported", "start_time", "end_time", "last_processed");
                    List<String> timeNames = Arrays.asList("millis", "start_time", "end_time", "last_processed", "reported");
                    Calendar cal = Calendar.getInstance();
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    StringBuilder sb = new StringBuilder();
                    sb.append("New message being added to list:\n");
                    Enumeration mapNames = message.getMapNames();
                    TreeSet<String> sortedMapNames = new TreeSet<String>();
                    while (mapNames.hasMoreElements()) {
                        sortedMapNames.add((String)mapNames.nextElement());
                    }
                    for (String key : standardNames) {
                        if (!message.itemExists(key)) continue;
                        sb.append("\t").append(key).append(" = ").append(message.getObject(key).toString());
                        if (timeNames.contains(key)) {
                            cal.setTimeInMillis(message.getLong(key));
                            sb.append(" (").append(fmt.format(cal.getTime())).append(")");
                        }
                        sb.append("\n");
                    }
                    for (String key : sortedMapNames) {
                        if (standardNames.contains(key) || key.equals("body")) continue;
                        sb.append("\t").append(key).append(" = ").append(message.getObject(key).toString());
                        if (timeNames.contains(key)) {
                            cal.setTimeInMillis(message.getLong(key));
                            sb.append(" (").append(fmt.format(cal.getTime())).append(")");
                        }
                        sb.append("\n");
                    }
                    if (message.itemExists("body")) {
                        sb.append("\t").append("body:\n");
                        for (Iterator<String> iterator : message.getString("body").trim().split("\n")) {
                            sb.append("\t\t").append((String)((Object)iterator)).append("\n");
                        }
                    }
                    String msg = sb.toString();
                    LOGGER.log(Level.FINEST, msg);
                }
                this._messageTypes.add(encapsulatedMessage);
                this._messageTypes.notify();
            }
            collection = this._messageListeners;
            synchronized (collection) {
                for (GenericMessageListener<M> listener : this._messageListeners) {
                    try {
                        listener.onMessage(encapsulatedMessage);
                    }
                    catch (JMSException e) {
                        LOGGER.log(Level.FINEST, "Error parsing message.", e);
                    }
                    catch (ClassCastException | IllegalArgumentException | SecurityException e) {
                        LOGGER.log(Level.FINEST, "Error encapsulating message.", e);
                    }
                }
                this._messageListeners.notify();
            }
        }
        catch (JMSException e) {
            LOGGER.log(Level.FINEST, "Error parsing message.", e);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.log(Level.FINEST, "Error encapsulating message.", e);
        }
    }

    public void addMessageClass(Class<M> messageClass) {
        if (!this._messageClasses.containsKey(messageClass)) {
            this._messageClasses.put(messageClass, this.createMessageClassProperties(messageClass));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<M> getMessages() {
        ArrayList<M> dequeuedMessageList;
        List<M> list = this._messageTypes;
        synchronized (list) {
            if (!this._messageTypes.isEmpty()) {
                dequeuedMessageList = new ArrayList(this._messageTypes.size());
                dequeuedMessageList.addAll(this._messageTypes);
                this._messageTypes.clear();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Dequeue message list: ");
                    sb.append(dequeuedMessageList);
                    sb.append("\nRemaining message list: ");
                    sb.append(this._messageTypes);
                    String msg = sb.toString();
                    LOGGER.log(Level.FINEST, msg);
                }
            } else {
                dequeuedMessageList = new ArrayList<M>(0);
            }
            this._messageTypes.notify();
        }
        return dequeuedMessageList;
    }
}

