/*
 * Decompiled with CFR 0.152.
 */
package hec.db.util;

import java.util.Date;
import java.util.Properties;
import usace.metrics.services.AbstractMetric;
import usace.metrics.services.Timer;

public final class CwmsMetricsBuilder {
    public static final String CWMS_METRICS_PREFIX = "CWMS/Metrics/HecDbImpl";
    private final AbstractMetric _metric;
    private final Properties _properties = new Properties();

    private CwmsMetricsBuilder(AbstractMetric metric) {
        this._metric = metric;
    }

    public static CwmsMetricsBuilder newBuilder(Timer timer) {
        return new CwmsMetricsBuilder((AbstractMetric)timer);
    }

    public void setProperties() {
        this._metric.setMetricProperties(this._properties);
    }

    public CwmsMetricsBuilder withOfficeId(String officeId) {
        if (officeId != null) {
            this._properties.put("Office Id", officeId);
        }
        return this;
    }

    public CwmsMetricsBuilder withLocationId(String locationId) {
        if (locationId != null) {
            this._properties.put("Location Id", locationId);
        }
        return this;
    }

    public CwmsMetricsBuilder withTimeSeriesMask(String tsSubselectString) {
        if (tsSubselectString != null) {
            this._properties.put("Time Series ID", tsSubselectString);
        }
        return this;
    }

    public CwmsMetricsBuilder withReturnedRows(int size) {
        this._properties.put("Values", (Object)size);
        return this;
    }

    public CwmsMetricsBuilder withLocationCategory(String locationCategory) {
        if (locationCategory != null) {
            this._properties.put("Location Category", locationCategory);
        }
        return this;
    }

    public CwmsMetricsBuilder withLocationGroup(String locationGroup) {
        if (locationGroup != null) {
            this._properties.put("Location Group", locationGroup);
        }
        return this;
    }

    public CwmsMetricsBuilder withTsCategory(String tsCategory) {
        if (tsCategory != null) {
            this._properties.put("Time Series Category", tsCategory);
        }
        return this;
    }

    public CwmsMetricsBuilder withTsGroup(String tsGroup) {
        if (tsGroup != null) {
            this._properties.put("Time Series Group", tsGroup);
        }
        return this;
    }

    public CwmsMetricsBuilder withTimeSeriesId(String timeSeriesId) {
        if (timeSeriesId != null) {
            this._properties.put("Time Series ID", timeSeriesId);
        }
        return this;
    }

    public CwmsMetricsBuilder withTimeSeriesValueCount(long i) {
        this._properties.put("Values", (Object)i);
        return this;
    }

    public CwmsMetricsBuilder withVersionDate(Date versionDate) {
        if (versionDate != null) {
            this._properties.put("Version Date", versionDate);
        }
        return this;
    }

    public CwmsMetricsBuilder withTimeSeriesAndTimeWindow(String timeWindowMap) {
        if (timeWindowMap != null) {
            this._properties.put("Time Window", timeWindowMap);
        }
        return this;
    }

    public CwmsMetricsBuilder withUtcOffsetMinutes(Number utcOffsetMinutes) {
        if (utcOffsetMinutes != null) {
            this._properties.put("UtcOffsetMinutes", utcOffsetMinutes);
        }
        return this;
    }

    public CwmsMetricsBuilder withVerticalDatum(String verticalDatumInfo) {
        if (verticalDatumInfo != null) {
            this._properties.put("Vertical Datum", verticalDatumInfo);
        }
        return this;
    }

    public CwmsMetricsBuilder withTemplateIdMask(String templateIdMask) {
        if (templateIdMask != null) {
            this._properties.put("Rating Template", templateIdMask);
        }
        return this;
    }

    public CwmsMetricsBuilder withSpecIdMask(String specIdMask) {
        if (specIdMask != null) {
            this._properties.put("Rating Spec", specIdMask);
        }
        return this;
    }

    public CwmsMetricsBuilder withStartDate(Date effectiveDateStart) {
        if (effectiveDateStart != null) {
            this._properties.put("Start Date", effectiveDateStart);
        }
        return this;
    }

    public CwmsMetricsBuilder withEndDate(Date effectiveDateEnd) {
        if (effectiveDateEnd != null) {
            this._properties.put("End Date", effectiveDateEnd);
        }
        return this;
    }

    public CwmsMetricsBuilder withRatingSpec(String ratingSpec) {
        if (ratingSpec != null) {
            this._properties.put("Rating Spec", ratingSpec);
        }
        return this;
    }

    public CwmsMetricsBuilder withRatingInputCount(int length) {
        this._properties.put("Input Values", (Object)length);
        return this;
    }

    public CwmsMetricsBuilder withRatingOutputCount(int length) {
        this._properties.put("Values", (Object)length);
        return this;
    }

    public CwmsMetricsBuilder withTemplateId(String templateId) {
        if (templateId != null) {
            this._properties.put("Rating Template", templateId);
        }
        return this;
    }

    public CwmsMetricsBuilder withDeleteAction(String deleteAction) {
        if (deleteAction != null) {
            this._properties.put("Delete Action", deleteAction);
        }
        return this;
    }

    public CwmsMetricsBuilder withRatingsXmlSize(String xml) {
        if (xml != null) {
            this._properties.put("Rating XML Size", (Object)xml.length());
        }
        return this;
    }
}

