/*
 * Decompiled with CFR 0.152.
 */
package hec.db.util;

import com.google.common.flogger.FluentLogger;
import hec.data.TimeWindowMap;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

public final class CwmsTsUtil {
    public static final int MESSAGE_LEVEL_OFF = 0;
    public static final int MESSAGE_LEVEL_SEVERE = 1;
    public static final int MESSAGE_LEVEL_INFO = 2;
    public static final int MESSAGE_LEVEL_CONFIG = 3;
    public static final int MESSAGE_LEVEL_FINE = 4;
    public static final int MESSAGE_LEVEL_FINER = 5;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone(NumericalConstants.UTC_ZONEID);
    private static final String MESSAGE_LEVEL_PROPERTY = "cwms.dbi.message_level";

    private CwmsTsUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    public static int getDbiPropertiesMessageLevel() {
        String property = System.getProperty(MESSAGE_LEVEL_PROPERTY, Integer.toString(0));
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException ex) {
            String errorMessage = "System property: cwms.dbi.message_level set to invalid number value, must be an integer: " + property + " Reverting to default: 0 (MESSAGE_LEVEL_OFF)";
            ((FluentLogger.Api)((FluentLogger.Api)FluentLogger.forEnclosingClass().atWarning()).withCause((Throwable)ex)).log(errorMessage);
            return 0;
        }
    }

    public static String parseTimeSeriesTemplate(Collection<TimeSeriesTemplate> templs) {
        HashMap<TimeSeriesIdentifier, TimeWindowMap> map = new HashMap<TimeSeriesIdentifier, TimeWindowMap>();
        templs.stream().filter(Objects::nonNull).forEach(templ -> {
            TimeWindowMap timeWindowMap = new TimeWindowMap();
            timeWindowMap.addTimeWindow(new Date(templ.getStartTime()), true, new Date(templ.getEndTime()), true);
            map.put(templ.getTimeSeriesIdentifier(), timeWindowMap);
        });
        return CwmsTsUtil.parseTimeWindowMap(map);
    }

    public static String parseTimeWindowMap(Map<TimeSeriesIdentifier, TimeWindowMap> map) {
        return map.entrySet().stream().map(entry -> {
            String timeWindows = ((TimeWindowMap)entry.getValue()).getTimeWindowSet().stream().map(timeWindow -> timeWindow.getStartDate().toString() + "-" + timeWindow.getEndDate()).collect(Collectors.joining(";"));
            return ((TimeSeriesIdentifier)entry.getKey()).getTimeSeriesId() + ":" + timeWindows;
        }).collect(Collectors.joining(" ", "{", "}"));
    }

    public static String parseTimeSeries(Collection<TimeSeries> timeSeries) {
        HashMap<TimeSeriesIdentifier, TimeWindowMap> map = new HashMap<TimeSeriesIdentifier, TimeWindowMap>();
        timeSeries.stream().filter(Objects::nonNull).forEach(templ -> {
            TimeWindowMap timeWindowMap = new TimeWindowMap();
            timeWindowMap.addTimeWindow(new Date(templ.getStartTime().toInstant().toEpochMilli()), true, new Date(templ.getEndTime().toInstant().toEpochMilli()), true);
            map.put(templ.getTimeSeriesIdentifier(), timeWindowMap);
        });
        return CwmsTsUtil.parseTimeWindowMap(map);
    }

    public static void log(FluentLogger logger, long t1, long t2, String type, List<TimeSeries> list) {
        StringBuilder sb = new StringBuilder();
        int dbiPropertiesMessageLevel = CwmsTsUtil.getDbiPropertiesMessageLevel();
        if (logger.at(Level.CONFIG).isEnabled() || dbiPropertiesMessageLevel >= 1) {
            int size = list.size();
            int numvals = 0;
            for (TimeSeries timeSeries : list) {
                numvals += timeSeries.getNumberValues();
            }
            sb.append(size);
            sb.append(" time series (");
            sb.append(numvals);
            sb.append(" values), ");
            sb.append(type);
            sb.append(", ");
            sb.append(t2 - t1);
            sb.append(" ms.\n");
        }
        if (logger.at(Level.FINE).isEnabled() || dbiPropertiesMessageLevel >= 2) {
            for (TimeSeries timeSeries : list) {
                sb.append("  ");
                sb.append(timeSeries.getTimeSeriesIdentifier().toString());
                sb.append(", Units=");
                sb.append(timeSeries.getUnits().toString());
                sb.append("\n");
            }
        }
        if (logger.at(Level.FINER).isEnabled() || dbiPropertiesMessageLevel >= 3) {
            String d = DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(t2));
            sb.append("  Current Time:");
            sb.append(d);
            sb.append("\n");
        }
        if (logger.at(Level.FINEST).isEnabled() || dbiPropertiesMessageLevel >= 4) {
            for (TimeSeries timeSeries : list) {
                sb.append("  ");
                sb.append(timeSeries.getTimeSeriesIdentifier().toString());
                sb.append(", Units=");
                sb.append(timeSeries.getUnits().toString());
                sb.append("\n");
                CwmsTsUtil.logDataSet(logger, sb, timeSeries);
                sb.append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - "\n".length());
            ((FluentLogger.Api)logger.atInfo()).log(sb.toString());
        }
    }

    public static void log(FluentLogger logger, long t1, long t2, String type, Optional<TimeSeries> timeSeries, TimeSeriesIdentifier timeSeriesIdentifier) {
        StringBuilder sb = new StringBuilder();
        int dbiPropertiesMessageLevel = CwmsTsUtil.getDbiPropertiesMessageLevel();
        if (logger.at(Level.CONFIG).isEnabled() || dbiPropertiesMessageLevel >= 1) {
            int numvals = timeSeries.map(TimeSeries::getNumberValues).orElse(0);
            sb.append("1 time series (");
            sb.append(numvals);
            sb.append(" values), ");
            sb.append(type);
            sb.append(", ");
            sb.append(t2 - t1);
            sb.append(" ms.\n");
        }
        if (logger.at(Level.FINE).isEnabled() || dbiPropertiesMessageLevel >= 2) {
            sb.append("  ");
            sb.append(timeSeries.map(TimeSeries::getTimeSeriesIdentifier).orElse(timeSeriesIdentifier));
            timeSeries.ifPresent(t -> {
                sb.append(", Units=");
                sb.append(t.getUnits().toString());
            });
            sb.append("\n");
        }
        if (logger.at(Level.FINER).isEnabled() || dbiPropertiesMessageLevel >= 3) {
            String d = DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(t2));
            sb.append("  Current Time:");
            sb.append(d);
            sb.append("\n");
        }
        if (logger.at(Level.FINEST).isEnabled() || dbiPropertiesMessageLevel >= 4) {
            timeSeries.ifPresent(t -> CwmsTsUtil.logDataSet(logger, sb, t));
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - "\n".length());
            ((FluentLogger.Api)logger.atInfo()).log(sb.toString());
        }
    }

    private static void logDataSet(FluentLogger logger, StringBuilder sb, TimeSeries ts) {
        double[] vals = ts.getValues();
        long[] times = ts.getTimes();
        if (vals != null && times != null) {
            int valuesToLog = Math.min(10, vals.length);
            if (logger.at(Level.ALL).isEnabled() || CwmsTsUtil.getDbiPropertiesMessageLevel() > 4) {
                valuesToLog = vals.length;
            }
            for (int i = 0; i < valuesToLog; ++i) {
                sb.append("  ");
                sb.append(DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(times[i])));
                sb.append("  ");
                if (NumericalConstants.isValidValue((double)vals[i])) {
                    sb.append(vals[i]);
                } else {
                    sb.append("N/A");
                }
                Optional quality = ts.getQuality();
                if (quality.isPresent()) {
                    sb.append("  ").append(((Quality)quality.get()).getIntegerAt(i));
                }
                if (i >= valuesToLog - 1) continue;
                sb.append(",\n");
            }
        }
    }

    public static void logRetrieveTimeSeriesMap(FluentLogger logger, List<TimeSeriesTemplate> templateList, int size) {
        if (((FluentLogger.Api)logger.atFiner()).isEnabled()) {
            String msg = "Calling cwmsTsJdbc.retrieveMulti(...) for " + size + " time series\n";
            ((FluentLogger.Api)logger.atFiner()).log(msg);
        }
        if (((FluentLogger.Api)logger.atFinest()).isEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Calling cwmsTsJdbc.retrieveMulti(...) for the following time series:\n");
            for (TimeSeriesTemplate templ : templateList) {
                TimeSeriesIdentifier desc = templ.getTimeSeriesIdentifier();
                String tsid = desc.toString();
                sb.append("\t").append(tsid).append("\n");
            }
            String msg = sb.toString();
            ((FluentLogger.Api)logger.atFinest()).log(msg);
        }
    }
}

