/*
 * Decompiled with CFR 0.152.
 */
package rma.services.annotations.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

final class ServiceLoaderLine
implements Comparable<ServiceLoaderLine> {
    private static final String POSITION = "#position=";
    private static final String SUPERSEDE = "#-";
    private final String _impl;
    private final int _position;
    private final String[] _supersedes;

    public ServiceLoaderLine(String impl, int position, String[] supersedes) {
        this._impl = impl;
        this._position = position;
        this._supersedes = supersedes;
    }

    public static void parse(Reader r, SortedSet<ServiceLoaderLine> lines) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(r);
        String impl = null;
        int position = Integer.MAX_VALUE;
        ArrayList<String> supersedes = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith(POSITION)) {
                position = Integer.parseInt(line.substring(POSITION.length()));
                continue;
            }
            if (line.startsWith(SUPERSEDE)) {
                supersedes.add(line.substring(SUPERSEDE.length()));
                continue;
            }
            ServiceLoaderLine.finalizeParse(lines, impl, position, supersedes);
            impl = line;
            position = Integer.MAX_VALUE;
            supersedes.clear();
        }
        ServiceLoaderLine.finalizeParse(lines, impl, position, supersedes);
    }

    private static void finalizeParse(Set<ServiceLoaderLine> lines, String impl, int position, List<String> supersedes) {
        if (impl != null) {
            lines.add(new ServiceLoaderLine(impl, position, supersedes.toArray(new String[0])));
        }
    }

    @Override
    public int compareTo(ServiceLoaderLine o) {
        if (this._impl.equals(o._impl)) {
            return 0;
        }
        int r = this._position - o._position;
        return r != 0 ? r : this._impl.compareTo(o._impl);
    }

    public boolean equals(Object o) {
        return o instanceof ServiceLoaderLine && this._impl.equals(((ServiceLoaderLine)o)._impl);
    }

    public int hashCode() {
        return this._impl.hashCode();
    }

    public void write(PrintWriter w) {
        w.println(this._impl);
        if (this._position != Integer.MAX_VALUE) {
            w.println(POSITION + this._position);
        }
        for (String exclude : this._supersedes) {
            w.println(SUPERSEDE + exclude);
        }
    }
}

