/*
 * Decompiled with CFR 0.152.
 */
package rma.services.annotations.spi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import rma.services.annotations.ServiceProvider;
import rma.services.annotations.ServiceProviders;
import rma.services.annotations.spi.ServiceLoaderLine;

@SupportedAnnotationTypes(value={"rma.services.annotations.ServiceProvider", "rma.services.annotations.ServiceProviders"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class ServiceProviderProcessor
extends AbstractProcessor {
    private final Map<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>> _outputFilesByProcessor = new WeakHashMap<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>>();
    private final Map<ProcessingEnvironment, Map<String, List<Element>>> _originatingElementsByProcessor = new WeakHashMap<ProcessingEnvironment, Map<String, List<Element>>>();
    private final Map<TypeElement, Boolean> _verifiedClasses = new WeakHashMap<TypeElement, Boolean>();

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised()) {
            return false;
        }
        if (roundEnv.processingOver()) {
            this.writeServices();
            this._outputFilesByProcessor.clear();
            this._originatingElementsByProcessor.clear();
            return true;
        }
        return this.handleProcess(annotations, roundEnv);
    }

    protected final void register(TypeElement clazz, Class<? extends Annotation> annotation, TypeMirror type, String path, int position, String[] supersedes) {
        Boolean verify = this._verifiedClasses.get(clazz);
        if (verify == null) {
            verify = this.verifyServiceProviderSignature(clazz, annotation);
            this._verifiedClasses.put(clazz, verify);
        }
        if (!verify.booleanValue()) {
            return;
        }
        String impl = this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
        String xface = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement(type)).toString();
        if (!this.processingEnv.getTypeUtils().isAssignable(clazz.asType(), type)) {
            AnnotationMirror ann = this.findAnnotationMirror(clazz, annotation);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, impl + " is not assignable to " + xface, clazz, ann, this.findAnnotationValue(ann, "service"));
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, impl + " to be registered as a " + xface + (String)(path.length() > 0 ? " under " + path : ""));
        String rsrc = (String)(path.length() > 0 ? "META-INF/namedservices/" + path + "/" : "META-INF/services/") + xface;
        Map originatingElements = this._originatingElementsByProcessor.computeIfAbsent(this.processingEnv, k -> new HashMap());
        List origEls = originatingElements.computeIfAbsent(rsrc, k -> new ArrayList());
        origEls.add(clazz);
        Map outputFiles = this._outputFilesByProcessor.computeIfAbsent(this.processingEnv, k -> new HashMap());
        TreeSet<ServiceLoaderLine> lines = (TreeSet<ServiceLoaderLine>)outputFiles.get(rsrc);
        if (lines == null) {
            lines = new TreeSet<ServiceLoaderLine>();
            try {
                try {
                    FileObject in = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", rsrc);
                    in.openInputStream().close();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot generate " + rsrc + " because it already exists in sources: " + in.toUri());
                    return;
                }
                catch (FileNotFoundException in) {
                }
                catch (RuntimeException ex) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Skipping check to determine if META-INF service definition already exists for: " + rsrc);
                }
                try {
                    FileObject in = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", rsrc);
                    try (InputStream is = in.openInputStream();){
                        ServiceLoaderLine.parse(new InputStreamReader(is, StandardCharsets.UTF_8), lines);
                    }
                }
                catch (IOException in) {}
            }
            catch (IOException x) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                x.printStackTrace(pw);
                pw.flush();
                sw.flush();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Register: " + x.toString() + sw.toString());
                try {
                    sw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            outputFiles.put(rsrc, lines);
        }
        lines.add(new ServiceLoaderLine(impl, position, supersedes));
    }

    private AnnotationMirror findAnnotationMirror(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(annotation.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private AnnotationValue findAnnotationValue(AnnotationMirror annotation, String name) {
        if (annotation != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals(name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean verifyServiceProviderSignature(TypeElement clazz, Class<? extends Annotation> annotation) {
        AnnotationMirror ann = this.findAnnotationMirror(clazz, annotation);
        if (!clazz.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must be public", clazz, ann);
            return false;
        }
        if (clazz.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must not be abstract", clazz, ann);
            return false;
        }
        boolean hasDefaultCtor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(clazz.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
            hasDefaultCtor = true;
            break;
        }
        if (!hasDefaultCtor) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must have a public no-argument constructor", clazz, ann);
            return false;
        }
        return true;
    }

    private void writeServices() {
        for (Map.Entry<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>> outputFiles : this._outputFilesByProcessor.entrySet()) {
            for (Map.Entry<String, SortedSet<ServiceLoaderLine>> entry : outputFiles.getValue().entrySet()) {
                try {
                    FileObject out = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", entry.getKey(), this._originatingElementsByProcessor.get(outputFiles.getKey()).get(entry.getKey()).toArray(new Element[0]));
                    OutputStream os = out.openOutputStream();
                    try {
                        PrintWriter w = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
                        for (ServiceLoaderLine line : entry.getValue()) {
                            line.write(w);
                        }
                        w.flush();
                        w.close();
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                catch (IOException x) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write to " + entry.getKey() + ": " + x.toString());
                }
            }
        }
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement clazz;
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceProvider.class)) {
            clazz = (TypeElement)element;
            ServiceProvider sp = clazz.getAnnotation(ServiceProvider.class);
            this.register(clazz, ServiceProvider.class, sp);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceProviders.class)) {
            clazz = (TypeElement)element;
            ServiceProviders spp = clazz.getAnnotation(ServiceProviders.class);
            for (ServiceProvider sp : spp.value()) {
                this.register(clazz, ServiceProviders.class, sp);
            }
        }
        return true;
    }

    private void register(TypeElement clazz, Class<? extends Annotation> annotation, ServiceProvider svc) {
        try {
            svc.service();
            assert (false);
        }
        catch (MirroredTypeException e) {
            this.register(clazz, annotation, e.getTypeMirror(), svc.path(), svc.position(), svc.supersedes());
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element annotated, AnnotationMirror annotation, ExecutableElement attr, String userText) {
        if (this.processingEnv == null || annotated == null || !annotated.getKind().isClass()) {
            return Collections.emptyList();
        }
        if (annotation == null || !"rma.services.annotations.ServiceProvider".contentEquals(((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName())) {
            return Collections.emptyList();
        }
        if (!"service".contentEquals(attr.getSimpleName())) {
            return Collections.emptyList();
        }
        TypeElement jlObject = this.processingEnv.getElementUtils().getTypeElement("java.lang.Object");
        if (jlObject == null) {
            return Collections.emptyList();
        }
        LinkedList<TypeCompletion> result = new LinkedList<TypeCompletion>();
        LinkedList<TypeElement> toProcess = new LinkedList<TypeElement>();
        toProcess.add((TypeElement)annotated);
        while (!toProcess.isEmpty()) {
            TypeElement c = (TypeElement)toProcess.remove(0);
            result.add(new TypeCompletion(c.getQualifiedName().toString() + ".class"));
            LinkedList<? extends TypeMirror> parents = new LinkedList<TypeMirror>();
            parents.add(c.getSuperclass());
            parents.addAll(c.getInterfaces());
            for (TypeMirror typeMirror : parents) {
                TypeElement type;
                if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED || jlObject.equals(type = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror))) continue;
                toProcess.add(type);
            }
        }
        return result;
    }

    private static final class TypeCompletion
    implements Completion {
        private final String _type;

        public TypeCompletion(String type) {
            this._type = type;
        }

        @Override
        public String getValue() {
            return this._type;
        }

        @Override
        public String getMessage() {
            return null;
        }
    }
}

