/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ObservableClass;
import hec.heclib.dss.DSSPathname;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;

public abstract class AbstractSaveAsDialog
extends JDialog {
    protected JPanel pathnamePanel;
    protected JPanel filePanel;
    protected JLabel pathnameLabel;
    protected JTextField pathnameTextField;
    protected JPanel partsPanel;
    protected JLabel labelA;
    protected JTextField APartTextField;
    protected JLabel labelB;
    protected JTextField BPartTextField;
    protected JLabel labelC;
    protected JTextField CPartTextField;
    protected JLabel labelD;
    protected JTextField DPartTextField;
    protected JLabel labelE;
    protected JTextField EPartTextField;
    protected JLabel labelF;
    protected JTextField FPartTextField;
    protected JPanel buttonPanel;
    protected ButtonCmdPanel _cmdPanel;
    protected RmaJComboBox _fileComboBox;
    protected RmaJCheckBox storeAsDoubles;
    protected DataContainer _dataContainer = null;
    protected DSSPathname _path;
    protected boolean _checkOverwrite = true;
    protected boolean _canceled = false;
    protected Frame _parent = null;
    protected ObservableClass _observer;
    protected int _gridy = 0;
    boolean fComponentsAdjusted = false;

    public AbstractSaveAsDialog(Frame parent, boolean modal) {
        super(parent, modal);
    }

    public void setPathname(String pathname) {
        this._path = new DSSPathname(pathname);
        this.setText();
    }

    public void showOptions(boolean showDoubles, boolean showSelectFiles) {
        if (this.storeAsDoubles != null) {
            this.storeAsDoubles.setVisible(showDoubles);
        }
        if (this.filePanel != null) {
            this.filePanel.setVisible(showSelectFiles);
        }
    }

    protected void setup() {
        this._observer = new ObservableClass();
        this.setTitle("Save As");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(600, 230);
        this.setBackground(new Color(-3355444));
        this.pathnameTextField = new JTextField();
        this.APartTextField = new JTextField();
        this.BPartTextField = new JTextField();
        this.CPartTextField = new JTextField();
        this.DPartTextField = new JTextField();
        this.EPartTextField = new JTextField();
        this.FPartTextField = new JTextField();
        this.storeAsDoubles = new RmaJCheckBox("Save as Double Precision");
        this.storeAsDoubles.setVisible(false);
        this.build();
    }

    protected void build() {
        this.buildPathnamePanel();
        this.buildPartsPanel();
        this.buildFilePanel();
        this.buildButtonPanel();
        this.registerListeners();
        this.setLocation(50, 50);
    }

    protected void buildPathnamePanel() {
        this.pathnamePanel = new JPanel();
        this.pathnamePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this._gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(8, 0, 0, 0);
        this.getContentPane().add((Component)this.pathnamePanel, gbc);
        this.pathnameLabel = new JLabel("Pathname: ");
        Font font = this.pathnameLabel.getFont();
        this.pathnameLabel.setDisplayedMnemonic('P');
        this.pathnameLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        this.pathnameLabel.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(14, 15, 0, 0);
        gbc.ipadx = 8;
        gbc.ipady = 9;
        this.pathnamePanel.add((Component)this.pathnameLabel, gbc);
        this.pathnameTextField.setForeground(new Color(0));
        this.pathnameTextField.setMargin(new Insets(0, 2, 0, 0));
        this.pathnameLabel.setLabelFor(this.pathnameTextField);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 7;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 6, 0, 10);
        gbc.ipadx = 80;
        gbc.ipady = 5;
        this.pathnamePanel.add((Component)this.pathnameTextField, gbc);
    }

    protected void buildPartsPanel() {
        Insets ins12 = new Insets(0, 2, 0, 2);
        Insets ins5 = new Insets(0, 5, 0, 0);
        this.partsPanel = new JPanel();
        this.partsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this._gridy;
        gbc.gridheight = 2;
        this._gridy += gbc.gridheight;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 6, 0, 10);
        gbc.ipadx = 8;
        gbc.ipady = 9;
        this.getContentPane().add((Component)this.partsPanel, gbc);
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new GridBagLayout());
        this.labelA = new JLabel();
        this.labelA.setText("A:");
        this.labelA.setForeground(new Color(0));
        this.labelA.setDisplayedMnemonic('A');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = ins12;
        gbc.fill = 0;
        aPanel.add((Component)this.labelA, gbc);
        this.APartTextField.setForeground(new Color(0));
        this.APartTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = ins5;
        gbc.ipadx = 50;
        gbc.ipady = 0;
        aPanel.add((Component)this.APartTextField, gbc);
        this.labelA.setLabelFor(this.APartTextField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = ins12;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)aPanel, gbc);
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new GridBagLayout());
        this.labelB = new JLabel();
        this.labelB.setText("B:");
        this.labelB.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = ins12;
        gbc.fill = 0;
        ((GridBagLayout)bPanel.getLayout()).setConstraints(this.labelB, gbc);
        bPanel.add(this.labelB);
        this.BPartTextField = new JTextField();
        this.BPartTextField.setToolTipText("Location");
        this.BPartTextField.setForeground(new Color(0));
        this.BPartTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = ins5;
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)bPanel.getLayout()).setConstraints(this.BPartTextField, gbc);
        bPanel.add(this.BPartTextField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = ins12;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)bPanel, gbc);
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = ins12;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)cPanel, gbc);
        this.labelC = new JLabel();
        this.labelC.setText("C:");
        this.labelC.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = ins12;
        gbc.fill = 0;
        ((GridBagLayout)cPanel.getLayout()).setConstraints(this.labelC, gbc);
        cPanel.add(this.labelC);
        this.CPartTextField = new JTextField();
        this.CPartTextField.setToolTipText("Parameter");
        this.CPartTextField.setForeground(new Color(0));
        this.CPartTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = ins5;
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)cPanel.getLayout()).setConstraints(this.CPartTextField, gbc);
        cPanel.add(this.CPartTextField);
        JPanel dPanel = new JPanel();
        dPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = ins12;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)dPanel, gbc);
        this.labelD = new JLabel();
        this.labelD.setText("D:");
        this.labelD.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = ins12;
        gbc.fill = 0;
        gbc.anchor = 22;
        dPanel.add((Component)this.labelD, gbc);
        this.DPartTextField = new JTextField();
        this.DPartTextField.setToolTipText("Block start date (automatically generated)");
        this.DPartTextField.setForeground(new Color(0));
        this.DPartTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 22;
        gbc.insets = ins5;
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)dPanel.getLayout()).setConstraints(this.DPartTextField, gbc);
        dPanel.add(this.DPartTextField);
        JPanel ePanel = new JPanel();
        ePanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = ins12;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)ePanel, gbc);
        this.labelE = new JLabel();
        this.labelE.setText("E:");
        this.labelE.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = ins12;
        ((GridBagLayout)ePanel.getLayout()).setConstraints(this.labelE, gbc);
        ePanel.add(this.labelE);
        this.EPartTextField.setForeground(new Color(0));
        this.EPartTextField.setMargin(new Insets(0, 2, 0, 0));
        this.labelE.setLabelFor(this.EPartTextField);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = ins5;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        ((GridBagLayout)ePanel.getLayout()).setConstraints(this.EPartTextField, gbc);
        ePanel.add(this.EPartTextField);
        JPanel fPanel = new JPanel();
        fPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = ins12;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)fPanel, gbc);
        this.labelF = new JLabel();
        this.labelF.setText("F:");
        this.labelF.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = ins12;
        gbc.fill = 0;
        fPanel.add((Component)this.labelF, gbc);
        this.FPartTextField = new JTextField();
        this.FPartTextField.setToolTipText("Version");
        this.FPartTextField.setForeground(new Color(0));
        this.FPartTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = ins5;
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)fPanel.getLayout()).setConstraints(this.FPartTextField, gbc);
        fPanel.add(this.FPartTextField);
    }

    protected void buildFilePanel() {
        this.filePanel = new JPanel();
        this.filePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this._gridy++;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.getContentPane().add((Component)this.filePanel, gbc);
        JLabel label = new JLabel("Save to: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 10, 4, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.filePanel.add((Component)label, gbc);
        Vector files = this.getFileList();
        this._fileComboBox = new RmaJComboBox(files);
        String filename = this.getFileName();
        if (filename != null) {
            this._fileComboBox.setSelectedItem((Object)filename);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.filePanel.add((Component)this._fileComboBox, gbc);
        JButton openButton = new JButton("Browse");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 10, 6, 10);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.filePanel.add((Component)openButton, gbc);
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSaveAsDialog.this.openDssDialog();
            }
        });
    }

    protected void buildButtonPanel() {
        this.buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this._gridy++;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(20, 20, 0, 0);
        this.buttonPanel.add((Component)this.storeAsDoubles, gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.buttonPanel.add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        AbstractSaveAsDialog.this.OKButton_ActionPerformed(e);
                        break;
                    }
                    case 4: {
                        AbstractSaveAsDialog.this.CancelButton_ActionPerformed(e);
                    }
                }
            }
        });
    }

    protected void registerListeners() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        PartListener partListener = new PartListener();
        this.pathnameTextField.addFocusListener(partListener);
        this.APartTextField.addFocusListener(partListener);
        this.BPartTextField.addFocusListener(partListener);
        this.CPartTextField.addFocusListener(partListener);
        this.DPartTextField.addFocusListener(partListener);
        this.EPartTextField.addFocusListener(partListener);
        this.FPartTextField.addFocusListener(partListener);
    }

    public void setCheckOverwrite(boolean checkOverwrite) {
        this._checkOverwrite = checkOverwrite;
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public void disableFileBrowser() {
        this.filePanel.setVisible(false);
        this.setSize(500, 180);
    }

    public void disablePart(String partLetter) {
        if (partLetter.equalsIgnoreCase("A")) {
            this.APartTextField.setEnabled(false);
            this.APartTextField.setBackground(Color.lightGray);
        } else if (partLetter.equalsIgnoreCase("B")) {
            this.BPartTextField.setEnabled(false);
            this.BPartTextField.setBackground(Color.lightGray);
        } else if (partLetter.equalsIgnoreCase("C")) {
            this.CPartTextField.setEnabled(false);
            this.CPartTextField.setBackground(Color.lightGray);
        } else if (partLetter.equalsIgnoreCase("D")) {
            this.DPartTextField.setEnabled(false);
            this.DPartTextField.setBackground(Color.lightGray);
        } else if (partLetter.equalsIgnoreCase("E")) {
            this.EPartTextField.setEnabled(false);
            this.EPartTextField.setBackground(Color.lightGray);
        } else if (partLetter.equalsIgnoreCase("F")) {
            this.FPartTextField.setEnabled(false);
            this.FPartTextField.setBackground(Color.lightGray);
        }
    }

    protected void setText() {
        this.pathnameTextField.setText(this._path.pathname());
        this.APartTextField.setText(this._path.aPart());
        this.BPartTextField.setText(this._path.bPart());
        this.CPartTextField.setText(this._path.cPart());
        this.DPartTextField.setText(this._path.dPart());
        this.EPartTextField.setText(this._path.ePart());
        this.FPartTextField.setText(this._path.fPart());
        this.pathnameTextField.setToolTipText(this._path.pathname());
        this.APartTextField.setToolTipText(this._path.aPart());
        this.BPartTextField.setToolTipText(this._path.bPart());
        this.CPartTextField.setToolTipText(this._path.cPart());
        this.DPartTextField.setToolTipText(this._path.dPart());
        this.EPartTextField.setToolTipText(this._path.ePart());
        this.FPartTextField.setToolTipText(this._path.fPart());
        if (this._path.isTimeSeries()) {
            this.disablePart("D");
            this.disablePart("E");
        }
        this.validate();
    }

    protected void pathnameTextField_ActionPerformed() {
        if (this._dataContainer instanceof TimeSeriesContainer) {
            String d = this._path.dPart();
            String e = this._path.ePart();
            this._path.setPathname(this.pathnameTextField.getText());
            this._path.setDPart(d);
            this._path.setEPart(e);
        } else {
            this._path.setPathname(this.pathnameTextField.getText());
        }
        this.setText();
    }

    protected void partTextField_ActionPerformed(Object object) {
        if (object == this.APartTextField) {
            this._path.setAPart(this.APartTextField.getText());
        } else if (object == this.BPartTextField) {
            this._path.setBPart(this.BPartTextField.getText());
        } else if (object == this.CPartTextField) {
            this._path.setCPart(this.CPartTextField.getText());
        } else if (object == this.DPartTextField) {
            this._path.setDPart(this.DPartTextField.getText());
        } else if (object == this.EPartTextField) {
            this._path.setEPart(this.EPartTextField.getText());
        } else if (object == this.FPartTextField) {
            this._path.setFPart(this.FPartTextField.getText());
        }
        this.setText();
    }

    public DSSPathname getPathname() {
        if (!this._path.pathname().equals(this.pathnameTextField.getText())) {
            this._path.setPathname(this.pathnameTextField.getText());
        }
        if (!this._path.aPart().equals(this.APartTextField.getText())) {
            this._path.setAPart(this.APartTextField.getText());
        }
        if (!this._path.bPart().equals(this.BPartTextField.getText())) {
            this._path.setBPart(this.BPartTextField.getText());
        }
        if (!this._path.cPart().equals(this.CPartTextField.getText())) {
            this._path.setCPart(this.CPartTextField.getText());
        }
        if (!this._path.dPart().equals(this.DPartTextField.getText())) {
            this._path.setDPart(this.DPartTextField.getText());
        }
        if (!this._path.ePart().equals(this.EPartTextField.getText())) {
            this._path.setEPart(this.EPartTextField.getText());
        }
        if (!this._path.fPart().equals(this.FPartTextField.getText())) {
            this._path.setFPart(this.FPartTextField.getText());
        }
        this.setText();
        return this._path;
    }

    protected void OKButton_ActionPerformed(ActionEvent e) {
        this.getPathname();
        this._canceled = false;
        ActionEvent event = new ActionEvent(this, 1001, "OK");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
        boolean status = this.saveData();
        this.setVisible(false);
    }

    protected void CancelButton_ActionPerformed(ActionEvent e) {
        this._canceled = true;
        this.setVisible(false);
        ActionEvent event = new ActionEvent(this, 1001, "Cancel");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    public boolean canceled() {
        return this._canceled;
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }

    protected void JFrame1_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    protected abstract void openDssDialog();

    public abstract boolean saveData();

    protected abstract String getFileName();

    protected abstract Vector getFileList();

    public class SymWindow
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == AbstractSaveAsDialog.this) {
                AbstractSaveAsDialog.this.JFrame1_WindowClosing(event);
            }
        }
    }

    public class PartListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            Object object = event.getSource();
            if (object == AbstractSaveAsDialog.this.pathnameTextField) {
                AbstractSaveAsDialog.this.pathnameTextField_ActionPerformed();
            } else {
                AbstractSaveAsDialog.this.partTextField_ActionPerformed(object);
            }
        }
    }
}

