/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

abstract class BasePathnameTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected String[][] _pathnameParts;
    protected String[] _pathnameList = new String[0];
    protected CondensedReference[] _condensedList = new CondensedReference[0];
    protected DssDataManager _dataManager;
    int[] _partPositions = new int[7];
    int[] _maxLengths = new int[7];
    int[] _pathnamesDisplayed;
    int _pathnamesDisplayedSize = 0;

    public DssDataManager getDataManager() {
        return this._dataManager;
    }

    public String getDssFileName() {
        return this._dataManager.DSSFileName();
    }

    @Override
    public int getRowCount() {
        if (this._pathnameParts == null) {
            return 0;
        }
        return this._pathnamesDisplayedSize;
    }

    public int size() {
        return this.getRowCount();
    }

    public String[] getPathnameList() {
        return this._pathnameList;
    }

    public CondensedReference[] getCondensedCatalog() {
        return this._condensedList;
    }

    public void setPathnameList(String[] pathnameList, DssDataManager dataManager) {
        this._pathnameList = pathnameList;
        this._dataManager = dataManager;
        if (this._pathnameList.length == 0) {
            this._pathnamesDisplayedSize = 0;
        }
    }

    public void setCondensedCatalog(CondensedReference[] condensedList, DssDataManager dataManager) {
        this._condensedList = condensedList;
        this._dataManager = dataManager;
        if (this._condensedList.length == 0) {
            this._pathnamesDisplayedSize = 0;
        }
    }

    public int getPathnamesDisplayedSize() {
        return this._pathnamesDisplayedSize;
    }

    public int getPathnameListLength() {
        if (this._pathnamesDisplayed == null) {
            return 0;
        }
        return this._pathnamesDisplayed.length;
    }

    public int getPathnamesDisplayed(int part) {
        if (this._pathnamesDisplayed == null || this._pathnamesDisplayed.length <= part) {
            return 0;
        }
        return this._pathnamesDisplayed[part];
    }

    public String[] getPathnamePartList(int part) {
        if (this._pathnameParts == null) {
            return new String[0];
        }
        return this._pathnameParts[part];
    }

    public int[] getMaxLengths() {
        return this._maxLengths;
    }

    public String getPathnamePart(int numb, int part) {
        return this._pathnameParts[part][numb];
    }

    public void buildList() {
        int i;
        int number;
        this._pathnamesDisplayedSize = number = this._pathnameList.length;
        this._pathnamesDisplayed = new int[number];
        for (int i2 = 0; i2 < 7; ++i2) {
            this._maxLengths[i2] = 0;
        }
        this._pathnameParts = new String[6][number];
        for (i = 0; i < number; ++i) {
            this._pathnamesDisplayed[i] = i;
            String pathname = this._pathnameList[i];
            int stat = DSSPathname.parsePathname((String)pathname, (int[])this._partPositions);
            for (int j = 0; j < 6; ++j) {
                String pathnamePart;
                int length = this._partPositions[j + 1] - this._partPositions[j];
                this._pathnameParts[j][i] = length > 0 ? (pathnamePart = pathname.substring(this._partPositions[j], this._partPositions[j + 1] - 1)) : "";
                if (length <= this._maxLengths[j + 1]) continue;
                this._maxLengths[j + 1] = length;
            }
        }
        block3: for (i = 0; i < number; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (this._pathnameParts[j][i] != null) continue;
                Logger logger = Logger.getLogger(BasePathnameTableModel.class.getName());
                StringBuilder sb = new StringBuilder();
                sb.append("Null pathname part for row:  ").append(i).append(":  ").append("/").append(this._pathnameParts[0][i]).append("/").append(this._pathnameParts[1][i]).append("/").append(this._pathnameParts[2][i]).append("/").append(this._pathnameParts[3][i]).append("/").append(this._pathnameParts[4][i]).append("/").append(this._pathnameParts[5][i]).append("/");
                logger.log(Level.SEVERE, sb.toString());
                continue block3;
            }
        }
        this._maxLengths[0] = Integer.toString(number).length();
        this.fireTableStructureChanged();
    }

    public boolean searchByString(String search) {
        boolean foundSome = true;
        if (search.length() == 0) {
            this._pathnamesDisplayedSize = this._pathnameParts[0].length;
            for (int i = 0; i < this._pathnamesDisplayedSize; ++i) {
                this._pathnamesDisplayed[i] = i;
            }
        } else {
            int i;
            this._pathnamesDisplayedSize = 0;
            for (i = 0; i < this._pathnameList.length; ++i) {
                if (this._pathnameList[i].toUpperCase().indexOf(search.toUpperCase()) <= -1) continue;
                this._pathnamesDisplayed[this._pathnamesDisplayedSize++] = i;
            }
            if (this._pathnamesDisplayedSize == 0) {
                foundSome = false;
                this._pathnamesDisplayedSize = this._pathnameParts[0].length;
                for (i = 0; i < this._pathnamesDisplayedSize; ++i) {
                    this._pathnamesDisplayed[i] = i;
                }
            }
        }
        this.fireTableStructureChanged();
        return foundSome;
    }

    public void searchByParts(boolean oneIsSet, boolean[] searchPart, String[] parts) {
        if (!oneIsSet) {
            this._pathnamesDisplayedSize = this._pathnameParts[0].length;
            for (int i = 0; i < this._pathnamesDisplayedSize; ++i) {
                this._pathnamesDisplayed[i] = i;
            }
        } else {
            this._pathnamesDisplayedSize = 0;
            for (int i = 0; i < this._pathnameParts[0].length; ++i) {
                boolean foundOne = true;
                for (int j = 0; j < 6; ++j) {
                    if (!searchPart[j]) continue;
                    String part = parts[j];
                    if (part.equals("(blank)")) {
                        part = "";
                    }
                    if (part.equals(this._pathnameParts[j][i])) continue;
                    foundOne = false;
                    break;
                }
                if (!foundOne) continue;
                this._pathnamesDisplayed[this._pathnamesDisplayedSize++] = i;
            }
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this._pathnameParts == null) {
            return "";
        }
        if (column == 0) {
            return new Integer(row + 1);
        }
        if (row >= this._pathnamesDisplayedSize) {
            return "";
        }
        if (row >= this._pathnamesDisplayed.length) {
            return "";
        }
        int numb = this._pathnamesDisplayed[row];
        if (numb >= this._pathnameParts[0].length) {
            return "";
        }
        return this._pathnameParts[column - 1][numb];
    }

    public String getNominalPathname(int row) {
        int numb = this._pathnamesDisplayed[row];
        return this._pathnameList[numb];
    }

    public String getPathname(int row) {
        int numb = this._pathnamesDisplayed[row];
        return this._pathnameList[numb];
    }

    public CondensedReference getCondensedReference(int row) {
        return null;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Integer.class;
        }
        return String.class;
    }
}

