/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dataTable.HecDataTableFrame;
import hec.dssgui.CompareFilesDialog;
import hec.dssgui.ListSelection;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDSSUtilities;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecDssCatalog;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecDouble;
import hec.heclib.util.Heclib;
import hec.heclib.util.stringContainer;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.util.TextDialog;
import java.awt.Component;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;

public class CompareFiles {
    protected ListSelection _listSelection;
    protected DssDataManager _firstDataManager;
    protected DssDataManager _secondDataManager;
    HashSet<String> pathsFirst = new HashSet();
    HashSet<String> pathsSecond = new HashSet();
    HashSet<String> pathsBoth = new HashSet();
    HashSet<String> pathsDiffer = new HashSet();
    HashSet<String> pathsSame = new HashSet();
    HashSet<String> timeSeriesDiffer = new HashSet();
    stringContainer sc = new stringContainer();
    StringBuffer mess = new StringBuffer();
    int taskNumber;
    int currentNumber;
    int currentNumberDifferences;
    int totalNumber;
    boolean cancel;
    int task1_Location;
    boolean _useOptions;
    boolean _ignoreMissing;
    boolean _coincidentTimes;
    boolean _compareDataSets;
    int _compareType;
    HecDouble _compareValue;

    public CompareFiles(ListSelection listSelection, DssDataManager firstDataManager, DssDataManager secondDataManager, boolean useOptions, boolean compareDatasets, boolean ignoreMissing, boolean coincidentTimes, int compareType, HecDouble compareValue) {
        this._listSelection = listSelection;
        this._firstDataManager = firstDataManager;
        this._secondDataManager = secondDataManager;
        this._useOptions = useOptions;
        this._compareDataSets = compareDatasets;
        this._ignoreMissing = ignoreMissing;
        this._coincidentTimes = coincidentTimes;
        this._compareType = compareType;
        this._compareValue = new HecDouble(compareValue);
        this.taskNumber = 0;
        this.currentNumber = 0;
        this.currentNumberDifferences = 0;
        this.totalNumber = 0;
        this.task1_Location = 0;
        this.cancel = false;
    }

    public CompareFiles(ListSelection listSelection, DssDataManager firstDataManager, DssDataManager secondDataManager) {
        this(listSelection, firstDataManager, secondDataManager, false, false, false, 0, new HecDouble());
    }

    public CompareFiles(ListSelection listSelection, DssDataManager firstDataManager, DssDataManager secondDataManager, boolean useOptions, boolean ignoreMissing, boolean coincidentTimes, int compareType, HecDouble compareValue) {
        this(listSelection, firstDataManager, secondDataManager, useOptions, false, ignoreMissing, coincidentTimes, compareType, compareValue);
    }

    public boolean doCompare() {
        this.obtainPathnames();
        boolean cont = this.comparePathnames();
        if (cont) {
            this.compareData();
            this.showDifferences();
            return true;
        }
        String mess = this.getMessage();
        JOptionPane.showMessageDialog(this._listSelection, mess.toString(), "Compare HEC-DSS Files", 1);
        return false;
    }

    public boolean obtainPathnames() {
        this.currentNumber = 0;
        this.taskNumber = 1;
        this.totalNumber = this._firstDataManager.numberRecords() + this._secondDataManager.numberRecords();
        if (this.cancel) {
            return false;
        }
        if (this._compareDataSets) {
            CondensedReference cp;
            int i;
            String[] temp = new String[1];
            HecDSSUtilities dm = (HecDSSUtilities)this._firstDataManager.dataManager();
            String[] paths = dm.getPathnameList(true);
            Vector condensedPaths = dm.getCondensedCatalog(paths, true);
            this.pathsFirst = new HashSet(condensedPaths.size());
            for (i = 0; i < condensedPaths.size(); ++i) {
                cp = (CondensedReference)condensedPaths.get(i);
                ((HecDataManager)this._firstDataManager.dataManager()).setPathname(cp.getFirstPathname());
                cp.complete((HecDssCatalog)((HecDataManager)this._firstDataManager.dataManager()), temp, 0, true);
                this.pathsFirst.add(cp.getNominalPathname().toUpperCase());
            }
            dm = (HecDSSUtilities)this._secondDataManager.dataManager();
            paths = dm.getPathnameList(true);
            condensedPaths = dm.getCondensedCatalog(paths, true);
            this.pathsSecond = new HashSet(condensedPaths.size());
            for (i = 0; i < condensedPaths.size(); ++i) {
                cp = (CondensedReference)condensedPaths.get(i);
                ((HecDataManager)this._secondDataManager.dataManager()).setPathname(cp.getFirstPathname());
                cp.complete((HecDssCatalog)((HecDataManager)this._secondDataManager.dataManager()), temp, 0, true);
                this.pathsSecond.add(cp.getNominalPathname().toUpperCase());
            }
        } else if (this._firstDataManager.getDssFileVersion() != this._secondDataManager.getDssFileVersion()) {
            String e;
            int interval;
            int i;
            String[] paths = this._firstDataManager.getCatalog(false, null);
            this.pathsFirst = new HashSet(paths.length);
            int vers = this._firstDataManager.getDssFileVersion();
            if (vers == 7) {
                DSSPathname path = new DSSPathname();
                for (i = 0; i < paths.length; ++i) {
                    path.setPathname(paths[i]);
                    interval = HecTimeSeriesBase.zgintlFromEPart((String)path.ePart());
                    if (interval > 0) {
                        e = HecTimeSeriesBase.getEPartFromInterval((int)interval);
                        path.setEPart(e);
                        this.pathsFirst.add(path.pathname().toUpperCase());
                        continue;
                    }
                    this.pathsFirst.add(paths[i].toUpperCase());
                }
            } else {
                for (int i2 = 0; i2 < paths.length; ++i2) {
                    this.pathsFirst.add(paths[i2]);
                }
            }
            paths = this._secondDataManager.getCatalog(false, null);
            this.pathsSecond = new HashSet(paths.length);
            vers = this._secondDataManager.getDssFileVersion();
            if (vers == 7) {
                DSSPathname path = new DSSPathname();
                for (i = 0; i < paths.length; ++i) {
                    path.setPathname(paths[i]);
                    interval = HecTimeSeriesBase.zgintlFromEPart((String)path.ePart());
                    if (interval > 0) {
                        e = HecTimeSeriesBase.getEPartFromInterval((int)interval);
                        path.setEPart(e);
                        this.pathsSecond.add(path.pathname().toUpperCase());
                        continue;
                    }
                    this.pathsSecond.add(paths[i].toUpperCase());
                }
            } else {
                for (int i3 = 0; i3 < paths.length; ++i3) {
                    this.pathsSecond.add(paths[i3]);
                }
            }
        } else {
            int i;
            String[] paths = this._firstDataManager.getCatalog(false, null);
            this.pathsFirst = new HashSet(paths.length);
            for (i = 0; i < paths.length; ++i) {
                this.pathsFirst.add(paths[i]);
            }
            paths = this._secondDataManager.getCatalog(false, null);
            this.pathsSecond = new HashSet(paths.length);
            for (i = 0; i < paths.length; ++i) {
                this.pathsSecond.add(paths[i]);
            }
        }
        this.task1_Location = 0;
        return !this.cancel;
    }

    public boolean comparePathnames() {
        String path;
        this._listSelection.setCursorWait("Compare Files: Comparing pathnames");
        this.currentNumberDifferences = 0;
        this.currentNumber = 0;
        this.taskNumber = 1;
        this.totalNumber = this._firstDataManager.numberRecords();
        Iterator<String> iter = this.pathsFirst.iterator();
        while (iter.hasNext()) {
            if (this.cancel) {
                return false;
            }
            ++this.currentNumber;
            path = iter.next();
            if (this.pathsSecond.contains(path)) {
                this.pathsBoth.add(path);
                continue;
            }
            ++this.currentNumberDifferences;
        }
        if (this.pathsBoth.size() == 0) {
            this.mess.append("Files completely different (no records in common).\n");
            this.mess.append(this._firstDataManager.DSSFileName());
            this.mess.append("  compared to  ");
            this.mess.append(this._secondDataManager.DSSFileName());
            return false;
        }
        if (this.pathsBoth.size() == this.pathsFirst.size() && this.pathsBoth.size() == this.pathsSecond.size()) {
            this.pathsFirst = new HashSet(1);
            this.pathsSecond = new HashSet(1);
        } else {
            iter = this.pathsBoth.iterator();
            while (iter.hasNext()) {
                if (this.cancel) {
                    return false;
                }
                path = iter.next();
                this.pathsFirst.remove(path);
                this.pathsSecond.remove(path);
            }
        }
        return true;
    }

    public void cancelCompare() {
        this.cancel = true;
        if (this.taskNumber == 1) {
            if (this.task1_Location == 1) {
                this._firstDataManager.setInterrupt(true);
            } else if (this.task1_Location == 2) {
                this._secondDataManager.setInterrupt(true);
            }
            Heclib.zset((String)"inte", (String)"", (int)1);
        }
    }

    public String getMessage() {
        String message = this.mess.toString().trim();
        if (message.length() < 3) {
            message = this.areFilesDifferent() ? "Files are Different" : (this._useOptions ? "Files are the same within specified tolerences" : "Files are Identical");
        }
        return message;
    }

    public void compareData() {
        String pathDup = "";
        this._listSelection.updateStatusField("Compare Files: Comparing data");
        this.currentNumberDifferences = 0;
        this.currentNumber = 0;
        this.totalNumber = this.pathsBoth.size();
        this.taskNumber = 2;
        Iterator<String> iter = this.pathsBoth.iterator();
        while (iter.hasNext()) {
            DSSPathname dssPath;
            String path;
            boolean differ = false;
            if (this.cancel) {
                return;
            }
            ++this.currentNumber;
            pathDup = path = iter.next();
            if (!this._firstDataManager.recordExists(path)) {
                differ = true;
            }
            int type = 0;
            DataReference dr = new DataReference(path, null);
            if (this._compareDataSets && (dssPath = new DSSPathname(path)).dPart().length() == 21 && dssPath.dPart().indexOf(" - ") == 9) {
                String tw = dssPath.dPart().substring(0, 9) + " 0001, " + dssPath.dPart().substring(12) + " 2400";
                dr.setTimeWindow(tw);
                dssPath.setDPart(dssPath.dPart().substring(0, 9));
                path = dssPath.pathname();
                dr.setPath(path);
                type = 100;
            }
            if (type == 0) {
                type = this._firstDataManager.recordType(path);
            }
            if (type >= 100 && type < 300) {
                if (type < 200) {
                    TimeSeriesContainer tsc1 = new TimeSeriesContainer();
                    this._firstDataManager.readData(dr, tsc1, false);
                    TimeSeriesContainer tsc2 = new TimeSeriesContainer();
                    this._secondDataManager.readData(dr, tsc2, false);
                    differ = !CompareFiles.compareContainers((DataContainer)tsc1, (DataContainer)tsc2, this._useOptions, this._ignoreMissing, this._coincidentTimes, this._compareType, this._compareValue);
                } else {
                    PairedDataContainer pdc1 = new PairedDataContainer();
                    this._firstDataManager.readData(dr, pdc1);
                    PairedDataContainer pdc2 = new PairedDataContainer();
                    this._secondDataManager.readData(dr, pdc2);
                    boolean bl = differ = !CompareFiles.compareContainers((DataContainer)pdc1, (DataContainer)pdc2, this._useOptions, this._ignoreMissing, this._coincidentTimes, this._compareType, this._compareValue);
                }
            }
            if (differ) {
                this.pathsDiffer.add(pathDup);
                ++this.currentNumberDifferences;
                if (type == 0) {
                    type = this._firstDataManager.recordType(path);
                }
                if (type < 100 || type >= 200) continue;
                this.timeSeriesDiffer.add(pathDup);
                continue;
            }
            this.pathsSame.add(pathDup);
        }
    }

    public boolean areFilesDifferent() {
        return !this.pathsDiffer.isEmpty() || this.currentNumberDifferences > 0;
    }

    public int getNumberDifferent() {
        return this.currentNumberDifferences;
    }

    public void showDifferences() {
        int i;
        if (this.pathsDiffer.size() == 0 && this.pathsFirst.size() == 0 && this.pathsSecond.size() == 0) {
            this.mess.append("The files are identical");
            JOptionPane.showMessageDialog(this._listSelection, "The Files are Identical", ListSelection._programName, 1);
            return;
        }
        if (this.pathsFirst.size() > 0) {
            this.mess.append("There are ");
            this.mess.append(Integer.toString(this.pathsFirst.size()));
            this.mess.append(" records in ");
            this.mess.append(this._firstDataManager.DSSFileName());
            this.mess.append(" that are not in ");
            this.mess.append(this._secondDataManager.DSSFileName());
            this.mess.append(".\n");
        }
        if (this.pathsSecond.size() > 0) {
            this.mess.append("There are ");
            this.mess.append(Integer.toString(this.pathsSecond.size()));
            this.mess.append(" records in ");
            this.mess.append(this._secondDataManager.DSSFileName());
            this.mess.append(" that are not in ");
            this.mess.append(this._firstDataManager.DSSFileName());
            this.mess.append(".\n");
        }
        if (this.pathsDiffer.size() > 0) {
            this.mess.append("There are ");
            this.mess.append(Integer.toString(this.pathsSame.size()));
            this.mess.append(" records in common contain the same data.\n");
            this.mess.append("There are ");
            this.mess.append(Integer.toString(this.pathsDiffer.size()));
            this.mess.append(" records in common that have different data.");
        }
        Object[] opts = new String[]{"Show Differences", "Cancel"};
        int opt = JOptionPane.showOptionDialog(this._listSelection, this.mess.toString(), ListSelection._programName, 0, 3, null, opts, opts[0]);
        if (opt == 1) {
            return;
        }
        this.mess = new StringBuffer();
        if (this.pathsFirst.size() > 0) {
            Object[] pOld = this.pathsFirst.toArray();
            Arrays.sort(pOld);
            this.mess.append("Records in ");
            this.mess.append(this._firstDataManager.DSSFileName());
            this.mess.append(" that are not in ");
            this.mess.append(this._secondDataManager.DSSFileName());
            this.mess.append(":\n");
            for (i = 0; i < pOld.length; ++i) {
                this.mess.append((String)pOld[i]);
                this.mess.append("\n");
            }
        }
        if (this.pathsSecond.size() > 0) {
            Object[] pNew = this.pathsSecond.toArray();
            Arrays.sort(pNew);
            this.mess.append("\n\nRecords in ");
            this.mess.append(this._secondDataManager.DSSFileName());
            this.mess.append(" that are not in ");
            this.mess.append(this._firstDataManager.DSSFileName());
            this.mess.append(":\n");
            for (i = 0; i < pNew.length; ++i) {
                this.mess.append((String)pNew[i]);
                this.mess.append("\n");
            }
        }
        if (this.pathsDiffer.size() > 0) {
            Object[] pDiffer = this.pathsDiffer.toArray();
            Arrays.sort(pDiffer);
            this.mess.append("\n\nRecords in common that have different data between the two files:\n");
            for (i = 0; i < pDiffer.length; ++i) {
                this.mess.append((String)pDiffer[i]);
                this.mess.append("\n");
            }
        }
        TextContainer tc = new TextContainer();
        tc.text = this.mess.toString();
        tc.fullName = "Differences between " + this._firstDataManager.DSSFileName() + " and " + this._secondDataManager.DSSFileName();
        TextDialog textDialog = new TextDialog((Component)this._listSelection);
        try {
            textDialog.initialize(tc, false);
            textDialog.setLocation(20, 20);
            textDialog.setSize(700, 500);
            textDialog.setVisible(true);
            this._listSelection.getObjectList().addElement(textDialog);
            textDialog.addWindowListener((WindowListener)this._listSelection.getWindowClosingListener());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (this.timeSeriesDiffer.size() > 0) {
            Object[] tsDiffer = this.timeSeriesDiffer.toArray();
            Arrays.sort(tsDiffer);
            Vector<Object> tsDifferV = new Vector<Object>(Arrays.asList(tsDiffer));
            CompareFilesDialog compareFilesDialog = new CompareFilesDialog(this._listSelection, tsDifferV, this._firstDataManager, this._secondDataManager);
            if (this._useOptions) {
                compareFilesDialog.setOptions(this._ignoreMissing, this._coincidentTimes, this._compareType, this._compareValue);
            }
            compareFilesDialog.setVisible(true);
        }
    }

    public int getCompareStatus(int[] numberRecs, int[] currentRec, int[] currentNumberDiff) {
        if (this.taskNumber == 1) {
            if (this.task1_Location == 1) {
                this._firstDataManager.getProcessStatus(numberRecs, currentRec);
            } else if (this.task1_Location == 2) {
                this._secondDataManager.getProcessStatus(numberRecs, currentRec);
            } else {
                Heclib.zquery((String)"CURR", (stringContainer)this.sc, (int[])currentRec);
            }
            currentRec[0] = currentRec[0] + this.currentNumber;
        } else {
            currentRec[0] = this.currentNumber;
        }
        numberRecs[0] = this.totalNumber;
        currentNumberDiff[0] = this.currentNumberDifferences;
        return this.taskNumber;
    }

    public static boolean compareContainers(DataContainer dc1, DataContainer dc2) {
        return CompareFiles.compareContainers(dc1, dc2, false, false, false, 0, new HecDouble());
    }

    public static boolean compareContainers(DataContainer dc1, DataContainer dc2, boolean useOptions, boolean ignoreMissing, boolean coincidentTimes, int compareType, HecDouble compareValue) {
        if (dc1 instanceof TimeSeriesContainer && dc2 instanceof TimeSeriesContainer) {
            int i;
            TimeSeriesContainer tsc1 = (TimeSeriesContainer)dc1;
            TimeSeriesContainer tsc2 = (TimeSeriesContainer)dc2;
            if (tsc1.numberValues == 0 && tsc2.numberValues == 0) {
                return true;
            }
            if (ignoreMissing) {
                tsc1.removeAllMissing();
                tsc2.removeAllMissing();
            }
            if (tsc1.numberValues != tsc2.numberValues) {
                return false;
            }
            if (tsc1.interval != tsc2.interval) {
                return false;
            }
            if (tsc1.startTime != tsc2.startTime) {
                return false;
            }
            if (tsc1.endTime != tsc2.endTime) {
                return false;
            }
            if (!tsc1.units.equals(tsc2.units)) {
                return false;
            }
            if (!tsc1.type.equals(tsc2.type)) {
                return false;
            }
            if (tsc1.quality != null && tsc2.quality == null) {
                return false;
            }
            if (tsc1.quality == null && tsc2.quality != null) {
                return false;
            }
            if (tsc1.quality != null && tsc2.quality != null) {
                for (i = 0; i < tsc1.numberValues; ++i) {
                    if (tsc1.quality[i] == tsc2.quality[i]) continue;
                    return false;
                }
            }
            if (!useOptions) {
                if (tsc1.numberValues > 0) {
                    for (i = 0; i < tsc1.numberValues; ++i) {
                        if (tsc1.values[i] != tsc2.values[i]) {
                            return false;
                        }
                        if (tsc1.times[i] == tsc2.times[i]) continue;
                        return false;
                    }
                }
            } else {
                HecDataTableFrame table = new HecDataTableFrame(null);
                Vector<TimeSeriesContainer> dataSets = new Vector<TimeSeriesContainer>(2);
                dataSets.add(tsc1);
                dataSets.add(tsc2);
                int[] ordinatesDifferent = table.getCompareDataSetOrdinates(dataSets, compareType, -1, compareValue, ignoreMissing);
                if (ordinatesDifferent == null) {
                    return true;
                }
                int numberDifferent = ordinatesDifferent.length;
                if (numberDifferent > 0) {
                    return false;
                }
            }
            return true;
        }
        if (dc1 instanceof PairedDataContainer && dc2 instanceof PairedDataContainer) {
            PairedDataContainer pdc1 = (PairedDataContainer)dc1;
            PairedDataContainer pdc2 = (PairedDataContainer)dc2;
            if (pdc1.numberOrdinates != pdc2.numberOrdinates) {
                return false;
            }
            if (pdc1.numberCurves != pdc2.numberCurves) {
                return false;
            }
            if (pdc1.labelsUsed != pdc2.labelsUsed) {
                return false;
            }
            if (!pdc1.xunits.equals(pdc2.xunits)) {
                return false;
            }
            if (!pdc1.xtype.equals(pdc2.xtype)) {
                return false;
            }
            if (!pdc1.yunits.equals(pdc2.yunits)) {
                return false;
            }
            if (!pdc1.ytype.equals(pdc2.ytype)) {
                return false;
            }
            if (!useOptions) {
                if (pdc1.numberOrdinates > 0) {
                    int i;
                    for (i = 0; i < pdc1.numberOrdinates; ++i) {
                        if (pdc1.xOrdinates[i] == pdc2.xOrdinates[i]) continue;
                        return false;
                    }
                    if (pdc1.numberCurves > 0) {
                        for (i = 0; i < pdc1.numberCurves; ++i) {
                            for (int j = 0; j < pdc1.numberOrdinates; ++j) {
                                if (pdc1.yOrdinates[i][j] == pdc2.yOrdinates[i][j]) continue;
                                return false;
                            }
                            if (!pdc1.labelsUsed || pdc1.labels[i].equals(pdc2.labels[i])) continue;
                            return false;
                        }
                    }
                }
            } else {
                HecDataTableFrame table = new HecDataTableFrame(null);
                Vector<PairedDataContainer> dataSets = new Vector<PairedDataContainer>(2);
                dataSets.add(pdc1);
                dataSets.add(pdc1);
                int numberDifferent = table.compareDataSets(dataSets, compareType, -1, compareValue, ignoreMissing);
                if (numberDifferent > 0) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

