/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dataTable.HecDataTableFrame;
import hec.dssgui.CompareOptionsDialog;
import hec.dssgui.ListSelection;
import hec.dssgui.SelectRecords;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecDouble;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CompareFilesDialog
extends SelectRecords {
    protected DssDataManager _dataManager = null;
    protected DssDataManager _secondDataManager;
    protected boolean ignoreMissing = false;
    protected boolean coincidentTimes = false;
    protected int compareType = 0;
    protected HecDouble compareValue = new HecDouble();

    public CompareFilesDialog(JFrame parent, Vector pathnames, DssDataManager dataManager, DssDataManager secondDataManager) {
        super(parent);
        this._dataManager = dataManager;
        this._secondDataManager = secondDataManager;
        this.setTitle("Compare Records");
        this.changeButtons();
        String[] names = pathnames.toArray(new String[0]);
        this.populateTable(names);
        this.compareValue.set(0.0);
    }

    protected void changeButtons() {
        JButton okButton = this.cmdPanel.getButton("OK");
        okButton.setText("Compare Records");
        JButton b = this.cmdPanel.getButton("Apply");
        this.cmdPanel.remove((Component)b);
        JButton options = new JButton("Options");
        options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareFilesDialog.this.displayOptions();
            }
        });
        this.selectButtons.setLayout(new GridLayout(1, 3));
        this.selectButtons.add(options);
    }

    protected void setOptions(boolean ignoreMiss, boolean coincidTimes, int type, HecDouble value) {
        this.ignoreMissing = ignoreMiss;
        this.coincidentTimes = coincidTimes;
        this.compareType = type;
        this.compareValue.set(value);
    }

    protected void displayOptions() {
        CompareOptionsDialog cod = new CompareOptionsDialog((Frame)((Object)this));
        cod.setOptions(this.compareType, this.compareValue);
        cod.setVisible(true);
        if (cod.isCanceled()) {
            return;
        }
        this.ignoreMissing = cod.getIgnoreMissing();
        this.coincidentTimes = cod.getCoincidentTimes();
        this.compareType = cod.getCompareType();
        this.compareValue.set(cod.getValue());
    }

    @Override
    void jButtonOk_actionPerformed(ActionEvent event) {
        for (int i = 0; i < this._dataNamesTable.getRowCount(); ++i) {
            String select = this._dataNamesTable.getCell(i, 0).toString();
            if (!select.equals("true")) continue;
            Vector<Object> data = new Vector<Object>();
            String path = (String)this._dataNamesTable.getValueAt(i, 1);
            DataReference dr = new DataReference(path, this._dataManager.DSSFileName());
            int type = this._dataManager.recordType(dr.pathname());
            if (type >= 100 && type < 200) {
                int count;
                TimeSeriesContainer tsc1 = new TimeSeriesContainer();
                this._dataManager.readData(dr, tsc1);
                dr = new DataReference(path, this._secondDataManager.DSSFileName());
                TimeSeriesContainer tsc2 = new TimeSeriesContainer();
                this._secondDataManager.readData(dr, tsc2);
                data.add(tsc1);
                data.add(tsc2);
                if (this.ignoreMissing) {
                    for (int j = 0; j < data.size(); ++j) {
                        Object obj = data.get(j);
                        if (!(obj instanceof TimeSeriesContainer)) continue;
                        ((TimeSeriesContainer)obj).removeAllMissing();
                    }
                }
                if (this.coincidentTimes && (count = HecTimeSeries.getCoincidentTimes(data)) < 1) {
                    String message = "No coincident times shared among data sets";
                    System.out.println(message);
                    if (ListSelection.isInteractive()) {
                        JOptionPane.showMessageDialog((Component)((Object)this), message);
                    }
                    return;
                }
            } else if (type >= 200 && type < 300) {
                PairedDataContainer pdc1 = new PairedDataContainer();
                this._dataManager.readData(dr, pdc1);
                dr = new DataReference(path, this._secondDataManager.DSSFileName());
                PairedDataContainer pdc2 = new PairedDataContainer();
                this._secondDataManager.readData(dr, pdc2);
                data.add(pdc1);
                data.add(pdc2);
            } else {
                JOptionPane.showMessageDialog(this._parent, "Cannot tabulate this data type");
                return;
            }
            HecDataTableFrame table = new HecDataTableFrame((Object)this._parent);
            int[] rows = table.getCompareDataSetOrdinates(data, this.compareType, -1, this.compareValue, this.ignoreMissing);
            int loc = 10 * i + 10;
            if (loc > 500) {
                loc = 500;
            }
            table.setLocation(loc, loc);
            table.setTitle(this._dataManager.DSSFileName() + " verses " + this._secondDataManager.DSSFileName());
            table.setVisible(true);
            table.setShownNextOrdinate(rows);
        }
    }

    @Override
    void jButtonCancel_actionPerformed(ActionEvent event) {
        this.dispose();
    }
}

