/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.Help;
import hec.heclib.util.HecDouble;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.RootPaneContainer;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;

public class CompareOptionsDialog
extends RmaJDialog {
    protected JCheckBox _ignoreMissing;
    protected JCheckBox _coincidentTimes;
    protected JRadioButton _records;
    protected JRadioButton _dataSets;
    protected JRadioButton _exact;
    protected JRadioButton _percentDifferent;
    protected JRadioButton _amountDifferent;
    protected RmaJDecimalField _percentDifferentFld;
    protected RmaJDecimalField _amountDifferentFld;
    protected boolean _canceled = false;
    protected Preferences _preferences;

    public CompareOptionsDialog(Frame parent) {
        super(parent, true);
        this.build();
        this.init();
        Help.setHelp((RootPaneContainer)((Object)this), "39");
    }

    public void setOptions(int compareType, HecDouble value) {
        if (compareType == 0) {
            this._exact.setSelected(true);
        } else if (compareType == 1) {
            this._percentDifferent.setSelected(true);
            this._percentDifferentFld.setValue(value);
        } else if (compareType == 2) {
            this._amountDifferent.setSelected(true);
            this._amountDifferentFld.setValue(value);
        }
    }

    protected void build() {
        this.setTitle("Compare Options");
        this.getContentPane().setLayout(new GridBagLayout());
        int gridy = 0;
        JPanel panela = new JPanel(new GridBagLayout());
        panela.setBorder(BorderFactory.createTitledBorder("Compare What?"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)panela, gbc);
        this._records = new JRadioButton("Individual Records (pathnames)");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panela.add((Component)this._records, gbc);
        this._dataSets = new JRadioButton("Complete Data Sets");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panela.add((Component)this._dataSets, gbc);
        this._ignoreMissing = new JCheckBox("Ignore Missing Values");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(15, 10, 0, 0);
        this.getContentPane().add((Component)this._ignoreMissing, gbc);
        this._coincidentTimes = new JCheckBox("Coincident Times Only");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 10, 0, 0);
        this.getContentPane().add((Component)this._coincidentTimes, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Allowable Difference"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)panel, gbc);
        this._exact = new JRadioButton();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)this._exact, gbc);
        JLabel label = new JLabel("Exact");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)label, gbc);
        label = new JLabel("    ");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)label, gbc);
        this._percentDifferent = new JRadioButton();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)this._percentDifferent, gbc);
        this._percentDifferentFld = new RmaJDecimalField();
        this._percentDifferentFld.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        panel.add((Component)this._percentDifferentFld, gbc);
        label = new JLabel("Percent Difference");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5005;
        panel.add((Component)label, gbc);
        label = new JLabel("        ");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        panel.add((Component)label, gbc);
        this._amountDifferent = new JRadioButton();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)this._amountDifferent, gbc);
        this._amountDifferentFld = new RmaJDecimalField();
        this._amountDifferentFld.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        panel.add((Component)this._amountDifferentFld, gbc);
        label = new JLabel("Amount Difference");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5005;
        panel.add((Component)label, gbc);
        label = new JLabel("        ");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        panel.add((Component)label, gbc);
        label = new JLabel("        ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        panel.add((Component)label, gbc);
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)cmdPanel, gbc);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        CompareOptionsDialog.this.OKPressed();
                        break;
                    }
                    case 4: {
                        CompareOptionsDialog.this._canceled = true;
                        CompareOptionsDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    protected void init() {
        this._preferences = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        this._ignoreMissing.setSelected(this._preferences.getBoolean("ignoreMissing", false));
        this._coincidentTimes.setSelected(this._preferences.getBoolean("coincidentTimes", false));
        int compareType = this._preferences.getInt("compareType", 0);
        if (compareType == 1) {
            this._percentDifferent.setSelected(true);
        } else if (compareType == 2) {
            this._amountDifferent.setSelected(true);
        } else {
            this._exact.setSelected(true);
        }
        this._percentDifferentFld.setText(this._preferences.get("percentDifferent", ""));
        this._amountDifferentFld.setText(this._preferences.get("amountDifferent", ""));
        this.buttonSelected();
        ButtonGroup selBG = new ButtonGroup();
        selBG.add(this._exact);
        selBG.add(this._percentDifferent);
        selBG.add(this._amountDifferent);
        this._exact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareOptionsDialog.this.buttonSelected();
            }
        });
        this._percentDifferent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareOptionsDialog.this.buttonSelected();
            }
        });
        this._amountDifferent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareOptionsDialog.this.buttonSelected();
            }
        });
        ButtonGroup whatBG = new ButtonGroup();
        this._records.setSelected(true);
        whatBG.add(this._records);
        whatBG.add(this._dataSets);
    }

    protected void OKPressed() {
        this._preferences.putBoolean("ignoreMissing", this._ignoreMissing.isSelected());
        this._preferences.putBoolean("coincidentTimes", this._coincidentTimes.isSelected());
        this._preferences.putInt("compareType", this.getCompareType());
        this._preferences.put("percentDifferent", this._percentDifferentFld.getText());
        this._preferences.put("amountDifferent", this._amountDifferentFld.getText());
        this._canceled = false;
        this.setVisible(false);
    }

    protected void buttonSelected() {
        if (this._exact.isSelected()) {
            this._percentDifferentFld.setEnabled(false);
            this._amountDifferentFld.setEnabled(false);
        } else if (this._percentDifferent.isSelected()) {
            this._percentDifferentFld.setEnabled(true);
            this._amountDifferentFld.setEnabled(false);
        } else {
            this._percentDifferentFld.setEnabled(false);
            this._amountDifferentFld.setEnabled(true);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setSize(290, 340);
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            if (bounds.width > 0) {
                this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            }
        }
        super.setVisible(visible);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public boolean getIgnoreMissing() {
        return this._ignoreMissing.isSelected();
    }

    public boolean getCoincidentTimes() {
        return this._coincidentTimes.isSelected();
    }

    public boolean getCompareDataSets() {
        return this._dataSets.isSelected();
    }

    public int getCompareType() {
        if (this._exact.isSelected()) {
            return 0;
        }
        if (this._percentDifferent.isSelected()) {
            return 1;
        }
        return 2;
    }

    public HecDouble getValue() {
        if (this._exact.isSelected()) {
            return new HecDouble();
        }
        if (this._percentDifferent.isSelected()) {
            return this._percentDifferentFld.getHecDouble();
        }
        return this._amountDifferentFld.getHecDouble();
    }
}

