/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ListSelection;
import hec.dssgui.PathnamePartsTableModel;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.util.ElapsedTime;
import java.util.Vector;

class CondensedPathnameTableModel
extends PathnamePartsTableModel {
    private static final long serialVersionUID = 1L;
    protected int[] _partLocs = new int[2];
    boolean _useCollectionGroups = false;

    CondensedPathnameTableModel() {
    }

    @Override
    public String getNominalPathname(int row) {
        int numb = this._pathnamesDisplayed[row];
        return this._condensedList[numb].toString();
    }

    @Override
    public String getPathname(int row) {
        CondensedReference cr = this.getCondensedReference(row);
        return cr.getFirstPathname();
    }

    @Override
    public String[] getPathnameList() {
        this._pathnameList = new String[this.size()];
        int count = 0;
        for (int i = 0; i < this._condensedList.length; ++i) {
            CondensedReference cr = this._condensedList[i];
            String[] paths = cr.getPathnameList();
            for (int j = 0; j < paths.length; ++j) {
                this._pathnameList[count++] = paths[j];
            }
        }
        return this._pathnameList;
    }

    @Override
    public CondensedReference getCondensedReference(int row) {
        int numb = this._pathnamesDisplayed[row];
        return this._condensedList[numb];
    }

    public void setUseCollectionGroups(boolean useCollectionGroups) {
        this._useCollectionGroups = useCollectionGroups;
    }

    public boolean getUseCollectionGroups() {
        return this._useCollectionGroups;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 4) {
            return "Part D / range";
        }
        return super.getColumnName(col);
    }

    @Override
    public int size() {
        if (this._condensedList == null) {
            return 0;
        }
        int count = 0;
        int len = this._condensedList.length;
        for (int i = 0; i < len; ++i) {
            count += this._condensedList[i].size();
        }
        return count;
    }

    @Override
    public boolean searchByString(String search) {
        boolean foundSome;
        block4: {
            int i;
            block3: {
                foundSome = true;
                if (search.length() != 0) break block3;
                this._pathnamesDisplayedSize = this._pathnameParts[0].length;
                for (int i2 = 0; i2 < this._pathnamesDisplayedSize; ++i2) {
                    this._pathnamesDisplayed[i2] = i2;
                }
                break block4;
            }
            this._pathnamesDisplayedSize = 0;
            for (i = 0; i < this._condensedList.length; ++i) {
                if (this._condensedList[i].toString().toUpperCase().indexOf(search.toUpperCase()) <= -1) continue;
                this._pathnamesDisplayed[this._pathnamesDisplayedSize++] = i;
            }
            if (this._pathnamesDisplayedSize != 0) break block4;
            foundSome = false;
            this._pathnamesDisplayedSize = this._pathnameParts[0].length;
            for (i = 0; i < this._pathnamesDisplayedSize; ++i) {
                this._pathnamesDisplayed[i] = i;
            }
        }
        return foundSome;
    }

    @Override
    public void buildList() {
        int number;
        this._pathnamesDisplayedSize = number = this._condensedList.length;
        this._pathnamesDisplayed = new int[number];
        this.finishCondensedList();
        this._maxLengths[0] = Integer.toString(number).length();
    }

    private void finishCondensedList() {
        int i;
        if (ListSelection.debug) {
            System.out.println("Enter CondensedPathnameTableModel.finishCondensedList() " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
        if (this._useCollectionGroups) {
            boolean haveCollections = false;
            int number = this._condensedList.length;
            for (i = 0; i < number; ++i) {
                String path = this._condensedList[i].toString();
                if (!DSSPathname.isaCollectionPath((String)path)) continue;
                haveCollections = true;
                break;
            }
            if (haveCollections) {
                Vector<CondensedReference> condensed = new Vector<CondensedReference>(number);
                Vector<CondensedReference> collection = new Vector<CondensedReference>();
                String lastPathname = new String(" ");
                for (int i2 = 0; i2 < number; ++i2) {
                    CondensedReference cr;
                    String path = this._condensedList[i2].toString();
                    if (DSSPathname.isaCollectionPath((String)path)) {
                        if (DSSPathname.isSameCollection((String)path, (String)lastPathname)) {
                            collection.add(this._condensedList[i2]);
                            continue;
                        }
                        if (collection.size() == 1) {
                            condensed.add((CondensedReference)collection.get(0));
                            collection.removeAllElements();
                        } else if (collection.size() > 1) {
                            cr = new CondensedReference();
                            cr.setCollection(collection);
                            condensed.add(cr);
                            collection.removeAllElements();
                        }
                        collection.add(this._condensedList[i2]);
                        lastPathname = path;
                        continue;
                    }
                    if (collection.size() == 1) {
                        condensed.add((CondensedReference)collection.get(0));
                        collection.removeAllElements();
                        lastPathname = "";
                    } else if (collection.size() > 1) {
                        cr = new CondensedReference();
                        cr.setCollection(collection);
                        condensed.add(cr);
                        collection.removeAllElements();
                        lastPathname = "";
                    }
                    condensed.add(this._condensedList[i2]);
                }
                if (collection.size() == 1) {
                    condensed.add((CondensedReference)collection.get(0));
                } else if (collection.size() > 1) {
                    CondensedReference cr = new CondensedReference();
                    cr.setCollection(collection);
                    condensed.add(cr);
                }
                this._condensedList = condensed.toArray(new CondensedReference[0]);
            }
        }
        for (int i3 = 0; i3 < 7; ++i3) {
            this._maxLengths[i3] = 0;
        }
        int number = this._condensedList.length;
        this._pathnameParts = new String[6][number];
        this._pathnamesDisplayed = new int[number];
        this._pathnamesDisplayedSize = number;
        for (i = 0; i < number; ++i) {
            this._pathnamesDisplayed[i] = i;
            String pathname = this._condensedList[i].toString();
            int stat = DSSPathname.parsePathname((String)pathname, (int[])this._partPositions);
            for (int j = 0; j < 6; ++j) {
                int length = this._partPositions[j + 1] - this._partPositions[j];
                if (length > 1) {
                    this._pathnameParts[j][i] = pathname.substring(this._partPositions[j], this._partPositions[j + 1] - 1);
                } else {
                    this._pathnameParts[j][i] = "";
                    length = 1;
                }
                if (length <= this._maxLengths[j + 1]) continue;
                this._maxLengths[j + 1] = length;
            }
        }
        if (ListSelection.debug) {
            System.out.println("Exit CondensedPathnameTableModel.finishCondensedList() " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
    }
}

