/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataManager;
import hec.heclib.util.HecTime;
import hec.heclib.util.stringContainer;
import java.util.Arrays;
import java.util.Vector;

public class CondensedReference
extends hec.heclib.dss.CondensedReference {
    int _julianStart = -2147483647;
    int _julianEnd = -2147483647;

    public CondensedReference() {
    }

    public CondensedReference(String nominalPath) {
        super(nominalPath);
    }

    public Vector getPathnameVector() {
        Vector<String> v = new Vector<String>();
        if (this.collection == null) {
            if (this.pathnameList != null) {
                v.addAll(Arrays.asList(this.pathnameList));
            }
        } else {
            String[] paths = this.getPathnameList();
            v.addAll(Arrays.asList(paths));
        }
        return v;
    }

    public void setJulianStart(int julianStart) {
        this._julianStart = julianStart;
    }

    public void setJulianEnd(int julianEnd) {
        this._julianEnd = julianEnd;
    }

    public void complete(DssDataManager dataManager, String[] paths, int number, boolean querryTimes) {
        if (number > 0) {
            this.setPathnameArray(paths, number);
        }
        if (this.pathnameList == null) {
            return;
        }
        String first = this.getFirstPathname();
        String last = this.getLastPathname();
        this.nominalPathname = first;
        int[] partPositions = new int[7];
        int stat = DSSPathname.parsePathname((String)first, (int[])partPositions);
        if (stat != 0) {
            DSSPathname.parsePathname((String)"///////", (int[])partPositions);
        }
        if (partPositions[4] - partPositions[3] == 10 && partPositions[5] - partPositions[4] > 3) {
            HecTime start = new HecTime();
            HecTime end = new HecTime();
            if (this._julianStart != -2147483647 && this._julianEnd != -2147483647) {
                start.setJulian(this._julianStart);
                end.setJulian(this._julianEnd);
            } else if (querryTimes) {
                this.getDataTimes(dataManager, start, end);
            }
            if (this.size() == 1 && !start.isDateDefined()) {
                return;
            }
            this.nominalPathname = start.isDateDefined() && end.isDateDefined() ? first.substring(0, partPositions[3]) + start.date(4) + " - " + end.date(4) + first.substring(partPositions[4] - 1, partPositions[6]) : first.substring(0, partPositions[4] - 1) + " - " + last.substring(partPositions[3], partPositions[6]);
        }
    }

    public void getDataTimes(DssDataManager dataManager, HecTime start, HecTime end) {
        start.setUndefined();
        end.setUndefined();
        if (this.size() == 0) {
            return;
        }
        String path = this.pathnameList[0];
        if (path == null) {
            return;
        }
        stringContainer units = new stringContainer();
        stringContainer type = new stringContainer();
        if (dataManager != null) {
            dataManager.getTSRecordInfo(path, start, end, units, type);
            if (this.size() > 1) {
                path = this.getLastPathname();
                HecTime temp = new HecTime();
                dataManager.getTSRecordInfo(path, temp, end, units, type);
            }
        }
    }
}

