/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.DebugUtility;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.stringContainer;
import hec.util.GeneralTableEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.table.RmaCellRenderer;

public class DebugExamineFile7
extends GeneralTableEditor {
    protected HecDataManager _dataManager;
    protected String _fileName = null;
    protected long _start;
    protected int _numberWords;
    protected JTextField _goTo;
    protected JMenuItem _modifyMenuItem;
    protected JPopupMenu _popup;
    protected JMenuItem _gotoMenuItem;
    protected JPanel _lowerPanel;
    protected JButton _previousButton = null;
    protected JButton _nextButton = null;
    protected String[] _columnNames = new String[]{"Ordinate", "Address", "Integer 8", "Integer 4", "Integer 4", "Double", "Real", "Real", "Character", "Byte 1", "Byte 2", "Byte 3", "Byte 4", "Byte 5", "Byte 6", "Byte 7", "Byte 8"};
    protected int[] colWidths = new int[]{60, 70, 85, 85, 85, 85, 80, 80, 70, 50, 50, 50, 50, 50, 50, 50, 50};

    public DebugExamineFile7(HecDataManager dataManager, long address, int numberWords) {
        this._dataManager = dataManager;
        this._fileName = this._dataManager.DSSFileName();
        this._start = address;
        this._numberWords = numberWords;
        this._table.setEditable(false);
        this.initialize();
    }

    protected DebugExamineFile7() {
    }

    protected void initialize() {
        Vector rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
        this.initialize(this._columnNames, rows);
        RmaCellRenderer renderer = new RmaCellRenderer(new JLabel());
        renderer.setHorizontalAlignment(4);
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        this._table.setEditable(false);
        this._popup = new JPopupMenu();
        this._gotoMenuItem = new JMenuItem("Go To");
        this._gotoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugExamineFile7.this.goToPopup();
            }
        });
        this._popup.add(this._gotoMenuItem);
        this._modifyMenuItem = new JMenuItem("Modify Word");
        this._modifyMenuItem.setEnabled(false);
        this._modifyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugExamineFile7.this.modify();
            }
        });
        this._popup.add(this._modifyMenuItem);
        this._table.setPopupMenu(this._popup);
        int width = 0;
        for (int i = 0; i < this.colWidths.length; ++i) {
            width += this.colWidths[i];
            TableColumn tc = this._table.getColumnModel().getColumn(i);
            tc.setPreferredWidth(this.colWidths[i]);
        }
        this.setSize(width, 600);
        this.setLocation(100, 100);
        this.setTitle(this._fileName);
    }

    protected Vector decodeArray(int[] array, long address) {
        long[] ival8 = new long[1];
        int[] ivala = new int[1];
        int[] ivalb = new int[1];
        stringContainer doubleValue = new stringContainer();
        stringContainer crealValuea = new stringContainer();
        stringContainer crealValueb = new stringContainer();
        stringContainer cstringValue = new stringContainer();
        int[] ibytes = new int[8];
        Vector<String[]> rows = new Vector<String[]>();
        int[] iarray = new int[2];
        int n = array.length / 2;
        for (int i = 0; i < n; ++i) {
            String[] vals = new String[17];
            vals[0] = Integer.toString(i + 1);
            vals[1] = Long.toString(address + (long)i);
            iarray[0] = array[i * 2];
            iarray[1] = array[i * 2 + 1];
            DebugUtility.ConvertToVariousFormats(iarray, ival8, ivala, ivalb, doubleValue, crealValuea, crealValueb, cstringValue, ibytes);
            vals[2] = Long.toString(ival8[0]);
            vals[3] = Integer.toString(ivala[0]);
            vals[4] = Integer.toString(ivalb[0]);
            vals[5] = doubleValue.string;
            vals[6] = crealValuea.string;
            vals[7] = crealValueb.string;
            vals[8] = cstringValue.string;
            for (int j = 0; j < 8; ++j) {
                vals[9 + j] = Integer.toString(ibytes[j]);
            }
            rows.add(vals);
        }
        return rows;
    }

    public Vector getDecodedInfo(HecDataManager dataManager, long address, int numberWords) {
        if (dataManager != null) {
            int[] array = dataManager.debugLook(address, numberWords);
            Vector rows = this.decodeArray(array, address);
            return rows;
        }
        return null;
    }

    protected void build() {
        super.build();
        JButton button = this._cmdPanel.getButton(4);
        button.setVisible(false);
        button = this._cmdPanel.getButton(8);
        button.setText("Close");
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        DebugExamineFile7.this.close();
                    }
                }
            }
        });
        this._lowerPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        this.getContentPane().add((Component)this._lowerPanel, gbc);
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
        cmdPanel.setApplyAlwaysOn(true);
        this._previousButton = cmdPanel.getButton("OK");
        this._previousButton.setText("<< Previous");
        this._nextButton = cmdPanel.getButton("Cancel");
        this._nextButton.setText("Next >>");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this._lowerPanel.add((Component)cmdPanel, gbc);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        DebugExamineFile7.this.previous();
                        break;
                    }
                    case 4: {
                        DebugExamineFile7.this.next();
                    }
                }
            }
        });
        this._goTo = new JTextField();
        this._goTo.setColumns(8);
        this._goTo.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 10, 2, 0);
        this._lowerPanel.add((Component)this._goTo, gbc);
        ButtonCmdPanel goToButton = new ButtonCmdPanel(12);
        goToButton.setApplyAlwaysOn(true);
        goToButton.getButton("OK").setText("Go To");
        goToButton.getButton("Cancel").setText("Search");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this._lowerPanel.add((Component)goToButton, gbc);
        goToButton.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 4: {
                        DebugExamineFile7.this.search();
                        break;
                    }
                    case 8: {
                        DebugExamineFile7.this.goTo();
                    }
                }
            }
        });
    }

    protected void previous() {
        this._start -= (long)this._numberWords;
        if (this._dataManager != null) {
            if (this._start < 1L) {
                this._start = 1L;
            }
        } else if (this._start < 1L) {
            this._start = 0L;
        }
        Vector rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
        this.setRows(rows);
    }

    protected void next() {
        this._start += (long)this._numberWords;
        Vector rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
        this.setRows(rows);
    }

    protected void goTo() {
        String s = this._goTo.getText();
        this.go(s);
    }

    protected void go(String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        long address = Long.parseLong(s);
        if (this._dataManager != null) {
            if (address < 1L) {
                address = 1L;
            }
        } else if (address < 1L) {
            address = 0L;
        }
        this._start = address;
        Vector rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
        this.setRows(rows);
    }

    protected void okayButton() {
        this.close();
    }

    protected void goToPopup() {
        String s = this._table.getSelectedCellData().toString();
        this._table.clearSelection();
        this.go(s);
    }

    protected void search() {
        String s = this._goTo.getText();
        long val = 0L;
        try {
            val = Long.parseLong(s);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid number provided");
            return;
        }
        long add = this.search(val);
        if (add < 0L) {
            JOptionPane.showMessageDialog(null, "Value not found");
            return;
        }
        this._start = add;
        Vector rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
        this.setRows(rows);
    }

    protected long search(long val) {
        int[] array = null;
        long address = this._start + 1L;
        int numberWords = 2000;
        int max = 100000000;
        if (this._dataManager != null) {
            max = this._dataManager.zinqir("fsiz");
        }
        do {
            int i;
            if (this._dataManager != null) {
                array = this._dataManager.debugLook(address, numberWords);
            }
            if (array == null) {
                return -1L;
            }
            for (i = 0; i < array.length; ++i) {
                if ((long)array[i] != val) continue;
                return address + (long)(i / 2);
            }
            for (i = 0; i < array.length; i += 2) {
                long lval = DebugUtility.i4toi8(array[i], array[i + 1]);
                if (lval != val) continue;
                return address + (long)(i / 2);
            }
            if (array.length < numberWords) {
                return -1L;
            }
            if ((address += (long)(array.length / 2)) >= (long)max) {
                return -1L;
            }
            DebugExamineFile7 debugExamineFile7 = this;
        } while (!debugExamineFile7._dataManager.checkForSevereError());
        return -1L;
    }

    protected void buildMenu() {
        super.buildMenu();
        JMenuBar mb = new JMenuBar();
        mb.setVisible(false);
        this.setJMenuBar(mb);
    }

    protected void modify() {
        int selected = this._table.getSelectedRow();
        if (selected < 0) {
            return;
        }
        String sa = this._table.getValueAt(selected, 1).toString();
        long address = Long.parseLong(sa);
        int[] array = this._dataManager.debugLook(address, 1);
        String value = Long.toString(array[0]);
        String s = JOptionPane.showInputDialog("Modify value at address " + sa + ".\nWarning - this writes to disk.", (Object)value);
        if (s == null) {
            return;
        }
        long val = Long.parseLong(s);
        this._dataManager.debugModify(address, val);
        Vector rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
        this.setRows(rows);
    }

    protected void checkMenuItemsEnabled() {
        int selected = this._table.getSelectedRow();
        if (selected >= 0) {
            this._modifyMenuItem.setEnabled(true);
        } else {
            this._modifyMenuItem.setEnabled(false);
        }
    }
}

