/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.DebugExamineFile7;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecTime;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;

public class DebugFileInfo7
extends DebugExamineFile7 {
    protected RecordSection _recordSection = RecordSection.PERM_SECTION;
    protected String _nextString = "";
    protected static DecimalFormat dfmt3 = new DecimalFormat("000");
    protected String[] _colNames = new String[]{"Ordinate", "Description", "Address", "Value"};
    protected int[] _colWidths = new int[]{60, 400, 120, 400};
    protected String[] _cellNames = new String[]{"ZDSS, DSS identifier", "File header size", "DSS Version", "Number of records", "Number Aliases", "File size, words", "Dead space, words", "Number Expansions", "Number Collections", "Number Renamed", "Number Deleted", "Number Aliases Deleted", "File creation date", "Last written date", "Address of Lock word", "Maximum table hash code", "Number of table hash codes used", "Maximum number of pathnames for one table hash code", "Hash code for the maximum number", "Address of hash table", "Number of pathname hash collisions", "Number of pathname bins per block", "Number of bins remaining in current block", "Size of pathname bin, words", "Address of first pathname bin", "Address of next empty pathname bin", "Number of pathname bins used", "Number of full bins", "File password", "Error Occurred", "Error Code", "Catalog sort order sequence number", "Catalog sort order status", "New writes since last sort", "Deletes since last sort", "Size of Sort Order Array", "Number in Sort Order Array", "Address of Sort Order Array", "Minimum space that can be reclaimed", "Maximum reclaimable space in one segment", "Total reclaimable space", "Address of reclaim table", "Address of next reclaim segment", "Number of next reclaim segment", "Maximum number of reclaim segments", "Number reclaim segments used", "Number in reclaim table", "Size of reclaim table", "Number paths from bin reclaimed", "Number of records reclaimed", "Maximum pathname size", "Maximum A part size", "Maximum B part size", "Maximum C part size", "Maximum D part size", "Maximum E part size", "Maximum F part size", "Maximum internal header size (ints)", "Maximum header 2 size (ints)", "Maximum header 3 size (ints)", "Maximum user header size (ints)", "Maximum data 1 size (ints)", "Maximum data 2 size (ints)", "Number records using internal header", "Number records using header 2", "Number records using header 3", "Number records using user header", "Number records using data 1 area", "Number records using data 2 area", "Maximum record size (longs)", "Maximum RTS record size", "Maximum RTD record size", "Maximum ITS record size", "Maximum ITD record size", "Maximum PD record size", "Maximum PDD record size", "Maximum other record size", "Maximum Expected Number of Pathnames", "Number memory errors", "Number address errors", "Number write errors", "Number read errors", "Total errors (prior to squeeze)", "LR Bounding", "LL Bounding", "UR Bounding", "UL Bounding", "Elev Bounding", "De-tune testing", "Lock array sizes", "Address of Write Lock array (not viewable)", "Address of Read Lock array (not viewable)", "Address of the process ID array", "Reserved", "Reserved", "Reserved", "Reserved", "Reserved", "End of Perm Flag (-97531)"};
    protected String[] _infoNames = new String[]{"Info Flag", "Status", "Pathname Length", "Pathname Hash", "Data Type", "Version Number", "Number Expansions", "Expansion Flag", "Last Written Date/Time", "Program", "Date first Value", "Date Last Value", "Record password", "Address Internal Header", "Size Internal Header", "Address Header 2", "Size Header 2", "Address User Header", "Size User Header", "Address of first data area", "Size (ints) first data area", "Address of second data area", "Size (ints) second data area", "Address of third data area", "Size (ints) third data area", "Allocated size data (ints)", "Number of data values", "Logical number of data (users sees)", "Address Alias Pathname", "Reserved", "Pathname"};
    protected String[] _binNames = new String[]{"Pathname hash", "Status", "Pathname length", "Pathname size (int 8)", "Info address", "Data type", "Catalog sort sequence", "Last write time", "Date first value", "Date Last value", "Pathname", "Next pathname hash"};
    protected String[] _headerNamesRTS = new String[]{"Time Granularity Flag", "Precision", "Time offset, in seconds", "Number Profile Depths", "Block position of first valid value", "Block position of last valid value", "Values Array length", "Length of each value, ints", "Length of each value element", "Values Compression Flag", "Quality Array length", "Length of each quality, ints", "Quality Flags Compression Method", "Notes Array length", "Length of each note, ints", "Note Compression Method", "Length Notes String", "Units", "Type", "Time zone"};
    protected String[] _headerNamesPD = new String[]{"Number of Ordinates", "Number of Curves", "X Axis is Independent (bool)", "Lables Length", "Precision"};

    public DebugFileInfo7(HecDataManager dataManager) {
        this._dataManager = dataManager;
        this.initialize(0L, RecordSection.PERM_SECTION);
    }

    public DebugFileInfo7(HecDataManager dataManager, long address, RecordSection section) {
        this._dataManager = dataManager;
        this.initialize(address, section);
    }

    protected void initialize(long address, RecordSection section) {
        Vector rows;
        this._recordSection = section;
        this._start = address;
        if (section == RecordSection.PERM_SECTION) {
            this._numberWords = this._cellNames.length + 2;
            this._numberWords = 100;
            rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
            this.initialize(this._colNames, rows);
        } else if (this._recordSection == RecordSection.INFO_SECTION) {
            this._numberWords = this._infoNames.length + 50;
            rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
            this.initialize(this._colNames, rows);
        } else if (this._recordSection == RecordSection.INTERNAL_HEADER) {
            long[] add = this._dataManager.debugLook7(address += 13L, 1);
            this._numberWords = this._headerNamesRTS.length + 30;
            Vector rows2 = this.getDecodedInfo(this._dataManager, add[0], this._numberWords);
            this.initialize(this._colNames, rows2);
        } else if (this._recordSection == RecordSection.PATHNAME_BIN) {
            this._numberWords = this._binNames.length + 54;
            rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
            this.initialize(this._colNames, rows);
            this._goTo.setText(this._nextString);
        }
        this._table.setEditable(false);
        this._popup = new JPopupMenu();
        this._gotoMenuItem = new JMenuItem("Go To");
        this._gotoMenuItem.addActionListener(e -> this.goToPopup());
        this._popup.add(this._gotoMenuItem);
        this._modifyMenuItem = new JMenuItem("Modify Word");
        this._modifyMenuItem.setEnabled(false);
        this._modifyMenuItem.addActionListener(e -> this.modify());
        this._table.setPopupMenu(this._popup);
        int width = 0;
        for (int i = 0; i < this._colWidths.length; ++i) {
            width += this._colWidths[i];
            TableColumn tc = this._table.getColumnModel().getColumn(i);
            tc.setPreferredWidth(this._colWidths[i]);
        }
        if (this._recordSection != RecordSection.PATHNAME_BIN) {
            this._lowerPanel.setVisible(false);
            this._cmdPanel.setVisible(false);
            this.setSize(width, 800);
            this.setLocation(100, 100);
        } else {
            if (this._previousButton != null) {
                this._previousButton.setVisible(false);
            }
            if (this._nextButton != null) {
                this._nextButton.setVisible(false);
            }
            this.setSize(600, 500);
            this.setLocation(100, 100);
        }
        String title = this.getTitle();
        if (title == null || title.length() < 2) {
            this.setTitle(this._dataManager.DSSFileName());
        }
    }

    @Override
    protected Vector decodeArray(int[] array, long address) {
        int i;
        HecTime hecTime;
        HecTime hecTime2;
        int millis;
        long cdate;
        boolean doubleInteger;
        int npath;
        int jcount;
        int icount;
        Vector originalRows = super.decodeArray(array, address);
        Vector<String[]> rows = new Vector<String[]>();
        if (this._recordSection == RecordSection.INFO_SECTION) {
            icount = 0;
            jcount = 0;
            npath = 0;
            int i2 = 0;
            while (jcount < this._infoNames.length - 1) {
                String[] vals = new String[4];
                String[] decodedVals = (String[])originalRows.elementAt(icount);
                boolean numeric = true;
                boolean date = false;
                boolean julian = false;
                doubleInteger = false;
                vals[0] = Integer.toString(jcount);
                vals[1] = this._infoNames[jcount];
                vals[2] = decodedVals[1];
                if (i2 == 2) {
                    npath = Integer.valueOf(decodedVals[2]);
                } else if (i2 == 4) {
                    doubleInteger = true;
                } else if (i2 == 5) {
                    doubleInteger = true;
                } else if (i2 == 6) {
                    date = true;
                } else if (i2 == 7) {
                    numeric = false;
                } else if (i2 == 8) {
                    julian = true;
                } else if (i2 == 9) {
                    julian = true;
                } else if (i2 == 10) {
                    numeric = false;
                }
                if (date) {
                    cdate = Long.valueOf(decodedVals[2]);
                    long secs = cdate / 1000L;
                    millis = (int)(cdate - secs * 1000L);
                    hecTime2 = new HecTime(0);
                    hecTime2.setSeconds((long)((int)secs));
                    vals[3] = "(" + decodedVals[2] + ")   " + hecTime2.toString(1) + "." + dfmt3.format(millis);
                } else if (julian) {
                    int jul = Integer.valueOf(decodedVals[3]);
                    int secs = Integer.valueOf(decodedVals[4]);
                    int min = secs / 60;
                    hecTime = new HecTime(0);
                    hecTime.setJulian(jul, min, secs -= min * 60);
                    vals[3] = "(" + decodedVals[3] + ", " + decodedVals[4] + ")   " + hecTime.toString(1);
                } else if (doubleInteger) {
                    vals[3] = decodedVals[3];
                    rows.add(vals);
                    vals = new String[]{Integer.toString(++jcount), this._infoNames[jcount], decodedVals[1], decodedVals[4]};
                } else if (numeric) {
                    vals[3] = decodedVals[2];
                } else {
                    vals[3] = decodedVals[8];
                    if (i2 == 7 || i2 == 10) {
                        decodedVals = (String[])originalRows.elementAt(++icount);
                        vals[3] = vals[3] + decodedVals[8];
                    }
                    vals[3] = vals[3].replace('~', ' ');
                }
                rows.add(vals);
                ++icount;
                ++jcount;
                ++i2;
            }
            String[] vals = new String[4];
            String[] decodedVals = (String[])originalRows.elementAt(icount);
            vals[0] = Integer.toString(jcount);
            vals[1] = this._infoNames[jcount];
            vals[2] = decodedVals[1];
            int numb = (npath - 1) / 8 + 1;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < numb; ++i) {
                decodedVals = (String[])originalRows.elementAt(icount++);
                sb.append(decodedVals[8]);
            }
            vals[3] = sb.toString().replace('~', ' ');
            rows.add(vals);
            this.setTitle(vals[3].trim());
        } else if (this._recordSection == RecordSection.PERM_SECTION) {
            int count = 0;
            for (int i3 = 0; i3 < this._cellNames.length; ++i3) {
                String[] vals = new String[4];
                String[] decodedVals = (String[])originalRows.elementAt(count);
                boolean numeric = true;
                boolean date = false;
                boolean password = false;
                boolean useCommas = false;
                vals[0] = Integer.toString(i3);
                vals[1] = this._cellNames[i3];
                vals[2] = decodedVals[1];
                if (i3 == 0) {
                    numeric = false;
                }
                if (i3 == 2) {
                    numeric = false;
                }
                if (i3 == 12) {
                    date = true;
                }
                if (i3 == 13) {
                    date = true;
                }
                if (i3 == 28) {
                    password = true;
                    numeric = false;
                }
                if (i3 >= 3 && i3 <= 11) {
                    useCommas = true;
                }
                if (date) {
                    long cdate2 = Long.valueOf(decodedVals[2]);
                    long secs = cdate2 / 1000L;
                    int millis2 = (int)(cdate2 - secs * 1000L);
                    hecTime = new HecTime(0);
                    hecTime.setSeconds((long)((int)secs));
                    vals[3] = "(" + decodedVals[2] + ")   " + hecTime.toString(1) + "." + dfmt3.format(millis2);
                } else if (numeric) {
                    if (useCommas) {
                        long ival = Long.parseLong(decodedVals[2]);
                        vals[3] = NumberFormat.getNumberInstance().format(ival);
                    } else {
                        vals[3] = decodedVals[2];
                    }
                } else if (password) {
                    vals[3] = decodedVals[8];
                    decodedVals = (String[])originalRows.elementAt(++count);
                    vals[3] = vals[3] + decodedVals[8];
                } else {
                    vals[3] = decodedVals[8];
                }
                rows.add(vals);
                ++count;
            }
        } else if (this._recordSection == RecordSection.INTERNAL_HEADER) {
            boolean numeric;
            icount = 0;
            jcount = 0;
            boolean npath2 = false;
            int recordType = this._dataManager.getRecordInfo().recordType;
            if (recordType >= 100 && recordType < 200) {
                int i4 = 0;
                while (jcount < this._headerNamesRTS.length - 1) {
                    String[] vals = new String[4];
                    String[] decodedVals = (String[])originalRows.elementAt(icount);
                    numeric = true;
                    boolean date = false;
                    doubleInteger = true;
                    vals[0] = Integer.toString(jcount);
                    vals[1] = this._headerNamesRTS[jcount];
                    vals[2] = decodedVals[1];
                    if (date) {
                        cdate = Long.valueOf(decodedVals[2]);
                        long secs = cdate / 1000L;
                        millis = (int)(cdate - secs * 1000L);
                        hecTime2 = new HecTime(0);
                        hecTime2.setSeconds((long)((int)secs));
                        vals[3] = "(" + decodedVals[2] + ")   " + hecTime2.toString(1) + "." + dfmt3.format(millis);
                    }
                    if (doubleInteger) {
                        vals[3] = decodedVals[3];
                        rows.add(vals);
                        vals = new String[]{Integer.toString(++jcount), this._headerNamesRTS[jcount], decodedVals[1], decodedVals[4]};
                    } else if (numeric) {
                        vals[3] = decodedVals[2];
                    } else {
                        vals[3] = decodedVals[8];
                        if (i4 == 12 || i4 == 14) {
                            decodedVals = (String[])originalRows.elementAt(++icount);
                            vals[3] = vals[3] + decodedVals[8];
                            decodedVals = (String[])originalRows.elementAt(++icount);
                            vals[3] = vals[3] + decodedVals[8];
                        }
                    }
                    rows.add(vals);
                    ++icount;
                    ++jcount;
                    ++i4;
                }
            } else {
                int i5 = 0;
                while (jcount < this._headerNamesPD.length) {
                    String[] vals = new String[4];
                    String[] decodedVals = (String[])originalRows.elementAt(icount);
                    numeric = false;
                    boolean doubleInteger2 = true;
                    boolean singleInteger = false;
                    vals[0] = Integer.toString(jcount);
                    vals[1] = this._headerNamesPD[jcount];
                    vals[2] = decodedVals[1];
                    if (jcount > 3) {
                        doubleInteger2 = false;
                    }
                    if (jcount == 4) {
                        singleInteger = true;
                    }
                    if (doubleInteger2) {
                        vals[3] = decodedVals[3];
                        rows.add(vals);
                        vals = new String[]{Integer.toString(++jcount), this._headerNamesPD[jcount], decodedVals[1], decodedVals[4]};
                    } else if (singleInteger) {
                        vals[3] = decodedVals[3];
                    } else if (numeric) {
                        vals[3] = decodedVals[2];
                    } else {
                        vals[3] = decodedVals[8];
                        if (i5 == 12 || i5 == 14) {
                            decodedVals = (String[])originalRows.elementAt(++icount);
                            vals[3] = vals[3] + decodedVals[8];
                            decodedVals = (String[])originalRows.elementAt(++icount);
                            vals[3] = vals[3] + decodedVals[8];
                        }
                    }
                    rows.add(vals);
                    ++icount;
                    ++jcount;
                    ++i5;
                }
            }
        }
        if (this._recordSection == RecordSection.PATHNAME_BIN) {
            icount = 0;
            jcount = 0;
            npath = 0;
            int i6 = 0;
            while (jcount < this._binNames.length - 2) {
                String[] vals = new String[4];
                String[] decodedVals = (String[])originalRows.elementAt(icount);
                boolean numeric = true;
                boolean julian = false;
                boolean doubleInteger3 = false;
                boolean date = false;
                vals[0] = Integer.toString(jcount);
                vals[1] = this._binNames[jcount];
                vals[2] = decodedVals[1];
                if (i6 == 2) {
                    doubleInteger3 = true;
                } else if (i6 == 4) {
                    doubleInteger3 = true;
                } else if (i6 == 5) {
                    date = true;
                } else if (i6 == 6) {
                    julian = true;
                } else if (i6 == 7) {
                    numeric = false;
                }
                if (julian) {
                    int jul = Integer.valueOf(decodedVals[3]);
                    HecTime hecTime3 = new HecTime();
                    hecTime3.setJulian(jul, 1, 0);
                    vals[3] = "(" + decodedVals[3] + ")   " + hecTime3.date(1);
                    rows.add(vals);
                    vals = new String[]{Integer.toString(++jcount), this._binNames[jcount], decodedVals[1], decodedVals[4]};
                    jul = Integer.valueOf(vals[3]);
                    hecTime3.setJulian(jul, 1, 0);
                    vals[3] = "(" + vals[3] + ")   " + hecTime3.date(1);
                } else if (date) {
                    long cdate3 = Long.valueOf(decodedVals[2]);
                    long secs = cdate3 / 1000L;
                    millis = (int)(cdate3 - secs * 1000L);
                    hecTime2 = new HecTime(0);
                    hecTime2.setSeconds((long)((int)secs));
                    vals[3] = "(" + decodedVals[2] + ")   " + hecTime2.toString(1) + "." + dfmt3.format(millis);
                } else if (doubleInteger3) {
                    vals[3] = decodedVals[3];
                    rows.add(vals);
                    if (jcount == 2) {
                        npath = Integer.valueOf(decodedVals[3]);
                    }
                    vals = new String[]{Integer.toString(++jcount), this._binNames[jcount], decodedVals[1], decodedVals[4]};
                } else if (numeric) {
                    vals[3] = decodedVals[2];
                } else {
                    vals[3] = decodedVals[8];
                    if (i6 == 6 || i6 == 9) {
                        decodedVals = (String[])originalRows.elementAt(++icount);
                        vals[3] = vals[3] + decodedVals[8];
                    }
                    vals[3] = vals[3].replace('~', ' ');
                }
                rows.add(vals);
                ++icount;
                ++jcount;
                ++i6;
            }
            String[] vals = new String[4];
            String[] decodedVals = (String[])originalRows.elementAt(icount);
            vals[0] = Integer.toString(jcount);
            vals[1] = this._binNames[jcount];
            vals[2] = decodedVals[1];
            StringBuffer sb = new StringBuffer();
            if (npath > 0 && npath < 400) {
                int numb = (npath - 1) / 8 + 1;
                for (i = 0; i < numb; ++i) {
                    decodedVals = (String[])originalRows.elementAt(icount++);
                    sb.append(decodedVals[8]);
                }
            }
            vals[3] = sb.toString().replace('~', ' ');
            rows.add(vals);
            this.setTitle(vals[3].trim());
            vals = new String[4];
            decodedVals = (String[])originalRows.elementAt(icount);
            vals[0] = Integer.toString(++jcount);
            vals[1] = this._binNames[jcount];
            vals[2] = decodedVals[1];
            vals[3] = decodedVals[2];
            rows.add(vals);
            this._nextString = vals[2];
        }
        return rows;
    }

    @Override
    protected void goTo() {
        String s = this._goTo.getText();
        this.go(s);
        if (this._recordSection == RecordSection.PATHNAME_BIN) {
            this._goTo.setText(this._nextString);
        }
    }

    @Override
    protected void previous() {
        System.out.println("***  I DONt WORK ****");
        if (this._start != 0L) {
            return;
        }
        this._start -= (long)this._numberWords;
        if (this._dataManager != null) {
            if (this._start < 1L) {
                this._start = 1L;
            }
        } else if (this._start < 1L) {
            this._start = 0L;
        }
        Vector rows = this.getDecodedInfo(this._dataManager, this._start, this._numberWords);
        this.setRows(rows);
    }

    @Override
    protected void goToPopup() {
        long address;
        String s = this._table.getSelectedCellData().toString();
        this._table.clearSelection();
        try {
            address = Long.parseLong(s);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid number provided");
            return;
        }
        DebugExamineFile7 frame = new DebugExamineFile7(this._dataManager, address, 30);
        frame.setVisible(true);
    }

    protected static enum RecordSection {
        PERM_SECTION,
        INFO_SECTION,
        INTERNAL_HEADER,
        PATHNAME_BIN;

    }
}

