/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.heclib.util.stringContainer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;

public class DebugUtility {
    private DebugUtility() throws Exception {
        throw new Exception("Utility class");
    }

    private static double combineIntegersIntoDouble(int int1, int int2) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putInt(int2);
        bb.putInt(int1);
        bb.flip();
        long longValue = bb.getLong();
        return Double.longBitsToDouble(longValue);
    }

    private static byte[] convertIntToBytes(int int1) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(int1);
        byte[] raw = bb.array();
        byte[] rval = new byte[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            rval[i] = raw[raw.length - 1 - i];
        }
        return rval;
    }

    private static String convertIntToHollerith(int value) {
        byte[] data;
        StringBuilder sb = new StringBuilder();
        for (byte c : data = DebugUtility.convertIntToBytes(value)) {
            sb.append(c < 32 || c > 126 ? (char)'~' : (char)c);
        }
        return sb.toString();
    }

    protected static synchronized void ConvertToVariousFormats(int[] value, long[] lvalue8, int[] value4a, int[] value4b, stringContainer cstringDouble, stringContainer cstringReala, stringContainer cstringRealb, stringContainer cstringValue, int[] ibytes) {
        lvalue8[0] = DebugUtility.i4toi8(value[0], value[1]);
        value4a[0] = value[0];
        value4b[0] = value[1];
        double d = DebugUtility.combineIntegersIntoDouble(value[0], value[1]);
        DecimalFormat df = new DecimalFormat("0.00");
        cstringDouble.string = df.format(d);
        float fa = Float.intBitsToFloat(value[0]);
        float fb = Float.intBitsToFloat(value[1]);
        cstringReala.string = df.format(fa);
        cstringRealb.string = df.format(fb);
        byte[] ba = DebugUtility.convertIntToBytes(value[0]);
        byte[] bb = DebugUtility.convertIntToBytes(value[1]);
        for (int i = 0; i < 4; ++i) {
            ibytes[i] = Byte.toUnsignedInt(ba[i]);
            ibytes[i + 4] = Byte.toUnsignedInt(bb[i]);
        }
        cstringValue.string = DebugUtility.convertIntToHollerith(value[0]) + DebugUtility.convertIntToHollerith(value[1]);
    }

    public static synchronized long i4toi8(int int4a, int int4b) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(0, int4b);
        buf.putInt(4, int4a);
        return buf.getLong();
    }

    public static synchronized void i8toi4(long integer8, int[] int4a, int[] int4b) {
        if (int4a == null || int4a.length == 0) {
            throw new RuntimeException("Parameter int4a is null or zero-length");
        }
        if (int4b == null || int4b.length == 0) {
            throw new RuntimeException("Parameter int4b is null or zero-length");
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(integer8);
        int4a[0] = buf.getInt(4);
        int4b[0] = buf.getInt(0);
    }
}

