/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.dssgui.Help;
import hec.dssgui.ListSelection;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.util.HecDouble;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class DssMetaDataDialog
extends RmaJDialog {
    private static final Logger logger = Logger.getLogger(DssMetaDataDialog.class.getName());
    private RmaJComboBox _pathCombo;
    private JTextArea _supplementalInfo;
    private RmaJDecimalField _xOrdinateFld;
    private RmaJDecimalField _yOrdinateFld;
    private RmaJDecimalField _zOrdinateFld;
    private RmaJComboBox _coordinateSystemCombo;
    private RmaJIntegerField _coordinateIDFld;
    private RmaJComboBox _horizontalUnitsCombo;
    private RmaJComboBox _horizontalDatumCombo;
    private JTextField _typeField;
    private JTextField _recTypeField;
    private JTextField _lastWrittenField;
    private JTextField _programNameField;
    private JTextField _recordTagField;
    private JTextField _versionField;
    private JTextField _precisionField;
    private JTextField _displayPrecisionField;
    private JTextField _passwordProtectedField;
    private JTextField _compressionField;
    private ButtonCmdPanel _cmdPanel;
    private DataContainerHolder _dc;
    private ListSelection _listSelection;
    private String _title;
    private JLabel _timeZoneIdLabel;
    private RmaJTextField _timeZoneIdFld;
    private JTextField _verticalDatumField;
    private JTextField _verticalDatumUnitsField;
    private RmaJDecimalField _shiftNAVD88Field;
    private RmaJDecimalField _shiftNGVD29Field;
    private VerticalDatumContainer _verticalDatum;
    private JLabel _labelNAVD88;
    private JLabel _labelNGVD29;

    public DssMetaDataDialog(ListSelection parent) {
        super((Frame)parent, false);
        this._listSelection = parent;
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setLocationRelativeTo(this._listSelection);
        Help.setHelp((RootPaneContainer)((Object)this), "27");
    }

    protected void buildControls() {
        this._title = "Location and Supplemental Information";
        this.setTitle(this._title);
        Color backgroundColor = new Color(245, 245, 245);
        this.getContentPane().setLayout(new GridBagLayout());
        int gridy = 0;
        JLabel label = new JLabel("Data Set:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._pathCombo = new RmaJComboBox();
        this._pathCombo.setModifiable(false);
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._pathCombo, gbc);
        label = new JLabel("Record Type:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._recTypeField = new JTextField();
        this._recTypeField.setEditable(false);
        this._recTypeField.setBackground(backgroundColor);
        label.setLabelFor(this._recTypeField);
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._recTypeField, gbc);
        label = new JLabel("Last Written:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._lastWrittenField = new JTextField();
        this._lastWrittenField.setEditable(false);
        this._lastWrittenField.setBackground(backgroundColor);
        label.setLabelFor(this._lastWrittenField);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._lastWrittenField, gbc);
        label = new JLabel("By Program:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._programNameField = new JTextField();
        this._programNameField.setEditable(false);
        this._programNameField.setBackground(backgroundColor);
        label.setLabelFor(this._programNameField);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._programNameField, gbc);
        label = new JLabel("Record tag:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._recordTagField = new JTextField();
        this._recordTagField.setEditable(false);
        this._recordTagField.setBackground(backgroundColor);
        label.setLabelFor(this._recordTagField);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._recordTagField, gbc);
        label = new JLabel("Version:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._versionField = new JTextField();
        this._versionField.setEditable(false);
        this._versionField.setBackground(backgroundColor);
        label.setLabelFor(this._versionField);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._versionField, gbc);
        label = new JLabel("Precision:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._precisionField = new JTextField();
        this._precisionField.setEditable(false);
        this._precisionField.setBackground(backgroundColor);
        label.setLabelFor(this._precisionField);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._precisionField, gbc);
        label = new JLabel("Display Precision:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._displayPrecisionField = new JTextField();
        this._displayPrecisionField.setEditable(false);
        this._displayPrecisionField.setBackground(backgroundColor);
        label.setLabelFor(this._displayPrecisionField);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._displayPrecisionField, gbc);
        label = new JLabel("Compression:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._compressionField = new JTextField();
        this._compressionField.setEditable(false);
        this._compressionField.setBackground(backgroundColor);
        label.setLabelFor(this._compressionField);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._compressionField, gbc);
        label = new JLabel("Password Protected:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._passwordProtectedField = new JTextField();
        this._passwordProtectedField.setEditable(false);
        this._passwordProtectedField.setBackground(backgroundColor);
        label.setLabelFor(this._passwordProtectedField);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._passwordProtectedField, gbc);
        label = new JLabel("Type:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._typeField = new JTextField();
        this._typeField.setEditable(false);
        this._typeField.setBackground(backgroundColor);
        label.setLabelFor(this._typeField);
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._typeField, gbc);
        JSeparator sep = new JSeparator();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)sep, gbc);
        label = new JLabel("Notes:");
        label.setDisplayedMnemonic('S');
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        String toolTip = "<html>Supplemental Info is any additional information that describes this data or location<br>It <b>MUST</b> be in a <i>Keyword:Item;</i> format.  The keyword is separated from the item<br>by a colon <b>:</b>, and the item is terminated by a simi-colon <b>;</b><br>Items may or may not be a number.<br>Keyword1:Item1;Keyword2:Item2;Keyword3:Item3;<br>Examples:<br>Offset:1.2;Shift:3.4;Datum:5.6;Transform:LogLog;</html>";
        this._supplementalInfo = new RmaJTextArea(5, 40){

            public String getToolTipText(MouseEvent e) {
                return "<html>Supplemental Info is any additional information that describes this data or location<br>It <b>MUST</b> be in a <i>Keyword:Item;</i> format.  The keyword is separated from the item<br>by a colon <b>:</b>, and the item is terminated by a simi-colon <b>;</b><br>Items may or may not be a number.<br>Keyword1:Item1;Keyword2:Item2;Keyword3:Item3;<br>Examples:<br>Offset:1.2;Shift:3.4;Datum:5.6;Transform:LogLog;</html>";
            }

            public String getToolTipText() {
                return "<html>Supplemental Info is any additional information that describes this data or location<br>It <b>MUST</b> be in a <i>Keyword:Item;</i> format.  The keyword is separated from the item<br>by a colon <b>:</b>, and the item is terminated by a simi-colon <b>;</b><br>Items may or may not be a number.<br>Keyword1:Item1;Keyword2:Item2;Keyword3:Item3;<br>Examples:<br>Offset:1.2;Shift:3.4;Datum:5.6;Transform:LogLog;</html>";
            }
        };
        this._supplementalInfo.setToolTipText(" ");
        label.setLabelFor(this._supplementalInfo);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this._supplementalInfo.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(this._supplementalInfo), gbc);
        sep = new JSeparator();
        gbc.gridx = 0;
        gbc.gridy = gridy += 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)sep, gbc);
        label = new JLabel("Coordinate System:");
        label.setDisplayedMnemonic('C');
        gbc.gridx = 0;
        gbc.gridy = gridy += 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        Vector<String> list = new Vector<String>(6);
        list.add("No Coordinates set");
        list.add("Lat/long");
        list.add("State Plane, FIPS");
        list.add("State Plane, ADS");
        list.add("UTM");
        list.add("Local (other)");
        this._coordinateSystemCombo = new RmaJComboBox(list);
        this._coordinateSystemCombo.setModifiable(true);
        label.setLabelFor((Component)this._coordinateSystemCombo);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._coordinateSystemCombo, gbc);
        label = new JLabel("Coordinate ID:");
        label.setDisplayedMnemonic('o');
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._coordinateIDFld = new RmaJIntegerField();
        label.setLabelFor((Component)this._coordinateIDFld);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._coordinateIDFld, gbc);
        label = new JLabel("Horizontal Datum:");
        label.setDisplayedMnemonic('H');
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        list = new Vector();
        list.add("unset");
        list.add("NAD83");
        list.add("NAD27");
        list.add("WGS84");
        list.add("WGS72");
        list.add("Local (other)");
        this._horizontalDatumCombo = new RmaJComboBox(list);
        this._horizontalDatumCombo.setModifiable(true);
        label.setLabelFor((Component)this._horizontalDatumCombo);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._horizontalDatumCombo, gbc);
        label = new JLabel("Datum Units:");
        label.setDisplayedMnemonic('D');
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        list = new Vector(3);
        list.add("Not Specified");
        list.add("English");
        list.add("SI");
        list.add("Decimal Degrees");
        list.add("Degrees Minutes Seconds");
        this._horizontalUnitsCombo = new RmaJComboBox(list);
        this._horizontalUnitsCombo.setModifiable(true);
        label.setLabelFor((Component)this._horizontalUnitsCombo);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._horizontalUnitsCombo, gbc);
        label = new JLabel("X Coordinate:");
        label.setDisplayedMnemonic('X');
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._xOrdinateFld = new RmaJDecimalField();
        label.setLabelFor((Component)this._xOrdinateFld);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._xOrdinateFld, gbc);
        label = new JLabel("Y Coordinate:");
        label.setDisplayedMnemonic('Y');
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._yOrdinateFld = new RmaJDecimalField();
        label.setLabelFor((Component)this._yOrdinateFld);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._yOrdinateFld, gbc);
        sep = new JSeparator();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)sep, gbc);
        label = new JLabel("Vertical Datum:");
        label.setDisplayedMnemonic('V');
        gbc.gridx = 0;
        gbc.gridy = ++gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._verticalDatumField = new JTextField();
        this._verticalDatumField.setEditable(false);
        label.setLabelFor(this._verticalDatumField);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._verticalDatumField, gbc);
        label = new JLabel("Vertical Datum Units:");
        label.setDisplayedMnemonic('L');
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._verticalDatumUnitsField = new JTextField();
        this._verticalDatumUnitsField.setEditable(false);
        label.setLabelFor(this._verticalDatumUnitsField);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._verticalDatumUnitsField, gbc);
        this._labelNAVD88 = new JLabel(this.getNAVD88Label());
        this._labelNAVD88.setDisplayedMnemonic('X');
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._labelNAVD88, gbc);
        this._shiftNAVD88Field = new RmaJDecimalField();
        this._shiftNAVD88Field.setEditable(false);
        this._labelNAVD88.setLabelFor((Component)this._shiftNAVD88Field);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._shiftNAVD88Field, gbc);
        this._labelNGVD29 = new JLabel(this.getNGVD29Label());
        this._labelNGVD29.setDisplayedMnemonic('Y');
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._labelNGVD29, gbc);
        this._shiftNGVD29Field = new RmaJDecimalField();
        this._shiftNGVD29Field.setEditable(false);
        this._labelNGVD29.setLabelFor((Component)this._shiftNGVD29Field);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._shiftNGVD29Field, gbc);
        sep = new JSeparator();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)sep, gbc);
        this._timeZoneIdLabel = new JLabel("Time Zone ID:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._timeZoneIdLabel, gbc);
        this._timeZoneIdFld = new RmaJTextField();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._timeZoneIdFld, gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = 0;
        gbc.gridy = gridy += 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 4;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        DssMetaDataDialog.this.saveForm();
                        DssMetaDataDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        DssMetaDataDialog.this.setVisible(false);
                    }
                }
            }
        });
        this._pathCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    DssMetaDataDialog.this.saveDataContainer();
                    return;
                }
                DataContainerHolder dch = (DataContainerHolder)DssMetaDataDialog.this._pathCombo.getSelectedItem();
                DssMetaDataDialog.this.fillForm(dch);
            }
        });
    }

    protected void saveDataContainer() {
        if (this.isModified() && this._dc != null) {
            this._dc.dataContainer.supplementalInfo = this._supplementalInfo.getText();
            this._dc.dataContainer.coordinateSystem = this._coordinateSystemCombo.getSelectedIndex();
            this._dc.dataContainer.coordinateID = this._coordinateIDFld.getValue();
            this._dc.dataContainer.horizontalDatum = this._horizontalDatumCombo.getSelectedIndex();
            this._dc.dataContainer.horizontalUnits = this._horizontalUnitsCombo.getSelectedIndex();
            this._dc.dataContainer.xOrdinate = this._xOrdinateFld.getValue();
            this._dc.dataContainer.yOrdinate = this._yOrdinateFld.getValue();
            if (this._dc.dataContainer instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)this._dc.dataContainer;
                tsc.timeZoneID = this._timeZoneIdFld.getText();
                tsc.timeZoneRawOffset = 0;
            }
            if (this._verticalDatum != null) {
                try {
                    this._dc.dataContainer.insertVerticalDatum(this._verticalDatum);
                }
                catch (IOException | VerticalDatumException e) {
                    logger.log(Level.WARNING, "Failed to set Vertical Datum", e);
                }
            }
            this._dc.modified = true;
        } else if (this._dc.dataContainer instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)this._dc.dataContainer;
            String timeZoneId = this._timeZoneIdFld.getText();
            if (tsc.timeZoneID != null && !timeZoneId.equals(tsc.timeZoneID)) {
                tsc.timeZoneID = timeZoneId;
                tsc.timeZoneRawOffset = 0;
                this._dc.modified = true;
            }
        }
    }

    protected void saveForm() {
        this.saveDataContainer();
        RmaListModel model = (RmaListModel)this._pathCombo.getModel();
        Vector<DataContainer> modifiedDataContainers = new Vector<DataContainer>();
        for (int i = 0; i < model.getSize(); ++i) {
            DataContainerHolder dch = (DataContainerHolder)model.get(i);
            if (!dch.modified) continue;
            modifiedDataContainers.add(dch.dataContainer);
        }
        if (modifiedDataContainers.size() > 0) {
            this._listSelection.save(modifiedDataContainers);
        }
    }

    public void fillForm(List dataContainers) {
        this.clearForm();
        RmaListModel model = new RmaListModel(false);
        for (int i = 0; i < dataContainers.size(); ++i) {
            model.addElement((Object)new DataContainerHolder((DataContainer)dataContainers.get(i)));
        }
        this._pathCombo.setModel((ComboBoxModel)model);
        this._pathCombo.setSelectedIndex(0);
    }

    public void fillForm(DataContainerHolder dc) {
        this._dc = dc;
        if (dc == null) {
            this.clearForm();
            this.setModified(false);
            return;
        }
        try {
            this._verticalDatum = dc.dataContainer.extractVerticalDatum();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to extract Vertical Datum", e);
        }
        if (dc.dataContainer.otherInfo instanceof HecDSSRecordInfo) {
            HecDSSRecordInfo ri = (HecDSSRecordInfo)dc.dataContainer.otherInfo;
            if (ri.lastWrittenTime == null || ri.programName == null) {
                return;
            }
            String type = Integer.toString(ri.recordType) + ":  " + ri.recordTypeDescription;
            this._recTypeField.setText(type);
            if (dc.dataContainer instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc.dataContainer;
                if (tsc.type != null) {
                    this._typeField.setText(tsc.type);
                }
            }
            this._lastWrittenField.setText(ri.lastWrittenTime.toString(8));
            this._programNameField.setText(ri.programName);
            this._recordTagField.setText(ri.recordTag);
            this._versionField.setText(Integer.toString(ri.version));
            if (ri.doubles) {
                this._precisionField.setText("Double");
            } else {
                this._precisionField.setText("Regular");
            }
            String dp = DssMetaDataDialog.getDisplayPrecision(ri.precision, ri.recordType);
            this._displayPrecisionField.setText(dp);
            if (ri.timeSeriesCompression > 0) {
                this._compressionField.setText(Integer.toString(ri.timeSeriesCompression));
            } else {
                this._compressionField.setText("None");
            }
            if (ri.passwordProtected) {
                this._passwordProtectedField.setText("Yes");
            } else {
                this._passwordProtectedField.setText("No");
            }
        }
        if (dc.dataContainer.supplementalInfo != null) {
            VerticalDatumContainer vdc = null;
            try {
                vdc = dc.dataContainer.extractVerticalDatum();
                dc.dataContainer.insertVerticalDatum(null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to remove Vertical Datum from supplemental info", e);
            }
            this._supplementalInfo.setText(dc.dataContainer.supplementalInfo);
            if (vdc != null) {
                try {
                    dc.dataContainer.insertVerticalDatum(vdc);
                }
                catch (IOException | VerticalDatumException e) {
                    logger.log(Level.WARNING, "Failed to insert Vertical Datum", e);
                }
            }
        }
        this._coordinateSystemCombo.setSelectedIndex(this._dc.dataContainer.coordinateSystem);
        this._coordinateIDFld.setValue(this._dc.dataContainer.coordinateID);
        this._horizontalDatumCombo.setSelectedIndex(this._dc.dataContainer.horizontalDatum);
        this._horizontalUnitsCombo.setSelectedIndex(this._dc.dataContainer.horizontalUnits);
        this._xOrdinateFld.setValue(this._dc.dataContainer.xOrdinate);
        this._yOrdinateFld.setValue(this._dc.dataContainer.yOrdinate);
        if (this._dc.dataContainer instanceof TimeSeriesContainer) {
            this._timeZoneIdFld.setEnabled(true);
            this._timeZoneIdLabel.setEnabled(true);
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc.dataContainer;
            this._timeZoneIdFld.setText(tsc.timeZoneID);
        } else {
            this._timeZoneIdFld.setText("");
            this._timeZoneIdFld.setEnabled(false);
            this._timeZoneIdLabel.setEnabled(false);
        }
        if (this._verticalDatum != null) {
            this.fillVerticalDatum();
        }
        this.setModified(this._dc.modified);
    }

    private void fillVerticalDatumValues() {
        try {
            double navd88 = Units.convertUnits((double)this._verticalDatum.getNAVD88Offset(), (String)this._verticalDatum.unit, (String)this.getVerticalDisplayUnit());
            this._shiftNAVD88Field.setValue(navd88);
        }
        catch (UnitsConversionException | VerticalDatumException ex) {
            this._shiftNAVD88Field.setText("");
        }
        try {
            double ngvd29 = Units.convertUnits((double)(this._verticalDatum.getNAVD88Offset() - this._verticalDatum.getNGVD29Offset()), (String)this._verticalDatum.unit, (String)this.getVerticalDisplayUnit());
            this._shiftNGVD29Field.setValue(ngvd29);
        }
        catch (UnitsConversionException | VerticalDatumException ex) {
            this._shiftNGVD29Field.setText("");
        }
    }

    private void fillVerticalDatum() {
        try {
            this._verticalDatumField.setText(this._verticalDatum.getCurrentVerticalDatum());
            this._verticalDatumUnitsField.setText(this._verticalDatum.unit);
            this.fillVerticalDatumValues();
            this._labelNAVD88.setText(this.getNAVD88Label());
            this._labelNGVD29.setText(this.getNGVD29Label());
        }
        catch (VerticalDatumException e) {
            logger.log(Level.WARNING, "Failed to get Vertical Datum", e);
        }
    }

    public void setModified(boolean b) {
        super.setModified(b);
        this.setTitle(this._title + (b ? "*" : ""));
    }

    public static String getDisplayPrecision(int precision, int recordType) {
        if (precision < 1) {
            return "Not Specified";
        }
        if (recordType >= 200 && recordType < 300) {
            int xprecision = precision / 10;
            int yprecision = precision - xprecision * 10;
            return HecDouble.formatPattern((int)xprecision) + ", " + HecDouble.formatPattern((int)yprecision);
        }
        return HecDouble.formatPattern((int)precision);
    }

    private String getVerticalDisplayUnit() {
        String unitStr;
        String string = unitStr = this._verticalDatum != null ? this._verticalDatum.unit : "";
        if (Units.isValidUnitsSystem((int)this._listSelection.getUnitSystem())) {
            try {
                Parameter elev = new Parameter("Elev");
                unitStr = elev.getUnitsStringForSystem(this._listSelection.getUnitSystem());
            }
            catch (DataSetIllegalArgumentException e) {
                logger.log(Level.WARNING, "Failed to get parameter for Elev", e);
            }
        }
        return unitStr;
    }

    private String getNAVD88Label() {
        String unitStr = "(" + this.getVerticalDisplayUnit() + ")";
        return "Shift to NAVD88" + unitStr + ":";
    }

    private String getNGVD29Label() {
        String unitStr = "(" + this.getVerticalDisplayUnit() + ")";
        return "Shift to NAVD88 from NGVD29" + unitStr + ":";
    }

    private class DataContainerHolder {
        DataContainer dataContainer;
        boolean modified;

        public DataContainerHolder(DataContainer dc) {
            this.dataContainer = dc;
        }

        public String toString() {
            return this.dataContainer.fullName;
        }
    }
}

