/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ListSelection;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.util.HecDouble;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class DssVueProgressBar
extends JDialog
implements ActionListener {
    protected JProgressBar _taskProgressBar;
    protected JProgressBar _overallProgressBar;
    protected JLabel filenameText;
    protected JLabel toFilenameText;
    protected JLabel stepText;
    protected JLabel statusText;
    protected JLabel timeLeftText;
    protected JLabel taskTimeText;
    protected JLabel totalTimeText;
    protected JLabel errorText;
    protected JButton cancelButton;
    protected JButton skipButton;
    protected Timer timer;
    protected int totalNumber;
    protected boolean firstDoneMessage = false;
    protected long startTime;
    protected long taskStart;
    protected int count;
    protected int _taskNumber;
    protected int _numberTasks;
    protected int _operation;
    protected String _taskName = "";
    protected int[] numberRecs = new int[1];
    protected int[] currentRec = new int[1];
    protected int _numberErrors = 0;
    protected int _taskErrors = 0;
    protected int _numberDifferences = 0;
    protected int _maximumErrors = 99999;
    protected boolean _done;
    protected ListSelection _listSelection;

    public DssVueProgressBar(ListSelection listSelection, int operation, int numberTasks, String title) {
        this(listSelection, operation, numberTasks, title, true);
    }

    public DssVueProgressBar(ListSelection listSelection, int operation, String secondFile, String title) {
        this(listSelection, operation, 1, title, secondFile, true);
    }

    public DssVueProgressBar(ListSelection listSelection, int operation, int numberTasks, String title, boolean makeVisible) {
        this(listSelection, operation, numberTasks, title, "", makeVisible);
    }

    public DssVueProgressBar(ListSelection listSelection, int operation, int numberTasks, String title, String secondFile, boolean makeVisible) {
        super((Frame)listSelection, false);
        this._listSelection = listSelection;
        this._operation = operation;
        this._numberTasks = numberTasks;
        this._taskNumber = 1;
        this._numberErrors = 0;
        this._taskErrors = 0;
        this._listSelection._dataManager.clearStatus();
        this._done = false;
        this.setTitle(title);
        this.setDefaultCloseOperation(0);
        this.getProgress();
        this.totalNumber = operation == 2 || operation == 3 || operation == 9 || operation == 10 ? this._listSelection._dataManager.numberRecords() : 1;
        this.filenameText = new JLabel();
        this.filenameText.setText("File:                                      ");
        this.filenameText.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.toFilenameText = new JLabel();
        this.toFilenameText.setText("To:                                        ");
        this.toFilenameText.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.stepText = new JLabel();
        this.stepText.setText("Proecss:    ");
        this.stepText.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.statusText = new JLabel();
        this.statusText.setText("Status:        ");
        this.statusText.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.timeLeftText = new JLabel();
        this.timeLeftText.setText("Time Left:     ");
        this.timeLeftText.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.taskTimeText = new JLabel();
        this.taskTimeText.setText("Task Time:     ");
        this.taskTimeText.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        this.totalTimeText = new JLabel();
        this.totalTimeText.setText("Total Time:     ");
        this.totalTimeText.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.errorText = new JLabel();
        this.errorText.setText("   ");
        this.errorText.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this._taskProgressBar = new JProgressBar(0, 100);
        this._taskProgressBar.setValue(0);
        if (this._numberTasks > 1) {
            this._taskProgressBar.setString("Task");
        }
        this._taskProgressBar.setStringPainted(true);
        this._taskProgressBar.setPreferredSize(new Dimension(320, 20));
        this._overallProgressBar = new JProgressBar(0, 100);
        this._overallProgressBar.setValue(0);
        this._overallProgressBar.setString("Overall");
        this._overallProgressBar.setStringPainted(true);
        this._overallProgressBar.setPreferredSize(new Dimension(300, 20));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.skipButton = new JButton("Skip Task");
        this.skipButton.addActionListener(this);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        contentPane.add((Component)this.filenameText, gbc);
        gbc.gridy = gridy++;
        contentPane.add((Component)this.filenameText, gbc);
        if (this._numberTasks > 1) {
            gbc.gridy = gridy++;
            contentPane.add((Component)this.stepText, gbc);
        }
        if (secondFile.length() > 0) {
            this.toFilenameText.setText("To:            " + secondFile);
            gbc.gridy = gridy++;
            contentPane.add((Component)this.toFilenameText, gbc);
        }
        gbc.gridy = gridy++;
        contentPane.add((Component)this.statusText, gbc);
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        contentPane.add((Component)this.timeLeftText, gbc);
        if (this._numberTasks > 1) {
            gbc.gridx = 1;
            contentPane.add((Component)this.taskTimeText, gbc);
            gbc.gridx = 0;
        }
        gbc.gridy = gridy++;
        gbc.gridwidth = 2;
        contentPane.add((Component)this.totalTimeText, gbc);
        gbc.gridy = gridy++;
        contentPane.add((Component)this.errorText, gbc);
        gbc.insets = new Insets(6, 0, 0, 0);
        gbc.gridy = gridy++;
        contentPane.add((Component)this._taskProgressBar, gbc);
        if (this._numberTasks > 1) {
            gbc.gridy = gridy++;
            contentPane.add((Component)this._overallProgressBar, gbc);
        }
        JPanel panel = new JPanel();
        if (this._numberTasks > 1) {
            panel.add(this.skipButton);
        }
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(15, 0, 0, 0);
        gbc.fill = 0;
        gbc.anchor = 13;
        panel.add(this.cancelButton);
        contentPane.add((Component)panel, gbc);
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        if (this._numberTasks > 1) {
            contentPane.setSize(new Dimension(600, 320));
        } else {
            contentPane.setSize(new Dimension(400, 300));
        }
        this.setContentPane(contentPane);
        this._taskProgressBar.setValue(0);
        this.filenameText.setText("File:           " + this._listSelection._dataManager.DSSFileName());
        if (this._numberTasks > 1) {
            this.stepText.setText("Process:    " + this._taskName);
        }
        this.statusText.setText("Status:       0  of  " + this.totalNumber);
        this.pack();
        this.setLocation(100, 100);
        this.setVisible(makeVisible);
    }

    public void setTask(int taskNumber, int numberErrors, String taskName) {
        this._listSelection.clearStatus();
        this._taskNumber = taskNumber;
        this._taskName = taskName;
        this.stepText.setText("Process:    " + this._taskName);
        this.count = 0;
        this.taskStart = 0L;
        this._numberErrors = numberErrors;
        this._taskErrors = 0;
        this.currentRec[0] = 0;
        this.displayProgress();
    }

    public void go() {
        this.count = 0;
        this.startTime = 0L;
        this.taskStart = 0L;
        this.timer = new Timer(200, this);
        this.timer.start();
    }

    public void done(int numberErrors) {
        if (this._done) {
            return;
        }
        this._done = true;
        if (this.timer != null) {
            this.timer.stop();
        }
        this._numberErrors = numberErrors;
        this._taskNumber = this._numberTasks;
        this._taskErrors = 0;
        if (this._operation == 2 || this._operation == 3 || this._operation == 9 || this._operation == 10) {
            this.currentRec[0] = this.totalNumber;
        } else {
            this.getProgress();
        }
        if (this._operation == 4) {
            if (this._numberErrors == 0) {
                this.errorText.setText("Integrity check complete, no errors detected");
            } else if (this._numberErrors >= this._maximumErrors) {
                this.errorText.setText("Integrity check complete, mmore than " + this._numberErrors + " errors found");
            } else {
                this.errorText.setText("Integrity check complete, " + this._numberErrors + " errors found");
            }
        }
        this.displayProgress();
        this._listSelection.setCursorDefault();
    }

    public int getTotalValues() {
        return this.totalNumber;
    }

    public int getCurrentValues() {
        return this.currentRec[0];
    }

    public void canceled() {
        this.timer.stop();
    }

    protected void getProgress() {
        if (this._operation == 5) {
            this._listSelection.getWriteStatus(this.numberRecs, this.currentRec);
        } else if (this._operation == 7 || this._operation == 1 || this._operation == 8) {
            this._listSelection.getDataManagerStatus(this.numberRecs, this.currentRec);
        } else if (this._operation == 10) {
            int[] numberDiffs = new int[1];
            this._listSelection.getCompareStatus(this.numberRecs, this.currentRec, numberDiffs);
            this._numberDifferences = numberDiffs[0];
        } else {
            int[] numberErrors = new int[1];
            HecDSSFileAccess.processStatus((int[])this.numberRecs, (int[])this.currentRec, (int[])numberErrors);
            this._taskErrors = numberErrors[0];
        }
        this.totalNumber = this.numberRecs[0];
    }

    public void updateProgress() {
        this.getProgress();
        this.displayProgress();
    }

    protected void displayProgress() {
        if (!this.firstDoneMessage) {
            int progress;
            if (this.currentRec[0] > 0) {
                ++this.count;
                if (this.startTime == 0L) {
                    this.startTime = new Date().getTime();
                }
                if (this.taskStart == 0L) {
                    this.taskStart = new Date().getTime();
                }
                int timeUsed = (int)(new Date().getTime() - this.taskStart);
                int secondsLeft = (int)((double)timeUsed * ((double)((float)this.totalNumber / (float)this.currentRec[0]) - 1.0) + 600.0) / 1000;
                if (this.totalNumber > 200000) {
                    double fact = 1.0 + (double)(this.totalNumber - this.currentRec[0]) / 100000.0 * 0.08;
                    secondsLeft = (int)((double)secondsLeft * fact);
                }
                StringBuffer timeString = new StringBuffer();
                this.formatTime(secondsLeft, timeString);
                this.timeLeftText.setText("Time Left:    " + timeString);
                timeString = new StringBuffer();
                int secondsUsed = timeUsed / 1000;
                this.formatTime(secondsUsed, timeString);
                if (this._numberTasks > 0) {
                    this.taskTimeText.setText("Task Time:  " + timeString);
                }
                timeString = new StringBuffer();
                timeUsed = (int)(new Date().getTime() - this.startTime);
                secondsUsed = timeUsed / 1000;
                this.formatTime(secondsUsed, timeString);
                this.totalTimeText.setText("Total Time:  " + timeString);
            }
            if (this.currentRec[0] == this.totalNumber && this._taskNumber == this._numberTasks) {
                this.firstDoneMessage = true;
            }
            this.statusText.setText("Status:       " + this.currentRec[0] + "  of  " + this.totalNumber);
            if (this._numberTasks > 1) {
                progress = (this._taskNumber - 1) * this.totalNumber + this.currentRec[0];
                int denom = this.totalNumber * this._numberTasks;
                if (denom > 0) {
                    int progressPercent = 100 * progress / denom;
                    if (progressPercent > 100) {
                        progressPercent = 100;
                    }
                    this._overallProgressBar.setString(progressPercent + "% Overall");
                    this._overallProgressBar.setValue(progressPercent);
                }
            }
            if (this.totalNumber > 0) {
                progress = this.currentRec[0] * 100 / this.totalNumber;
                if (this._numberTasks > 1) {
                    this._taskProgressBar.setString(progress + "% Task");
                } else {
                    this._taskProgressBar.setString(progress + "%");
                }
                if (progress > 100) {
                    progress = 99;
                }
                this._taskProgressBar.setValue(progress);
            }
            if (this.totalNumber > 0) {
                double d = (double)this.currentRec[0] / (double)this.totalNumber * 100.0;
                if (d > 100.0) {
                    d = 99.0;
                }
                HecDouble percent = new HecDouble(d, 1);
                Object mess = "  " + this._taskName + ":  " + this.currentRec[0] + " of " + this.totalNumber + ";  Percent complete: " + percent.toString();
                if (this.currentRec[0] >= this.totalNumber && this._taskNumber == this._numberTasks) {
                    if (this._operation == 3) {
                        mess = "Copying squeezed file back...";
                    } else {
                        this.done(this._numberErrors);
                        this.setVisible(false);
                    }
                }
                this._listSelection.setCursorWait((String)mess);
            }
            if (this._numberErrors > 0 || this._taskErrors > 0) {
                if (this._operation == 9) {
                    if (this._taskErrors > 0) {
                        this.errorText.setText("Empty records (not copied):  " + this._taskErrors);
                    }
                } else {
                    int numb = this._numberErrors + this._taskErrors;
                    this.errorText.setText(numb + " errors detected.");
                }
            }
            if (this._operation == 10) {
                this.errorText.setText(this._numberDifferences + " differences found.");
            }
        }
        this.repaint();
    }

    public void formatTime(int timeInSeconds, StringBuffer timeString) {
        int hours = timeInSeconds / 3600;
        int minutes = (timeInSeconds - hours * 3600) / 60;
        int seconds = timeInSeconds - (hours * 3600 + minutes * 60);
        if (hours < 10) {
            timeString.append("0");
        }
        timeString.append(Integer.toString(hours) + ":");
        if (minutes < 10) {
            timeString.append("0");
        }
        timeString.append(Integer.toString(minutes) + ":");
        if (seconds < 10) {
            timeString.append("0");
        }
        timeString.append(Integer.toString(seconds));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.cancelButton) {
            this.canceled();
            this._listSelection.operationCanceled(this._operation, false, 0);
        } else if (object == this.skipButton) {
            this._listSelection.operationCanceled(this._operation, true, 0);
        } else {
            this.updateProgress();
        }
    }
}

