/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ListSelection;
import hec.dssgui.PathnameTable;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.util.HecTime;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

class DssVueTransferHandler
extends TransferHandler {
    private DataFlavor fileFlavor;
    private DataFlavor stringFlavor;
    public static DataFlavor dssPathnameFlavor = null;
    private ListSelection listSelection;
    private JTextArea source;
    private PathnameTable table;
    protected String newline = "\n";
    Position p0 = null;
    Position p1 = null;
    String mimeType = "application/x-java-jvm-local-objectref;class=hec.heclib.dss.DataReferenceSet";

    DssVueTransferHandler(ListSelection ls) {
        this.listSelection = ls;
        this.fileFlavor = DataFlavor.javaFileListFlavor;
        this.stringFlavor = DataFlavor.stringFlavor;
    }

    protected void createFlavor() {
        try {
            dssPathnameFlavor = new DataFlavor(this.mimeType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                Object str = null;
                List files = (List)t.getTransferData(this.fileFlavor);
                this.listSelection.importVariousFileTypes(files);
                return true;
            }
            if (this.hasStringFlavor(t.getTransferDataFlavors())) {
                JTextArea tc = (JTextArea)c;
                if (tc.equals(this.source) && tc.getCaretPosition() >= this.p0.getOffset() && tc.getCaretPosition() <= this.p1.getOffset()) {
                    return true;
                }
                String str = (String)t.getTransferData(this.stringFlavor);
                tc.replaceSelection(str);
                return true;
            }
            if (this.hasPathnameFlavor(t.getTransferDataFlavors())) {
                DataReferenceSet drs = (DataReferenceSet)t.getTransferData(DataReferenceSet.dssPathnameFlavor);
                System.out.println(drs);
                this.listSelection.dataDropped(c, drs);
                return true;
            }
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
        }
        catch (IOException ieo) {
            System.out.println("importData: I/O exception");
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTextArea) {
            this.source = (JTextArea)c;
            int start = this.source.getSelectionStart();
            int end = this.source.getSelectionEnd();
            Document doc = this.source.getDocument();
            if (start == end) {
                return null;
            }
            try {
                this.p0 = doc.createPosition(start);
                this.p1 = doc.createPosition(end);
            }
            catch (BadLocationException e) {
                System.out.println("Can't create position - unable to remove text from source.");
            }
            String data = this.source.getSelectedText();
            return new StringSelection(data);
        }
        if (c instanceof PathnameTable) {
            this.table = (PathnameTable)c;
            DataReferenceSet drs = this.table.getSelectedPathnames();
            HecTime startTime = this.listSelection.getStartTime();
            HecTime endTime = this.listSelection.getEndTime();
            drs.setTimeWindow(startTime, endTime);
            return drs;
        }
        if (c instanceof JList) {
            JList list = (JList)c;
            Object[] obj = list.getSelectedValues();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < obj.length; ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(obj[i].toString());
            }
            return new StringSelection(sb.toString());
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        if (this.hasFileFlavor(flavors)) {
            return true;
        }
        if (this.hasStringFlavor(flavors)) {
            return false;
        }
        return this.hasPathnameFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!this.fileFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasStringFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!this.stringFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasPathnameFlavor(DataFlavor[] flavors) {
        if (dssPathnameFlavor == null) {
            this.createFlavor();
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!dssPathnameFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

