/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.MathFrame2;
import hec.dssgui.MathPanel;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecDouble;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.PairedDataMath;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJRadioButton;
import rma.swing.list.RmaListModel;

public class GeneralTab
extends MathPanel {
    public static final String UNITS_CONVERSION = "Units Conversion";
    public static final String SET_UNITS = "Set Units";
    public static final String SET_TYPE = "Set Type";
    public static final String ESTIMATE_MISSING = "Estimate Missing Values";
    public static final String REPLACE_VALUES = "Replace Specific Values";
    public static final String SCREEN_MIN_MAX = "Screen using Minimum and Maximum";
    public static final String SCREEN_FORWARD_MOVING_AVE = "Screen with Forward Moving Average";
    public static final String MERGE_TIMESERIES = "Merge Time Series";
    public static final String MERGE_PAIREDDATA = "Merge Paired Data";
    public static final String PAIRED_DATA_OPERATIONS = "Paried Data Operations";
    public static final String GENERATE_DATA_PAIRS = "Generate Data Pairs";
    private static final String ROUND_TO_NEAREST_WHOLE_NUMBER = "Round to Nearest Whole Number";
    private static final String TRUNCATE_TO_WHOLE_NUMBER = "Truncate to Whole Number";
    private static final String ROUND_OFF = "Round Off";
    private static String[] _operators = new String[]{"Units Conversion", "Set Units", "Set Type", "Round to Nearest Whole Number", "Truncate to Whole Number", "Round Off", "Estimate Missing Values", "Replace Specific Values", "Screen using Minimum and Maximum", "Screen with Forward Moving Average", "Merge Time Series", "Merge Paired Data", "Paried Data Operations", "Generate Data Pairs"};
    private UnitsConversionPanel _unitsConvertPanel;
    private SetTypePanel _setTypePanel;
    private SetUnitsPanel _setUnitsPanel;
    private EstimateForMissingPanel _estimatePanel;
    private DoubleFieldPanel _replaceSpecificValuesPanel;
    private ScreenMinMaxPanel _screenMinMaxPanel;
    private ScreenForwardMovingPanel _screenForwardPanel;
    private MathPanel.MultipleDataSetListPanel _mergeTimeSeriesPanel;
    private MergePairedDataPanel _mergePairedDataPanel;
    private GenerateDataPairsPanel _generateDataPairsPanel;
    private PairedDataOpsPanel _pairedDataOpsPanel;
    private MathPanel.DataSetListPanel _roundToNearestWholeNumber;
    private MathPanel.DataSetListPanel _truncateToWholeNumberPanel;
    private DoubleFieldPanel _roundOffPanel;
    protected boolean _computing = false;

    public GeneralTab(MathFrame2 parent) {
        super(parent);
    }

    @Override
    protected void buildPanel() {
        super.buildPanel();
        this._opCombo.setModel(new RmaListModel(false, (Object[])_operators));
        this._opCombo.setMaximumRowCount(_operators.length);
        final CardLayout cl = (CardLayout)this._cardPanel.getLayout();
        this._unitsConvertPanel = new UnitsConversionPanel();
        this._cardPanel.add(UNITS_CONVERSION, this._unitsConvertPanel);
        this._setTypePanel = new SetTypePanel();
        this._cardPanel.add(SET_TYPE, this._setTypePanel);
        this._setUnitsPanel = new SetUnitsPanel();
        this._cardPanel.add(SET_UNITS, this._setUnitsPanel);
        this._roundToNearestWholeNumber = new MathPanel.DataSetListPanel();
        this._cardPanel.add(ROUND_TO_NEAREST_WHOLE_NUMBER, this._roundToNearestWholeNumber);
        this._truncateToWholeNumberPanel = new MathPanel.DataSetListPanel();
        this._cardPanel.add(TRUNCATE_TO_WHOLE_NUMBER, this._truncateToWholeNumberPanel);
        this._roundOffPanel = new DoubleFieldPanel(true);
        this._roundOffPanel.setLabelText("Number Significant Digits:", 'N');
        this._roundOffPanel.setLabel2Text("Power of 10s Place:", 'P');
        this._cardPanel.add(ROUND_OFF, this._roundOffPanel);
        this._estimatePanel = new EstimateForMissingPanel();
        this._cardPanel.add(ESTIMATE_MISSING, this._estimatePanel);
        this._replaceSpecificValuesPanel = new DoubleFieldPanel(false);
        this._replaceSpecificValuesPanel.setLabelText("Value to be replaced:", 'R');
        this._replaceSpecificValuesPanel.setLabel2Text("Value to replace with:", 'W');
        this._replaceSpecificValuesPanel._messageLabel.setText("Leave blank for missing values");
        this._cardPanel.add(REPLACE_VALUES, this._replaceSpecificValuesPanel);
        this._screenMinMaxPanel = new ScreenMinMaxPanel();
        this._cardPanel.add(SCREEN_MIN_MAX, this._screenMinMaxPanel);
        this._screenForwardPanel = new ScreenForwardMovingPanel();
        this._cardPanel.add(SCREEN_FORWARD_MOVING_AVE, this._screenForwardPanel);
        this._mergeTimeSeriesPanel = new MathPanel.MultipleDataSetListPanel();
        this._cardPanel.add(MERGE_TIMESERIES, this._mergeTimeSeriesPanel);
        this._mergePairedDataPanel = new MergePairedDataPanel();
        this._mergePairedDataPanel.setShowSelectedContainer(false);
        this._mergePairedDataPanel.setListClassType(PairedDataContainer.class);
        this._mergePairedDataPanel.setSelectedClassType(PairedDataContainer.class);
        this._mergePairedDataPanel.setDataSetLabel("Paired Data", 'P');
        this._cardPanel.add(MERGE_PAIREDDATA, this._mergePairedDataPanel);
        this._generateDataPairsPanel = new GenerateDataPairsPanel();
        this._cardPanel.add(GENERATE_DATA_PAIRS, this._generateDataPairsPanel);
        this._pairedDataOpsPanel = new PairedDataOpsPanel();
        this._cardPanel.add(PAIRED_DATA_OPERATIONS, this._pairedDataOpsPanel);
        this._opCombo.setSelectedIndex(-1);
        this._opCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cl.show(GeneralTab.this._cardPanel, (String)GeneralTab.this._opCombo.getSelectedItem());
                GeneralTab.this.setComputeButtonEnabled(GeneralTab.this.isComputable());
            }
        });
        this._opCombo.setSelectedIndex(0);
    }

    @Override
    public boolean compute() {
        this._computing = true;
        boolean success = this.computeOps();
        this._computing = false;
        return success;
    }

    protected boolean computeOps() {
        TimeSeriesContainer outputDc = null;
        TimeSeriesMath mathGuy = null;
        HecMath outputMath = null;
        String op = (String)this._opCombo.getSelectedItem();
        int[] selection = this.getSelectedIndices();
        DataContainer[] containers = this._parent.getDataSets(selection);
        for (int j = 0; j < selection.length; ++j) {
            DataContainer dc = containers[j];
            if (dc instanceof TimeSeriesContainer) {
                mathGuy = this._tsmath;
                outputDc = new TimeSeriesContainer();
            } else if (dc instanceof PairedDataContainer) {
                mathGuy = this._pdmath;
                outputDc = new PairedDataContainer();
            }
            if (mathGuy == null) {
                return false;
            }
            try {
                mathGuy.setData(dc);
            }
            catch (HecMathException e) {
                System.out.println("compute: Exception : " + e);
                return false;
            }
            try {
                HecMath tmpMath;
                if (UNITS_CONVERSION.equals(op)) {
                    if (mathGuy.isEnglish()) {
                        outputMath = mathGuy.convertToMetricUnits();
                    } else if (mathGuy.isMetric()) {
                        outputMath = mathGuy.convertToEnglishUnits();
                    }
                } else if (SET_TYPE.equals(op)) {
                    String type = this._setTypePanel.getType();
                    if (dc instanceof TimeSeriesContainer) {
                        ((TimeSeriesContainer)dc).type = type;
                        dc.modified = true;
                    }
                    mathGuy.setData(dc);
                    outputMath = mathGuy;
                } else if (SET_UNITS.equals(op)) {
                    String units = this._setUnitsPanel.getUnits();
                    double multiplier = this._setUnitsPanel.getMultiplier();
                    if (dc instanceof TimeSeriesContainer) {
                        TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                        tsc.units = units;
                        for (int i = 0; i < tsc.values.length; ++i) {
                            if (tsc.values[i] == -3.4028234663852886E38) continue;
                            int n = i;
                            tsc.values[n] = tsc.values[n] * multiplier;
                        }
                        dc.modified = true;
                    }
                    mathGuy.setData(dc);
                    outputMath = mathGuy;
                } else if (ROUND_OFF.equals(op)) {
                    double significantDigits = this._roundOffPanel.getConstantInt();
                    if (significantDigits == -3.4028234663852886E38) {
                        return false;
                    }
                    double powersPlace = this._roundOffPanel.get2ndConstantInt();
                    if (powersPlace == -3.4028234663852886E38) {
                        return false;
                    }
                    outputMath = mathGuy.roundOff((int)significantDigits, (int)powersPlace);
                } else if (ROUND_TO_NEAREST_WHOLE_NUMBER.equals(op)) {
                    outputMath = mathGuy.round();
                } else if (TRUNCATE_TO_WHOLE_NUMBER.equals(op)) {
                    outputMath = mathGuy.truncate();
                } else if (ESTIMATE_MISSING.equals(op)) {
                    int maxMissing = this._estimatePanel.getMaxMissing();
                    outputMath = this._estimatePanel.isForPrecip() ? this._tsmath.estimateForMissingPrecipValues(maxMissing) : this._tsmath.estimateForMissingValues(maxMissing);
                } else if (REPLACE_VALUES.equals(op)) {
                    HecDouble from = new HecDouble(this._replaceSpecificValuesPanel.getConstantText());
                    HecDouble to = new HecDouble(this._replaceSpecificValuesPanel.getConstant2Text());
                    outputMath = mathGuy.replaceSpecificValues(from, to);
                } else if (SCREEN_MIN_MAX.equals(op)) {
                    double changeLimit;
                    double maxLimit;
                    String quality = this._screenMinMaxPanel.getQualityFlag();
                    double minLimit = this._screenMinMaxPanel.getMinValueLimit();
                    if (minLimit == -3.4028234663852886E38) {
                        minLimit = -1.7976931348623157E308;
                    }
                    if ((maxLimit = this._screenMinMaxPanel.getMaxValueLimit()) == -3.4028234663852886E38) {
                        maxLimit = Double.MAX_VALUE;
                    }
                    if ((changeLimit = this._screenMinMaxPanel.getChangeValueLimit()) == -3.4028234663852886E38) {
                        changeLimit = Double.MAX_VALUE;
                    }
                    outputMath = this._tsmath.screenWithMaxMin(minLimit, maxLimit, changeLimit, this._screenMinMaxPanel.getReplaceValueCheckbox(), this._screenMinMaxPanel.getReplacementValue(), this._screenMinMaxPanel.getQualityFlag());
                } else if (SCREEN_FORWARD_MOVING_AVE.equals(op)) {
                    String quality = this._screenMinMaxPanel.getQualityFlag();
                    outputMath = this._tsmath.screenWithForwardMovingAverage(this._screenForwardPanel.getNumberToAverageOver(), this._screenForwardPanel.getChangeValueLimit(), this._screenForwardPanel.getInvalidToMissing(), this._screenForwardPanel.getQualityFlag());
                } else if (MERGE_TIMESERIES.equals(op)) {
                    tmpMath = HecMath.createInstance((DataContainer)this._parent.getSelectedDataSet());
                    outputMath = tmpMath.mergeTimeSeries((HecMath)this._tsmath);
                    if (outputMath != null) {
                        TimeSeriesContainer tsc = new TimeSeriesContainer();
                        outputMath.getData((DataContainer)tsc);
                        this._parent.updateSelectedDataSet((DataContainer)tsc);
                        continue;
                    }
                } else if (MERGE_PAIREDDATA.equals(op)) {
                    tmpMath = HecMath.createInstance((DataContainer)this._mergePairedDataPanel.getSelectedDataContainer());
                    tmpMath.setCurve(this._mergePairedDataPanel.getPairedDataCurve());
                    outputMath = this._pdmath.mergePairedDataSets(tmpMath);
                    if (outputMath != null) {
                        PairedDataContainer pdc = new PairedDataContainer();
                        outputMath.getData((DataContainer)pdc);
                        pdc.modified = true;
                        this._parent.addDataSet((DataContainer)pdc);
                        this.clearSelection();
                        return true;
                    }
                } else if (GENERATE_DATA_PAIRS.equals(op)) {
                    boolean sorted;
                    tmpMath = HecMath.createInstance((DataContainer)this._generateDataPairsPanel.getSelectedDataContainer());
                    outputMath = this._tsmath.generateDataPairs(tmpMath, sorted = this._generateDataPairsPanel.isSorted());
                    if (outputMath != null) {
                        PairedDataContainer pdc = new PairedDataContainer();
                        outputMath.getData((DataContainer)pdc);
                        pdc.modified = true;
                        this._parent.addDataSet((DataContainer)pdc);
                        this.clearSelection();
                        return true;
                    }
                } else if (PAIRED_DATA_OPERATIONS.equals(op)) {
                    if (mathGuy instanceof PairedDataMath) {
                        int switchXY = this._pairedDataOpsPanel.getSwitchXY();
                        boolean reorder = this._pairedDataOpsPanel.reorder();
                        int resample = this._pairedDataOpsPanel.getResample();
                        boolean swapXY = this._pairedDataOpsPanel.getSwap();
                        int[] deleteCurves = this._pairedDataOpsPanel.getSelectedDeletions();
                        if (deleteCurves == null) {
                            throw new HecMathException("Delete Curve selected, but no curves chosen");
                        }
                        outputMath = ((PairedDataMath)mathGuy).pairedDataOps(reorder, resample, swapXY, deleteCurves, switchXY);
                    } else {
                        return false;
                    }
                }
                if (outputMath == null) continue;
                outputMath.getData((DataContainer)outputDc);
                outputDc.modified = true;
                this._parent.setSelectedIndex(selection[j]);
                this._parent.updateSelectedDataSet((DataContainer)outputDc);
                continue;
            }
            catch (Exception e) {
                System.out.println("compute: Exception " + e);
                JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 0);
                return false;
            }
        }
        if (op.equals(UNITS_CONVERSION)) {
            this._unitsConvertPanel.updateDataList();
        }
        if (outputMath != null) {
            this._computing = false;
            if (PAIRED_DATA_OPERATIONS.equals(op)) {
                this._parent.updateSelectedDataSet((DataContainer)outputDc);
            }
            return true;
        }
        return false;
    }

    @Override
    public Vector getSelectedDataSets() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(ROUND_TO_NEAREST_WHOLE_NUMBER)) {
            return this._roundToNearestWholeNumber.getSelectedDataSets();
        }
        if (op.equals(SET_TYPE)) {
            return this._setTypePanel.getSelectedDataSets();
        }
        if (op.equals(SET_UNITS)) {
            return this._setUnitsPanel.getSelectedDataSets();
        }
        if (op.equals(TRUNCATE_TO_WHOLE_NUMBER)) {
            return this._truncateToWholeNumberPanel.getSelectedDataSets();
        }
        if (op.equals(ROUND_OFF)) {
            return this._roundOffPanel.getSelectedDataSets();
        }
        if (op.equals(ESTIMATE_MISSING)) {
            return this._estimatePanel.getSelectedDataSets();
        }
        if (op.equals(SCREEN_MIN_MAX)) {
            return this._screenMinMaxPanel.getSelectedDataSets();
        }
        if (op.equals(SCREEN_FORWARD_MOVING_AVE)) {
            return this._screenForwardPanel.getSelectedDataSets();
        }
        if (op.equals(MERGE_TIMESERIES)) {
            return this._mergeTimeSeriesPanel.getSelectedDataSets();
        }
        if (op.equals(PAIRED_DATA_OPERATIONS)) {
            return this._pairedDataOpsPanel.getSelectedDataSets();
        }
        if (op.equals(UNITS_CONVERSION)) {
            return this._parent.getModifiedDataSets();
        }
        return super.getSelectedDataSets();
    }

    @Override
    public int[] getSelectedIndices() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(ROUND_TO_NEAREST_WHOLE_NUMBER)) {
            return this._roundToNearestWholeNumber.getSelectedIndices();
        }
        if (op.equals(SET_TYPE)) {
            return this._setTypePanel.getSelectedIndices();
        }
        if (op.equals(SET_UNITS)) {
            return this._setUnitsPanel.getSelectedIndices();
        }
        if (op.equals(TRUNCATE_TO_WHOLE_NUMBER)) {
            return this._truncateToWholeNumberPanel.getSelectedIndices();
        }
        if (op.equals(ROUND_OFF)) {
            return this._roundOffPanel.getSelectedIndices();
        }
        if (op.equals(ESTIMATE_MISSING)) {
            return this._estimatePanel.getSelectedIndices();
        }
        if (op.equals(SCREEN_MIN_MAX)) {
            return this._screenMinMaxPanel.getSelectedIndices();
        }
        if (op.equals(MERGE_TIMESERIES)) {
            return this._mergeTimeSeriesPanel.getSelectedIndices();
        }
        if (op.equals(PAIRED_DATA_OPERATIONS)) {
            return this._pairedDataOpsPanel.getSelectedIndices();
        }
        if (op.equals(SCREEN_FORWARD_MOVING_AVE)) {
            return this._screenForwardPanel.getSelectedIndices();
        }
        if (op.equals(UNITS_CONVERSION)) {
            return this._unitsConvertPanel.getSelectedIndices();
        }
        MathPanel.MathCardListPanel panel = this.getVisibleOpPanel();
        if (panel != null) {
            return panel.getSelectedIndices();
        }
        return super.getSelectedIndices();
    }

    private MathPanel.MathCardListPanel getVisibleOpPanel() {
        MathPanel.MathCardListPanel panel = null;
        if (this._cardPanel != null && this._cardPanel.isVisible()) {
            for (Component component : this._cardPanel.getComponents()) {
                if (!(component instanceof MathPanel.MathCardListPanel) || !component.isVisible()) continue;
                panel = (MathPanel.MathCardListPanel)component;
                break;
            }
        }
        return panel;
    }

    public void clearSelection() {
        String op = (String)this._opCombo.getSelectedItem();
        if (op.equals(ROUND_TO_NEAREST_WHOLE_NUMBER)) {
            this._roundToNearestWholeNumber.getDataSetList().clearSelection();
        } else if (op.equals(SET_UNITS)) {
            this._setUnitsPanel.getDataSetList().clearSelection();
        } else if (op.equals(SET_TYPE)) {
            this._setTypePanel.getDataSetList().clearSelection();
        } else if (op.equals(TRUNCATE_TO_WHOLE_NUMBER)) {
            this._truncateToWholeNumberPanel.getDataSetList().clearSelection();
        } else if (op.equals(ROUND_OFF)) {
            this._roundOffPanel.getDataSetList().clearSelection();
        } else if (op.equals(ESTIMATE_MISSING)) {
            this._estimatePanel.getDataSetList().clearSelection();
        } else if (op.equals(SCREEN_MIN_MAX)) {
            this._screenMinMaxPanel.getDataSetList().clearSelection();
        } else if (op.equals(MERGE_TIMESERIES)) {
            this._mergeTimeSeriesPanel.getDataSetList().clearSelection();
        } else if (op.equals(PAIRED_DATA_OPERATIONS)) {
            this._pairedDataOpsPanel.getDataSetList().clearSelection();
        } else if (op.equals(SCREEN_FORWARD_MOVING_AVE)) {
            this._screenForwardPanel.getDataSetList().clearSelection();
        } else if (op.equals(REPLACE_VALUES)) {
            this._replaceSpecificValuesPanel.getDataSetList().clearSelection();
        }
    }

    @Override
    public String getTabName() {
        return "General";
    }

    class UnitsConversionPanel
    extends MathPanel.DataSetPanel {
        private RmaJRadioButton _convertToSIRadio;
        private RmaJRadioButton _convertToEnglishRadio;

        UnitsConversionPanel() {
        }

        @Override
        protected void buildPanel() {
            super.buildPanel();
            GridBagConstraints gbc = ((GridBagLayout)this.getLayout()).getConstraints(this._dataSetLabel);
            gbc.gridy += 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this._dataSetLabel, gbc);
            gbc = ((GridBagLayout)this.getLayout()).getConstraints(this._dataSetScrollPane);
            gbc.gridy += 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this._dataSetScrollPane, gbc);
            this._dataSetLabel.setText("Available Data Sets to Convert ");
            this._dataSetLabel.setDisplayedMnemonic('A');
            this._dataSetList.setSelectionMode(2);
            this._convertToSIRadio = new RmaJRadioButton("Convert to SI", true);
            this._convertToSIRadio.setMnemonic('S');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._convertToSIRadio, gbc);
            this._convertToEnglishRadio = new RmaJRadioButton("Convert to English");
            this._convertToEnglishRadio.setMnemonic('C');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._convertToEnglishRadio, gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._convertToSIRadio);
            bg.add((AbstractButton)this._convertToEnglishRadio);
            this.setSelectedClassType(null);
            this.setListClassType(null);
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    UnitsConversionPanel.this.updateDataList();
                }
            };
            this._convertToEnglishRadio.addActionListener(al);
            this._convertToSIRadio.addActionListener(al);
        }

        public void updateDataList() {
            Vector v = GeneralTab.this._parent.getDataSets();
            this.updateDataList(v);
        }

        private void updateDataList(Vector v) {
            TimeSeriesMath tsMathGuy = new TimeSeriesMath();
            PairedDataMath pdMathGuy = new PairedDataMath();
            Vector<DataContainer> items2Convert = new Vector<DataContainer>(v.size());
            boolean convertToSI = this._convertToSIRadio.isSelected();
            boolean isEnglish = false;
            boolean isMetric = false;
            for (int i = 0; i < v.size(); ++i) {
                DataContainer dc = (DataContainer)v.get(i);
                try {
                    TimeSeriesMath mathGuy;
                    if (dc instanceof TimeSeriesContainer) {
                        tsMathGuy.setData(dc);
                        mathGuy = tsMathGuy;
                    } else {
                        pdMathGuy.setData(dc);
                        mathGuy = pdMathGuy;
                    }
                    try {
                        isEnglish = mathGuy.isEnglish();
                        isMetric = mathGuy.isMetric();
                    }
                    catch (HecMathException e) {
                        continue;
                    }
                    if (!(convertToSI ? isEnglish : isMetric)) continue;
                    items2Convert.add(dc);
                    continue;
                }
                catch (HecMathException e) {
                    System.out.println("Exception " + e);
                }
            }
            this._dataSetList.setModel((ListModel)new RmaListModel(false, items2Convert));
            this._dataSetList.setSelectedValue((Object)GeneralTab.this._parent.getSelectedDataSet(), true);
        }

        @Override
        public boolean isComputable() {
            if (this._dataSetList.getSelectedIndex() == -1) {
                if (this._dataSetList.getModel().getSize() == 0) {
                    this.setStatusLineText("No DataSets to convert");
                    return false;
                }
                this.setStatusLineText("No ", this._dataSetLabel, " selected");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            this._dataSetList.setSelectedValue((Object)dc, true);
        }

        @Override
        public void setDataContainers(Vector v) {
            if (v == null) {
                this._dataSetList.setListData((Vector)null);
                return;
            }
            this.updateDataList(v);
        }

        public int[] getSelectedIndices() {
            return this._dataSetList.getSelectedIndices();
        }

        @Override
        public void setStatusLineText(String text) {
            super.setStatusLineText(text);
        }
    }

    class SetTypePanel
    extends MathPanel.MathCardListPanel {
        protected JComboBox _typeComboBox;
        private JLabel _setTypeLabel;
        private JLabel _currentType;
        private JLabel _note;
        private DataContainer _dc;
        protected String convertString = "Convert Data to this Type";

        SetTypePanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            JPanel typePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)typePanel, gbc);
            this._setTypeLabel = new JLabel("Type:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            typePanel.add((Component)this._setTypeLabel, gbc);
            String[] types = new String[]{"PER-AVER", "PER-CUM", "INST-VAL", "INST-CUM"};
            this._typeComboBox = new JComboBox<String>(types);
            this._setTypeLabel.setLabelFor(this._typeComboBox);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            typePanel.add((Component)this._typeComboBox, gbc);
            JLabel label = new JLabel("Current Type:");
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 20, 0, 5);
            typePanel.add((Component)label, gbc);
            this._currentType = new JLabel("");
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 2, 0, 5);
            this.add((Component)this._currentType, gbc);
            JPanel p = new JPanel(new GridLayout(1, 2));
            p.add(this._currentType);
            p.add(new JLabel(" "));
            typePanel.add((Component)p, gbc);
            this._note = new JLabel("(This funtion will not modify the data; it only sets the type field.)");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 4;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 5, 0, 5);
            typePanel.add((Component)this._note, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(7, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            MathPanel.MathCardPanel.ComputeActionListener kl = new MathPanel.MathCardPanel.ComputeActionListener();
            this._typeComboBox.addActionListener(kl);
        }

        public String getType() {
            return this._typeComboBox.getSelectedItem().toString();
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            this._dc = dc;
            if (dc == null) {
                return;
            }
            if (dc instanceof TimeSeriesContainer) {
                this.setEnabled(true);
                this._currentType.setText(((TimeSeriesContainer)dc).type);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
            this.isComputable();
        }

        @Override
        public boolean isComputable() {
            if (this._dc instanceof TimeSeriesContainer) {
                this.clearStatusLineText();
                return true;
            }
            return false;
        }
    }

    class SetUnitsPanel
    extends MathPanel.MathCardListPanel {
        private JTextField _unitsField;
        private JLabel _setUnitsLabel;
        private JLabel _multiplierLabel;
        private JTextField _multiplier;
        private JLabel _noteLabel;

        SetUnitsPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            JPanel unitsPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)unitsPanel, gbc);
            this._setUnitsLabel = new JLabel("Units:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            unitsPanel.add((Component)this._setUnitsLabel, gbc);
            this._unitsField = new JTextField(10);
            this._unitsField.setHorizontalAlignment(4);
            this._setUnitsLabel.setLabelFor(this._unitsField);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            unitsPanel.add((Component)this._unitsField, gbc);
            this._multiplierLabel = new JLabel("Conversion Multiplier:");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 15, 0, 5);
            unitsPanel.add((Component)this._multiplierLabel, gbc);
            this._multiplier = new JTextField("1.0", 8);
            this._multiplier.setHorizontalAlignment(4);
            this._multiplierLabel.setLabelFor(this._multiplier);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            unitsPanel.add((Component)this._multiplier, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 4;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            unitsPanel.add((Component)new JLabel(" "), gbc);
            this._noteLabel = new JLabel("Note:  The units field will only be set if the multiplier is 1.0; no conversion will be done.");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 5;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(10, 5, 5, 5);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(7, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._unitsField.addKeyListener(kl);
            this._multiplier.addKeyListener(kl);
        }

        public String getUnits() {
            return this._unitsField.getText();
        }

        public double getMultiplier() {
            String s = this._multiplier.getText().trim();
            double numb = 1.0;
            if (s.length() > 0) {
                try {
                    numb = Double.parseDouble(s);
                }
                catch (Exception e) {
                    numb = 1.0;
                }
            }
            return numb;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc == null) {
                return;
            }
            if (dc instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                if (this._unitsField.getText().length() == 0) {
                    this._unitsField.setText(tsc.units);
                }
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
            this.isComputable();
        }

        @Override
        public boolean isComputable() {
            boolean b = this._unitsField.getText().length() > 0;
            String s = this._multiplier.getText().trim();
            boolean numb = false;
            if (s.length() > 0) {
                try {
                    Double.parseDouble(s);
                    numb = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (b && numb) {
                this.clearStatusLineText();
                return true;
            }
            if (!b) {
                this.setStatusLineText("No units entered.");
            } else {
                this.setStatusLineText("Invalid conversion multiplier.");
            }
            return false;
        }
    }

    class DoubleFieldPanel
    extends MathPanel.MathCardListPanel {
        private RmaJIntegerField _constantIntTxt;
        private RmaJDecimalField _constantDecimalTxt;
        private RmaJIntegerField _constantInt2Txt;
        private RmaJDecimalField _constantDecimal2Txt;
        private JLabel _constantLabel;
        private JLabel _constant2Label;
        public JLabel _messageLabel;
        boolean _intFields;

        DoubleFieldPanel(boolean intFields) {
            this._intFields = intFields;
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            super.setLayout(new GridBagLayout());
            this._constantLabel = new JLabel("Value1:");
            this._constantLabel.setDisplayedMnemonic('V');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._constantLabel, gbc);
            this._constantIntTxt = new RmaJIntegerField();
            this._constantIntTxt.setColumns(10);
            this._constantLabel.setLabelFor((Component)this._constantIntTxt);
            this._constantDecimalTxt = new RmaJDecimalField();
            this._constantDecimalTxt.setColumns(10);
            this._constantLabel.setLabelFor((Component)this._constantDecimalTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.ipadx = 100;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            if (this._intFields) {
                this.add((Component)this._constantIntTxt, gbc);
            } else {
                this.add((Component)this._constantDecimalTxt, gbc);
            }
            this._constant2Label = new JLabel("Value2:");
            this._constant2Label.setDisplayedMnemonic('V');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._constant2Label, gbc);
            this._constantInt2Txt = new RmaJIntegerField();
            this._constantInt2Txt.setColumns(10);
            this._constant2Label.setLabelFor((Component)this._constantInt2Txt);
            this._constantDecimal2Txt = new RmaJDecimalField();
            this._constantDecimal2Txt.setColumns(10);
            this._constant2Label.setLabelFor((Component)this._constantDecimal2Txt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.ipadx = 100;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            if (this._intFields) {
                this.add((Component)this._constantInt2Txt, gbc);
            } else {
                this.add((Component)this._constantDecimal2Txt, gbc);
            }
            this._messageLabel = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._messageLabel, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 3;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._constantInt2Txt.addKeyListener((KeyListener)kl);
            this._constantIntTxt.addKeyListener((KeyListener)kl);
            this._constantDecimal2Txt.addKeyListener((KeyListener)kl);
            this._constantDecimalTxt.addKeyListener((KeyListener)kl);
        }

        public void setLabelText(String text, char mnemonic) {
            if (text == null) {
                this._constantLabel.setText("");
            } else {
                this._constantLabel.setText(text);
            }
            if (mnemonic != '\u0000') {
                this._constantLabel.setDisplayedMnemonic(mnemonic);
            }
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this._constantIntTxt.setText("");
                this._constantInt2Txt.setText("");
                this._constantDecimalTxt.setText("");
                this._constantDecimal2Txt.setText("");
            }
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
            this.isComputable();
        }

        @Override
        public boolean isComputable() {
            if (this._intFields) {
                boolean b;
                boolean bl = b = this._constantIntTxt.getText().length() != 0;
                if (!b) {
                    this.setStatusLineText("No ", this._constantLabel, " entered.");
                    return false;
                }
                boolean bl2 = b = this._constantInt2Txt.getText().length() != 0;
                if (!b) {
                    this.setStatusLineText("No ", this._constant2Label, " entered.");
                    return false;
                }
            } else {
                boolean b2;
                boolean b1 = this._constantDecimalTxt.getText().length() != 0;
                boolean bl = b2 = this._constantDecimal2Txt.getText().length() != 0;
                if (!b1 && !b2) {
                    this.setStatusLineText("No ", this._constant2Label, " entered.");
                    return false;
                }
            }
            this.clearStatusLineText();
            return true;
        }

        public int getConstantInt() {
            int value = this._constantIntTxt.getValue();
            if (value == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return value;
        }

        public int get2ndConstantInt() {
            int value = this._constantInt2Txt.getValue();
            if (value == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return value;
        }

        public double getConstantDouble() {
            double value = this._constantDecimalTxt.getValue();
            if (value == -2.147483648E9) {
                return -2.147483648E9;
            }
            return value;
        }

        public double get2ndConstantDouble() {
            double value = this._constantDecimal2Txt.getValue();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }

        public String getConstantText() {
            if (this._intFields) {
                return this._constantIntTxt.getText();
            }
            return this._constantDecimalTxt.getText();
        }

        public String getConstant2Text() {
            if (this._intFields) {
                return this._constantInt2Txt.getText();
            }
            return this._constantDecimal2Txt.getText();
        }

        public void setLabel2Text(String text, char mnemonic) {
            if (text == null) {
                this._constant2Label.setText("");
            } else {
                this._constant2Label.setText(text);
            }
            if (mnemonic != '\u0000') {
                this._constant2Label.setDisplayedMnemonic(mnemonic);
            }
        }
    }

    class EstimateForMissingPanel
    extends MathPanel.MathCardListPanel {
        private RmaJIntegerField _maxMissingFld;
        private JLabel _maxMissingLabel;
        private RmaJCheckBox _isPrecipData;

        EstimateForMissingPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._maxMissingLabel = new JLabel("Maximum Consecutive Number of Missing:");
            this._maxMissingLabel.setDisplayedMnemonic('M');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._maxMissingLabel, gbc);
            this._maxMissingFld = new RmaJIntegerField();
            this._maxMissingFld.setMinValue(1);
            this._maxMissingLabel.setLabelFor((Component)this._maxMissingFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._maxMissingFld, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add(Box.createHorizontalStrut(100), gbc);
            this._isPrecipData = new RmaJCheckBox("Interpolate Cumulative Precip");
            this._isPrecipData.setMnemonic('I');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)this._isPrecipData, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._maxMissingFld.addKeyListener((KeyListener)kl);
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc == null) {
                return;
            }
            if (dc instanceof TimeSeriesContainer) {
                this.setEnabled(true);
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                this._isPrecipData.setEnabled(tsc.type.toUpperCase().indexOf("INST-CUM") > -1);
                if (!this._isPrecipData.isEnabled()) {
                    this._isPrecipData.setSelected(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public boolean isForPrecip() {
            return this._isPrecipData.isSelected();
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
            this.isComputable();
        }

        @Override
        public boolean isComputable() {
            boolean b;
            boolean bl = b = this._maxMissingFld.getText().length() > 0;
            if (b) {
                this.clearStatusLineText();
            } else {
                this.setStatusLineText("No ", this._maxMissingLabel, " entered.");
            }
            return b;
        }

        public int getMaxMissing() {
            return this._maxMissingFld.getValue();
        }
    }

    class ScreenMinMaxPanel
    extends MathPanel.MathCardListPanel {
        private RmaJDecimalField _minValueLimitTxt;
        private RmaJDecimalField _maxValueLimitTxt;
        private RmaJDecimalField _changeValueLimitTxt;
        private RmaJCheckBox _setReplaceValuesCB;
        private RmaJDecimalField _replacementValue;
        private RmaJCheckBox _setQualityFlagCB;
        private RmaJComboBox _qualityFlagCombo;
        private JLabel _minValueLimitLabel;
        private JLabel _maxValueLimitLabel;
        private JLabel _changeValueLimitLabel;

        ScreenMinMaxPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._minValueLimitLabel = new JLabel("Minimum Value Limit:");
            this._minValueLimitLabel.setDisplayedMnemonic('M');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._minValueLimitLabel, gbc);
            this._minValueLimitTxt = new RmaJDecimalField();
            this._minValueLimitLabel.setLabelFor((Component)this._minValueLimitTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._minValueLimitTxt, gbc);
            JLabel label = new JLabel("                    ");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)label, gbc);
            this._maxValueLimitLabel = new JLabel("Maximum Value Limit:");
            this._maxValueLimitLabel.setDisplayedMnemonic('a');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._maxValueLimitLabel, gbc);
            this._maxValueLimitTxt = new RmaJDecimalField();
            this._maxValueLimitLabel.setLabelFor((Component)this._maxValueLimitTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._maxValueLimitTxt, gbc);
            this._changeValueLimitLabel = new JLabel("Change Value Limit:");
            this._changeValueLimitLabel.setDisplayedMnemonic('C');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._changeValueLimitLabel, gbc);
            this._changeValueLimitTxt = new RmaJDecimalField();
            this._changeValueLimitLabel.setLabelFor((Component)this._changeValueLimitTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._changeValueLimitTxt, gbc);
            this._setReplaceValuesCB = new RmaJCheckBox("Set invalid values to:");
            this._setReplaceValuesCB.setMnemonic('S');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._setReplaceValuesCB, gbc);
            this._replacementValue = new RmaJDecimalField();
            this._setReplaceValuesCB.setLabelFor((Component)this._replacementValue);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._replacementValue, gbc);
            JLabel jl = new JLabel("Leave blank for missing");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)jl, gbc);
            this._setQualityFlagCB = new RmaJCheckBox("Set Quality Flag to:");
            this._setQualityFlagCB.setMnemonic('Q');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._setQualityFlagCB, gbc);
            this._qualityFlagCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])MathPanel.getQualityFlagList()));
            this._qualityFlagCombo.setEnabled(false);
            label.setLabelFor((Component)this._qualityFlagCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._qualityFlagCombo, gbc);
            this._qualityFlagCombo.setSelectedIndex(0);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridwidth = 0;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            this._setReplaceValuesCB.setSelected(true);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._minValueLimitTxt.addKeyListener((KeyListener)kl);
            this._maxValueLimitTxt.addKeyListener((KeyListener)kl);
            this._changeValueLimitTxt.addKeyListener((KeyListener)kl);
            this._setQualityFlagCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScreenMinMaxPanel.this._qualityFlagCombo.setEnabled(ScreenMinMaxPanel.this._setQualityFlagCB.isSelected());
                    GeneralTab.this.setComputeButtonEnabled(ScreenMinMaxPanel.this.isComputable());
                }
            });
            this._setReplaceValuesCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneralTab.this.setComputeButtonEnabled(ScreenMinMaxPanel.this.isComputable());
                }
            });
            this._qualityFlagCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneralTab.this.setComputeButtonEnabled(ScreenMinMaxPanel.this.isComputable());
                }
            });
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
            this.isComputable();
        }

        @Override
        public boolean isComputable() {
            if (this._minValueLimitTxt.getText().length() == 0 && this._maxValueLimitTxt.getText().length() == 0 && this._changeValueLimitTxt.getText().length() == 0) {
                this.setStatusLineText("No values entered");
                return false;
            }
            if (!this._setReplaceValuesCB.isSelected() && !this._setQualityFlagCB.isSelected()) {
                this.setStatusLineText("Either 'Set invalid values to Missing' or 'Set Quality Flag to' needs to be selected.");
                return false;
            }
            if (this._setQualityFlagCB.isSelected() && this._qualityFlagCombo.getSelectedIndex() == -1) {
                this.setStatusLineText("No ", (JComponent)this._setQualityFlagCB, " selected");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public double getMinValueLimit() {
            double value = this._minValueLimitTxt.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }

        public double getMaxValueLimit() {
            double value = this._maxValueLimitTxt.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }

        public double getChangeValueLimit() {
            double value = this._changeValueLimitTxt.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }

        public double getReplacementValue() {
            double value = this._replacementValue.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }

        public boolean getReplaceValueCheckbox() {
            return this._setReplaceValuesCB.isSelected();
        }

        public String getQualityFlag() {
            if (!this._qualityFlagCombo.isEnabled()) {
                return "";
            }
            return MathPanel.getQualityFlagChar((String)this._qualityFlagCombo.getSelectedItem());
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            this.setEnabled(dc instanceof TimeSeriesContainer);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this._qualityFlagCombo.setEnabled(this._setQualityFlagCB.isSelected());
            }
        }
    }

    class ScreenForwardMovingPanel
    extends MathPanel.MathCardListPanel {
        private RmaJIntegerField _numToChangeOverTxt;
        private RmaJDecimalField _changeValueLimitTxt;
        private RmaJComboBox _qualityFlagCombo;
        private RmaJCheckBox _setMissingValuesCB;
        private RmaJCheckBox _setQualityFlagCB;
        private JLabel _numToChangeOverLabel;
        private JLabel _changeValueLimitLabel;

        ScreenForwardMovingPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._numToChangeOverLabel = new JLabel("Number to Average Over:");
            this._numToChangeOverLabel.setDisplayedMnemonic('N');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._numToChangeOverLabel, gbc);
            this._numToChangeOverTxt = new RmaJIntegerField();
            this._numToChangeOverLabel.setLabelFor((Component)this._numToChangeOverTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._numToChangeOverTxt, gbc);
            JLabel label = new JLabel("                    ");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)label, gbc);
            this._changeValueLimitLabel = new JLabel("Change Value Limit:");
            this._changeValueLimitLabel.setDisplayedMnemonic('C');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._changeValueLimitLabel, gbc);
            this._changeValueLimitTxt = new RmaJDecimalField();
            this._changeValueLimitLabel.setLabelFor((Component)this._changeValueLimitTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._changeValueLimitTxt, gbc);
            this._setMissingValuesCB = new RmaJCheckBox("Set invalid values to Missing");
            this._setMissingValuesCB.setMnemonic('S');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._setMissingValuesCB, gbc);
            this._setQualityFlagCB = new RmaJCheckBox("Set Quality Flag to:");
            this._setQualityFlagCB.setMnemonic('Q');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._setQualityFlagCB, gbc);
            this._qualityFlagCombo = new RmaJComboBox((Object[])MathPanel.getQualityFlagList());
            label.setLabelFor((Component)this._qualityFlagCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._qualityFlagCombo, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridwidth = 0;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._numToChangeOverTxt.addKeyListener((KeyListener)kl);
            this._changeValueLimitTxt.addKeyListener((KeyListener)kl);
            this._setQualityFlagCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScreenForwardMovingPanel.this._qualityFlagCombo.setEnabled(ScreenForwardMovingPanel.this._setQualityFlagCB.isSelected());
                    GeneralTab.this.setComputeButtonEnabled(ScreenForwardMovingPanel.this.isComputable());
                }
            });
            this._setMissingValuesCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneralTab.this.setComputeButtonEnabled(ScreenForwardMovingPanel.this.isComputable());
                }
            });
        }

        @Override
        public boolean isComputable() {
            if (this._numToChangeOverTxt.getText().length() == 0) {
                this.setStatusLineText("No ", this._numToChangeOverLabel, " over entered.");
                return false;
            }
            if (this._changeValueLimitTxt.getText().length() == 0) {
                this.setStatusLineText("No ", this._changeValueLimitLabel, " value entered.");
                return false;
            }
            if (!this._setMissingValuesCB.isSelected() && !this._setQualityFlagCB.isSelected()) {
                this.setStatusLineText("Either Set invalid values to Missing or Set Quality Flag to needs to be selected.");
                return false;
            }
            if (this._setQualityFlagCB.isSelected() && this._qualityFlagCombo.getSelectedIndex() == -1) {
                this.setStatusLineText("No ", (JComponent)this._setQualityFlagCB, " selected");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public int getNumberToAverageOver() {
            return this._numToChangeOverTxt.getValue();
        }

        public double getChangeValueLimit() {
            double value = this._changeValueLimitTxt.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }

        public String getQualityFlag() {
            if (!this._qualityFlagCombo.isEnabled()) {
                return "";
            }
            return MathPanel.getQualityFlagChar((String)this._qualityFlagCombo.getSelectedItem());
        }

        public boolean getInvalidToMissing() {
            return this._setMissingValuesCB.isSelected();
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
            this.isComputable();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this._qualityFlagCombo.setEnabled(this._setQualityFlagCB.isSelected());
            }
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            this.setEnabled(dc instanceof TimeSeriesContainer);
        }
    }

    class MergePairedDataPanel
    extends MathPanel.DataSetPanel {
        private JLabel _pairedDataCurveLabel;
        private RmaJComboBox _pairedDataCurveCombo;

        MergePairedDataPanel() {
        }

        @Override
        protected void buildPanel() {
            super.buildPanel();
            this._pairedDataCurveLabel = new JLabel("Select Paired Data Curve:");
            this._pairedDataCurveLabel.setDisplayedMnemonic('P');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._pairedDataCurveLabel, gbc);
            this._pairedDataCurveCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false));
            this._pairedDataCurveCombo.setVerifyInputWhenFocusTarget(false);
            this._pairedDataCurveLabel.setLabelFor((Component)this._pairedDataCurveCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._pairedDataCurveCombo, gbc);
            this.remove(this._dataSetScrollPane);
            this.remove(this._dataSetLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._dataSetLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._dataSetScrollPane, gbc);
            this._pairedDataCurveCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneralTab.this.setComputeButtonEnabled(MergePairedDataPanel.this.isComputable());
                }
            });
        }

        @Override
        public boolean isComputable() {
            if (!super.isComputable()) {
                return false;
            }
            if (this._pairedDataCurveCombo.getSelectedIndex() == -1) {
                this.setStatusLineText("No ", this._pairedDataCurveLabel, " selected.");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            super.setSelectedDataContainer(dc);
        }

        @Override
        public void dataSetListSelectionChanged(DataContainer dc) {
            this.fillPairedDataCombo(dc);
        }

        private void fillPairedDataCombo(DataContainer dc) {
            int i;
            boolean visible = dc instanceof PairedDataContainer;
            PairedDataContainer pdc = null;
            RmaListModel model = (RmaListModel)this._pairedDataCurveCombo.getModel();
            model.clear();
            if (!visible) {
                return;
            }
            pdc = (PairedDataContainer)dc;
            this._pairedDataCurveCombo.setEnabled(pdc != null && pdc.yOrdinates != null);
            if (pdc == null || pdc.yOrdinates == null) {
                return;
            }
            for (i = 0; i < pdc.yOrdinates.length; ++i) {
                if (pdc.labelsUsed && pdc.labels != null && pdc.labels[i] != null) {
                    model.addElement((Object)pdc.labels[i]);
                    continue;
                }
                model.addElement((Object)String.valueOf(i + 1));
            }
            if (i > 1) {
                model.addElement((Object)"All");
            }
            if (pdc.yOrdinates.length == 1) {
                this._pairedDataCurveCombo.setSelectedIndex(0);
            } else {
                this._pairedDataCurveCombo.setSelectedItem((Object)"All");
            }
            this._pairedDataCurveCombo.setEnabled(model.getSize() > 0);
        }

        public int getPairedDataCurve() {
            if (!this._pairedDataCurveCombo.isEnabled()) {
                return -100;
            }
            int i = 0;
            int cnt = this._pairedDataCurveCombo.getItemCount();
            if (i < cnt) {
                String item = (String)this._pairedDataCurveCombo.getSelectedItem();
                if ("All".equals(item)) {
                    return -1;
                }
                return this._pairedDataCurveCombo.getSelectedIndex();
            }
            return -1;
        }
    }

    class GenerateDataPairsPanel
    extends MathPanel.DataSetPanel {
        private RmaJCheckBox _sortedValuesCB;

        GenerateDataPairsPanel() {
            this.setSelectedClassType(TimeSeriesContainer.class);
            this.setListClassType(TimeSeriesContainer.class);
        }

        @Override
        protected void buildPanel() {
            super.buildPanel();
            this._sortedValuesCB = new RmaJCheckBox("Sorted", true);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.add((Component)this._sortedValuesCB, gbc);
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            boolean b = dc instanceof TimeSeriesContainer;
            this.setEnabled(b);
            if (!b) {
                this.setStatusLineText("Selected DataSet not a Time Series");
            } else {
                this.clearStatusLineText();
            }
        }

        public boolean isSorted() {
            return this._sortedValuesCB.isSelected();
        }
    }

    class PairedDataOpsPanel
    extends MathPanel.MathCardListPanel {
        protected JCheckBox _switchXY;
        protected JRadioButton _switchX;
        protected JRadioButton _switchY;
        protected JCheckBox _ascending;
        protected JCheckBox _resample;
        protected JComboBox _resamplePoints;
        protected JCheckBox _swapXY;
        protected JCheckBox _deleteCurve;
        protected JComboBox _deleteCurveCombo;
        protected boolean _isPD = false;

        PairedDataOpsPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            JPanel switchPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)switchPanel, gbc);
            this._switchXY = new JCheckBox("Set horizontal (X) axis for plots:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            switchPanel.add((Component)this._switchXY, gbc);
            this._switchX = new JRadioButton("X (default)");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            switchPanel.add((Component)this._switchX, gbc);
            this._switchY = new JRadioButton("Y");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            switchPanel.add((Component)this._switchY, gbc);
            ButtonGroup selBG = new ButtonGroup();
            selBG.add(this._switchX);
            selBG.add(this._switchY);
            this._ascending = new JCheckBox("Reorder to ascending and remove duplicate independent values");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._ascending, gbc);
            JPanel panel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)panel, gbc);
            this._resample = new JCheckBox("Resample every");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            panel.add((Component)this._resample, gbc);
            String[] points = new String[19];
            for (int i = 0; i < points.length; ++i) {
                points[i] = Integer.toString(i + 2);
            }
            this._resamplePoints = new JComboBox<String>(points);
            this._resamplePoints.setSelectedIndex(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            panel.add((Component)this._resamplePoints, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(8, 5, 0, 5);
            panel.add((Component)new JLabel(" points"), gbc);
            this._swapXY = new JCheckBox("Swap parameters (move X data to Y, Y to X) ");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._swapXY, gbc);
            panel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)panel, gbc);
            this._deleteCurve = new JCheckBox("Delete Curve");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            panel.add((Component)this._deleteCurve, gbc);
            String[] curves = new String[2];
            for (int i = 0; i < curves.length; ++i) {
                curves[i] = Integer.toString(i + 1);
            }
            this._deleteCurveCombo = new JComboBox<String>(curves);
            this._deleteCurveCombo.setSelectedIndex(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            panel.add((Component)this._deleteCurveCombo, gbc);
            JSeparator sep = new JSeparator();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(7, 0, 0, 0);
            this.add((Component)sep, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridheight = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._dataSetListPanel, gbc);
            this._switchXY.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PairedDataOpsPanel.this.somethingSelected();
                }
            });
            this._resample.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PairedDataOpsPanel.this.somethingSelected();
                }
            });
            this._deleteCurve.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PairedDataOpsPanel.this.somethingSelected();
                }
            });
        }

        protected void somethingSelected() {
            if (this._switchXY.isSelected()) {
                this._switchX.setEnabled(true);
                this._switchY.setEnabled(true);
            } else {
                this._switchX.setEnabled(false);
                this._switchY.setEnabled(false);
            }
            if (this._resample.isSelected()) {
                this._resamplePoints.setEnabled(true);
            } else {
                this._resamplePoints.setEnabled(false);
            }
            if (this._deleteCurve.isSelected()) {
                this._deleteCurveCombo.setEnabled(true);
            } else {
                this._deleteCurveCombo.setEnabled(false);
            }
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (GeneralTab.this._computing) {
                return;
            }
            if (dc == null) {
                return;
            }
            if (dc instanceof PairedDataContainer) {
                String independentParam = null;
                String dependentParam = null;
                PairedDataContainer pdc = (PairedDataContainer)dc;
                DSSPathname path = new DSSPathname(pdc.fullName);
                int idx = path.cPart().indexOf("-");
                if (idx > 1) {
                    independentParam = path.cPart().substring(0, idx);
                    if (idx < path.cPart().length()) {
                        dependentParam = path.cPart().substring(idx + 1);
                        this._switchX.setText(independentParam + "  (default)");
                        this._switchY.setText(dependentParam);
                        String swap = "Swap parameters (move " + independentParam + " data to Y, " + dependentParam + " to X) ";
                        this._swapXY.setText(swap);
                    }
                }
                this.setEnabled(true);
                if (pdc.numberCurves == 1) {
                    this._swapXY.setEnabled(true);
                    this._deleteCurve.setEnabled(false);
                } else {
                    int i;
                    this._swapXY.setEnabled(false);
                    this._deleteCurve.setEnabled(true);
                    String[] names = new String[pdc.numberCurves + 1];
                    Vector<JCheckBoxMenuItem> v = new Vector<JCheckBoxMenuItem>(names.length);
                    names[0] = " ";
                    if (pdc.labelsUsed && pdc.labels.length == pdc.numberCurves) {
                        for (i = 0; i < pdc.numberCurves; ++i) {
                            names[i + 1] = pdc.labels[i];
                        }
                    } else {
                        for (i = 0; i < pdc.numberCurves; ++i) {
                            names[i + 1] = Integer.toString(i + 1);
                        }
                    }
                    for (i = 0; i < names.length; ++i) {
                        JCheckBoxMenuItem cb = new JCheckBoxMenuItem(names[i]);
                        if (i == 0) {
                            cb.setEnabled(false);
                        }
                        v.add(cb);
                    }
                    DefaultComboBoxModel model = new DefaultComboBoxModel(v);
                    this._deleteCurveCombo.setModel(model);
                    int max = names.length;
                    if (max > 20) {
                        max = 20;
                    }
                    this._deleteCurveCombo.setMaximumRowCount(max);
                    final ComboBoxCellRenderer cbr = new ComboBoxCellRenderer(names);
                    this._deleteCurveCombo.setRenderer(cbr);
                    this._deleteCurveCombo.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e.getActionCommand().equals("comboBoxChanged") && PairedDataOpsPanel.this._deleteCurveCombo.getSelectedItem() instanceof JCheckBoxMenuItem) {
                                JCheckBoxMenuItem cb = (JCheckBoxMenuItem)PairedDataOpsPanel.this._deleteCurveCombo.getSelectedItem();
                                String name = cb.getText();
                                cbr.setNameSelected(name);
                            }
                        }
                    });
                }
                if (pdc.switchXyAxis) {
                    this._switchY.setSelected(true);
                } else {
                    this._switchX.setSelected(true);
                }
                this._isPD = true;
                this.somethingSelected();
            } else {
                this._isPD = false;
                this.setEnabled(false);
            }
        }

        public int getSwitchXY() {
            if (this._switchXY.isSelected()) {
                if (this._switchX.isSelected()) {
                    return 1;
                }
                return 2;
            }
            return 0;
        }

        public boolean reorder() {
            return this._ascending.isSelected();
        }

        public int getResample() {
            if (this._resample.isSelected()) {
                String s = this._resamplePoints.getSelectedItem().toString();
                return Integer.parseInt(s);
            }
            return 0;
        }

        public boolean getSwap() {
            return this._swapXY.isSelected();
        }

        public int[] getSelectedDeletions() {
            ListCellRenderer rend;
            if (this._deleteCurve.isSelected() && (rend = this._deleteCurveCombo.getRenderer()) instanceof ComboBoxCellRenderer) {
                int[] sel = ((ComboBoxCellRenderer)rend).getSelectedIndicies();
                if (sel.length == 0) {
                    return null;
                }
                return sel;
            }
            return new int[0];
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
            this.isComputable();
        }

        @Override
        public boolean isComputable() {
            if (this._isPD) {
                this.clearStatusLineText();
            } else {
                this.setStatusLineText("Data is not Paired Data");
            }
            return this._isPD;
        }
    }

    protected class ComboBoxCellRenderer
    extends JCheckBoxMenuItem
    implements ListCellRenderer {
        String[] names;
        boolean[] selected;

        public ComboBoxCellRenderer(String[] boxNames) {
            this.names = boxNames;
            this.selected = new boolean[this.names.length];
            for (int i = 0; i < this.selected.length; ++i) {
                this.selected[i] = false;
            }
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public void setNameSelected(String name) {
            for (int i = 1; i < this.names.length; ++i) {
                if (!name.equals(this.names[i])) continue;
                this.selected[i] = !this.selected[i];
                return;
            }
        }

        public String[] getSelectedNames() {
            int count = 0;
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.selected[i]) continue;
                ++count;
            }
            String[] selectedNames = new String[count];
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.selected[i]) continue;
                selectedNames[count] = this.names[i];
                ++count;
            }
            return selectedNames;
        }

        public int[] getSelectedIndicies() {
            int count = 0;
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.selected[i]) continue;
                ++count;
            }
            int[] selectedNames = new int[count];
            count = 0;
            for (int i = 1; i < this.names.length; ++i) {
                if (!this.selected[i]) continue;
                selectedNames[count] = i - 1;
                ++count;
            }
            return selectedNames;
        }

        protected boolean isBoxSelected(String name) {
            for (int i = 1; i < this.names.length; ++i) {
                if (!name.equals(this.names[i])) continue;
                return this.selected[i];
            }
            return false;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(null);
            }
            if (index == 0) {
                isSelected = false;
            }
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.textBackground"));
                this.setForeground(UIManager.getColor("List.textForeground"));
            }
            String name = " ";
            if (value instanceof JCheckBoxMenuItem && (name = ((JCheckBoxMenuItem)value).getText()).trim().length() != 0) {
                this.setSelected(this.isBoxSelected(name));
            }
            this.setText(name);
            return this;
        }
    }
}

