/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.data.TimeSeriesDataEditorListener;
import hec.dataui.tx.DataSourceList;
import hec.dataui.tx.TsContainerDataSourceList;
import hec.dssgui.ListSelection;
import hec.dssgui.TsEditAction;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import java.util.List;
import rma.swing.RmaImage;

final class GraphicalEditorAction
extends TsEditAction {
    private static final String NAME = "Graphical Edit...";
    private static final String TOOLTIP = "Graphically Edit time series data. Any quality associated with the time series will not be displayed or modified.";

    GraphicalEditorAction(ListSelection listSelection) {
        super(listSelection);
        this.putValue("SmallIcon", RmaImage.getImageIcon((String)"Images/G-GraphicalEditor_16.png"));
        this.putValue("SwingLargeIconKey", RmaImage.getImageIcon((String)"Images/G-GraphicalEditor_24.png"));
    }

    static String getName() {
        return NAME;
    }

    static String getToolTipText() {
        return TOOLTIP;
    }

    @Override
    DataSourceList buildDataSourceList(List<TimeSeriesContainer> timeSeriesContainers) {
        HecTime startTime = this.getListSelection().getStartTime();
        HecTime endTime = this.getListSelection().getEndTime();
        TsContainerDataSourceList dataSourceList = new TsContainerDataSourceList(startTime, endTime, timeSeriesContainers);
        dataSourceList.addDataEditorListener((TimeSeriesDataEditorListener)this.getListSelection());
        return dataSourceList;
    }
}

