/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.AbstractGridInfoTab;
import hec.dssgui.GridInfoTab;
import hec.heclib.dss.DSSPathname;
import hec.heclib.grid.GridData;
import hec.io.GridContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import rma.swing.FontChooser;
import rma.swing.RmaInsets;
import rma.swing.RmaNavigationPanel;
import rma.swing.event.RecordSelectorListener;

public class GridInfoFrame
extends JFrame
implements ActionListener {
    private static List<Class> _additionalTabs = new ArrayList<Class>();
    private JTabbedPane _tabPane;
    private JPanel _panelContainer;
    private RmaNavigationPanel _navPanel;
    private List<AbstractGridInfoTab> _panelList = new ArrayList<AbstractGridInfoTab>();
    private List<GridHolder> _grids = new ArrayList<GridHolder>();

    public static void addTabClass(Class c, int pos) {
        if (c == null) {
            return;
        }
        if (pos < 0) {
            _additionalTabs.add(c);
        }
        if (AbstractGridInfoTab.class.isAssignableFrom(c)) {
            _additionalTabs.add(pos, c);
        }
    }

    public static void removeTabClass(Class c) {
        _additionalTabs.remove(c);
    }

    public GridInfoFrame(DSSPathname path, GridData gridData) {
        this(path.getPathname(), gridData);
    }

    public GridInfoFrame(GridContainer gridContainer) {
        this(gridContainer.fullName, gridContainer.getGridData());
    }

    public GridInfoFrame(String path, GridData gridData) {
        this.buildControls();
        this.buildMenus();
        this.addListeners();
        this.addGrid(path, gridData);
        this.fillForm(path, gridData);
        this._navPanel.setNumRecords(1);
        this._navPanel.setRecordPosition(0);
        this.setSize(600, 400);
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._panelContainer = new JPanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this._panelContainer, gbc);
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)bottomPanel, gbc);
        this._navPanel = new RmaNavigationPanel();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        bottomPanel.add((Component)this._navPanel, gbc);
        for (int i = 0; i < _additionalTabs.size(); ++i) {
            AbstractGridInfoTab tab;
            block5: {
                Class c = _additionalTabs.get(i);
                if (c == null) continue;
                try {
                    tab = (AbstractGridInfoTab)c.newInstance();
                    if (!(tab instanceof AbstractGridInfoTab) || i <= 1) break block5;
                    tab.setVerboseMode(true);
                }
                catch (InstantiationException e) {
                    System.out.println("InstantiationException " + e);
                    if (e.getCause() != null) {
                        e.getCause().printStackTrace();
                        continue;
                    }
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    System.out.println("IllegalAccessException " + e);
                    e.printStackTrace();
                    continue;
                }
            }
            this.addTab(tab);
        }
    }

    protected void buildMenus() {
        JMenuBar mb = new JMenuBar();
        JMenu mFile = new JMenu("File");
        JMenuItem miPrint = new JMenuItem("Print");
        miPrint.addActionListener(this);
        mFile.add(miPrint);
        mFile.addSeparator();
        JMenuItem miExit = new JMenuItem("Close");
        mFile.add(miExit);
        miExit.addActionListener(this);
        mb.add(mFile);
        this.setJMenuBar(mb);
    }

    protected void addListeners() {
        this._navPanel.addRecordSelectorListener(new RecordSelectorListener(){

            public boolean newRecord() {
                return false;
            }

            public boolean selectRecord(int recordNum) {
                if (recordNum >= GridInfoFrame.this._grids.size()) {
                    return false;
                }
                GridHolder gh = GridInfoFrame.this._grids.get(recordNum);
                GridInfoFrame.this.fillForm(gh.getPath(), gh.getGridData());
                return true;
            }
        });
        InputMap inputMap = this.getRootPane().getInputMap(1);
        ActionMap actionMap = this.getRootPane().getActionMap();
        AbstractAction prevAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridInfoFrame.this._navPanel.previousRecord();
            }
        };
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "prevRecord");
        actionMap.put("prevRecord", prevAction);
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridInfoFrame.this._navPanel.nextRecord();
            }
        };
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "nextRecord");
        actionMap.put("nextRecord", nextAction);
    }

    protected void addTab(AbstractGridInfoTab panel) {
        if (panel == null) {
            return;
        }
        System.out.println("addTab:adding " + panel.getTabname());
        if (this._panelContainer.getComponentCount() == 0) {
            this._panelContainer.add((Component)panel, "Center");
        } else {
            if (this._tabPane == null) {
                this._tabPane = new JTabbedPane();
                this._panelContainer.add((Component)this._tabPane, "Center");
                for (int i = 0; i < this._panelList.size(); ++i) {
                    AbstractGridInfoTab tPanel = this._panelList.get(i);
                    this._tabPane.add((Component)tPanel, tPanel.getTabname());
                }
            }
            this._tabPane.add((Component)panel, panel.getTabname());
        }
        this._panelList.add(panel);
    }

    protected void setSelectedTabIndex(int index) {
        try {
            this._tabPane.setSelectedIndex(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void fillForm(String pathStr, GridData gridData) {
        this.setTitle(pathStr);
        for (int i = 0; i < this._panelList.size(); ++i) {
            this._panelList.get(i).fillPanel(pathStr, gridData);
        }
    }

    protected void fontDialog() {
        int i = 0;
        while (!(this._panelList.get(i) instanceof GridInfoTab)) {
            ++i;
        }
        FontChooser fc = new FontChooser((Frame)this, "Select Font", true, this._panelList.get(i).getFont());
        Font font = fc.getSelectedFont();
        if (font != null) {
            for (i = 0; i < this._panelList.size(); ++i) {
                if (!(this._panelList.get(i) instanceof GridInfoTab)) continue;
                ((GridInfoTab)this._panelList.get(i)).updateFont(font);
            }
        }
    }

    public void print() {
        if (this._tabPane != null) {
            AbstractGridInfoTab tab = (AbstractGridInfoTab)this._tabPane.getSelectedComponent();
            tab.print();
        } else if (this._panelList.size() > 0) {
            this._panelList.get(0).print();
        }
    }

    public void closeFrame() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem c = (JMenuItem)e.getSource();
        String arg = c.getText();
        if (arg.equals("Print")) {
            this.print();
        } else if (arg.equals("Close")) {
            this.closeFrame();
        }
    }

    public void addGrid(GridContainer gridContainer) {
        this.addGrid(gridContainer.fullName, gridContainer.getGridData());
    }

    public void addGrid(DSSPathname path, GridData gridData) {
        this.addGrid(path.toString(), gridData);
    }

    public void addGrid(String path, GridData gridData) {
        this._grids.add(new GridHolder(path, gridData));
        this._navPanel.fillForm(0, this._grids.size());
    }

    static {
        GridInfoFrame.addTabClass(GridInfoTab.class, 0);
        GridInfoFrame.addTabClass(GridInfoTab.class, 1);
    }

    private class GridHolder {
        private String _path;
        private GridData _gridData;

        public GridHolder(String path, GridData gridData) {
            this._path = path;
            this._gridData = gridData;
        }

        public GridData getGridData() {
            return this._gridData;
        }

        public String getPath() {
            return this._path;
        }
    }
}

