/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.AbstractGridInfoTab;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import rma.swing.print.DocumentRenderer;

public class GridInfoTab
extends AbstractGridInfoTab {
    private JEditorPane _textArea;
    private String _info;
    private int _count = 0;
    private Font _font;
    final DocumentRenderer _renderer = new DocumentRenderer();

    public GridInfoTab() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._textArea = new JEditorPane();
        this._textArea.setEditable(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JScrollPane(this._textArea), gbc);
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    protected void updateFont(Font font) {
        this._font = font;
        this._textArea.setFont(font);
    }

    @Override
    public void fillPanel(String pathStr, GridData gridData) {
        if (gridData == null) {
            return;
        }
        GridInfo gridInfo = gridData.getGridInfo();
        gridInfo.setVerboseMode(this._verbose);
        StringBuffer str = new StringBuffer("  ");
        str.append(pathStr);
        str.append('\n');
        str.append('\n');
        this.setBounds(50, 50, 635, 565);
        str.append(gridInfo.toString());
        if (this._font != null) {
            this._textArea.setFont(this._font);
        }
        this._info = str.toString();
        this._textArea.setText(str.toString());
        this._textArea.setCaretPosition(0);
    }

    public String format(int places, String number) {
        Object s = "";
        int len = number.length();
        if (len <= places) {
            int diff = places - len;
            for (int i = 0; i < diff; ++i) {
                s = (String)s + " ";
            }
            s = (String)s + number;
            return s;
        }
        return number;
    }

    public String format(int places, String number, boolean addZero) {
        Object s = "";
        int len = ((String)number).length();
        if (len <= places) {
            int diff = places - len;
            if (((String)number).charAt(len - 1) == '0') {
                diff = places - len - 1;
                number = (String)number + "0";
            }
            for (int i = 0; i < diff; ++i) {
                s = (String)s + " ";
            }
            s = (String)s + (String)number;
            return s;
        }
        return number;
    }

    public int[] getInRange(int[] equalorexceed) {
        int[] range = new int[equalorexceed.length];
        boolean stop = false;
        for (int i = 0; i < equalorexceed.length - 1; ++i) {
            range[i] = equalorexceed[i] - equalorexceed[i + 1];
        }
        range[equalorexceed.length - 1] = equalorexceed[equalorexceed.length - 1];
        return range;
    }

    @Override
    public String getTabname() {
        if (this._verbose) {
            return "Detailed Grid Info";
        }
        return "Grid Info";
    }

    @Override
    public boolean print() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                GridInfoTab.this._renderer.print(GridInfoTab.this._textArea);
            }
        });
        thread.start();
        return true;
    }
}

