/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ObservableClass;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.Group;
import hec.util.GeneralTableEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumn;

public class GroupEditor
extends GeneralTableEditor {
    String[] _columnNames = new String[]{"Group\n(Use > for Subgroup)", "Time window", "Pathname", "File name"};
    protected int[] colWidths = new int[]{130, 230, 500, 200};
    protected JMenuItem _deleteGroupItem;
    protected ObservableClass _observer = new ObservableClass();

    public GroupEditor(Vector groups) {
        this.setTitle("Manage Groups");
        this.init(this._columnNames, groups);
        this._table.setEditable(true);
        int width = 0;
        for (int i = 0; i < this.colWidths.length; ++i) {
            width += this.colWidths[i];
            TableColumn tc = this._table.getColumnModel().getColumn(i);
            tc.setPreferredWidth(this.colWidths[i]);
        }
        this.setSize(width, 600);
        this.setLocation(100, 100);
        this._table.setHorizontalAlignment(0, 0);
    }

    public void init(String[] columnNames, Vector groups) {
        Vector groupsRows = this.makeGroupRows(groups);
        super.initialize(columnNames, groupsRows);
        this._cmdPanel.getButton("Save to Disk").setText("Save");
    }

    protected Vector makeGroupRows(Vector groups) {
        Vector<String[]> groupRows = new Vector<String[]>();
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.elementAt(i);
            for (int j = 0; j < group.size(); ++j) {
                String[] s = new String[4];
                if (j == 0) {
                    s[0] = group.getName();
                    s[1] = group.getTimeWindow();
                } else {
                    s[0] = "";
                    s[1] = "";
                }
                DataReference dr = group.getElement(j);
                s[2] = dr.getNominalPathname(false);
                s[3] = dr.getFilename();
                groupRows.add(s);
            }
            String[] s = new String[4];
            for (int j = 0; j < s.length; ++j) {
                s[j] = "";
            }
            groupRows.add(s);
        }
        return groupRows;
    }

    protected void buildFileMenu() {
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('f');
        JMenuItem menuItem = new JMenuItem("Close", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupEditor.this.close();
            }
        });
        this._fileMenu.add(menuItem);
        this._fileMenu.addSeparator();
        menuItem = new JMenuItem("Save", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupEditor.this.save(false);
            }
        });
        this._fileMenu.add(menuItem);
        this._menuBar.add(this._fileMenu);
    }

    protected void buildEditMenu() {
        this._deleteGroupItem = new JMenuItem("Delete Group(s)");
        this._deleteGroupItem.setEnabled(false);
        this._deleteGroupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupEditor.this.deleteGroup();
            }
        });
        this._editMenu.add(this._deleteGroupItem);
        this._editMenu.addSeparator();
        super.buildEditMenu();
    }

    protected void deleteGroup() {
        int size;
        int opt;
        Vector names = this.getSelectedGroups();
        if (names.size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Groups Selected.", "Delete Groups", 2);
            return;
        }
        if (names.size() == 1) {
            opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Delete Group " + names.elementAt(0).toString() + "?", "Delete Groups", 0);
        } else {
            StringBuffer sb = new StringBuffer("Delete the following groups?");
            for (int i = 0; i < names.size(); ++i) {
                sb.append("\n");
                sb.append(names.elementAt(i).toString());
            }
            opt = JOptionPane.showConfirmDialog((Component)((Object)this), sb.toString(), "Delete Groups", 0);
        }
        if (opt == 1) {
            return;
        }
        Vector groups = this.getGroups();
        for (int i = size = groups.size() - 1; i >= 0; --i) {
            Group group = (Group)groups.elementAt(i);
            for (int j = 0; j < names.size(); ++j) {
                if (!group.getName().equals(names.elementAt(j).toString())) continue;
                groups.remove(i);
            }
        }
        Vector groupRows = this.makeGroupRows(groups);
        this.setRows(groupRows);
        this._tableModel.setDataChanged(true);
    }

    protected Vector getSelectedGroups() {
        this.stopEditing();
        int[] rows = this._table.getSelectedRows();
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < rows.length; ++i) {
            this._table.getValueAt(rows[i], 0).toString();
            String name = this._table.getValueAt(rows[i], 0).toString().trim();
            if (name.length() <= 0) continue;
            names.add(name);
        }
        return names;
    }

    public Vector getGroups() {
        this.stopEditing();
        Vector<Group> groups = new Vector<Group>();
        Group group = new Group();
        String filename = "";
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String name = this._table.getValueAt(i, 0).toString().trim();
            if (name.length() > 0) {
                group = new Group(name);
                groups.add(group);
                group.setTimeWindow(this._table.getValueAt(i, 1).toString().trim());
            }
            String path = this._table.getValueAt(i, 2).toString().trim();
            String fn = this._table.getValueAt(i, 3).toString().trim();
            if (fn.length() > 0) {
                filename = fn;
            }
            if (path.length() <= 0) continue;
            DataReference dr = new DataReference(path, filename);
            group.add(dr);
        }
        return groups;
    }

    protected void checkMenuItemsEnabled() {
        int selected = this._table.getSelectedRow();
        if (selected >= 0) {
            this._deleteGroupItem.setEnabled(true);
        } else {
            this._deleteGroupItem.setEnabled(false);
        }
    }

    public boolean save(boolean b) {
        return this.saveData();
    }

    public boolean saveData() {
        ActionEvent event = new ActionEvent((Object)this, 1001, "Save");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
        return true;
    }

    protected void cancelButton() {
        if (!this.checkForChangedData()) {
            return;
        }
        this.close();
    }

    protected void okayButton() {
        try {
            this.save(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    protected void close() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
        if (this._standAlone) {
            System.exit(0);
        }
        this.dispose();
    }
}

