/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.GroupEditor;
import hec.dssgui.Help;
import hec.dssgui.ObservableClass;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.Group;
import hec.heclib.util.HecTime;
import hec.util.FileUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;

class GroupManager
implements Observer {
    protected Vector _groups = new Vector();
    protected String _groupFileName = null;
    protected GroupEditor _groupEditor = null;
    protected ObservableClass _observer;
    protected Component _parent;

    GroupManager(Component parent, String appDirectory) {
        this._parent = parent;
        this._groupFileName = appDirectory + "groups.txt";
        this._observer = new ObservableClass();
    }

    public void load() throws Exception {
        File file = new File(this._groupFileName);
        if (!file.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("Group")) continue;
                String name = line.substring(7);
                Group group = new Group(name);
                group.read(reader);
                this._groups.add(group);
            }
            reader.close();
        }
        catch (Exception e) {
            String message = "Unable to load group data from file " + file.getAbsolutePath() + "\n" + e.toString();
            throw new Exception(message);
        }
    }

    public void save() throws Exception {
        File file = new File(this._groupFileName);
        try {
            if (this._groups.size() > 0) {
                PrintWriter writer = new PrintWriter(file);
                for (int i = 0; i < this._groups.size(); ++i) {
                    Group group = (Group)this._groups.elementAt(i);
                    group.save(writer);
                }
                writer.close();
            } else {
                file.delete();
            }
        }
        catch (Exception e) {
            String message = "Unable to save group data to file " + file.getAbsolutePath() + "\n" + e.toString();
            throw new Exception(message);
        }
        ActionEvent event = new ActionEvent(this, 1001, "groupsUpdated");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    public boolean checkTimeWindows() {
        StringBuffer sb = new StringBuffer();
        HecTime hecTime = new HecTime();
        for (int i = 0; i < this._groups.size(); ++i) {
            int stat;
            Group group = (Group)this._groups.elementAt(i);
            String tw = group.getTimeWindow();
            if (tw.trim().length() <= 0 || (stat = HecTime.getTimeWindow((String)tw, (HecTime)hecTime, (HecTime)hecTime)) == 0) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Invalid time window for group ");
            sb.append(group.getName());
            sb.append(": ");
            sb.append(tw);
        }
        if (sb.length() > 0) {
            sb.append("\n\nIgnore error or fix?");
            Object[] options = new Object[]{"Ignore", "Fix"};
            int opt = JOptionPane.showOptionDialog(null, sb.toString(), "Error in time window", -1, 2, null, options, options[1]);
            if (opt == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean saveWithBackup() {
        boolean error = this.checkTimeWindows();
        if (error) {
            return false;
        }
        try {
            FileUtilities.copyFile((String)this._groupFileName, (String)(this._groupFileName + ".bak"));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to make backup file (" + this._groupFileName + ".bak) ", "Save Groups", 2);
        }
        try {
            this.save();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Save Groups", 2);
            return false;
        }
        JOptionPane.showMessageDialog(null, "Groups save with backup file (" + this._groupFileName + ".bak) ", "Save Groups", 1);
        return true;
    }

    public int size() {
        return this._groups.size();
    }

    public String[] getGroupNames() {
        int size = this.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            String name;
            Group group = (Group)this._groups.elementAt(i);
            names[i] = name = group.getName();
        }
        return names;
    }

    public void add(String groupName, DataReferenceSet dataSets, String timeWindow) {
        Group group = new Group(groupName, dataSets, timeWindow);
        for (int i = 0; i < this._groups.size(); ++i) {
            Group g = (Group)this._groups.elementAt(i);
            String name = g.getName();
            if (!groupName.equalsIgnoreCase(name)) continue;
            this._groups.remove(i);
            break;
        }
        this._groups.add(0, group);
    }

    public boolean delete(String groupName) {
        for (int i = 0; i < this._groups.size(); ++i) {
            Group g = (Group)this._groups.elementAt(i);
            String name = g.getName();
            if (!groupName.equalsIgnoreCase(name)) continue;
            this._groups.remove(i);
            return true;
        }
        return false;
    }

    public Group getGroup(String groupName) {
        for (int i = 0; i < this._groups.size(); ++i) {
            Group group = (Group)this._groups.elementAt(i);
            String name = group.getName();
            if (!groupName.equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    public DataReferenceSet getGroupSet(String groupName) {
        Group group = this.getGroup(groupName);
        if (group == null) {
            return null;
        }
        return group.getDataReferenceSet();
    }

    public boolean manage() {
        this._groupEditor = new GroupEditor(this._groups);
        this._groupEditor.addObserver(this);
        Help.setHelp((RootPaneContainer)((Object)this._groupEditor), "35");
        this._groupEditor.setVisible(true);
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        ActionEvent event;
        String eventName;
        if (arg instanceof ActionEvent && (eventName = (event = (ActionEvent)arg).getActionCommand()).compareTo("Save") == 0 && this._groupEditor != null) {
            this._groups = this._groupEditor.getGroups();
            boolean success = this.saveWithBackup();
            if (success) {
                this._groupEditor.close();
                this._groupEditor = null;
            }
        }
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }
}

