/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ListSelection;
import hec.gfx2d.G2dData;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecTime;
import hec.hecmath.ScriptLauncher;
import hec.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import mil.army.usace.hec.rmi.heclib.dss.HecDataManagerRemote;
import org.python.util.PythonInterpreter;
import rma.util.RMAIO;

public class HecDssVue
implements Serializable {
    private static final String SPLASH_IMAGE_URL = "Images/hec/DSSVue/32-bit/grid_transparent/DSSVue_grid_transparent_256x256_32.png";
    protected String inputFileName = null;
    protected String dssFileName = null;
    protected boolean runScript = false;
    protected boolean setLookAndFeel = true;
    protected String _programName = "HEC-DSSVue";
    private static String _splashImageURL;

    public static void main(String[] args) {
        new HecDssVue(args);
    }

    public HecDssVue(String[] args) {
        this.setupDssVue(args);
    }

    public static ListSelection getMainWindow() {
        return ListSelection.getMainWindow();
    }

    protected void setupDssVue(String[] args) {
        RMAIO.getVersionStamp();
        G2dData.setUseDisplayUnits((boolean)false);
        ListSelection.setIsInteractive(false, true);
        HecDSSFileAccess.zset((String)"PROG", (String)this._programName, (int)0);
        HecDSSFileAccess.catchSevereErrors();
        String dssurl = System.getProperty("dssurl");
        HecDataManagerRemote.setDSSManagerUrl((String)dssurl);
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String temp = args[i].toLowerCase();
                if (temp.endsWith(".dss")) {
                    this.dssFileName = args[i];
                    continue;
                }
                if (temp.equalsIgnoreCase("-laf")) {
                    this.setLookAndFeel = false;
                    continue;
                }
                if (temp.endsWith(".py")) {
                    this.runScript = true;
                    continue;
                }
                if (temp.startsWith("-d")) {
                    int numb = 10;
                    if (args.length > i + 1) {
                        try {
                            numb = Integer.parseInt(args[++i]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (numb < 0) {
                            numb = 10;
                        }
                    }
                    HecDSSFileAccess.setMessageLevel((int)numb);
                    continue;
                }
                this.inputFileName = args[i];
            }
        }
        try {
            String osName = System.getProperty("os.name");
            if (this.setLookAndFeel && osName.toLowerCase().startsWith("windows")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            System.out.println("Error setting look and feel " + e);
        }
        if (this.runScript) {
            Vector<String> argsVec = new Vector<String>();
            for (int i = 0; i < args.length; ++i) {
                String temp = args[i].toLowerCase();
                if (!temp.endsWith(".py")) continue;
                for (int j = i; j < args.length; ++j) {
                    argsVec.add(args[j]);
                }
                break;
            }
            String[] scriptArgs = new String[argsVec.size()];
            for (int i = 0; i < scriptArgs.length; ++i) {
                scriptArgs[i] = (String)argsVec.get(i);
            }
            PythonInterpreter.initialize((Properties)System.getProperties(), null, (String[])scriptArgs);
            ScriptLauncher sl = new ScriptLauncher(true, args);
            sl.execute();
        } else {
            this.process(this.inputFileName, this.dssFileName);
        }
    }

    public HecDssVue() {
        this.process(null, null);
    }

    public HecDssVue(String inputFileName, String DssFileName) {
        this.process(inputFileName, DssFileName);
    }

    protected ListSelection createListSelection(String titleName, int mode, boolean exitOnClose, boolean clientServer) {
        ListSelection listSelection = new ListSelection(titleName, mode, true, exitOnClose, clientServer);
        return listSelection;
    }

    protected void process(String inputFileName, String DssFileName) {
        Console console;
        String debug;
        FileInputStream inputStream = null;
        ListSelection selection = null;
        boolean allowRemote = false;
        String remote = System.getProperty("remoteDss", "false");
        if (remote.equalsIgnoreCase("true")) {
            allowRemote = true;
        }
        if (!(debug = System.getProperty("debug", "false")).equalsIgnoreCase("false")) {
            ListSelection.debug = true;
        }
        if ((console = Console.getConsole()) == null) {
            String consoleLog = System.getProperty("LOGFILE");
            consoleLog = ListSelection.getLogFileName("Console", consoleLog);
            console = new Console();
            console.setLogFile(consoleLog);
        }
        String logFile = System.getProperty("DSSLOGFILE");
        boolean isDir = false;
        if (inputFileName != null && new File(inputFileName).isDirectory()) {
            isDir = true;
        }
        if (inputFileName != null && !isDir) {
            try {
                inputStream = new FileInputStream(inputFileName);
            }
            catch (Exception e) {
                String message = "Unable to access input file: " + inputFileName + "\n" + e.toString();
                System.out.println(message);
                System.exit(-1);
            }
        } else {
            selection = this.createListSelection("", 2, true, allowRemote);
            if (!"nolog".equalsIgnoreCase(logFile)) {
                selection.setDssLogFile(logFile);
                selection.setConsole(console);
            }
            if (isDir) {
                selection.setDirectory(inputFileName);
            }
            selection.setVisible(true);
            if (DssFileName != null) {
                selection.openDSSFile(DssFileName);
            }
            return;
        }
        selection = this.createListSelection("", 2, false, allowRemote);
        selection.setDssLogFile(logFile);
        selection.setConsole(console);
        ToolTipManager.sharedInstance().setDismissDelay((int)TimeUnit.SECONDS.toMillis(30L));
        if (DssFileName != null) {
            selection.openDSSFile(DssFileName);
        }
        while (true) {
            String parameters;
            String command;
            String line = inputStream != null ? this.readFileLine(inputStream) : HecDssVue.readStdInLine();
            int comma = line.indexOf(",");
            int space = line.indexOf(" ");
            if (comma == -1) {
                comma = space;
            }
            int delim = space;
            if (comma < space) {
                delim = comma;
            }
            if (delim == -1) {
                command = line.toLowerCase();
                parameters = "";
            } else {
                command = line.substring(0, delim).toLowerCase();
                parameters = delim < line.length() ? line.substring(delim + 1).trim() : "";
            }
            if (command.startsWith("op")) {
                selection.openDSSFile(parameters);
                if (inputStream == null) continue;
                System.out.println("");
                continue;
            }
            if (command.startsWith("ti")) {
                if (parameters.length() < 2) {
                    selection.setTimeWindow(new HecTime(), new HecTime(), true);
                    System.out.println("Time window cleared.");
                    continue;
                }
                HecDataManager dataManager = new HecDataManager();
                dataManager.setTimeWindow(parameters);
                selection.setTimeWindow(dataManager.startTime(), dataManager.endTime(), true);
                continue;
            }
            if (command.startsWith("pat")) {
                selection.addToSelection(parameters);
                continue;
            }
            if (command.startsWith("pl")) {
                selection.plot();
                selection.clearSelection();
                if (inputStream == null) continue;
                System.out.println("");
                continue;
            }
            if (command.startsWith("ta")) {
                selection.tabulate();
                selection.clearSelection();
                if (inputStream == null) continue;
                System.out.println("");
                continue;
            }
            if (command.startsWith("wa")) {
                try {
                    int mills = Integer.parseInt(parameters) * 1000;
                    Thread.sleep(mills);
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                continue;
            }
            if (command.startsWith("pau")) {
                if (parameters.length() == 0) {
                    JOptionPane.showMessageDialog(null, "Press OK to continue", "HecDssVue", 1);
                    continue;
                }
                System.out.println("Press carriage return to continue");
                HecDssVue.readStdInLine();
                continue;
            }
            if (command.startsWith("#")) {
                System.out.println(parameters);
                continue;
            }
            if (command.startsWith("*")) continue;
            if (command.startsWith("fi")) {
                while (true) {
                    int number;
                    if ((number = selection.checkNumberOpenWindows()) == 0) {
                        selection.exitProgram();
                        System.exit(0);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
            if (command.length() == 0) continue;
            System.out.println("Unrecognized command: " + line);
        }
    }

    public static String readStdInLine() {
        StringBuffer line = new StringBuffer();
        boolean done = false;
        while (!done) {
            try {
                int ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                if ((char)ch == '\r') continue;
                line.append((char)ch);
            }
            catch (IOException e) {
                done = true;
            }
        }
        return line.toString();
    }

    public String readFileLine(FileInputStream inputStream) {
        StringBuffer line = new StringBuffer();
        boolean done = false;
        while (!done) {
            try {
                int ch = inputStream.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                if ((char)ch == '\r') continue;
                line.append((char)ch);
            }
            catch (IOException e) {
                done = true;
            }
        }
        return line.toString();
    }

    public static String getSplashImageURL() {
        if (_splashImageURL == null) {
            _splashImageURL = SPLASH_IMAGE_URL;
        }
        return _splashImageURL;
    }

    public static void setSplashImageURL(String splashImageURL) {
        _splashImageURL = splashImageURL;
    }
}

