/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.IPanelController;
import hec.dssgui.IPathNamePanel;
import hec.dssgui.SelectionAndFilterPanel;
import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

final class LinkedTabbedPane
extends JTabbedPane {
    final SelectionAndFilterPanel _parent;

    public LinkedTabbedPane(SelectionAndFilterPanel parent) {
        super(1);
        this._parent = parent;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index >= this.getTabCount() || index < 0) {
            return;
        }
        int oldIndex = super.getSelectedIndex();
        if (oldIndex >= 0 && oldIndex != index && oldIndex < this.getTabCount()) {
            Component component = this.getComponentAt(oldIndex);
            if (component instanceof IPanelController) {
                IPanelController panelController = (IPanelController)((Object)component);
                panelController.commit();
                if (panelController.isModified()) {
                    int dialogButton = 1;
                    switch (JOptionPane.showConfirmDialog(null, "Would You Like to Save?", "Warning", dialogButton)) {
                        case 0: {
                            panelController.save();
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                }
            }
            if (component instanceof IPathNamePanel) {
                ((IPathNamePanel)((Object)component)).setBottom(null);
            }
        }
        super.setSelectedIndex(index);
    }

    @Override
    public void removeTabAt(int index) {
        int selIndex = super.getSelectedIndex();
        List<Component> linkedTabs = this._parent.getLinkedTabs(index);
        if (linkedTabs.isEmpty()) {
            super.removeTabAt(index);
        } else {
            for (int i = linkedTabs.size() - 1; i >= 0; --i) {
                int tabIndex = this.indexOfComponent(linkedTabs.get(i));
                super.removeTabAt(tabIndex);
            }
            linkedTabs.clear();
        }
        if (selIndex != index && this.getTabCount() > 0 && null != this._parent.getDataManager()) {
            this._parent.dssFileChanged();
        }
    }
}

