/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.appInterface.FileOpener;
import hec.client.AboutDialog;
import hec.data.TimeSeriesDataEditorListener;
import hec.data.TimeWindowMap;
import hec.data.Units;
import hec.data.cwmsRating.io.AbstractRatingContainerWrapper;
import hec.dataTable.HecDataTable;
import hec.dataTable.HecDataTableFrame;
import hec.dataTable.SavableDataFrame;
import hec.dataTable.TextTable;
import hec.dataTable.TimeSeriesDataModel;
import hec.dataTable.TimeSeriesQualityColumn;
import hec.dataui.tx.util.PhotoViewerJFrame;
import hec.dssgui.CompareFiles;
import hec.dssgui.CompareOptionsDialog;
import hec.dssgui.DebugExamineFile7;
import hec.dssgui.DebugFileInfo7;
import hec.dssgui.DssMetaDataDialog;
import hec.dssgui.DssVueProgressBar;
import hec.dssgui.DssVueTransferHandler;
import hec.dssgui.FileTransfer;
import hec.dssgui.GraphicalEditorAction;
import hec.dssgui.GridInfoFrame;
import hec.dssgui.GroupManager;
import hec.dssgui.Help;
import hec.dssgui.ImportPlugin;
import hec.dssgui.LinkedTabbedPane;
import hec.dssgui.MathFrame2;
import hec.dssgui.MessageLevelDialog;
import hec.dssgui.NewPartsDialog;
import hec.dssgui.PairedDataEntry;
import hec.dssgui.PathnamePanel;
import hec.dssgui.PathnameTable;
import hec.dssgui.PlotUtilities;
import hec.dssgui.RecordInternalsDialog;
import hec.dssgui.SaveAs;
import hec.dssgui.SaveAsAction;
import hec.dssgui.ScriptButtonFrame;
import hec.dssgui.ScriptEditor;
import hec.dssgui.ScriptManagerImpl;
import hec.dssgui.Search;
import hec.dssgui.SelectionAndFilterPanel;
import hec.dssgui.ShefImportExport;
import hec.dssgui.SingleGrid;
import hec.dssgui.SingleGridGlyph;
import hec.dssgui.SortDialog;
import hec.dssgui.SupplementalInfo7;
import hec.dssgui.TimeSeriesDataEntry;
import hec.dssgui.UndeleteEditor;
import hec.dssgui.ValidationEditorAction;
import hec.dssgui.grid.GridDataMapPanel;
import hec.dssgui.options.OptionsDialog;
import hec.dssgui.waterquality.WaterQualityProfilePlotWindow;
import hec.event.ScriptEvent;
import hec.event.ScriptEventListener;
import hec.gfx2d.DssVueSimpleDSSTimeSeriesCollection;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dDialogIndividualSelect;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotDialogFactory;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.Viewport;
import hec.gui.AbstractEditorPanel;
import hec.gui.PanelEditor;
import hec.gui.TimeZonePanel;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.Group;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.dss.HecDSSFileData;
import hec.heclib.dss.HecDSSFileDataManager;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecDSSUtilities;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecDssCatalog;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.dss.IHecDSSUtilities;
import hec.heclib.dss.LocalDssDataManager;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.Heclib;
import hec.heclib.util.intArrayContainer;
import hec.heclib.util.stringContainer;
import hec.io.ArrayContainer;
import hec.io.Console;
import hec.io.ConsoleWindow;
import hec.io.DataContainer;
import hec.io.DssFileContainer;
import hec.io.GridContainer;
import hec.io.PairedDataContainer;
import hec.io.StreamRatingContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TinContainer;
import hec.lang.ClientAppCheck;
import hec.lang.NamedType;
import hec.lang.annotation.Scriptable;
import hec.map.MapGlyphFactory;
import hec.script.Script;
import hec.script.ScriptEngine;
import hec.script.ScriptFlatButton;
import hec.script.ScriptIdentifier;
import hec.script.ScriptManager;
import hec.script.ScriptMenuItem;
import hec.serversuite.ServerSuiteUtil;
import hec.util.AnimatedStatusIconPanel;
import hec.util.ElapsedTime;
import hec.util.PhotoViewerInfo;
import hec.util.TextDialog;
import hec.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.heclib.dss.HecDSSUtilitiesRemote;
import mil.army.usace.hec.rmi.heclib.dss.HecDataManagerRemote;
import mil.army.usace.hec.rmi.heclib.dss.RmiDssDataManager;
import mil.army.usace.hec.serversuite.ui.RmiFileDialog;
import rma.services.ServiceLookup;
import rma.services.tz.TimeZoneComponent;
import rma.services.tz.TimeZoneDisplayService;
import rma.services.units.UnitsComponent;
import rma.services.units.UnitsDisplayService;
import rma.swing.FlatPanelButton;
import rma.swing.RmaImage;
import rma.swing.RmaJFrame;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTextField;
import rma.util.MemoryMonitor;
import rma.util.PlugInLoader;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;
import rma.util.RMASort;

public class ListSelection
extends JFrame
implements ClipboardOwner,
ScriptEventListener,
PropertyChangeListener,
SavableDataFrame,
TimeSeriesDataEditorListener<TimeSeriesContainer>,
Observer {
    private static final String ICON_IMAGE_URL_16X16 = "Images/HecDssVue.png";
    private static final String ICON_IMAGE_URL_256x256 = "Images/hec/DSSVue/32-bit/transparent/DSSVue_transparent_256x256_32.png";
    private static final String ABOUT_IMAGE_URL = "Images/hec/DSSVue/32-bit/grid_transparent/DSSVue_grid_transparent_256x256_32.png";
    private static final Logger LOGGER = Logger.getLogger(ListSelection.class.getName());
    private static final String DECIMAL_PLACES = "decimalPlaces";
    private static final String EMBEDDED = "Embedded";
    public static String _beta = ListSelection.getBetaFromManifest();
    public static String _versionNumber = ListSelection.class.getPackage().getImplementationVersion();
    public static String _versionUpdate = "";
    public static String _versionDate = ListSelection.getBuildTimeFromManifest();
    public static String _programName = "HEC-DSSVue";
    public static boolean _standAlone = true;
    protected String _titleName = "";
    public static final int BROWSER = 1;
    public static final int FULL_FUNCTION = 2;
    public static final int MULTIPLE_PATH_SELECTION = 0;
    public static final int SINGLE_PATH_SELECTION = 1;
    public static boolean debug = false;
    protected static final int COPY = 1;
    protected static final int MERGE = 2;
    protected static final int SQUEEZE = 3;
    protected static final int FILE_CHECK = 4;
    protected static final int WRITE = 5;
    protected static final int CATALOG = 6;
    protected static final int RENAME = 7;
    protected static final int DUPLICATE = 8;
    protected static final int CONVERT_VERS = 9;
    protected static final int COMPARE = 10;
    protected static final int SUCCESS = 1;
    protected static final int FAIL = 2;
    protected static final int CANCEL = 3;
    public String _appDirectory = "";
    public boolean _isOsWindows = false;
    protected boolean _createCatalog = false;
    protected DssDataManager _dataManager = null;
    protected DssDataManager _secondDataManager = null;
    protected String _secondDataManagerName = "";
    private String _remoteFileName;
    private String _localFileName;
    protected String _currentDirectory = null;
    private String _lastOpenedRemoteDirectory = null;
    protected Vector _objectList = new Vector();
    protected GroupManager _groupManager;
    protected WindowClosingListener _windowClosingListener = new WindowClosingListener();
    protected Vector _pastFilesAccessed = new Vector();
    protected int _numberCataloged = 0;
    protected DssVueProgressBar _dssVueProgressBar = null;
    protected boolean _useTabbedPane;
    protected boolean _showErrorOnEmptyFile = true;
    protected RmaJFrame _memMonitorFrame = null;
    protected boolean _normalize = false;
    protected boolean _syncTimes = false;
    protected boolean _operationCanceled = false;
    protected boolean _exitOnClose = false;
    protected static boolean _showPopups = true;
    protected static boolean _searchByParts = true;
    protected boolean _remote = false;
    protected boolean _allowRemote = false;
    protected boolean _interrupt = false;
    protected int _numberContainers = 0;
    protected int _containerNumber = 0;
    protected int _mode;
    protected TimeZone _timeZone = null;
    protected CompareFiles _compareFiles = null;
    protected int _differencesSoFar = 0;
    protected VueActionListener vueActionListener;
    protected ScriptEditor _scriptEditor;
    protected ScriptButtonFrame _scriptButtonFrame;
    protected Console _console;
    protected String _dssLogFile = null;
    protected int _dssLogUnit = 7;
    protected String _shefLogFile = null;
    protected int _messageUnit = -1;
    protected String _fileCheckLogFile = null;
    public final int _maximumFileCheckErrors = 200;
    protected final Vector<String> _mruRemoteFileList = new Vector();
    protected Hashtable<String, Boolean> _mruFileList = new Hashtable();
    protected Preferences _preferences;
    protected static boolean _isInteractive = true;
    protected static boolean _isInteractiveSet = true;
    protected OptionsDialog _options;
    protected DssVueTransferHandler _transferHandler = null;
    protected AnimatedStatusIconPanel _statusIcon;
    protected MathFrame2 _mathFrame = null;
    public int _viewState = 2;
    protected int _viewStatePrevious = 2;
    protected String _catalogWithWildChars = null;
    protected String _defaultWildChars = "/*/*/*/*/*/*/";
    protected WildCardChooserDlg _wildCardChooserDlg = null;
    protected String _wildCharsDialogTitle = "Enter pathname with wild (*) characters";
    protected TreeSet<String> _catalogWithWildCharsChoices = new TreeSet();
    protected Insets _insets0000 = new Insets(0, 0, 0, 0);
    protected String _scriptEditorForegroundColor = null;
    protected String _scriptEditorBackgroundColor = null;
    protected String _scriptEditorFont = null;
    protected String _pathnames = "Pathnames";
    protected int _scriptEditorTabSize = 8;
    protected Dimension _scriptBrowserSize = null;
    protected Point _scriptBrowserLocation = null;
    protected ScriptManagerImpl _scriptManager = null;
    protected Vector importPlugins = new Vector();
    protected Vector importPluginExtensions = new Vector();
    protected PhotoViewerJFrame _imageFrame = null;
    protected DataReferenceSet _imagePathnames = null;
    protected int _imageCount = 0;
    protected ShefImportExport shefImportExport = null;
    protected JPopupMenu _popup;
    protected FileDialog openFileDialog;
    protected JPanel jPanelToolBar;
    protected SelectionAndFilterPanel _selectionAndFilterPanel;
    protected JToolBar jToolBar1;
    protected FlatPanelButton OpenOldTool;
    protected FlatPanelButton PlotTool;
    protected FlatPanelButton TabulateTool;
    protected FlatPanelButton GraphicalEditTool;
    protected FlatPanelButton ValidationEditTool;
    protected FlatPanelButton MathFunctionTool;
    protected JPanel jPanelFileName;
    protected RmaJTextField fileName;
    protected JLabel jLabelPathsShown;
    protected JLabel jLabelPathsSelected;
    protected JLabel jLabelPathsFile;
    protected JLabel jLabelFileSize;
    protected JLabel jLabelFileReadOnly;
    protected JLabel jLabelFileVersion;
    protected JLabel jLabelLibraryVersion;
    protected JLabel jLabelLibraryDate;
    protected JLabel searchPathnameLabel;
    protected JLabel messageField;
    protected JPanel _statusPanel;
    protected boolean fComponentsAdjusted = false;
    protected JMenuBar mainMenuBar;
    protected JMenu fileMenu;
    protected JMenuItem miLogOff;
    protected JMenuItem miNew;
    protected JMenuItem miNewRemote;
    protected JMenuItem miOpenLocal;
    protected JMenuItem miOpenRemote;
    protected JMenuItem miSaveAsLocal;
    protected JMenuItem miSaveAsRemote;
    protected JMenuItem miClose;
    protected JMenuItem miPrint;
    protected JMenuItem miPrintPreview;
    protected JMenuItem miSave;
    protected JMenuItem miSaveAs;
    protected JMenuItem miExit;
    protected JMenuItem[] miPastFile;
    protected JMenu editMenu;
    protected JMenu miUndelete;
    protected JMenuItem miUndeleteAll;
    protected JMenuItem miUndeleteSelected;
    protected JMenuItem miUndo;
    protected JMenuItem miDelete;
    protected JMenuItem miSelectAll;
    protected JMenuItem miEditData;
    protected JMenuItem miGraphicalEdit;
    protected JMenuItem miValidationEdit;
    protected JMenuItem miCopyRecords;
    protected JMenuItem miCopyLocalRecords;
    protected JMenuItem miCopyRemoteRecords;
    protected JMenuItem miCopyRecordsTo;
    protected JMenuItem miDuplicateRecords;
    protected JMenuItem miRenameRecords;
    protected JMenuItem miMergeFiles;
    protected JMenuItem miMergeLocalFiles;
    protected JMenuItem miMergeRemoteFiles;
    protected JMenu viewMenu;
    protected JCheckBoxMenuItem pathnameListCheckBox;
    protected JCheckBoxMenuItem pathnamePartsCheckBox;
    protected JCheckBoxMenuItem condensedCatalogCheckBox;
    protected JCheckBoxMenuItem condensedCatalogCollectionsCheckBox;
    protected JCheckBoxMenuItem noPathnamesCheckBox;
    protected JCheckBoxMenuItem unsortedListCheckBox;
    protected JCheckBoxMenuItem pathnameStringSearch;
    protected JCheckBoxMenuItem pathnamePartsSearch;
    protected JCheckBoxMenuItem wildCharsSearch;
    protected JMenuItem miRefreshCatalog;
    protected JMenu displayMenu;
    protected JMenuItem miPlot;
    protected JMenuItem miWaterQualityPlot;
    protected JMenuItem miPlotIndividualSets;
    protected JMenu miPlotOptions;
    protected JCheckBoxMenuItem miNormalize;
    protected JCheckBoxMenuItem miSyncTimes;
    protected JMenuItem miTabulate;
    protected JMenuItem miSupplementalInfo;
    protected JMenuItem miTimeWindow;
    protected JMenuItem miShow;
    protected JMenuItem miRun;
    protected JMenuItem mDefaultDisplay;
    protected JMenuItem mPopPlot;
    protected JMenuItem mPopTabulate;
    protected JMenuItem mPopEditData;
    protected JMenuItem mPopCopyPathnames;
    protected JMenuItem mPopRenameRecords;
    protected JMenuItem mPopDuplicateRecords;
    protected JMenuItem mPopCopyRecords;
    protected JMenuItem mPopCopyRecordsLocal;
    protected JMenuItem mPopCopyRecordsRemote;
    protected JMenuItem mPopDelete;
    protected JMenuItem mPopMoveTop;
    protected JMenuItem mPopMoveUp;
    protected JMenuItem mPopMoveDown;
    protected JMenuItem mPopMoveBottom;
    protected JMenu menuTimeZone;
    protected JCheckBoxMenuItem asStoredTimeZoneItem;
    protected JCheckBoxMenuItem localTimeZoneItem;
    protected JCheckBoxMenuItem watershedTimeZoneItem;
    protected JCheckBoxMenuItem gmtTimeZoneItem;
    protected JCheckBoxMenuItem selectTimeZoneItem;
    protected JMenu menuUnitSystem;
    protected JCheckBoxMenuItem _asStoredUnitItem;
    protected JCheckBoxMenuItem _englishUnitItem;
    protected JCheckBoxMenuItem _SIUnitItem;
    protected int _unitSystem = 3;
    public static final String AS_STORED_STR = "As Stored";
    public static final String LOCAL_TIME_ZONE_STR = "Local";
    public static final String WATERSHED_TIME_ZONE_STR = "Watershed";
    public static final String CUSTOM_TIME_ZONE_STR = "Custom";
    public static final String UTC_TIME_ZONE_STR = "UTC";
    public static final int AS_STORED = 0;
    public static final int LOCAL_TIME_ZONE = 1;
    public static final int WATERSHED_TIME_ZONE = 2;
    public static final int CUSTOM_TIME_ZONE = 3;
    public static final int UTC_TIME_ZONE = 4;
    protected int _timeZoneEnum;
    protected String _timeZoneId = "";
    protected JMenu groupMenu;
    protected JMenuItem miGroupAdd;
    protected JMenu miGroupGet_Clear;
    protected JMenu miGroupGet_Add;
    protected JMenu miGroupPlot;
    protected JMenu miGroupIndividualPlot;
    protected JMenu miGroupTabulate;
    protected JMenu miGroupMath;
    protected JMenuItem miGroupManage;
    protected JMenuItem[] miGroupGetNames;
    protected JMenuItem[] miGroupPlotNames;
    protected JMenuItem[] miGroupIndividualPlotNames;
    protected JMenuItem[] miGroupTabulateNames;
    protected JMenuItem[] miGroupMathNames;
    protected JMenu dataEntryMenu;
    protected JMenuItem miTSDataEntry;
    protected JMenuItem miPDDataEntry;
    protected JMenuItem miTextEntry;
    protected JMenu miImport;
    protected JMenuItem miImportShef;
    protected JMenuItem miImportText;
    protected JMenuItem miImportImages;
    protected JMenuItem miImportFiles;
    protected JMenu miExport;
    protected JMenuItem miExportShef;
    protected JMenuItem miExportToFile;
    protected JMenu toolsMenu;
    protected JMenuItem miMath;
    protected JMenuItem miCompare;
    protected JMenuItem miCompareFiles;
    protected JMenuItem miCompareFilesOptions;
    protected JMenuItem miCompareDataSets;
    protected JMenuItem miCompareDataSetsOptions;
    protected JMenuItem miSearch;
    protected JMenuItem miCheckIntegrity;
    protected JMenuItem miSqueezeFile;
    protected JMenuItem miConvertFile;
    protected JMenuItem miScripts;
    protected JMenu miScriptButtons;
    protected JMenu customMenu;
    protected JMenu scriptMenu;
    protected JMenu advancedMenu;
    protected JMenu catalogFileMenu;
    protected JMenuItem unsortSelectiveCatFileMenu;
    protected JMenuItem sortedCatalogMenu;
    protected JMenuItem selectiveCatFileMenu;
    protected JMenuItem menuDebugFileInfo;
    protected JMenuItem menuFileAccessInfo;
    protected JMenuItem miDebugRecordBins;
    protected JMenuItem menuDssStatus;
    protected JMenuItem menuZset;
    protected JMenuItem menuZinqir;
    protected JMenuItem menuMemoryMonitor;
    protected JMenu miDebug;
    protected JMenuItem menuMessageLevel;
    protected JMenuItem menuExamineFile;
    protected JMenuItem miRecordAddresses;
    protected JMenu miOutput;
    protected JMenuItem miConsole;
    protected JMenuItem miViewDssLog;
    protected JMenuItem miViewShefLog;
    protected JMenuItem miProgramOptions;
    private static String _iconURL;
    private static String _highResIconURL;
    private static String _aboutImageURL;
    protected JDialog _wildcardChooserDialog = null;
    public static final int FILE = 0;
    public static final int EDIT = 1;
    public static final int VIEW = 2;
    public static final int DISPLAY = 3;
    public static final int GROUPS = 4;
    public static final int DATA_ENTRY = 5;
    public static final int TOOLS = 6;
    public static final int CUSTOM = 7;
    public static final int SCRIPTS = 8;
    public static final int ADVANCED = 9;
    public static final int HELP = 10;
    public static final int PLOT_FILE = 11;
    public static final int PLOT_EDIT = 12;
    public static final int PLOT_VIEW = 13;
    public static final int TABLE_FILE = 14;
    public static final int TABLE_EDIT = 15;
    public static final int TABLE_VIEW = 16;
    public static final int MATH_FILE = 17;
    public static final int MATH_EDIT = 18;
    public static final int MATH_DISPLAY = 19;
    protected boolean _pluginsAdded = false;
    protected boolean _extendedPluginsAdded = false;
    protected Vector[] pluginVector = new Vector[20];
    private JMenuBar _menuBar = null;
    private static final int TIMESERIES_CONTAINER = 0;
    private static final int PAIREDDATA_CONTAINER = 1;
    private static final int TEXT_CONTAINER = 2;
    private static final int GRIDDED_CONTAINER = 3;
    private static final int RATING_CONTAINER = 4;
    private static final int PATHNAMES_CONTAINER = 5;
    private static final int ARRAY_CONTAINER = 6;
    private static final int LOCATION_CONTAINER = 7;
    private static final int TIN_CONTAINER = 8;
    protected JMenu helpMenu;
    protected JMenuItem miAbout;
    private JMenuItem _helpMenuItem = new JMenuItem();
    private ScriptButtonPanel _scriptButtonPanel;
    private JPanel _scriptButtonToolbarPanel;
    private boolean _useCollection;
    private int _maxRecord = 10000;

    public ListSelection(String titleName, int mode, boolean useTabbedPane, boolean exitOnClose, boolean clientServer) {
        if (titleName != null && titleName.length() > 1) {
            this._titleName = titleName;
        }
        this._mode = mode;
        this._exitOnClose = exitOnClose;
        this._allowRemote = this._remote = clientServer;
        this._dataManager = new LocalDssDataManager();
        this.setup(useTabbedPane);
        if (mode == 2) {
            this._options = new OptionsDialog(this, this._preferences, this._appDirectory, false);
        }
    }

    public ListSelection(String titleName, int mode, boolean exitOnClose, boolean clientServer) {
        this(titleName, mode, false, exitOnClose, clientServer);
    }

    public ListSelection() {
        this._mode = 2;
        this._dataManager = new LocalDssDataManager();
        this.setup(true);
        this._options = new OptionsDialog(this, this._preferences, this._appDirectory, false);
    }

    public static void setShowPopupMessages(boolean showPopups) {
        _showPopups = showPopups;
    }

    public boolean isRemote() {
        return this._remote;
    }

    public static boolean isInteractive() {
        if (_isInteractiveSet) {
            return _isInteractive;
        }
        boolean interactive = ListSelection.testIfInteractive();
        ListSelection.setIsInteractive(true, interactive);
        return interactive;
    }

    public static void setIsInteractive(boolean isInteractiveSet, boolean isInteractive) {
        _isInteractiveSet = isInteractiveSet;
        _isInteractive = isInteractive;
    }

    public static boolean testIfInteractive() {
        if (!_showPopups) {
            return false;
        }
        Frame[] frames = ScriptButtonFrame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].getClass().getName().equals("hec.dssgui.ListSelection")) {
                return true;
            }
            if (!frames[i].getClass().getName().equals("hec.cwmsVue.CwmsListSelection")) continue;
            return true;
        }
        return false;
    }

    public static String getBuildTimeFromManifest() {
        Class<ListSelection> clazz = ListSelection.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Build-Time");
            return value;
        }
        catch (IOException e) {
            return "Error reading build date.";
        }
    }

    public static String getBetaFromManifest() {
        Class<ListSelection> clazz = ListSelection.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Beta-Tag");
            if (value == null) {
                return "";
            }
            return value;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static ListSelection getMainWindow() {
        ListSelection mainWindow = null;
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!ListSelection.class.isAssignableFrom(frames[i].getClass()) || !frames[i].isVisible()) continue;
            mainWindow = (ListSelection)frames[i];
            break;
        }
        if (mainWindow == null) {
            mainWindow = ListSelection.createMainWindow();
        }
        return mainWindow;
    }

    public static void setProgramName(String programName) {
        _programName = programName;
    }

    public static void setVersionNumber(String versionNumber) {
        _versionNumber = versionNumber;
    }

    public static ListSelection createMainWindow() {
        return new ListSelection("", 2, true, false, ClientAppCheck.isNetworked());
    }

    public static ListSelection createMainWindow(boolean remote) {
        return new ListSelection("", 2, true, false, remote);
    }

    public DataReferenceSet getSelectionList() {
        DataReferenceSet selectionList = this._selectionAndFilterPanel.getSelectedPathnames();
        return selectionList;
    }

    public DataReferenceSet getSelectedPathnames() {
        DataReferenceSet selectionList = this._selectionAndFilterPanel.getSelectedPathnames();
        return selectionList;
    }

    public Vector getSelectedPaths() {
        return this._selectionAndFilterPanel.getSelectedPathnames().getPathnameSet();
    }

    public String getFilterSelection(int partNumber) {
        return this._selectionAndFilterPanel.getFilterSelection(partNumber);
    }

    public void clearSelection() {
        this._selectionAndFilterPanel.clearSelection();
    }

    public void clear() {
        this.clearSelection();
    }

    public void setSelectedPathnames(Vector selectedPathnames) {
        String s;
        String filename = "";
        if (this._dataManager != null && (s = this._dataManager.DSSFileName()) != null) {
            filename = s;
        }
        DataReferenceSet dataReferenceSet = new DataReferenceSet(selectedPathnames, filename);
        this.setSelectedList(dataReferenceSet);
    }

    public void setSelectedList(DataReferenceSet selected) {
        this._selectionAndFilterPanel.clearSelection();
        this._selectionAndFilterPanel.addToSelection(selected);
    }

    public Preferences getPreferences() {
        return this._preferences;
    }

    public JPanel getToolBarPanel() {
        return this.jPanelToolBar;
    }

    public void addToolBarButton(JButton button) {
        int pos = 5;
        if (this.jToolBar1.getComponentCount() <= pos) {
            pos = -1;
        }
        this.jToolBar1.add((Component)button, pos);
    }

    public void registerImportPlugin(hec.dssgui.plugins.ImportPlugin importPlugin, JMenuItem menuItem, String dropAndDragExtension) {
        if (this.miImport != null) {
            this.miImport.add((Component)menuItem, 1);
        }
        if (importPlugin != null && dropAndDragExtension != null) {
            this.importPlugins.add(importPlugin);
            this.importPluginExtensions.add(dropAndDragExtension);
        }
    }

    public void registerImportPlugin(ImportPlugin importPlugin, JMenuItem menuItem, String dropAndDragExtension) {
        if (this.miImport != null) {
            this.miImport.add((Component)menuItem, 1);
        }
        if (importPlugin != null && dropAndDragExtension != null) {
            this.importPlugins.add(importPlugin);
            this.importPluginExtensions.add(dropAndDragExtension);
        }
    }

    public void registerExportPlugin(JMenuItem menuItem) {
        if (this.miExport != null) {
            this.miExport.add((Component)menuItem, 0);
        }
    }

    public void setCustomMenu(String menuText) {
        this.customMenu.setText(menuText);
        this.customMenu.setVisible(true);
    }

    public void setScriptMenu(String menuText) {
        this.scriptMenu.setText(menuText);
        this.scriptMenu.setVisible(true);
    }

    public void registerPlugin(int menuNumber, JMenuItem menuItem) {
        if (menuNumber < 0) {
            return;
        }
        if (menuNumber > 19) {
            return;
        }
        if (this.pluginVector[menuNumber] == null) {
            this.pluginVector[menuNumber] = new Vector();
        }
        this.pluginVector[menuNumber].add(menuItem);
        if (menuNumber >= 11) {
            this._extendedPluginsAdded = true;
        }
    }

    public JToolBar getToolBar() {
        return this.jToolBar1;
    }

    public JMenu getImportMenu() {
        return this.miImport;
    }

    public JMenu getExportMenu() {
        return this.miExport;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    public JMenu getDisplayMenu() {
        return this.displayMenu;
    }

    public JMenu getCustomMenu() {
        this.customMenu.setVisible(true);
        return this.customMenu;
    }

    public JMenu getScriptMenu() {
        this.scriptMenu.setVisible(true);
        return this.scriptMenu;
    }

    public JMenu getAdvancedMenu() {
        return this.advancedMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public boolean runScript(ScriptIdentifier id) {
        if (id == null) {
            System.out.println("runScript:Null ScriptIdentifier ");
            return false;
        }
        try {
            Script script = this.getScriptManager().getScript(id);
            if (script == null) {
                return false;
            }
            int rv = ScriptEngine.engine().execute(script, id.getUserDisplayedName(), id.getName());
            return rv == 0;
        }
        catch (Exception ex) {
            System.out.println("Error executing script " + id.getFileName() + " Error:" + ex);
            return false;
        }
    }

    protected ScriptManager getScriptManager() {
        if (this._scriptManager == null) {
            this._scriptManager = ScriptManagerImpl.getInstance();
        }
        return this._scriptManager;
    }

    public void setTimeWindow(String timeWindow) {
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        HecTime.getTimeWindow((String)timeWindow, (HecTime)start, (HecTime)end);
        this.setTimeWindow(start, end, true);
    }

    public void time(String timeWindow) {
        this.setTimeWindow(timeWindow);
    }

    public void setFilter(String pathFilter) {
        this._selectionAndFilterPanel.setFilter(pathFilter);
    }

    public void setPathSelectionMode(int selectionMode) {
        this._selectionAndFilterPanel.setPathSelectionMode(selectionMode);
        if (this._mode == 1 && selectionMode == 1) {
            this.mainMenuBar.remove(this.editMenu);
        }
    }

    public void displayScriptEditor() {
        if (this._scriptEditor == null) {
            this._scriptEditor = new ScriptEditor(this, true);
            this._scriptEditor.addScriptEventListener(this);
            Help.setHelp((RootPaneContainer)((Object)this._scriptEditor), "36");
        }
        this._scriptEditor.setVisible(true);
    }

    public void displayScriptButtons(String groupName) {
        ScriptButtonFrame scriptButtonFrame = new ScriptButtonFrame(this, groupName){};
        scriptButtonFrame.setPreferences(this._preferences);
        Preferences sbfPrefs = this._preferences.node("ScriptButtonFrame-" + groupName);
        Point p = scriptButtonFrame.getLocation();
        Dimension size = scriptButtonFrame.getSize();
        int x = sbfPrefs.getInt("x", p.x);
        int y = sbfPrefs.getInt("y", p.y);
        int width = sbfPrefs.getInt("width", size.width);
        int height = sbfPrefs.getInt("height", size.height);
        scriptButtonFrame.setLocation(x, y);
        scriptButtonFrame.setSize(width, height);
        if (scriptButtonFrame.getState() == 1) {
            scriptButtonFrame.setState(0);
        }
        scriptButtonFrame.setVisible(true);
    }

    public void displayScriptButtons() {
        if (this._scriptButtonFrame == null) {
            this._scriptButtonFrame = new ScriptButtonFrame(this){

                @Override
                public void setVisible(boolean visible) {
                    if (!visible) {
                        Preferences sbfPrefs = ListSelection.this._preferences.node("ScriptButtonFrame");
                        Point p = ListSelection.this._scriptButtonFrame.getLocation();
                        Dimension size = ListSelection.this._scriptButtonFrame.getSize();
                        sbfPrefs.putInt("x", p.x);
                        sbfPrefs.putInt("y", p.y);
                        sbfPrefs.putInt("width", size.width);
                        sbfPrefs.putInt("height", size.height);
                    }
                    super.setVisible(visible);
                }
            };
            Preferences sbfPrefs = this._preferences.node("ScriptButtonFrame");
            Point p = this._scriptButtonFrame.getLocation();
            Dimension size = this._scriptButtonFrame.getSize();
            int x = sbfPrefs.getInt("x", p.x);
            int y = sbfPrefs.getInt("y", p.y);
            int width = sbfPrefs.getInt("width", size.width);
            int height = sbfPrefs.getInt("height", size.height);
            this._scriptButtonFrame.setLocation(x, y);
            this._scriptButtonFrame.setSize(width, height);
        }
        if (this._scriptButtonFrame.getState() == 1) {
            this._scriptButtonFrame.setState(0);
        }
        this._scriptButtonFrame.setVisible(true);
    }

    public void displayConsole() {
        if (this._console != null) {
            ConsoleWindow w = this._console.getConsoleWindow();
            Help.setHelp((RootPaneContainer)w, "30");
            this._console.showConsole();
        }
    }

    public void displayOptions() {
        this.getOptions().setVisible(true);
    }

    public OptionsDialog getOptions() {
        if (this._options == null) {
            this._options = new OptionsDialog(this, this._preferences, this._appDirectory, false);
            this._options.addObserver(this);
        }
        return this._options;
    }

    public void displayDssLog() {
        block3: {
            if (this._dssLogFile == null) {
                return;
            }
            Heclib.fortranFlush((int)this._dssLogUnit);
            try {
                this.printViewFile(this._dssLogFile, false);
            }
            catch (Exception e) {
                String mess = "Unable to access DSS log file: " + this._dssLogFile + "\n" + e.toString();
                System.out.println(mess);
                if (!ListSelection.isInteractive()) break block3;
                JOptionPane.showMessageDialog(this, mess, _programName, 2);
            }
        }
    }

    public void displayShefLog() {
        block3: {
            if (this._shefLogFile == null) {
                return;
            }
            try {
                this.printViewFile(this._shefLogFile, false);
            }
            catch (Exception e) {
                String mess = "Unable to access SHEF log file: " + this._shefLogFile + "\n" + e.toString();
                System.out.println(mess);
                if (!ListSelection.isInteractive()) break block3;
                JOptionPane.showMessageDialog(this, mess, _programName, 2);
            }
        }
    }

    protected String getShefLogFile() {
        return this._shefLogFile;
    }

    protected void setShefLogFile(String logFileName) {
        this._shefLogFile = logFileName;
    }

    public void setCursorWait() {
        this.setCursorWait("Working...");
    }

    public void setCursorWait(String message) {
        this.setCursor(new Cursor(3));
        this.updateMessageField(message);
        this._statusIcon.setState(1);
    }

    public void setCursorDefault() {
        this.setCursor(new Cursor(0));
        this.updateMessageField();
        this._statusIcon.setState(2);
        this._statusIcon.revalidate();
    }

    public void scriptEventPerformed(ScriptEvent event) {
        this.buildScriptButtons();
        if (this._scriptButtonFrame != null) {
            this._scriptButtonFrame.updateScriptButtons();
        }
    }

    public void setConsole(Console console) {
        this._console = console;
        if (this._console != null) {
            this.miConsole.setVisible(true);
        }
    }

    public void setDssLogFile(String logFile) {
        stringContainer name = new stringContainer();
        this._dssLogUnit = this.openLogFile(this._dssLogUnit, logFile, "HEC-DSS", name);
        this._dssLogFile = name.string;
        if (this._dssLogUnit != 6) {
            this.miViewDssLog.setVisible(true);
        }
        Heclib.zset((String)"MUNIT", (String)"", (int)this._dssLogUnit);
    }

    public static String getLogFileName(String prefix, String givenName) {
        File f;
        String pathSeparator = System.getProperty("file.separator");
        Object tempDirectory = System.getProperty("java.io.tmpdir");
        if (!((String)tempDirectory).endsWith(pathSeparator)) {
            tempDirectory = (String)tempDirectory + pathSeparator;
        }
        if (!(f = new File((String)(tempDirectory = (String)tempDirectory + "HEC-DSSVue"))).isDirectory()) {
            f.mkdirs();
        }
        tempDirectory = (String)tempDirectory + System.getProperty("file.separator");
        Object name = givenName == null ? (String)tempDirectory + prefix + ".log" : givenName;
        f = new File((String)name);
        if (f.exists() && !f.delete()) {
            for (int i = 0; i < 100; ++i) {
                String tryName = (String)tempDirectory + prefix + Integer.toString(i) + ".log";
                f = new File(tryName);
                if (f.exists()) {
                    if (!f.delete()) continue;
                    name = tryName;
                    break;
                }
                name = tryName;
                break;
            }
        }
        return name;
    }

    protected int openLogFile(int unit, String givenName, String prefix, stringContainer finalName) {
        finalName.string = ListSelection.getLogFileName(prefix, givenName);
        int stat = Heclib.fortranOpen((String)finalName.string, (int)unit);
        if (stat != 0) {
            return 6;
        }
        return unit;
    }

    public void setScriptEditorForegroundColor(String color) {
        this._scriptEditorForegroundColor = color;
    }

    public void setScriptEditorBackgroundColor(String color) {
        this._scriptEditorBackgroundColor = color;
    }

    public void setScriptEditorFont(String font) {
        this._scriptEditorFont = font;
    }

    public void setScriptBrowserSize(Dimension size) {
        this._scriptBrowserSize = size;
    }

    public void setScriptBrowserLocation(Point location) {
        this._scriptBrowserLocation = location;
    }

    public void setScriptBrowserSizeAndLocation(Dimension size, Point location) {
        this.setScriptBrowserSize(size);
        this.setScriptBrowserLocation(location);
    }

    public void setScriptEditorTabSize(int tabsize) {
        this._scriptEditorTabSize = tabsize;
    }

    public String getScriptEditorForegroundColor() {
        return this._scriptEditorForegroundColor;
    }

    public String getScriptEditorBackgroundColor() {
        return this._scriptEditorBackgroundColor;
    }

    public String getScriptEditorFont() {
        return this._scriptEditorFont;
    }

    public int getScriptEditorTabSize() {
        return this._scriptEditorTabSize;
    }

    public Dimension getscriptBrowserSize() {
        return this._scriptBrowserSize;
    }

    public Point getscriptBrowserLocation() {
        return this._scriptBrowserLocation;
    }

    public void maximize() {
        this.setExtendedState(6);
    }

    public void minimize() {
        this.iconify();
    }

    public void iconify() {
        this.setExtendedState(1);
    }

    public void restore() {
        this.setExtendedState(0);
    }

    public void setDirectory(String directory) {
        this._currentDirectory = directory != null && !this._remote ? directory.replace('/', File.separatorChar) : directory;
    }

    public String getDirectory() {
        return this._currentDirectory;
    }

    public void setRemoteDirectory(String directory) {
        this._lastOpenedRemoteDirectory = directory != null && !this._remote ? directory.replace('/', File.separatorChar) : directory;
    }

    public String getRemoteDirectory() {
        String remoteDirectory = this._lastOpenedRemoteDirectory;
        if (remoteDirectory == null) {
            String url = HecDataManagerRemote.getDSSManagerUrl();
            remoteDirectory = this.lookupWorkingDir(url);
        }
        return remoteDirectory;
    }

    public boolean setDSSFilename(String DSSFileName) {
        return this.openDSSFile(DSSFileName, true, false);
    }

    public boolean setDssFilename(String dssFilename) {
        return this.openDSSFile(dssFilename, true, false);
    }

    public boolean open(String dssFilename) {
        return this.openDSSFile(dssFilename, true, false);
    }

    public void close() {
        this.closeDssFile();
    }

    @Scriptable
    public void finish() {
        this.exitOut();
    }

    public void fin() {
        this.exitOut();
    }

    public String getDSSFilename() {
        if (this._dataManager != null) {
            return this._dataManager.DSSFileName();
        }
        return "";
    }

    public String getDssFilename() {
        return this.getDSSFilename();
    }

    public Vector getDssFilenames() {
        return this._selectionAndFilterPanel.getDssFilenames();
    }

    public DssDataManager getDataManager() {
        return this._dataManager;
    }

    public void addToSelection(String pathname) {
        this._selectionAndFilterPanel.addToSelection(pathname);
    }

    public void path(String pathname) {
        this.addToSelection(pathname);
    }

    public void selectAll() {
        this._selectionAndFilterPanel.selectAll();
    }

    public void removeFromSelection() {
        this._selectionAndFilterPanel.removeFromSelection();
    }

    protected void menuTimeZoneSelected(ActionEvent event) {
        Object object = event.getSource();
        if (object instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)object;
            if (checkBox.getText().startsWith("As ")) {
                this.setTimeZone(0);
            } else if (checkBox.getText().startsWith("Loc")) {
                this.setTimeZone(1);
            } else if (checkBox.getText().startsWith(UTC_TIME_ZONE_STR)) {
                this.setTimeZone(4);
            } else if (checkBox.getText().startsWith("Wat")) {
                this.setTimeZone(2);
            } else if (checkBox.getText().startsWith("Cust")) {
                PanelEditor pe = new PanelEditor((Frame)this, false);
                TimeZonePanel tzp = new TimeZonePanel(){

                    public boolean savePanel(NamedType dobj) {
                        ListSelection.this._timeZone = this.getSelectedTimeZone();
                        ListSelection.this.setTimeZone(3);
                        return true;
                    }
                };
                TimeZone tz = this._timeZone;
                tzp.setSelectedTimeZone(tz);
                tzp.setInternationalDefault(false);
                pe.setTitle("Select a Time Zone");
                pe.addPanel((AbstractEditorPanel)tzp);
                pe.fillForm(null);
                pe.pack();
                pe.setVisible(true);
            }
        }
    }

    public void setTimeZone(int timeZoneEnum, TimeZone timeZone) {
        if (timeZoneEnum == 0) {
            this.asStoredTimeZoneItem.setSelected(true);
        } else if (timeZoneEnum == 1) {
            this.localTimeZoneItem.setSelected(true);
        } else if (timeZoneEnum == 2) {
            this.watershedTimeZoneItem.setSelected(true);
        } else if (timeZoneEnum == 4) {
            this.gmtTimeZoneItem.setSelected(true);
        } else {
            this.selectTimeZoneItem.setSelected(true);
            this._timeZone = timeZone;
        }
        this.setTimeZone(timeZoneEnum);
    }

    protected String getTimeZonePref() {
        String timeZonePref = "";
        if (!_standAlone) {
            timeZonePref = "Embedded/";
        }
        if (ClientAppCheck.haveClientApp()) {
            return timeZonePref + "TimeZone";
        }
        return timeZonePref + "DssVueTimeZone";
    }

    protected void setTimeZone(int timeZoneEnum) {
        TimeZoneDisplayService timeZoneDisplayService;
        this._timeZoneEnum = timeZoneEnum;
        if (this._timeZoneEnum == 0) {
            this._preferences.put(this.getTimeZonePref(), AS_STORED_STR);
            this._timeZone = null;
            this._timeZoneId = "";
        } else if (this._timeZoneEnum == 1) {
            this._preferences.put(this.getTimeZonePref(), LOCAL_TIME_ZONE_STR);
            this._timeZone = TimeZone.getDefault();
            this._timeZoneId = this._timeZone.getDisplayName(false, 0);
        } else if (this._timeZoneEnum == 4) {
            this._preferences.put(this.getTimeZonePref(), UTC_TIME_ZONE_STR);
            this._timeZone = TimeZone.getTimeZone(UTC_TIME_ZONE_STR);
            this._timeZoneId = this._timeZone.getDisplayName(false, 0);
        } else {
            if (this._timeZone != null) {
                this._timeZoneId = this._timeZone.getDisplayName(false, 0);
            } else if (this._timeZoneId != null && this._timeZoneId.length() > 0) {
                this._timeZone = TimeZone.getTimeZone(this._timeZoneId);
            } else {
                this.setTimeZone(1);
                return;
            }
            this._preferences.put(this.getTimeZonePref(), this._timeZoneId);
        }
        if (this._dataManager != null) {
            this._dataManager.setTimeZone(this._timeZone);
        }
        if (null != (timeZoneDisplayService = ServiceLookup.getTimeZoneDisplayService()) && _standAlone) {
            timeZoneDisplayService.setTimeZone(this._timeZone);
        }
        HecTimeArray.setGlobalViewTimeZone((TimeZone)this._timeZone);
        TimeSeriesDataModel.setGlobalViewTimeZone((TimeZone)this._timeZone);
        this.updateMessageField();
        this._selectionAndFilterPanel.getTimeWindowDialog().setTimeZone(this._timeZone);
    }

    public void setUnitSystem(int unitSystem) {
        this._unitSystem = unitSystem;
        this._asStoredUnitItem.setSelected(false);
        this._englishUnitItem.setSelected(false);
        this._SIUnitItem.setSelected(false);
        if (this._unitSystem == 2) {
            this._SIUnitItem.setSelected(true);
        } else if (this._unitSystem == 1) {
            this._englishUnitItem.setSelected(true);
        } else {
            this._asStoredUnitItem.setSelected(true);
        }
        if (this._dataManager != null) {
            this._dataManager.setDisplayUnitSystem(this._unitSystem);
        }
        this._preferences.putInt("unitSystem", this._unitSystem);
        this.updateMessageField();
    }

    protected void menuUnitsSelected(ActionEvent event) {
        Object object = event.getSource();
        if (object instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)object;
            if (checkBox.getText().equals("SI")) {
                if (!checkBox.getState()) {
                    if (this._unitSystem == 2) {
                        this._SIUnitItem.setSelected(true);
                    }
                    return;
                }
                this._unitSystem = 2;
                this._englishUnitItem.setSelected(false);
                this._asStoredUnitItem.setSelected(false);
            } else if (checkBox.getText().equals("English")) {
                if (!checkBox.getState()) {
                    if (this._unitSystem == 1) {
                        this._englishUnitItem.setSelected(true);
                    }
                    return;
                }
                this._unitSystem = 1;
                this._SIUnitItem.setSelected(false);
                this._asStoredUnitItem.setSelected(false);
            } else if (checkBox.getText().equals(AS_STORED_STR)) {
                if (!checkBox.getState()) {
                    if (this._unitSystem == 3) {
                        this._asStoredUnitItem.setSelected(true);
                    }
                    return;
                }
                this._unitSystem = 3;
                this._SIUnitItem.setSelected(false);
                this._englishUnitItem.setSelected(false);
            }
            if (this._dataManager != null) {
                this._dataManager.setDisplayUnitSystem(this._unitSystem);
            }
            this._preferences.putInt("unitSystem", this._unitSystem);
            this.updateMessageField();
        }
    }

    protected void openMenu(boolean remote, boolean mustExist, boolean newFile, int dssVersion) {
        String title = newFile ? "Create new HEC-DSS File" : "Open HEC-DSS File";
        String filename = this.openDSSFileDialog(remote, title, newFile);
        if (filename != null) {
            this.openDSSFile(filename, true, remote, mustExist, dssVersion);
        }
    }

    public String openDSSFileDialog(boolean remote, String title) {
        return this.openDSSFileDialog(remote, title, false);
    }

    private String getLocalFile(String title, boolean newFile) {
        JFileChooser chooser = this._currentDirectory != null ? new JFileChooser(this._currentDirectory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(title);
        if (newFile) {
            chooser.setApproveButtonText("Create");
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.dss", "dss");
        chooser.addChoosableFileFilter(filter);
        int option = chooser.showOpenDialog(this);
        if (option != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private String getRemoteFile(String title) {
        String remoteFile = null;
        RmiFileDialog chooser = new RmiFileDialog((Frame)this, true);
        FileOpener fileOpener = this.getFileOpener();
        if (fileOpener == null) {
            RMAIO.postError((Component)this, (String)"FileManager is unavailable.");
        } else {
            chooser.setFileOpener(fileOpener);
            chooser.setTitle(title);
            String remoteDirectory = this.getRemoteDirectory();
            chooser.setStartDir(remoteDirectory);
            ArrayList<String> v = new ArrayList<String>();
            v.add("*.dss");
            chooser.setFileMask(v);
            chooser.setOpenTitle();
            chooser.setVisible(true);
            if (!chooser.isCanceled()) {
                remoteFile = chooser.getIdentifier().getPath();
            }
        }
        return remoteFile;
    }

    public String openDSSFileDialog(boolean remote, String title, boolean newFile) {
        if (!remote) {
            return this.getLocalFile(title, newFile);
        }
        return this.getRemoteFile(title);
    }

    protected String lookupWorkingDir(String filemanagerUrl) {
        String workingDir = ".";
        DSSManager dssManager = ServerSuiteUtil.getDssManager();
        if (dssManager != null) {
            try {
                workingDir = dssManager.getServerProperty("CWMS_HOME");
            }
            catch (RemoteException e) {
                System.out.println("Error getting remote user.dir");
            }
            return workingDir;
        }
        if (filemanagerUrl == null) {
            filemanagerUrl = System.getProperty("DSSFileManager");
        }
        if (filemanagerUrl != null) {
            Remote r = null;
            try {
                r = Naming.lookup(filemanagerUrl);
                DSSManager fm = (DSSManager)r;
                workingDir = dssManager.getServerProperty("CWMS_HOME");
            }
            catch (Exception e) {
                System.out.println("Error Looking up DSS Server @ " + filemanagerUrl + ". " + e);
            }
        }
        return workingDir;
    }

    protected FileOpener getFileOpener() {
        FileOpener fileOpener;
        if (ClientAppCheck.haveClientApp() && (fileOpener = this.reflectGetFileOpener()) != null) {
            return fileOpener;
        }
        return this.lookupFileOpener();
    }

    protected FileOpener reflectGetFileOpener() {
        FileOpener fileOpener = null;
        try {
            Class<?> workspaceDssManagerClass = Class.forName("hec.client.WorkspaceDssManager");
            Class[] parameterTypes = new Class[]{};
            Method getFileOpenerMethod = workspaceDssManagerClass.getMethod("getFileOpener", parameterTypes);
            Object[] args = new Object[]{};
            fileOpener = (FileOpener)getFileOpenerMethod.invoke(workspaceDssManagerClass, args);
        }
        catch (Exception e) {
            System.out.println("Unable to get Workspace DSS Manager.");
            e.printStackTrace();
        }
        return fileOpener;
    }

    protected FileOpener lookupFileOpener() {
        return ServerSuiteUtil.getRemoteFileOpener();
    }

    public boolean openDSSFile(String DSSFileName) {
        return this.openDSSFile(DSSFileName, true, true);
    }

    public boolean openDSSFile(String DSSFileName, boolean firstManager, boolean mustExist) {
        boolean remote = DssDataManager.isRemoteFileName((String)DSSFileName);
        return this.openDSSFile(DSSFileName, firstManager, remote, mustExist, 0);
    }

    public boolean openDSSFile(String DSSFileName, boolean firstManager, boolean remote, boolean mustExist, int dssVersion) {
        int status;
        if (remote) {
            this.miImportShef.setVisible(false);
        }
        DssDataManager dataManager = this.createDataManager(remote);
        if (this._timeZone != null) {
            dataManager.setTimeZone(this._timeZone);
        }
        dataManager.setDisplayUnitSystem(this._unitSystem);
        stringContainer cleanName = new stringContainer();
        dataManager.cleanDSSFileName(DSSFileName, cleanName);
        String message1 = "Cleaning file name from " + DSSFileName + "\nto " + cleanName.string;
        System.out.println(message1);
        DSSFileName = cleanName.string;
        boolean fileAlreadyExists = dataManager.doesDSSFileExist(DSSFileName);
        if (!fileAlreadyExists) {
            dssVersion = 7;
        }
        if (mustExist && !fileAlreadyExists) {
            String message = "The file " + DSSFileName + "\ndoes not exist.\nWould you like to Create it?";
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                int opt = JOptionPane.showConfirmDialog(this, message, _programName, 2);
                if (opt != 0) {
                    return false;
                }
                mustExist = false;
            } else {
                return false;
            }
        }
        if (firstManager) {
            this.miUndo.setEnabled(false);
        }
        if ((status = dataManager.setDSSFileName(DSSFileName, mustExist, dssVersion)) != 0) {
            this.processError(dataManager);
            this._showErrorOnEmptyFile = false;
            this.setCursorDefault();
            return false;
        }
        if (!fileAlreadyExists) {
            String message = "Created file " + DSSFileName;
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 1);
            }
            this._showErrorOnEmptyFile = false;
        } else {
            this._showErrorOnEmptyFile = true;
        }
        if (firstManager) {
            if (this._secondDataManager != null && dataManager.DSSFileName().equals(this._secondDataManager.DSSFileName())) {
                this._secondDataManager = null;
                this.miCopyRecordsTo.setVisible(false);
            }
            this._dataManager = dataManager;
            HecDataManager.setDefaultDSSFileName((String)DSSFileName);
            if (this._titleName.length() == 0) {
                this.setTitle(RMAIO.getFileFromPath((String)DSSFileName) + " - " + _programName);
            }
            if (remote) {
                String remoteDirectory = RMAIO.getDirectoryFromPath((String)this._dataManager.DSSFileName());
                this.setRemoteDirectory(remoteDirectory);
            } else {
                this._currentDirectory = RMAIO.getDirectoryFromPath((String)this._dataManager.DSSFileName());
            }
            this.newTableView(true, false, true);
            this.updateMenuItems(true);
        } else {
            if (this._secondDataManager != null && !this._secondDataManager.DSSFileName().equals(dataManager.DSSFileName())) {
                this._secondDataManager.close();
            }
            this._secondDataManager = dataManager;
        }
        String name = DSSFileName.replace('\\', '/');
        for (int i = this._pastFilesAccessed.size() - 1; i >= 0; --i) {
            String pastName = (String)this._pastFilesAccessed.elementAt(i);
            if (!(pastName = pastName.replace('\\', '/')).equalsIgnoreCase(name)) continue;
            this._pastFilesAccessed.removeElementAt(i);
        }
        this._pastFilesAccessed.addElement(DSSFileName);
        this.updateFileMenu();
        return true;
    }

    protected DssDataManager createDataManager(boolean remote) {
        if (remote) {
            return new RmiDssDataManager();
        }
        return new LocalDssDataManager();
    }

    public void closeDssFile() {
        if (this._dataManager != null && this._dataManager.fileOpened()) {
            this._dataManager.close();
        }
        if (this._secondDataManager != null && this._secondDataManager.fileOpened()) {
            this._secondDataManager.close();
        }
        this._selectionAndFilterPanel.closeAllFileTabs();
        this.refreshCatalog();
    }

    protected void updateFileStats(DssDataManager dataManager) {
        int readOnly;
        int kbytes;
        int numberRecords;
        if (dataManager == null || dataManager.isExplicitlyClosed()) {
            numberRecords = 0;
            kbytes = 0;
            readOnly = 0;
            this.fileName.setText("");
            this.jLabelFileVersion.setText(" ");
            this.enableSaveAs(false);
        } else {
            numberRecords = dataManager.numberRecords();
            kbytes = dataManager.zinqir("SIZE");
            readOnly = dataManager.zinqir("READ");
            this.fileName.setText(dataManager.DSSFileName());
            stringContainer alpha = new stringContainer();
            int[] numb = new int[1];
            dataManager.zinqir("FVER", alpha, numb);
            Object fileVers = "";
            if (!alpha.string.isEmpty()) {
                fileVers = "  File Version: " + alpha.string;
            }
            this.jLabelFileVersion.setText((String)fileVers);
            this.setLibrary(dataManager);
            this.enableSaveAs(true);
        }
        String numberCommas = NumberFormat.getIntegerInstance().format(numberRecords);
        this.jLabelPathsFile.setText("       " + this._pathnames + " in File:  " + numberCommas);
        if (kbytes > 1024) {
            DecimalFormat fmt = new DecimalFormat("#.##");
            if (kbytes > 0x100000) {
                this.jLabelFileSize.setText("       File Size:  " + fmt.format((double)kbytes / 1048576.0) + "  GB");
            } else {
                this.jLabelFileSize.setText("       File Size:  " + fmt.format((double)kbytes / 1024.0) + "  MB");
            }
        } else {
            this.jLabelFileSize.setText("       File Size:  " + kbytes + "  KB");
        }
        if (readOnly == 1) {
            this.jLabelFileReadOnly.setText("  Read Only");
        } else {
            this.jLabelFileReadOnly.setText(" ");
        }
    }

    protected void enableSaveAs(boolean enable) {
        if (this.miSaveAsLocal != null) {
            this.miSaveAsLocal.setEnabled(enable);
        }
        if (this.miSaveAsRemote != null) {
            this.miSaveAsRemote.setEnabled(enable);
        }
    }

    private void setLibrary(DssDataManager dataManager) {
        stringContainer alpha = new stringContainer();
        int[] numb = new int[1];
        dataManager.zquery("VERS", alpha, numb);
        Object libVersion = "";
        if (!alpha.string.isEmpty()) {
            libVersion = "  Library Version: " + alpha.string;
        }
        if (this.jLabelLibraryVersion != null) {
            this.jLabelLibraryVersion.setText((String)libVersion);
        }
        Object libDate = "";
        if (numb[0] == 7) {
            alpha = new stringContainer();
            numb = new int[1];
            dataManager.zquery("date", alpha, numb);
            if (alpha.string.trim().length() > 5) {
                libDate = "    Library Date: " + alpha.string.trim();
            }
        }
        if (this.jLabelLibraryDate != null) {
            this.jLabelLibraryDate.setText((String)libDate);
        }
    }

    public boolean isDssFileAccessible() {
        if (this._dataManager == null) {
            return false;
        }
        if (!this._dataManager.fileAccessible()) {
            if (this._dataManager.DSSFileName().length() > 0) {
                String message = "The HEC-DSS file " + this._dataManager.DSSFileName() + " is not accessible";
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, message, _programName, 2);
                }
            }
            return false;
        }
        return true;
    }

    public DssDataManager getFirstDataManager() {
        return this._dataManager;
    }

    public DssDataManager getSecondDataManager() {
        return this._secondDataManager;
    }

    public void refreshCatalog() {
        this.newTableView(true, true, false);
    }

    public void updateCatalog() {
        this.updateCatalog(false);
    }

    public void updateCatalog(boolean renamedRecords) {
        int numberInFile = this._dataManager.numberRecords();
        if (numberInFile != this._numberCataloged || renamedRecords) {
            this.refreshCatalog();
        }
        if (this._selectionAndFilterPanel.getPathnamesDisplayedSize() == 0 && numberInFile > 0) {
            this.newTableView(false, false, false);
        }
    }

    protected void newTableView(boolean newCatalog, boolean createCatalog, boolean newTab) {
        CondensedReference[] cr;
        if (this._dataManager == null) {
            return;
        }
        if (createCatalog) {
            this._createCatalog = true;
        }
        if (this._viewStatePrevious == 5 || this._viewStatePrevious == 4) {
            newCatalog = true;
        }
        if (this._viewStatePrevious == 3) {
            newCatalog = true;
        }
        if (!(this._viewState != 2 && this._viewState != 3 || (cr = this._selectionAndFilterPanel.getCondensedCatalog()) != null && cr.length != 0)) {
            newCatalog = true;
        }
        this.updateTableView(newCatalog, newTab);
    }

    protected LoadCatalogSwingWorker buildLoadCatalogSwingWorker() {
        return new LoadCatalogSwingWorker(this._dataManager);
    }

    protected boolean fileAccessible() {
        return this._dataManager.fileAccessible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTableView(boolean newCatalog, boolean newTab) {
        boolean opened = this.fileAccessible();
        this.updateMenuItems(opened);
        if (!opened) {
            return;
        }
        if (this._viewState == 4) {
            this.newPathTable(newTab);
            String[] paths = new String[]{};
            this._selectionAndFilterPanel.setPathnameList(paths, this._dataManager);
            this.pathnameListUpdated();
            return;
        }
        if (newCatalog) {
            this._dataManager.setForceNewCatalog(newCatalog);
            this.newPathTable(newTab);
            this._selectionAndFilterPanel.setPathnameList(new String[0], this._dataManager);
            if (ListSelection.isInteractive()) {
                this._selectionAndFilterPanel.enableTabCloseButtons(false);
                this.buildLoadCatalogSwingWorker().execute();
            } else {
                this.setCursorWait("Building catalog...");
                try {
                    if (this._viewState == 2 || this._viewState == 3) {
                        CondensedReference[] condensed = this.getCondensedCatalog();
                        this._selectionAndFilterPanel.setCondensedCatalog(condensed, this._dataManager);
                    } else {
                        String[] paths = this.catalogFile(this._createCatalog);
                        this._selectionAndFilterPanel.setPathnameList(paths, this._dataManager);
                    }
                    this.pathnameListUpdated();
                }
                finally {
                    this.setCursorDefault();
                }
            }
        } else if (this._viewState == 2 || this._viewState == 3) {
            CondensedReference[] condensed = this._selectionAndFilterPanel.getCondensedCatalog();
            if (condensed == null) {
                condensed = this.getCondensedCatalog();
            }
            this.newPathTable(newTab);
            this._selectionAndFilterPanel.setCondensedCatalog(condensed, this._dataManager);
        } else {
            String[] paths = this._selectionAndFilterPanel.getPathnameList();
            this.newPathTable(newTab);
            this._selectionAndFilterPanel.setPathnameList(paths, this._dataManager, false);
        }
    }

    protected void newPathTable(boolean newTab) {
        this._selectionAndFilterPanel.newTableView(this._viewState, newTab, this._dataManager.DSSFileName());
        this._selectionAndFilterPanel.addObserver(this);
        if (newTab) {
            this._selectionAndFilterPanel.resetSearchString();
        }
    }

    protected void pathnameListUpdated() {
        this._selectionAndFilterPanel.pathnameListUpdated();
        this.updateFileStats(this._dataManager);
        String numberCommas = NumberFormat.getIntegerInstance().format(this._selectionAndFilterPanel.getPathnamesDisplayedSize());
        this.jLabelPathsShown.setText(this._pathnames + " Shown:  " + numberCommas);
        if (this._selectionAndFilterPanel.getPathnamesDisplayedSize() > 0) {
            this.miPrint.setEnabled(true);
            this.miPrintPreview.setEnabled(true);
        } else {
            this.miPrint.setEnabled(false);
            this.miPrintPreview.setEnabled(false);
        }
        this.setCursorDefault();
    }

    protected boolean useCatalogWildChars() {
        return true;
    }

    public String[] catalogFile(boolean forceUpdate) {
        return this.catalogFile(forceUpdate, true);
    }

    private String[] catalogFile(boolean forceUpdate, boolean bWait) {
        if (!this.isDssFileAccessible()) {
            return new String[0];
        }
        if (this._viewState != 4) {
            if (bWait) {
                this.setCursorWait("Building catalog...");
            }
            this._operationCanceled = false;
            this.shutDownDssVueProgressBar();
            if (debug) {
                System.out.println("Enter ListSelection.catalogFile() ");
                ElapsedTime.elapsedTimeMils();
            }
        }
        if (this.wildCharsSearch.isSelected() && this.useCatalogWildChars()) {
            String pathWithWildChars = this.getWildCardChooserDlg().getSelectedItem();
            if (pathWithWildChars != null && pathWithWildChars.trim().length() > 0) {
                this._catalogWithWildChars = pathWithWildChars.trim();
                this._catalogWithWildCharsChoices.add(this._catalogWithWildChars);
            } else {
                this._catalogWithWildChars = null;
            }
        } else {
            this._catalogWithWildChars = null;
        }
        String[] paths = null;
        try {
            this._dataManager.setForceNewCatalog(forceUpdate);
            paths = this._viewState == 5 ? this._dataManager.getCatalog(false, this._catalogWithWildChars) : this._dataManager.getCatalog(true, this._catalogWithWildChars);
            if (paths == null) {
                this._numberCataloged = 0;
                paths = new String[]{};
            } else {
                this._numberCataloged = paths.length;
            }
        }
        catch (Exception except) {
            System.out.println("Error, unable to catalog file: " + except.toString());
            return null;
        }
        if (debug) {
            System.out.println("Catalog complete " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
        if (this._numberCataloged <= 0) {
            int nRecs = this._dataManager.numberRecords();
            if (nRecs == 0) {
                if (this._showErrorOnEmptyFile && ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, "There are no records in the HEC-DSS File.", _programName, 1);
                }
            } else {
                String mess = "Unable to access the HEC-DSS catalog file";
                System.out.println(mess);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, mess, _programName, 2);
                }
                this.setCursorDefault();
                return new String[0];
            }
        }
        this._dataManager.setCatalogNeedsUpdate(false);
        this.checkForSevereError(this._dataManager);
        return paths;
    }

    public String[] catalogFile(intArrayContainer startDatesContainer, intArrayContainer endDatesContainer, boolean forceUpdate) {
        return this.catalogFile(forceUpdate);
    }

    protected CondensedReference[] getCondensedCatalog() {
        if (!this.isDssFileAccessible()) {
            return new CondensedReference[0];
        }
        if (this.wildCharsSearch.isSelected() && this.useCatalogWildChars()) {
            String pathWithWildChars = this.getWildCardChooserDlg().getSelectedItem();
            if (pathWithWildChars != null && pathWithWildChars.trim().length() > 0) {
                this._catalogWithWildChars = pathWithWildChars.trim();
                this._catalogWithWildCharsChoices.add(this._catalogWithWildChars);
            } else {
                this._catalogWithWildChars = null;
            }
        } else {
            this._catalogWithWildChars = null;
        }
        this.setCursorWait("Building catalog...");
        this._operationCanceled = false;
        this.shutDownDssVueProgressBar();
        if (debug) {
            System.out.println("Enter ListSelection.catalogFile() ");
            ElapsedTime.elapsedTimeMils();
        }
        CondensedReference[] condensedReference = this._dataManager.getCondensedCatalog(this._catalogWithWildChars);
        this._numberCataloged = condensedReference.length;
        if (debug) {
            System.out.println("Catalog complete " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
        if (this._numberCataloged <= 0) {
            int nRecs = this._dataManager.numberRecords();
            if (nRecs == 0) {
                if (this._showErrorOnEmptyFile && ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, "There are no records in the HEC-DSS File.", _programName, 1);
                }
            } else {
                String mess = this._numberCataloged < 0 ? "Unable to access the HEC-DSS catalog file" : "No pathnames match selection.";
                System.out.println(mess);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, mess, _programName, 2);
                }
                this.setCursorDefault();
                return new CondensedReference[0];
            }
        }
        this._dataManager.setCatalogNeedsUpdate(false);
        this.checkForSevereError(this._dataManager);
        return condensedReference;
    }

    public void printCatalog(boolean showPreview) {
        this._selectionAndFilterPanel.printCatalog(showPreview);
    }

    public void updateSelectionIcons() {
        int numberSelected = this._selectionAndFilterPanel.getSelectedPathnamesSize();
        boolean flag = numberSelected > 0;
        this.PlotTool.setEnabled(flag);
        this.TabulateTool.setEnabled(flag);
        this.GraphicalEditTool.setEnabled(flag);
        this.ValidationEditTool.setEnabled(flag);
        this.MathFunctionTool.setEnabled(flag);
        this.miPlot.setEnabled(flag);
        this.miWaterQualityPlot.setEnabled(flag);
        this.miPlotIndividualSets.setEnabled(flag);
        this.miPlotOptions.setEnabled(flag);
        this.miTabulate.setEnabled(flag);
        this.miGraphicalEdit.setEnabled(flag);
        this.miValidationEdit.setEnabled(flag);
        this.miGroupAdd.setEnabled(flag);
        this.miMath.setEnabled(flag);
        this.miDelete.setEnabled(flag);
        this.miEditData.setEnabled(flag);
        this.miCopyRecords.setEnabled(flag);
        this.miCopyLocalRecords.setEnabled(flag);
        this.miCopyRemoteRecords.setEnabled(flag);
        this.miCopyRecordsTo.setEnabled(flag);
        this.miDuplicateRecords.setEnabled(flag);
        this.miRenameRecords.setEnabled(flag);
        this.miExport.setEnabled(flag);
        if (this.mDefaultDisplay != null) {
            this.mDefaultDisplay.setEnabled(flag);
        }
        this.mPopPlot.setEnabled(flag);
        this.mPopTabulate.setEnabled(flag);
        this.mPopEditData.setEnabled(flag);
        this.mPopCopyPathnames.setEnabled(flag);
        this.mPopRenameRecords.setEnabled(flag);
        this.mPopDuplicateRecords.setEnabled(flag);
        this.mPopCopyRecords.setEnabled(flag);
        this.mPopCopyRecordsRemote.setEnabled(flag);
        this.mPopCopyRecordsLocal.setEnabled(flag);
        this.mPopDelete.setEnabled(flag);
        this.miSearch.setEnabled(flag);
        this.miSupplementalInfo.setEnabled(false);
        this.miRecordAddresses.setEnabled(false);
        this.miCompareDataSets.setEnabled(false);
        this.miCompareDataSetsOptions.setEnabled(false);
        this.miShow.setVisible(false);
        this.miRun.setVisible(flag);
        this.miExportToFile.setVisible(false);
        this.enableReadMenus(flag);
        this.enableWriteMenus(flag);
        if (flag) {
            String path;
            if (!this.miClose.isEnabled() && this._dataManager.fileOpened()) {
                this.miClose.setEnabled(true);
            }
            if ((path = this._selectionAndFilterPanel.getFirstSelectedPathname()) == null || path.isEmpty()) {
                return;
            }
            int type = HecDataManager.pathnameDataType((String)path);
            if (numberSelected > 1) {
                this.miCompareDataSets.setEnabled(true);
                this.miCompareDataSetsOptions.setEnabled(true);
            }
            this.miSupplementalInfo.setEnabled(true);
            this.miRecordAddresses.setEnabled(true);
            boolean visible = false;
            if (type == 610) {
                visible = true;
            }
            this.miShow.setVisible(visible);
            if (type == 600) {
                visible = true;
            }
            this.miRun.setVisible(visible);
            if (type == 0 && (type = this._dataManager.recordType(path)) == 300) {
                visible = true;
            }
            this.miExportToFile.setVisible(visible);
        }
    }

    public void updateMenuItems(boolean fileOpened) {
        this.miSelectAll.setEnabled(fileOpened);
        this.miRefreshCatalog.setEnabled(fileOpened);
        this.miCompare.setEnabled(fileOpened);
        this.miMergeFiles.setEnabled(fileOpened);
        this.miMergeLocalFiles.setEnabled(fileOpened);
        this.miMergeRemoteFiles.setEnabled(fileOpened);
        this.miCheckIntegrity.setEnabled(fileOpened);
        this.miConvertFile.setEnabled(fileOpened);
        this.miTSDataEntry.setEnabled(fileOpened);
        this.miPDDataEntry.setEnabled(fileOpened);
        this.miTextEntry.setEnabled(fileOpened);
        this.miImport.setEnabled(fileOpened);
        this.miUndelete.setEnabled(fileOpened);
        this.menuZinqir.setEnabled(fileOpened);
        this.menuDebugFileInfo.setEnabled(fileOpened);
        this.menuFileAccessInfo.setEnabled(fileOpened);
        this.miDebugRecordBins.setEnabled(fileOpened);
        this.catalogFileMenu.setEnabled(fileOpened);
        if (fileOpened) {
            int vers = this._dataManager.zinqir("VERS");
            if (vers == 6) {
                this.miConvertFile.setText("Convert to DSS Version 7");
                this.miConvertFile.setVisible(true);
            } else {
                this.miConvertFile.setVisible(false);
            }
            String dssFileName = this._dataManager.getDSSFileName();
            if (!this._dataManager.writeAccess()) {
                this.miTSDataEntry.setEnabled(false);
                this.miPDDataEntry.setEnabled(false);
                this.miTextEntry.setEnabled(false);
                this.miUndelete.setEnabled(false);
                this.miImport.setEnabled(false);
            }
            boolean visible = !this._dataManager.isRemote();
            this.catalogFileMenu.setVisible(visible);
            this.miMergeFiles.setText("Copy " + dssFileName + " into...");
            this.miMergeLocalFiles.setText("Copy " + dssFileName + " into local...");
            this.miMergeRemoteFiles.setText("Copy " + dssFileName + " into remote...");
            if (this._dataManager.zinqir("COLL") == 0) {
                if (this.condensedCatalogCollectionsCheckBox.isSelected()) {
                    this.condensedCatalogCheckBox.setSelected(true);
                    this.condensedCatalogCollectionsCheckBox.setSelected(false);
                }
                this.condensedCatalogCollectionsCheckBox.setVisible(false);
            } else {
                this.condensedCatalogCollectionsCheckBox.setVisible(true);
            }
        } else {
            this.miConvertFile.setVisible(false);
            this.miMergeFiles.setText("Copy records into...");
        }
    }

    public int getNumberSelectedPathnames() {
        return this._selectionAndFilterPanel.getSelectedPathnamesSize();
    }

    @Scriptable
    public List[] getSelectedDataContainers() {
        return this.getSelectedDataContainers(false);
    }

    public List[] getSelectedDataContainers(boolean useDisplayOptions) {
        this.checkNumberOpenWindows();
        if (this.getNumberSelectedPathnames() <= 0) {
            return null;
        }
        Vector[] dataSets = this.readData(false, false, useDisplayOptions);
        return (List[])dataSets.clone();
    }

    @Scriptable
    public DataContainer read(String pathname) {
        DataReference dataReference = new DataReference(pathname, "");
        return this.read(dataReference);
    }

    @Scriptable
    public DataContainer read(String pathname, HecTime startTime, HecTime endTime) {
        DataReference dataReference = new DataReference(pathname, "");
        dataReference.setTimeWindow(startTime, endTime);
        return this.read(dataReference);
    }

    @Scriptable
    public DataContainer read(String pathname, String timeWindowString) {
        DataReference dataReference = new DataReference(pathname, "");
        dataReference.setTimeWindow(timeWindowString);
        return this.read(dataReference);
    }

    @Scriptable
    public DataContainer read(DataReference dataReference) {
        if (this._dataManager == null) {
            return null;
        }
        if (!this._dataManager.fileAccessible()) {
            return null;
        }
        DataReferenceSet drs = new DataReferenceSet();
        drs.add((Object)dataReference);
        Vector[] data = this.readData(drs, false);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null || data[i].size() <= 0) continue;
            Object obj = data[i].get(0);
            if (obj instanceof DataContainer) {
                return (DataContainer)obj;
            }
            if (i != 5) continue;
            String path = obj.toString();
            try {
                DssFileContainer FileContainer;
                int status;
                if (path.indexOf("/IMAGE/") > 0) {
                    PhotoViewerInfo info = new PhotoViewerInfo();
                    int status2 = this._dataManager.readImage(dataReference, info);
                    if (status2 == 0) {
                        return info;
                    }
                } else if (path.indexOf("/FILE/") > 0 && (status = this._dataManager.readData(dataReference, FileContainer = new DssFileContainer())) == 0) {
                    return FileContainer;
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return null;
        }
        return null;
    }

    @Scriptable
    public boolean write(DataContainer dataContainer) {
        return this.save(dataContainer);
    }

    public Vector[] readData() {
        return this.readData(false, false, true);
    }

    public Vector[] readData(boolean getRecordInfo, boolean quickOnly) {
        return this.readData(getRecordInfo, quickOnly, false);
    }

    public Vector[] readData(boolean getRecordInfo, boolean quickOnly, boolean useDisplayOptions) {
        DataReferenceSet selectedPathnames = this._selectionAndFilterPanel.getSelectedPathnames(quickOnly);
        Vector[] dataSets = this.readData(selectedPathnames, getRecordInfo);
        if (useDisplayOptions && dataSets[0] != null) {
            if (this._normalize) {
                this.normalizeDisplay(dataSets[0]);
            }
            if (this._syncTimes) {
                this.syncDisplayTimes(dataSets[0], true);
            }
        }
        return dataSets;
    }

    private static void addContainer(Vector[] dataSets, int containerIndex, Object container) {
        if (dataSets[containerIndex] == null) {
            dataSets[containerIndex] = new Vector();
        }
        dataSets[containerIndex].add(container);
    }

    public Vector[] readData(DataReferenceSet selectedPathnames, boolean getRecordInfo) {
        Vector[] dataSets = new Vector[9];
        if (selectedPathnames == null || selectedPathnames.isEmpty()) {
            return dataSets;
        }
        DataReference dataSet = null;
        StringBuilder message = new StringBuilder("No data found for:");
        int numberSetsNotRead = 0;
        DssDataManager dataManager = this._dataManager;
        if (dataManager == null) {
            dataSet = selectedPathnames.get(0);
            boolean remote = dataSet.getFilename().startsWith("/");
            dataManager = this.createDataManager(remote);
            dataManager.setDSSFileName(dataSet.getFilename());
            this._dataManager = dataManager;
        }
        selectedPathnames = selectedPathnames.expandWaterYear();
        if (!this._useCollection) {
            selectedPathnames = selectedPathnames.expandCollections();
        }
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        this.getTimeWindow(startTime, endTime);
        boolean timeWindowDefined = startTime.isDateDefined();
        for (int i = 0; i < selectedPathnames.size(); ++i) {
            block46: {
                int status;
                dataSet = selectedPathnames.get(i);
                if (dataSet == null) continue;
                if (timeWindowDefined && !dataSet.hasTimeWindow()) {
                    dataSet.setTimeWindow(startTime, endTime);
                }
                if ((dataManager = this.getDssDataManager(dataSet.getFilename(), dataManager)) == null) break;
                int type = dataManager.recordType(dataSet.getPath());
                if (type >= 100 && type < 200) {
                    if (dataSet.isaCollection()) {
                        TimeSeriesCollectionContainer collectionContainer = new TimeSeriesCollectionContainer();
                        if (getRecordInfo) {
                            collectionContainer.otherInfo = new HecDSSRecordInfo();
                        }
                        if ((status = dataManager.readData(dataSet, collectionContainer, !timeWindowDefined)) == 0) {
                            ListSelection.addContainer(dataSets, 0, collectionContainer);
                        } else {
                            ++numberSetsNotRead;
                            message.append("\n   " + dataSet.getPath());
                            message.append("\nStatus:  " + status);
                            dataSet.getTimeWindow(startTime, endTime);
                            if (startTime.isDefined()) {
                                message.append("\nTime window:  " + startTime.toString(7) + "   to   " + endTime.toString(7));
                            }
                        }
                    } else {
                        TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
                        if (getRecordInfo) {
                            timeSeriesContainer.otherInfo = new HecDSSRecordInfo();
                        }
                        if ((status = dataManager.readData(dataSet, timeSeriesContainer, !timeWindowDefined)) == 0 && (!timeSeriesContainer.allMissing() || timeSeriesContainer.hasValidProfileData())) {
                            ListSelection.addContainer(dataSets, 0, timeSeriesContainer);
                        } else {
                            ++numberSetsNotRead;
                            message.append("\n   " + dataSet.getPath());
                            message.append("\nStatus:  " + status);
                            dataSet.getTimeWindow(startTime, endTime);
                            if (startTime.isDefined()) {
                                message.append("\nTime window:  " + startTime.toString(7) + "   to   " + endTime.toString(7));
                            }
                        }
                    }
                } else if (type >= 200 && type < 300) {
                    PairedDataContainer pairedDataContainer = new PairedDataContainer();
                    if (getRecordInfo) {
                        pairedDataContainer.otherInfo = new HecDSSRecordInfo();
                    }
                    if ((status = dataManager.readData(dataSet, pairedDataContainer)) == 0) {
                        ListSelection.addContainer(dataSets, 1, pairedDataContainer);
                    } else {
                        ++numberSetsNotRead;
                        message.append("\n   " + dataSet.getPath());
                    }
                } else if (type >= 300 && type < 400) {
                    TextContainer textContainer = new TextContainer();
                    status = dataManager.readData(dataSet, textContainer);
                    if (status >= 0) {
                        ListSelection.addContainer(dataSets, 2, textContainer);
                    } else {
                        ++numberSetsNotRead;
                        message.append("\n   " + dataSet.getPath());
                    }
                } else if (type == 450) {
                    TinContainer tinContainer = new TinContainer();
                    status = dataManager.readData(dataSet, tinContainer);
                    if (status == 0) {
                        ListSelection.addContainer(dataSets, 8, tinContainer);
                    } else {
                        ++numberSetsNotRead;
                        message.append("\n   " + dataSet.getPath());
                    }
                } else if (type >= 400 && type < 500) {
                    GridContainer gridContainer = new GridContainer();
                    status = dataManager.readData(dataSet, gridContainer);
                    if (status == 0) {
                        ListSelection.addContainer(dataSets, 3, gridContainer);
                    } else {
                        ++numberSetsNotRead;
                        message.append("\n   " + dataSet.getPath());
                    }
                } else if (type >= 90 && type < 100) {
                    ArrayContainer arrayContainer = new ArrayContainer();
                    status = dataManager.readData(dataSet, arrayContainer);
                    if (status > 0) {
                        ListSelection.addContainer(dataSets, 6, arrayContainer);
                    } else {
                        ++numberSetsNotRead;
                        message.append("\n   " + dataSet.getPath());
                    }
                } else if (type == 20) {
                    DataContainer dc = new DataContainer();
                    dc.fullName = dataSet.getPath();
                    status = -1;
                    try {
                        status = this._dataManager.readLocation(dc);
                        if (status >= 0) {
                            ListSelection.addContainer(dataSets, 7, dc);
                            break block46;
                        }
                        ++numberSetsNotRead;
                        message.append("\n   " + dataSet.getPath());
                    }
                    catch (Exception exception) {}
                } else {
                    ListSelection.addContainer(dataSets, 5, dataSet.getPathname());
                }
            }
            if (!this.checkForSevereError(dataManager)) continue;
            return dataSets;
        }
        if (dataManager != null && !this._dataManager.DSSFileName().equals(dataManager.DSSFileName())) {
            dataManager.close();
        }
        if (numberSetsNotRead > 0) {
            System.out.println(message.toString());
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message.toString(), _programName, 2);
            }
        }
        return dataSets;
    }

    private DssDataManager getDssDataManager(String filename, DssDataManager currentDataManager) {
        if (filename != null && !filename.equals(currentDataManager.DSSFileName())) {
            currentDataManager = this.createManagerForFileName(filename);
        }
        return currentDataManager;
    }

    protected DssDataManager createManagerForFileName(String filename) {
        boolean remote = DssDataManager.isRemoteFileName((String)filename);
        DssDataManager dataManager = this.createDataManager(remote);
        dataManager.setDisplayUnitSystem(this._unitSystem);
        dataManager.setTimeZone(this._timeZone);
        int status = dataManager.setDSSFileName(filename, true, 0);
        if (status < 0 || this.checkForSevereError(dataManager)) {
            return null;
        }
        return dataManager;
    }

    public boolean checkForError(DssDataManager dataManager) {
        boolean error = false;
        if (dataManager == null) {
            error = HecDSSFileAccess.checkForSevereError();
        } else if (dataManager.getDssFileVersion() == 6) {
            error = dataManager.checkForSevereError();
        } else if (dataManager.getDssFileVersion() == 7 && dataManager.dataManager() instanceof HecDSSFileAccess) {
            int ierr = ((HecDSSFileAccess)dataManager.dataManager()).checkForError();
            if (ierr < 2) {
                return false;
            }
            this.processError(dataManager);
        }
        if (error) {
            StringBuffer message = new StringBuffer();
            if (dataManager != null) {
                DSSErrorMessage errorMessage = dataManager.lastSevereErrorMessage();
                message.append("Error; Severity: ");
                message.append(errorMessage.errorCode);
                message.append("\nMessage: ");
                message.append(errorMessage.errorMessage);
                dataManager.clearSevereError();
            } else {
                stringContainer container = new stringContainer();
                int[] returnInt = new int[1];
                Heclib.zquery((String)"ERROR", (stringContainer)container, (int[])returnInt);
                message.append("Error; code: ");
                message.append(returnInt[0]);
                message.append("\nMessage: ");
                message.append(container.toString());
                message.append("\n(After making a backup, squeeze the file for recovery)");
            }
            if (this._remote) {
                message.append("\nCheck log file for details.");
            }
            System.out.println(message.toString());
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message.toString(), _programName + " Error", 0);
            }
        }
        return error;
    }

    protected boolean processError(DssDataManager dataManager) {
        int option;
        if (dataManager == null) {
            String message = "Unknown Error / Unable to access file";
            System.out.println(message.toString());
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName + " Critical Error", 0);
            }
            return false;
        }
        DSSErrorMessage errorMessage = dataManager.lastErrorMessage();
        dataManager.clearSevereError();
        if (errorMessage == null || errorMessage.errorType == 0) {
            return false;
        }
        StringBuffer message = new StringBuffer();
        if (errorMessage.errorType < 3) {
            this.buildErrorMessage(message, errorMessage, true);
            return true;
        }
        this.buildErrorMessage(message, errorMessage, false);
        message.append("\nProgram must exit.\nPress OK to exit or Cancel to attempt to continue.");
        System.out.println(message.toString());
        if (ListSelection.isInteractive() && (option = JOptionPane.showConfirmDialog(this, message.toString(), _programName + " Critical Error", 2, 0)) == 2) {
            return true;
        }
        System.exit(-1);
        return true;
    }

    protected void buildErrorMessage(StringBuffer message, DSSErrorMessage errorMessage, boolean showDialog) {
        int icon = 1;
        if (errorMessage.errorType == 1) {
            message.append("Warning:\n");
            icon = 2;
        } else if (errorMessage.errorType == 2) {
            message.append("File access error:\n");
            icon = 2;
        } else if (errorMessage.errorType == 3) {
            message.append("File corruption error:\n");
            icon = 0;
        } else if (errorMessage.errorType == 4) {
            message.append("Critical error:\n");
            icon = 0;
        }
        if (errorMessage.errorMessage.trim().length() > 2) {
            message.append(errorMessage.errorMessage);
        }
        if (errorMessage.systemErrorMessage.trim().length() > 2) {
            message.append("\nSystem message: ");
            message.append(errorMessage.systemErrorMessage.trim());
        }
        if (errorMessage.systemError > 0) {
            message.append("\nSystem error code: ");
            message.append(errorMessage.systemError);
        }
        if (errorMessage.lastPathname.trim().length() > 2) {
            message.append("\nPathname: ");
            message.append(errorMessage.lastPathname);
        }
        if (errorMessage.dssFileName.trim().length() > 2) {
            message.append("\nFile: ");
            message.append(errorMessage.dssFileName);
        }
        message.append("\nSeverity: ");
        message.append(errorMessage.severity);
        if (errorMessage.errorType >= 1) {
            if (errorMessage.functionName.trim().length() > 2) {
                message.append("\nError occurred in function: ");
                message.append(errorMessage.functionName);
                if (errorMessage.calledByFunction.trim().length() > 2) {
                    message.append("\nCalled by function: ");
                    message.append(errorMessage.calledByFunction);
                }
            }
            if (errorMessage.lastAddress > 0L) {
                message.append("\nat address: ");
                message.append(errorMessage.lastAddress);
            }
        }
        message.append("\nError Code: ");
        message.append(errorMessage.errorCode);
        System.out.println(message.toString());
        if (showDialog && ListSelection.isInteractive()) {
            JOptionPane.showMessageDialog(this, message.toString(), _programName + " Error", icon);
        }
    }

    public boolean checkForSevereError(DssDataManager dataManager) {
        return this.checkForError(dataManager);
    }

    public G2dDialog plot() {
        List[] dataSets = this.getSelectedDataContainers(true);
        return this.plot(dataSets);
    }

    public void plotWaterQuality() {
        List[] dataSets = this.getSelectedDataContainers(true);
        if (dataSets == null || dataSets.length == 0 || dataSets[0] == null) {
            return;
        }
        WaterQualityProfilePlotWindow tpw = new WaterQualityProfilePlotWindow();
        tpw.setData(dataSets[0]);
        tpw.setSize(1000, 750);
        tpw.setLocationRelativeTo(this);
        tpw.setTitle("Water Quality Profile");
        tpw.setVisible(true);
    }

    public G2dDialog plotIndividualSets() {
        List[] dataSets = this.getSelectedDataContainers(true);
        return this.plot(dataSets, true);
    }

    public G2dDialog plot(boolean quickOnly) {
        this.checkNumberOpenWindows();
        List[] dataSets = this.readData(false, quickOnly, true);
        boolean found = false;
        for (int i = 0; i < dataSets.length; ++i) {
            if (dataSets[i] == null) continue;
            found = true;
        }
        if (!found) {
            return null;
        }
        return this.plot(dataSets);
    }

    public void plot(List<TimeSeriesContainer> objectsToPlot) {
        List[] lists = new List[]{objectsToPlot};
        this.plot(lists);
    }

    public G2dDialog plot(List[] dataSets) {
        G2dDialog rval = this.plot(dataSets, false);
        Help.setHelp((RootPaneContainer)rval, "24");
        return rval;
    }

    protected G2dDialog plot(List[] dataSets, boolean individualSets) {
        G2dDialogIndividualSelect graph = null;
        if (dataSets == null) {
            return graph;
        }
        Vector<Object> dataObjVec = new Vector<Object>();
        Window gridFrame = null;
        for (int i = 0; i < dataSets.length; ++i) {
            int zz;
            if (ListSelection.hasUsableContainer(dataSets, i, 0)) {
                G2dDialogIndividualSelect gfxdlg;
                TimeSeriesDataSet tsds;
                TimeSeriesContainer tsc;
                int zz2;
                dataObjVec.removeAllElements();
                boolean sameTimeZone = true;
                int timezoneOffset = -1;
                String tz = null;
                for (zz2 = 0; zz2 < dataSets[i].size(); ++zz2) {
                    if (dataSets[i].get(zz2) instanceof TimeSeriesCollectionContainer) {
                        TimeSeriesCollectionContainer tscc = (TimeSeriesCollectionContainer)dataSets[i].get(zz2);
                        DssVueSimpleDSSTimeSeriesCollection sts = new DssVueSimpleDSSTimeSeriesCollection(tscc);
                        dataObjVec.addElement(sts);
                        continue;
                    }
                    if (dataSets[i].get(zz2) instanceof TimeSeriesContainer) {
                        tsc = (TimeSeriesContainer)dataSets[i].get(zz2);
                        tsds = (TimeSeriesDataSet)this.createPlotDataObject((DataContainer)tsc);
                        if (tsc.timeZoneID != null && !tsc.timeZoneID.equals("")) {
                            tsc.timeZoneRawOffset = TimeZone.getTimeZone(tsc.timeZoneID).getRawOffset();
                            if (timezoneOffset == -1) {
                                timezoneOffset = tsc.timeZoneRawOffset;
                                tz = tsc.timeZoneID;
                            } else if (timezoneOffset != tsc.timeZoneRawOffset) {
                                sameTimeZone = false;
                            }
                            tsds.setGmtOffset(tsc.timeZoneRawOffset / 3600000);
                        }
                        if (tsc.hasValidProfileData()) {
                            Vector v = HecTimeSeries.expandProfileContainer((TimeSeriesContainer)tsc);
                            dataObjVec.addAll(v);
                            continue;
                        }
                        int paramId = this.getParameterId(tsc.parameter, tsc.units);
                        tsds.setYParameterId(paramId);
                        dataObjVec.addElement(tsds);
                        continue;
                    }
                    tsc = (DataContainer)dataSets[i].get(zz2);
                    G2dObject plotDataObject = this.createPlotDataObject((DataContainer)tsc);
                    if (plotDataObject == null) continue;
                    dataObjVec.addElement(plotDataObject);
                }
                if (!sameTimeZone) {
                    dataObjVec.removeAllElements();
                    for (zz2 = 0; zz2 < dataSets[i].size(); ++zz2) {
                        tsc = (TimeSeriesContainer)dataSets[i].get(zz2);
                        if (tsc.timeZoneID != null && !tsc.timeZoneID.equals("")) {
                            tsc.timeZoneRawOffset = TimeZone.getTimeZone(tsc.timeZoneID).getRawOffset();
                            if (timezoneOffset != tsc.timeZoneRawOffset) {
                                int diff = timezoneOffset - tsc.timeZoneRawOffset;
                                tsc.startTime += (diff /= 60000);
                                tsc.endTime += diff;
                                int jd = 0;
                                while (jd < tsc.times.length) {
                                    int n = jd++;
                                    tsc.times[n] = tsc.times[n] + diff;
                                }
                                tsc.timeZoneID = tz;
                                tsc.timeZoneRawOffset = timezoneOffset;
                            }
                        }
                        tsds = new TimeSeriesDataSet(tsc);
                        if (tsc.timeZoneID != null && !tsc.timeZoneID.equals("")) {
                            tsds.setGmtOffset(tsc.timeZoneRawOffset / 3600000);
                        }
                        int paramId = this.getParameterId(tsc.parameter, tsc.units);
                        tsds.setYParameterId(paramId);
                        dataObjVec.addElement(tsds);
                    }
                }
                if (individualSets && dataSets[i].size() > 1) {
                    gfxdlg = new G2dDialogIndividualSelect((Frame)this, "", dataObjVec);
                } else {
                    gfxdlg = PlotDialogFactory.getPlotDialogCreator().createPlotDialog((Frame)this, ((DataContainer)dataSets[i].get(0)).getFullName(), false, dataObjVec);
                    gfxdlg.setTransferHandler((TransferHandler)this._transferHandler);
                }
                if (this._extendedPluginsAdded) {
                    this.addPlotPlugins((G2dDialog)gfxdlg);
                }
                gfxdlg.setLocation(75, 75);
                gfxdlg.setVisible(true);
                this._objectList.addElement(gfxdlg);
                gfxdlg.addWindowListener((WindowListener)this._windowClosingListener);
                graph = gfxdlg;
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 1)) {
                G2dDialogIndividualSelect gfxdlg;
                dataObjVec.removeAllElements();
                for (zz = 0; zz < dataSets[i].size(); ++zz) {
                    G2dObject gobject = this.createPlotDataObject((DataContainer)dataSets[i].get(zz));
                    if (gobject == null) continue;
                    dataObjVec.addElement(gobject);
                }
                if (individualSets && dataSets[i].size() > 1) {
                    gfxdlg = new G2dDialogIndividualSelect((Frame)this, "", dataObjVec);
                } else {
                    gfxdlg = PlotDialogFactory.getPlotDialogCreator().createPlotDialog((Frame)this, ((DataContainer)dataSets[i].get(0)).getFullName(), false, dataObjVec);
                    gfxdlg.setTransferHandler((TransferHandler)this._transferHandler);
                }
                if (this._extendedPluginsAdded) {
                    this.addPlotPlugins((G2dDialog)gfxdlg);
                }
                gfxdlg.setLocation(75, 75);
                gfxdlg.setVisible(true);
                this._objectList.addElement(gfxdlg);
                gfxdlg.addWindowListener((WindowListener)this._windowClosingListener);
                graph = gfxdlg;
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 3)) {
                int locx = 50;
                int locy = 50;
                for (int j = 0; j < dataSets[i].size(); ++j) {
                    GridContainer gridContainer = (GridContainer)dataSets[i].get(j);
                    if (gridFrame == null) {
                        gridFrame = new GridInfoFrame(gridContainer);
                        gridFrame.setLocation(locx, locy);
                        gridFrame.addWindowListener(this._windowClosingListener);
                        this._objectList.addElement(gridFrame);
                        locx += 20;
                        locy += 20;
                        continue;
                    }
                    ((GridInfoFrame)gridFrame).addGrid(gridContainer);
                }
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 4)) {
                JOptionPane.showMessageDialog(this, "Rating Data cannot be plotted at this time.", "Unable to Plot", 2);
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 5)) {
                this.displayOther((Vector)dataSets[5]);
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 6)) {
                dataObjVec.removeAllElements();
                for (zz = 0; zz < dataSets[i].size(); ++zz) {
                    G2dDialogIndividualSelect gfxdlg;
                    ArrayContainer arrayContainer;
                    PairedDataContainer pairedDataContainer;
                    G2dObject gobject;
                    if (dataSets[i].get(zz) instanceof ArrayContainer && (gobject = this.createPlotDataObject((DataContainer)(pairedDataContainer = (arrayContainer = (ArrayContainer)dataSets[i].get(zz)).getPairedDataContainer()))) != null) {
                        dataObjVec.addElement(gobject);
                    }
                    if (individualSets && dataSets[i].size() > 1) {
                        gfxdlg = new G2dDialogIndividualSelect((Frame)this, "", dataObjVec);
                    } else {
                        gfxdlg = PlotDialogFactory.getPlotDialogCreator().createPlotDialog((Frame)this, ((DataContainer)dataSets[i].get(0)).getFullName(), false, dataObjVec);
                        gfxdlg.setTransferHandler((TransferHandler)this._transferHandler);
                    }
                    if (this._extendedPluginsAdded) {
                        this.addPlotPlugins((G2dDialog)gfxdlg);
                    }
                    gfxdlg.setLocation(75, 75);
                    gfxdlg.setVisible(true);
                    this._objectList.addElement(gfxdlg);
                    gfxdlg.addWindowListener((WindowListener)this._windowClosingListener);
                    graph = gfxdlg;
                }
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 7)) {
                this.showLocationDialog(dataSets[i]);
                continue;
            }
            if (!ListSelection.hasUsableContainer(dataSets, i, 8)) continue;
            int nTins = 0;
            int nPoints = 0;
            for (int j = 0; j < dataSets[i].size(); ++j) {
                TinContainer tinContainer = (TinContainer)dataSets[i].get(j);
                ++nTins;
                nPoints += tinContainer.numberPoints;
            }
            Object message = "TIN Data cannot be plotted at this time.\n";
            if (nTins > 1) {
                message = (String)message + "These " + nTins + " TINs contain " + nPoints + " points\n";
                int avg = nPoints / nTins;
                message = (String)message + " -- an average of " + avg + " per TIN.";
            } else {
                message = (String)message + "This TIN contains " + nPoints + " points.";
            }
            JOptionPane.showMessageDialog(this, message, "Unable to Plot", 2);
        }
        if (gridFrame != null) {
            gridFrame.setVisible(true);
        }
        if (graph != null) {
            this.showTimeZoneInPlotTitle((G2dDialog)graph);
        }
        return graph;
    }

    private void showTimeZoneInPlotTitle(G2dDialog graph) {
        Optional optionalTimeZone = ServiceLookup.getTimeZoneDisplayService().getDisplayTimeZone();
        if (!optionalTimeZone.isPresent()) {
            LOGGER.warning("A time zone for display was not found.");
            return;
        }
        TimeZone timeZone = (TimeZone)optionalTimeZone.get();
        String plotTitle = timeZone.getID();
        graph.getPlotTitle().setVisible(true);
        graph.getPlotTitle().setDrawTitleOn();
        graph.getPlotTitle().setText(plotTitle);
        RmaJLabel component = new RmaJLabel(){

            public void setTimeZone(TimeZone tz) {
                Container container = this.getParent();
                Component component = container.getComponent(0);
                if (component instanceof G2dPanel) {
                    G2dPanel g2dPanel = (G2dPanel)component;
                    g2dPanel.setTitle(tz.getID());
                }
            }
        };
        component.setVisible(false);
        graph.add((Component)component, (Object)"Last");
    }

    protected G2dObject createPlotDataObject(DataContainer dataContainer) {
        return PlotUtilities.createPlotDataObject(dataContainer);
    }

    protected G2dDialog plotFrequency(Vector containers) {
        Vector<G2dObject> dataObjVec = new Vector<G2dObject>();
        for (int i = 0; i < containers.size(); ++i) {
            PairedDataContainer pdc = (PairedDataContainer)containers.elementAt(i);
            G2dObject gobject = this.createPlotDataObject((DataContainer)pdc);
            if (gobject == null) continue;
            dataObjVec.addElement(gobject);
        }
        G2dDialog gfxdlg = new G2dDialog((Frame)this, "Exceedence Probability", false);
        G2dLineProperties lineProps2 = new G2dLineProperties();
        lineProps2._symbolType = 7;
        lineProps2._symbolSize = 5.0f;
        lineProps2._drawPoints = true;
        lineProps2._drawLine = false;
        lineProps2._fillColor = Color.BLUE;
        lineProps2._symbolType = 7;
        lineProps2._pointLineColor = Color.BLUE;
        ArrayList<G2dLineProperties> lineProps = new ArrayList<G2dLineProperties>();
        lineProps.add(lineProps2);
        lineProps2 = new G2dLineProperties();
        lineProps2._drawLine = true;
        lineProps2._lineColor = new Color(254, 50, 50);
        lineProps.add(lineProps2);
        G2dDialog.setUseLineStyles((boolean)false);
        gfxdlg.getPlotpanel().buildComponents(dataObjVec, lineProps);
        Viewport viewport = (Viewport)gfxdlg.getViewports().elementAt(0);
        viewport.setMinorGridXVisible(true);
        viewport.setMinorGridYVisible(true);
        viewport.zoomByFactor(1.0);
        gfxdlg.setLocation(75, 75);
        gfxdlg.setVisible(true);
        return gfxdlg;
    }

    protected int getParameterId(String parameterString) {
        try {
            Parameter param = new Parameter(parameterString);
            int paramId = param.getParameterId();
            if (paramId != Integer.MIN_VALUE) {
                return paramId;
            }
        }
        catch (DataSetIllegalArgumentException e) {
            return -1;
        }
        return -1;
    }

    protected int getParameterId(String parameterString, String units) {
        try {
            Parameter param = new Parameter(parameterString);
            if (!Units.canConvertBetweenUnits((String)param.getUnitsString(), (String)units)) {
                return -1;
            }
            int paramId = param.getParameterId();
            if (paramId != Integer.MIN_VALUE) {
                return paramId;
            }
        }
        catch (DataSetIllegalArgumentException e) {
            return -1;
        }
        return -1;
    }

    protected void displayOther(Vector pathnames) {
        this._imagePathnames = new DataReferenceSet();
        Vector<String> genericFiles = new Vector<String>();
        for (int i = 0; i < pathnames.size(); ++i) {
            String path = (String)pathnames.elementAt(i);
            if (path.indexOf("/IMAGE/") > 0) {
                DataReference dataSet = new DataReference(path, this._dataManager.DSSFileName());
                this._imagePathnames.add((Object)dataSet);
                continue;
            }
            if (path.indexOf("/FILE/") <= 0) continue;
            genericFiles.add(path);
        }
        if (this._imagePathnames.size() > 0) {
            this._imageCount = 0;
            this._imageFrame = null;
            this.nextImage();
        }
        if (genericFiles.size() > 0) {
            this.runFile(genericFiles);
        }
    }

    protected void showLocationDialog(List<DataContainer> containers) {
        if (this._dataManager.getDssFileVersion() == 7) {
            SupplementalInfo7 controlFrame = new SupplementalInfo7(this);
            controlFrame.fillForm(containers);
            controlFrame.setVisible(true);
        } else {
            DssMetaDataDialog controlFrame = new DssMetaDataDialog(this);
            controlFrame.fillForm(containers);
            controlFrame.setVisible(true);
        }
    }

    protected void showImages(List photoInfoList) {
        for (int i = 0; i < photoInfoList.size(); ++i) {
            Object obj = photoInfoList.get(i);
            if (!(obj instanceof PhotoViewerInfo)) continue;
            PhotoViewerInfo info = (PhotoViewerInfo)obj;
            PhotoViewerJFrame frame = new PhotoViewerJFrame(info);
            frame.setVisible(true);
        }
    }

    public void slideShow() {
        this._imagePathnames = this._selectionAndFilterPanel.getSelectedPathnames(true);
        if (this._imagePathnames == null || this._imagePathnames.size() == 0) {
            return;
        }
        this._imageCount = 0;
        this._imageFrame = null;
        this.nextImage();
    }

    protected void nextImage() {
        block13: {
            try {
                if (this._imagePathnames == null) {
                    return;
                }
                if (this._imageCount < this._imagePathnames.size()) {
                    int type;
                    DataReference dataSet = this._imagePathnames.get(this._imageCount);
                    ++this._imageCount;
                    boolean moreImages = true;
                    if (this._imageCount >= this._imagePathnames.size()) {
                        moreImages = false;
                    }
                    if ((type = this._dataManager.recordType(dataSet.getPath())) == 610) {
                        PhotoViewerInfo info = new PhotoViewerInfo();
                        int status = this._dataManager.readImage(dataSet, info);
                        if (status == 0) {
                            if (this._imageFrame != null) {
                                this._imageFrame.addNextImage(info, moreImages);
                            } else {
                                this._imageFrame = new PhotoViewerJFrame(info, this._imagePathnames.size());
                                this._imageFrame.addObserver((Observer)this);
                                this._imageFrame.setVisible(true);
                            }
                        } else {
                            this.nextImage();
                        }
                    } else {
                        this.nextImage();
                    }
                } else {
                    if (this._imageFrame != null) {
                        this._imageFrame.dispose();
                    }
                    this._imageFrame = null;
                }
            }
            catch (Exception e) {
                String message = "Error reading or displaying " + this._imagePathnames.get(this._imageCount).getDSSPathname();
                System.out.println(message);
                if (!ListSelection.isInteractive()) break block13;
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
        }
    }

    public void runFile() {
        DataReferenceSet dataReferenceSet = this._selectionAndFilterPanel.getSelectedPathnames(true);
        if (dataReferenceSet == null || dataReferenceSet.size() == 0) {
            return;
        }
        Vector<String> pathnames = new Vector<String>();
        for (int i = 0; i < dataReferenceSet.size(); ++i) {
            DataReference dataReference = dataReferenceSet.get(i);
            pathnames.add(dataReference.getPath());
        }
        this.runFile(pathnames);
    }

    public void runFile(Vector pathnames) {
        for (int i = 0; i < pathnames.size(); ++i) {
            String message;
            String pathname = (String)pathnames.get(i);
            int type = this._dataManager.recordType(pathname);
            if (type != 610 && type != 600) continue;
            DSSPathname path = new DSSPathname(pathname);
            String cpart = path.cPart();
            String name = cpart.substring(0, cpart.lastIndexOf("."));
            File file = null;
            try {
                file = File.createTempFile(name, "." + path.ePart());
                file.deleteOnExit();
                int status = this._dataManager.exportFile(pathname, file, "");
                if (status != 0) {
                    message = "Error in retrieving  " + pathname + ",  " + status;
                    System.out.println(message);
                    if (!ListSelection.isInteractive()) continue;
                    JOptionPane.showMessageDialog(this, message, _programName, 2);
                    continue;
                }
                Util.runProcess((String)file.getAbsolutePath());
                continue;
            }
            catch (Exception e) {
                message = "Error in writing \nPathname: " + pathname + "\n" + file.getAbsolutePath() + "\n" + e.toString();
                System.out.println(message);
                if (!ListSelection.isInteractive()) continue;
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
        }
    }

    public void exportToFile() {
        DataReferenceSet dataReferenceSet = this._selectionAndFilterPanel.getSelectedPathnames(true);
        boolean other = false;
        for (int i = 0; i < dataReferenceSet.size(); ++i) {
            DataReference dataReference = dataReferenceSet.get(i);
            if (dataReference.getPathname().indexOf("/IMAGE/") > 0 || dataReference.getPathname().indexOf("/FILE/") > 0) continue;
            other = true;
        }
        if (!other) {
            this.exportToFile(dataReferenceSet);
        } else {
            DataReferenceSet drsFiles = new DataReferenceSet();
            new DataReferenceSet();
            for (int i = 0; i < dataReferenceSet.size(); ++i) {
                DataReference dataReference = dataReferenceSet.get(i);
                if (dataReference.getPathname().indexOf("/IMAGE/") > 0) {
                    drsFiles.add((Object)dataReference);
                    continue;
                }
                if (dataReference.getPathname().indexOf("/FILE/") > 0) {
                    drsFiles.add((Object)dataReference);
                    continue;
                }
                if (this._dataManager.recordType(dataReference.getPathname()) == 300) {
                    this.exportTextFile(dataReference);
                    continue;
                }
                String message = "Cannot export this type of data:  " + dataReference.getPath();
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, message, _programName, 2);
                }
                return;
            }
            if (drsFiles.size() > 0) {
                this.exportToFile(drsFiles);
            }
        }
    }

    public void exportToFile(DataReferenceSet dataReferenceSet) {
        if (dataReferenceSet == null || dataReferenceSet.size() == 0) {
            return;
        }
        DataReference dataReference = dataReferenceSet.get(0);
        String prefDirectory = dataReference.getPathname().indexOf("/IMAGE/") > 0 ? "ImageDirectory" : "FileDirectory";
        String directory = this._preferences.get(prefDirectory, "");
        JFileChooser chooser = directory != null && directory.length() > 0 ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(1);
        chooser.setDialogType(1);
        int retval = chooser.showSaveDialog(this);
        if (retval != 0) {
            return;
        }
        File dir = chooser.getSelectedFile();
        directory = dir.getAbsolutePath();
        this._preferences.put(prefDirectory, directory);
        int numberStored = 0;
        for (int i = 0; i < dataReferenceSet.size(); ++i) {
            String message;
            dataReference = dataReferenceSet.get(i);
            int type = this._dataManager.recordType(dataReference.getPath());
            if (type != 610 && type != 600) continue;
            try {
                int status = this._dataManager.exportFile(dataReference.getPathname(), null, directory);
                if (status != 0) {
                    message = "Error in retrieving  " + dataReference.getPath() + ",  " + status;
                    System.out.println(message);
                    if (!ListSelection.isInteractive()) continue;
                    JOptionPane.showMessageDialog(this, message, _programName, 2);
                    continue;
                }
                ++numberStored;
                continue;
            }
            catch (Exception e) {
                message = "Error in writing \nPathname: " + dataReference.pathname() + "\n" + e.toString();
                System.out.println(message);
                if (!ListSelection.isInteractive()) continue;
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
        }
        Object mess = "";
        if (numberStored == 1) {
            mess = dataReference.pathname() + " written to " + directory;
        } else if (numberStored > 1) {
            mess = numberStored + " files written to " + directory;
        }
        System.out.println((String)mess);
        if (ListSelection.isInteractive()) {
            JOptionPane.showMessageDialog(this, mess, _programName, 1);
        }
    }

    public JFrame tabulate(boolean edit, boolean quickOnly) {
        this.checkNumberOpenWindows();
        List[] dataSets = this.readData(false, quickOnly, true);
        boolean found = false;
        for (int i = 0; i < dataSets.length; ++i) {
            if (dataSets[i] == null) continue;
            found = true;
        }
        if (!found) {
            return new JFrame();
        }
        return this.tabulate(dataSets, edit);
    }

    public JFrame tabulate() {
        return this.tabulate(false, false);
    }

    public JFrame tabularEdit() {
        return this.tabulate(true, false);
    }

    public void tabulate(List<TimeSeriesContainer> objectsToTabulate) {
        List[] lists = new List[]{objectsToTabulate};
        this.tabulate(lists, false);
    }

    private static boolean hasUsableContainer(List[] dataSets, int index, int containerType) {
        return index == containerType && dataSets[index] != null && dataSets[index].size() > 0;
    }

    public JFrame tabulate(List[] dataSets, boolean editData) {
        boolean writeAccess = false;
        GridInfoFrame tableFrame = null;
        if (this._dataManager.fileOpened()) {
            writeAccess = this._dataManager.writeAccess();
        }
        boolean locX = false;
        boolean locY = false;
        for (int i = 0; i < dataSets.length; ++i) {
            if (ListSelection.hasUsableContainer(dataSets, i, 0)) {
                String timezone;
                int status;
                HecDataTableFrame table = new HecDataTableFrame((Object)this);
                table.addPropertyChangeListener((PropertyChangeListener)this);
                table.setTransferHandler((TransferHandler)this._transferHandler);
                table.setCommasState(this._preferences.getBoolean("showTableCommas", true));
                table.setReverseOrderState(this._preferences.getBoolean("reverseOrderTable", false));
                table.setDateTimeAsTwoColumnsState(this._preferences.getBoolean("showDateTimeAsTwoColumns", false));
                table.setDecimalPlaces(this._preferences.getInt(DECIMAL_PLACES, -1));
                TimeSeriesDataModel.setDefaultDateStyle((int)this._preferences.getInt("dateStyle", 7));
                String temp = this._preferences.get("showTableQuality", Integer.toString(TimeSeriesQualityColumn.QUALITY_STYLE_SYMBOL));
                if (temp != null) {
                    if (temp.equals("true")) {
                        table.setQualityState(1);
                    } else if (temp.equals("1")) {
                        table.setQualityState(1);
                    } else if (temp.equals("2")) {
                        table.setQualityState(2);
                    } else {
                        table.setQualityState(0);
                    }
                }
                if ((status = table.setData(dataSets[i])) != 0) continue;
                Object obj = dataSets[i].get(0);
                if (obj instanceof TimeSeriesContainer && (timezone = ((TimeSeriesContainer)obj).timeZoneID) != null && timezone.length() > 2) {
                    String current;
                    String view;
                    String title = timezone;
                    if (this._timeZone != null && ((view = this._timeZone.getDisplayName(false, 0)) != null || view.length() >= 0)) {
                        title = view;
                    }
                    if ((current = table.getTableTitleText()) == null || current.length() < 1) {
                        table.setTableTitleText(title);
                    }
                }
                table.allowEditing(writeAccess);
                if (editData && writeAccess) {
                    table.editData(true);
                }
                if (this._extendedPluginsAdded) {
                    this.addTablePlugins(table);
                }
                table.setLocation(50, 50);
                table.setVisible(true);
                this._objectList.addElement(table);
                table.addWindowListener((WindowListener)this._windowClosingListener);
                tableFrame = table;
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 1)) {
                Vector v1 = this.orderPairedDataContainers(dataSets[i]);
                int loc = 40;
                for (int k = 0; k < v1.size(); ++k) {
                    Vector v2 = (Vector)v1.elementAt(k);
                    HecDataTableFrame table = new HecDataTableFrame((Object)this);
                    table.addPropertyChangeListener((PropertyChangeListener)this);
                    table.setTransferHandler((TransferHandler)this._transferHandler);
                    table.setCommasState(this._preferences.getBoolean("showTableCommas", true));
                    int status = table.setData((List)v2);
                    if (status != 0) continue;
                    table.setLocation(loc += 20, loc);
                    table.allowEditing(writeAccess);
                    if (editData && writeAccess) {
                        table.editData(true);
                    }
                    if (this._extendedPluginsAdded) {
                        this.addTablePlugins(table);
                    }
                    table.setVisible(true);
                    this._objectList.addElement(table);
                    table.addWindowListener((WindowListener)this._windowClosingListener);
                    tableFrame = table;
                }
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 2)) {
                for (int j = 0; j < dataSets[i].size(); ++j) {
                    TextContainer textContainer = (TextContainer)dataSets[i].get(j);
                    TextTable frame = new TextTable((Object)this, textContainer);
                    frame.setVisible(true);
                    this._objectList.addElement(frame);
                    frame.addWindowListener((WindowListener)this._windowClosingListener);
                }
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 3)) {
                int locx = 50;
                int locy = 50;
                GridInfoFrame gridFrame = null;
                for (int j = 0; j < dataSets[i].size(); ++j) {
                    GridContainer gridContainer = (GridContainer)dataSets[i].get(j);
                    if (gridFrame == null) {
                        gridFrame = new GridInfoFrame(gridContainer);
                        gridFrame.setLocation(locx, locy);
                        gridFrame.addWindowListener(this._windowClosingListener);
                        this._objectList.addElement(gridFrame);
                        locx += 20;
                        locy += 20;
                        continue;
                    }
                    gridFrame.addGrid(gridContainer);
                }
                gridFrame.setSelectedTabIndex(1);
                gridFrame.setVisible(true);
                tableFrame = gridFrame;
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 4)) {
                JOptionPane.showMessageDialog(this, "Rating Data cannot be tabulated at this time.", "Unable to Tabulate", 2);
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 5)) {
                this.displayOther((Vector)dataSets[5]);
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 6)) {
                HecDataTableFrame table = new HecDataTableFrame((Object)this);
                table.addPropertyChangeListener((PropertyChangeListener)this);
                table.setTransferHandler((TransferHandler)this._transferHandler);
                int status = table.setData(dataSets[i]);
                if (status != 0) continue;
                table.setLocation(40, 40);
                table.allowEditing(writeAccess);
                if (editData && writeAccess) {
                    table.editData(true);
                }
                if (this._extendedPluginsAdded) {
                    this.addTablePlugins(table);
                }
                table.setVisible(true);
                this._objectList.addElement(table);
                table.addWindowListener((WindowListener)this._windowClosingListener);
                tableFrame = table;
                continue;
            }
            if (ListSelection.hasUsableContainer(dataSets, i, 7)) {
                this.showLocationDialog(dataSets[i]);
                continue;
            }
            if (!ListSelection.hasUsableContainer(dataSets, i, 8)) continue;
            int nTins = 0;
            int nPoints = 0;
            for (int j = 0; j < dataSets[i].size(); ++j) {
                TinContainer tinContainer = (TinContainer)dataSets[i].get(j);
                ++nTins;
                nPoints += tinContainer.numberPoints;
            }
            Object message = "TIN Data cannot be tabulated at this time.\n";
            if (nTins > 1) {
                message = (String)message + "These " + nTins + " TINs contain " + nPoints + " points\n";
                int avg = nPoints / nTins;
                message = (String)message + " -- an average of " + avg + " per TIN.";
            } else {
                message = (String)message + "This TIN contains " + nPoints + " points.";
            }
            JOptionPane.showMessageDialog(this, message, "Unable to Tabulate", 2);
        }
        Help.setHelp(tableFrame, "38");
        return tableFrame;
    }

    protected Vector orderPairedDataContainers(List dataSets) {
        Vector v1 = new Vector();
        for (int j = 0; j < dataSets.size(); ++j) {
            boolean inVect = false;
            PairedDataContainer pdc = (PairedDataContainer)dataSets.get(j);
            block1: for (int k = 0; k < v1.size(); ++k) {
                Vector v2 = (Vector)v1.elementAt(k);
                for (int n = 0; n < v2.size(); ++n) {
                    PairedDataContainer p = (PairedDataContainer)v2.elementAt(n);
                    if (!p.xunits.equalsIgnoreCase(pdc.xunits) || !p.xtype.equalsIgnoreCase(pdc.xtype)) continue;
                    v2.add(pdc);
                    inVect = true;
                    continue block1;
                }
            }
            if (inVect) continue;
            Vector<PairedDataContainer> v = new Vector<PairedDataContainer>();
            v.add(pdc);
            v1.add(v);
        }
        return v1;
    }

    public void supplementalInfo() {
        int i;
        Vector[] dataContainers = this.readData(true, false);
        Vector containers = new Vector();
        for (i = 0; i < dataContainers.length; ++i) {
            if (dataContainers[i] == null) continue;
            containers.addAll(dataContainers[i]);
        }
        if (containers.size() == 0) {
            String mess = "Please select a Time Series Pathname";
            System.out.println(mess);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, mess, "No Pathname Selected", 2);
            }
            return;
        }
        for (i = containers.size() - 1; i >= 0; --i) {
            DataContainer dc = (DataContainer)containers.elementAt(i);
            if (dc.fullName != null && dc.fullName.length() != 0) continue;
            containers.remove(i);
        }
        if (containers.size() == 0) {
            String mess = "No valid data found.";
            System.out.println(mess);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, mess, "No Pathname Selected", 2);
            }
            return;
        }
        if (this._dataManager.getDssFileVersion() == 7) {
            SupplementalInfo7 controlFrame = new SupplementalInfo7(this);
            controlFrame.fillForm(containers);
            controlFrame.setVisible(true);
        } else {
            DssMetaDataDialog controlFrame = new DssMetaDataDialog(this);
            controlFrame.fillForm(containers);
            controlFrame.setVisible(true);
        }
    }

    public void recordAddresses() {
        DataReferenceSet drs = this.getSelectionList();
        if (drs.size() == 0) {
            return;
        }
        Vector<HecDSSRecordInfo> list = new Vector<HecDSSRecordInfo>();
        for (int i = 0; i < drs.size(); ++i) {
            DataReference dataReference = drs.elementAt(i);
            HecDSSRecordInfo recordInfo = new HecDSSRecordInfo();
            this._dataManager.getRecordInfo(dataReference, recordInfo);
            list.add(recordInfo);
        }
        RecordInternalsDialog recordInternals = new RecordInternalsDialog(this);
        recordInternals.fillForm(list);
        recordInternals.setVisible(true);
    }

    public void setTableCommasState(boolean showCommas) {
        this._preferences.putBoolean("showTableCommas", showCommas);
    }

    public void setTableReverseOrderState(boolean reverseOrder) {
        this._preferences.putBoolean("reverseOrderTable", reverseOrder);
    }

    public void setDateTimeAsTwoColumns(boolean showDateTimeAsTwoColumns) {
        this._preferences.putBoolean("showDateTimeAsTwoColumns", showDateTimeAsTwoColumns);
    }

    public void setDateStyle(int dateStyle) {
        this._preferences.putInt("dateStyle", dateStyle);
    }

    private void setDecimalPlaces(int decimalPlaces) {
        this._preferences.putInt(DECIMAL_PLACES, decimalPlaces);
    }

    public void setTableQualityState(int qualityStyle) {
        this._preferences.putInt("showTableQuality", qualityStyle);
    }

    public void graphicalEdit() {
        Vector[] dataSets = this.readData();
        new GraphicalEditorAction(this).edit(dataSets);
    }

    public void graphicalEdit(TimeSeriesContainer tsc) {
        new GraphicalEditorAction(this).edit(Arrays.asList(tsc));
    }

    public void graphicalEdit(TimeSeriesContainer[] tsc) {
        new GraphicalEditorAction(this).edit(Arrays.asList(tsc));
    }

    public void graphicalEdit(Vector[] dataSets) {
        new GraphicalEditorAction(this).edit(dataSets);
    }

    public void normalizeDisplay(List dataSets) {
        int j;
        TimeSeriesContainer tsc;
        int i;
        if (dataSets == null) {
            return;
        }
        if (dataSets.size() <= 1) {
            return;
        }
        double firstValue = -3.4028234663852886E38;
        int firstContainer = 0;
        double diff = 0.0;
        for (i = 0; i < dataSets.size(); ++i) {
            tsc = (TimeSeriesContainer)dataSets.get(i);
            if (tsc.numberValues > 0) {
                for (j = 0; j < tsc.numberValues; ++j) {
                    if (tsc.values[j] == -3.4028234663852886E38) continue;
                    firstValue = tsc.values[j];
                    firstContainer = i + 1;
                    break;
                }
            }
            if (firstValue != -3.4028234663852886E38) break;
        }
        if (firstValue == -3.4028234663852886E38) {
            return;
        }
        if (firstContainer >= dataSets.size()) {
            return;
        }
        for (i = firstContainer; i < dataSets.size(); ++i) {
            tsc = (TimeSeriesContainer)dataSets.get(i);
            if (tsc.numberValues <= 0) continue;
            for (j = 0; j < tsc.numberValues; ++j) {
                if (tsc.values[j] == -3.4028234663852886E38) continue;
                diff = firstValue - tsc.values[j];
                break;
            }
            for (j = 0; j < tsc.numberValues; ++j) {
                if (tsc.values[j] == -3.4028234663852886E38) continue;
                int n = j;
                tsc.values[n] = tsc.values[n] + diff;
            }
        }
    }

    public void syncDisplayTimes(List dataSets, boolean addDateToFpart) {
        int i;
        if (dataSets == null) {
            return;
        }
        if (dataSets.size() <= 1) {
            return;
        }
        TimeSeriesContainer tsc = (TimeSeriesContainer)dataSets.get(0);
        if (tsc.numberValues <= 0) {
            return;
        }
        int firstTime = tsc.times[0];
        int averageRangeMins = 0;
        int[] averageTime = new int[dataSets.size()];
        for (i = 0; i < dataSets.size(); ++i) {
            tsc = (TimeSeriesContainer)dataSets.get(i);
            if (tsc.numberValues <= 0) continue;
            int idx = tsc.numberValues / 2;
            averageTime[i] = tsc.times[idx];
            averageRangeMins += tsc.endTime - tsc.startTime;
            int diff = firstTime - tsc.times[0];
            int j = 0;
            while (j < tsc.numberValues) {
                int n = j++;
                tsc.times[n] = tsc.times[n] + diff;
            }
        }
        if (addDateToFpart) {
            averageRangeMins /= dataSets.size();
            for (i = 0; i < dataSets.size(); ++i) {
                tsc = (TimeSeriesContainer)dataSets.get(i);
                this.addDateToVersion(tsc, averageRangeMins, averageTime[i]);
            }
        }
    }

    protected void addDateToVersion(TimeSeriesContainer tsc, int averageRangeMins, int averageTime) {
        DSSPathname path = new DSSPathname(tsc.fullName);
        HecTime htime = new HecTime();
        htime.set(averageTime);
        if (averageRangeMins > 259200) {
            int yr = htime.year();
            path.setFPart(path.fPart() + " " + Integer.toString(yr));
        } else if (averageRangeMins > 14400) {
            String d = htime.date(7);
            d = d.substring(3);
            path.setFPart(path.fPart() + " " + d);
        } else {
            String d = htime.date(7);
            path.setFPart(path.fPart() + " " + d);
        }
        tsc.fullName = path.pathname();
        tsc.version = path.fPart();
    }

    @Deprecated
    public void ratingEdit(Object dataset) {
    }

    public void helpAbout() {
        StringBuffer message = new StringBuffer(_programName);
        message.append("\n");
        if (!_beta.isEmpty()) {
            message.append(" " + _beta);
        }
        message.append("\nVersion " + _versionNumber + "\n" + _versionDate);
        if (_versionUpdate.length() > 0) {
            message.append(", Release Update ");
            message.append(_versionUpdate);
        }
        message.append("\n");
        message.append("\n<br><br>For more information contact:\n<br><FONT SIZE=4>Hydrologic Engineering Center</FONT>\nInstitute for Water Resources\nUS Army Corps of Engineers\n609 Second Street\nDavis, CA 95616");
        AboutDialog aboutDialog = new AboutDialog((Frame)null, false, _programName, message.toString(), "www.hec.usace.army.mil", ListSelection.getAboutImageURL());
        aboutDialog.setLocationRelativeTo((Component)this);
        aboutDialog.setVisible(true);
    }

    public void groupLoad() {
        try {
            this._groupManager.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.groupUpdateMenu();
    }

    private void addMenu(JMenu mainMenu, String menuName, ActionListener actionListener) {
        String[] splitName = menuName.split(">");
        if (splitName.length == 1) {
            JMenuItem miGroupPlotItem = new JMenuItem(splitName[0]);
            miGroupPlotItem.addActionListener(actionListener);
            mainMenu.add(miGroupPlotItem);
        } else {
            String firstName = splitName[0];
            JMenu theMenu = null;
            for (int i = 0; i < mainMenu.getItemCount(); ++i) {
                JMenu menu;
                JMenuItem item = mainMenu.getItem(i);
                if (!(item instanceof JMenu) || !(menu = (JMenu)item).getText().equals(firstName)) continue;
                theMenu = menu;
                break;
            }
            if (theMenu == null) {
                theMenu = new JMenu(firstName);
                mainMenu.add(theMenu);
            }
            Object newName = splitName[1];
            for (int i = 2; i < splitName.length; ++i) {
                newName = (String)newName + ">";
                newName = (String)newName + splitName[i];
            }
            this.addMenu(theMenu, (String)newName, actionListener);
        }
    }

    public void groupUpdateMenu() {
        String[] groupNames = this._groupManager.getGroupNames();
        this.miGroupPlotNames = new JMenuItem[groupNames.length];
        this.miGroupIndividualPlotNames = new JMenuItem[groupNames.length];
        this.miGroupTabulateNames = new JMenuItem[groupNames.length];
        this.miGroupMathNames = new JMenuItem[groupNames.length];
        this.miGroupGetNames = new JMenuItem[groupNames.length];
        this.miGroupPlot.removeAll();
        this.miGroupIndividualPlot.removeAll();
        this.miGroupTabulate.removeAll();
        this.miGroupMath.removeAll();
        this.miGroupGet_Clear.removeAll();
        this.miGroupGet_Add.removeAll();
        for (int i = 0; i < groupNames.length; ++i) {
            final String groupName = groupNames[i];
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof JMenuItem) {
                        ListSelection.this.groupPlot(groupName);
                    }
                }
            };
            this.addMenu(this.miGroupPlot, groupName, actionListener);
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof JMenuItem) {
                        ListSelection.this.groupIndividualPlot(groupName);
                    }
                }
            };
            this.addMenu(this.miGroupIndividualPlot, groupName, actionListener);
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof JMenuItem) {
                        ListSelection.this.groupTabulate(groupName);
                    }
                }
            };
            this.addMenu(this.miGroupTabulate, groupName, actionListener);
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof JMenuItem) {
                        ListSelection.this.groupMath(groupName);
                    }
                }
            };
            this.addMenu(this.miGroupMath, groupName, actionListener);
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof JMenuItem) {
                        ListSelection.this.groupGet(groupName, true);
                    }
                }
            };
            this.addMenu(this.miGroupGet_Clear, groupName, actionListener);
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof JMenuItem) {
                        String name = ((JMenuItem)obj).getText();
                        ListSelection.this.groupGet(groupName, false);
                    }
                }
            };
            this.addMenu(this.miGroupGet_Add, groupName, actionListener);
        }
        boolean enable = groupNames.length > 0;
        this.miGroupGet_Clear.setEnabled(enable);
        this.miGroupGet_Add.setEnabled(enable);
        this.miGroupPlot.setEnabled(enable);
        this.miGroupIndividualPlot.setEnabled(enable);
        this.miGroupTabulate.setEnabled(enable);
        this.miGroupMath.setEnabled(enable);
        this.miGroupManage.setEnabled(enable);
    }

    public void groupAdd() {
        DataReferenceSet drs = this.getSelectionList();
        Object[] options = new Object[]{"OK", "Cancel"};
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)new JLabel("Name*:"), c);
        JTextField textField = new JTextField(20);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        panel.add((Component)textField, c);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)new JLabel("*Use > to indicate a subgroup menu."), c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        panel.add((Component)new JLabel("For example, Group1>Sub-Group2."), c);
        int result = JOptionPane.showOptionDialog(this, panel, "New Group", 2, -1, null, options, null);
        if (result != 0) {
            return;
        }
        String name = textField.getText();
        if (name == null || name.trim().length() == 0) {
            return;
        }
        String timeWindow = this._selectionAndFilterPanel._timeWindowDialog.getTimeWindowString(4);
        this._groupManager.add(name, drs, timeWindow);
        this.groupSave();
        String mess = "Group " + name + " saved.";
        System.out.println(mess);
        if (ListSelection.isInteractive()) {
            JOptionPane.showMessageDialog(this, mess, "Saved Group", 1);
        }
    }

    protected void groupSave() {
        try {
            this._groupManager.save();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void groupGet(String groupName, boolean clear) {
        IHecDSSUtilities dataManager;
        Group group = this._groupManager.getGroup(groupName);
        if (group == null) {
            return;
        }
        DataReferenceSet selectedGroup = group.getDataReferenceSet();
        if (!this._dataManager.fileAccessible()) {
            DataReference dr = (DataReference)selectedGroup.firstElement();
            this._dataManager.setDSSFileName(dr.getFilename());
        }
        if ((dataManager = this._dataManager.dataManager()) instanceof HecDataManager) {
            group.generateCondensedPathnameList((HecDataManager)dataManager, false);
        }
        if (clear) {
            this._selectionAndFilterPanel.clearSelection();
        }
        this._selectionAndFilterPanel.addToSelection(selectedGroup);
    }

    public void groupPlot(String groupName) {
        List[] dataSets = this.groupReadData(groupName);
        if (dataSets == null) {
            return;
        }
        this.plot(dataSets);
    }

    public void groupIndividualPlot(String groupName) {
        List[] dataSets = this.groupReadData(groupName);
        if (dataSets == null) {
            return;
        }
        this.plot(dataSets, true);
    }

    public void groupTabulate(String groupName) {
        List[] dataSets = this.groupReadData(groupName);
        if (dataSets == null) {
            return;
        }
        this.tabulate(dataSets, false);
    }

    public void groupMath(String groupName) {
        Vector[] dataSets = this.groupReadData(groupName);
        if (dataSets == null) {
            return;
        }
        this.math(dataSets);
    }

    public void groupManage() {
        this._groupManager.manage();
    }

    public void groupSetTimeWindow(DataReferenceSet group) {
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        boolean timesDefined = this.getTimeWindow(startTime, endTime);
        if (timesDefined) {
            group.setTimeWindow(startTime, endTime);
        } else {
            String tw = group.getTimeWindow();
            if (tw != null && tw.length() > 0) {
                group.setTimeWindowString(tw);
            }
        }
    }

    public Vector[] groupReadData(String groupName) {
        IHecDSSUtilities dataManager;
        Group group = this._groupManager.getGroup(groupName);
        if (group == null) {
            return null;
        }
        DataReferenceSet dataSet = group.getDataReferenceSet();
        this.groupSetTimeWindow(dataSet);
        if (!this._dataManager.fileAccessible()) {
            DataReference dr = (DataReference)dataSet.firstElement();
            this._dataManager.setDSSFileName(dr.getFilename());
        }
        if ((dataManager = this._dataManager.dataManager()) instanceof HecDataManager) {
            group.generateCondensedPathnameList((HecDataManager)dataManager, false);
        }
        Vector[] dataSets = this.readData(dataSet, false);
        return dataSets;
    }

    public void math() {
        if (!this._dataManager.writeAccess()) {
            String message = "No write access to DSS File " + this._dataManager.DSSFileName();
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        this.checkNumberOpenWindows();
        Vector[] dataSets = this.readData();
        boolean found = false;
        for (int i = 0; i < dataSets.length; ++i) {
            if (dataSets[i] == null) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        this.math(dataSets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void math(Vector[] dataSets) {
        boolean nonTimeSeries = false;
        this._mathFrame = null;
        for (int i = 0; i < dataSets.length; ++i) {
            if (i == 0 || i == 1) {
                if (dataSets[i] == null) continue;
                try {
                    this.setCursorWait();
                    if (this._mathFrame != null) continue;
                    this._mathFrame = new MathFrame2(this, dataSets);
                    continue;
                }
                finally {
                    this.setCursorDefault();
                }
            }
            if (i == 0 || i == 1 || dataSets[i] == null) continue;
            nonTimeSeries = true;
        }
        if (this._mathFrame != null) {
            if (this._extendedPluginsAdded) {
                this.addMathPlugins(this._mathFrame);
            }
            this._mathFrame.setVisible(true);
        }
        if (nonTimeSeries) {
            String message = "Can only perform math functions on Time Series data at this time";
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
        }
    }

    public void closeMath() {
        this._mathFrame = null;
    }

    public void compareFiles() {
        this.compareFiles(false);
    }

    public void compareFiles(boolean useOptions) {
        boolean opened;
        if (!this._dataManager.fileAccessible()) {
            String message = "Unable to access HEC-DSS file " + this._dataManager.DSSFileName();
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        this._secondDataManagerName = this.openDSSFileDialog(this._remote, "Compare to HEC-DSS File", false);
        if (this._secondDataManagerName == null) {
            return;
        }
        if (this._secondDataManager != null && this._secondDataManager.fileOpened()) {
            this._secondDataManager.close();
        }
        if (!(opened = this.openDSSFile(this._secondDataManagerName, false, false))) {
            String message = "Unable to access HEC-DSS file " + this._secondDataManagerName;
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        boolean ignoreMissing = false;
        boolean coincidentTimes = false;
        boolean compareDatasets = false;
        int compareType = 0;
        HecDouble compareValue = new HecDouble();
        compareValue.set(0.0);
        if (useOptions) {
            CompareOptionsDialog cod = new CompareOptionsDialog(this);
            cod.setVisible(true);
            if (cod.isCanceled()) {
                return;
            }
            ignoreMissing = cod.getIgnoreMissing();
            coincidentTimes = cod.getCoincidentTimes();
            compareType = cod.getCompareType();
            compareValue = cod.getValue();
            compareDatasets = cod.getCompareDataSets();
        }
        int numberRecords = this._dataManager.numberRecords();
        this.setCursorWait();
        this._operationCanceled = false;
        this.shutDownDssVueProgressBar();
        final ListSelection listSelection = this;
        this._compareFiles = new CompareFiles(listSelection, this._dataManager, this._secondDataManager, useOptions, compareDatasets, ignoreMissing, coincidentTimes, compareType, compareValue);
        if (numberRecords >= 1000 && !this._remote && ListSelection.isInteractive()) {
            this._dssVueProgressBar = new DssVueProgressBar(this, 10, 2, "Comparing Files");
            this._dssVueProgressBar.setTask(1, 0, "Step 1 of 2, Comparing Pathnames");
            new SwingWorker<Object, Object>(){

                @Override
                public Object doInBackground() {
                    Thread.currentThread().setPriority(4);
                    ListSelection.this.setCursorWait("Compare Files: Searching pathnames");
                    boolean cont = ListSelection.this._compareFiles.obtainPathnames();
                    if (!cont || ListSelection.this._operationCanceled) {
                        return new Integer(1);
                    }
                    cont = ListSelection.this._compareFiles.comparePathnames();
                    if (ListSelection.this._operationCanceled) {
                        return new Integer(0);
                    }
                    if (cont) {
                        int[] numberRecs = new int[1];
                        int[] currentRec = new int[1];
                        int[] currentNumberDiff = new int[1];
                        listSelection.getCompareStatus(numberRecs, currentRec, currentNumberDiff);
                        ListSelection.this._differencesSoFar += currentNumberDiff[0];
                        ListSelection.this._dssVueProgressBar.setTask(2, 0, "Step 2 of 2, Comparing Data Sets");
                        ListSelection.this._compareFiles.compareData();
                        return new Integer(0);
                    }
                    return new Integer(1);
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        int numberDifferent = 0;
                        if (ListSelection.this._compareFiles != null) {
                            numberDifferent = ListSelection.this._compareFiles.getNumberDifferent();
                        }
                        if (ListSelection.this._operationCanceled) {
                            ListSelection.this.compareFilesDone(3, numberDifferent);
                        } else {
                            ListSelection.this.compareFilesDone(1, numberDifferent);
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    ListSelection.this.shutDownDssVueProgressBar();
                }
            }.execute();
            if (this._dssVueProgressBar != null) {
                this._dssVueProgressBar.go();
            }
        } else {
            this.setCursorWait("Compare Files: Comparing Files");
            if (this._compareFiles != null) {
                this._compareFiles.doCompare();
            }
            this.setCursorDefault();
        }
    }

    public void compareFilesDone(int status, int numberDiff) {
        this.operationFinished(10, 0, this.isInteractive());
        StringBuffer message = new StringBuffer("Compare Files ");
        if (status == 3) {
            message.append("canceled.");
            if (this._compareFiles.areFilesDifferent()) {
                message.append("\nDo you wish to see differences found so far?");
                int option = JOptionPane.showConfirmDialog(this, message, "Compare Canceled", 0);
                if (option == 0) {
                    this._compareFiles.showDifferences();
                }
            } else {
                JOptionPane.showMessageDialog(this, message.toString(), _programName, 1);
            }
        } else {
            this._compareFiles.showDifferences();
        }
    }

    public int getCompareStatus(int[] numberRecs, int[] currentRec, int[] currentNumberDiff) {
        if (this._compareFiles == null) {
            return -1;
        }
        int status = this._compareFiles.getCompareStatus(numberRecs, currentRec, currentNumberDiff);
        currentNumberDiff[0] = currentNumberDiff[0] + this._differencesSoFar;
        return status;
    }

    public void compareDataSets(boolean useOptions) {
        DataReferenceSet drs = this._selectionAndFilterPanel.getSelectedPathnames();
        for (int i = 0; i < drs.size(); ++i) {
            DataReference dataReference = drs.get(i);
            String path = dataReference.getPathname();
            int type = HecDataManager.pathnameDataType((String)path);
            if (type >= 100 && type < 300) continue;
            this.setCursorDefault();
            String message = "Compare Data Sets is currently implemented for time series and paired data only";
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, "Compare Data Sets", 2);
            }
            return;
        }
        boolean ignoreMissing = false;
        boolean coincidentTimes = false;
        int compareType = 0;
        HecDouble compareValue = new HecDouble();
        compareValue.set(0.0);
        if (useOptions) {
            CompareOptionsDialog cod = new CompareOptionsDialog(this);
            cod.setVisible(true);
            if (cod.isCanceled()) {
                return;
            }
            ignoreMissing = cod.getIgnoreMissing();
            coincidentTimes = cod.getCoincidentTimes();
            compareType = cod.getCompareType();
            compareValue = cod.getValue();
        }
        this.setCursorWait();
        List[] dataSets = this.readData();
        if (dataSets[0] != null && dataSets[0].size() > 1) {
            int count;
            if (ignoreMissing) {
                for (int i = 0; i < dataSets[0].size(); ++i) {
                    Object obj = dataSets[0].get(i);
                    if (!(obj instanceof TimeSeriesContainer)) continue;
                    ((TimeSeriesContainer)obj).removeAllMissing();
                }
            }
            if (coincidentTimes && (count = HecTimeSeries.getCoincidentTimes((List)dataSets[0])) < 1) {
                this.setCursorDefault();
                String message = "No coincident times shared among data sets";
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, message);
                }
                return;
            }
            HecDataTableFrame table = new HecDataTableFrame((Object)this);
            int[] ordinatesDifferent = table.getCompareDataSetOrdinates((List)dataSets[0], compareType, -1, compareValue, ignoreMissing);
            int numberDifferent = ordinatesDifferent == null ? 0 : ordinatesDifferent.length;
            this.setCursorDefault();
            if (numberDifferent == 0) {
                this.setCursorDefault();
                String message = "No differences between data sets";
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, message);
                }
                return;
            }
            if (numberDifferent > 0) {
                int opt = 1;
                String message = numberDifferent + " values are different\nShow complete table with differences highlighted or\nshow partial table with only the values that are different?";
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    Object[] opts = new String[]{"Show Full Table", "Show Only Differences", "Cancel"};
                    opt = JOptionPane.showOptionDialog(this, message, "Compare Data Sets", 1, 3, null, opts, opts[0]);
                }
                if (opt == 2) {
                    this.setCursorDefault();
                    return;
                }
                if (opt == 1) {
                    List containers = table.getContainersForSelectedRows(ordinatesDifferent);
                    table = new HecDataTableFrame((Object)this);
                    table.setData(containers);
                }
                table.addPropertyChangeListener((PropertyChangeListener)this);
                table.setTransferHandler((TransferHandler)this._transferHandler);
                table.setCommasState(this._preferences.getBoolean("showTableCommas", true));
                table.setDateTimeAsTwoColumnsState(this._preferences.getBoolean("showDateTimeAsTwoColumns", false));
                TimeSeriesDataModel.setDefaultDateStyle((int)this._preferences.getInt("dateStyle", 7));
                String temp = this._preferences.get("showTableQuality", Integer.toString(TimeSeriesQualityColumn.QUALITY_STYLE_SYMBOL));
                if (temp != null) {
                    if (temp.equals("true")) {
                        table.setQualityState(1);
                    } else if (temp.equals("1")) {
                        table.setQualityState(1);
                    } else if (temp.equals("2")) {
                        table.setQualityState(2);
                    } else {
                        table.setQualityState(0);
                    }
                }
                table.setLocation(50, 50);
                this._objectList.addElement(table);
                table.addWindowListener((WindowListener)this._windowClosingListener);
                this.setCursorDefault();
                table.setVisible(true);
                if (opt == 0) {
                    table.setShownNextOrdinate(ordinatesDifferent);
                }
            }
        } else if (dataSets[1] != null && dataSets[1].size() > 1) {
            String mess;
            HecDataTableFrame table = new HecDataTableFrame((Object)this);
            int numberDifferent = table.compareDataSets((List)dataSets[1], compareType, -1, compareValue, ignoreMissing);
            this.setCursorDefault();
            String message = table.getCompareMessage();
            int option = 1;
            if (numberDifferent == 0) {
                this.setCursorDefault();
                String mess2 = "No differences between data sets";
                System.out.println(mess2);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, mess2, "Compare Paired Data", 1);
                }
                return;
            }
            if (numberDifferent < 0) {
                mess = "Data sets differ:" + message + "\nTabulate?\n";
                System.out.println(mess);
                if (ListSelection.isInteractive()) {
                    option = JOptionPane.showConfirmDialog(this, mess, "Compare Paired Data", 0);
                }
            } else {
                mess = numberDifferent + " values different." + message + "\nTabulate?\n";
                System.out.println(mess);
                if (ListSelection.isInteractive()) {
                    option = JOptionPane.showConfirmDialog(this, mess, "Compare Paired Data", 0);
                }
            }
            if (option == 0) {
                dataSets[0] = null;
                for (int i = 2; i < dataSets.length; ++i) {
                    dataSets[i] = null;
                }
                this.tabulate(dataSets, false);
            }
        } else {
            this.setCursorDefault();
        }
    }

    public void search() {
        Search search = new Search(this);
        search.searchDb();
    }

    public void timeSeriesDataEntry() {
        if (!this.isDssFileAccessible()) {
            return;
        }
        TimeSeriesDataEntry timeSeriesDataEntry = new TimeSeriesDataEntry(this, this._dataManager);
        timeSeriesDataEntry.setModal(false);
        timeSeriesDataEntry.setVisible(true);
    }

    public void timeSeriesDataEntry(String pathname, String startDateTime) {
        if (!this.isDssFileAccessible()) {
            return;
        }
        TimeSeriesDataEntry timeSeriesDataEntry = new TimeSeriesDataEntry(this, this._dataManager);
        if (pathname != null && pathname.length() > 0) {
            timeSeriesDataEntry.setPathname(pathname);
        }
        if (startDateTime != null && startDateTime.length() > 0) {
            timeSeriesDataEntry.setStartTime(startDateTime);
        }
        timeSeriesDataEntry.setModal(false);
        timeSeriesDataEntry.setVisible(true);
    }

    public void timeSeriesDataEntry(String pathname) {
        if (!this.isDssFileAccessible()) {
            return;
        }
        TimeSeriesDataEntry timeSeriesDataEntry = new TimeSeriesDataEntry(this, this._dataManager);
        if (pathname != null && pathname.length() > 0) {
            timeSeriesDataEntry.setPathname(pathname);
        }
        timeSeriesDataEntry.setModal(false);
        timeSeriesDataEntry.setVisible(true);
    }

    public void timeSeriesDataEntry(TimeSeriesContainer tsc) {
        if (!this.isDssFileAccessible()) {
            return;
        }
        TimeSeriesDataEntry timeSeriesDataEntry = new TimeSeriesDataEntry(this, this._dataManager);
        timeSeriesDataEntry.setData(tsc);
        timeSeriesDataEntry.setModal(false);
        timeSeriesDataEntry.setVisible(true);
    }

    public void pairedDataEntry() {
        if (!this.isDssFileAccessible()) {
            return;
        }
        PairedDataEntry pairedDataEntry = new PairedDataEntry(this, this._dataManager);
        pairedDataEntry.setVisible(true);
    }

    public void pairedDataEntry(String pathname) {
        if (!this.isDssFileAccessible()) {
            return;
        }
        PairedDataEntry pairedDataEntry = new PairedDataEntry(this, this._dataManager);
        if (pathname != null && pathname.length() > 0) {
            pairedDataEntry.setPathname(pathname);
        }
        pairedDataEntry.setVisible(true);
    }

    public void textEntry() {
        List[] dataSets = new Vector[5];
        TextContainer textContainer = new TextContainer();
        textContainer.text = "";
        if (dataSets[2] == null) {
            dataSets[2] = new Vector();
        }
        dataSets[2].add(textContainer);
        this.tabulate(dataSets, true);
    }

    public void textFileEntry() {
        TextContainer textContainer = new TextContainer();
        textContainer.text = "";
        String directory = this._preferences.get("TextDirectory", null);
        JFileChooser chooser = directory != null ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter((FileFilter)new RMAFilenameFilter("txt", "*.txt"));
        int option = chooser.showOpenDialog(this);
        if (option != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        directory = RMAIO.getDirectoryFromPath((String)file.getAbsolutePath());
        this._preferences.put("TextDirectory", directory);
        try {
            String line;
            StringBuffer text = new StringBuffer();
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                text.append(line);
                text.append("\n");
            }
            in.close();
            textContainer.text = text.toString();
        }
        catch (Exception e) {
            String message = "Error reading from file " + file.getAbsolutePath() + "\n" + e.toString();
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        List[] dataSets = new Vector[5];
        if (dataSets[2] == null) {
            dataSets[2] = new Vector();
        }
        dataSets[2].add(textContainer);
        this.tabulate(dataSets, true);
    }

    public void exportTextFile(DataReference dataReference) {
        TextContainer textContainer;
        int stat;
        String directory = this._preferences.get("TextDirectory", null);
        JFileChooser chooser = directory != null && directory.length() > 0 ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter((FileFilter)new RMAFilenameFilter("txt", "*.txt"));
        chooser.setDialogType(1);
        int retval = chooser.showSaveDialog(this);
        if (retval != 0) {
            return;
        }
        File textFile = chooser.getSelectedFile();
        if (!textFile.getAbsolutePath().endsWith("txt")) {
            textFile = new File(textFile.getAbsolutePath() + ".txt");
        }
        if ((stat = this._dataManager.readData(dataReference, textContainer = new TextContainer())) < 0) {
            String mess = "Unable to retrieve text data: " + dataReference.getPath();
            System.out.println(mess);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, mess, _programName, 2);
            }
            return;
        }
        try {
            new StringBuffer();
            BufferedWriter out = new BufferedWriter(new FileWriter(textFile));
            out.write(textContainer.text);
            out.close();
            String mess = "Text data: " + dataReference.getPath() + "\nWritten to file " + textFile.getAbsolutePath();
            System.out.println(mess);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, mess, _programName, 1);
            }
        }
        catch (Exception e) {
            String message = "Error writing to file " + textFile.getAbsolutePath() + "\n" + e.toString();
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
    }

    public void importVariousFileTypes(List files) {
        int i;
        Vector imageFiles = new Vector();
        Vector genericFiles = new Vector();
        Vector dssFiles = new Vector();
        Vector shefFiles = new Vector();
        Vector[] importFiles = new Vector[this.importPluginExtensions.size()];
        for (i = 0; i < this.importPluginExtensions.size(); ++i) {
            importFiles[i] = new Vector();
        }
        for (i = 0; i < files.size(); ++i) {
            String extension;
            if (debug) {
                System.out.println(((File)files.get(i)).getName());
            }
            if ((extension = RMAFilenameFilter.getExtension((File)((File)files.get(i))).toLowerCase()).equals("dss")) {
                dssFiles.add(files.get(i));
                continue;
            }
            if (extension.equals("jpg")) {
                imageFiles.add(files.get(i));
                continue;
            }
            if (extension.equals("shef")) {
                shefFiles.add(files.get(i));
                continue;
            }
            boolean found = false;
            if (this.importPluginExtensions.size() > 0) {
                for (int j = 0; j < this.importPluginExtensions.size(); ++j) {
                    String ext = (String)this.importPluginExtensions.elementAt(j);
                    if (!extension.equals(ext)) continue;
                    importFiles[j].add(files.get(i));
                    found = true;
                    break;
                }
            }
            if (found) continue;
            genericFiles.add(files.get(i));
        }
        if (imageFiles.size() > 0) {
            File[] images = new File[imageFiles.size()];
            for (int i2 = 0; i2 < imageFiles.size(); ++i2) {
                images[i2] = (File)imageFiles.get(i2);
            }
            this.importFiles(images, true);
        }
        if (genericFiles.size() > 0) {
            File[] generics = new File[genericFiles.size()];
            for (int i3 = 0; i3 < genericFiles.size(); ++i3) {
                generics[i3] = (File)genericFiles.get(i3);
            }
            this.importFiles(generics, false);
        }
        if (shefFiles.size() > 0) {
            File[] fs = new File[shefFiles.size()];
            for (int i4 = 0; i4 < shefFiles.size(); ++i4) {
                fs[i4] = (File)shefFiles.get(i4);
            }
            stringContainer mess = new stringContainer();
            int number = this.importShef(fs, true, mess);
            if (number > 0) {
                this.refreshCatalog();
            }
        }
        if (this.importPluginExtensions.size() > 0) {
            for (int j = 0; j < this.importPluginExtensions.size(); ++j) {
                Object importClass;
                if (importFiles[j].size() <= 0 || !((importClass = this.importPlugins.elementAt(j)) instanceof ImportPlugin)) continue;
                File[] impFiles = new File[importFiles[j].size()];
                for (int k = 0; k < importFiles[j].size(); ++k) {
                    impFiles[k] = (File)importFiles[j].get(k);
                }
                ((ImportPlugin)importClass).importFiles(impFiles);
            }
        }
        if (dssFiles.size() > 0) {
            File[] fs = new File[dssFiles.size()];
            for (int i5 = 0; i5 < dssFiles.size(); ++i5) {
                fs[i5] = (File)dssFiles.get(i5);
            }
            int count = 0;
            if (!this.isDssFileAccessible()) {
                this.openDSSFile(fs[0].getAbsolutePath());
                count = 1;
            } else if (fs.length == 1) {
                String message = "Do you want to Open or Copy all records from " + fs[0].getName() + "?";
                Object[] options = new Object[]{"Open", "Copy All", "Cancel"};
                int action = 1;
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    action = JOptionPane.showOptionDialog(this, message, "What do you want to do?", -1, 3, null, options, options[0]);
                }
                if (action != 2 && action != -1) {
                    if (action == 0) {
                        this.openDSSFile(fs[0].getAbsolutePath());
                    } else {
                        this.mergeFiles(fs);
                    }
                }
            }
            if (fs.length > 1) {
                String message = "Do you want Copy all records into " + this._dataManager.DSSFileName() + "?";
                Object[] options = new Object[]{"Copy All", "Cancel"};
                int action = 0;
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    action = JOptionPane.showOptionDialog(this, message, "What do you want to do?", -1, 3, null, options, options[0]);
                }
                if (action != 1 && action != -1) {
                    if (count > 0) {
                        File[] nfs = new File[fs.length - count];
                        for (int i6 = 0; i6 < nfs.length; ++i6) {
                            nfs[i6] = fs[count++];
                        }
                        fs = nfs;
                    }
                    this.mergeFiles(fs);
                }
            }
        }
    }

    public void importGenericFiles() {
        String directory = this._preferences.get("FileDirectory", "");
        JFileChooser chooser = directory != null && directory.length() > 0 ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setMultiSelectionEnabled(true);
        int retVal = this instanceof JFrame ? chooser.showOpenDialog(this) : chooser.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        if (files == null || files.length == 0) {
            return;
        }
        directory = RMAIO.getDirectoryFromPath((String)files[0].getPath());
        this._preferences.put("FileDirectory", directory);
        this.importFiles(files, false);
    }

    public void importImages() {
        String directory = this._preferences.get("ImageDirectory", "");
        JFileChooser chooser = directory != null && directory.length() > 0 ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter((FileFilter)new RMAFilenameFilter("jpg", "*.jpg"));
        chooser.setMultiSelectionEnabled(true);
        int retVal = this instanceof JFrame ? chooser.showOpenDialog(this) : chooser.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        if (files == null || files.length == 0) {
            return;
        }
        directory = RMAIO.getDirectoryFromPath((String)files[0].getPath());
        this._preferences.put("ImageDirectory", directory);
        this.importFiles(files, true);
    }

    protected void importFiles(File[] files, boolean imageFile) {
        if (this._dataManager == null || !this._dataManager.writeAccess()) {
            Object message = this._dataManager == null || !this._dataManager.fileAccessible() ? "No HEC-DSS file opened, or file is not accessible." : (!this._dataManager.writeAccess() ? this._dataManager.DSSFileName() + " does not have write access." : "HEC-DSS file cannot be accessed or written to.");
            System.out.println((String)message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        DSSPathname pathname = new DSSPathname();
        if (files.length > 1) {
            pathname.setCPart("*");
        } else {
            pathname.setCPart(files[0].getName());
        }
        String extension = RMAFilenameFilter.getExtension((File)files[0]);
        if (imageFile) {
            pathname.setDPart("IMAGE");
        } else {
            pathname.setDPart("FILE");
        }
        pathname.setEPart(extension);
        SaveAs saveAs = new SaveAs((Frame)this, pathname);
        if (files.length > 1) {
            saveAs.disablePart("C");
        }
        saveAs.disablePart("D");
        saveAs.disablePart("E");
        saveAs.disableFileBrowser();
        saveAs.setVisible(true);
        if (saveAs.canceled()) {
            return;
        }
        pathname = saveAs.getPathname();
        if (files.length > 1) {
            pathname.setCPart("");
        }
        int numberStored = 0;
        for (int i = 0; i < files.length; ++i) {
            String message;
            try {
                int status = this._dataManager.writeFile(files[i], pathname, imageFile);
                if (status != 0) {
                    message = "Error in storing " + files[i].getName() + ",  " + status;
                    System.out.println(message);
                    if (!ListSelection.isInteractive()) continue;
                    JOptionPane.showMessageDialog(this, message, _programName, 2);
                    continue;
                }
                ++numberStored;
                continue;
            }
            catch (Exception e) {
                message = "Error in storing " + files[i].getName() + "\nPathname: " + pathname.pathname() + "\n" + e.toString();
                System.out.println(message);
                if (!ListSelection.isInteractive()) continue;
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
        }
        Object message = "";
        if (numberStored == 1) {
            message = pathname.pathname() + " stored";
        } else if (numberStored > 1) {
            message = numberStored + " items stored";
        }
        System.out.println((String)message);
        if (ListSelection.isInteractive()) {
            JOptionPane.showMessageDialog(this, message, _programName, 1);
        }
        if (numberStored > 0) {
            this.refreshCatalog();
        }
    }

    public void importShef() {
        String directory = this._preferences.get("ShefDirectory", "");
        JFileChooser chooser = directory != null && directory.length() > 0 ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setMultiSelectionEnabled(true);
        int retVal = this instanceof JFrame ? chooser.showOpenDialog(this) : chooser.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        if (files == null || files.length == 0) {
            return;
        }
        directory = RMAIO.getDirectoryFromPath((String)files[0].getPath());
        this._preferences.put("ShefDirectory", directory);
        stringContainer mess = new stringContainer();
        int number = this.importShef(files, true, mess);
        if (number > 0) {
            this.refreshCatalog();
        }
    }

    public void importShef(String fileName) {
        File[] files = new File[]{new File(fileName)};
        stringContainer mess = new stringContainer();
        this.importShef(files, false, mess);
        System.out.println(mess);
    }

    public int importShef(File[] files, boolean showStatusDialog, stringContainer message) {
        if (this.shefImportExport == null) {
            this.shefImportExport = new ShefImportExport(this);
        }
        return this.shefImportExport.importShef(files, showStatusDialog, message);
    }

    public void exportShef() {
        String directory = this._preferences.get("ShefDirectory", "");
        JFileChooser chooser = directory != null && directory.length() > 0 ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setDialogType(1);
        int retVal = chooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        directory = RMAIO.getDirectoryFromPath((String)file.getPath());
        this._preferences.put("ShefDirectory", directory);
        Object name = file.getAbsolutePath();
        String ext = RMAIO.getFileExtension((String)name);
        if (ext == "" || !ext.equalsIgnoreCase(".shef") && !ext.equalsIgnoreCase(".shf")) {
            name = (String)name + ".shef";
        }
        this.exportShef((String)name);
    }

    public void exportShef(String exportFileName) {
        Vector[] data = this.readData();
        if (data == null || data[0] == null || data[0].size() == 0) {
            System.out.println("No data found for name / time window given.");
            return;
        }
        this.exportShef(exportFileName, data[0]);
    }

    public void exportShef(String exportFileName, Vector timeSeriesContainers) {
        if (this.shefImportExport == null) {
            this.shefImportExport = new ShefImportExport(this);
        }
        this.shefImportExport.exportShef(exportFileName, timeSeriesContainers);
    }

    public void copyRecords(boolean openFile) {
        this.copyRecords(openFile, false);
    }

    public void copyRecords(boolean openFile, boolean quickOnly) {
        this.copyRecords(openFile, quickOnly, false);
    }

    public void copyRecords(boolean openFile, boolean quickOnly, boolean remote) {
        DataReference dr;
        if (this._selectionAndFilterPanel.getSelectedPathnamesSize(quickOnly) == 0) {
            return;
        }
        if (!this.isDssFileAccessible()) {
            return;
        }
        if (this._secondDataManager == null || this._secondDataManager.DSSFileName().length() <= 0) {
            openFile = true;
        }
        String newFile = null;
        if (!openFile) {
            if (this._secondDataManager.isRemote() && !remote) {
                openFile = true;
                newFile = this._localFileName;
            } else if (!this._secondDataManager.isRemote() && remote) {
                openFile = true;
                newFile = this._remoteFileName;
            }
        }
        if (openFile) {
            String openFileName = newFile;
            if (openFileName == null) {
                openFileName = this.openDSSFileDialog(remote, "Copy Records into HEC-DSS File", false);
            }
            if (openFileName == null) {
                return;
            }
            this._secondDataManagerName = openFileName;
            boolean opened = false;
            if (this._secondDataManager != null && this._secondDataManager.DSSFileName().equals(this._secondDataManagerName)) {
                opened = true;
            }
            if (!opened) {
                int fromVersion = this._dataManager.getDssFileVersion();
                opened = this.openDSSFile(this._secondDataManagerName, false, DssDataManager.isRemoteFileName((String)this._secondDataManagerName), false, fromVersion);
            }
            if (!opened) {
                String message = "Unable to access HEC-DSS file " + this._secondDataManagerName;
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, message, _programName, 2);
                }
                return;
            }
            if (remote) {
                this._remoteFileName = this._secondDataManager.DSSFileName();
            } else {
                this._localFileName = this._secondDataManager.DSSFileName();
            }
        }
        if (this._secondDataManager.zinqir("READ") == 1) {
            String message = "You do not have permission to write to the HEC-DSS file " + this._secondDataManagerName;
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            this._secondDataManager.close();
            return;
        }
        this.miCopyRecordsTo.setText("Copy to " + this._secondDataManagerName);
        this.miCopyRecordsTo.setVisible(true);
        DataReferenceSet pathnames = this._selectionAndFilterPanel.getSelectedPathnames(quickOnly);
        Vector newPathnames = this._selectionAndFilterPanel.getSelectedPathnames().getPathnameSet();
        if (pathnames.size() > 0 && (dr = pathnames.get(0)).isWaterYear()) {
            pathnames = pathnames.expandWaterYear();
            newPathnames = pathnames.getPathnameSet(true);
        }
        DataReferenceSet paths = pathnames.expand();
        Vector newPaths = newPathnames;
        this.checkOverwriteRecords("CopyTo", this._secondDataManager, paths, newPaths);
    }

    protected void completeCopyRecords(DataReferenceSet dataReferenceSet) {
        DssDataManager dataManager;
        String opNameVerb = "Copying records to " + this._secondDataManagerName;
        this.setCursorWait(opNameVerb);
        Vector filenames = new Vector();
        final Vector pathnames = new Vector();
        DataReferenceSet drs = new DataReferenceSet();
        final DataReferenceSet timeSeries = new DataReferenceSet();
        final DataReferenceSet timeSeriesErrors = new DataReferenceSet();
        final Vector<DssDataManager> tsDataManagers = new Vector<DssDataManager>();
        for (int i = 0; i < dataReferenceSet.size(); ++i) {
            boolean bRemoteFile;
            String fileName;
            DSSPathname path;
            DataReference dr = dataReferenceSet.get(i);
            boolean useTimeWindow = false;
            if (dr.hasTimeWindow() && (path = new DSSPathname(dr.getPathname())).isTimeSeries()) {
                useTimeWindow = true;
            }
            if (useTimeWindow) {
                timeSeries.add((Object)dr);
                fileName = dr.getFilename();
                dataManager = this._selectionAndFilterPanel.getDataManager(fileName);
                tsDataManagers.add(dataManager);
                continue;
            }
            fileName = dr.getFilename();
            dataManager = this._selectionAndFilterPanel.getDataManager(fileName);
            boolean bl = bRemoteFile = dataManager.isRemote() && !this.isCwms(dataManager);
            if (!dataManager.isRemote() && this._secondDataManager.isRemote() && !this.isCwms(this._secondDataManager) || bRemoteFile && !this._secondDataManager.isRemote()) {
                timeSeries.add((Object)dr);
                tsDataManagers.add(dataManager);
                continue;
            }
            drs.add((Object)dr);
        }
        final int numberPaths = drs.getFilesAndPathnames(filenames, pathnames) + timeSeries.size();
        final Vector<DssDataManager> dataManagers = new Vector<DssDataManager>(filenames.size());
        for (int i = 0; i < filenames.size(); ++i) {
            String name = filenames.elementAt(i).toString();
            dataManager = this._selectionAndFilterPanel.getDataManager(name);
            dataManagers.add(dataManager);
        }
        this._operationCanceled = false;
        boolean visible = true;
        if (dataReferenceSet.numberPathnames() < 1000) {
            visible = false;
        }
        this._dssVueProgressBar = new MyDssVueProgressBar(this, 1, timeSeries.size(), opNameVerb, opNameVerb, visible);
        this._dssVueProgressBar.setTask(1, 0, opNameVerb);
        SwingWorker<Integer, Integer> copyRecs = new SwingWorker<Integer, Integer>(){

            @Override
            public Integer doInBackground() {
                int i;
                Thread.currentThread().setPriority(4);
                for (i = 0; i < dataManagers.size(); ++i) {
                    boolean bRemoteFile;
                    DssDataManager dataManager = (DssDataManager)dataManagers.elementAt(i);
                    boolean bl = bRemoteFile = dataManager.isRemote() && !ListSelection.this.isCwms(dataManager);
                    if (!dataManager.isRemote() && ListSelection.this._secondDataManager.isRemote() && !ListSelection.this.isCwms(ListSelection.this._secondDataManager) || bRemoteFile && !ListSelection.this._secondDataManager.isRemote()) continue;
                    return dataManager.copyRecordsFrom(ListSelection.this._secondDataManager, ListSelection.this._secondDataManagerName, (List)((Vector)pathnames.elementAt(i)));
                }
                for (i = 0; i < timeSeries.size(); ++i) {
                    ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(i);
                    DataReference dr = timeSeries.get(i);
                    DssDataManager dataManager = (DssDataManager)tsDataManagers.elementAt(i);
                    int type = dataManager.recordType(dr.getPath());
                    if (type >= 400 && type < 500) {
                        GridContainer gridContainer = new GridContainer();
                        int status = dataManager.readData(dr, gridContainer);
                        int n = ListSelection.this._secondDataManager.writeData(gridContainer);
                        continue;
                    }
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    int istat = dataManager.readData(dr, tsc, false);
                    tsc.fileName = "";
                    if (tsc.numberValues == 0) {
                        istat = -2;
                    } else {
                        boolean allMissing = true;
                        for (int j = 0; j < tsc.values.length; ++j) {
                            if (tsc.values[j] == -3.4028234663852886E38) continue;
                            allMissing = false;
                            break;
                        }
                        if (allMissing) {
                            istat = -2;
                        }
                    }
                    if (istat >= -1) {
                        int stat = ListSelection.this._secondDataManager.writeData(tsc);
                        if (stat < 0) {
                            return new Integer(stat);
                        }
                    } else {
                        timeSeriesErrors.add((Object)dr);
                    }
                    ListSelection.this._dssVueProgressBar.updateProgress();
                }
                return new Integer(0);
            }

            @Override
            protected void done() {
                ListSelection.this.setCursorDefault();
                if (ListSelection.this._operationCanceled) {
                    ListSelection.this.shutDownDssVueProgressBar();
                    ListSelection.this._secondDataManager.done();
                    return;
                }
                if (ListSelection.this.checkForSevereError(ListSelection.this._secondDataManager)) {
                    ListSelection.this._dssVueProgressBar.done(1);
                    ListSelection.this._secondDataManager.done();
                    return;
                }
                int stat = -1;
                try {
                    Integer ist = (Integer)this.get();
                    stat = ist;
                }
                catch (Exception ist) {
                    // empty catch block
                }
                if (stat < 0) {
                    ListSelection.this._dssVueProgressBar.done(1);
                    JOptionPane.showMessageDialog(ListSelection.this, "Record copy failed;  status: " + stat, _programName, 2);
                    ListSelection.this.shutDownDssVueProgressBar();
                    ListSelection.this._secondDataManager.done();
                    return;
                }
                if (!ListSelection.this._operationCanceled) {
                    ListSelection.this._dssVueProgressBar.done(0);
                    int number = numberPaths - timeSeriesErrors.size();
                    String message = number == 1 ? number + "  record copied to " + ListSelection.this._secondDataManagerName : number + "  records copied to " + ListSelection.this._secondDataManagerName;
                    if (timeSeries.size() > 0) {
                        DataReference dr = timeSeries.get(0);
                        HecTime start = new HecTime();
                        HecTime end = new HecTime();
                        dr.getTimeWindow(start, end);
                        if (start.isTimeDefined() && end.isTimeDefined()) {
                            message = message + "\nUsing time window " + start.toString() + "   " + end.toString();
                        }
                        if (timeSeriesErrors.size() > 0) {
                            message = message + "\nError reading " + timeSeriesErrors.size() + " data set(s)";
                            if (timeSeriesErrors.size() < 5) {
                                for (int i = 0; i < timeSeriesErrors.size(); ++i) {
                                    message = message + "\n" + timeSeriesErrors.get(i).getDSSPathname();
                                }
                            }
                        }
                    }
                    JOptionPane.showMessageDialog(null, message, _programName, 1);
                }
                ListSelection.this.shutDownDssVueProgressBar();
                ListSelection.this._secondDataManager.done();
            }
        };
        this._dssVueProgressBar.go();
        copyRecs.execute();
    }

    public void copyRecordsInto(DataReferenceSet drs, DssDataManager dataManager) {
        if (drs.size() == 0) {
            return;
        }
        DataReference dr = drs.get(0);
        this._secondDataManagerName = dr.getFilename();
        boolean opened = false;
        if (this._secondDataManager != null && this._secondDataManager.DSSFileName().equals(this._secondDataManagerName)) {
            opened = true;
        }
        if (!opened) {
            opened = this.openDSSFile(this._secondDataManagerName, false, false);
        }
        if (!opened) {
            String message = "Unable to access HEC-DSS file " + this._secondDataManagerName;
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        DataReferenceSet pathnames = drs.expand();
        Vector newPathnames = drs.getPathnameSet();
        this.checkOverwriteRecords("CopyFrom", dataManager, pathnames, newPathnames);
    }

    protected void completeCopyFrom(DataReferenceSet drs, final DssDataManager dataManager) {
        final Vector pathnames = drs.getPathnameSet();
        String opNameVerb = "Copying records from " + this._secondDataManagerName;
        this.setCursorWait(opNameVerb);
        this._operationCanceled = false;
        boolean visible = true;
        if (drs.numberPathnames() < 1000) {
            visible = false;
        }
        this._dssVueProgressBar = new DssVueProgressBar(this, 1, 1, opNameVerb, visible);
        this._dssVueProgressBar.setTask(1, 0, opNameVerb);
        SwingWorker<Integer, Integer> copyRecsFrom = new SwingWorker<Integer, Integer>(){

            @Override
            public Integer doInBackground() {
                Thread.currentThread().setPriority(4);
                int stat = dataManager.copyRecordsInto(ListSelection.this._secondDataManager, ListSelection.this._secondDataManagerName, (List)pathnames);
                if (stat < 0) {
                    return new Integer(stat);
                }
                return new Integer(0);
            }

            @Override
            protected void done() {
                ListSelection.this.setCursorDefault();
                if (ListSelection.this.checkForSevereError(dataManager)) {
                    ListSelection.this._dssVueProgressBar.done(1);
                    return;
                }
                int stat = -1;
                try {
                    Integer ist = (Integer)this.get();
                    stat = ist;
                }
                catch (Exception ist) {
                    // empty catch block
                }
                if (stat < 0) {
                    ListSelection.this._dssVueProgressBar.done(1);
                    JOptionPane.showMessageDialog(null, "Record copy failed.", _programName, 2);
                    ListSelection.this.shutDownDssVueProgressBar();
                    return;
                }
                if (!ListSelection.this._operationCanceled) {
                    ListSelection.this._dssVueProgressBar.done(0);
                    String message = pathnames.size() == 1 ? pathnames.size() + "  record copied from " + ListSelection.this._secondDataManagerName : pathnames.size() + "  records copied from " + ListSelection.this._secondDataManagerName;
                    JOptionPane.showMessageDialog(null, message, _programName, 1);
                }
                ListSelection.this.shutDownDssVueProgressBar();
                if (dataManager.equals(ListSelection.this._dataManager)) {
                    ListSelection.this.updateCatalog();
                } else {
                    dataManager.setCatalogNeedsUpdate(true);
                }
            }
        };
        this._dssVueProgressBar.go();
        copyRecsFrom.execute();
    }

    public void copyPathnamesToClipboard(boolean quickOnly) {
        DataReferenceSet ds = this._selectionAndFilterPanel.getSelectedPathnames(quickOnly);
        Vector pathnames = ds.getPathnameSet(false);
        if (pathnames.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pathnames.size(); ++i) {
            sb.append((String)pathnames.elementAt(i));
            if (i == pathnames.size() - 1) continue;
            sb.append("\n");
        }
        StringSelection ss = new StringSelection(sb.toString());
        Clipboard cb = this.getToolkit().getSystemClipboard();
        cb.setContents(ss, ss);
    }

    public void defaultDisplay(boolean quickOnly) {
        Vector pathnames = this._selectionAndFilterPanel.getSelectedPathnames(quickOnly).getPathnameSet();
        if (pathnames.size() == 0) {
            return;
        }
        this.plot(quickOnly);
    }

    public void renameRecords() {
        this.renameRecords(false);
    }

    public void renameRecords(boolean quickOnly) {
        if (this._selectionAndFilterPanel.getSelectedPathnamesSize(quickOnly) <= 0) {
            return;
        }
        if (!this.isDssFileAccessible()) {
            return;
        }
        DataReferenceSet drs = this._selectionAndFilterPanel.getSelectedPathnames(quickOnly);
        drs = drs.expand();
        Vector pathnames = drs.getPathnameSet();
        NewPartsDialog newParts = new NewPartsDialog("Rename Records to:", pathnames);
        newParts.setLocationRelativeTo(this);
        newParts.setVisible(true);
        Vector newPathnames = newParts.getNewPathnames();
        if (newPathnames == null) {
            return;
        }
        this.checkOverwriteRecords("Rename", this._dataManager, drs, newPathnames);
    }

    public void duplicateRecords() {
        this.duplicateRecords(false);
    }

    public void duplicateRecords(boolean quickOnly) {
        if (this._selectionAndFilterPanel.getSelectedPathnamesSize(quickOnly) <= 0) {
            return;
        }
        if (!this.isDssFileAccessible()) {
            return;
        }
        this.setCursorWait("Duplicate Records...");
        DataReferenceSet drs = this._selectionAndFilterPanel.getSelectedPathnames(quickOnly);
        drs = drs.expand(false);
        Vector pathnames = drs.getPathnameSet(false);
        NewPartsDialog newParts = new NewPartsDialog((Frame)this, "New pathname parts for duplicate records:", pathnames);
        newParts.setLocationRelativeTo(this);
        newParts.setVisible(true);
        Vector newPathnames = newParts.getNewPathnames();
        this.setCursorDefault();
        if (newPathnames == null) {
            return;
        }
        this.checkOverwriteRecords("Duplicate", this._dataManager, drs, newPathnames);
    }

    protected void completeDupRename(DataReferenceSet drs, Vector newPaths, final String opName, final int operation) {
        String opNameVerb = operation == 7 ? "Renaming records" : "Duplicating records";
        this.setCursorWait(opNameVerb);
        final Vector newPathnames = new Vector(newPaths.size());
        final DssDataManager dataManager = this._dataManager;
        Vector<String> filenames = new Vector<String>();
        final Vector<String> pathnames = new Vector<String>();
        DataReferenceSet timeSeries = new DataReferenceSet();
        Vector newTimeSeriesPaths = new Vector();
        boolean allSameFile = true;
        String fname = this._dataManager.DSSFileName();
        for (int i = 0; i < drs.size(); ++i) {
            DSSPathname path;
            DataReference dr = drs.get(i);
            if (!fname.equals(dr.getFilename())) {
                allSameFile = false;
            }
            boolean useTimeWindow = false;
            if (operation == 8 && dr.hasTimeWindow() && (path = new DSSPathname(dr.getPathname())).isTimeSeries()) {
                useTimeWindow = true;
            }
            if (useTimeWindow) {
                timeSeries.add((Object)dr);
                newTimeSeriesPaths.add(newPaths.get(i));
                continue;
            }
            pathnames.add(dr.getPathname());
            newPathnames.add(newPaths.get(i));
            filenames.add(dr.getFilename());
        }
        if (allSameFile && pathnames.size() > 200 && timeSeries.size() == 0 && !this._remote && ListSelection.isInteractive()) {
            this._operationCanceled = false;
            this._dssVueProgressBar = new DssVueProgressBar(this, operation, 1, opNameVerb);
            this._dssVueProgressBar.setTask(1, 0, opNameVerb);
            SwingWorker<Integer, Integer> dupRenameRecs = new SwingWorker<Integer, Integer>(){

                @Override
                public Integer doInBackground() {
                    Thread.currentThread().setPriority(4);
                    if (operation == 7) {
                        int stat = dataManager.renameRecords((List)pathnames, (List)newPathnames);
                        return new Integer(stat);
                    }
                    int stat = dataManager.duplicateRecords((List)pathnames, (List)newPathnames);
                    return new Integer(stat);
                }

                @Override
                protected void done() {
                    ListSelection.this.setCursorDefault();
                    if (ListSelection.this.checkForSevereError(dataManager)) {
                        ListSelection.this._dssVueProgressBar.done(1);
                        return;
                    }
                    int stat = -1;
                    try {
                        Integer ist = (Integer)this.get();
                        stat = ist;
                    }
                    catch (Exception ist) {
                        // empty catch block
                    }
                    if (stat < 0) {
                        ListSelection.this._dssVueProgressBar.done(1);
                        JOptionPane.showMessageDialog(null, opName + " failed.", _programName, 2);
                        ListSelection.this.shutDownDssVueProgressBar();
                        return;
                    }
                    if (!ListSelection.this._operationCanceled) {
                        ListSelection.this._dssVueProgressBar.done(0);
                        String message = operation == 7 ? newPathnames.size() + "  records renamed." : newPathnames.size() + "  records duplicated.";
                        JOptionPane.showMessageDialog(null, message, _programName, 1);
                    }
                    ListSelection.this.shutDownDssVueProgressBar();
                    ListSelection.this._selectionAndFilterPanel.clearSelection();
                    ListSelection.this.updateCatalog(true);
                }
            };
            this._dssVueProgressBar.go();
            dupRenameRecs.execute();
        } else {
            String message;
            DataReference dr;
            Vector<String> p = new Vector<String>(1);
            Vector<String> np = new Vector<String>(1);
            p.add("");
            np.add("");
            int stat = 0;
            for (int i = 0; i < filenames.size(); ++i) {
                fname = (String)filenames.elementAt(i);
                DssDataManager dm = this._selectionAndFilterPanel.getDataManager(fname);
                if (dm == null) {
                    return;
                }
                dm.setCatalogNeedsUpdate(true);
                p.set(0, (String)pathnames.get(i));
                np.set(0, (String)newPathnames.get(i));
                stat = operation == 7 ? dm.renameRecords(p, np) : dm.duplicateRecords(p, np);
                if (stat < 0) break;
            }
            p.removeAllElements();
            int tsCount = 0;
            for (int i = 0; i < timeSeries.size(); ++i) {
                dr = timeSeries.get(i);
                fname = dr.getFilename();
                DssDataManager dm = this._selectionAndFilterPanel.getDataManager(fname);
                if (dm == null) {
                    return;
                }
                TimeSeriesContainer tsc = new TimeSeriesContainer();
                int istat = dm.readData(dr, tsc, false);
                if (tsc.numberValues == 0) {
                    istat = -2;
                } else {
                    boolean allMissing = true;
                    for (int j = 0; j < tsc.values.length; ++j) {
                        if (tsc.values[j] == -3.4028234663852886E38) continue;
                        allMissing = false;
                        break;
                    }
                    if (allMissing) {
                        istat = -2;
                    }
                }
                if (istat >= -1) {
                    tsc.fullName = (String)newTimeSeriesPaths.get(i);
                    stat = dm.writeData(tsc);
                    ++tsCount;
                    continue;
                }
                p.add(tsc.fullName);
            }
            this.setCursorDefault();
            if (stat < 0) {
                String message2 = opName + " failed.";
                System.out.println(message2);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(null, message2, _programName, 2);
                }
                return;
            }
            if (operation == 7) {
                message = newPathnames.size() + "  record(s) renamed.";
            } else {
                message = newPathnames.size() + tsCount + "  record(s) duplicated.";
                if (timeSeries.size() > 0) {
                    dr = timeSeries.get(0);
                    HecTime start = new HecTime();
                    HecTime end = new HecTime();
                    dr.getTimeWindow(start, end);
                    message = message + "\nUsing time window " + start.toString() + "   " + end.toString();
                    if (p.size() > 0) {
                        message = message + "\nError reading " + p.size() + " data set(s)";
                        if (p.size() < 5) {
                            for (int i = 0; i < p.size(); ++i) {
                                message = message + "\n" + (String)p.elementAt(i);
                            }
                        }
                    }
                }
            }
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(null, message, _programName, 1);
            }
            this._selectionAndFilterPanel.clearSelection();
            this.updateCatalog(true);
        }
    }

    public void undeleteAll() {
        int numberAvailable = this._dataManager.zinqir("DELE");
        StringBuffer message = new StringBuffer();
        if (numberAvailable < 0) {
            this.checkForSevereError(this._dataManager);
            return;
        }
        if (numberAvailable == 0) {
            String mess = "No records in file available to undelete.";
            System.out.println(mess);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, mess, _programName, 2);
            }
            return;
        }
        if (numberAvailable == 1) {
            message.append("Undelete 1 record?");
        } else {
            message.append("Undelete " + numberAvailable + " records?");
        }
        System.out.println(message);
        int option = 0;
        if (ListSelection.isInteractive()) {
            option = JOptionPane.showConfirmDialog(this, message, _programName, 0);
        }
        if (option == 1) {
            return;
        }
        Vector<String> v = new Vector<String>();
        v.add("ALL");
        int status = this._dataManager.undelete(v);
        if (status == 0) {
            String mess = "All available records undeleted.";
            System.out.println(mess);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, mess, _programName, 1);
            }
        } else {
            this.checkForSevereError(this._dataManager);
            return;
        }
        this.updateCatalog();
    }

    public void undeleteSelected() {
        UndeleteEditor undelete = new UndeleteEditor(this, this._dataManager);
        undelete.setVisible(true);
    }

    public void undo() {
        List deletedPathnames = this._dataManager.getLastDeletePathnames();
        if (deletedPathnames.size() == 0) {
            JOptionPane.showMessageDialog(this, "Nothing to undo.", _programName, 1);
            return;
        }
        StringBuffer message = new StringBuffer();
        if (deletedPathnames.size() == 1) {
            String path = (String)deletedPathnames.get(0);
            message.append("Undelete " + path + "?");
        } else if (deletedPathnames.size() < 10) {
            message.append("Undelete the following records?");
            for (int i = 0; i < deletedPathnames.size(); ++i) {
                message.append("\n");
                message.append((String)deletedPathnames.get(i));
            }
        } else {
            message.append("Undelete " + deletedPathnames.size() + " records?");
        }
        System.out.println(message);
        int option = 0;
        if (ListSelection.isInteractive()) {
            option = JOptionPane.showConfirmDialog(this, message, _programName, 0);
        }
        if (option == 1) {
            return;
        }
        int status = this._dataManager.undoLastDelete();
        if (status != 0) {
            boolean error = this.checkForSevereError(this._dataManager);
            if (error) {
                return;
            }
            JOptionPane.showMessageDialog(this, "Unable to undelete record", _programName, 2);
        }
        this.miUndo.setEnabled(false);
        this.updateCatalog();
    }

    public int deleteValues(Map<TimeSeriesContainer, TimeWindowMap> timeSeriesTimeWindowMap) {
        return 0;
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean quickOnly) {
        if (this._selectionAndFilterPanel.getSelectedPathnamesSize(quickOnly) <= 0) {
            return;
        }
        if (!this.isDssFileAccessible()) {
            return;
        }
        DataReferenceSet selectedDataSets = this._selectionAndFilterPanel.getSelectedPathnames(quickOnly);
        Vector pathnames = selectedDataSets.getPathnameSet();
        int opt = this.confirmDelete(pathnames, selectedDataSets);
        if (opt != 0) {
            return;
        }
        int status = this._dataManager.delete((List)pathnames);
        if (this.checkForSevereError(this._dataManager)) {
            return;
        }
        if (status != 0) {
            JOptionPane.showMessageDialog(this, "Unable to delete record(s)", _programName, 2);
            return;
        }
        this.miUndo.setEnabled(true);
        String message = pathnames.size() == 1 ? pathnames.elementAt(0).toString() + " deleted." : pathnames.size() + "  records deleted.";
        Logger logger = Logger.getLogger(ListSelection.class.getName());
        logger.log(Level.INFO, message);
        this._selectionAndFilterPanel.clearSelection();
        this.updateCatalog();
    }

    protected int confirmDelete(Vector pathnames, DataReferenceSet dataSets) {
        StringBuffer mess = new StringBuffer();
        if (pathnames.size() == 1) {
            mess.append("Delete ");
            mess.append(pathnames.firstElement());
            mess.append("?");
        } else if (dataSets.size() == 1) {
            mess.append("Delete ");
            mess.append(dataSets.elementAt(0));
            mess.append("?\n(");
            mess.append(Integer.toString(pathnames.size()));
            mess.append(" records)");
        } else if (dataSets.size() < 5) {
            mess.append("Delete the following data sets?");
            for (int i = 0; i < dataSets.size(); ++i) {
                mess.append("\n");
                mess.append(dataSets.get(i));
            }
            if (dataSets.size() != pathnames.size()) {
                mess.append("\n(");
                mess.append(Integer.toString(pathnames.size()));
                mess.append(" records)");
            }
        } else {
            mess.append("Delete the ");
            mess.append(Integer.toString(dataSets.size()));
            mess.append(" selected data sets?");
            if (dataSets.size() != pathnames.size()) {
                mess.append("\n(");
                mess.append(Integer.toString(pathnames.size()));
                mess.append(" records)");
            }
        }
        int opt = 0;
        System.out.println(mess);
        if (ListSelection.isInteractive()) {
            opt = JOptionPane.showConfirmDialog(this, mess.toString(), "Delete Records", 0);
        }
        return opt;
    }

    private String getTempDssFileFrom(DssDataManager dataManager, String fileName) {
        String newName;
        int i = 0;
        while (true) {
            newName = fileName + "." + Integer.toString(i) + ".dss";
            if (dataManager.isRemote()) {
                try {
                    if (ServerSuiteUtil.getFileManager().fileExists(newName)) {
                        ++i;
                        continue;
                    }
                    return newName;
                }
                catch (RemoteException e) {
                    return newName;
                }
            }
            if (!dataManager.doesDSSFileExist(newName)) break;
            ++i;
        }
        return newName;
    }

    private void merge(final String toDssFilename, final boolean remote) {
        String opNameVerb = "Merging";
        this._dssVueProgressBar = new MyDssVueProgressBar(this, 2, 13, opNameVerb, toDssFilename, true);
        this._operationCanceled = false;
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){
            DssDataManager _tempDataManager = null;
            String tempToFileName = null;
            String tempFileName = null;
            boolean _remoteSrc;

            @Override
            protected void done() {
                block20: {
                    if (this.isCancelled()) {
                        File file;
                        block19: {
                            if (this._tempDataManager != null) {
                                this._tempDataManager.cancelProcess();
                                this._tempDataManager.done();
                                this._tempDataManager.close();
                            }
                            if (ListSelection.this._secondDataManager != null) {
                                ListSelection.this._secondDataManager.cancelProcess();
                                ListSelection.this._secondDataManager.done();
                                ListSelection.this._secondDataManager.close();
                            }
                            if (this.tempFileName != null) {
                                if (this._remoteSrc) {
                                    try {
                                        if (ServerSuiteUtil.getFileManager().deleteFile(this.tempFileName)) {
                                            System.out.println(this.tempFileName + " deleted");
                                            this.tempFileName = null;
                                            break block19;
                                        }
                                        System.out.println("could not delete " + this.tempFileName);
                                        this.tempFileName = null;
                                    }
                                    catch (RemoteException e) {
                                        System.out.println("could not delete " + this.tempFileName);
                                    }
                                } else {
                                    file = new File(this.tempFileName);
                                    if (file.delete()) {
                                        System.out.println("Temp file deleted: " + this.tempFileName);
                                        this.tempFileName = null;
                                    } else {
                                        System.out.println("could not delete " + this.tempFileName);
                                        this.tempFileName = null;
                                    }
                                }
                            }
                        }
                        if (this.tempToFileName != null) {
                            if (remote) {
                                try {
                                    if (ServerSuiteUtil.getFileManager().deleteFile(this.tempToFileName)) {
                                        System.out.println(this.tempToFileName + " deleted");
                                        this.tempToFileName = null;
                                        break block20;
                                    }
                                    System.out.println("could not delete " + this.tempToFileName);
                                    this.tempToFileName = null;
                                }
                                catch (RemoteException e) {
                                    System.out.println("could not delete " + this.tempToFileName);
                                    this.tempToFileName = null;
                                }
                            } else {
                                file = new File(this.tempToFileName);
                                if (file.delete()) {
                                    System.out.println("Temp file deleted: " + this.tempToFileName);
                                    this.tempToFileName = null;
                                } else {
                                    System.out.println("could not delete " + this.tempToFileName);
                                    this.tempToFileName = null;
                                }
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInBackground() {
                int status;
                block44: {
                    Thread.currentThread().setPriority(4);
                    status = 0;
                    this.tempFileName = ListSelection.this.getTempDssFileFrom(ListSelection.this._dataManager, ListSelection.this._dataManager.DSSFileName());
                    ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(1);
                    System.out.println("temp dss file: " + this.tempFileName);
                    boolean interactove = _isInteractive;
                    boolean interactoveSet = _isInteractiveSet;
                    _isInteractive = false;
                    _isInteractiveSet = true;
                    try {
                        String message;
                        boolean bRemote = false;
                        if (this.tempFileName.startsWith("/")) {
                            this._remoteSrc = true;
                            bRemote = true;
                        }
                        boolean opened = ListSelection.this.openDSSFile(this.tempFileName, false, bRemote, false, 6);
                        ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(2);
                        if (!opened) {
                            message = "could not open temp dss file: " + this.tempFileName;
                            System.out.println(message);
                            if (ListSelection.this._secondDataManager != null) {
                                ListSelection.this._secondDataManager.done();
                                ListSelection.this._secondDataManager.close();
                            }
                            ListSelection.this._operationCanceled = true;
                            JOptionPane.showMessageDialog(ListSelection.this._dssVueProgressBar, message, _programName, 2);
                        }
                        if (!(ListSelection.this._operationCanceled || this.isCancelled() || ListSelection.this._secondDataManager != null && ListSelection.this._secondDataManager.writeAccess())) {
                            if (ListSelection.this._secondDataManager != null) {
                                ListSelection.this._secondDataManager.done();
                                ListSelection.this._secondDataManager.close();
                            }
                            message = "No write access to temp DSS File " + this.tempFileName;
                            System.out.println(message);
                            JOptionPane.showMessageDialog(ListSelection.this._dssVueProgressBar, message, _programName, 2);
                            ListSelection.this._operationCanceled = true;
                        }
                        if (!ListSelection.this._operationCanceled && !this.isCancelled()) {
                            ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(3);
                            ListSelection.this._dataManager.setMessageLevel(2);
                            status = ListSelection.this._dataManager.copyFile(ListSelection.this._secondDataManager, this.tempFileName);
                            ListSelection.this._dataManager.setMessageLevel(4);
                            if (status < 0 || ListSelection.this.checkForSevereError(ListSelection.this._dataManager)) {
                                ListSelection.this._operationCanceled = true;
                                if (ListSelection.this._secondDataManager != null) {
                                    ListSelection.this._secondDataManager.close();
                                    ListSelection.this._secondDataManager.done();
                                }
                            }
                        }
                        if (!ListSelection.this._operationCanceled && !this.isCancelled()) {
                            File file;
                            block42: {
                                ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(4);
                                if (ListSelection.this._secondDataManager != null) {
                                    ListSelection.this._secondDataManager.close();
                                    ListSelection.this._secondDataManager.done();
                                }
                                this._tempDataManager = ListSelection.this.createDataManager(remote);
                                this.tempToFileName = ListSelection.this.getTempDssFileFrom(this._tempDataManager, toDssFilename);
                                ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(5);
                                System.out.println("to temp dss file: " + this.tempToFileName);
                                FileTransfer.copyBinaryFile(ListSelection.this._dataManager.isRemote(), this.tempFileName, remote, this.tempToFileName);
                                System.out.println("Copied Binary");
                                ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(6);
                                if (this._remoteSrc) {
                                    try {
                                        if (ServerSuiteUtil.getFileManager().deleteFile(this.tempFileName)) {
                                            System.out.println(this.tempFileName + " deleted");
                                            this.tempFileName = null;
                                            break block42;
                                        }
                                        System.out.println("could not delete " + this.tempFileName);
                                        this.tempFileName = null;
                                    }
                                    catch (RemoteException e) {
                                        System.out.println("could not delete " + this.tempFileName);
                                    }
                                } else {
                                    HecDSSFileDataManager dm = new HecDSSFileDataManager();
                                    dm.unmapFile(this.tempFileName);
                                    file = new File(this.tempFileName);
                                    if (file.delete()) {
                                        System.out.println("Temp file deleted: " + this.tempFileName);
                                        this.tempFileName = null;
                                    } else {
                                        System.out.println("could not delete " + this.tempFileName);
                                        this.tempFileName = null;
                                    }
                                }
                            }
                            ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(7);
                            this._tempDataManager.setDSSFileName(this.tempToFileName);
                            ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(8);
                            bRemote = DssDataManager.isRemoteFileName((String)toDssFilename);
                            opened = ListSelection.this.openDSSFile(toDssFilename, false, bRemote, false, 6);
                            if (!opened) {
                                block43: {
                                    ListSelection.this._operationCanceled = true;
                                    message = "could not open destination dss file: " + toDssFilename;
                                    System.out.println(message);
                                    if (ListSelection.this._secondDataManager != null) {
                                        ListSelection.this._secondDataManager.done();
                                        ListSelection.this._secondDataManager.close();
                                    }
                                    this._tempDataManager.done();
                                    this._tempDataManager.close();
                                    if (remote) {
                                        try {
                                            if (ServerSuiteUtil.getFileManager().deleteFile(this.tempToFileName)) {
                                                System.out.println(this.tempToFileName + " deleted");
                                                this.tempToFileName = null;
                                                break block43;
                                            }
                                            System.out.println("could not delete " + this.tempToFileName);
                                            this.tempToFileName = null;
                                        }
                                        catch (RemoteException e) {
                                            System.out.println("could not delete " + this.tempToFileName);
                                            this.tempToFileName = null;
                                        }
                                    } else {
                                        file = new File(this.tempToFileName);
                                        if (file.delete()) {
                                            System.out.println("Temp file deleted: " + this.tempToFileName);
                                            this.tempToFileName = null;
                                        } else {
                                            System.out.println("could not delete " + this.tempToFileName);
                                            this.tempToFileName = null;
                                        }
                                    }
                                }
                                JOptionPane.showMessageDialog(ListSelection.this._dssVueProgressBar, message, _programName, 2);
                            }
                        }
                        if (!ListSelection.this._operationCanceled && !this.isCancelled()) {
                            ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(9);
                            if (!ListSelection.this._secondDataManager.writeAccess()) {
                                message = "No write access to DSS File " + toDssFilename;
                                System.out.println(message);
                                ListSelection.this._operationCanceled = true;
                                ListSelection.this._secondDataManager.done();
                                ListSelection.this._secondDataManager.close();
                                JOptionPane.showMessageDialog(ListSelection.this._dssVueProgressBar, message, _programName, 2);
                            }
                        }
                        if (ListSelection.this._operationCanceled || this.isCancelled()) break block44;
                        ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(10);
                        status = this._tempDataManager.copyFile(ListSelection.this._secondDataManager, toDssFilename);
                        ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(11);
                        if (ListSelection.this._secondDataManager != null) {
                            ListSelection.this._secondDataManager.done();
                            ListSelection.this._secondDataManager.close();
                        }
                        ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(12);
                        try {
                            this._tempDataManager.done();
                            this._tempDataManager.close();
                            if (this._tempDataManager.isRemote()) {
                                if (ServerSuiteUtil.getFileManager().deleteFile(this.tempToFileName)) {
                                    System.out.println(this.tempToFileName + " deleted");
                                    this.tempToFileName = null;
                                } else {
                                    System.out.println("could not delete " + this.tempToFileName);
                                    this.tempToFileName = null;
                                }
                            } else {
                                File file = new File(this.tempToFileName);
                                if (file.delete()) {
                                    System.out.println("Temp file deleted: " + this.tempToFileName);
                                    this.tempToFileName = null;
                                } else {
                                    System.out.println("could not delete " + this.tempToFileName);
                                    this.tempToFileName = null;
                                }
                            }
                        }
                        catch (RemoteException e) {
                            System.out.println("could not delete " + this.tempToFileName);
                            this.tempToFileName = null;
                        }
                        ((MyDssVueProgressBar)ListSelection.this._dssVueProgressBar).setProgress(13);
                    }
                    finally {
                        _isInteractive = interactove;
                        _isInteractiveSet = interactoveSet;
                    }
                }
                if (ListSelection.this._operationCanceled) {
                    ListSelection.this.operationCanceled(2, false, status);
                } else {
                    ListSelection.this.operationFinished(2, status, true);
                }
                return null;
            }
        };
        ((MyDssVueProgressBar)this._dssVueProgressBar).setWorker(worker);
        worker.execute();
        this._dssVueProgressBar.go();
    }

    protected void mergeFiles(boolean remote) {
        Object toDssFilename = this.openDSSFileDialog(remote, "Copy all records into HEC-DSS File", false);
        if (toDssFilename == null) {
            return;
        }
        if (!((String)toDssFilename).toLowerCase().endsWith(".dss")) {
            toDssFilename = (String)toDssFilename + ".dss";
        }
        if (remote && !this._dataManager.isRemote()) {
            this.merge((String)toDssFilename, remote);
        } else if (!remote && this._dataManager.isRemote()) {
            this.merge((String)toDssFilename, remote);
        } else {
            this.mergeFiles((String)toDssFilename, ListSelection.isInteractive());
        }
    }

    public void mergeFiles(String toDssFilename) {
        this.mergeFiles(toDssFilename, false);
    }

    protected void mergeFiles(String toDssFilename, boolean interactive) {
        int numberRecords;
        boolean opened;
        this._secondDataManagerName = toDssFilename;
        if (this.miCopyRecordsTo.isVisible()) {
            this.miCopyRecordsTo.setVisible(false);
        }
        if (!(opened = this.openDSSFile(this._secondDataManagerName, false, false))) {
            return;
        }
        if (!this._secondDataManager.writeAccess()) {
            String message = "No write access to DSS File " + this._secondDataManagerName;
            System.out.println(message);
            if (interactive) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        int status = 0;
        this._operationCanceled = false;
        this.shutDownDssVueProgressBar();
        if (interactive) {
            this.setCursorWait();
        }
        if ((numberRecords = this._dataManager.numberRecords()) >= 1000 && interactive && !this._remote) {
            this._dssVueProgressBar = new DssVueProgressBar(this, 2, this._secondDataManagerName, "Merge");
            new SwingWorker<Object, Object>(){

                @Override
                public Object doInBackground() {
                    Thread.currentThread().setPriority(4);
                    int mlevel = ListSelection.this._dataManager.getMessageLevel();
                    ListSelection.this._dataManager.setMessageLevel(2);
                    int status = ListSelection.this._dataManager.copyFile(ListSelection.this._secondDataManager, ListSelection.this._secondDataManagerName);
                    ListSelection.this._dataManager.setMessageLevel(mlevel);
                    if (ListSelection.this._operationCanceled) {
                        ListSelection.this.operationCanceled(2, false, status);
                    } else {
                        ListSelection.this.operationFinished(2, status, true);
                    }
                    if (status < 0 || ListSelection.this.checkForSevereError(ListSelection.this._dataManager)) {
                        // empty if block
                    }
                    if (ListSelection.this._secondDataManager != null) {
                        ListSelection.this._secondDataManager.done();
                    }
                    return null;
                }
            }.execute();
            this._dssVueProgressBar.go();
        } else {
            this._dataManager.setMessageLevel(2);
            status = this._dataManager.copyFile(this._secondDataManager, this._secondDataManagerName);
            this._dataManager.setMessageLevel(4);
            if (status < 0 || this.checkForSevereError(this._dataManager)) {
                return;
            }
            this.operationFinished(2, status, interactive);
            if (this._secondDataManager != null) {
                this._secondDataManager.done();
            }
        }
    }

    public void mergeFiles(File[] files) {
        if (this.miCopyRecordsTo.isVisible()) {
            this.miCopyRecordsTo.setVisible(false);
        }
        if (!this._dataManager.writeAccess()) {
            String message = "No write access to DSS File " + this._dataManager.DSSFileName();
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        int status = 0;
        this._operationCanceled = false;
        this.shutDownDssVueProgressBar();
        this.setCursorWait();
        for (int i = 0; i < files.length; ++i) {
            this._secondDataManagerName = files[i].getAbsolutePath();
            boolean opened = this.openDSSFile(this._secondDataManagerName, false, false);
            if (!opened) continue;
            this._secondDataManager.numberRecords();
            this._dataManager.setMessageLevel(2);
            status = this._secondDataManager.copyFile(this._dataManager, this._dataManager.DSSFileName());
            this._dataManager.setMessageLevel(4);
            if (status >= 0 && !this.checkForSevereError(this._dataManager)) continue;
            return;
        }
        this.setCursorDefault();
        this.refreshCatalog();
    }

    public void squeeze() {
        if (!this.isDssFileAccessible()) {
            if (!this._remote) {
                JFileChooser chooser = this._currentDirectory != null ? new JFileChooser(this._currentDirectory) : new JFileChooser();
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setDialogTitle("Select HEC-DSS file to squeeze");
                FileNameExtensionFilter filter = new FileNameExtensionFilter("*.dss", "dss");
                chooser.addChoosableFileFilter(filter);
                int option = chooser.showOpenDialog(this);
                if (option != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                this.setCursorWait();
                int status = Heclib.squeezeDSS((String)file.getAbsolutePath());
                this.operationFinished(3, status, true);
                this.openDSSFile(file.getAbsolutePath(), true, true);
                return;
            }
            String message = "For remote squeeze, you must open the HEC-DSS file first";
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        if (!this._dataManager.writeAccess()) {
            String message = "No write access to DSS File " + this._dataManager.DSSFileName();
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        int numberRecords = this._dataManager.numberRecords();
        this.setCursorWait();
        int status = 0;
        this._operationCanceled = false;
        this.shutDownDssVueProgressBar();
        if (numberRecords >= 1000 && !this._remote && ListSelection.isInteractive()) {
            this._dssVueProgressBar = new DssVueProgressBar(this, 3, 1, "Squeeze Database");
            this._dssVueProgressBar.setTask(1, 0, "Squeezing");
            new SwingWorker<Object, Object>(){

                @Override
                public Object doInBackground() {
                    Thread.currentThread().setPriority(4);
                    int status = ListSelection.this._dataManager.squeeze();
                    if (!ListSelection.this._operationCanceled) {
                        ListSelection.this.operationFinished(3, status, true);
                    }
                    return null;
                }
            }.execute();
            this._dssVueProgressBar.go();
        } else {
            status = this._dataManager.squeeze();
            this.operationFinished(3, status, true);
        }
    }

    public void convertVersion() {
        if (!this.isDssFileAccessible()) {
            return;
        }
        int vers = this._dataManager.zinqir("VERS");
        String title = vers == 6 ? "Open New DSS 7 File To Convert To" : "Open New DSS 6 File To Convert To";
        JFileChooser chooser = this._currentDirectory != null ? new JFileChooser(this._currentDirectory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(title);
        chooser.setApproveButtonText("Create");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.dss", "dss");
        chooser.addChoosableFileFilter(filter);
        int option = chooser.showOpenDialog(this);
        if (option != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        int numberRecords = this._dataManager.numberRecords();
        int status = 0;
        this._operationCanceled = false;
        this.shutDownDssVueProgressBar();
        stringContainer sc = new stringContainer();
        boolean exists = HecDataManager.cleanDSSFileName((String)file.getAbsolutePath(), (stringContainer)sc);
        if (exists) {
            String message = "Error:  " + sc.string + " already exists.\nCannot convert to an existing file;  Please enter a new file name.";
            System.out.println(message);
            if (_isInteractive) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
            return;
        }
        final String filename = sc.string;
        title = vers == 6 ? "Convert from DSS Version 6 to DSS Version 7" : "Convert from DSS Version 7 to DSS Version 6";
        this.setCursorWait();
        if (numberRecords >= 1000 && !this._remote && ListSelection.isInteractive()) {
            this._dssVueProgressBar = new DssVueProgressBar(this, 9, filename, title);
            this._dssVueProgressBar.setTask(1, 0, "Converting file; Record");
            new SwingWorker<Object, Object>(){

                @Override
                public Object doInBackground() {
                    Thread.currentThread().setPriority(3);
                    int status = ListSelection.this._dataManager.convertVersion(filename);
                    if (!ListSelection.this._operationCanceled) {
                        if (ListSelection.this.checkForSevereError(ListSelection.this._dataManager)) {
                            return null;
                        }
                        if (status == 0) {
                            ListSelection.this._pastFilesAccessed.addElement(filename);
                            ListSelection.this.updateFileMenu();
                            ListSelection.this.openDSSFile(filename);
                        }
                        ListSelection.this.operationFinished(9, status, true);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    ListSelection.this.shutDownDssVueProgressBar();
                }
            }.execute();
            this._dssVueProgressBar.go();
        } else {
            this._dataManager.zset("SIZE", "", numberRecords);
            status = this._dataManager.convertVersion(filename);
            if (this.checkForSevereError(this._dataManager)) {
                return;
            }
            this.operationFinished(9, status, true);
            if (status == 0) {
                this._pastFilesAccessed.addElement(filename);
                this.updateFileMenu();
                this.openDSSFile(filename);
            }
        }
    }

    private void shutDownDssVueProgressBar() {
        if (this._dssVueProgressBar != null) {
            this._dssVueProgressBar.setVisible(false);
            this._dssVueProgressBar = null;
        }
    }

    public void operationFinished(int operation, int status, boolean interactive) {
        Window parent = this;
        if (this._dssVueProgressBar != null) {
            this._dssVueProgressBar.done(0);
            parent = this._dssVueProgressBar;
            this._dssVueProgressBar.setAlwaysOnTop(false);
            this.shutDownDssVueProgressBar();
        }
        if (interactive) {
            this.setCursorDefault();
        }
        this.updateFileStats(this._dataManager);
        if (operation == 5) {
            if (this._mathFrame != null) {
                int[] numberRecs = new int[1];
                int[] currentRec = new int[1];
                this.getWriteStatus(numberRecs, currentRec);
                int total = numberRecs[0];
                int current = currentRec[0];
                this._mathFrame.saveCompleted(parent, 1, current, total);
                if (this._dataManager.numberRecords() < 5000) {
                    this.updateCatalog(false);
                }
            }
        } else if (operation != 10) {
            if (status == 0) {
                Object message;
                if (operation == 3) {
                    message = "DSS File " + this._dataManager.DSSFileName() + " squeezed.";
                } else if (operation == 2) {
                    message = "Files merged.";
                } else if (operation == 9) {
                    int nrecs = this._dataManager.numberRecords();
                    int[] numberRecs = new int[1];
                    int[] currentRec = new int[1];
                    int[] numberErrors = new int[1];
                    HecDataManager.processStatus((int[])numberRecs, (int[])currentRec, (int[])numberErrors);
                    message = numberErrors[0] > 0 ? "Conversion complete\n" + (nrecs -= numberErrors[0]) + " records converted\n" + numberErrors[0] + " empty records (not copied)" : "Conversion complete\n" + nrecs + " records converted";
                } else {
                    message = "Operation completed";
                }
                System.out.println((String)message);
                if (interactive) {
                    JOptionPane.showMessageDialog(parent, message, _programName, 1);
                }
            } else {
                Object[] options;
                int opt;
                Object message = operation == 3 ? "Error during squeeze of File " + this._dataManager.DSSFileName() : (operation == 2 ? "Error during file merge." : (operation == 9 ? "Error during conversion" : "Error during operation."));
                System.out.println((String)message);
                System.out.println("Status: " + status);
                if (interactive && (opt = JOptionPane.showOptionDialog(parent, message, _programName, -1, 2, null, options = new Object[]{"OK", "View Log"}, options[1])) == 1) {
                    this.displayDssLog();
                }
            }
        }
        this.shutDownDssVueProgressBar();
    }

    public void cancelProcess() {
        this._dataManager.cancelSqueeze();
    }

    public void operationCanceled(int operation, boolean skip, int status) {
        if (!skip) {
            this._operationCanceled = true;
        }
        if (operation == 3) {
            this._dataManager.cancelSqueeze();
        } else if (operation == 9) {
            this._dataManager.cancelProcess();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._dataManager.cancelProcess();
        } else if (operation == 10) {
            if (this._compareFiles != null) {
                this._compareFiles.cancelCompare();
            }
        } else {
            this._dataManager.cancelProcess();
        }
        if (skip) {
            return;
        }
        if (operation == 4) {
            return;
        }
        if (operation == 5) {
            this.setInterrupt(true);
        }
        this.setCursorDefault();
        this.shutDownDssVueProgressBar();
        if (status == 0) {
            String message;
            if (operation == 3) {
                message = "Squeeze canceled.";
            } else if (operation == 2) {
                message = "Merge canceled.";
            } else {
                if (operation == 10) {
                    return;
                }
                message = "Operation canceled.";
            }
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 1);
            }
        } else {
            String message = operation == 3 ? "Unable to cancel squeeze." : (operation == 2 ? "Unable to cancel merge." : "Unable to cancel operation.");
            System.out.println(message);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
        }
    }

    public int fileCheck() {
        this._messageUnit = this._dataManager.zinqir("MUNIT");
        stringContainer logFile = new stringContainer();
        String name = RMAIO.getFileNameNoExtension((String)this._dataManager.DSSFileName());
        this.openLogFile(19, null, name, logFile);
        System.out.println("fileCheck open log file, requested name: " + name + ", name used: " + logFile.string);
        this._fileCheckLogFile = logFile.string;
        HecDataManager.zset((String)"MUNIT", (String)" ", (int)19);
        this._operationCanceled = false;
        Heclib.zset((String)"MAXERROR", (String)"", (int)200);
        Heclib.fortranWrite((String)(" File Check for " + this._dataManager.DSSFileName()), (int)19);
        Heclib.fortranWrite((String)" ", (int)19);
        this._dataManager.fileStats();
        Heclib.fortranWrite((String)" ", (int)19);
        if (this._dataManager.numberRecords() > 1000) {
            this._dssVueProgressBar = new DssVueProgressBar(this, 4, 4, "Database Integrity Check");
        } else {
            this.shutDownDssVueProgressBar();
            this.setCursorWait("Checking File Inegrity");
        }
        new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                Thread.currentThread().setPriority(3);
                if (ListSelection.this._dssVueProgressBar != null) {
                    ListSelection.this._dssVueProgressBar.setTask(1, 0, "Step 1 of 4, Loading file into system cache");
                }
                if (ListSelection.this._operationCanceled) {
                    return new Integer(0);
                }
                if (ListSelection.this._dssVueProgressBar != null) {
                    ListSelection.this._dssVueProgressBar.setTask(2, 0, "Step 2 of 4, Verifying Records");
                }
                Heclib.fortranWrite((String)" ", (int)19);
                Heclib.fortranWrite((String)" Verifying Records", (int)19);
                int numberErrors = ListSelection.this._dataManager.checkAllPathnames();
                if (ListSelection.this._operationCanceled || numberErrors >= 200) {
                    return new Integer(numberErrors);
                }
                if (ListSelection.this._dssVueProgressBar != null) {
                    ListSelection.this._dssVueProgressBar.setTask(3, numberErrors, "Step 3 of 4, Verifying Addresses");
                }
                Heclib.fortranWrite((String)" ", (int)19);
                Heclib.fortranWrite((String)" Verifying Addresses", (int)19);
                if (ListSelection.this._operationCanceled || (numberErrors += ListSelection.this._dataManager.checkLinks()) >= 200) {
                    return new Integer(numberErrors);
                }
                if (ListSelection.this._dssVueProgressBar != null) {
                    ListSelection.this._dssVueProgressBar.setTask(4, numberErrors, "Step 4 of 4, Verifying Indices");
                }
                Heclib.fortranWrite((String)" ", (int)19);
                Heclib.fortranWrite((String)" Verifying Indices", (int)19);
                return new Integer(numberErrors += ListSelection.this._dataManager.checkPathnameBins());
            }

            @Override
            protected void done() {
                try {
                    Object obj = this.get();
                    int numberErrors = 0;
                    if (obj instanceof Integer) {
                        numberErrors = (Integer)obj;
                    }
                    if (ListSelection.this._operationCanceled) {
                        ListSelection.this.fileCheckDone(3, numberErrors);
                    } else {
                        ListSelection.this.fileCheckDone(1, numberErrors);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.execute();
        if (this._dssVueProgressBar != null) {
            this._dssVueProgressBar.go();
        }
        return 0;
    }

    protected void fileCheckDone(int status, int numberErrors) {
        Object[] options;
        this.setCursorDefault();
        boolean logFileValid = false;
        if (this._messageUnit > 0) {
            HecDataManager.zset((String)"MUNIT", (String)" ", (int)this._messageUnit);
            Heclib.fortranClose((int)19);
            File file = new File(this._fileCheckLogFile);
            file.deleteOnExit();
            if (file.length() > 10L) {
                logFileValid = true;
            }
        }
        StringBuffer message = new StringBuffer("Database integrity check ");
        if (status == 3) {
            message.append("canceled.");
        } else if (numberErrors >= 200) {
            message.append("stopped because error limit reached.");
            if (this._dssVueProgressBar != null) {
                this._dssVueProgressBar.canceled();
            }
        } else {
            message.append("completed.");
            if (this._dssVueProgressBar != null) {
                this._dssVueProgressBar.done(numberErrors);
            }
        }
        this.setCursorDefault();
        int opt = 0;
        boolean squeeze = false;
        int icon = 2;
        if (numberErrors == 0) {
            int ipoint;
            int size;
            message.append("\nNo errors detected.");
            Object reason = "";
            int idead = this._dataManager.zinqir("DEAD");
            if (idead > 25) {
                squeeze = true;
                reason = "Inactive space: " + idead + "%  > 25%";
            } else if (idead > 15 && (size = this._dataManager.zinqir("SIZE")) > 1000000) {
                squeeze = true;
                reason = "Inactive space: " + idead + "%  > 15%, large file.";
            }
            if (!squeeze && (ipoint = this._dataManager.zinqir("POINT")) > 500) {
                squeeze = true;
                HecDouble p = new HecDouble((double)ipoint / 100.0, 2);
                reason = "Pointer utilization: " + p.toString() + "  > 5 (should be < 1)";
            }
            if (squeeze) {
                message.append("\nHowever, file efficiency can be improved by squeezing.\n");
                message.append((String)reason);
                message.append("\nSqueeze?");
                icon = 1;
            }
        } else {
            squeeze = true;
            message.append("\n");
            if (numberErrors >= 200) {
                message.append("More than ");
                message.append(numberErrors);
            } else {
                message.append(numberErrors);
            }
            message.append(" errors detected.\nSqueeeze file to repair errors?");
        }
        if (!squeeze) {
            if (logFileValid) {
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    options = new Object[]{"OK", "View Log"};
                    opt = JOptionPane.showOptionDialog(this, message, _programName, -1, 1, null, options, options[1]);
                }
            } else {
                System.out.println(message);
                if (ListSelection.isInteractive()) {
                    options = new Object[]{"OK"};
                    opt = JOptionPane.showOptionDialog(this, message, _programName, -1, 1, null, options, options[0]);
                }
            }
            this.shutDownDssVueProgressBar();
            if (opt == 1) {
                this.displayFileCheckLog();
            }
        } else {
            while (true) {
                if (logFileValid) {
                    System.out.println(message);
                    if (ListSelection.isInteractive()) {
                        options = new Object[]{"Squeeze", "View Log", "Cancel"};
                        opt = JOptionPane.showOptionDialog(this, message, _programName, -1, icon, null, options, options[0]);
                    }
                    logFileValid = false;
                } else {
                    System.out.println(message);
                    if (ListSelection.isInteractive() && (opt = JOptionPane.showOptionDialog(this, message, _programName, -1, icon, null, options = new Object[]{"Squeeze", "Cancel"}, options[0])) == 1) {
                        opt = 2;
                    }
                }
                this.shutDownDssVueProgressBar();
                if (opt == 0) {
                    this.squeeze();
                    return;
                }
                if (opt != true) break;
                this.displayFileCheckLog();
            }
            return;
        }
    }

    protected void displayFileCheckLog() {
        block2: {
            TextDialog textDialog = new TextDialog((Component)this);
            try {
                textDialog.initialize(this._fileCheckLogFile, false);
                textDialog.setAlwaysOnTop(true);
                textDialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
                textDialog.setLocation(20, 20);
                textDialog.setSize(700, 500);
                textDialog.setVisible(true);
                this._objectList.addElement(textDialog);
                textDialog.addWindowListener((WindowListener)this._windowClosingListener);
            }
            catch (Exception e) {
                String message = "Unable to access DSS log file: " + this._dssLogFile + "\n" + e.toString();
                System.out.println(message);
                if (!ListSelection.isInteractive()) break block2;
                JOptionPane.showMessageDialog(this, message, _programName, 2);
            }
        }
    }

    public void diskCatalog(int catalogType) {
        boolean sortCatalog;
        String pathWithWildChars = "";
        if (catalogType == 1 || catalogType == 0) {
            if (this.wildCharsSearch.isSelected() && this.useCatalogWildChars()) {
                pathWithWildChars = this.getWildCardChooserDlg().getSelectedItem();
                if (pathWithWildChars != null && pathWithWildChars.trim().length() > 0) {
                    this._catalogWithWildChars = pathWithWildChars.trim();
                    this._catalogWithWildCharsChoices.add(this._catalogWithWildChars);
                } else {
                    this._catalogWithWildChars = null;
                }
            } else {
                this._catalogWithWildChars = null;
            }
        }
        switch (catalogType) {
            case 1: {
                this.setCursorWait("Building new Sorted Selective Catalog File...");
                sortCatalog = true;
                break;
            }
            case 0: {
                this.setCursorWait("Building new Unsorted Selective Catalog File...");
                sortCatalog = false;
                break;
            }
            default: {
                this.setCursorWait("Building new sorted catalog file...");
                sortCatalog = true;
            }
        }
        if (debug) {
            System.out.println("Enter ListSelection.diskCatalog() ");
            System.out.println("disk Catalog, cat = " + catalogType);
            ElapsedTime.startElapsedTime();
        }
        final int catType = catalogType;
        final boolean sorted = sortCatalog;
        final String pathWithWild = pathWithWildChars;
        final String catName = this._dataManager.getCatalogName(1);
        final ListSelection listSelection = this;
        new SwingWorker<Object, Object>(){
            int numberCataloged = 0;

            @Override
            public Object doInBackground() {
                IHecDSSUtilities obj = ListSelection.this._dataManager.dataManager();
                if (obj instanceof HecDssCatalog) {
                    HecDssCatalog dssCatalog = (HecDssCatalog)obj;
                    this.numberCataloged = dssCatalog.catalogFile(catName, sorted, pathWithWild);
                }
                return null;
            }

            @Override
            protected void done() {
                if (debug) {
                    System.out.println("Catalog complete " + ElapsedTime.elapsedTimeDescription((boolean)true));
                }
                listSelection.diskCatalogDone(catType, this.numberCataloged);
            }
        }.execute();
    }

    protected void diskCatalogDone(int catalogType, int numberCataloged) {
        block6: {
            this.setCursorDefault();
            if (numberCataloged < 0) {
                String mess = "Unable to access HEC-DSS catalog file.";
                System.out.println(mess);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, mess, _programName, 2);
                }
                return;
            }
            if (numberCataloged == 0) {
                String mess = catalogType == 2 ? "No pathnames found." : "No pathnames match selection.";
                System.out.println(mess);
                if (ListSelection.isInteractive()) {
                    JOptionPane.showMessageDialog(this, mess, _programName, 2);
                }
                return;
            }
            String catName = this._dataManager.getCatalogName(1);
            try {
                this.printViewFile(catName, false);
            }
            catch (Exception e) {
                String mess = "Unable to access HEC-DSS catalog file.\n" + e.toString();
                System.out.println(mess);
                if (!ListSelection.isInteractive()) break block6;
                JOptionPane.showMessageDialog(this, mess, _programName, 2);
            }
        }
    }

    public TextDialog printViewFile(String fileName, boolean print) throws Exception {
        String configurationManagerHelpString = null;
        if (!print) {
            configurationManagerHelpString = "dssOutputHelp";
        }
        TextDialog textDialog = configurationManagerHelpString != null ? new TextDialog((Component)this, configurationManagerHelpString) : new TextDialog((Component)this);
        try {
            textDialog.initialize(fileName, false);
            textDialog.setLocation(20, 20);
            textDialog.setSize(700, 500);
            if (print) {
                textDialog.print();
            } else {
                textDialog.setVisible(true);
                this._objectList.addElement(textDialog);
                textDialog.addWindowListener((WindowListener)this._windowClosingListener);
                Help.setHelp((RootPaneContainer)textDialog, "31");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return textDialog;
    }

    public void statusDebug() {
        if (this._dataManager == null) {
            return;
        }
        List output = this._dataManager.DssFileManagerStatus();
        StringBuffer text = new StringBuffer();
        HecTime htime = new HecTime(0);
        htime.setCurrent();
        text.append("DSS Trace for " + htime.dateAndTime() + " (local)");
        text.append("\n");
        text.append("Number of files accessed: " + output.size());
        text.append("\n");
        for (int i = 0; i < output.size(); ++i) {
            HecDSSFileData fileDataSet = (HecDSSFileData)output.get(i);
            text.append("\n");
            text.append("File: " + fileDataSet.dssFileName);
            text.append("\n");
            text.append("Open: " + fileDataSet.dssFileOpened);
            text.append("\n");
            text.append("Objects accessing file: " + fileDataSet.objectCount);
            text.append("\n");
            htime.set(fileDataSet.firstAccessTime);
            text.append("First Access: " + htime.dateAndTime());
            text.append("\n");
            htime.set(fileDataSet.lastAccessTime);
            text.append("Last Access:  " + htime.dateAndTime());
            text.append("\n");
            text.append("Number of Accesses: " + fileDataSet.numberAccesses);
            text.append("\n");
        }
        JEditorPane textPane = new JEditorPane();
        textPane.setContentType("text/plain");
        textPane.setText(text.toString());
        JScrollPane scrollPane = new JScrollPane(textPane);
        JFrame frame = new JFrame("HecDss File Manager Status");
        frame.getContentPane().add(scrollPane);
        frame.setLocation(20, 20);
        frame.setSize(500, 400);
        frame.setVisible(true);
    }

    protected void zsetRequest() {
        String request = JOptionPane.showInputDialog(this, "Enter ZSET parameter and  value(s)", "ZSET", 3);
        if (request == null || request.length() == 0) {
            return;
        }
        String[] r = request.split(" ");
        if (r.length < 2) {
            JOptionPane.showMessageDialog(this, "Invalid entry; must be two or three items separated by a space", "ZSET", 2);
        }
        String sval = "";
        int ival = 0;
        if (r.length == 3) {
            sval = r[1];
            try {
                ival = Integer.parseInt(r[2]);
            }
            catch (Exception exception) {}
        } else {
            try {
                ival = Integer.parseInt(r[1]);
            }
            catch (Exception e) {
                sval = r[1];
            }
        }
        this._dataManager.zset(r[0].toUpperCase(), sval.toUpperCase(), ival);
    }

    protected void zinqirRequest() {
        String request = JOptionPane.showInputDialog(this, "Enter ZINQIR parameter request", "ZINQIR", 3);
        if (request == null || request.length() == 0) {
            return;
        }
        stringContainer alpha = new stringContainer();
        int[] number = new int[1];
        this._dataManager.zinqir(request.toUpperCase(), alpha, number);
        String mess = "Results - Alpha: " + alpha.string + ",  Numeric: " + number[0];
        JOptionPane.showMessageDialog(this, mess, "ZINQIR", 1);
    }

    protected void memoryMonitor_Action() {
        if (this._memMonitorFrame == null) {
            final MemoryMonitor demo = new MemoryMonitor();
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    demo.surf.stop();
                    ListSelection.this._memMonitorFrame = null;
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    demo.surf.start();
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    demo.surf.start();
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    demo.surf.stop();
                }
            };
            this._memMonitorFrame = new RmaJFrame("MemoryMonitor");
            this._memMonitorFrame.setSystemClosable(false);
            this._memMonitorFrame.addWindowListener((WindowListener)l);
            this._memMonitorFrame.getContentPane().add("Center", (Component)demo);
            this._memMonitorFrame.pack();
            this._memMonitorFrame.setSize(new Dimension(200, 200));
            this._memMonitorFrame.setVisible(true);
        } else if (this._memMonitorFrame.getState() == 1) {
            this._memMonitorFrame.setState(0);
        } else if (!this._memMonitorFrame.isVisible()) {
            this._memMonitorFrame.setVisible(true);
        } else {
            this._memMonitorFrame.toFront();
        }
    }

    public void setMessageLevel() {
        if (Heclib.getLibraryVersion() >= 70211) {
            MessageLevelDialog mld = new MessageLevelDialog(this);
            mld.setVisible(true);
        } else {
            String s;
            int level = 4;
            if (this._dataManager != null) {
                level = this._dataManager.getMessageLevel();
            }
            if ((s = JOptionPane.showInputDialog(this, "Enter Message Level (Default is 4)", Integer.toString(level))) == null) {
                return;
            }
            level = Integer.parseInt(s);
            if (this._dataManager != null) {
                this._dataManager.setMessageLevel(level);
            } else {
                HecDataManager.setMessageLevel((int)level);
            }
        }
    }

    public void examineDssFile() {
        if (this._dataManager != null && this._dataManager.isRemote()) {
            JOptionPane.showMessageDialog(this, "Not implemented for Remote Files");
            return;
        }
        if (this._dataManager != null && this._dataManager.fileAccessible()) {
            if (this._dataManager.zinqir("VERS") == 6) {
                JOptionPane.showMessageDialog(this, "Not implemented for version 6 Files");
                return;
            }
            String s = JOptionPane.showInputDialog(this, "Enter address and number of words", "0 40");
            if (s == null) {
                return;
            }
            String[] sp = s.split(" ");
            if (sp.length != 2) {
                return;
            }
            long address = Long.parseLong(sp[0]);
            int numberWords = Integer.parseInt(sp[1]);
            DebugExamineFile7 frame = new DebugExamineFile7((HecDataManager)((HecDSSUtilities)this._dataManager.dataManager()), address, numberWords);
            frame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "Please open a dss file");
        }
    }

    protected void fileAccessInfo() {
        if (this._dataManager.isRemote()) {
            JOptionPane.showMessageDialog(this, "Not implemented for Remote Files");
            return;
        }
        if (this._dataManager.zinqir("VERS") == 6) {
            JOptionPane.showMessageDialog(this, "Not implemented for version 6 Files");
            return;
        }
        int[] accessMode = new int[1];
        int[] numberAccesses = new int[1];
        int[] numberWrites = new int[1];
        int[] pidsArray = new int[20];
        int[] modesArray = new int[20];
        int[] numberPids = new int[1];
        this._dataManager.fileAccessInfo(accessMode, numberAccesses, numberWrites, pidsArray, modesArray, numberPids);
        String access = "Current access for file   " + this._dataManager.getDSSFileName() + "   \nAccess mode:  " + this.getAcessModeName(accessMode[0]) + "  \nNumber processes accessing the file:  " + numberAccesses[0] + "\nNumber processes writing to the file:  " + numberWrites[0] + "\nNumber current processes recorded in the file:  " + numberPids[0] + "\n";
        for (int i = 0; i < numberPids[0]; ++i) {
            access = access + "\nProcess ID:  " + pidsArray[i] + "\nMode:  " + this.getAcessModeName(modesArray[i]);
            String pidName = Heclib.getProcessName((int)pidsArray[i]);
            access = access + "\nProcess Name:  " + pidName + "    \n";
        }
        JOptionPane.showMessageDialog(this, access);
    }

    protected String getAcessModeName(int mode) {
        if (mode == 0) {
            return " ";
        }
        if (mode == 1) {
            return "Read Only";
        }
        if (mode == 2) {
            return "Multiple Writers";
        }
        if (mode == 3) {
            return "Single Read/Write - Advisory";
        }
        if (mode == 4) {
            return "Exclusive";
        }
        if (mode == 5) {
            return "Exclusive";
        }
        if (mode == 6) {
            return "Exclusive Release";
        }
        return Integer.toString(mode);
    }

    protected void debugFileInfo() {
        if (this._dataManager.isRemote()) {
            JOptionPane.showMessageDialog(this, "Not implemented for Remote Files");
            return;
        }
        if (this._dataManager.zinqir("VERS") == 6) {
            JOptionPane.showMessageDialog(this, "Not implemented for DSS 6 Files");
            return;
        }
        DebugFileInfo7 frame = new DebugFileInfo7((HecDataManager)((HecDSSUtilities)this._dataManager.dataManager()));
        frame.setVisible(true);
    }

    protected void debugPathnameBins() {
        if (this._dataManager.isRemote()) {
            JOptionPane.showMessageDialog(this, "Not implemented for Remote Files");
            return;
        }
        if (this._dataManager.zinqir("VERS") == 6) {
            JOptionPane.showMessageDialog(this, "Not implemented for Version 6 Files");
            return;
        }
        String s = JOptionPane.showInputDialog(this, "Enter bin address", "");
        if (s == null) {
            return;
        }
        long address = Long.parseLong(s);
        DebugFileInfo7 frame = new DebugFileInfo7((HecDataManager)((HecDSSUtilities)this._dataManager.dataManager()), address, DebugFileInfo7.RecordSection.PATHNAME_BIN);
        frame.setVisible(true);
    }

    public void setTimeWindow(String start, String end, boolean applyAll) {
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        startTime.set(start);
        endTime.set(end);
        this.setTimeWindow(startTime, endTime, applyAll);
    }

    public void setTimeWindow(HecTime start, HecTime end, boolean applyAll) {
        this._selectionAndFilterPanel.setTimeWindow(start, end, applyAll);
        this.updateMessageField();
    }

    public boolean getTimeWindow(HecTime startTime, HecTime endTime) {
        return this._selectionAndFilterPanel.getTimeWindow(startTime, endTime);
    }

    public HecTime getStartTime() {
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        this.getTimeWindow(startTime, endTime);
        return startTime;
    }

    public HecTime getEndTime() {
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        this.getTimeWindow(startTime, endTime);
        return endTime;
    }

    public void delete(List object) {
        Logger logger = Logger.getLogger(ListSelection.class.getName());
        logger.log(Level.FINE, "Delete no-op");
    }

    public boolean save(Object object) {
        if (object instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsContainer = (TimeSeriesContainer)object;
            return this.save(tsContainer);
        }
        if (object instanceof StreamRatingContainer) {
            StreamRatingContainer ratingContainer = (StreamRatingContainer)object;
            return this.save(ratingContainer);
        }
        if (object instanceof AbstractRatingContainerWrapper) {
            AbstractRatingContainerWrapper ratingContainer = (AbstractRatingContainerWrapper)object;
            return this.save(ratingContainer);
        }
        if (object instanceof List) {
            int status = this.save((Vector)object);
            return status >= 0;
        }
        return false;
    }

    public boolean save(DataContainer dataContainer) {
        if (dataContainer instanceof PairedDataContainer) {
            return this.save((PairedDataContainer)dataContainer);
        }
        if (dataContainer instanceof TimeSeriesContainer) {
            return this.save((TimeSeriesContainer)dataContainer);
        }
        if (dataContainer instanceof TextContainer) {
            return this.save((TextContainer)dataContainer);
        }
        return false;
    }

    public boolean save(PairedDataContainer pairedDataContainer) {
        SaveAs saveas = new SaveAs((Frame)this, this._dataManager, (DataContainer)pairedDataContainer);
        saveas.setCheckOverwrite(false);
        saveas.saveData();
        return !saveas.canceled();
    }

    public boolean save(TimeSeriesContainer timeSeriesContainer) {
        SaveAs saveas = new SaveAs((Frame)this, this._dataManager, (DataContainer)timeSeriesContainer);
        saveas.setCheckOverwrite(false);
        saveas.saveData();
        return !saveas.canceled();
    }

    public boolean save(AbstractRatingContainerWrapper ratingContainer) {
        SaveAs saveas = new SaveAs((Frame)this, this._dataManager, (DataContainer)ratingContainer);
        saveas.setCheckOverwrite(false);
        saveas.saveData();
        return !saveas.canceled();
    }

    public boolean save(StreamRatingContainer ratingContainer) {
        SaveAs saveas = new SaveAs((Frame)this, this._dataManager, (DataContainer)ratingContainer);
        saveas.setCheckOverwrite(false);
        saveas.saveData();
        return !saveas.canceled();
    }

    public boolean save(TextContainer textContainer) {
        SaveAs saveas = new SaveAs((Frame)this, this._dataManager, (DataContainer)textContainer);
        saveas.setCheckOverwrite(false);
        saveas.saveData();
        return !saveas.canceled();
    }

    public boolean saveAs(TextContainer textContainer) {
        SaveAs saveas = new SaveAs((Frame)this, this._dataManager, (DataContainer)textContainer);
        saveas.setVisible(true);
        if (saveas.canceled()) {
            return false;
        }
        this.updateCatalog();
        return !saveas.canceled();
    }

    public boolean saveAs(DataContainer dataContainer) {
        if (dataContainer instanceof PairedDataContainer) {
            return this.saveAs((PairedDataContainer)dataContainer);
        }
        if (dataContainer instanceof TimeSeriesContainer) {
            return this.saveAs((TimeSeriesContainer)dataContainer);
        }
        if (dataContainer instanceof TextContainer) {
            return this.saveAs((TextContainer)dataContainer);
        }
        return false;
    }

    public boolean saveAs(PairedDataContainer pairedDataContainer) {
        SaveAs saveas = new SaveAs((Frame)this, this._dataManager, (DataContainer)pairedDataContainer);
        saveas.setVisible(true);
        if (saveas.canceled()) {
            return false;
        }
        this.updateCatalog();
        return true;
    }

    public boolean saveAs(TimeSeriesContainer timeSeriesContainer) {
        SaveAs saveas = new SaveAs((Frame)this, this._dataManager, (DataContainer)timeSeriesContainer);
        saveas.setVisible(true);
        if (saveas.canceled()) {
            return false;
        }
        this.updateCatalog();
        return true;
    }

    public boolean saveAs(Vector dataContainers) {
        int size = dataContainers.size();
        if (size <= 0) {
            return false;
        }
        Vector<String> pathnames = new Vector<String>(size);
        DataContainer dc = null;
        for (int i = 0; i < size; ++i) {
            dc = (DataContainer)dataContainers.get(i);
            pathnames.add(dc.fullName);
        }
        NewPartsDialog newParts = new NewPartsDialog((Frame)this, "Save As:", pathnames);
        if (dc instanceof TimeSeriesContainer) {
            newParts.disablePart("D");
            newParts.disablePart("E");
        }
        newParts.setLocationRelativeTo(this);
        newParts.setVisible(true);
        Vector newPathnames = newParts.getNewPathnames();
        if (newParts.canceled()) {
            return false;
        }
        StringBuffer message = new StringBuffer();
        if (newPathnames != null && newPathnames.size() > 0) {
            String dssFilename = this._dataManager.DSSFileName().replace('\\', '/');
            boolean differentFile = false;
            for (int i = 0; i < dataContainers.size(); ++i) {
                dc = (DataContainer)dataContainers.get(i);
                dc.fullName = (String)newPathnames.get(i);
                if (dataContainers.size() >= 5 || dc.fileName.replace('\\', '/').equals(dssFilename)) continue;
                differentFile = true;
            }
            int status = this.saveData(dataContainers);
            for (int i = 0; i < dataContainers.size(); ++i) {
                dc = (DataContainer)dataContainers.get(i);
                if (dataContainers.size() < 5) {
                    message.append("\nSaved record:  ");
                    message.append(dc.fullName);
                    if (differentFile) {
                        message.append("\nTo file: ");
                        message.append(dc.fileName);
                    }
                }
                dc.fullName = (String)pathnames.get(i);
            }
            if (status == 0) {
                if (dataContainers.size() < 5) {
                    System.out.println(message.toString());
                    if (ListSelection.isInteractive()) {
                        JOptionPane.showMessageDialog(this, message.toString(), "Data Saved", 1);
                    }
                } else {
                    String mess = dataContainers.size() + " data sets saved.";
                    System.out.println(mess);
                    if (ListSelection.isInteractive()) {
                        JOptionPane.showMessageDialog(this, mess, "Data Saved", 1);
                    }
                }
                this.updateCatalog();
                return true;
            }
            Object mess = newPathnames.size() == 1 ? "Error in saving record:  " + newPathnames.elementAt(0).toString() + "\nSee Log for details." : "Error in saving data.\nSee Log for details.";
            System.out.println((String)mess);
            if (ListSelection.isInteractive()) {
                JOptionPane.showMessageDialog(this, mess, "Could Not Save Data", 2);
            }
        }
        return false;
    }

    public int save(Vector dataContainers) {
        return this.save(dataContainers, false);
    }

    public int save(Vector dataContainers, boolean refreshCatalog) {
        return this.save(dataContainers, refreshCatalog, false);
    }

    public int save(Vector dataContainers, final boolean refreshCatalog, boolean doThreaded) {
        this._numberContainers = dataContainers.size();
        this._containerNumber = 0;
        if (dataContainers.size() > 1000) {
            doThreaded = true;
        } else {
            int numberValues = 0;
            for (int i = 0; i < dataContainers.size(); ++i) {
                Object obj = dataContainers.get(i);
                if (!(obj instanceof TimeSeriesContainer)) continue;
                numberValues += ((TimeSeriesContainer)obj).numberValues;
            }
            if (numberValues > this._maxRecord) {
                doThreaded = true;
            }
        }
        if (doThreaded && !this._remote && ListSelection.isInteractive()) {
            final Vector containers = dataContainers;
            this._dssVueProgressBar = new DssVueProgressBar(this, 5, 1, "Saving Data");
            new SwingWorker<Object, Object>(){

                @Override
                public Object doInBackground() {
                    Thread.currentThread().setPriority(3);
                    ListSelection.this.saveData(containers);
                    return null;
                }

                @Override
                protected void done() {
                    ListSelection.this.operationFinished(5, 0, true);
                    if (refreshCatalog) {
                        ListSelection.this.updateCatalog(true);
                    }
                }
            }.execute();
            this._dssVueProgressBar.go();
            return 0;
        }
        int status = this.saveData(dataContainers);
        this.operationFinished(5, status, true);
        return status;
    }

    public void getWriteStatus(int[] numberRecs, int[] currentRec) {
        numberRecs[0] = this._numberContainers;
        currentRec[0] = this._containerNumber;
    }

    public void getDataManagerStatus(int[] numberRecs, int[] currentRec) {
        if (this._remote) {
            numberRecs[0] = 0;
            currentRec[0] = 0;
        } else {
            this._dataManager.getProcessStatus(numberRecs, currentRec);
        }
    }

    public void clearStatus() {
        this._interrupt = false;
        this._numberContainers = 0;
        this._containerNumber = 0;
        this._dataManager.clearStatus();
    }

    public void setInterrupt(boolean interrupt) {
        this._interrupt = interrupt;
        this._dataManager.setInterrupt(interrupt);
    }

    public int saveData(Vector dataContainers) {
        int status = 0;
        this._numberContainers = dataContainers.size();
        DssDataManager dataManager = this._dataManager;
        this._containerNumber = 0;
        while (this._containerNumber < this._numberContainers) {
            if (this._interrupt) {
                this._interrupt = false;
                return status;
            }
            Object obj = dataContainers.get(this._containerNumber);
            if (obj instanceof DataContainer) {
                DataContainer dataContainer = (DataContainer)obj;
                dataManager = this.getDssDataManager(dataContainer.fileName, dataManager);
                status = dataManager.writeData(dataContainer);
            }
            ++this._containerNumber;
        }
        return status;
    }

    public int saveData(Vector dataContainers, DssDataManager DssDataManager2) {
        int status = 0;
        this._numberContainers = dataContainers.size();
        this._containerNumber = 0;
        while (this._containerNumber < this._numberContainers) {
            if (this._interrupt) {
                this._interrupt = false;
                return status;
            }
            Object obj = dataContainers.get(this._containerNumber);
            if (obj instanceof DataContainer) {
                DataContainer dataContainer = (DataContainer)obj;
                status = DssDataManager2.writeData(dataContainer);
            }
            ++this._containerNumber;
        }
        return status;
    }

    public int checkOverwriteRecords(DssDataManager dataManager, Vector pathnames, Vector newPathnames) {
        int i;
        if (!ListSelection.isInteractive()) {
            return 0;
        }
        if (dataManager == null) {
            dataManager = this.getDataManager();
        }
        boolean[] exists = dataManager.recordsExist((List)newPathnames);
        Vector existingRecords = new Vector();
        for (i = 0; i < exists.length; ++i) {
            String oldPathname = (String)pathnames.get(i);
            String newPathname = (String)newPathnames.get(i);
            if (!exists[i] || oldPathname.equalsIgnoreCase(newPathname)) continue;
            existingRecords.add(newPathnames.get(i));
        }
        if (existingRecords.size() > 0) {
            System.out.println(existingRecords.size() + " records already exist:");
            for (i = 0; i < existingRecords.size(); ++i) {
                System.out.println((String)existingRecords.get(i));
            }
            StringBuffer message = new StringBuffer();
            if (existingRecords.size() > 4) {
                message.append(Integer.toString(existingRecords.size()));
                message.append(" records already exist.\nOverwrite existing records?");
            } else {
                message.append("Record(s) already exist:");
                for (int i2 = 0; i2 < existingRecords.size(); ++i2) {
                    message.append("\n");
                    message.append((String)existingRecords.get(i2));
                }
                message.append("\nOverwrite existing record(s)?");
            }
            int option = JOptionPane.showConfirmDialog(this, message, "HecDssVue", 1);
            if (option == 2) {
                return option;
            }
            if (option == 1) {
                for (int i3 = exists.length - 1; i3 > -1; --i3) {
                    if (!exists[i3]) continue;
                    pathnames.removeElementAt(i3);
                    newPathnames.removeElementAt(i3);
                }
            }
            return option;
        }
        return 0;
    }

    public void checkOverwriteRecords(final String operationType, final DssDataManager dataManager, final DataReferenceSet pathnames, final Vector newPathnames) {
        this.setCursorWait("Checking if records exist in " + dataManager.DSSFileName());
        SwingWorker<boolean[], boolean[]> ckExists = new SwingWorker<boolean[], boolean[]>(){

            @Override
            public boolean[] doInBackground() {
                Thread.currentThread().setPriority(4);
                boolean[] exists = dataManager.recordsExist((List)newPathnames);
                return exists;
            }

            @Override
            protected void done() {
                boolean[] exists;
                try {
                    exists = (boolean[])this.get();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.toString());
                    ListSelection.this.setCursorDefault();
                    return;
                }
                ListSelection.this.setCursorDefault();
                Vector existingRecords = new Vector();
                for (int i = 0; i < exists.length; ++i) {
                    String oldPathname = pathnames.get(i).getPath();
                    String newPathname = (String)newPathnames.get(i);
                    if (!exists[i] || oldPathname.equalsIgnoreCase(newPathname)) continue;
                    existingRecords.add(newPathnames.get(i));
                }
                if (existingRecords.size() > 0) {
                    System.out.println(existingRecords.size() + " records already exist:");
                    int size = existingRecords.size();
                    if (size > 10) {
                        size = 10;
                    }
                    for (int i = 0; i < size; ++i) {
                        System.out.println((String)existingRecords.get(i));
                    }
                    StringBuffer message = new StringBuffer();
                    if (existingRecords.size() > 4) {
                        message.append(Integer.toString(existingRecords.size()));
                        message.append(" records already exist.\nOverwrite existing records?");
                    } else {
                        message.append("Record(s) already exist:");
                        for (int i = 0; i < existingRecords.size(); ++i) {
                            message.append("\n");
                            message.append((String)existingRecords.get(i));
                        }
                        message.append("\nOverwrite existing record(s)?");
                    }
                    int option = JOptionPane.showConfirmDialog(null, message, "HecDssVue", 1);
                    if (option == 2) {
                        return;
                    }
                    if (option == 1) {
                        for (int i = exists.length - 1; i > -1; --i) {
                            if (!exists[i]) continue;
                            pathnames.removePathname(i);
                            newPathnames.removeElementAt(i);
                        }
                    }
                }
                if (newPathnames.size() == 0) {
                    return;
                }
                if (operationType.equals("CopyTo")) {
                    ListSelection.this.completeCopyRecords(pathnames);
                } else if (operationType.equals("CopyFrom")) {
                    ListSelection.this.completeCopyFrom(pathnames, dataManager);
                } else if (operationType.equals("Rename")) {
                    ListSelection.this.completeDupRename(pathnames, newPathnames, operationType, 7);
                } else if (operationType.equals("Duplicate")) {
                    ListSelection.this.completeDupRename(pathnames, newPathnames, operationType, 8);
                }
            }
        };
        ckExists.execute();
    }

    protected String getErrorMessage() {
        DSSErrorMessage errorMessage = this._dataManager.lastSevereErrorMessage();
        if (errorMessage != null) {
            this._dataManager.clearSevereError();
            return errorMessage.message();
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ActionEvent) {
            ActionEvent event = (ActionEvent)arg;
            String eventName = event.getActionCommand();
            if (eventName.compareTo("selectionUpdated") == 0) {
                this.selectionUpdated();
            } else if (eventName.compareTo("pathnamesShownUpdated") == 0) {
                this.selectionUpdated();
            } else if (eventName.compareTo("timesUpdated") == 0) {
                this.updateMessageField();
            } else if (eventName.compareTo("refreshCatalog") == 0) {
                this.refreshCatalog();
            } else if (eventName.compareTo("dssFileChanged") == 0) {
                this.dssFileChanged();
            } else if (eventName.compareTo("dssFileClosed") == 0) {
                this.dssFileClosed();
            } else if (eventName.compareTo("defaultDisplay") == 0) {
                this.defaultDisplay(true);
            } else if (eventName.compareTo("resetToDefaults") == 0) {
                this.resetToDefaults();
            } else if (eventName.compareTo("nextImage") == 0) {
                this.nextImage();
            } else if (eventName.compareTo("PhotoViewerClose") == 0) {
                this._imageFrame = null;
            } else if (eventName.compareTo("groupsUpdated") == 0) {
                this.groupUpdateMenu();
            } else if (eventName.compareTo("searchByString") == 0) {
                this.pathnameStringSearch.doClick(0);
            } else if (eventName.compareTo("searchByPathname") == 0) {
                this.pathnamePartsSearch.doClick(0);
            } else if (eventName.compareTo("wildCharsSearch") == 0) {
                this.wildCharsSearch.doClick(0);
            } else if (eventName.compareTo("getTimeWindow") == 0 && this._selectionAndFilterPanel != null) {
                this._selectionAndFilterPanel.getTimeWindow();
            }
        }
    }

    protected void dataDropped(Object obj, DataReferenceSet drs) {
        if (debug) {
            System.out.println("Data dropped, object = " + obj);
        }
        if (obj instanceof Viewport) {
            obj = ((Viewport)obj).getG2dPanel();
        }
        if (obj instanceof HecDataTable) {
            Component parent = ((HecDataTable)obj).getParentFrame();
            if (parent instanceof HecDataTableFrame) {
                HecDataTableFrame tableFrame = (HecDataTableFrame)parent;
                Vector[] newData = this.readData(drs, false);
                if (tableFrame.getTableType().equals("timeseries")) {
                    if (newData[0].size() > 0) {
                        tableFrame.addDataToExistingTable(newData[0]);
                    }
                } else if (tableFrame.getTableType().equals("paired") && newData[1].size() > 0) {
                    tableFrame.addDataToExistingTable(newData[1]);
                }
            }
        } else if (obj instanceof G2dPanel) {
            Vector[] newData = this.readData(drs, false);
            G2dPanel g2dPanel = (G2dPanel)obj;
            Vector dataObjVec = g2dPanel.getPlotObjects();
            Vector colorvec = g2dPanel.getAllLinePropertyObjects();
            if (newData != null && newData.length > 0 && newData[0] != null && newData[0].size() > 0) {
                if (this._normalize) {
                    this.normalizeDisplay(newData[0]);
                }
                if (this._syncTimes) {
                    this.syncDisplayTimes(newData[0], true);
                }
                for (int i = 0; i < newData[0].size(); ++i) {
                    DataContainer dc = (DataContainer)newData[0].get(i);
                    G2dObject gobject = this.createPlotDataObject(dc);
                    if (gobject instanceof TimeSeriesDataSet) {
                        TimeSeriesDataSet tsds = (TimeSeriesDataSet)gobject;
                        if (tsds._timeSeries != null) {
                            int paramId = this.getParameterId(tsds._timeSeries.parameter, tsds._timeSeries.units);
                            tsds.setYParameterId(paramId);
                        }
                    }
                    if (gobject == null) continue;
                    dataObjVec.addElement(gobject);
                }
                g2dPanel.setVisible(false);
                g2dPanel.buildComponents((List)dataObjVec, (List)colorvec);
                g2dPanel.setVisible(true);
                g2dPanel.invalidate();
                g2dPanel.repaint();
            }
        } else if (obj instanceof PathnamePanel || obj instanceof PathnameTable) {
            DataReference dr = drs.elementAt(0);
            if (dr.getFilename().equalsIgnoreCase(this._dataManager.DSSFileName())) {
                return;
            }
            this.copyRecordsInto(drs, this._dataManager);
        } else if (obj instanceof SelectionAndFilterPanel) {
            int idx = this._selectionAndFilterPanel.getTabDroppedIndex();
            int idxSel = this._selectionAndFilterPanel.getSelectedIndex();
            if (idxSel == idx) {
                return;
            }
            DssDataManager dataManager = this._selectionAndFilterPanel.getDataManager(idx);
            this.copyRecordsInto(drs, dataManager);
        } else if (obj instanceof JList && obj == this._selectionAndFilterPanel._selectedListDisplay) {
            int idxSel = this._selectionAndFilterPanel.getSelectionList().getSelectedIndex();
            this._selectionAndFilterPanel.addToSelection(drs, idxSel);
        }
    }

    protected void fileName_actionPerformed(ActionEvent event) {
        String name = this.fileName.getText();
        if (name != null) {
            this.openDSSFile(name);
        }
    }

    protected void normalizePlotChange(ItemEvent event) {
        this._normalize = event.getStateChange() == 1;
        this.updateMessageField();
    }

    protected void syncTimesChange(ItemEvent event) {
        this._syncTimes = event.getStateChange() == 1;
        this.updateMessageField();
    }

    protected void dssFileClosed() {
        this._dataManager = this._selectionAndFilterPanel.getDataManager();
        if (this._dataManager != null && this._dataManager.isExplicitlyClosed()) {
            this.updateFileStats(null);
        } else {
            this.updateFileStats(this._dataManager);
        }
        this.updateMenuItems(false);
        this.fileName.setText("");
        this._dataManager = null;
    }

    protected void dssFileChanged() {
        this._dataManager = this._selectionAndFilterPanel.getDataManager();
        if (this._dataManager != null) {
            boolean byParts;
            String dataSource = this._dataManager.DSSFileName();
            HecDSSFileAccess.setDefaultDSSFileName((String)dataSource);
            this.fileName.setText(this._dataManager.DSSFileName());
            if (this._titleName.length() == 0) {
                this.setTitle(RMAIO.getFileFromPath((String)dataSource) + " - " + _programName);
            }
            this._remote = this._dataManager.isRemote();
            if (this._remote) {
                if (!this.isCwms(this._dataManager)) {
                    String directory = RMAIO.getDirectoryFromPath((String)dataSource);
                    this.setRemoteDirectory(directory);
                }
            } else {
                this._currentDirectory = RMAIO.getDirectoryFromPath((String)dataSource);
            }
            if ((byParts = this._selectionAndFilterPanel.getSearchMethod()) != _searchByParts) {
                this._selectionAndFilterPanel.setSearchByPartsMethod(_searchByParts);
            }
            if (this._dataManager.getCatalogNeedsUpdate()) {
                this.updateCatalog();
            }
            this.updateMenuItems(true);
        } else {
            this.updateMenuItems(false);
        }
        this.updateFileStats(this._dataManager);
        this.selectionUpdated();
        this.repaint();
        this._selectionAndFilterPanel.repaint();
        this.updateMessageField();
    }

    protected void selectionUpdated() {
        String numberCommas = NumberFormat.getIntegerInstance().format(this._selectionAndFilterPanel.getSelectedPathnamesSize());
        this.jLabelPathsSelected.setText("       " + this._pathnames + " Selected: " + numberCommas);
        numberCommas = NumberFormat.getIntegerInstance().format(this._selectionAndFilterPanel.getPathnamesDisplayedSize());
        this.jLabelPathsShown.setText(this._pathnames + " Shown:  " + numberCommas);
        this.updateSelectionIcons();
    }

    protected void updateMessageField() {
        String catalogFilter;
        LinkedTabbedPane tabbedPane;
        Component component;
        String twMess = this._selectionAndFilterPanel.getTimeWindowMessage();
        StringBuffer sb = new StringBuffer(twMess);
        if (this._normalize || this._syncTimes) {
            sb.append("   Display Options:");
            if (this._normalize) {
                sb.append("  Normalize");
                if (this._syncTimes) {
                    sb.append(";");
                } else {
                    sb.append(".");
                }
            }
            if (this._syncTimes) {
                sb.append("  Synchronize times.");
            }
        }
        if (this._timeZoneEnum != 0) {
            sb.append(";  Time zone: ");
            if (this._timeZoneEnum == 1) {
                sb.append("Local Time ");
            }
            sb.append(this._timeZoneId);
        }
        if (this._unitSystem != 3) {
            if (this._unitSystem == 1) {
                sb.append(";  Unit system: English");
            } else {
                sb.append(";  Unit system: SI");
            }
        }
        if ((component = (tabbedPane = this.getSelectionAndFilterPanel()._tabbedPane).getSelectedComponent()) instanceof PathnamePanel && (catalogFilter = ((PathnamePanel)component).getCatalogFilter()) != null && catalogFilter.length() > 0) {
            sb.append(";  Catalog filter: ").append(catalogFilter);
        }
        this.messageField.setText(sb.toString());
        this.messageField.validate();
        this.messageField.revalidate();
    }

    public void updateMessageField(String message) {
        this.messageField.setText(message);
        this.messageField.revalidate();
    }

    public void updateStatusField(String message) {
        this.updateMessageField(message);
    }

    protected void condensedCatalogCheckBox_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 2) {
            return;
        }
        if (this._viewState == 2) {
            return;
        }
        this._viewStatePrevious = this._viewState;
        this._viewState = 2;
        this.setViewCheckboxesSelection();
    }

    protected void condensedCatalogCollectionsCheckBox_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 2) {
            return;
        }
        if (this._viewState == 3) {
            return;
        }
        this._viewStatePrevious = this._viewState;
        this._viewState = 3;
        this.setViewCheckboxesSelection();
    }

    protected void pathnameListCheckBox_ItemStateChanged(ItemEvent event) {
        if (this._viewState == 0) {
            return;
        }
        if (event.getStateChange() == 2) {
            return;
        }
        this._viewStatePrevious = this._viewState;
        this._viewState = 0;
        this.setViewCheckboxesSelection();
    }

    protected void unsortedListCheckBox_ItemStateChanged(ItemEvent event) {
        if (this._viewState == 5) {
            return;
        }
        if (event.getStateChange() == 2) {
            return;
        }
        this._viewStatePrevious = this._viewState;
        this._viewState = 5;
        this.setViewCheckboxesSelection();
    }

    protected void pathnamePartsCheckBox_ItemStateChanged(ItemEvent event) {
        if (this._viewState == 1) {
            return;
        }
        if (event.getStateChange() == 2) {
            return;
        }
        this._viewStatePrevious = this._viewState;
        this._viewState = 1;
        this.setViewCheckboxesSelection();
    }

    protected void noPathnamesCheckBox_ItemStateChanged(ItemEvent event) {
        if (this._viewState == 4) {
            return;
        }
        if (event.getStateChange() == 2) {
            return;
        }
        this._viewStatePrevious = this._viewState;
        this._viewState = 4;
        this.setViewCheckboxesSelection();
    }

    protected void setViewCheckboxesSelection() {
        boolean newCatalog = false;
        if (this.pathnameListCheckBox.isSelected() && this._viewState != 0) {
            this.pathnameListCheckBox.setSelected(false);
        }
        if (this.pathnamePartsCheckBox.isSelected() && this._viewState != 1) {
            this.pathnamePartsCheckBox.setSelected(false);
        }
        if (this.condensedCatalogCheckBox.isSelected() && this._viewState != 2) {
            this.condensedCatalogCheckBox.setSelected(false);
        }
        if (this.condensedCatalogCollectionsCheckBox.isSelected() && this._viewState != 3) {
            this.condensedCatalogCollectionsCheckBox.setSelected(false);
        }
        if (this.noPathnamesCheckBox.isSelected() && this._viewState != 4) {
            this.noPathnamesCheckBox.setSelected(false);
            newCatalog = true;
        }
        if (this.unsortedListCheckBox.isSelected() && this._viewState != 5) {
            this.unsortedListCheckBox.setSelected(false);
        }
        if (this._viewState == 5) {
            if (_searchByParts) {
                this.pathnameStringSearch.setSelected(true);
                this.pathnamePartsSearch.setSelected(false);
                _searchByParts = false;
                this._selectionAndFilterPanel.setSearchByPartsMethod(_searchByParts);
            }
            this.pathnamePartsSearch.setEnabled(false);
        } else {
            this.pathnamePartsSearch.setEnabled(true);
        }
        this.newTableView(newCatalog, false, false);
    }

    protected void initializeViewCheckboxes() {
        if (this._viewState == 0) {
            this.pathnameListCheckBox.setSelected(true);
        } else if (this._viewState == 1) {
            this.pathnamePartsCheckBox.setSelected(true);
        } else if (this._viewState == 2) {
            this.condensedCatalogCheckBox.setSelected(true);
        } else if (this._viewState == 3) {
            this.condensedCatalogCollectionsCheckBox.setSelected(true);
        } else if (this._viewState == 4) {
            this.noPathnamesCheckBox.setSelected(true);
        } else if (this._viewState == 5) {
            this.unsortedListCheckBox.setSelected(true);
        }
    }

    protected void pathnamePartsSearch_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 2) {
            if (_searchByParts) {
                this.pathnamePartsSearch.setSelected(true);
            }
            return;
        }
        if (event.getStateChange() != 1) {
            return;
        }
        if (_searchByParts) {
            return;
        }
        _searchByParts = true;
        this.pathnameStringSearch.setSelected(false);
        this._selectionAndFilterPanel.setSearchByPartsMethod(_searchByParts);
        this.validate();
    }

    protected void pathnameStringSearch_ItemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 2) {
            if (!_searchByParts) {
                this.pathnameStringSearch.setSelected(true);
            }
            return;
        }
        if (event.getStateChange() != 1) {
            return;
        }
        if (!_searchByParts) {
            return;
        }
        _searchByParts = false;
        this.pathnamePartsSearch.setSelected(false);
        this._selectionAndFilterPanel.setSearchByPartsMethod(_searchByParts);
        this.validate();
        this.repaint();
    }

    public void exitProgram() {
        int number;
        try {
            this._scriptEditor.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._preferences.putInt("pathnameViewMethod", this._viewState);
        this._preferences.putInt("scriptEditor.tabsize", this._scriptEditorTabSize);
        this._preferences.putBoolean("pathnameSearchMethod", _searchByParts);
        this._preferences.putBoolean("useLineStyles", G2dDialog.getUseLineStyles());
        Point p = this.getLocation();
        this._preferences.putInt("mainWindow.position.x", p.x);
        this._preferences.putInt("mainWindow.position.y", p.y);
        Dimension d = this.getSize();
        this._preferences.putInt("mainWindow.size.width", d.width);
        this._preferences.putInt("mainWindow.size.height", d.height);
        int extendedState = this.getExtendedState();
        this._preferences.putInt("mainWindow.state", extendedState);
        int dividerLocation = this._selectionAndFilterPanel.getDividerLocation();
        if (dividerLocation > 0) {
            this._preferences.putInt("pathnameWindow.size", dividerLocation);
        }
        if (this._scriptEditorForegroundColor != null) {
            this._preferences.put("scriptEditor.foregroundColor", this._scriptEditorForegroundColor);
        }
        if (this._scriptEditorBackgroundColor != null) {
            this._preferences.put("scriptEditor.backgroundColor", this._scriptEditorBackgroundColor);
        }
        if (this._scriptEditorFont != null) {
            this._preferences.put("scriptEditor.font", this._scriptEditorFont);
        }
        if (this._scriptBrowserSize != null) {
            this._preferences.put("scriptBrowser.size", (int)this._scriptBrowserSize.getWidth() + "," + (int)this._scriptBrowserSize.getHeight());
        }
        if (this._scriptBrowserLocation != null) {
            this._preferences.put("scriptBrowser.location", (int)this._scriptBrowserLocation.getX() + "," + (int)this._scriptBrowserLocation.getY());
        }
        if ((number = this._pastFilesAccessed.size()) > 6) {
            number = 6;
        }
        for (int i = 0; i < number; ++i) {
            int position = this._pastFilesAccessed.size() - i - 1;
            String filename = (String)this._pastFilesAccessed.get(position);
            this._preferences.put("previousFile" + new Integer(i).toString(), filename);
        }
        if (this._exitOnClose && this._currentDirectory != null && this._currentDirectory.length() > 0) {
            this._preferences.put("directory", this._currentDirectory);
        }
        this.exitOut();
    }

    protected void exitOut() {
        if (this._dataManager != null && this._dataManager.fileOpened()) {
            this._dataManager.close();
        }
        if (this._secondDataManager != null && this._secondDataManager.fileOpened()) {
            this._secondDataManager.close();
        }
        this.setVisible(false);
        this.dispose();
        if (this._exitOnClose) {
            System.exit(0);
        }
    }

    protected void resetToDefaults() {
        if (this._options != null) {
            this._options.setVisible(false);
            this._options.dispose();
            this._options = null;
        }
        try {
            this._preferences.removeNode();
            this._preferences.flush();
            int opt = JOptionPane.showConfirmDialog(this, _programName + " reset to original defaults.\nYou must exit now to keep the defaults.\nExit now?", _programName, 0);
            if (opt == 0) {
                this.exitOut();
            }
            this.setupParameters();
            JOptionPane.showMessageDialog(this, "Non-exit;  some settings will remain.", _programName, 1);
        }
        catch (Exception e) {
            System.out.println("Unable to clear preferences: " + e.toString());
        }
    }

    protected void setup(boolean useTabbedPane) {
        String maxRecordStr;
        this._useCollection = System.getProperty("COLLECTION") != null;
        this._catalogWithWildCharsChoices.add(this._defaultWildChars);
        String debug = System.getProperty("debug", "false");
        if (!debug.equalsIgnoreCase("false")) {
            ListSelection.debug = true;
        }
        if ((maxRecordStr = System.getProperty("DSSVueMaxRecord")) != null) {
            try {
                this._maxRecord = Integer.parseInt(maxRecordStr);
            }
            catch (RuntimeException ex) {
                Logger.getLogger(ListSelection.class.getName()).log(Level.WARNING, "-Dmax_record {0} cannot be parsed as Integer", maxRecordStr);
                Logger.getLogger(ListSelection.class.getName()).log(Level.FINE, "caused by: ", ex);
            }
        }
        this.setupParameters();
        this._useTabbedPane = useTabbedPane;
        this.build();
        this.loadPlugins(this);
    }

    protected void setupParameters() {
        int size;
        StringTokenizer parser2;
        int viewState;
        StringBuffer version = new StringBuffer();
        version.append(_programName);
        version.append(":  Version ");
        version.append(_versionNumber);
        version.append(", ");
        version.append(_versionDate);
        String[] versionStamp = RMAIO.getVersionStamp();
        if (versionStamp[0] != null) {
            version.append("\n");
            version.append("Java Library build: ");
            version.append(versionStamp[0]);
        }
        if (versionStamp[1] != null) {
            version.append("   ");
            version.append("Java Build date:    ");
            version.append(versionStamp[1]);
        }
        String s = System.getProperty("os.arch");
        version.append("\n");
        if (s.indexOf("64") > 0) {
            version.append("64-bit Version");
        } else {
            version.append(s + " Version");
        }
        System.out.println(version);
        String osName = System.getProperty("os.name");
        this._isOsWindows = osName.toLowerCase().startsWith("windows");
        Image image = RmaImage.loadURLImage((Component)this, (String)ListSelection.getHighResIconImageURL());
        if (image != null) {
            this.setIconImage(image);
            if (RmaJFrame.getDefaultIconImage() == null) {
                RmaJFrame.setDefaultIconImage((Image)image);
            }
        }
        this._appDirectory = this._isOsWindows ? System.getProperty("user.home") + File.separator + "Application Data" + File.separator + "HEC" + File.separator + _programName + File.separator : System.getProperty("user.home") + File.separator + "HEC" + File.separator + _programName + File.separator;
        File appDir = new File(this._appDirectory);
        if (!appDir.exists()) {
            appDir.mkdirs();
        }
        this._preferences = Preferences.userNodeForPackage(this.getClass());
        if (debug) {
            System.out.println("==[Preferences Info]=======================");
            System.out.println("AbsPath  = " + this._preferences.absolutePath());
            System.out.println("Name     = " + this._preferences.name());
            System.out.println("Settings :");
            try {
                for (String key : this._preferences.keys()) {
                    System.out.println("  " + key + " = " + this._preferences.get(key, "<null>"));
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            System.out.println("===========================================");
        }
        if ((viewState = this._preferences.getInt("pathnameViewMethod", 2)) == 3) {
            viewState = 2;
        }
        this._viewStatePrevious = this._viewState = viewState;
        _searchByParts = this._preferences.getBoolean("pathnameSearchMethod", true);
        boolean lineStyle = this._preferences.getBoolean("useLineStyles", false);
        G2dDialog.setUseLineStyles((boolean)lineStyle);
        String temp = this._preferences.get("hecdss.set", "");
        if (temp.length() > 0) {
            HecDSSFileAccess.setDss((String)temp);
        }
        this.setScriptEditorForegroundColor(this._preferences.get("scriptEditor.foregroundColor", null));
        this.setScriptEditorBackgroundColor(this._preferences.get("scriptEditor.backgroundColor", null));
        this.setScriptEditorFont(this._preferences.get("scriptEditor.font", null));
        this.setScriptEditorTabSize(this._preferences.getInt("scriptEditor.tabsize", 8));
        try {
            temp = this._preferences.get("scriptBrowser.location", "");
            if (temp.length() > 0) {
                parser2 = new StringTokenizer(temp, ",");
                int x = Integer.parseInt(parser2.nextToken());
                int y = Integer.parseInt(parser2.nextToken());
                this.setScriptBrowserLocation(new Point(x, y));
            }
        }
        catch (Exception parser2) {
            // empty catch block
        }
        try {
            temp = this._preferences.get("scriptBrowser.size", "");
            if (temp.length() > 0) {
                parser2 = new StringTokenizer(temp, ",");
                int width = Integer.parseInt(parser2.nextToken());
                int height = Integer.parseInt(parser2.nextToken());
                this.setScriptBrowserSize(new Dimension(width, height));
            }
        }
        catch (Exception parser3) {
            // empty catch block
        }
        Vector<String> tempVector = new Vector<String>();
        for (int i = 0; i < 6; ++i) {
            String filename = this._preferences.get("previousFile" + new Integer(i).toString(), null);
            if (filename == null || filename.length() <= 0) continue;
            tempVector.addElement(filename);
        }
        for (int i = size = tempVector.size() - 1; i >= 0; --i) {
            this._pastFilesAccessed.addElement(tempVector.get(i));
        }
        String directory = this._preferences.get("directory", "");
        if (directory.length() > 0) {
            this._currentDirectory = directory;
        }
    }

    protected void build() {
        this.vueActionListener = new VueActionListener();
        this.addWindowListener(new VueWindowAdapter());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.buildToolBar();
        this.buildFilenamePanel();
        this.buildSelectionPanel();
        this.buildMenu();
        this.buildPopup();
        if (this.miScripts != null) {
            this.buildScriptButtons();
        }
        this._groupManager = new GroupManager(this, this._appDirectory);
        this.groupLoad();
        this._groupManager.addObserver(this);
        if (this._titleName.length() == 0) {
            if (Heclib.getLibraryMajorVersion() == 7) {
                this.setTitle(_programName + " " + _versionNumber + " " + _beta);
            } else {
                this.setTitle(_programName);
            }
        } else {
            this.setTitle(this._titleName);
        }
        this.updateMessageField();
        this.updateSelectionIcons();
        this.setCursorDefault();
    }

    protected void buildToolBar() {
        this.jPanelToolBar = new JPanel();
        this.jPanelToolBar.setLayout(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = this._insets0000;
        this.getContentPane().add((Component)this.jPanelToolBar, gbc);
        JSeparator sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = this._insets0000;
        this.getContentPane().add((Component)sep, gbc);
        this.jToolBar1 = new JToolBar();
        this.jPanelToolBar.add((Component)this.jToolBar1, "West");
        this.OpenOldTool = new FlatPanelButton();
        this.OpenOldTool.setMargin(new Insets(3, 4, 3, 4));
        this.OpenOldTool.setVerticalAlignment(1);
        this.OpenOldTool.setActionCommand("OpenFileDialog");
        this.OpenOldTool.setToolTipText("Open");
        this.OpenOldTool.setBounds(23, 2, 7, 7);
        this.jToolBar1.add((Component)this.OpenOldTool);
        this.OpenOldTool.setIcon((Icon)RmaImage.getImageIcon((String)"Images/Open.gif"));
        this.PlotTool = new FlatPanelButton();
        this.PlotTool.setMargin(new Insets(0, 0, 0, 0));
        this.PlotTool.setActionCommand("Plot");
        this.PlotTool.setToolTipText("Plot");
        this.PlotTool.setIcon((Icon)RmaImage.getImageIcon((String)"Images/plot.gif"));
        this.TabulateTool = new FlatPanelButton();
        this.TabulateTool.setMargin(new Insets(0, 0, 0, 0));
        this.TabulateTool.setActionCommand("Tabulate");
        this.TabulateTool.setToolTipText("Tabulate");
        this.TabulateTool.setBounds(93, 2, 7, 7);
        this.TabulateTool.setIcon((Icon)RmaImage.getImageIcon((String)"Images/T-TabulateEditor_25.png"));
        this.GraphicalEditTool = new FlatPanelButton((Action)new GraphicalEditorAction(this));
        this.GraphicalEditTool.setMargin(new Insets(0, 0, 0, 0));
        this.GraphicalEditTool.setToolTipText(GraphicalEditorAction.getToolTipText());
        this.GraphicalEditTool.setBounds(121, 2, 7, 7);
        this.ValidationEditTool = new FlatPanelButton((Action)new ValidationEditorAction(this));
        this.ValidationEditTool.setMargin(new Insets(0, 0, 0, 0));
        this.ValidationEditTool.setToolTipText(ValidationEditorAction.getToolTipText());
        this.ValidationEditTool.setBounds(121, 2, 7, 7);
        this.MathFunctionTool = new FlatPanelButton();
        this.MathFunctionTool.setMargin(new Insets(0, 0, 0, 0));
        this.MathFunctionTool.setActionCommand("Math Functions");
        this.MathFunctionTool.setToolTipText("Math Functions");
        this.MathFunctionTool.setBounds(135, 2, 7, 7);
        this.MathFunctionTool.setIcon((Icon)RmaImage.getImageIcon((String)"Images/mathfunction.gif"));
        this.jToolBar1.add((Component)this.PlotTool);
        this.jToolBar1.add((Component)this.TabulateTool);
        if (this._mode == 2) {
            this.jToolBar1.add((Component)this.GraphicalEditTool);
            this.jToolBar1.add((Component)this.ValidationEditTool);
            this.jToolBar1.add((Component)this.MathFunctionTool);
        }
        this._scriptButtonToolbarPanel = new JPanel();
        this._scriptButtonPanel = new ScriptButtonPanel(this._scriptButtonToolbarPanel);
        this.jToolBar1.add(this._scriptButtonPanel);
        this.OpenOldTool.addActionListener((ActionListener)this.vueActionListener);
        this.PlotTool.addActionListener((ActionListener)this.vueActionListener);
        this.TabulateTool.addActionListener((ActionListener)this.vueActionListener);
        this.MathFunctionTool.addActionListener((ActionListener)this.vueActionListener);
    }

    protected void buildFilenamePanel() {
        String s;
        this.jPanelFileName = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.jPanelFileName.setLayout(gridBagLayout);
        this.jPanelFileName.setBounds(0, 16, 734, 43);
        this.jPanelFileName.setForeground(new Color(0, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 4, 2, 4);
        this.getContentPane().add((Component)this.jPanelFileName, gbc);
        JLabel fileNameLabel = new JLabel("File Name:");
        Font labelFont = fileNameLabel.getFont();
        Font boldFont = new Font(labelFont.getName(), 1, labelFont.getSize());
        fileNameLabel.setDisplayedMnemonic('N');
        fileNameLabel.setHorizontalTextPosition(2);
        fileNameLabel.setFont(boldFont);
        fileNameLabel.setForeground(new Color(0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.jPanelFileName.add((Component)fileNameLabel, gbc);
        this.fileName = new RmaJTextField();
        fileNameLabel.setLabelFor((Component)this.fileName);
        this.fileName.setMargin(new Insets(0, 2, 0, 0));
        this.fileName.setToolTipText("HEC-DSS filename");
        this.fileName.setDragEnabled(true);
        this.fileName.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.gridheight = -1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 0, 20);
        this.jPanelFileName.add((Component)this.fileName, gbc);
        this.fileName.addActionListener((ActionListener)this.vueActionListener);
        JPanel jPanelFileInfo = new JPanel();
        jPanelFileInfo.setLayout(new FlowLayout(0, 5, 2));
        jPanelFileInfo.setForeground(new Color(0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.gridheight = -1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = this._insets0000;
        this.jPanelFileName.add((Component)jPanelFileInfo, gbc);
        this.jLabelPathsShown = new JLabel(this._pathnames + " Shown:  0");
        this.jLabelPathsShown.setToolTipText("Number of pathnames shown in the catalog list");
        labelFont = this.jLabelPathsShown.getFont();
        Font smallFont = new Font(labelFont.getName(), 0, labelFont.getSize() - 1);
        this.jLabelPathsShown.setFont(smallFont);
        this.jLabelPathsShown.setForeground(new Color(0, 0, 0));
        jPanelFileInfo.add(this.jLabelPathsShown);
        this.jLabelPathsSelected = new JLabel("       " + this._pathnames + " Selected:  0");
        this.jLabelPathsSelected.setAlignmentX(1.0f);
        this.jLabelPathsSelected.setToolTipText("Number of pathnames in Selection List");
        this.jLabelPathsSelected.setHorizontalTextPosition(2);
        this.jLabelPathsSelected.setBounds(304, 5, 131, 14);
        this.jLabelPathsSelected.setFont(smallFont);
        this.jLabelPathsSelected.setForeground(new Color(0, 0, 0));
        jPanelFileInfo.add(this.jLabelPathsSelected);
        this.jLabelPathsFile = new JLabel("       " + this._pathnames + " in File:  0");
        this.jLabelPathsFile.setAlignmentX(1.0f);
        this.jLabelPathsFile.setToolTipText("Total number of pathnames in the DSS file");
        this.jLabelPathsFile.setHorizontalTextPosition(2);
        this.jLabelPathsFile.setFont(smallFont);
        this.jLabelPathsFile.setForeground(new Color(0, 0, 0));
        jPanelFileInfo.add(this.jLabelPathsFile);
        this.jLabelFileSize = new JLabel("       File Size:  0.0  KB");
        this.jLabelFileSize.setHorizontalTextPosition(2);
        this.jLabelFileSize.setFont(smallFont);
        this.jLabelFileSize.setForeground(new Color(0, 0, 0));
        jPanelFileInfo.add(this.jLabelFileSize);
        this.jLabelFileReadOnly = new JLabel(" ");
        this.jLabelFileReadOnly.setHorizontalTextPosition(2);
        this.jLabelFileReadOnly.setFont(smallFont);
        this.jLabelFileReadOnly.setForeground(new Color(0, 0, 0));
        jPanelFileInfo.add(this.jLabelFileReadOnly);
        this.jLabelFileVersion = new JLabel(" ");
        this.jLabelFileVersion.setHorizontalTextPosition(2);
        this.jLabelFileVersion.setFont(smallFont);
        this.jLabelFileVersion.setForeground(new Color(0, 0, 0));
        jPanelFileInfo.add(this.jLabelFileVersion);
        stringContainer alpha = new stringContainer();
        int[] numb = new int[1];
        Heclib.zquery((String)"VERS", (stringContainer)alpha, (int[])numb);
        this.jLabelLibraryVersion = new JLabel("  Library Version: " + alpha.string);
        this.jLabelLibraryVersion.setHorizontalTextPosition(2);
        this.jLabelLibraryVersion.setFont(smallFont);
        this.jLabelLibraryVersion.setForeground(new Color(0, 0, 0));
        jPanelFileInfo.add(this.jLabelLibraryVersion);
        if (numb[0] == 7 && this.jLabelLibraryDate != null) {
            Heclib.zquery((String)"date", (stringContainer)alpha, (int[])numb);
            if (alpha.string.trim().length() > 5) {
                this.jLabelLibraryDate.setText("    Library Date: " + alpha.string.trim());
            }
        }
        if ((s = System.getProperty("os.arch")).indexOf("64") > 0) {
            JLabel label = new JLabel("  x64");
            label.setHorizontalTextPosition(2);
            label.setFont(smallFont);
            label.setForeground(new Color(0, 0, 0));
            jPanelFileInfo.add(label);
        }
    }

    protected void buildSelectionPanel() {
        String filename = null;
        if (this._dataManager != null) {
            filename = this._dataManager.DSSFileName();
        }
        Preferences preferences = this._preferences;
        if (!_standAlone) {
            preferences = this._preferences.node(EMBEDDED);
        }
        this._selectionAndFilterPanel = new SelectionAndFilterPanel(this._viewState, _searchByParts, this._useTabbedPane, filename, preferences);
        this._selectionAndFilterPanel.addObserver(this);
        this._transferHandler = new DssVueTransferHandler(this);
        this._selectionAndFilterPanel.setTransferHandler(this._transferHandler);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = new Insets(8, 4, 2, 4);
        this.getContentPane().add((Component)this._selectionAndFilterPanel, gbc);
        this._selectionAndFilterPanel.setMode(this._mode);
        this._statusPanel = new JPanel();
        this._statusPanel.setBorder(new EtchedBorder());
        this._statusPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this._statusPanel, gbc);
        ImageIcon image = RmaImage.getImageIcon((String)ListSelection.getIconImageURL());
        this._statusIcon = new AnimatedStatusIconPanel(1, image);
        this._statusIcon.setColor(Color.BLUE);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(1, 4, 1, 0);
        this._statusPanel.add((Component)this._statusIcon, gbc);
        this.messageField = new JLabel();
        this.messageField.setForeground(new Color(0, 0, 0));
        this.messageField.setToolTipText("Message panel");
        this.messageField.setText(" ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 4, 1, 0);
        this._statusPanel.add((Component)this.messageField, gbc);
    }

    protected void buildMenu() {
        int timeZoneEnum;
        this.mainMenuBar = _standAlone ? new JMenuBar() : new MenuBarTimeZone();
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        this.miNew = new JMenuItem("New...");
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        this.miNew.setMnemonic('N');
        this.miNew.setEnabled(true);
        this.miNew.setToolTipText("Create a new version 7 file");
        this.miNewRemote = new JMenuItem("New Remote...");
        this.miNewRemote.setToolTipText("Create a remote version 7 file");
        if (this._allowRemote) {
            this.miOpenLocal = new JMenuItem("Open Local DSS File...");
            this.miSaveAsLocal = new JMenuItem(new SaveAsAction("Save As Local DSS File...", this, false));
            this.miSaveAsRemote = new JMenuItem(new SaveAsAction("Save As Remote DSS File...", this, true));
        } else {
            this.miOpenLocal = new JMenuItem("Open...");
            this.miSaveAsLocal = new JMenuItem(new SaveAsAction("Save As...", this, false));
        }
        this.miOpenLocal.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.miOpenLocal.setMnemonic('O');
        this.miOpenRemote = new JMenuItem("Open Remote DSS File...");
        this.miClose = new JMenuItem("Close DSS File(s)");
        this.miPrintPreview = new JMenuItem("Print Catalog Preview...", 114);
        this.miPrint = new JMenuItem("Print Catalog...");
        this.miPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        this.miPrint.setMnemonic('P');
        this.miExit = this._exitOnClose ? new JMenuItem("Exit") : new JMenuItem("Close");
        this.miExit.setMnemonic('x');
        this.miExit.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        this.updateFileMenu();
        this.mainMenuBar.add(this.fileMenu);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic('E');
        this.miEditData = new JMenuItem("Tabular Edit...", 84);
        this.miEditData.setIcon(RmaImage.getImageIcon((String)"Images/T-TabulateEditor_16.png"));
        this.miEditData.setAccelerator(KeyStroke.getKeyStroke(69, 2, false));
        this.miEditData.setEnabled(false);
        this.miGraphicalEdit = new JMenuItem(new GraphicalEditorAction(this));
        this.miGraphicalEdit.setText(GraphicalEditorAction.getName());
        this.miGraphicalEdit.setMnemonic('G');
        this.miGraphicalEdit.setAccelerator(KeyStroke.getKeyStroke(71, 2, false));
        this.miGraphicalEdit.setEnabled(false);
        this.miValidationEdit = new JMenuItem(new ValidationEditorAction(this));
        this.miValidationEdit.setText(ValidationEditorAction.getName());
        this.miValidationEdit.setMnemonic('Q');
        this.miValidationEdit.setText("Validation Edit...");
        this.miValidationEdit.setAccelerator(KeyStroke.getKeyStroke(81, 2, false));
        this.miValidationEdit.setEnabled(false);
        if (this._mode == 2) {
            this.editMenu.add(this.miEditData);
            this.editMenu.add(this.miGraphicalEdit);
            this.editMenu.add(this.miValidationEdit);
            this.editMenu.addSeparator();
        }
        this.miSelectAll = new JMenuItem("Select All");
        this.miSelectAll.setMnemonic('S');
        this.miSelectAll.setEnabled(false);
        this.editMenu.add(this.miSelectAll);
        this.editMenu.addSeparator();
        this.miRenameRecords = new JMenuItem("Rename Records", 82);
        this.miRenameRecords.setAccelerator(KeyStroke.getKeyStroke(82, 9, false));
        this.miRenameRecords.setEnabled(false);
        this.editMenu.add(this.miRenameRecords);
        this.miDelete = new JMenuItem("Delete Records");
        this.miDelete.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        this.miDelete.setMnemonic('D');
        this.miDelete.setEnabled(false);
        if (this._mode == 2) {
            this.editMenu.add(this.miDelete);
        }
        this.miUndelete = new JMenu("Undelete");
        this.miUndelete.setMnemonic('U');
        this.miUndelete.setEnabled(false);
        this.miUndeleteAll = new JMenuItem("All", 65);
        this.miUndelete.add(this.miUndeleteAll);
        this.miUndeleteSelected = new JMenuItem("Select...", 83);
        this.miUndelete.add(this.miUndeleteSelected);
        this.miUndo = new JMenuItem("Last Deleted", 76);
        this.miUndo.setEnabled(false);
        this.miUndelete.add(this.miUndo);
        if (this._mode == 2) {
            this.editMenu.add(this.miUndelete);
        }
        this.miDuplicateRecords = new JMenuItem("Duplicate", 117);
        this.miDuplicateRecords.setAccelerator(KeyStroke.getKeyStroke(85, 9, false));
        this.miDuplicateRecords.setEnabled(false);
        this.editMenu.add(this.miDuplicateRecords);
        this.miCopyRecords = new JMenuItem("Copy To", 67);
        this.miCopyRecords.setEnabled(false);
        this.miCopyLocalRecords = new JMenuItem("Copy To Local DSS File...");
        this.miCopyLocalRecords.setEnabled(false);
        this.miCopyRemoteRecords = new JMenuItem("Copy To Remote DSS File...");
        this.miCopyRemoteRecords.setEnabled(false);
        if (!this._remote) {
            this.editMenu.add(this.miCopyRecords);
        } else {
            this.editMenu.add(this.miCopyLocalRecords);
            this.editMenu.add(this.miCopyRemoteRecords);
        }
        this.miCopyRecordsTo = new JMenuItem("Copy To ...");
        this.miCopyRecordsTo.setMnemonic('o');
        this.miCopyRecordsTo.setEnabled(false);
        this.miCopyRecordsTo.setVisible(false);
        this.editMenu.add(this.miCopyRecordsTo);
        this.miMergeFiles = new JMenuItem("Merge records into...", 77);
        this.miMergeFiles.setEnabled(false);
        this.miMergeLocalFiles = new JMenuItem("Merge records into local...", 77);
        this.miMergeLocalFiles.setEnabled(false);
        this.miMergeRemoteFiles = new JMenuItem("Merge records into remote...", 77);
        this.miMergeRemoteFiles.setEnabled(false);
        if (!this._remote) {
            this.editMenu.add(this.miMergeFiles);
        } else {
            this.editMenu.add(this.miMergeLocalFiles);
            this.editMenu.add(this.miMergeRemoteFiles);
        }
        this.mainMenuBar.add(this.editMenu);
        ButtonGroup btnGroup = new ButtonGroup();
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('V');
        this.pathnameListCheckBox = new JCheckBoxMenuItem("Pathname List");
        btnGroup.add(this.pathnameListCheckBox);
        this.pathnameListCheckBox.setMnemonic('L');
        this.viewMenu.add(this.pathnameListCheckBox);
        this.pathnamePartsCheckBox = new JCheckBoxMenuItem("Pathname Parts");
        this.pathnamePartsCheckBox.setMnemonic('P');
        this.viewMenu.add(this.pathnamePartsCheckBox);
        btnGroup.add(this.pathnamePartsCheckBox);
        this.condensedCatalogCheckBox = new JCheckBoxMenuItem("Condensed Catalog");
        this.condensedCatalogCheckBox.setMnemonic('C');
        this.viewMenu.add(this.condensedCatalogCheckBox);
        btnGroup.add(this.condensedCatalogCheckBox);
        this.condensedCatalogCollectionsCheckBox = new JCheckBoxMenuItem("Condensed - Group Collections");
        this.condensedCatalogCollectionsCheckBox.setMnemonic('G');
        this.viewMenu.add(this.condensedCatalogCollectionsCheckBox);
        this.condensedCatalogCollectionsCheckBox.setVisible(false);
        btnGroup.add(this.condensedCatalogCollectionsCheckBox);
        this.noPathnamesCheckBox = new JCheckBoxMenuItem("No Pathnames");
        this.noPathnamesCheckBox.setMnemonic('N');
        this.viewMenu.add(this.noPathnamesCheckBox);
        btnGroup.add(this.noPathnamesCheckBox);
        this.unsortedListCheckBox = new JCheckBoxMenuItem("Unsorted List");
        this.unsortedListCheckBox.setMnemonic('U');
        this.viewMenu.add(this.unsortedListCheckBox);
        btnGroup.add(this.unsortedListCheckBox);
        this.viewMenu.addSeparator();
        this.pathnameStringSearch = new JCheckBoxMenuItem("Search pathnames by string");
        this.pathnameStringSearch.setMnemonic('e');
        this.viewMenu.add(this.pathnameStringSearch);
        this.pathnamePartsSearch = new JCheckBoxMenuItem("Search pathnames by parts");
        this.pathnamePartsSearch.setMnemonic('a');
        if (_searchByParts) {
            this.pathnameStringSearch.setSelected(false);
            this.pathnamePartsSearch.setSelected(true);
        } else {
            this.pathnameStringSearch.setSelected(true);
            this.pathnamePartsSearch.setSelected(false);
        }
        this.viewMenu.add(this.pathnamePartsSearch);
        this.initializeViewCheckboxes();
        this.viewMenu.addSeparator();
        this.wildCharsSearch = new JCheckBoxMenuItem("Catalog using wild characters");
        this.wildCharsSearch.setEnabled(true);
        this.viewMenu.add(this.wildCharsSearch);
        this.viewMenu.addSeparator();
        this.miRefreshCatalog = new JMenuItem("Refresh Catalog");
        this.miRefreshCatalog.setMnemonic('R');
        this.miRefreshCatalog.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.miRefreshCatalog.setEnabled(false);
        this.viewMenu.add(this.miRefreshCatalog);
        this.viewMenu.addSeparator();
        this.menuUnitSystem = new JMenu("Unit System");
        this.menuUnitSystem.setMnemonic('U');
        this._asStoredUnitItem = new JCheckBoxMenuItem(AS_STORED_STR);
        this._asStoredUnitItem.setMnemonic('A');
        this.menuUnitSystem.add(this._asStoredUnitItem);
        this._englishUnitItem = new JCheckBoxMenuItem("English");
        this._englishUnitItem.setMnemonic(71);
        this.menuUnitSystem.add(this._englishUnitItem);
        this._SIUnitItem = new JCheckBoxMenuItem("SI");
        this._SIUnitItem.setMnemonic(83);
        this.menuUnitSystem.add(this._SIUnitItem);
        this.viewMenu.add(this.menuUnitSystem);
        this._asStoredUnitItem.addActionListener(e -> this.menuUnitsSelected(e));
        this._englishUnitItem.addActionListener(e -> this.menuUnitsSelected(e));
        this._SIUnitItem.addActionListener(e -> this.menuUnitsSelected(e));
        TimeZone tz = TimeZone.getDefault();
        this.menuTimeZone = new JMenu("Time Zone");
        this.menuTimeZone.setMnemonic('N');
        this.asStoredTimeZoneItem = new JCheckBoxMenuItem(AS_STORED_STR);
        this.asStoredTimeZoneItem.setMnemonic('A');
        this.menuTimeZone.add(this.asStoredTimeZoneItem);
        this.localTimeZoneItem = new JCheckBoxMenuItem("Local (" + tz.getID() + ")");
        this.localTimeZoneItem.setMnemonic('O');
        this.menuTimeZone.add(this.localTimeZoneItem);
        this.watershedTimeZoneItem = new JCheckBoxMenuItem(WATERSHED_TIME_ZONE_STR);
        this.gmtTimeZoneItem = new JCheckBoxMenuItem("UTC (GMT)");
        this.menuTimeZone.add(this.gmtTimeZoneItem);
        this.selectTimeZoneItem = new JCheckBoxMenuItem(CUSTOM_TIME_ZONE_STR);
        this.selectTimeZoneItem.setMnemonic('C');
        this.menuTimeZone.add(this.selectTimeZoneItem);
        if (ClientAppCheck.haveClientApp()) {
            TimeZone appTZ = ServiceLookup.getTimeZoneDisplayService().getTimeZone();
            if (appTZ == null) {
                this._timeZoneId = AS_STORED_STR;
            } else {
                this._timeZoneId = appTZ.getID();
                this._timeZone = appTZ;
            }
        } else {
            this._timeZoneId = this._preferences.get(this.getTimeZonePref(), AS_STORED_STR);
        }
        if (!_standAlone) {
            this.menuTimeZone.setEnabled(false);
            TimeZoneDisplayService timeZoneDisplayService = ServiceLookup.getTimeZoneDisplayService();
            if (null != timeZoneDisplayService) {
                this._timeZone = timeZoneDisplayService.getTimeZone();
                this._timeZoneId = this._timeZone.getID();
                timeZoneDisplayService.addContainer((Container)this);
            }
            this.menuUnitSystem.setEnabled(false);
            UnitsDisplayService unitsDisplayService = ServiceLookup.getUnitsDisplayService();
            if (null != unitsDisplayService) {
                this._unitSystem = unitsDisplayService.getDisplayUnitsSystem();
                unitsDisplayService.addContainer((Container)this);
            }
        }
        if (this._timeZoneId.equals(AS_STORED_STR)) {
            timeZoneEnum = 0;
            this.asStoredTimeZoneItem.setSelected(true);
        } else if (this._timeZoneId.equals(LOCAL_TIME_ZONE_STR)) {
            timeZoneEnum = 1;
            this.localTimeZoneItem.setSelected(true);
        } else if (this._timeZoneId.equals(UTC_TIME_ZONE_STR)) {
            timeZoneEnum = 4;
            this.gmtTimeZoneItem.setSelected(true);
        } else if (this._timeZoneId.equals(WATERSHED_TIME_ZONE_STR)) {
            timeZoneEnum = 2;
            this.watershedTimeZoneItem.setSelected(true);
        } else {
            timeZoneEnum = 3;
            this.selectTimeZoneItem.setSelected(true);
        }
        this.setTimeZone(timeZoneEnum);
        ButtonGroup timeZoneGroup = new ButtonGroup();
        timeZoneGroup.add(this.asStoredTimeZoneItem);
        timeZoneGroup.add(this.localTimeZoneItem);
        timeZoneGroup.add(this.watershedTimeZoneItem);
        timeZoneGroup.add(this.gmtTimeZoneItem);
        timeZoneGroup.add(this.selectTimeZoneItem);
        this.viewMenu.add(this.menuTimeZone);
        this.asStoredTimeZoneItem.addActionListener(e -> this.menuTimeZoneSelected(e));
        this.localTimeZoneItem.addActionListener(e -> this.menuTimeZoneSelected(e));
        this.watershedTimeZoneItem.addActionListener(e -> this.menuTimeZoneSelected(e));
        this.gmtTimeZoneItem.addActionListener(e -> this.menuTimeZoneSelected(e));
        this.selectTimeZoneItem.addActionListener(e -> this.menuTimeZoneSelected(e));
        this._unitSystem = this._preferences.getInt("unitSystem", 3);
        if (this._dataManager != null) {
            this._dataManager.setDisplayUnitSystem(this._unitSystem);
        }
        if (this._unitSystem == 1) {
            this._englishUnitItem.setSelected(true);
        } else if (this._unitSystem == 2) {
            this._SIUnitItem.setSelected(true);
        } else {
            this._asStoredUnitItem.setSelected(true);
        }
        this.mainMenuBar.add(this.viewMenu);
        this.displayMenu = new JMenu("Display");
        this.displayMenu.setMnemonic('D');
        this.miPlot = new JMenuItem("Plot");
        this.miPlot.setAccelerator(KeyStroke.getKeyStroke(76, 2, false));
        this.miPlot.setMnemonic('P');
        this.displayMenu.add(this.miPlot);
        this.miWaterQualityPlot = new JMenuItem("Plot Water Quality Profile");
        this.miWaterQualityPlot.setActionCommand("PlotWaterQualityProfile");
        this.miWaterQualityPlot.setToolTipText("Plot Water Quality Profile");
        this.displayMenu.add(this.miWaterQualityPlot);
        this.miPlotIndividualSets = new JMenuItem("Plot Individual Data Sets");
        this.miPlotIndividualSets.setMnemonic('S');
        this.displayMenu.add(this.miPlotIndividualSets);
        this.miTabulate = new JMenuItem("Tabulate");
        this.miTabulate.setAccelerator(KeyStroke.getKeyStroke(84, 2, false));
        this.miTabulate.setMnemonic('T');
        this.displayMenu.add(this.miTabulate);
        this.miPlotOptions = new JMenu("Display Data Options");
        this.miPlotOptions.setMnemonic('D');
        this.displayMenu.add(this.miPlotOptions);
        this.miNormalize = new JCheckBoxMenuItem("Normalize");
        this.miNormalize.setMnemonic('N');
        this.miNormalize.setSelected(false);
        this.miPlotOptions.add(this.miNormalize);
        this.miSyncTimes = new JCheckBoxMenuItem("Sync data set times to first");
        this.miSyncTimes.setMnemonic('S');
        this.miSyncTimes.setSelected(false);
        this.miPlotOptions.add(this.miSyncTimes);
        this.displayMenu.addSeparator();
        this.miSupplementalInfo = new JMenuItem("Supplemental Information", 73);
        this.displayMenu.add(this.miSupplementalInfo);
        this.miTimeWindow = new JMenuItem("Time Window...");
        this.miTimeWindow.setMnemonic('W');
        this.displayMenu.add(this.miTimeWindow);
        this.miShow = new JMenuItem("Slide Show", 83);
        this.displayMenu.add(this.miShow);
        this.miRun = new JMenuItem("Run data set(s)", 82);
        this.displayMenu.add(this.miRun);
        this.mainMenuBar.add(this.displayMenu);
        this.groupMenu = new JMenu("Groups");
        this.groupMenu.setMnemonic('G');
        this.mainMenuBar.add(this.groupMenu);
        this.miGroupAdd = new JMenuItem("Save Selected...", 83);
        this.groupMenu.add(this.miGroupAdd);
        this.miGroupGet_Clear = new JMenu("Get");
        this.miGroupGet_Clear.setMnemonic('G');
        this.groupMenu.add(this.miGroupGet_Clear);
        this.miGroupGet_Add = new JMenu("Get (add to list)");
        this.miGroupGet_Add.setMnemonic('A');
        this.groupMenu.add(this.miGroupGet_Add);
        this.miGroupPlot = new JMenu("Plot");
        this.miGroupPlot.setMnemonic('P');
        this.groupMenu.add(this.miGroupPlot);
        this.miGroupIndividualPlot = new JMenu("Plot Individual Sets");
        this.miGroupIndividualPlot.setMnemonic('I');
        this.groupMenu.add(this.miGroupIndividualPlot);
        this.miGroupTabulate = new JMenu("Tabulate");
        this.miGroupTabulate.setMnemonic('T');
        this.groupMenu.add(this.miGroupTabulate);
        this.miGroupMath = new JMenu("Math");
        this.miGroupMath.setMnemonic('M');
        this.groupMenu.add(this.miGroupMath);
        this.miGroupManage = new JMenuItem("Manage...", 97);
        this.groupMenu.add(this.miGroupManage);
        this.dataEntryMenu = new JMenu("Data");
        this.dataEntryMenu.setMnemonic('a');
        if (this._mode == 2) {
            this.mainMenuBar.add(this.dataEntryMenu);
        }
        this.miTSDataEntry = new JMenuItem("Manual Time Series...", 84);
        this.miTSDataEntry.setEnabled(false);
        this.dataEntryMenu.add(this.miTSDataEntry);
        this.miPDDataEntry = new JMenuItem("Manual Paired Data...", 80);
        this.miPDDataEntry.setEnabled(false);
        this.dataEntryMenu.add(this.miPDDataEntry);
        this.miTextEntry = new JMenuItem("Manual Text...", 77);
        this.miTextEntry.setEnabled(false);
        this.dataEntryMenu.add(this.miTextEntry);
        this.dataEntryMenu.addSeparator();
        this.miImport = new JMenu("Import");
        this.miImport.setMnemonic('I');
        this.miImport.setEnabled(false);
        this.miImportShef = new JMenuItem("SHEF...", 83);
        if (!this._remote) {
            this.miImport.add(this.miImportShef);
        }
        this.miImport.addSeparator();
        this.miImportText = new JMenuItem("Text from File...", 84);
        this.miImport.add(this.miImportText);
        this.miImportImages = new JMenuItem("Images...", 73);
        this.miImport.add(this.miImportImages);
        this.miImportFiles = new JMenuItem("Files (Generic type)...", 70);
        this.miImport.add(this.miImportFiles);
        this.dataEntryMenu.add(this.miImport);
        this.miExport = new JMenu("Export");
        this.miExport.setMnemonic('x');
        this.miExport.setEnabled(false);
        this.miExportToFile = new JMenuItem("Export To File(s)", 69);
        this.miExport.add(this.miExportToFile);
        this.miExportShef = new JMenuItem("SHEF...", 83);
        this.miExport.add(this.miExportShef);
        this.dataEntryMenu.add(this.miExport);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic('T');
        this.miMath = new JMenuItem("Math Functions...");
        this.miMath.setAccelerator(KeyStroke.getKeyStroke(77, 2, false));
        this.miMath.setMnemonic('F');
        this.miMath.setEnabled(false);
        this.toolsMenu.add(this.miMath);
        this.toolsMenu.addSeparator();
        this.miCompare = new JMenu("Compare");
        this.miCompare.setMnemonic('C');
        this.miCompare.setEnabled(false);
        this.miCompareFiles = new JMenuItem("Files", 70);
        this.miCompareFiles.setEnabled(true);
        this.miCompareFilesOptions = new JMenuItem("Files with Options");
        this.miCompareFilesOptions.setEnabled(true);
        this.miCompareDataSets = new JMenuItem("Data Sets", 68);
        this.miCompareDataSets.setEnabled(false);
        this.miCompareDataSetsOptions = new JMenuItem("Data Sets with Options", 79);
        this.miCompareDataSetsOptions.setEnabled(false);
        this.miCompare.add(this.miCompareFiles);
        this.miCompare.add(this.miCompareFilesOptions);
        this.miCompare.add(this.miCompareDataSets);
        this.miCompare.add(this.miCompareDataSetsOptions);
        this.toolsMenu.add(this.miCompare);
        this.miSearch = new JMenuItem("Search for Value", 83);
        this.miSearch.setEnabled(false);
        this.toolsMenu.add(this.miSearch);
        this.toolsMenu.addSeparator();
        this.miCheckIntegrity = new JMenuItem("Check File Integrity");
        this.miCheckIntegrity.setMnemonic('i');
        this.miCheckIntegrity.setEnabled(false);
        this.toolsMenu.add(this.miCheckIntegrity);
        this.miSqueezeFile = new JMenuItem("Squeeze");
        this.miSqueezeFile.setMnemonic('q');
        this.miSqueezeFile.setEnabled(true);
        this.toolsMenu.add(this.miSqueezeFile);
        this.miConvertFile = new JMenuItem("");
        this.miConvertFile.setMnemonic('c');
        this.miConvertFile.setEnabled(false);
        this.miConvertFile.setVisible(false);
        this.toolsMenu.add(this.miConvertFile);
        if (!ClientAppCheck.haveClientApp()) {
            this.toolsMenu.addSeparator();
            this.miScripts = new JMenuItem("Script Editor");
            this.miScripts.setMnemonic('E');
            this.toolsMenu.add(this.miScripts);
            this.miScriptButtons = new JMenu("Script Selector");
            this.miScriptButtons.setMnemonic('S');
            this.toolsMenu.add(this.miScriptButtons);
        }
        if (this._mode == 2) {
            this.mainMenuBar.add(this.toolsMenu);
        }
        this.customMenu = new JMenu();
        this.customMenu.setVisible(false);
        this.mainMenuBar.add(this.customMenu);
        this.scriptMenu = new JMenu("Scripts");
        this.scriptMenu.setVisible(false);
        this.mainMenuBar.add(this.scriptMenu);
        this.advancedMenu = new JMenu("Advanced");
        this.advancedMenu.setMnemonic('n');
        this.mainMenuBar.add(this.advancedMenu);
        this.catalogFileMenu = new JMenu("Catalog to File");
        this.catalogFileMenu.setMnemonic('C');
        this.advancedMenu.add(this.catalogFileMenu);
        this.catalogFileMenu.setEnabled(false);
        this.unsortSelectiveCatFileMenu = new JMenuItem("Unsorted using wild chars");
        this.catalogFileMenu.add(this.unsortSelectiveCatFileMenu);
        this.selectiveCatFileMenu = new JMenuItem("Sorted using wild chars");
        this.catalogFileMenu.add(this.selectiveCatFileMenu);
        this.sortedCatalogMenu = new JMenuItem("Sorted full");
        this.catalogFileMenu.add(this.sortedCatalogMenu);
        this.advancedMenu.addSeparator();
        this.miOutput = new JMenu("Output");
        this.miOutput.setMnemonic('O');
        this.advancedMenu.add(this.miOutput);
        if (_standAlone) {
            this.miConsole = new JMenuItem("Console", 67);
            this.miConsole.setVisible(false);
            this.miOutput.add(this.miConsole);
        }
        this.miViewDssLog = new JMenuItem("HEC-DSS", 72);
        this.miViewDssLog.setVisible(false);
        this.miOutput.add(this.miViewDssLog);
        this.miViewShefLog = new JMenuItem("SHEF Import/Export Output...", 83);
        this.miViewShefLog.setVisible(false);
        this.miOutput.add(this.miViewShefLog);
        this.miDebug = new JMenu("Debug");
        this.miDebug.setMnemonic('D');
        this.advancedMenu.add(this.miDebug);
        this.menuMessageLevel = new JMenuItem("Message Level...", 77);
        this.miDebug.add(this.menuMessageLevel);
        this.menuDebugFileInfo = new JMenuItem("DSS File Header", 68);
        this.menuDebugFileInfo.setEnabled(false);
        this.miDebug.add(this.menuDebugFileInfo);
        this.miRecordAddresses = new JMenuItem("Record Addresses", 82);
        this.miDebug.add(this.miRecordAddresses);
        this.miDebugRecordBins = new JMenuItem("Pathname Bin", 68);
        this.miDebugRecordBins.setEnabled(false);
        this.miDebug.add(this.miDebugRecordBins);
        this.menuExamineFile = new JMenuItem("Debug/Examine File...", 69);
        this.miDebug.add(this.menuExamineFile);
        this.menuFileAccessInfo = new JMenuItem("File Access Info", 65);
        this.miDebug.add(this.menuFileAccessInfo);
        this.menuMemoryMonitor = new JMenuItem("Memory Monitor...", 89);
        this.miDebug.add(this.menuMemoryMonitor);
        this.menuMemoryMonitor.setAccelerator(KeyStroke.getKeyStroke(77, 2, false));
        this.menuDssStatus = new JMenuItem("DSS Files Opened", 70);
        this.miDebug.add(this.menuDssStatus);
        this.menuZset = new JMenuItem("DSS ZSET", 90);
        this.miDebug.add(this.menuZset);
        this.menuZinqir = new JMenuItem("DSS ZINQIR", 73);
        this.menuZinqir.setEnabled(false);
        this.miDebug.add(this.menuZinqir);
        this.miProgramOptions = new JMenuItem("Program Options", 80);
        this.advancedMenu.add(this.miProgramOptions);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('H');
        this.miAbout = new JMenuItem("About");
        this.miAbout.setMnemonic('A');
        ImageIcon icon = RmaImage.getImageIcon((String)ListSelection.getIconImageURL());
        this.miAbout.setIcon(icon);
        this.helpMenu.add(this.miAbout);
        if (this._mode == 2) {
            this.mainMenuBar.add(this.helpMenu);
        }
        this.setJMenuBar(this.mainMenuBar);
        Help.setMainHelp(this);
        this.miNew.addActionListener(this.vueActionListener);
        this.miNewRemote.addActionListener(this.vueActionListener);
        this.miOpenLocal.addActionListener(this.vueActionListener);
        this.miOpenRemote.addActionListener(this.vueActionListener);
        this.miClose.addActionListener(this.vueActionListener);
        this.miPrint.addActionListener(this.vueActionListener);
        this.miPrintPreview.addActionListener(this.vueActionListener);
        this.miExit.addActionListener(this.vueActionListener);
        this.miUndeleteAll.addActionListener(this.vueActionListener);
        this.miUndeleteSelected.addActionListener(this.vueActionListener);
        this.miUndo.addActionListener(this.vueActionListener);
        this.miDelete.addActionListener(this.vueActionListener);
        this.miEditData.addActionListener(this.vueActionListener);
        this.miSelectAll.addActionListener(this.vueActionListener);
        this.miPlot.addActionListener(this.vueActionListener);
        this.miWaterQualityPlot.addActionListener(this.vueActionListener);
        this.miPlotIndividualSets.addActionListener(this.vueActionListener);
        this.miTabulate.addActionListener(this.vueActionListener);
        this.miSupplementalInfo.addActionListener(this.vueActionListener);
        this.miShow.addActionListener(this.vueActionListener);
        this.miRun.addActionListener(this.vueActionListener);
        this.miRefreshCatalog.addActionListener(this.vueActionListener);
        this.miGroupAdd.addActionListener(this.vueActionListener);
        this.miGroupGet_Clear.addActionListener(this.vueActionListener);
        this.miGroupGet_Add.addActionListener(this.vueActionListener);
        this.miGroupPlot.addActionListener(this.vueActionListener);
        this.miGroupIndividualPlot.addActionListener(this.vueActionListener);
        this.miGroupTabulate.addActionListener(this.vueActionListener);
        this.miGroupMath.addActionListener(this.vueActionListener);
        this.miGroupManage.addActionListener(this.vueActionListener);
        this.miTimeWindow.addActionListener(this.vueActionListener);
        this.miMath.addActionListener(this.vueActionListener);
        this.miCompareFiles.addActionListener(this.vueActionListener);
        this.miCompareFilesOptions.addActionListener(this.vueActionListener);
        this.miCompareDataSets.addActionListener(this.vueActionListener);
        this.miCompareDataSetsOptions.addActionListener(this.vueActionListener);
        this.miSearch.addActionListener(this.vueActionListener);
        this.miCopyRecords.addActionListener(this.vueActionListener);
        this.miCopyLocalRecords.addActionListener(this.vueActionListener);
        this.miCopyRemoteRecords.addActionListener(this.vueActionListener);
        this.miCopyRecordsTo.addActionListener(this.vueActionListener);
        this.miTSDataEntry.addActionListener(this.vueActionListener);
        this.miPDDataEntry.addActionListener(this.vueActionListener);
        this.miTextEntry.addActionListener(this.vueActionListener);
        this.miImportText.addActionListener(this.vueActionListener);
        this.miImportImages.addActionListener(this.vueActionListener);
        this.miImportFiles.addActionListener(this.vueActionListener);
        this.miImportShef.addActionListener(this.vueActionListener);
        this.miExportShef.addActionListener(this.vueActionListener);
        this.miExportToFile.addActionListener(this.vueActionListener);
        this.miRenameRecords.addActionListener(this.vueActionListener);
        this.miDuplicateRecords.addActionListener(this.vueActionListener);
        this.miMergeFiles.addActionListener(this.vueActionListener);
        this.miMergeLocalFiles.addActionListener(this.vueActionListener);
        this.miMergeRemoteFiles.addActionListener(this.vueActionListener);
        this.miCheckIntegrity.addActionListener(this.vueActionListener);
        this.miSqueezeFile.addActionListener(this.vueActionListener);
        this.miConvertFile.addActionListener(this.vueActionListener);
        this.unsortSelectiveCatFileMenu.addActionListener(this.vueActionListener);
        this.selectiveCatFileMenu.addActionListener(this.vueActionListener);
        this.sortedCatalogMenu.addActionListener(this.vueActionListener);
        this.menuDssStatus.addActionListener(this.vueActionListener);
        this.menuZset.addActionListener(this.vueActionListener);
        this.menuZinqir.addActionListener(this.vueActionListener);
        this.menuMemoryMonitor.addActionListener(this.vueActionListener);
        this.menuMessageLevel.addActionListener(this.vueActionListener);
        this.menuExamineFile.addActionListener(this.vueActionListener);
        this.menuDebugFileInfo.addActionListener(this.vueActionListener);
        this.menuFileAccessInfo.addActionListener(this.vueActionListener);
        this.miDebugRecordBins.addActionListener(this.vueActionListener);
        this.miRecordAddresses.addActionListener(this.vueActionListener);
        this.miAbout.addActionListener(this.vueActionListener);
        if (this.miConsole != null) {
            this.miConsole.addActionListener(this.vueActionListener);
        }
        this.miViewDssLog.addActionListener(this.vueActionListener);
        this.miViewShefLog.addActionListener(this.vueActionListener);
        this.miProgramOptions.addActionListener(this.vueActionListener);
        if (this.miScripts != null) {
            this.miScripts.addActionListener(this.vueActionListener);
            this.miScriptButtons.addActionListener(this.vueActionListener);
        }
        SymItem lSymItem = new SymItem();
        this.pathnamePartsCheckBox.addItemListener(lSymItem);
        this.pathnameListCheckBox.addItemListener(lSymItem);
        this.condensedCatalogCheckBox.addItemListener(lSymItem);
        this.condensedCatalogCollectionsCheckBox.addItemListener(lSymItem);
        this.noPathnamesCheckBox.addItemListener(lSymItem);
        this.unsortedListCheckBox.addItemListener(lSymItem);
        this.pathnameStringSearch.addItemListener(lSymItem);
        this.pathnamePartsSearch.addItemListener(lSymItem);
        this.miNormalize.addItemListener(lSymItem);
        this.miSyncTimes.addItemListener(lSymItem);
    }

    protected WildCardChooserDlg getWildCardChooserDlg() {
        if (this._wildCardChooserDlg == null) {
            this._wildCardChooserDlg = new WildCardChooserDlg(this);
        }
        String[] choices = this._catalogWithWildCharsChoices.toArray(new String[this._catalogWithWildCharsChoices.size()]);
        this._wildCardChooserDlg.setChoices(choices);
        this._wildCardChooserDlg.setVisible(true);
        return this._wildCardChooserDlg;
    }

    public void addPluginMenus() {
        Object mi;
        int i;
        if (this._pluginsAdded) {
            return;
        }
        this._pluginsAdded = true;
        if (this.pluginVector[0] != null) {
            this.addFilePlugins();
        }
        if (this.pluginVector[1] != null) {
            this.editMenu.addSeparator();
            for (i = 0; i < this.pluginVector[1].size(); ++i) {
                mi = this.pluginVector[1].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.editMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[2] != null) {
            this.viewMenu.addSeparator();
            for (i = 0; i < this.pluginVector[2].size(); ++i) {
                mi = this.pluginVector[2].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.viewMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[3] != null) {
            this.displayMenu.addSeparator();
            for (i = 0; i < this.pluginVector[3].size(); ++i) {
                mi = this.pluginVector[3].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.displayMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[4] != null) {
            this.groupMenu.addSeparator();
            for (i = 0; i < this.pluginVector[4].size(); ++i) {
                mi = this.pluginVector[4].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.groupMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[5] != null) {
            this.dataEntryMenu.addSeparator();
            for (i = 0; i < this.pluginVector[5].size(); ++i) {
                mi = this.pluginVector[5].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.dataEntryMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[6] != null) {
            this.toolsMenu.addSeparator();
            for (i = 0; i < this.pluginVector[6].size(); ++i) {
                mi = this.pluginVector[6].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.toolsMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[7] != null) {
            this.customMenu.setVisible(true);
            for (i = 0; i < this.pluginVector[7].size(); ++i) {
                mi = this.pluginVector[7].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.customMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[8] != null) {
            this.scriptMenu.setVisible(true);
            for (i = 0; i < this.pluginVector[8].size(); ++i) {
                mi = this.pluginVector[8].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.scriptMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[9] != null) {
            this.advancedMenu.addSeparator();
            for (i = 0; i < this.pluginVector[9].size(); ++i) {
                mi = this.pluginVector[9].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.advancedMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[10] != null) {
            this.helpMenu.addSeparator();
            for (i = 0; i < this.pluginVector[10].size(); ++i) {
                mi = this.pluginVector[10].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.helpMenu.add((JMenuItem)mi);
            }
        }
        this.invalidate();
        this.validate();
    }

    protected void addFilePlugins() {
        if (this.pluginVector[0] != null) {
            for (int i = 0; i < this.pluginVector[0].size(); ++i) {
                Object mi = this.pluginVector[0].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    this.fileMenu.add((Component)new JPopupMenu.Separator(), 3);
                }
                this.fileMenu.add((Component)((JMenuItem)mi), 4);
            }
        }
    }

    protected void addPlotPlugins(G2dDialog g2d) {
        Object mi;
        int i;
        JMenu menu;
        if (this.pluginVector[11] != null) {
            menu = g2d.getFileMenu();
            for (i = 0; i < this.pluginVector[11].size(); ++i) {
                mi = this.pluginVector[11].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[12] != null) {
            menu = g2d.getEditMenu();
            for (i = 0; i < this.pluginVector[12].size(); ++i) {
                mi = this.pluginVector[12].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[13] != null) {
            menu = g2d.getViewMenu();
            for (i = 0; i < this.pluginVector[13].size(); ++i) {
                mi = this.pluginVector[13].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
    }

    protected void addTablePlugins(HecDataTableFrame table) {
        Object mi;
        int i;
        JMenu menu;
        if (this.pluginVector[14] != null) {
            menu = table.getFileMenu();
            for (i = 0; i < this.pluginVector[14].size(); ++i) {
                mi = this.pluginVector[14].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[15] != null) {
            menu = table.getEditMenu();
            for (i = 0; i < this.pluginVector[15].size(); ++i) {
                mi = this.pluginVector[15].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[16] != null) {
            menu = table.getViewMenu();
            for (i = 0; i < this.pluginVector[16].size(); ++i) {
                mi = this.pluginVector[16].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
    }

    protected void addMathPlugins(MathFrame2 math) {
        Object mi;
        int i;
        JMenu menu;
        if (this.pluginVector[17] != null) {
            menu = math.getFileMenu();
            for (i = 0; i < this.pluginVector[17].size(); ++i) {
                mi = this.pluginVector[17].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[18] != null) {
            menu = math.getEditMenu();
            for (i = 0; i < this.pluginVector[18].size(); ++i) {
                mi = this.pluginVector[18].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[19] != null) {
            menu = math.getDisplayMenu();
            for (i = 0; i < this.pluginVector[19].size(); ++i) {
                mi = this.pluginVector[19].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                if (i == 0) {
                    menu.add(new JPopupMenu.Separator());
                }
                menu.add((JMenuItem)mi);
            }
        }
    }

    protected void enableReadMenus(boolean enable) {
        Object mi;
        int i;
        if (this.pluginVector[2] != null) {
            for (i = 0; i < this.pluginVector[2].size(); ++i) {
                mi = this.pluginVector[2].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                ((JMenuItem)mi).setEnabled(enable);
            }
        }
        if (this.pluginVector[3] != null) {
            for (i = 0; i < this.pluginVector[3].size(); ++i) {
                mi = this.pluginVector[3].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                ((JMenuItem)mi).setEnabled(enable);
            }
        }
        if (this.pluginVector[4] != null) {
            for (i = 0; i < this.pluginVector[4].size(); ++i) {
                mi = this.pluginVector[4].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                this.groupMenu.add((JMenuItem)mi);
            }
        }
        if (this.pluginVector[6] != null) {
            for (i = 0; i < this.pluginVector[6].size(); ++i) {
                mi = this.pluginVector[6].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                ((JMenuItem)mi).setEnabled(enable);
            }
        }
        if (this.pluginVector[7] != null) {
            this.customMenu.setVisible(true);
            for (i = 0; i < this.pluginVector[7].size(); ++i) {
                mi = this.pluginVector[7].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                ((JMenuItem)mi).setEnabled(enable);
            }
        }
        if (this.pluginVector[8] != null) {
            this.scriptMenu.setVisible(true);
            for (i = 0; i < this.pluginVector[8].size(); ++i) {
                mi = this.pluginVector[8].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                ((JMenuItem)mi).setEnabled(enable);
            }
        }
        if (this.pluginVector[9] != null) {
            for (i = 0; i < this.pluginVector[9].size(); ++i) {
                mi = this.pluginVector[9].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                ((JMenuItem)mi).setEnabled(enable);
            }
        }
    }

    protected void enableWriteMenus(boolean enable) {
        Object mi;
        int i;
        if (this.pluginVector[1] != null) {
            for (i = 0; i < this.pluginVector[1].size(); ++i) {
                mi = this.pluginVector[1].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                ((JMenuItem)mi).setEnabled(enable);
            }
        }
        if (this.pluginVector[5] != null) {
            this.dataEntryMenu.addSeparator();
            for (i = 0; i < this.pluginVector[5].size(); ++i) {
                mi = this.pluginVector[5].elementAt(i);
                if (!(mi instanceof JMenuItem)) continue;
                ((JMenuItem)mi).setEnabled(enable);
            }
        }
    }

    protected void buildPopup() {
        this._popup = new JPopupMenu();
        this.mDefaultDisplay = new JMenuItem("Default Display");
        this.mPopPlot = new JMenuItem("Plot");
        this.mPopTabulate = new JMenuItem("Tabulate");
        this.mPopEditData = new JMenuItem("Edit");
        this.mPopCopyPathnames = new JMenuItem("Copy Pathnames to Clipboard");
        this.mPopRenameRecords = new JMenuItem("Rename");
        this.mPopDuplicateRecords = new JMenuItem("Duplicate");
        this.mPopCopyRecords = new JMenuItem("Copy");
        this.mPopCopyRecordsLocal = new JMenuItem("Copy Local");
        this.mPopCopyRecordsRemote = new JMenuItem("Copy Remote");
        this.mPopDelete = new JMenuItem("Delete");
        this.mPopDelete.setName("Delete");
        this.mPopMoveTop = new JMenuItem("Move to Top");
        this.mPopMoveUp = new JMenuItem("Move Up");
        this.mPopMoveDown = new JMenuItem("Move Down");
        this.mPopMoveBottom = new JMenuItem("Move to Bottom");
        this.mDefaultDisplay.addActionListener(this.vueActionListener);
        this.mPopPlot.addActionListener(this.vueActionListener);
        this.mPopTabulate.addActionListener(this.vueActionListener);
        this.mPopEditData.addActionListener(this.vueActionListener);
        this.mPopCopyPathnames.addActionListener(this.vueActionListener);
        this.mPopRenameRecords.addActionListener(this.vueActionListener);
        this.mPopDuplicateRecords.addActionListener(this.vueActionListener);
        this.mPopCopyRecords.addActionListener(this.vueActionListener);
        this.mPopCopyRecordsLocal.addActionListener(this.vueActionListener);
        this.mPopCopyRecordsRemote.addActionListener(this.vueActionListener);
        this.mPopDelete.addActionListener(this.vueActionListener);
        this.mPopMoveTop.addActionListener(this.vueActionListener);
        this.mPopMoveUp.addActionListener(this.vueActionListener);
        this.mPopMoveDown.addActionListener(this.vueActionListener);
        this.mPopMoveBottom.addActionListener(this.vueActionListener);
        this._popup.add(this.mPopPlot);
        this._popup.add(this.mPopTabulate);
        this._popup.add(this.mPopEditData);
        this._popup.addSeparator();
        this._popup.add(this.mPopCopyPathnames);
        this._popup.addSeparator();
        this._popup.add(this.mPopRenameRecords);
        this._popup.add(this.mPopDuplicateRecords);
        if (this.isRemote()) {
            this._popup.add(this.mPopCopyRecordsLocal);
            this._popup.add(this.mPopCopyRecordsRemote);
        } else {
            this._popup.add(this.mPopCopyRecords);
        }
        this._popup.add(this.mPopDelete);
        this._popup.addSeparator();
        int n = this._popup.getComponentCount();
        this._popup.getComponent(n - 1).setVisible(false);
        this._popup.add(this.mPopMoveTop);
        this.mPopMoveTop.setVisible(false);
        this._popup.add(this.mPopMoveUp);
        this.mPopMoveUp.setVisible(false);
        this._popup.add(this.mPopMoveDown);
        this.mPopMoveDown.setVisible(false);
        this._popup.add(this.mPopMoveBottom);
        this.mPopMoveBottom.setVisible(false);
        this._selectionAndFilterPanel.setPopup(this._popup);
    }

    protected void updateFileMenu() {
        this.fileMenu.removeAll();
        this.fileMenu.add(this.miNew);
        if (this._allowRemote) {
            this.fileMenu.add(this.miNewRemote);
        }
        this.fileMenu.add(this.miOpenLocal);
        if (this._allowRemote) {
            this.fileMenu.add(this.miOpenRemote);
        }
        this.fileMenu.add(this.miSaveAsLocal);
        if (this._allowRemote) {
            this.fileMenu.add(this.miSaveAsRemote);
        }
        boolean flag = false;
        if (this._dataManager != null && this._dataManager.fileOpened()) {
            flag = true;
        }
        if (this._secondDataManager != null && this._secondDataManager.fileOpened()) {
            flag = true;
        }
        this.miClose.setEnabled(flag);
        this.fileMenu.add(this.miClose);
        this.enableSaveAs(flag);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.miPrintPreview);
        this.fileMenu.add(this.miPrint);
        this.miPastFile = new JMenuItem[this._pastFilesAccessed.size()];
        if (this._pastFilesAccessed.size() > 0) {
            this.fileMenu.addSeparator();
        }
        Vector pastFiles = this.getPastFiles();
        int numb = Math.min(pastFiles.size(), this.miPastFile.length);
        for (int i = 0; i < numb; ++i) {
            String filename = (String)pastFiles.elementAt(i);
            int position = i + 1;
            this.miPastFile[i] = new JMenuItem(filename);
            this.miPastFile[i].setActionCommand(filename);
            char c = Integer.toString(position).charAt(0);
            this.miPastFile[i].setMnemonic(c);
            if (this._mruFileList.containsKey(filename)) {
                this.miPastFile[i].setEnabled(this._mruFileList.get(filename));
            } else if (filename.toLowerCase().startsWith("c:")) {
                File file = new File(filename);
                boolean exists = file.exists();
                this.miPastFile[i].setEnabled(exists);
                this._mruFileList.put(filename, exists);
            } else {
                this.miPastFile[i].setEnabled(false);
                this._mruRemoteFileList.add(filename);
            }
            this.fileMenu.add(this.miPastFile[i]);
            this.miPastFile[i].addActionListener(this.vueActionListener);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.miExit);
        this.addFilePlugins();
        if (this._mruRemoteFileList.size() > 0 && this.isVisible()) {
            CheckMruRemoteFiles ck = new CheckMruRemoteFiles();
            ck.checkFiles(this);
        }
    }

    protected void enableMenuFileItem(String filename, boolean enable) {
        this._mruFileList.put(filename, enable);
        for (int i = 0; i < this.miPastFile.length; ++i) {
            if (this.miPastFile[i] == null || !filename.equals(this.miPastFile[i].getText())) continue;
            this.miPastFile[i].setEnabled(enable);
            return;
        }
    }

    protected Vector getPastFiles() {
        Vector<String> pastFiles = new Vector<String>();
        int pastFilesSize = this._pastFilesAccessed.size();
        if (pastFilesSize > 6) {
            pastFilesSize = 6;
        }
        for (int i = 0; i < pastFilesSize; ++i) {
            int j = this._pastFilesAccessed.size() - i - 1;
            String filename = (String)this._pastFilesAccessed.get(j);
            filename = filename.replace('\\', '/');
            pastFiles.add(filename);
        }
        return pastFiles;
    }

    protected void buildScriptButtons() {
        int i;
        ScriptManagerImpl sm = ScriptManagerImpl.getInstance();
        Vector v = sm.getScriptIdsForObject("Scripts/HecDssVue");
        HashMap<String, JMenu> groupsToMenu = new HashMap<String, JMenu>();
        if (!this.isVisible()) {
            this.jToolBar1.addSeparator();
        } else {
            this._scriptButtonToolbarPanel.removeAll();
            int compCnt = this.scriptMenu.getMenuComponentCount();
            for (int i2 = compCnt - 1; i2 >= 0; --i2) {
                this.scriptMenu.remove(i2);
            }
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof ScriptFlatButton) {
                    ScriptIdentifier id = ((ScriptFlatButton)obj).getScriptIdentifier();
                    if (id == null) {
                        System.out.println("Null ScriptIdentifier for button labeled " + ((ScriptFlatButton)obj).getText());
                        return;
                    }
                    ListSelection.this.runScript(id);
                } else if (obj instanceof ScriptMenuItem) {
                    ScriptIdentifier id = ((ScriptMenuItem)obj).getScriptIdentifier();
                    if (id == null) {
                        System.out.println("Null ScriptIdentifier for menu item labeled " + ((ScriptMenuItem)obj).getText());
                        return;
                    }
                    ListSelection.this.runScript(id);
                }
            }
        };
        ArrayList<ScriptFlatButton> buttons = new ArrayList<ScriptFlatButton>(v.size());
        for (i = 0; i < v.size(); ++i) {
            ScriptIdentifier sid = (ScriptIdentifier)v.get(i);
            if (!sid.isDisplayedToUser()) continue;
            ScriptFlatButton button = new ScriptFlatButton(sid){

                public String toString() {
                    return this.getText();
                }
            };
            button.addActionListener(al);
            button.setContentAreaFilled(false);
            button.setOpaque(true);
            buttons.add(button);
        }
        this.sortScriptButtons(buttons);
        for (i = 0; i < buttons.size(); ++i) {
            if (buttons.get(i) == null) continue;
            this._scriptButtonToolbarPanel.add((Component)buttons.get(i));
        }
        for (i = 0; i < v.size(); ++i) {
            ScriptIdentifier sid = (ScriptIdentifier)v.get(i);
            if (!sid.isDisplayedInMenu()) continue;
            ScriptMenuItem menuItem = new ScriptMenuItem(sid);
            menuItem.addActionListener(al);
            String groupName = sid.getGroupName();
            if (groupName == null || groupName.isEmpty()) {
                this.scriptMenu.add((JMenuItem)menuItem);
                continue;
            }
            JMenu subMenu = (JMenu)groupsToMenu.get(groupName);
            if (subMenu == null) {
                subMenu = new JMenu(groupName);
                groupsToMenu.put(groupName, subMenu);
            }
            subMenu.add((JMenuItem)menuItem);
        }
        Collection subMenusValues = groupsToMenu.values();
        Object[] subMenus = new JMenu[subMenusValues.size()];
        subMenusValues.toArray(subMenus);
        Object[] names = new String[subMenus.length];
        for (int i3 = 0; i3 < subMenus.length; ++i3) {
            names[i3] = ((AbstractButton)subMenus[i3]).getText();
        }
        RMASort.quickSort((Object[])names, (Object[])subMenus);
        ActionListener scriptMenuAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                ListSelection.this.displayScriptButtons(menuItem.getName());
            }
        };
        this.miScriptButtons.removeAll();
        for (int i4 = 0; i4 < subMenus.length; ++i4) {
            this.scriptMenu.insert((JMenuItem)subMenus[i4], i4);
            JMenuItem scriptButtonsMenu = new JMenuItem(((AbstractButton)subMenus[i4]).getText());
            scriptButtonsMenu.setName(((AbstractButton)subMenus[i4]).getText());
            scriptButtonsMenu.addActionListener(scriptMenuAl);
            this.miScriptButtons.add(scriptButtonsMenu);
        }
        JMenuItem scriptButtonsMenu = new JMenuItem("Default");
        scriptButtonsMenu.addActionListener(scriptMenuAl);
        this.miScriptButtons.add((Component)scriptButtonsMenu, 0);
        this._scriptButtonPanel.update();
        this.jToolBar1.revalidate();
        if (this.scriptMenu.getMenuComponentCount() > 0) {
            this.scriptMenu.setVisible(true);
            this.scriptMenu.revalidate();
        }
    }

    @Override
    public void addNotify() {
        this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            int h;
            int iy;
            int ix;
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle screenSize = new Rectangle(size);
            if (screenSize.contains(ix = this._preferences.getInt("mainWindow.position.x", 50), iy = this._preferences.getInt("mainWindow.position.y", 50))) {
                this.setLocation(ix, iy);
            }
            int width = 650;
            int height = 500;
            int w = this._preferences.getInt("mainWindow.size.width", width);
            if (screenSize.contains(new Rectangle(w, h = this._preferences.getInt("mainWindow.size.height", height))) && w > 100 && h > 100) {
                width = w;
                height = h;
            }
            this.setSize(width, height);
            int state = this._preferences.getInt("mainWindow.state", -1);
            if (state != -1 && (state & 6) == 6) {
                this.setExtendedState(6);
            }
        }
        super.setVisible(visible);
        if (visible) {
            int dividerLoc = this._preferences.getInt("pathnameWindow.size", -1);
            this._selectionAndFilterPanel.setDividerLocation(dividerLoc);
            if (this._mruRemoteFileList.size() > 0) {
                CheckMruRemoteFiles ck = new CheckMruRemoteFiles();
                ck.checkFiles(this);
            }
        }
    }

    private void loadPlugins(ListSelection selection) {
        PlugInLoader.loadPlugIns((String)"HecDssVuePlugin", (Object[])new Object[]{selection});
        this.addPluginMenus();
    }

    public int checkNumberOpenWindows() {
        for (int i = this._objectList.size() - 1; i >= 0; --i) {
            JFrame frame;
            Object obj = this._objectList.get(i);
            if (!(obj instanceof JFrame) || (frame = (JFrame)obj).isVisible()) continue;
            this._objectList.removeElementAt(i);
        }
        return this._objectList.size();
    }

    public Vector getObjectList() {
        return this._objectList;
    }

    public WindowClosingListener getWindowClosingListener() {
        return this._windowClosingListener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof HecDataTableFrame) {
            String property = evt.getPropertyName();
            if (property.equals(HecDataTableFrame.DATE_STYLE)) {
                this.setDateStyle((Integer)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.QUALITY_STYLE)) {
                this.setTableQualityState((Integer)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.SHOW_COMMAS_PROPERTY)) {
                this.setTableCommasState((Boolean)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.REVERSE_ORDER_PROPERTY)) {
                this.setTableReverseOrderState((Boolean)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.SHOW_DATE_AS_TWO_COLUMNS)) {
                this.setDateTimeAsTwoColumns((Boolean)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.getDecimalPlacesProp())) {
                this.setDecimalPlaces((Integer)evt.getNewValue());
            }
        }
    }

    public void JFrame1_WindowClosing(WindowEvent event) {
        this.exitProgram();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void addHelpMenu(JMenuItem helpMenuItem) {
        if (helpMenuItem == null) {
            return;
        }
        this.helpMenu = this.getHelpMenu();
        if (this.helpMenu != null) {
            this.helpMenu.setMnemonic('H');
            this.helpMenu.add(helpMenuItem);
        }
    }

    public void setStatusLineVisible(boolean visible) {
        this._statusPanel.setVisible(visible);
    }

    public SelectionAndFilterPanel getSelectionAndFilterPanel() {
        return this._selectionAndFilterPanel;
    }

    protected void saveItemsToPrefs(List<ScriptFlatButton> scriptButtons) {
        Preferences scriptsNode = this._preferences.node("Scripts");
        if (scriptsNode == null) {
            System.out.println("saveItemsToPrefs:can't find scripts node");
            return;
        }
        try {
            scriptsNode.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        for (int i = 0; i < scriptButtons.size(); ++i) {
            ScriptFlatButton button = scriptButtons.get(i);
            scriptsNode.putInt(button.getText(), i);
        }
    }

    public void reloadScriptToolBar(List<ScriptFlatButton> buttons) {
        this._scriptButtonToolbarPanel.removeAll();
        this.sortScriptButtons(buttons);
        for (int i = 0; i < buttons.size(); ++i) {
            this._scriptButtonToolbarPanel.add((Component)buttons.get(i));
        }
        this._scriptButtonToolbarPanel.revalidate();
    }

    protected void sortScriptButtons(List<ScriptFlatButton> scriptButtons) {
        if (scriptButtons == null) {
            return;
        }
        try {
            if (!this._preferences.nodeExists("Scripts")) {
                return;
            }
        }
        catch (BackingStoreException e) {
            return;
        }
        Preferences scriptsNode = this._preferences.node("Scripts");
        if (scriptsNode == null) {
            return;
        }
        ArrayList<ScriptFlatButton> savedOrder = new ArrayList<ScriptFlatButton>();
        try {
            String[] keys = scriptsNode.keys();
            for (int i = 0; i < keys.length; ++i) {
                savedOrder.add(null);
            }
        }
        catch (BackingStoreException e) {
            return;
        }
        for (int i = 0; i < scriptButtons.size(); ++i) {
            ScriptFlatButton button = scriptButtons.get(i);
            int idx = scriptsNode.getInt(button.getText(), -1);
            if (idx > -1) {
                savedOrder.set(idx, button);
                continue;
            }
            savedOrder.add(button);
        }
        scriptButtons.clear();
        scriptButtons.addAll(savedOrder);
    }

    protected void setPrimaryDb(DssDataManager dssDataManager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSeriesContainer reload(TimeSeriesContainer tsContainer) {
        DataReference dataReference = new DataReference(tsContainer.fullName, tsContainer.fileName);
        DSSPathname dssName = new DSSPathname(tsContainer.getFullName());
        DssDataManager dataManager = this._dataManager;
        if (!dssName.isCwmsTsId()) {
            dssName.setDPart("");
        }
        dataReference.setFilename(tsContainer.fileName);
        dataReference.setPath(dssName.getPathname());
        dataReference.setTimeWindow(tsContainer.getStartTime(), tsContainer.getEndTime());
        tsContainer.startHecTime.setUndefined();
        tsContainer.endHecTime.setUndefined();
        tsContainer.startTime = 0;
        tsContainer.endTime = 0;
        tsContainer.values = null;
        tsContainer.quality = null;
        tsContainer.times = null;
        tsContainer.timeZoneID = null;
        TimeZone timeZone = dataManager.getTimeZone();
        dataManager.setTimeZone(null);
        try {
            dataManager.readData(dataReference, tsContainer, false);
        }
        finally {
            dataManager.setTimeZone(timeZone);
        }
        return tsContainer;
    }

    public int getUnitSystem() {
        return this._unitSystem;
    }

    public static String getIconImageURL() {
        if (_iconURL == null) {
            _iconURL = ICON_IMAGE_URL_16X16;
        }
        return _iconURL;
    }

    public static void setIconURL(String image) {
        _iconURL = image;
    }

    public static String getHighResIconImageURL() {
        if (_highResIconURL == null) {
            _highResIconURL = ICON_IMAGE_URL_256x256;
        }
        return _highResIconURL;
    }

    public static void setHighResIconImageURL(String image) {
        _highResIconURL = image;
    }

    public static String getAboutImageURL() {
        if (_aboutImageURL == null) {
            _aboutImageURL = ABOUT_IMAGE_URL;
        }
        return _aboutImageURL;
    }

    public static void setAboutURL(String newURL) {
        _aboutImageURL = newURL;
    }

    public static String getProgramName() {
        return _programName;
    }

    protected boolean isCwms(DssDataManager dssDataManager) {
        return false;
    }

    static {
        MapGlyphFactory.addMapping((String)SingleGrid.class.getName(), (String)SingleGridGlyph.class.getName());
        GridInfoFrame.addTabClass(GridDataMapPanel.class, 0);
    }

    protected class WindowClosingListener
    extends WindowAdapter {
        protected WindowClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Object src = e.getSource();
            ListSelection.this._objectList.removeElement(src);
            ((Window)src).removeWindowListener(this);
            System.gc();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Object src = e.getSource();
            ListSelection.this._objectList.removeElement(src);
            ((Window)src).removeWindowListener(this);
            System.gc();
        }
    }

    class WildCardChooserDlg
    extends JDialog {
        private String selectedItem;
        private JButton btnOkay;
        private JComboBox<String> jcb;

        String getSelectedItem() {
            return this.selectedItem;
        }

        void setChoices(String[] choices) {
            String selectedItem = (String)this.jcb.getSelectedItem();
            this.jcb.setModel(new DefaultComboBoxModel<String>(choices));
            this.jcb.setSelectedItem(selectedItem);
        }

        WildCardChooserDlg(ListSelection owner) {
            super(owner);
            this.selectedItem = null;
            this.btnOkay = null;
            this.setModal(true);
            this.setTitle("Selective Catalog");
            SpringLayout springLayout = new SpringLayout();
            this.getContentPane().setLayout(springLayout);
            JLabel lblQuestionIcon = new JLabel("");
            springLayout.putConstraint("North", (Component)lblQuestionIcon, 39, "North", (Component)this.getContentPane());
            springLayout.putConstraint("West", (Component)lblQuestionIcon, 10, "West", (Component)this.getContentPane());
            new UIManager();
            lblQuestionIcon.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
            this.getContentPane().add(lblQuestionIcon);
            JLabel lblMessage = new JLabel("Enter pathname or ID with wild (*) characters");
            springLayout.putConstraint("North", (Component)lblMessage, 10, "North", (Component)this.getContentPane());
            springLayout.putConstraint("West", (Component)lblMessage, 8, "East", (Component)lblQuestionIcon);
            this.getContentPane().add(lblMessage);
            this.jcb = new JComboBox();
            springLayout.putConstraint("North", this.jcb, 10, "South", (Component)lblMessage);
            springLayout.putConstraint("West", this.jcb, 0, "West", (Component)lblMessage);
            springLayout.putConstraint("East", this.jcb, 0, "East", (Component)lblMessage);
            this.jcb.setEditable(true);
            this.jcb.setModel(new DefaultComboBoxModel<String>(ListSelection.this._catalogWithWildCharsChoices.toArray(new String[ListSelection.this._catalogWithWildCharsChoices.size()])));
            this.jcb.setSelectedIndex(0);
            this.jcb.addActionListener(e -> {
                if (e.getActionCommand().equals("comboBoxEdited")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WildCardChooserDlg.this.btnOkay.doClick();
                        }
                    });
                }
            });
            this.getContentPane().add(this.jcb);
            this.btnOkay = new JButton("OK");
            springLayout.putConstraint("North", (Component)this.btnOkay, 30, "South", this.jcb);
            springLayout.putConstraint("West", (Component)this.btnOkay, 30, "West", this.jcb);
            this.btnOkay.addActionListener(e -> {
                this.selectedItem = (String)this.jcb.getSelectedItem();
                ListSelection.this._catalogWithWildCharsChoices.add(this.selectedItem);
                this.setVisible(false);
                this.jcb.requestFocus();
            });
            this.getContentPane().add(this.btnOkay);
            JButton btnCancel = new JButton("Cancel");
            springLayout.putConstraint("North", (Component)btnCancel, 0, "North", (Component)this.btnOkay);
            springLayout.putConstraint("West", (Component)btnCancel, 32, "East", (Component)this.btnOkay);
            btnCancel.addActionListener(e -> {
                this.setVisible(false);
                this.jcb.requestFocus();
            });
            this.getContentPane().add(btnCancel);
            this.setDefaultCloseOperation(1);
            this.getRootPane().setDefaultButton(this.btnOkay);
            this.getRootPane().registerKeyboardAction(e -> this.setVisible(false), KeyStroke.getKeyStroke(27, 0), 2);
            this.setPreferredSize(new Dimension(300, 173));
            this.pack();
            this.setLocationRelativeTo(owner);
            this.setVisible(true);
        }
    }

    protected class LoadCatalogSwingWorker
    extends SwingWorker<Object, Object> {
        protected DssDataManager _dataManager;

        protected LoadCatalogSwingWorker(DssDataManager dataManager) {
            this._dataManager = dataManager;
        }

        @Override
        public Object doInBackground() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ListSelection.this._selectionAndFilterPanel.enableTabCloseButtons(false);
                    ListSelection.this.setCursorWait("Building catalog...");
                }
            });
            if (debug) {
                Logger.getLogger(ListSelection.class.getName()).log(Level.INFO, "Begin BuildCatalog() ");
                ElapsedTime.startElapsedTime();
            }
            if (ListSelection.this._viewState == 2 || ListSelection.this._viewState == 3) {
                final CondensedReference[] condensed = ListSelection.this.getCondensedCatalog();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ListSelection.this._selectionAndFilterPanel.setCondensedCatalog(condensed, LoadCatalogSwingWorker.this._dataManager);
                    }
                });
            } else {
                final String[] paths = ListSelection.this.catalogFile(ListSelection.this._createCatalog, false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ListSelection.this._selectionAndFilterPanel.setPathnameList(paths, LoadCatalogSwingWorker.this._dataManager);
                    }
                });
            }
            if (debug) {
                Logger.getLogger(ListSelection.class.getName()).log(Level.INFO, "Complete BuildCatalog {0}", ElapsedTime.elapsedTimeDescription((boolean)false));
                Logger.getLogger(ListSelection.class.getName()).log(Level.INFO, " ");
            }
            return null;
        }

        /*
         * Loose catch block
         */
        @Override
        protected void done() {
            try {
                this.get();
                if (ListSelection.this._selectionAndFilterPanel.getPathnamesDisplayedSize() == 0 && this._dataManager.numberRecords() > 0) {
                    ListSelection.this.updateTableView(false, false);
                }
                ListSelection.this.pathnameListUpdated();
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.FINE, "Table load was interrupted.", ex);
                Thread.currentThread().interrupt();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ListSelection.this._selectionAndFilterPanel.enableTabCloseButtons(true);
                        ListSelection.this.setCursorDefault();
                    }
                });
            }
            catch (Exception ex2) {
                LOGGER.log(Level.WARNING, "Exception occurred and prevented the table from loading", ex2);
                {
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private class MyDssVueProgressBar
    extends DssVueProgressBar {
        SwingWorker _worker;

        public MyDssVueProgressBar(ListSelection listSelection2, int operation, int number, String title, String secondFile, boolean makeVisible) {
            super(listSelection2, operation, 1, title, secondFile, makeVisible);
            this._worker = null;
            this.totalNumber = number;
        }

        public void setProgress(int progress) {
            this.currentRec[0] = progress;
        }

        @Override
        public void updateProgress() {
            this.displayProgress();
        }

        public void setWorker(SwingWorker worker) {
            this._worker = worker;
        }

        @Override
        public void canceled() {
            super.canceled();
            if (this._worker != null) {
                this._worker.cancel(true);
            }
        }
    }

    protected class VueActionListener
    implements ActionListener {
        protected VueActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ListSelection.this._dssVueProgressBar != null) {
                return;
            }
            Object object = event.getSource();
            if (object == ListSelection.this.miOpenLocal) {
                ListSelection.this._remote = false;
                ListSelection.this.openMenu(ListSelection.this._remote, true, false, 0);
            } else if (object == ListSelection.this.miOpenRemote) {
                ListSelection.this._remote = true;
                ListSelection.this.openMenu(ListSelection.this._remote, true, false, 0);
            } else if (object == ListSelection.this.miNew) {
                ListSelection.this.openMenu(false, false, true, 7);
            } else if (object == ListSelection.this.miNewRemote) {
                ListSelection.this.openMenu(true, false, true, 7);
            } else if (object == ListSelection.this.miClose) {
                ListSelection.this.closeDssFile();
            } else if (object == ListSelection.this.miPrintPreview) {
                ListSelection.this.printCatalog(true);
            } else if (object == ListSelection.this.miPrint) {
                ListSelection.this.printCatalog(false);
            } else if (object == ListSelection.this.miPlot) {
                ListSelection.this.plot();
            } else if (object == ListSelection.this.miPlotIndividualSets) {
                ListSelection.this.plotIndividualSets();
            } else if (object == ListSelection.this.miWaterQualityPlot) {
                ListSelection.this.plotWaterQuality();
            } else if (object == ListSelection.this.miTabulate) {
                ListSelection.this.tabulate();
            } else if (object == ListSelection.this.miSupplementalInfo) {
                ListSelection.this.supplementalInfo();
            } else if (object == ListSelection.this.miShow) {
                ListSelection.this.slideShow();
            } else if (object == ListSelection.this.miRun) {
                ListSelection.this.runFile();
            } else if (object == ListSelection.this.miUndeleteAll) {
                ListSelection.this.undeleteAll();
            } else if (object == ListSelection.this.miUndeleteSelected) {
                ListSelection.this.undeleteSelected();
            } else if (object == ListSelection.this.miUndo) {
                ListSelection.this.undo();
            } else if (object == ListSelection.this.miDelete) {
                ListSelection.this.delete(false);
            } else if (object == ListSelection.this.miEditData) {
                ListSelection.this.tabularEdit();
            } else if (object == ListSelection.this.miRefreshCatalog) {
                ListSelection.this.refreshCatalog();
            } else if (object == ListSelection.this.miTimeWindow) {
                ListSelection.this._selectionAndFilterPanel.openTimeWindowDialog();
            } else if (object == ListSelection.this.miMath) {
                ListSelection.this.math();
            } else if (object == ListSelection.this.miCompareFiles) {
                ListSelection.this.compareFiles(false);
            } else if (object == ListSelection.this.miCompareFilesOptions) {
                ListSelection.this.compareFiles(true);
            } else if (object == ListSelection.this.miCompareDataSets) {
                ListSelection.this.compareDataSets(false);
            } else if (object == ListSelection.this.miCompareDataSetsOptions) {
                ListSelection.this.compareDataSets(true);
            } else if (object == ListSelection.this.miSearch) {
                ListSelection.this.search();
            } else if (object == ListSelection.this.miTSDataEntry) {
                ListSelection.this.timeSeriesDataEntry();
            } else if (object == ListSelection.this.miPDDataEntry) {
                ListSelection.this.pairedDataEntry();
            } else if (object == ListSelection.this.miTextEntry) {
                ListSelection.this.textEntry();
            } else if (object == ListSelection.this.miImportText) {
                ListSelection.this.textFileEntry();
            } else if (object == ListSelection.this.miImportShef) {
                ListSelection.this.importShef();
            } else if (object == ListSelection.this.miImportImages) {
                ListSelection.this.importImages();
            } else if (object == ListSelection.this.miImportFiles) {
                ListSelection.this.importGenericFiles();
            } else if (object == ListSelection.this.miExportShef) {
                ListSelection.this.exportShef();
            } else if (object == ListSelection.this.miExportToFile) {
                ListSelection.this.exportToFile();
            } else if (object == ListSelection.this.miCopyRecords) {
                ListSelection.this.copyRecords(true);
            } else if (object == ListSelection.this.miCopyLocalRecords) {
                ListSelection.this.copyRecords(true, false, false);
            } else if (object == ListSelection.this.miCopyRemoteRecords) {
                ListSelection.this.copyRecords(true, false, true);
            } else if (object == ListSelection.this.miCopyRecordsTo) {
                ListSelection.this.copyRecords(false, false, ListSelection.this._secondDataManager.isRemote());
            } else if (object == ListSelection.this.miRenameRecords) {
                ListSelection.this.renameRecords(false);
            } else if (object == ListSelection.this.miDuplicateRecords) {
                ListSelection.this.duplicateRecords(false);
            } else if (object == ListSelection.this.miMergeFiles) {
                ListSelection.this.mergeFiles(false);
            } else if (object == ListSelection.this.miMergeLocalFiles) {
                ListSelection.this.mergeFiles(false);
            } else if (object == ListSelection.this.miMergeRemoteFiles) {
                ListSelection.this.mergeFiles(true);
            } else if (object == ListSelection.this.miCheckIntegrity) {
                ListSelection.this.fileCheck();
            } else if (object == ListSelection.this.miSqueezeFile) {
                ListSelection.this.squeeze();
            } else if (object == ListSelection.this.miConvertFile) {
                ListSelection.this.convertVersion();
            } else if (object == ListSelection.this.miScripts) {
                ListSelection.this.displayScriptEditor();
            } else if (object == ListSelection.this.miScriptButtons) {
                ListSelection.this.displayScriptButtons();
            } else if (object == ListSelection.this.unsortSelectiveCatFileMenu) {
                ListSelection.this.diskCatalog(0);
            } else if (object == ListSelection.this.selectiveCatFileMenu) {
                ListSelection.this.diskCatalog(1);
            } else if (object == ListSelection.this.sortedCatalogMenu) {
                ListSelection.this.diskCatalog(2);
            } else if (object == ListSelection.this.menuDssStatus) {
                ListSelection.this.statusDebug();
            } else if (object == ListSelection.this.menuZset) {
                ListSelection.this.zsetRequest();
            } else if (object == ListSelection.this.menuZinqir) {
                ListSelection.this.zinqirRequest();
            } else if (object == ListSelection.this.menuMemoryMonitor) {
                ListSelection.this.memoryMonitor_Action();
            } else if (object == ListSelection.this.menuMessageLevel) {
                ListSelection.this.setMessageLevel();
            } else if (object == ListSelection.this.menuExamineFile) {
                ListSelection.this.examineDssFile();
            } else if (object == ListSelection.this.menuDebugFileInfo) {
                ListSelection.this.debugFileInfo();
            } else if (object == ListSelection.this.menuFileAccessInfo) {
                ListSelection.this.fileAccessInfo();
            } else if (object == ListSelection.this.miRecordAddresses) {
                ListSelection.this.recordAddresses();
            } else if (object == ListSelection.this.miDebugRecordBins) {
                ListSelection.this.debugPathnameBins();
            } else if (object == ListSelection.this.miConsole) {
                ListSelection.this.displayConsole();
            } else if (object == ListSelection.this.miViewDssLog) {
                ListSelection.this.displayDssLog();
            } else if (object == ListSelection.this.miViewShefLog) {
                ListSelection.this.displayShefLog();
            } else if (object == ListSelection.this.miProgramOptions) {
                ListSelection.this.displayOptions();
            } else if (object == ListSelection.this.miAbout) {
                ListSelection.this.helpAbout();
            } else if (object == ListSelection.this.OpenOldTool) {
                boolean remote = false;
                ListSelection.this.openMenu(remote, true, false, 0);
            } else if (object == ListSelection.this.fileName) {
                ListSelection.this.fileName_actionPerformed(event);
            } else if (object == ListSelection.this.miExit) {
                ListSelection.this.exitProgram();
            } else if (object == ListSelection.this.miSelectAll) {
                ListSelection.this.selectAll();
            } else if (object == ListSelection.this.PlotTool) {
                ListSelection.this.plot();
            } else if (object == ListSelection.this.TabulateTool) {
                ListSelection.this.tabulate();
            } else if (object == ListSelection.this.MathFunctionTool) {
                ListSelection.this.math();
            } else if (object == ListSelection.this.mDefaultDisplay) {
                ListSelection.this.defaultDisplay(true);
            } else if (object == ListSelection.this.mPopPlot) {
                ListSelection.this.plot(true);
            } else if (object == ListSelection.this.mPopTabulate) {
                ListSelection.this.tabulate(false, true);
            } else if (object == ListSelection.this.mPopEditData) {
                ListSelection.this.tabulate(true, true);
            } else if (object == ListSelection.this.mPopCopyPathnames) {
                ListSelection.this.copyPathnamesToClipboard(true);
            } else if (object == ListSelection.this.mPopRenameRecords) {
                ListSelection.this.renameRecords(true);
            } else if (object == ListSelection.this.mPopDuplicateRecords) {
                ListSelection.this.duplicateRecords(true);
            } else if (object == ListSelection.this.mPopCopyRecords) {
                ListSelection.this.copyRecords(false, true);
            } else if (object == ListSelection.this.mPopCopyRecordsLocal) {
                ListSelection.this.copyRecords(false, true, false);
            } else if (object == ListSelection.this.mPopCopyRecordsRemote) {
                ListSelection.this.copyRecords(false, true, true);
            } else if (object == ListSelection.this.mPopDelete) {
                ListSelection.this.delete(true);
            } else if (object == ListSelection.this.mPopMoveTop) {
                ListSelection.this._selectionAndFilterPanel.moveTop();
            } else if (object == ListSelection.this.mPopMoveUp) {
                ListSelection.this._selectionAndFilterPanel.moveUp();
            } else if (object == ListSelection.this.mPopMoveDown) {
                ListSelection.this._selectionAndFilterPanel.moveDown();
            } else if (object == ListSelection.this.mPopMoveBottom) {
                ListSelection.this._selectionAndFilterPanel.moveBottom();
            } else if (object == ListSelection.this.miGroupAdd) {
                ListSelection.this.groupAdd();
            } else if (object == ListSelection.this.miGroupManage) {
                ListSelection.this.groupManage();
            } else {
                int size = ListSelection.this.miPastFile.length;
                for (int i = 0; i < size; ++i) {
                    if (object != ListSelection.this.miPastFile[i]) continue;
                    String filename = ListSelection.this.miPastFile[i].getActionCommand();
                    ListSelection.this.openDSSFile(filename);
                    return;
                }
            }
        }
    }

    protected class VueWindowAdapter
    extends WindowAdapter {
        protected VueWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ListSelection.this) {
                ListSelection.this.JFrame1_WindowClosing(event);
            }
        }
    }

    class ScriptButtonPanel
    extends JPanel {
        private static final int scrollSpeedThrottle = 60;
        private JButton _scrollLeftButton;
        private JButton _scrollRightButton;
        private double _totalWidth;
        private int _x;
        private final int MOVEX = 40;
        private Point _point;
        private JScrollPane _scrollPane;
        private JPanel _buttonPanel;
        private MouseAdapter _popupMouseListener;

        public ScriptButtonPanel(JPanel buttonPanel) {
            super(new BorderLayout());
            this.MOVEX = 40;
            this._buttonPanel = buttonPanel;
            this._scrollLeftButton = new JButton(RmaImage.getImageIcon((String)"Images/backbutton.gif"));
            this._scrollLeftButton.setMargin(new Insets(0, 0, 0, 0));
            this._scrollLeftButton.setContentAreaFilled(false);
            this._scrollRightButton = new JButton(RmaImage.getImageIcon((String)"Images/forwardbutton.gif"));
            this._scrollRightButton.setMargin(new Insets(0, 0, 0, 0));
            this._scrollRightButton.setContentAreaFilled(false);
            this._scrollPane = new JScrollPane(ListSelection.this._scriptButtonToolbarPanel, 21, 31);
            this._scrollPane.setBorder(null);
            this._point = new Point(0, 0);
            this.add((Component)this._scrollLeftButton, "West");
            this.add((Component)this._scrollRightButton, "East");
            this.add((Component)this._scrollPane, "Center");
            this.addListeners();
        }

        protected void addListeners() {
            ListSelection.this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ScriptButtonPanel.this.update();
                }
            });
            this._scrollLeftButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptButtonPanel.this.scrollLeft();
                }
            });
            this._scrollRightButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptButtonPanel.this.scrollRight();
                }
            });
            this._popupMouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger() || SwingUtilities.isRightMouseButton(evt)) {
                        if (ScriptButtonPanel.this._buttonPanel.getComponentCount() <= 1) {
                            return;
                        }
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem menuItem = new JMenuItem("Arrange Items");
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ScriptButtonPanel.this.arrangeScriptButtonsInToolbarAction();
                            }
                        });
                        popup.add(menuItem);
                        popup.show(ScriptButtonPanel.this, evt.getX(), evt.getY());
                    }
                }
            };
            this.addMouseListener(this._popupMouseListener);
            this._buttonPanel.addMouseListener(this._popupMouseListener);
        }

        private void arrangeScriptButtonsInToolbarAction() {
            Component[] components = this._buttonPanel.getComponents();
            ArrayList<ScriptFlatButton> buttons = new ArrayList<ScriptFlatButton>(components.length);
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof ScriptFlatButton)) continue;
                buttons.add((ScriptFlatButton)components[i]);
            }
            if (buttons.size() == 0) {
                return;
            }
            SortDialog dialog = new SortDialog(ListSelection.this, "Arrange Items", buttons);
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            List<ScriptFlatButton> items = dialog.getItems();
            ListSelection.this.saveItemsToPrefs(items);
            ListSelection.this.reloadScriptToolBar(items);
        }

        @Override
        public Rectangle getBounds() {
            Rectangle bounds = super.getBounds();
            if (bounds.width == 0) {
                return bounds;
            }
            bounds.width = ListSelection.this.getBounds().width - bounds.x - 40;
            return bounds;
        }

        @Override
        public Dimension getSize() {
            Rectangle bounds = this.getBounds();
            if (bounds.height == 0 || bounds.width == 0) {
                return super.getSize();
            }
            Dimension d = new Dimension(bounds.width, bounds.height);
            return d;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension d = this.getSize();
            if (d.width <= 0 || d.height <= 0) {
                return super.getMaximumSize();
            }
            return d;
        }

        protected void scrollRight() {
            if (this._totalWidth <= 0.0) {
                this.update();
            }
            if (this._totalWidth >= (double)(this._x + this._scrollPane.getVisibleRect().width)) {
                this._x += 40;
                this._point.x = this._x;
                this._scrollPane.getViewport().setViewPosition(this._point);
            } else {
                this._x += 40;
                this._point.x = this._x;
                if (this._scrollPane.getViewport().getView().getBounds().contains(this._point)) {
                    this._scrollPane.getViewport().setViewPosition(this._point);
                } else {
                    this._x -= 40;
                    this._point.x = this._x;
                }
            }
        }

        protected void scrollLeft() {
            if (this._totalWidth <= 0.0) {
                this.update();
            }
            if (this._x != 0) {
                this._x -= 40;
                this._point.x = this._x;
                this._scrollPane.getViewport().setViewPosition(this._point);
            }
        }

        void update() {
            this.getBounds();
            this.setSize(this.getSize());
            this._totalWidth = this.getBounds().getWidth();
            double buttonPanelwidth = this._buttonPanel.getBounds().getWidth();
            if (buttonPanelwidth > this._totalWidth) {
                this._scrollLeftButton.setVisible(true);
                this._scrollRightButton.setVisible(true);
            } else {
                this._scrollLeftButton.setVisible(false);
                this._scrollRightButton.setVisible(false);
                this._x = 0;
            }
            this.revalidate();
        }
    }

    private class MenuBarTimeZone
    extends JMenuBar
    implements TimeZoneComponent,
    UnitsComponent {
        private MenuBarTimeZone() {
        }

        public void setTimeZone(TimeZone tz) {
            ListSelection.this._timeZone = tz;
            ListSelection.this._timeZoneId = ListSelection.this._timeZone.getDisplayName(false, 0);
            ListSelection.this._preferences.put(ListSelection.this.getTimeZonePref(), ListSelection.this._timeZoneId);
            if (ListSelection.this._dataManager != null) {
                ListSelection.this._dataManager.setTimeZone(ListSelection.this._timeZone);
            }
            HecTimeArray.setGlobalViewTimeZone((TimeZone)ListSelection.this._timeZone);
            ListSelection.this.updateMessageField();
            ListSelection.this._selectionAndFilterPanel.getTimeWindowDialog().setTimeZone(ListSelection.this._timeZone);
        }

        public TimeZone getTimeZone() {
            return ListSelection.this._timeZone;
        }

        public String getDisplayUnitsString(int unitSystem) {
            return "";
        }

        public void setDisplayUnitsSystem(int unitSystem) {
            ListSelection.this.setUnitSystem(unitSystem);
        }

        public void setDisplayScaleFactor(int paramId, double scaleFactor) {
        }
    }

    protected class SymItem
    implements ItemListener {
        protected SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (ListSelection.this._dssVueProgressBar != null) {
                return;
            }
            ItemSelectable object = event.getItemSelectable();
            if (object == ListSelection.this.pathnamePartsCheckBox) {
                ListSelection.this.pathnamePartsCheckBox_ItemStateChanged(event);
            } else if (object == ListSelection.this.pathnameListCheckBox) {
                ListSelection.this.pathnameListCheckBox_ItemStateChanged(event);
            } else if (object == ListSelection.this.condensedCatalogCheckBox) {
                ListSelection.this.condensedCatalogCheckBox_ItemStateChanged(event);
            } else if (object == ListSelection.this.condensedCatalogCollectionsCheckBox) {
                ListSelection.this.condensedCatalogCollectionsCheckBox_ItemStateChanged(event);
            } else if (object == ListSelection.this.noPathnamesCheckBox) {
                ListSelection.this.noPathnamesCheckBox_ItemStateChanged(event);
            } else if (object == ListSelection.this.unsortedListCheckBox) {
                ListSelection.this.unsortedListCheckBox_ItemStateChanged(event);
            } else if (object == ListSelection.this.pathnameStringSearch) {
                ListSelection.this.pathnameStringSearch_ItemStateChanged(event);
            } else if (object == ListSelection.this.pathnamePartsSearch) {
                ListSelection.this.pathnamePartsSearch_ItemStateChanged(event);
            } else if (object == ListSelection.this.miNormalize) {
                ListSelection.this.normalizePlotChange(event);
            } else if (object == ListSelection.this.miSyncTimes) {
                ListSelection.this.syncTimesChange(event);
            }
        }
    }

    protected class CheckMruRemoteFiles {
        protected CheckMruRemoteFiles() {
        }

        public void checkFiles(final ListSelection listSelection) {
            new SwingWorker<Hashtable, Hashtable>(){

                @Override
                public Hashtable doInBackground() {
                    Thread.currentThread().setPriority(3);
                    Hashtable<String, Boolean> fileList = new Hashtable<String, Boolean>();
                    int size = ListSelection.this._mruRemoteFileList.size();
                    for (int i = size - 1; i >= 0; --i) {
                        boolean exists;
                        String filename = ListSelection.this._mruRemoteFileList.elementAt(i);
                        ListSelection.this._mruRemoteFileList.remove(i);
                        if (ListSelection.this._remote) {
                            exists = HecDSSUtilitiesRemote.doesDSSFileExist((String)filename);
                        } else {
                            File file = new File(filename);
                            exists = file.exists();
                        }
                        fileList.put(filename, exists);
                    }
                    return fileList;
                }

                @Override
                protected void done() {
                    try {
                        Hashtable fileList = (Hashtable)this.get();
                        Enumeration keys = fileList.keys();
                        while (keys.hasMoreElements()) {
                            String filename = (String)keys.nextElement();
                            Boolean exists = (Boolean)fileList.get(filename);
                            listSelection.enableMenuFileItem(filename, exists);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.execute();
        }
    }
}

