/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dataTable.HecDataTableToExcel;
import hec.dssgui.GeneralTab;
import hec.dssgui.Help;
import hec.dssgui.ListSelection;
import hec.dssgui.MathPanel;
import hec.dssgui.MathTab;
import hec.dssgui.RoutingTab;
import hec.dssgui.SimpleMathTab;
import hec.dssgui.SmoothingTab;
import hec.dssgui.StatisticMathTab;
import hec.dssgui.TransformTab;
import hec.gfx2d.G2dDialog;
import hec.heclib.dss.DssDataType;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.FlatPanelButton;
import rma.swing.RmaImage;
import rma.swing.RmaJFrame;

public class MathFrame2
extends RmaJFrame
implements ActionListener,
ChangeListener {
    protected Vector _dataSetVector;
    protected Vector[] _dataSets;
    protected Vector[] _originalDataSets;
    protected Vector _originalDataSetsList;
    protected Vector _dataSetsToSave = null;
    protected JComboBox _dataSetsCB;
    protected ListSelection _parent;
    protected JMenuBar _menuBar;
    protected JMenu _fileMenu;
    protected JMenu editMenu;
    protected JMenu displayMenu;
    protected JMenuItem _saveItem;
    protected JMenuItem _saveAsItem;
    protected JMenuItem _tabulateItem;
    protected JMenuItem _plotItem;
    protected JMenuItem _exitItem;
    protected JMenu _pairedDataMenu;
    protected JMenuItem _restoreItem;
    protected MathJTabbedPane _tabbedPane;
    protected JPanel _contentPane;
    protected AltTextLabel _statusLineTxt;
    protected Action _saveAction;
    protected Action _saveAsAction;
    protected Action _plotAction;
    protected Action _tabulateAction;
    protected Action _closeAction;
    protected Action _tabulateExcelAction;
    protected boolean _dssFileModified = false;
    protected boolean _forceCatalogUpdate = false;
    protected JButton _computeButton;
    protected JButton _saveButton;
    protected JButton _saveAsButton;
    protected JButton _closeButton;
    protected JCheckBoxMenuItem _showOriginalData;
    protected JCheckBoxMenuItem _showAllDataSets;
    protected JToolBar _toolBar;

    public MathFrame2(ListSelection parent, Vector[] dataSets) {
        this.setTitle("Math Functions");
        this._parent = parent;
        this.build();
        this.setData(dataSets);
        Help.setHelp((RootPaneContainer)((Object)this), "37");
    }

    protected void setData(Vector[] dataSets) {
        int i;
        this._originalDataSets = dataSets;
        this._dataSets = new Vector[dataSets.length];
        boolean pairedData = false;
        int size = 0;
        for (i = 0; i < dataSets.length; ++i) {
            if (dataSets[i] == null) continue;
            size += dataSets[i].size();
            this._dataSets[i] = new Vector(dataSets[i].size());
            block5: for (int j = 0; j < dataSets[i].size(); ++j) {
                switch (i) {
                    case 0: {
                        TimeSeriesContainer tsc = (TimeSeriesContainer)dataSets[i].get(j);
                        TimeSeriesContainer tsClone = new TimeSeriesContainer();
                        tsc.clone(tsClone);
                        this._dataSets[i].add(tsClone);
                        continue block5;
                    }
                    case 1: {
                        PairedDataContainer pdc = (PairedDataContainer)dataSets[i].get(j);
                        PairedDataContainer pdClone = new PairedDataContainer();
                        pdc.clone(pdClone);
                        this._dataSets[i].add(pdClone);
                        pairedData = true;
                    }
                }
            }
        }
        this._dataSetVector = new Vector(size);
        this._originalDataSetsList = new Vector(size);
        for (i = 0; i < this._dataSets.length; ++i) {
            if (this._dataSets[i] == null) continue;
            this._dataSetVector.addAll(this._dataSets[i]);
            this._originalDataSetsList.addAll(this._originalDataSets[i]);
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(this._dataSetVector);
        this._dataSetsCB.setModel(model);
        this._tabbedPane.setData(this._dataSetVector);
        this._dataSetsCB.setSelectedIndex(0);
        if (pairedData) {
            for (int i2 = 0; i2 < this._tabbedPane.getComponentCount(); ++i2) {
                String title = this._tabbedPane.getTitleAt(i2);
                if (title.startsWith("Time")) {
                    this._tabbedPane.setEnabledAt(i2, false);
                    continue;
                }
                if (title.startsWith("Smooth")) {
                    this._tabbedPane.setEnabledAt(i2, false);
                    continue;
                }
                if (!title.startsWith("Stat")) continue;
                this._tabbedPane.setEnabledAt(i2, false);
            }
        }
    }

    public void addDataSet(DataContainer dc) {
        this.addDataSet(dc, true);
    }

    public void addDataSet(DataContainer dc, boolean addToOriginalList) {
        if (dc == null) {
            return;
        }
        if (dc instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsClone = new TimeSeriesContainer();
            ((TimeSeriesContainer)dc).clone(tsClone);
            ((DefaultComboBoxModel)this._dataSetsCB.getModel()).addElement(tsClone);
            if (addToOriginalList) {
                this._originalDataSetsList.add(dc);
            }
            this._tabbedPane.setData(this._dataSetVector);
            dc.modified = true;
        } else if (dc instanceof PairedDataContainer) {
            PairedDataContainer pdClone = new PairedDataContainer();
            ((PairedDataContainer)dc).clone(pdClone);
            ((DefaultComboBoxModel)this._dataSetsCB.getModel()).addElement(pdClone);
            if (addToOriginalList) {
                this._originalDataSetsList.add(dc);
                dc.modified = true;
            }
            this._tabbedPane.setData(this._dataSetVector);
        }
        this._dataSetsCB.setSelectedIndex(this._dataSetVector.size() - 1);
    }

    protected void build() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._contentPane = new JPanel(gridBagLayout);
        this.getContentPane().add((Component)this._contentPane, "Center");
        this.createActions();
        this.buildMenu();
        this.buildButtons();
        this.buildPanel();
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void createActions() {
        this._saveAction = new AbstractAction("Save", RmaImage.getImageIcon((String)"Images/Save.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MathFrame2.this.saveAction();
            }
        };
        this._saveAction.setEnabled(false);
        this._saveAsAction = new AbstractAction("Save As", RmaImage.getImageIcon((String)"Images/saveAs.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MathFrame2.this.saveAsAction();
            }
        };
        this._saveAsAction.setEnabled(false);
        this._plotAction = new AbstractAction("Plot", RmaImage.getImageIcon((String)"Images/smallPlot.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MathFrame2.this.plotAction();
            }
        };
        this._tabulateAction = new AbstractAction("Tabulate", RmaImage.getImageIcon((String)"Images/smallTabulate.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MathFrame2.this.tabulateAction();
            }
        };
        this._tabulateExcelAction = new AbstractAction("Tabulate in Excel", RmaImage.getImageIcon((String)"Images/smallExcel.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MathFrame2.this.tabulateInExcel();
            }
        };
        this._closeAction = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MathFrame2.this.exitAction();
            }
        };
    }

    protected void buildMenu() {
        this._menuBar = new JMenuBar();
        this._fileMenu = new JMenu("File");
        this._fileMenu.setVerifyInputWhenFocusTarget(false);
        this._fileMenu.setMnemonic('F');
        this._menuBar.add(this._fileMenu);
        JMenuItem item = this._fileMenu.add(this._saveAction);
        item.setVerifyInputWhenFocusTarget(false);
        item.setMnemonic('S');
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        item = this._fileMenu.add(this._saveAsAction);
        item.setVerifyInputWhenFocusTarget(false);
        item.setMnemonic('v');
        this._fileMenu.addSeparator();
        item = this._fileMenu.add(this._closeAction);
        item.setVerifyInputWhenFocusTarget(false);
        item.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        item.setMnemonic('C');
        item.setVerifyInputWhenFocusTarget(false);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setVerifyInputWhenFocusTarget(false);
        this.editMenu.setMnemonic('E');
        this._menuBar.add(this.editMenu);
        this._restoreItem = new JMenuItem("Restore Original Data", 82);
        this._restoreItem.setVerifyInputWhenFocusTarget(false);
        this._restoreItem.setEnabled(false);
        this._restoreItem.addActionListener(this);
        this.editMenu.add(this._restoreItem);
        this._pairedDataMenu = new JMenu("Select Paired Data Curve");
        this._pairedDataMenu.setVerifyInputWhenFocusTarget(false);
        this._pairedDataMenu.setMnemonic('P');
        this._pairedDataMenu.setVisible(false);
        this.editMenu.add(this._pairedDataMenu);
        this.displayMenu = new JMenu("Display");
        this.displayMenu.setVerifyInputWhenFocusTarget(false);
        this.displayMenu.setMnemonic('D');
        this._menuBar.add(this.displayMenu);
        this._showOriginalData = new JCheckBoxMenuItem("Original data with computed", false);
        this._showOriginalData.setVerifyInputWhenFocusTarget(false);
        this.displayMenu.add(this._showOriginalData);
        this._showAllDataSets = new JCheckBoxMenuItem("All Data Sets", false);
        this._showAllDataSets.setVerifyInputWhenFocusTarget(false);
        this.displayMenu.add(this._showAllDataSets);
        this.displayMenu.addSeparator();
        item = this.displayMenu.add(this._tabulateAction);
        item.setVerifyInputWhenFocusTarget(false);
        item.setMnemonic('T');
        item = this.displayMenu.add(this._plotAction);
        item.setVerifyInputWhenFocusTarget(false);
        item.setMnemonic('P');
        item = this.displayMenu.add(this._tabulateExcelAction);
        item.setVerifyInputWhenFocusTarget(false);
        item.setMnemonic('E');
        this.setJMenuBar(this._menuBar);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
    }

    protected void buildPanel() {
        JLabel label = new JLabel("Selected Data Set:");
        label.setDisplayedMnemonic('S');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this._contentPane.add((Component)label, gbc);
        this._dataSetsCB = new JComboBox();
        label.setLabelFor(this._dataSetsCB);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 5, 5, 5);
        this._contentPane.add((Component)this._dataSetsCB, gbc);
        this._tabbedPane = new MathJTabbedPane();
        this._tabbedPane.setVerifyInputWhenFocusTarget(false);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 3.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 0, 5, 0);
        this._contentPane.add((Component)this._tabbedPane, gbc);
        MathPanel tab = new SimpleMathTab(this);
        tab.setVerifyInputWhenFocusTarget(false);
        this._tabbedPane.addTab(tab.getTabName(), tab);
        tab = new GeneralTab(this);
        tab.setVerifyInputWhenFocusTarget(false);
        this._tabbedPane.addTab(tab.getTabName(), tab);
        tab = new TransformTab(this);
        tab.setVerifyInputWhenFocusTarget(false);
        this._tabbedPane.addTab(tab.getTabName(), tab);
        tab = new RoutingTab(this);
        tab.setVerifyInputWhenFocusTarget(false);
        this._tabbedPane.addTab(tab.getTabName(), tab);
        tab = new SmoothingTab(this);
        tab.setVerifyInputWhenFocusTarget(false);
        this._tabbedPane.addTab(tab.getTabName(), tab);
        tab = new StatisticMathTab(this);
        tab.setVerifyInputWhenFocusTarget(false);
        this._tabbedPane.addTab(tab.getTabName(), tab);
        this._dataSetsCB.addActionListener(this);
        this._tabbedPane.addChangeListener(this);
    }

    public void buildButtons() {
        JPanel computeButtonPanel = new JPanel();
        computeButtonPanel.setLayout(new FlowLayout(1, 20, 3));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this._contentPane.add((Component)computeButtonPanel, gbc);
        this._computeButton = new JButton("Compute");
        this._computeButton.setMnemonic('C');
        this._computeButton.setForeground(new Color(0, 0, 0));
        this._computeButton.setEnabled(false);
        this._computeButton.addActionListener(this);
        computeButtonPanel.add(this._computeButton);
        this._statusLineTxt = new AltTextLabel(" ");
        this._statusLineTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MathFrame2.this._statusLineTxt.setText(MathFrame2.this._statusLineTxt.getAltText());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MathFrame2.this._statusLineTxt.setText(MathFrame2.this._statusLineTxt.getName());
            }
        });
        this._statusLineTxt.setToolTipText("Message panel");
        this._statusLineTxt.setBorder(new EtchedBorder());
        this._statusLineTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (SwingUtilities.isLeftMouseButton(evt)) {
                    MathPanel panel = (MathPanel)MathFrame2.this._tabbedPane.getSelectedComponent();
                    if (panel == null) {
                        return;
                    }
                    JComponent comp = panel.getStatusLineComponent();
                    if (comp == null) {
                        return;
                    }
                    if (comp instanceof JLabel) {
                        comp = (JComponent)((JLabel)comp).getLabelFor();
                    }
                    if (comp == null) {
                        return;
                    }
                    comp.requestFocus();
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        this._contentPane.add((Component)this._statusLineTxt, gbc);
        this._toolBar = new JToolBar();
        FlatPanelButton button = new FlatPanelButton(this._saveAction);
        button.setToolTipText("Save");
        button.setText(null);
        Insets zeroInsets = new Insets(0, 0, 0, 0);
        button.setMargin(zeroInsets);
        button.setVerticalAlignment(1);
        this._toolBar.add((Component)button);
        button = new FlatPanelButton(this._saveAsAction);
        button.setToolTipText("Save As");
        button.setText(null);
        button.setMargin(zeroInsets);
        button.setVerticalAlignment(1);
        this._toolBar.add((Component)button);
        this._toolBar.addSeparator();
        button = new FlatPanelButton(this._plotAction);
        button.setToolTipText("Plot");
        button.setText(null);
        button.setMargin(zeroInsets);
        button.setVerticalAlignment(1);
        this._toolBar.add((Component)button);
        button = new FlatPanelButton(this._tabulateAction);
        button.setToolTipText("Tabulate");
        button.setText(null);
        button.setMargin(zeroInsets);
        button.setVerticalAlignment(1);
        this._toolBar.add((Component)button);
        button = new FlatPanelButton(this._tabulateExcelAction);
        button.setToolTipText("Tabulate in Excel");
        button.setText(null);
        button.setMargin(zeroInsets);
        button.setVerticalAlignment(1);
        this._toolBar.add((Component)button);
        this.getContentPane().add((Component)this._toolBar, "North");
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Object obj = event.getSource();
        if (obj == this._tabbedPane) {
            if (this._dataSetsCB.getSelectedIndex() == -1) {
                this._computeButton.setEnabled(false);
                return;
            }
            Component c = this._tabbedPane.getSelectedComponent();
            if (c instanceof MathTab) {
                MathTab mt = (MathTab)((Object)c);
                this._computeButton.setEnabled(mt.isComputable());
                mt.tabChangedTo();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this._computeButton) {
            this.compute();
        } else if ("setPairedDataCurve".equals(((Component)object).getName())) {
            this.setPairedDataCurve(((AbstractButton)object).getActionCommand());
        } else if (object == this._dataSetsCB) {
            DataContainer dc = (DataContainer)this._dataSetsCB.getSelectedItem();
            this._tabbedPane.setSelectedData(dc);
        } else if (object == this._restoreItem) {
            this.restoreData();
        }
    }

    protected void buildPairedDataMenu(PairedDataContainer pdc) {
        JCheckBoxMenuItem menuItem;
        int i;
        this._pairedDataMenu.removeAll();
        this._pairedDataMenu.setEnabled(pdc != null && pdc.yOrdinates != null);
        if (pdc == null || pdc.yOrdinates == null) {
            return;
        }
        ButtonGroup bg = new ButtonGroup();
        System.out.println("got " + pdc.yOrdinates.length + " y axis");
        for (i = 0; i < pdc.yOrdinates.length; ++i) {
            menuItem = pdc.labelsUsed && pdc.labels != null && pdc.labels[i] != null ? new JCheckBoxMenuItem(pdc.labels[i]) : new JCheckBoxMenuItem("" + (i + 1));
            if (pdc.yOrdinates.length == 1) {
                menuItem.setSelected(true);
            }
            bg.add(menuItem);
            menuItem.setActionCommand("" + i);
            menuItem.setName("setPairedDataCurve");
            menuItem.addActionListener(this);
            this._pairedDataMenu.add(menuItem);
        }
        if (i > 1) {
            menuItem = new JCheckBoxMenuItem("All");
            menuItem.setSelected(true);
            menuItem.setActionCommand("-1");
            menuItem.setName("setPairedDataCurve");
            menuItem.addActionListener(this);
            bg.add(menuItem);
            this._pairedDataMenu.add(menuItem);
        }
        this._pairedDataMenu.setEnabled(this._pairedDataMenu.getMenuComponentCount() > 0);
    }

    protected void compute() {
        Component c = this._tabbedPane.getSelectedComponent();
        if (!(c instanceof StatisticMathTab)) {
            this._computeButton.setEnabled(false);
        }
        boolean computeRv = false;
        if (c instanceof MathTab) {
            computeRv = ((MathTab)((Object)c)).compute();
        }
        if (computeRv) {
            this.setActionsEnabled(true);
            this.setStatusLineText("Compute Complete");
            if (c instanceof MathTab && ((MathTab)((Object)c)).canRestore()) {
                this._restoreItem.setEnabled(true);
                this.setModified(true);
            }
        } else {
            this.setStatusLineText("Compute Failed");
        }
    }

    public void setActionsEnabled(boolean enabled) {
        this._saveAction.setEnabled(enabled);
        this._saveAsAction.setEnabled(enabled);
    }

    public void setComputeButtonEnabled(boolean computable) {
        if (this._dataSetsCB.getSelectedIndex() < 0) {
            return;
        }
        this._computeButton.setEnabled(computable);
    }

    public MathPanel getSelectedTab() {
        return (MathPanel)this._tabbedPane.getSelectedComponent();
    }

    public JMenu getFileMenu() {
        return this._fileMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getDisplayMenu() {
        return this.displayMenu;
    }

    public void exitAction() {
        this.terminate();
    }

    protected void terminate() {
        this.setVisible(false);
        this._parent.closeMath();
    }

    public DataContainer getSelectedDataSet() {
        return (DataContainer)this._dataSetsCB.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this._dataSetsCB.getSelectedIndex();
    }

    public void setSelectedIndex(int indx) {
        int current = this._dataSetsCB.getSelectedIndex();
        if (current != indx) {
            this._dataSetsCB.setSelectedIndex(indx);
        }
    }

    public Vector getDataSets() {
        return this._dataSetVector;
    }

    public DataContainer[] getDataSets(int[] selection) {
        Vector v = new Vector(selection.length);
        for (int i = 0; i < selection.length; ++i) {
            int idx = selection[i];
            if (idx <= -1 || idx >= this._dataSetVector.size()) continue;
            v.add(this._dataSetVector.get(idx));
        }
        return v.toArray(new DataContainer[0]);
    }

    public ListSelection getListSelection() {
        return this._parent;
    }

    public void updateSelectedDataSet(DataContainer dc) {
        int idx = this._dataSetsCB.getSelectedIndex();
        if (idx == -1) {
            return;
        }
        dc.modified = true;
        this._dataSetVector.set(idx, dc);
        this._dataSetsCB.setSelectedIndex(idx);
        this._tabbedPane.updateSelectedDataSet(idx, dc);
    }

    public void updateDataSet(DataContainer updatedDc) {
        if (updatedDc == null) {
            return;
        }
        int idx = this._dataSetsCB.getSelectedIndex();
        for (int i = 0; i < this._dataSetVector.size(); ++i) {
            DataContainer dc = (DataContainer)this._dataSetVector.get(i);
            if (!dc.fullName.equals(updatedDc.fullName)) continue;
            this._dataSetVector.set(i, updatedDc);
            this._tabbedPane.setData(this._dataSetVector);
            this._dataSetsCB.setSelectedIndex(idx);
            updatedDc.modified = true;
            return;
        }
    }

    JComboBox getDataSetCombo() {
        return this._dataSetsCB;
    }

    protected void saveAction() {
        this.saveAction(this._dataSetVector);
    }

    protected void saveAction(Vector dataSets) {
        this.save(dataSets, false);
    }

    protected void saveAsAction() {
        this.save(this._dataSetVector, true);
    }

    protected void save(Vector dataSets, boolean saveAs) {
        DataContainer dc = null;
        boolean initialStateModified = this._dssFileModified;
        if (dataSets.size() == 1) {
            dc = (DataContainer)dataSets.get(0);
            if (dc.modified) {
                boolean success = saveAs ? this._parent.saveAs(dc) : this._parent.save(dc);
                if (success) {
                    this._dssFileModified = true;
                }
            } else {
                this.setModified(false);
            }
            this.toFront();
        } else {
            int size = dataSets.size();
            this._dataSetsToSave = new Vector(size);
            for (int i = 0; i < size; ++i) {
                dc = (DataContainer)dataSets.get(i);
                if (!dc.modified) continue;
                this._dataSetsToSave.add(dc);
                this._dssFileModified = true;
            }
            int saved = -1;
            if (saveAs) {
                if (this._parent.saveAs(this._dataSetsToSave)) {
                    saved = 0;
                }
            } else {
                saved = this._parent.save(this._dataSetsToSave);
            }
            if (saved == this._dataSetsToSave.size()) {
                this.setModified(false);
            }
        }
        if (this._forceCatalogUpdate && this._parent.getDataManager().numberRecords() < 10000) {
            this._parent.refreshCatalog();
            this._forceCatalogUpdate = false;
            if (!initialStateModified) {
                this._dssFileModified = false;
            }
        }
    }

    public void saveCompleted(Component parent, int status, int numberSaved, int numberAttempted) {
        if (parent == null) {
            parent = this;
        }
        if (status == 3) {
            String mess = "Save operation canceled";
            JOptionPane.showMessageDialog((Component)parent, mess, ListSelection._programName, 2);
            this.toFront();
        } else {
            Object mess;
            if (numberSaved == numberAttempted) {
                if (numberSaved == 1) {
                    if (this._dataSetsToSave != null && this._dataSetsToSave.size() == 1) {
                        DataContainer dc = (DataContainer)this._dataSetsToSave.elementAt(0);
                        mess = "Data set saved: " + dc.fullName;
                    } else {
                        mess = "Data set saved. ";
                    }
                } else {
                    mess = numberSaved + " data sets saved.";
                }
                if (this._forceCatalogUpdate && this._parent.getDataManager().numberRecords() < 10000) {
                    this._parent.refreshCatalog();
                    this._forceCatalogUpdate = false;
                }
            } else {
                if (numberSaved == -1) {
                    return;
                }
                mess = "Warning, " + numberSaved + " data sets of " + numberAttempted + " saved";
            }
            JOptionPane.showMessageDialog((Component)parent, mess, ListSelection._programName, 1);
            this._dssFileModified = true;
            this.toFront();
        }
    }

    protected void tabulateAction() {
        List[] v = new Vector[]{new Vector(), new Vector(), null, null};
        this.getDataSetsToDisplay((Vector[])v);
        this._parent.tabulate(v, false);
    }

    protected void plotAction() {
        List[] v = new Vector[]{new Vector(), new Vector(), null, null};
        this.getDataSetsToDisplay((Vector[])v);
        this._parent.plot(v);
    }

    protected void tabulateInExcel() {
        List[] v = new Vector[]{new Vector(), new Vector(), null, null};
        this.getDataSetsToDisplay((Vector[])v);
        HecDataTableToExcel excelTable = new HecDataTableToExcel();
        try {
            excelTable.runExcel(v);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.toString(), "", 2);
        }
    }

    protected G2dDialog plotFrequency(Vector containers) {
        return this._parent.plotFrequency(containers);
    }

    void getDataSetsToDisplay(Vector[] v) {
        DataContainer dc;
        int i;
        Vector dsVector;
        Vector originalDSVector = null;
        if (this._showAllDataSets.isSelected()) {
            dsVector = this._dataSetVector;
            originalDSVector = this._originalDataSetsList;
        } else {
            dsVector = this._tabbedPane.getSelectedDataSets();
            originalDSVector = this._originalDataSetsList;
        }
        for (i = 0; i < dsVector.size(); ++i) {
            dc = (DataContainer)dsVector.get(i);
            if (dc.modified) {
                TimeSeriesContainer dcCopy;
                if (dc instanceof TimeSeriesContainer) {
                    if (!dc.version.endsWith("MERGED")) {
                        dcCopy = new TimeSeriesContainer();
                        ((TimeSeriesContainer)dc).clone(dcCopy);
                        dcCopy.version = "MODIFIED-" + dcCopy.version;
                        v[0].add(dcCopy);
                    }
                } else if (dc instanceof PairedDataContainer && !dc.version.endsWith("MERGED")) {
                    dcCopy = new PairedDataContainer();
                    ((PairedDataContainer)dc).clone((PairedDataContainer)dcCopy);
                    dcCopy.version = "MODIFIED-" + dcCopy.version;
                    v[1].add(dcCopy);
                }
                if (!this._showOriginalData.isSelected() || i >= originalDSVector.size()) continue;
                dc = (DataContainer)originalDSVector.get(i);
                if (dc instanceof TimeSeriesContainer) {
                    v[0].add(dc);
                    continue;
                }
                if (!(dc instanceof PairedDataContainer)) continue;
                v[1].add(dc);
                continue;
            }
            if (!this._showAllDataSets.isSelected()) continue;
            if (dc instanceof TimeSeriesContainer) {
                v[0].add(dc);
                continue;
            }
            if (!(dc instanceof PairedDataContainer)) continue;
            v[1].add(dc);
        }
        if (v[0].size() == 0 && v[1].size() == 0) {
            dsVector = this._tabbedPane.getSelectedDataSets();
            for (i = 0; i < dsVector.size(); ++i) {
                dc = (DataContainer)dsVector.get(i);
                if (dc instanceof TimeSeriesContainer) {
                    v[0].add(dc);
                    continue;
                }
                if (!(dc instanceof PairedDataContainer)) continue;
                v[1].add(dc);
            }
        }
    }

    public Vector getModifiedDataSets() {
        Vector<DataContainer> mods = new Vector<DataContainer>();
        for (int i = 0; i < this._dataSetVector.size(); ++i) {
            DataContainer dc = (DataContainer)this._dataSetVector.get(i);
            if (!dc.modified) continue;
            mods.add(dc);
        }
        return mods;
    }

    protected void setPairedDataCurve(String idx) {
    }

    public boolean isModified() {
        for (int i = 0; i < this._dataSetVector.size(); ++i) {
            DataContainer dc = (DataContainer)this._dataSetVector.get(i);
            if (!dc.modified) continue;
            return true;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            Window w;
            if (this.isModified()) {
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Data has changed. Save Changes?", "Save Changes", 1);
                if (opt == 2) {
                    return;
                }
                if (opt == 0) {
                    this.saveAction();
                }
            }
            if (this._dssFileModified || this._forceCatalogUpdate) {
                if (this._parent instanceof ListSelection) {
                    ListSelection parent = this._parent;
                    parent.updateCatalog(this._forceCatalogUpdate);
                }
                this._dssFileModified = false;
            }
            if ((w = SwingUtilities.windowForComponent(this._toolBar)) != this && w != null) {
                w.setVisible(visible);
            }
        }
        super.setVisible(visible);
        if (visible) {
            MathPanel panel = (MathPanel)this._tabbedPane.getSelectedComponent();
            this.setComputeButtonEnabled(panel.isComputable());
            int act = MathFrame2.checkDataTypes((Component)((Object)this), this._dataSetVector);
            if (act < 0) {
                this.terminate();
            }
        }
    }

    public void setForceCatalogUpdate(boolean forceCatalogUpdate) {
        this._forceCatalogUpdate = forceCatalogUpdate;
    }

    public static int checkDataTypes(Component parent, Vector dataSetVector) {
        Vector<TimeSeriesContainer> tscVect = new Vector<TimeSeriesContainer>();
        Vector<String> types = new Vector<String>();
        for (int i = 0; i < dataSetVector.size(); ++i) {
            DataContainer dc = (DataContainer)dataSetVector.elementAt(i);
            if (!(dc instanceof TimeSeriesContainer) || !dc.fullName.startsWith("/")) continue;
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
            if (DssDataType.isValid((String)tsc.type)) continue;
            tsc.type.toUpperCase();
            if (DssDataType.isValid((String)tsc.type)) continue;
            tscVect.add(tsc);
            if (types.contains(tsc.type)) continue;
            types.add(tsc.type);
        }
        int retVal = 0;
        if (types.size() > 0) {
            for (int i = 0; i < types.size() && (retVal = ChangeDataType.showDialog(parent, types.elementAt(0).toString(), tscVect)) != -1 && retVal != 1; ++i) {
            }
        }
        return retVal;
    }

    public void setStatusLineText(String text) {
        this.setStatusLineText(text, text);
    }

    public void setStatusLineText(String text, String altText) {
        this._statusLineTxt.setText(text);
        this._statusLineTxt.setName(text);
        this._statusLineTxt.setAltText(altText);
    }

    protected void restoreData() {
        this.setData(this._originalDataSets);
        this.setModified(false);
    }

    private class MathJTabbedPane
    extends JTabbedPane {
        public void setData(Vector dataSets) {
            int cnt = this.getTabCount();
            for (int i = 0; i < cnt; ++i) {
                MathTab tab = (MathTab)((Object)this.getComponentAt(i));
                tab.setDataContainers(dataSets);
            }
        }

        public void updateSelectedDataSet(int idx, DataContainer dc) {
            int cnt = this.getTabCount();
            for (int i = 0; i < cnt; ++i) {
                MathTab tab = (MathTab)((Object)this.getComponentAt(i));
                tab.updateSelectedDataSet(idx, dc);
            }
        }

        public void setSelectedData(DataContainer dc) {
            int cnt = this.getTabCount();
            Component selObj = this.getSelectedComponent();
            for (int i = 0; i < cnt; ++i) {
                MathTab tab = (MathTab)((Object)this.getComponentAt(i));
                tab.setSelectedDataContainer(dc);
                if (tab != selObj) continue;
                MathFrame2.this.setComputeButtonEnabled(tab.isComputable());
            }
        }

        public Vector getSelectedDataSets() {
            int indx = this.getSelectedIndex();
            MathPanel tab = (MathPanel)this.getComponentAt(indx);
            return tab.getSelectedDataSets();
        }

        public int[] getSelectedIndices() {
            int indx = this.getSelectedIndex();
            MathPanel tab = (MathPanel)this.getComponentAt(indx);
            return tab.getSelectedIndices();
        }
    }

    private class SymWindow
    extends WindowAdapter {
        private SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == MathFrame2.this) {
                MathFrame2.this.exitAction();
            }
        }
    }

    private class AltTextLabel
    extends JLabel {
        private String _altText;

        AltTextLabel(String text) {
            super(text);
        }

        public String getAltText() {
            if (this._altText == null) {
                return this.getText();
            }
            return this._altText;
        }

        public void setAltText(String s) {
            this._altText = s;
        }

        @Override
        public String getToolTipText() {
            String txt = this.getText();
            if (txt.length() == 0 || txt.length() == 1) {
                return null;
            }
            return txt;
        }
    }

    public static class ChangeDataType {
        public static int showDialog(Component parent, String type, Vector containers) {
            String[] validTypes = DssDataType.getTimeSeriesTypes();
            String mess = "Warning - Unrecognized data type: " + type + "\nOperations on invalid types may produce incorrect results.";
            JOptionPane pane = new JOptionPane(mess, 2);
            Object[] options = new String[]{"OK", "Cancel", "Exit Math"};
            pane.setOptions(options);
            JPanel comboPanel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel("Change data type " + type + " to ");
            JComboBox<String> typeComboBox = new JComboBox<String>(validTypes);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 10, 0);
            gbc.ipadx = 0;
            gbc.ipady = 0;
            comboPanel.add((Component)label, gbc);
            gbc.gridx = 1;
            gbc.insets = new Insets(5, 0, 10, 0);
            comboPanel.add(typeComboBox, gbc);
            boolean isPer = false;
            if (type.indexOf("PER") > -1) {
                isPer = true;
            }
            boolean isCum = false;
            if (type.indexOf("CU") > -1) {
                isCum = true;
            }
            int idx = 0;
            if (!isPer) {
                idx = 2;
            }
            if (isCum) {
                ++idx;
            }
            typeComboBox.setSelectedIndex(idx);
            Component[] components = pane.getComponents();
            pane.remove(components[components.length - 1]);
            pane.add(comboPanel);
            pane.add(components[components.length - 1]);
            JDialog dialog = pane.createDialog(parent, "Unrecognized data type");
            dialog.setVisible(true);
            Object obj = pane.getValue();
            if (obj.equals(options[0])) {
                for (int i = 0; i < containers.size(); ++i) {
                    TimeSeriesContainer tsc = (TimeSeriesContainer)containers.elementAt(i);
                    if (!tsc.type.equals(type)) continue;
                    tsc.type = typeComboBox.getSelectedItem().toString();
                }
                return 0;
            }
            if (obj.equals(options[1])) {
                return 1;
            }
            return -1;
        }
    }
}

