/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ComputablePanel;
import hec.dssgui.MathFrame2;
import hec.dssgui.MathTab;
import hec.hecmath.PairedDataMath;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.RmaJList;
import rma.swing.RmaJRadioButton;
import rma.util.RMAIO;

public abstract class MathPanel
extends JPanel
implements MathTab {
    private JComponent _labelComp;
    private static final String[] QUALITY_FLAG_NAMES = new String[]{"Rejected", "Missing", "Questionable"};
    private static final String[] QUALITY_FLAG_CHARS = new String[]{"R", "M", "Q"};
    protected JPanel _cardPanel;
    protected MathFrame2 _parent;
    protected JLabel _opLabel;
    protected JComboBox _opCombo;
    protected Vector _dataContainers = null;
    protected TimeSeriesMath _tsmath = new TimeSeriesMath();
    protected PairedDataMath _pdmath = new PairedDataMath();

    public MathPanel(MathFrame2 parent) {
        super(new GridBagLayout());
        if (parent == null) {
            throw new NullPointerException("MathFrame2 parent cannot be null");
        }
        this._parent = parent;
        this.buildPanel();
    }

    protected void buildPanel() {
        this._opLabel = new JLabel("Operator:");
        this._opLabel.setDisplayedMnemonic('O');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this._opLabel, gbc);
        this._opCombo = new JComboBox();
        this._opCombo.setVerifyInputWhenFocusTarget(false);
        this._opLabel.setLabelFor(this._opCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this._opCombo, gbc);
        JSeparator sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)sep, gbc);
        this._cardPanel = new JPanel(new CardLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 16;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this._cardPanel, gbc);
    }

    public static String[] getQualityFlagList() {
        return QUALITY_FLAG_NAMES;
    }

    public static String getQualityFlagChar(String qualityFlagName) {
        if (qualityFlagName == null || qualityFlagName.length() == 0) {
            return "";
        }
        return qualityFlagName.substring(0, 1);
    }

    protected void setOpLabelText(String label, char mnemonic) {
        this._opLabel.setText(label);
        this._opLabel.setDisplayedMnemonic(mnemonic);
    }

    @Override
    public void setSelectedDataContainer(DataContainer dc) {
        int count = this._cardPanel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this._cardPanel.getComponent(i);
            if (!(c instanceof MathCardPanel)) continue;
            MathCardPanel mcp = (MathCardPanel)c;
            mcp.setSelectedDataContainer(dc);
        }
    }

    @Override
    public void updateSelectedDataSet(int idx, DataContainer dc) {
        int count = this._cardPanel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this._cardPanel.getComponent(i);
            if (!(c instanceof MathCardPanel)) continue;
            MathCardPanel mcp = (MathCardPanel)c;
            mcp.updateSelectedDataSet(idx, dc);
        }
    }

    public void setComputeButtonEnabled(boolean computable) {
        if (this._parent.getSelectedTab() == this) {
            this._parent.setComputeButtonEnabled(computable);
        }
    }

    @Override
    public void setDataContainers(Vector dcList) {
        int count = this._cardPanel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this._cardPanel.getComponent(i);
            if (!(c instanceof MathCardPanel)) continue;
            MathCardPanel mcp = (MathCardPanel)c;
            mcp.setDataContainers(dcList);
            if (!mcp.isVisible()) continue;
            this._parent.setComputeButtonEnabled(mcp.isComputable());
        }
    }

    public Vector getSelectedDataSets() {
        DataContainer dc = this._parent.getSelectedDataSet();
        Vector<DataContainer> v = new Vector<DataContainer>();
        v.add(dc);
        return v;
    }

    public int[] getSelectedIndices() {
        int[] sel = new int[]{this._parent.getSelectedIndex()};
        return sel;
    }

    @Override
    public boolean isComputable() {
        int cnt = this._cardPanel.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c = this._cardPanel.getComponent(i);
            if (!c.isVisible()) continue;
            if (!(c instanceof ComputablePanel)) break;
            return ((ComputablePanel)((Object)c)).isComputable();
        }
        return false;
    }

    public JComponent getStatusLineComponent() {
        return this._labelComp;
    }

    @Override
    public void tabChangedTo() {
    }

    @Override
    public boolean canRestore() {
        return true;
    }

    abstract class MathCardPanel
    extends JPanel
    implements ComputablePanel {
        private StringBuffer _buffer;
        private StringBuffer _buffer2;
        private JTabbedPane _tabbedPane;

        MathCardPanel() {
            super(new GridBagLayout());
            this._buffer = new StringBuffer(100);
            this._buffer2 = new StringBuffer(100);
        }

        protected abstract void buildPanel();

        @Override
        public abstract boolean isComputable();

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.setEnabled(this, b);
        }

        private void setEnabled(Container container, boolean enabled) {
            int cnt = container.getComponentCount();
            for (int i = 0; i < cnt; ++i) {
                Component c = container.getComponent(i);
                c.setEnabled(enabled);
                if (!(c instanceof Container)) continue;
                this.setEnabled((Container)c, enabled);
            }
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            if (b) {
                MathPanel.this._parent.setComputeButtonEnabled(this.isComputable());
            }
        }

        private void findEnclosingTabbedPane() {
            Container c;
            for (c = this.getParent(); c != null && !(c instanceof JTabbedPane); c = c.getParent()) {
            }
            if (c != null) {
                this._tabbedPane = (JTabbedPane)c;
            }
        }

        protected void setStatusLineText(String text) {
            this.setStatusLineText(text, text);
        }

        protected void setStatusLineText(String text, String text2) {
            if (text.length() == 0) {
                text = " ";
            }
            if (text2.length() == 0) {
                text2 = " ";
            }
            if (this._tabbedPane == null) {
                this.findEnclosingTabbedPane();
            }
            if (this.isVisible() && this._tabbedPane != null && this._tabbedPane.getSelectedComponent() == MathPanel.this) {
                MathPanel.this._parent.setStatusLineText(text, text2);
            }
        }

        protected void setStatusLineText(String pre, JComponent comp, String post) {
            MathPanel.this._labelComp = comp;
            if (this._buffer.length() > 0) {
                this._buffer.delete(0, this._buffer.length());
            }
            if (this._buffer2.length() > 0) {
                this._buffer2.delete(0, this._buffer2.length());
            }
            if (MathPanel.this._labelComp != null) {
                this._buffer.append("<html>");
                this._buffer2.append("<html>");
            }
            if (pre != null) {
                this._buffer.append(pre);
                this._buffer2.append(pre);
            }
            if (MathPanel.this._labelComp instanceof JLabel) {
                this._buffer.append("<Font=+0 Color=blue>");
                this._buffer2.append("<Font=+0 Color=blue><U>");
                JLabel label = (JLabel)MathPanel.this._labelComp;
                String s = RMAIO.removeChar((String)label.getText(), (char)':');
                this._buffer.append(s);
                this._buffer2.append(s);
                this._buffer.append("</Font>");
                this._buffer2.append("</U></Font>");
            } else if (MathPanel.this._labelComp instanceof AbstractButton) {
                this._buffer.append("<Font=+0 Color=blue>");
                this._buffer2.append("<Font=+0 Color=blue><U>");
                AbstractButton button = (AbstractButton)MathPanel.this._labelComp;
                String s = RMAIO.removeChar((String)button.getText(), (char)':');
                this._buffer.append(s);
                this._buffer2.append(s);
                this._buffer.append("</Font>");
                this._buffer2.append("</U></Font>");
            }
            if (post != null) {
                this._buffer.append(post);
                this._buffer2.append(post);
            }
            this.setStatusLineText(this._buffer.toString(), this._buffer2.toString());
        }

        protected void clearStatusLineText() {
            this.setStatusLineText("<html> </html>");
            MathPanel.this._labelComp = null;
        }

        public void setSelectedDataContainer(DataContainer dc) {
        }

        public void updateSelectedDataSet(int idx, DataContainer dc) {
        }

        public void setDataContainers(Vector v) {
        }

        class ComputeActionListener
        implements ActionListener {
            ComputeActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MathPanel.this.setComputeButtonEnabled(MathCardPanel.this.isComputable());
            }
        }

        class ComputeKeyListener
        extends KeyAdapter {
            ComputeKeyListener() {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MathPanel.this.setComputeButtonEnabled(MathCardPanel.this.isComputable());
            }
        }
    }

    public class DataSetListPanel
    extends MathCardPanel
    implements ActionListener {
        protected RmaJRadioButton _singleRB;
        protected RmaJRadioButton _multipleRB;
        protected JButton _selectAllButton;
        protected RmaJList _dataSetList;
        protected JScrollPane _scrollPane;

        public DataSetListPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._singleRB = new RmaJRadioButton("Single Selected Data Set (above)", true);
            this._singleRB.setMnemonic('s');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._singleRB, gbc);
            this._multipleRB = new RmaJRadioButton("Multiple Selected Data Sets (below)");
            this._multipleRB.setMnemonic('m');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._multipleRB, gbc);
            this._dataSetList = new RmaJList(){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    return d;
                }
            };
            this._dataSetList.setSelectionMode(2);
            this._selectAllButton = new JButton("Select All");
            this._selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] idx = new int[DataSetListPanel.this._dataSetList.getItemCount()];
                    for (int i = 0; i < DataSetListPanel.this._dataSetList.getItemCount(); ++i) {
                        idx[i] = i;
                    }
                    DataSetListPanel.this._dataSetList.setSelectedIndices(idx);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 4, 5);
            this.add((Component)this._selectAllButton, gbc);
            this._scrollPane = new JScrollPane((Component)this._dataSetList);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 5, 5);
            this.add((Component)this._scrollPane, gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._singleRB);
            bg.add((AbstractButton)this._multipleRB);
            this._singleRB.addActionListener((ActionListener)this);
            this._multipleRB.addActionListener((ActionListener)this);
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this._singleRB.doClick();
            }
            super.setVisible(b);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._singleRB.isSelected()) {
                this._dataSetList.clearSelection();
                this._dataSetList.setEnabled(false);
                this._selectAllButton.setEnabled(false);
            } else if (this._multipleRB.isSelected()) {
                this._dataSetList.setEnabled(true);
                this._selectAllButton.setEnabled(true);
            }
        }

        @Override
        public void setDataContainers(Vector containers) {
            if (containers == null) {
                this._dataSetList.setListData((Vector)null);
                this.setMultiplePanelVisible(false);
                return;
            }
            DefaultListModel newModel = new DefaultListModel();
            for (int i = 0; i < containers.size(); ++i) {
                newModel.addElement(containers.get(i));
            }
            this._dataSetList.setModel(newModel);
            if (containers.size() <= 1) {
                this.setMultiplePanelVisible(false);
            }
        }

        public void setMultiplePanelVisible(boolean visible) {
            this._singleRB.setVisible(visible);
            this._multipleRB.setVisible(visible);
            this._scrollPane.setVisible(visible);
            this._selectAllButton.setVisible(visible);
        }

        @Override
        public boolean isComputable() {
            this.setStatusLineText("");
            return true;
        }

        public DataContainer getSelectedDataContainer() {
            if (this._multipleRB.isSelected()) {
                return (DataContainer)this._dataSetList.getSelectedValue();
            }
            return null;
        }

        public RmaJList getDataSetList() {
            return this._dataSetList;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            boolean enabled = true;
            this._multipleRB.setEnabled(enabled);
            this._dataSetList.setEnabled(enabled);
            this._selectAllButton.setEnabled(enabled);
            if (!enabled && this._multipleRB.isSelected()) {
                this._singleRB.doClick();
            }
        }

        public int[] getSelectedIndices() {
            if (this._singleRB.isSelected()) {
                int[] sel = new int[]{MathPanel.this._parent.getSelectedIndex()};
                return sel;
            }
            if (this._dataSetList.getSelectedIndex() < 0) {
                int number = this._dataSetList.getItemCount();
                int[] selected = new int[number];
                for (int i = 0; i < number; ++i) {
                    selected[i] = i;
                }
                return selected;
            }
            return this._dataSetList.getSelectedIndices();
        }

        public void setSelectedIndices(int[] selected) {
            this._dataSetList.setSelectedIndices(selected);
        }

        public Vector getSelectedDataSets() {
            Vector<Object> v;
            block3: {
                block4: {
                    block2: {
                        v = new Vector<Object>();
                        if (!this._singleRB.isSelected()) break block2;
                        DataContainer dc = MathPanel.this._parent.getSelectedDataSet();
                        v.add(dc);
                        break block3;
                    }
                    if (this._dataSetList.getSelectedIndex() >= 0) break block4;
                    for (int i = 0; i < this._dataSetList.getItemCount(); ++i) {
                        v.add(this._dataSetList.getValueAt(i));
                    }
                    break block3;
                }
                int[] indicies = this._dataSetList.getSelectedIndices();
                if (indicies == null) break block3;
                for (int i = 0; i < indicies.length; ++i) {
                    v.add(this._dataSetList.getValueAt(indicies[i]));
                }
            }
            return v;
        }

        @Override
        public void updateSelectedDataSet(int idx, DataContainer dc) {
            DefaultListModel model = (DefaultListModel)this._dataSetList.getModel();
            model.set(idx, dc);
        }
    }

    public class MultipleDataSetListPanel
    extends DataSetListPanel {
        @Override
        protected void buildPanel() {
            this._multipleRB = new RmaJRadioButton();
            this._singleRB = new RmaJRadioButton();
            this._multipleRB.setSelected(true);
            this._singleRB.setSelected(false);
            this._dataSetList = new RmaJList(){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    return d;
                }
            };
            this._dataSetList.setSelectionMode(2);
            this._selectAllButton = new JButton("Select All");
            this._selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] idx = new int[MultipleDataSetListPanel.this._dataSetList.getItemCount()];
                    for (int i = 0; i < MultipleDataSetListPanel.this._dataSetList.getItemCount(); ++i) {
                        idx[i] = i;
                    }
                    MultipleDataSetListPanel.this._dataSetList.setSelectedIndices(idx);
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 4, 5);
            this.add((Component)this._selectAllButton, gbc);
            this._scrollPane = new JScrollPane((Component)this._dataSetList);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 5, 5);
            this.add((Component)this._scrollPane, gbc);
        }

        @Override
        public int[] getSelectedIndices() {
            if (this._dataSetList.getSelectedIndex() < 0) {
                int number = this._dataSetList.getItemCount();
                int[] selected = new int[number];
                for (int i = 0; i < number; ++i) {
                    selected[i] = i;
                }
                return selected;
            }
            return this._dataSetList.getSelectedIndices();
        }
    }

    public class DataSetListPanelTS
    extends DataSetListPanel {
        @Override
        public boolean isComputable() {
            boolean canCompute = true;
            for (int i = 0; i < this._dataSetList.getItemCount(); ++i) {
                Object obj = this._dataSetList.getValueAt(i);
                if (obj instanceof TimeSeriesContainer) continue;
                canCompute = false;
            }
            if (canCompute) {
                this.setStatusLineText("");
                return true;
            }
            this.setStatusLineText("Data is not Time Series");
            return false;
        }
    }

    class DataSetPanel
    extends MathCardPanel {
        protected Class _containerClass = PairedDataContainer.class;
        protected Class _selectedContainerClass = TimeSeriesContainer.class;
        protected boolean _showSelectedContainer = true;
        protected RmaJList _dataSetList;
        protected JLabel _dataSetLabel;
        protected JScrollPane _dataSetScrollPane;

        DataSetPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._dataSetLabel = new JLabel("Data Set");
            this._dataSetLabel.setDisplayedMnemonic('D');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._dataSetLabel, gbc);
            this._dataSetList = new RmaJList(){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    return d;
                }
            };
            this._dataSetLabel.setLabelFor((Component)this._dataSetList);
            this._dataSetList.setSelectionMode(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this._dataSetScrollPane = new JScrollPane((Component)this._dataSetList);
            this.add((Component)this._dataSetScrollPane, gbc);
            this._dataSetList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DataSetPanel.this.dataSetListSelectionChanged(DataSetPanel.this.getSelectedDataContainer());
                    MathPanel.this.setComputeButtonEnabled(DataSetPanel.this.isComputable());
                }
            });
        }

        public void setDataSetLabel(String label, char mnemonic) {
            if (label == null) {
                this._dataSetLabel.setText("");
            } else {
                this._dataSetLabel.setText(label);
            }
            if (mnemonic != '\u0000') {
                this._dataSetLabel.setDisplayedMnemonic(mnemonic);
            }
        }

        public void setShowSelectedContainer(boolean show) {
            this._showSelectedContainer = show;
        }

        @Override
        public boolean isComputable() {
            boolean b;
            if (!this.isEnabled()) {
                this.setStatusLineText("Selected Data Set not a " + (this._selectedContainerClass.equals(TimeSeriesContainer.class) ? "Time Series" : "Paired Data"));
                return false;
            }
            boolean bl = b = this._dataSetList.getSelectedIndex() > -1;
            if (!b) {
                this.setStatusLineText("No ", this._dataSetLabel, " selected");
            } else {
                this.clearStatusLineText();
            }
            return b;
        }

        public void dataSetListSelectionChanged(DataContainer dc) {
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            if (b) {
                MathPanel.this.setComputeButtonEnabled(this.isComputable());
            }
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc != null) {
                boolean enabled = this._selectedContainerClass == null || dc.getClass().isAssignableFrom(this._selectedContainerClass);
                this.setEnabled(enabled);
                if (!enabled) {
                    this.setStatusLineText("Selected Data Set not a " + (this._selectedContainerClass.equals(TimeSeriesContainer.class) ? "Time Series" : "Paired Data"));
                } else {
                    if (!this._showSelectedContainer) {
                        this.setDataContainers(MathPanel.this._parent.getDataSets());
                    }
                    this.clearStatusLineText();
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void setListClassType(Class cls) {
            this._containerClass = cls;
        }

        public void setSelectedClassType(Class cls) {
            this._selectedContainerClass = cls;
        }

        @Override
        public void setDataContainers(Vector containers) {
            if (containers == null) {
                this._dataSetList.setListData((Vector)null);
                return;
            }
            int[] sel = this._dataSetList.getSelectedIndices();
            int count = this._dataSetList.getComponentCount();
            DefaultListModel newModel = new DefaultListModel();
            for (int i = 0; i < containers.size(); ++i) {
                newModel.addElement(containers.get(i));
            }
            this._dataSetList.setModel(newModel);
            if (containers.size() <= 1) {
                // empty if block
            }
            if (count == containers.size() && sel != null && sel.length > 0 && this._showSelectedContainer) {
                this._dataSetList.setSelectedIndices(sel);
            }
            if (containers.size() == 1) {
                this._dataSetList.setSelectedIndex(0);
            }
        }

        public DataContainer getSelectedDataContainer() {
            return (DataContainer)this._dataSetList.getSelectedValue();
        }
    }

    abstract class MathCardListPanel
    extends MathCardPanel {
        protected DataSetListPanel _dataSetListPanel;

        MathCardListPanel() {
            this._dataSetListPanel = new DataSetListPanel();
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this._dataSetListPanel.setVisible(b);
        }

        @Override
        public void setDataContainers(Vector containers) {
            this._dataSetListPanel.setDataContainers(containers);
        }

        @Override
        public void updateSelectedDataSet(int idx, DataContainer dc) {
            this._dataSetListPanel.updateSelectedDataSet(idx, dc);
        }

        public int[] getSelectedIndices() {
            return this._dataSetListPanel.getSelectedIndices();
        }

        public void setSelectedIndices(int[] selected) {
            this._dataSetListPanel.setSelectedIndices(selected);
        }

        public Vector getSelectedDataSets() {
            return this._dataSetListPanel.getSelectedDataSets();
        }

        public RmaJList getDataSetList() {
            return this._dataSetListPanel.getDataSetList();
        }
    }
}

