/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.heclib.dss.HecDataManager;
import hec.heclib.util.Heclib;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

public class MessageLevelDialog
extends RmaJDialog {
    private static final long serialVersionUID = 1L;
    protected Vector<String> _levels = new Vector(7);
    protected Vector<String> _functionList = new Vector(18);
    protected int[] _functionLevel = new int[18];
    protected JTable table = new JTable();
    protected MethodTableModel tableModel;
    protected boolean initialized = false;
    protected int[] _originalLevels = new int[18];
    List<Method> listMethod = new ArrayList<Method>();
    List<Level> listLevel = new ArrayList<Level>();
    Color red = new Color(220, 0, 0, 255);
    Color orange = new Color(220, 160, 0, 255);

    public MessageLevelDialog(Frame parent) {
        super(parent, false);
        this.listLevel.add(new Level(" None", 0));
        this.listLevel.add(new Level(" Only Critical", 1));
        this.listLevel.add(new Level(" Terse", 2));
        this.listLevel.add(new Level(" Normal", 3));
        this.listLevel.add(new Level(" User Diagnostics", 4));
        this.listLevel.add(new Level(" Interal Diagnostics 1", 5));
        this.listLevel.add(new Level(" Interal Diagnostics 2", 6));
        this.listMethod.add(new Method(" Global (DSS-6 and DSS-7)", new Level()));
        this.listMethod.add(new Method(" General (DSS-7 only)", new Level()));
        this.listMethod.add(new Method(" Low level Get", new Level()));
        this.listMethod.add(new Method(" Low level Put", new Level()));
        this.listMethod.add(new Method(" Read", new Level()));
        this.listMethod.add(new Method(" Write", new Level()));
        this.listMethod.add(new Method(" File Creation", new Level()));
        this.listMethod.add(new Method(" Open", new Level()));
        this.listMethod.add(new Method(" Record Check", new Level()));
        this.listMethod.add(new Method(" Locking", new Level()));
        this.listMethod.add(new Method(" Time Series Read", new Level()));
        this.listMethod.add(new Method(" Time Series Write", new Level()));
        this.listMethod.add(new Method(" Alias", new Level()));
        this.listMethod.add(new Method(" Copy", new Level()));
        this.listMethod.add(new Method(" Utility", new Level()));
        this.listMethod.add(new Method(" Catalog", new Level()));
        this.listMethod.add(new Method(" Integrity Check", new Level()));
        this.listMethod.add(new Method(" Java Native Interface", new Level()));
        for (int i = 0; i < this._originalLevels.length; ++i) {
            this._originalLevels[i] = 3;
        }
        this.tableModel = new MethodTableModel(this.listMethod);
        this.table.setModel(this.tableModel);
        this.table.setDefaultRenderer(Level.class, new LevelCellRenderer());
        this.table.setDefaultEditor(Level.class, new LevelCellEditor(this.listLevel));
        this.table.setRowHeight(22);
        JScrollPane scrollpane = new JScrollPane(this.table);
        this.add(scrollpane, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton button = new JButton("Reset All");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 16;
        gbc.insets = RmaInsets.INSETS5555;
        panel.add((Component)button, gbc);
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 14;
        gbc.insets = RmaInsets.INSETS5555;
        panel.add((Component)cmdPanel, gbc);
        this.add(panel, "South");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageLevelDialog.this.resetAll();
            }
        });
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        MessageLevelDialog.this.okayButton();
                        break;
                    }
                    case 4: {
                        MessageLevelDialog.this.cancelButton();
                    }
                }
            }
        });
        this.setTitle("Set DSS Functions Message Level");
        this.pack();
        this.setPreferredSize(new Dimension(400, 800));
        this.setLocation(100, 100);
    }

    public void setVisible(boolean visible) {
        if (!this.initialized) {
            this.initialize();
        }
        super.setVisible(visible);
    }

    public void initialize() {
        for (int i = 0; i < this._originalLevels.length; ++i) {
            this._originalLevels[i] = Heclib.zgetMessageLevel((int)i);
        }
        this.initialized = true;
        this.setState();
    }

    protected void setState() {
        int size = this._originalLevels.length;
        if (this.listMethod.size() < size) {
            size = this.listMethod.size();
        }
        for (int i = 0; i < size; ++i) {
            Method method = this.listMethod.get(i);
            Level level = method.getLevel();
            level.setLevel(this._originalLevels[i]);
        }
    }

    protected void resetAll() {
        for (int i = 0; i < this.listMethod.size(); ++i) {
            Method method = this.listMethod.get(i);
            Level level = method.getLevel();
            level.setLevel(3);
        }
        this.setState();
        this.repaint();
    }

    protected void okayButton() {
        int opt;
        int i;
        this.stopEditing();
        int[] levels = new int[this._originalLevels.length];
        for (int i2 = 0; i2 < levels.length; ++i2) {
            levels[i2] = -1;
        }
        int size = this._originalLevels.length;
        if (this.listMethod.size() < size) {
            size = this.listMethod.size();
        }
        for (i = 0; i < size; ++i) {
            Method method = this.listMethod.get(i);
            Level level = method.getLevel();
            int newLevel = level.getLevel();
            if (newLevel == this._originalLevels[i]) continue;
            levels[i] = newLevel;
        }
        if ((levels[0] == 0 || levels[1] == 0) && (opt = JOptionPane.showOptionDialog((Component)((Object)this), "Caution - Setting the Global Message Level to NONE will not allow ANY error messages to be shown.\nAre you sure you want to do this?", "Set Message Level", 0, 2, null, null, null)) == 1) {
            return;
        }
        for (i = 0; i < size; ++i) {
            if (levels[i] == -1) continue;
            HecDataManager.zsetMessageLevel((int)i, (int)levels[i]);
        }
        this.cancelButton();
    }

    protected void cancelButton() {
        this.setVisible(false);
        this.dispose();
    }

    protected void stopEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected class Level {
        protected String name;
        protected int levelNumber;

        public Level(String name, int number) {
            this.name = name;
            this.levelNumber = number;
        }

        public Level() {
            this.setName(" Normal");
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            for (int i = 0; i < MessageLevelDialog.this.listLevel.size(); ++i) {
                Level l = MessageLevelDialog.this.listLevel.get(i);
                if (!name.trim().contains(l.getName().trim())) continue;
                this.levelNumber = l.getLevel();
                break;
            }
        }

        public String toString() {
            return this.name;
        }

        public int getLevel() {
            return this.levelNumber;
        }

        public void setLevel(int levelNumber) {
            this.levelNumber = levelNumber;
            Level l = MessageLevelDialog.this.listLevel.get(levelNumber);
            this.name = l.getName();
        }
    }

    protected class Method {
        protected String name;
        protected Level level;

        public Method(String name, Level level) {
            this.name = name;
            this.level = level;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Level getLevel() {
            return this.level;
        }

        public void setLevel(Level level) {
            this.level = level;
        }
    }

    protected class MethodTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Function", "Message Level"};
        private List<Method> listMethod = new ArrayList<Method>();

        public MethodTableModel(List<Method> listMethod) {
            this.listMethod.addAll(listMethod);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        @Override
        public int getRowCount() {
            return this.listMethod.size();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Method person = this.listMethod.get(rowIndex);
            if (columnIndex == 1) {
                person.setLevel((Level)value);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object returnValue = null;
            Method person = this.listMethod.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    returnValue = person.getName();
                    break;
                }
                case 1: {
                    returnValue = person.getLevel();
                }
            }
            return returnValue;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }
    }

    public class LevelCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Level) {
                Level level = (Level)value;
                this.setText(level.getName());
                if (level.getLevel() < 2) {
                    this.setForeground(MessageLevelDialog.this.red);
                } else if (level.getLevel() > 4) {
                    this.setForeground(MessageLevelDialog.this.orange);
                } else {
                    this.setForeground(Color.BLACK);
                }
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getSelectionForeground());
            }
            return this;
        }
    }

    public class LevelCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private Level level;
        private List<Level> listLevel;

        public LevelCellEditor(List<Level> listLevel) {
            this.listLevel = listLevel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.level;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Level) {
                this.level = (Level)value;
            }
            JComboBox<Level> comboLevel = new JComboBox<Level>();
            for (Level aLevel : this.listLevel) {
                comboLevel.addItem(aLevel);
            }
            comboLevel.setSelectedItem(this.level);
            comboLevel.addActionListener(this);
            if (isSelected) {
                comboLevel.setBackground(table.getSelectionBackground());
            } else {
                comboLevel.setBackground(table.getSelectionForeground());
            }
            return comboLevel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox comboLevel = (JComboBox)event.getSource();
            this.level = (Level)comboLevel.getSelectedItem();
        }
    }
}

