/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.SaveAs;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeriesBase;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JPanel;
import rma.swing.RmaJComboBox;

public class NewPartsDialog
extends SaveAs {
    protected Vector _pathnames = null;
    protected boolean OKPressed;
    protected boolean _timeSeriesData = false;
    protected String[] parts = new String[6];

    public NewPartsDialog(String title, Vector pathNames) {
        this(null, title, pathNames);
    }

    public NewPartsDialog(Frame parent, String title, Vector pathnames) {
        super(parent);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i] = "";
        }
        this._pathnames = pathnames;
        this.setPathnames(pathnames);
        this.setTitle(title);
        this.setSize(600, 200);
        this.OKPressed = false;
        this.setModal(true);
    }

    @Override
    protected void buildFilePanel() {
        this.filePanel = new JPanel();
        this._fileComboBox = new RmaJComboBox();
    }

    protected void setPathnames(Vector pathnames) {
        int[] partPositions = new int[7];
        String part = new String();
        for (int i = 0; i < pathnames.size(); ++i) {
            String pathname = (String)pathnames.elementAt(i);
            int stat = DSSPathname.parsePathname((String)pathname, (int[])partPositions);
            if (stat != 0) continue;
            for (int j = 0; j < 6; ++j) {
                int interval;
                int length = partPositions[j + 1] - partPositions[j];
                part = length > 0 ? pathname.substring(partPositions[j], partPositions[j + 1] - 1) : "";
                if (!this._timeSeriesData && j == 4 && (interval = HecTimeSeriesBase.getIntervalFromEPart((String)part)) >= 0 && (length = partPositions[4] - partPositions[3]) == 9) {
                    this._timeSeriesData = true;
                }
                if (i == 0) {
                    this.parts[j] = part;
                    continue;
                }
                if (part.equals(this.parts[j])) continue;
                this.parts[j] = "*";
            }
        }
        this._path = new DSSPathname();
        this._path.setAPart(this.parts[0]);
        this._path.setBPart(this.parts[1]);
        this._path.setCPart(this.parts[2]);
        this._path.setDPart(this.parts[3]);
        this._path.setEPart(this.parts[4]);
        this._path.setFPart(this.parts[5]);
        if (this._timeSeriesData) {
            this.disablePart("D");
            this.disablePart("E");
        }
        this.setText();
    }

    protected void setTextx() {
        this.APartTextField.setText(this.parts[0]);
        this.BPartTextField.setText(this.parts[1]);
        this.CPartTextField.setText(this.parts[2]);
        this.DPartTextField.setText(this.parts[3]);
        this.EPartTextField.setText(this.parts[4]);
        this.FPartTextField.setText(this.parts[5]);
        this.pathnameTextField.setText(this._path.pathname());
        this.validate();
    }

    @Override
    protected void OKButton_ActionPerformed(ActionEvent event) {
        this.OKPressed = true;
        this.setVisible(false);
    }

    public Vector getNewPathnames() {
        if (!this.OKPressed) {
            return null;
        }
        Vector<String> newPathnames = new Vector<String>();
        boolean aSet = false;
        boolean bSet = false;
        boolean cSet = false;
        boolean dSet = false;
        boolean eSet = false;
        boolean fSet = false;
        if (!this.parts[0].equals(this.APartTextField.getText()) && !this.APartTextField.getText().equals("*")) {
            aSet = true;
            this.parts[0] = this.APartTextField.getText();
        }
        if (!this.parts[1].equals(this.BPartTextField.getText()) && !this.BPartTextField.getText().equals("*")) {
            bSet = true;
            this.parts[1] = this.BPartTextField.getText();
        }
        if (!this.parts[2].equals(this.CPartTextField.getText()) && !this.CPartTextField.getText().equals("*")) {
            cSet = true;
            this.parts[2] = this.CPartTextField.getText();
        }
        if (!this.parts[3].equals(this.DPartTextField.getText()) && !this.DPartTextField.getText().equals("*")) {
            dSet = true;
            this.parts[3] = this.DPartTextField.getText();
        }
        if (!this.parts[4].equals(this.EPartTextField.getText()) && !this.EPartTextField.getText().equals("*")) {
            eSet = true;
            this.parts[4] = this.EPartTextField.getText();
        }
        if (!this.parts[5].equals(this.FPartTextField.getText()) && !this.FPartTextField.getText().equals("*")) {
            fSet = true;
            this.parts[5] = this.FPartTextField.getText();
        }
        this.setText();
        newPathnames.removeAllElements();
        for (int i = 0; i < this._pathnames.size(); ++i) {
            DSSPathname path = new DSSPathname((String)this._pathnames.elementAt(i));
            if (aSet) {
                path.setAPart(this.parts[0]);
            }
            if (bSet) {
                path.setBPart(this.parts[1]);
            }
            if (cSet) {
                path.setCPart(this.parts[2]);
            }
            if (dSet) {
                path.setDPart(this.parts[3]);
            }
            if (eSet) {
                path.setEPart(this.parts[4]);
            }
            if (fSet) {
                path.setFPart(this.parts[5]);
            }
            newPathnames.add(path.pathname());
        }
        return newPathnames;
    }

    @Override
    protected void CancelButton_ActionPerformed(ActionEvent event) {
        this.setVisible(false);
    }
}

