/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.Help;
import hec.dssgui.ListSelection;
import hec.dssgui.PairedDataEntryPanel;
import hec.heclib.dss.DssDataManager;
import hec.io.PairedDataContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;

public class PairedDataEntry
extends RmaJFrame {
    protected DssDataManager _dataManager = null;
    protected Frame _parent = null;
    protected JPanel buttonPanel;
    protected JButton plotButton;
    protected JButton saveButton;
    protected JButton CancelButton;
    protected boolean fComponentsAdjusted = false;
    private PairedDataEntryPanel _pairedDataPanel;

    public PairedDataEntry(Frame parent, DssDataManager dataManager) {
        this._parent = parent;
        this._dataManager = dataManager;
        this.setup();
    }

    public void setup() {
        this.setTitle("Manual Paired Data Entry");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(500, 700);
        this.build();
    }

    protected void build() {
        this._pairedDataPanel = new PairedDataEntryPanel(this, this._parent, this._dataManager);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)((Object)this._pairedDataPanel), gbc);
        this.buildOKButtonPanel();
        this.registerListeners();
        Help.setHelp((RootPaneContainer)((Object)this), "33");
    }

    public void setData(PairedDataContainer pairedDataContainer) {
        this._pairedDataPanel.setData(pairedDataContainer);
    }

    public void setPathname(String pathname) {
        this._pairedDataPanel.setPathname(pathname);
    }

    protected void buildOKButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.buttonPanel, gbc);
        this.getContentPane().add(this.buttonPanel);
        this.plotButton = new JButton();
        this.plotButton.setText("Plot");
        this.plotButton.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(36, 0, 16, 0);
        gbc.ipadx = 40;
        gbc.ipady = 3;
        ((GridBagLayout)this.buttonPanel.getLayout()).setConstraints(this.plotButton, gbc);
        this.buttonPanel.add(this.plotButton);
        this.saveButton = new JButton();
        this.saveButton.setText("Save");
        this.saveButton.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(36, 30, 16, 0);
        gbc.ipadx = 40;
        gbc.ipady = 3;
        ((GridBagLayout)this.buttonPanel.getLayout()).setConstraints(this.saveButton, gbc);
        this.buttonPanel.add(this.saveButton);
        this.CancelButton = new JButton();
        this.CancelButton.setText("Cancel");
        this.CancelButton.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(36, 30, 16, 0);
        gbc.ipadx = 40;
        gbc.ipady = 3;
        ((GridBagLayout)this.buttonPanel.getLayout()).setConstraints(this.CancelButton, gbc);
        this.buttonPanel.add(this.CancelButton);
    }

    protected void registerListeners() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.plotButton.addActionListener(lSymAction);
        this.CancelButton.addActionListener(lSymAction);
        this.saveButton.addActionListener(lSymAction);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this._parent);
        }
        super.setVisible(b);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public void setCheckDataAlreadyExists(boolean checkDataAlreadyExists) {
        this._pairedDataPanel.setCheckDataAlreadyExists(checkDataAlreadyExists);
    }

    void OKButton_ActionPerformed(ActionEvent event) {
        boolean status = this.saveData();
        if (status) {
            this.setVisible(false);
            boolean dataSaved = this._pairedDataPanel._dataSaved;
            if (dataSaved && this._parent instanceof ListSelection) {
                ListSelection parent = (ListSelection)this._parent;
                parent.updateCatalog();
            }
        }
    }

    public boolean saveData() {
        return this._pairedDataPanel.saveData();
    }

    void CancelButton_ActionPerformed(ActionEvent event) {
        this.setVisible(false);
        boolean dataSaved = this._pairedDataPanel._dataSaved;
        if (dataSaved && this._parent instanceof ListSelection) {
            ListSelection parent = (ListSelection)this._parent;
            parent.updateCatalog();
        }
    }

    void JFrame1_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == PairedDataEntry.this) {
                PairedDataEntry.this.JFrame1_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == PairedDataEntry.this.saveButton) {
                PairedDataEntry.this.OKButton_ActionPerformed(event);
            } else if (object == PairedDataEntry.this.CancelButton) {
                PairedDataEntry.this.CancelButton_ActionPerformed(event);
            } else if (object == PairedDataEntry.this.plotButton) {
                PairedDataEntry.this._pairedDataPanel.plotButton_ActionPerformed(event);
            }
        }
    }
}

