/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.BasePathnameTableModel;
import hec.dssgui.ListSelection;
import hec.dssgui.NoPathnamesTableModel;
import hec.dssgui.ObservableClass;
import hec.heclib.dss.DSSPathname;
import hec.util.ElapsedTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PathnameFilterPanel
extends JPanel {
    JPanel pathnameSearchPanel = new JPanel();
    JPanel partsSearchPanel = new JPanel();
    JComboBox[] _partsComboBox = new JComboBox[6];
    Vector[] _partsComboList = new Vector[6];
    Map<Integer, Vector> _previousPartListMap = new HashMap<Integer, Vector>();
    LinkedList<Integer> _previousPartSelected = new LinkedList();
    protected ObservableClass _observer;
    BasePathnameTableModel _tableModel;
    Insets _insets0000 = new Insets(0, 0, 0, 0);
    Insets _insets0400 = new Insets(0, 4, 0, 0);
    Insets _insets01500 = new Insets(0, 15, 0, 0);
    JTextField searchString = new JTextField();
    JButton jButtonSearchParts = new JButton("Search");
    JButton jButtonSearchString = new JButton("Search");
    protected JLabel labelA;
    protected JLabel labelB;
    protected JLabel labelC;
    protected JLabel labelD;
    protected JLabel labelE;
    protected JLabel labelF;
    boolean _searchByParts;
    String _programName;

    public PathnameFilterPanel(String programName) {
        this._programName = programName;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        for (int i = 0; i < 6; ++i) {
            this._partsComboList[i] = new Vector();
            this._partsComboList[i].addElement("");
            this._partsComboBox[i] = new JComboBox(this._partsComboList[i]);
            this._partsComboBox[i].setEditable(false);
            this._partsComboBox[i].setAlignmentX(0.0f);
        }
        this.buildFilterPanel();
        this.addListeners();
        this._observer = new ObservableClass();
    }

    protected void buildFilterPanel() {
        this.setForeground(new Color(0, 0, 0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.pathnameSearchPanel.setLayout(gridBagLayout);
        this.pathnameSearchPanel.setForeground(new Color(0));
        final JLabel searchPathnameLabel = new JLabel("Search Pathnames:");
        Font labelFont = searchPathnameLabel.getFont();
        Font smallBoldFont = new Font(labelFont.getName(), 1, labelFont.getSize() - 1);
        searchPathnameLabel.setDisplayedMnemonic('P');
        searchPathnameLabel.setFont(smallBoldFont);
        searchPathnameLabel.setForeground(new Color(0, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 10);
        this.pathnameSearchPanel.add((Component)searchPathnameLabel, gbc);
        this.searchString.setMargin(new Insets(0, 2, 0, 0));
        this.searchString.setToolTipText("Show all pathnames containing this string");
        this.searchString.setColumns(20);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = this._insets0000;
        this.pathnameSearchPanel.add((Component)this.searchString, gbc);
        this.jButtonSearchString.setMnemonic('S');
        this.jButtonSearchString.setActionCommand("Search");
        this.jButtonSearchString.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(6, 5, 6, 5);
        this.pathnameSearchPanel.add((Component)this.jButtonSearchString, gbc);
        gridBagLayout = new GridBagLayout();
        this.partsSearchPanel.setLayout(gridBagLayout);
        final JLabel jLabelSearch = new JLabel("Search");
        jLabelSearch.setDisplayedMnemonic('S');
        jLabelSearch.setFont(smallBoldFont);
        jLabelSearch.setForeground(new Color(0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 5, 0, 0);
        this.partsSearchPanel.add((Component)jLabelSearch, gbc);
        final JLabel jLabelParts = new JLabel("By Parts:");
        jLabelParts.setFont(smallBoldFont);
        jLabelParts.setForeground(new Color(0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(1, 5, 0, 0);
        this.partsSearchPanel.add((Component)jLabelParts, gbc);
        JPanel partsPanel = new JPanel(new GridLayout(2, 3, 12, 2));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridheight = 2;
        gbc.gridwidth = 5;
        gbc.fill = 2;
        gbc.insets = this._insets01500;
        this.partsSearchPanel.add((Component)partsPanel, gbc);
        this._partsComboBox[0].setToolTipText("Show all pathnames with this A part.");
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = this._insets0400;
        JPanel panel = new JPanel(new GridBagLayout());
        this.labelA = new JLabel("A: ");
        panel = new JPanel(new GridBagLayout());
        panel.add(this.labelA);
        panel.add((Component)this._partsComboBox[0], gbc);
        partsPanel.add(panel);
        this.labelC = new JLabel("C: ");
        panel = new JPanel(new GridBagLayout());
        panel.add(this.labelC);
        panel.add((Component)this._partsComboBox[2], gbc);
        partsPanel.add(panel);
        this.labelE = new JLabel("E: ");
        panel = new JPanel(new GridBagLayout());
        panel.add(this.labelE);
        panel.add((Component)this._partsComboBox[4], gbc);
        partsPanel.add(panel);
        this.labelB = new JLabel("B: ");
        panel = new JPanel(new GridBagLayout());
        panel.add(this.labelB);
        panel.add((Component)this._partsComboBox[1], gbc);
        partsPanel.add(panel);
        this.labelD = new JLabel("D: ");
        panel = new JPanel(new GridBagLayout());
        panel.add(this.labelD);
        panel.add((Component)this._partsComboBox[3], gbc);
        partsPanel.add(panel);
        this.labelF = new JLabel("F: ");
        panel = new JPanel(new GridBagLayout());
        panel.add(this.labelF);
        panel.add((Component)this._partsComboBox[5], gbc);
        partsPanel.add(panel);
        this.jButtonSearchParts.setActionCommand("Search");
        this.jButtonSearchParts.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 12, 0, 12);
        ((GridBagLayout)this.partsSearchPanel.getLayout()).setConstraints(this.jButtonSearchParts, gbc);
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Object src = e.getSource();
                if (src == jLabelSearch || src == jLabelParts) {
                    ActionEvent event = new ActionEvent(this, 1001, "searchByString");
                    if (PathnameFilterPanel.this._observer != null) {
                        PathnameFilterPanel.this._observer.notifyObservers(event);
                    }
                } else if (src == searchPathnameLabel) {
                    ActionEvent event = new ActionEvent(this, 1001, "searchByPathname");
                    if (PathnameFilterPanel.this._observer != null) {
                        PathnameFilterPanel.this._observer.notifyObservers(event);
                    }
                }
            }
        };
        jLabelSearch.addMouseListener(listener);
        jLabelParts.addMouseListener(listener);
        searchPathnameLabel.addMouseListener(listener);
    }

    public void setLabelNames(String[] labelNames) {
        if (labelNames == null || labelNames.length != 6) {
            this.labelA.setText("A: ");
            this.labelB.setText("B: ");
            this.labelC.setText("C: ");
            this.labelD.setText("D: ");
            this.labelE.setText("E: ");
            this.labelF.setText("F: ");
        } else {
            this.labelA.setText(labelNames[0] + ": ");
            this.labelB.setText(labelNames[1] + ": ");
            this.labelC.setText(labelNames[2] + ": ");
            this.labelD.setText(labelNames[3] + ": ");
            this.labelE.setText(labelNames[4] + ": ");
            this.labelF.setText(labelNames[5] + ": ");
        }
    }

    public void setTableModel(BasePathnameTableModel tableModel) {
        this._tableModel = tableModel;
        if (this._tableModel == null) {
            return;
        }
        String[] parts = new String[6];
        for (int i = 0; i < 6; ++i) {
            parts[i] = (String)this._partsComboBox[i].getSelectedItem();
        }
        if (this._searchByParts) {
            this.searchByParts(-1);
        }
    }

    public void setSearchMethod(boolean searchByParts) {
        this._searchByParts = searchByParts;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.removeAll();
        if (this._searchByParts) {
            this.add((Component)this.partsSearchPanel, gbc);
            this.searchByParts(-1);
        } else {
            this.add((Component)this.pathnameSearchPanel, gbc);
            this.searchByString();
        }
    }

    public boolean getSearchMethod() {
        return this._searchByParts;
    }

    public String getFilterSelection(int partNumber) {
        if (!this._searchByParts) {
            return null;
        }
        return this._partsComboBox[partNumber].getSelectedItem().toString();
    }

    public void catalogUpdated() {
        if (this._searchByParts) {
            Integer previous = this._previousPartSelected.peekLast();
            this.searchByParts(-1);
            if (previous != null) {
                this._previousPartSelected.add(previous);
            }
        } else if (this.searchString.getText().length() > 0) {
            this.searchByString();
        }
    }

    public void reset() {
        for (int i = 0; i < 6; ++i) {
            if (this._partsComboBox[i].getSelectedIndex() == 0) continue;
            this._partsComboBox[i].setSelectedIndex(0);
        }
        this.searchString.setText("");
    }

    public String getSearchText() {
        return this.searchString.getText();
    }

    public void setFilter(String pathFilter) {
        if (pathFilter == null) {
            for (int i = 0; i < this._partsComboBox.length; ++i) {
                this._partsComboBox[i].setSelectedIndex(0);
            }
            return;
        }
        Vector v = DSSPathname.parseDssPath((String)pathFilter);
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            String filter = (String)v.get(i);
            if (filter == null || filter.length() == 0) continue;
            this._partsComboBox[i].setSelectedItem(filter);
        }
    }

    void searchByString() {
        if (this._tableModel == null) {
            return;
        }
        String search = this.getSearchText().trim();
        boolean foundSome = this._tableModel.searchByString(search);
        if (!foundSome) {
            if (this._tableModel.getPathnameList().length > 0) {
                String message = "No pathnames contain the string " + search;
                JOptionPane.showMessageDialog(this, message, this._programName, 1);
            }
        } else {
            if (this._tableModel instanceof NoPathnamesTableModel) {
                ActionEvent event = new ActionEvent(this, 1001, "pathnameSetInSearch");
                if (this._observer != null) {
                    this._observer.notifyObservers(event);
                }
            }
            this._tableModel.fireTableDataChanged();
        }
        this.pathnamesShownUpdated();
    }

    public void searchByParts(int partSelected) {
        if (this._tableModel == null) {
            return;
        }
        if (this._tableModel instanceof NoPathnamesTableModel) {
            return;
        }
        String[] parts = new String[6];
        boolean[] searchPart = new boolean[6];
        boolean foundOne = false;
        for (int i = 0; i < 6; ++i) {
            parts[i] = (String)this._partsComboBox[i].getSelectedItem();
            if (parts[i].trim().length() > 0) {
                searchPart[i] = true;
                foundOne = true;
                if (partSelected != i) continue;
                Vector vector = this._previousPartListMap.get(i);
                if (vector == null) {
                    vector = new Vector();
                    this._previousPartListMap.put(i, vector);
                    for (int j = 0; j < this._partsComboBox[i].getItemCount(); ++j) {
                        vector.add(this._partsComboBox[i].getItemAt(j));
                    }
                }
                if (this._previousPartSelected.contains(i)) continue;
                this._previousPartSelected.add(i);
                continue;
            }
            if (this._previousPartSelected.contains(i)) {
                this._previousPartSelected.remove((Object)i);
            }
            if (this._previousPartListMap.containsKey(i)) {
                this._previousPartListMap.remove(i);
            }
            searchPart[i] = false;
        }
        this._tableModel.searchByParts(foundOne, searchPart, parts);
        this._tableModel.fireTableDataChanged();
        this.buildComboList(parts);
        this.pathnamesShownUpdated();
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }

    protected void pathnamesShownUpdated() {
        ActionEvent event = new ActionEvent(this, 1001, "pathnamesShownUpdated");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    protected void buildComboList(String[] setParts) {
        int i;
        if (ListSelection.debug) {
            System.out.println("Enter PathnameFilterPanel.buildComboList() " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
        int pathnamesDisplaySize = this._tableModel.getPathnamesDisplayedSize();
        HashSet[] hs = new HashSet[6];
        for (i = 0; i < 6; ++i) {
            hs[i] = new HashSet(pathnamesDisplaySize + 1);
        }
        if (this._tableModel.getPathnameListLength() == pathnamesDisplaySize) {
            for (i = 0; i < 6; ++i) {
                String[] parts = this._tableModel.getPathnamePartList(i);
                hs[i].addAll(Arrays.asList(parts));
            }
        } else {
            for (int j = 0; j < pathnamesDisplaySize; ++j) {
                int numb = this._tableModel.getPathnamesDisplayed(j);
                for (int i2 = 0; i2 < 6; ++i2) {
                    String part = this._tableModel.getPathnamePart(numb, i2);
                    hs[i2].add(part);
                }
            }
        }
        for (i = 0; i < 6; ++i) {
            if (hs[i].contains("")) {
                hs[i].add("(blank)");
            }
            hs[i].add("");
        }
        for (i = 0; i < 6; ++i) {
            String[] list = hs[i].toArray(new String[0]);
            try {
                Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
            }
            catch (Throwable t) {
                Logger logger = Logger.getLogger(PathnameFilterPanel.class.getName());
                logger.log(Level.SEVERE, "Error sorting pathname list.", t);
            }
            this._partsComboList[i].removeAllElements();
            this._partsComboList[i].addAll(Arrays.asList(list));
        }
        if (!this._previousPartSelected.isEmpty() && this._partsComboList[this._previousPartSelected.peekLast()].contains(setParts[this._previousPartSelected.peekLast()])) {
            this._partsComboList[this._previousPartSelected.peekLast()].removeAllElements();
            Vector vector = this._previousPartListMap.get(this._previousPartSelected.peekLast());
            if (vector != null) {
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    this._partsComboList[this._previousPartSelected.peekLast()].addElement(vector.get(i3));
                }
            }
        }
        for (int i4 = 0; i4 < 6; ++i4) {
            DefaultComboBoxModel m = new DefaultComboBoxModel(this._partsComboList[i4]);
            int indx = m.getIndexOf(setParts[i4]);
            if (indx == -1) {
                setParts[i4] = "";
            }
            m.setSelectedItem(setParts[i4]);
            this._partsComboBox[i4].setModel(m);
        }
        if (ListSelection.debug) {
            System.out.println("Exit PathnameFilterPanel.buildComboList() " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
    }

    protected void addListeners() {
        PathnamePanelActionListener listener = new PathnamePanelActionListener();
        this.searchString.addActionListener(listener);
        this.jButtonSearchString.addActionListener(listener);
        this.jButtonSearchParts.addActionListener(listener);
        for (int i = 0; i < 6; ++i) {
            this._partsComboBox[i].addActionListener(listener);
        }
        this.partsSearchPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    PathnameFilterPanel.this.displayPartsSearchPanelPopupMenu(e.getPoint());
                }
            }
        });
        this.labelA.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PathnameFilterPanel.this.clearCombo(PathnameFilterPanel.this._partsComboBox[0]);
                }
            }
        });
        this.labelB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PathnameFilterPanel.this.clearCombo(PathnameFilterPanel.this._partsComboBox[1]);
                }
            }
        });
        this.labelC.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PathnameFilterPanel.this.clearCombo(PathnameFilterPanel.this._partsComboBox[2]);
                }
            }
        });
        this.labelD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PathnameFilterPanel.this.clearCombo(PathnameFilterPanel.this._partsComboBox[3]);
                }
            }
        });
        this.labelE.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PathnameFilterPanel.this.clearCombo(PathnameFilterPanel.this._partsComboBox[4]);
                }
            }
        });
        this.labelF.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PathnameFilterPanel.this.clearCombo(PathnameFilterPanel.this._partsComboBox[5]);
                }
            }
        });
    }

    protected void clearCombo(JComboBox combo) {
        if (combo == null || combo.getItemCount() == 0) {
            return;
        }
        combo.setSelectedIndex(0);
    }

    protected void displayPartsSearchPanelPopupMenu(Point p) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem enterPathnameMenuItem = new JMenuItem("Enter Pathname");
        enterPathnameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathnameFilterPanel.this.enterPathnameAction();
            }
        });
        popup.add(enterPathnameMenuItem);
        popup.show(this.partsSearchPanel, p.x, p.y);
    }

    protected void enterPathnameAction() {
        String path = JOptionPane.showInputDialog(this, "Enter Pathname to Search for:", "Search Pathnames", -1);
        if (path != null) {
            DSSPathname pathname = new DSSPathname(path);
            this._partsComboBox[0].setSelectedItem(pathname.getAPart());
            this._partsComboBox[1].setSelectedItem(pathname.getBPart());
            this._partsComboBox[2].setSelectedItem(pathname.getCPart());
            this._partsComboBox[3].setSelectedItem(pathname.getDPart());
            this._partsComboBox[4].setSelectedItem(pathname.getEPart());
            this._partsComboBox[5].setSelectedItem(pathname.getFPart());
        }
    }

    class PathnamePanelActionListener
    implements ActionListener {
        PathnamePanelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == PathnameFilterPanel.this.searchString) {
                PathnameFilterPanel.this.searchByString();
            } else if (object == PathnameFilterPanel.this.jButtonSearchString) {
                PathnameFilterPanel.this.searchByString();
            } else if (object == PathnameFilterPanel.this.jButtonSearchParts) {
                PathnameFilterPanel.this.searchByParts(-1);
            }
            for (int i = 0; i < PathnameFilterPanel.this._partsComboBox.length; ++i) {
                if (object != PathnameFilterPanel.this._partsComboBox[i]) continue;
                PathnameFilterPanel.this.searchByParts(i);
                break;
            }
        }
    }
}

