/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.BasePathnameTableModel;
import hec.dssgui.CondensedPathnameTableModel;
import hec.dssgui.IPanelController;
import hec.dssgui.IPathNamePanel;
import hec.dssgui.ListSelection;
import hec.dssgui.NoPathnamesTableModel;
import hec.dssgui.ObservableClass;
import hec.dssgui.PathnameFilterPanel;
import hec.dssgui.PathnameListTableModel;
import hec.dssgui.PathnamePartsTableModel;
import hec.dssgui.PathnameTable;
import hec.dssgui.UnsortedListTableModel;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.DssDataManager;
import hec.util.ElapsedTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import mil.army.usace.hec.rmi.heclib.dss.HecDSSUtilitiesRemote;
import rma.swing.table.TablePrintManager;

public class PathnamePanel
extends JPanel
implements IPathNamePanel,
IPanelController {
    private static final Logger LOGGER = Logger.getLogger(PathnamePanel.class.getName());
    protected JPanel jPanelPathList;
    private PathnameFilterPanel _pathnameFilterPanel;
    protected JScrollPane _pathnameScrollPane;
    protected JScrollPane _selectedScrollPane;
    protected JSplitPane _splitPane;
    protected BasePathnameTableModel _tableModel;
    protected ListSelectionModel _pathnameListSelectionModel;
    protected PathnameTable _pathnameTable;
    protected String _dssFileName;
    protected String _programName;
    protected int _listTableType;
    protected ObservableClass _observer;
    protected JPopupMenu _popup;
    protected TransferHandler _transferHandler = null;
    protected int _previousSplitPaneHeight = 0;
    protected double _dividerLocation = 0.8;
    protected String[] _partColumns = null;
    protected String _listColumn = null;
    private boolean _popupDeleteActionVisible = true;
    private String _catalogFilter = null;
    private boolean _canClose = true;
    private final List<Component> linkedTab = new ArrayList<Component>();
    int _splitLoc = -1;

    public PathnamePanel(String programName, int initialTableType, boolean searchByParts, JScrollPane selectedScrollPane) {
        this._programName = programName;
        this._listTableType = initialTableType;
        this._selectedScrollPane = selectedScrollPane;
        this._observer = new ObservableClass();
        this.buildTable();
        this.build(searchByParts);
    }

    @Override
    public void setPathnameList(String[] pathnameList, DssDataManager dataManager) {
        if (ListSelection.debug) {
            int len = pathnameList == null ? -1 : pathnameList.length;
            LOGGER.log(Level.INFO, "Enter PathnamePanel.setPathnameList(), list length = {0}", len);
        }
        int divider = 0;
        if (this.isVisible()) {
            divider = this.getDividerLocation();
        }
        if (pathnameList != null && this._tableModel != null) {
            this._tableModel.setPathnameList(pathnameList, dataManager);
            this._tableModel.buildList();
            if (this._pathnameFilterPanel != null) {
                this._pathnameFilterPanel.setTableModel(this._tableModel);
            }
        }
        if (this.isVisible()) {
            this.setDividerLocation(divider);
        }
        if (pathnameList != null) {
            this.adjustTableWidths();
        }
    }

    @Override
    public void setCondensedCatalog(CondensedReference[] condensedList, DssDataManager dataManager) {
        if (ListSelection.debug) {
            int len = condensedList == null ? -1 : condensedList.length;
            System.out.println("Enter PathnamePanel.setCondensedCatalog(), list length = " + len);
        }
        int divider = this.getDividerLocation();
        if (condensedList != null && this._tableModel != null) {
            this._tableModel.setCondensedCatalog(condensedList, dataManager);
            this._tableModel.buildList();
            if (this._pathnameFilterPanel != null) {
                this._pathnameFilterPanel.setTableModel(this._tableModel);
            }
            this.setDividerLocation(divider);
        }
        if (condensedList != null) {
            this.adjustTableWidths();
        }
    }

    @Override
    public void newTableView(int tableType, String dssFileName) {
        if (ListSelection.debug) {
            System.out.println("Enter PathnamePanel.newTableView() " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
        this._listTableType = tableType;
        this._dssFileName = dssFileName;
        boolean sameModel = false;
        if (this._listTableType == 0) {
            if (this._tableModel instanceof PathnameListTableModel) {
                sameModel = true;
            } else {
                this._tableModel = new PathnameListTableModel();
            }
            if (this._listColumn != null) {
                ((PathnameListTableModel)this._tableModel).setColumnName(this._listColumn);
            }
        } else if (this._listTableType == 2) {
            if (this._tableModel instanceof CondensedPathnameTableModel) {
                sameModel = true;
            } else {
                this._tableModel = new CondensedPathnameTableModel();
            }
            ((CondensedPathnameTableModel)this._tableModel).setUseCollectionGroups(false);
        } else if (this._listTableType == 3) {
            if (this._tableModel instanceof CondensedPathnameTableModel) {
                sameModel = true;
            } else {
                this._tableModel = new CondensedPathnameTableModel();
            }
            ((CondensedPathnameTableModel)this._tableModel).setUseCollectionGroups(true);
        } else if (this._listTableType == 1) {
            if (this._tableModel instanceof PathnamePartsTableModel && !(this._tableModel instanceof CondensedPathnameTableModel)) {
                sameModel = true;
            } else {
                this._tableModel = new PathnamePartsTableModel();
            }
            if (this._partColumns != null) {
                ((PathnamePartsTableModel)this._tableModel).setColumnNames(this._partColumns);
            }
        } else if (this._listTableType == 4) {
            if (this._tableModel instanceof NoPathnamesTableModel) {
                sameModel = true;
            } else {
                this._tableModel = new NoPathnamesTableModel();
            }
        } else if (this._listTableType == 5) {
            if (this._tableModel instanceof UnsortedListTableModel) {
                sameModel = true;
            } else {
                this._tableModel = new UnsortedListTableModel();
            }
        }
        if (!sameModel) {
            if (this._tableModel != null) {
                this._pathnameTable.setModel(this._tableModel);
            }
            if (!(this._tableModel instanceof UnsortedListTableModel) && !(this._tableModel instanceof NoPathnamesTableModel)) {
                TableRowSorter<BasePathnameTableModel> sorter = new TableRowSorter<BasePathnameTableModel>(this._tableModel);
                this._pathnameTable.setRowSorter(sorter);
            } else {
                this._pathnameTable.setRowSorter(null);
            }
            this._pathnameTable.clearSelection();
        }
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this._transferHandler = transferHandler;
        super.setTransferHandler(transferHandler);
        if (this._pathnameTable != null) {
            this._pathnameTable.setTransferHandler(this._transferHandler);
        }
    }

    public String getDssFileName() {
        return this._dssFileName;
    }

    @Override
    public boolean isEmpty() {
        return !(this._dssFileName != null && this._dssFileName.length() != 0 || this._pathnameTable != null && this._pathnameTable.getRowCount() != 0);
    }

    public BasePathnameTableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public void pathnameListUpdated() {
        if (ListSelection.debug) {
            System.out.println("Enter PathnamePanel.pathnameListUpdated() " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
        this._tableModel.fireTableDataChanged();
    }

    @Override
    public int getPathnamesDisplayedSize() {
        return this._tableModel.getPathnamesDisplayedSize();
    }

    @Override
    public String[] getPathnameList() {
        return this._tableModel.getPathnameList();
    }

    @Override
    public CondensedReference[] getCondensedCatalog() {
        if (this._tableModel instanceof CondensedPathnameTableModel) {
            return ((CondensedPathnameTableModel)this._tableModel).getCondensedCatalog();
        }
        return new CondensedReference[0];
    }

    @Override
    public String getFilterSelection(int partNumber) {
        if (this._pathnameFilterPanel == null) {
            return "";
        }
        return this._pathnameFilterPanel.getFilterSelection(partNumber);
    }

    @Override
    public int getTableType() {
        return this._listTableType;
    }

    @Override
    public int getSelectedPathnamesSize() {
        int number = this._pathnameTable.getSelectedPathnamesSize();
        return number;
    }

    @Override
    public DataReferenceSet getSelectedPathnames() {
        String parsingRegexp = "(.*)//(.*):(.*)/(.*)";
        Pattern parsingPattern = Pattern.compile(parsingRegexp);
        String strUrl = "";
        DataReferenceSet drs = this._pathnameTable.getSelectedPathnames(this._dssFileName);
        DssDataManager dataManager = this.getDataManager();
        if (dataManager != null && dataManager.isRemote() && dataManager.dataManager() != null) {
            try {
                strUrl = ((HecDSSUtilitiesRemote)dataManager.dataManager()).getRemoteDSSManager().getServerUrl();
                Matcher m = parsingPattern.matcher(strUrl);
                if (m.matches() && m.groupCount() == 4) {
                    String host = m.group(2);
                    String port = m.group(3);
                    Integer iPort = Integer.parseInt(port);
                    for (int i = 0; i < drs.size(); ++i) {
                        DataReference dataSet = drs.elementAt(i);
                        dataSet.setHost(host);
                        dataSet.setPort(iPort);
                    }
                }
            }
            catch (RemoteException e) {
                LOGGER.log(Level.WARNING, "Error connecting to remote dss manager.", e);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error retrieving remote data.", ex);
            }
        }
        return drs;
    }

    @Override
    public void clearSelection() {
        this._pathnameTable.clearSelection();
    }

    @Override
    public String getFirstSelectedPathname() {
        return this._pathnameTable.getFirstSelectedPathname();
    }

    public JScrollPane getPathnameScrollPane() {
        return this._pathnameScrollPane;
    }

    @Override
    public DataReferenceSet getAllPathnames() {
        DataReferenceSet drs = new DataReferenceSet();
        for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
            DataReference dataSet = new DataReference(this._tableModel.getNominalPathname(i), this._dssFileName, this._tableModel.getCondensedReference(i));
            drs.add((Object)dataSet);
        }
        return drs;
    }

    @Override
    public void printCatalog(boolean showPreview) {
        final PathnameTable pathTable = this._pathnameTable;
        final String title = this._dssFileName;
        final boolean preview = showPreview;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TablePrintManager printManager = new TablePrintManager(pathTable);
                printManager.getPrintProperties().title = title;
                if (preview) {
                    printManager.printPreview();
                } else {
                    printManager.printData();
                }
            }
        });
        SwingUtilities.invokeLater(thread);
    }

    public int getFilterOffset() {
        if (this._pathnameFilterPanel != null && this._pathnameFilterPanel.getSize() != null) {
            return this._pathnameFilterPanel.getSize().height;
        }
        return 0;
    }

    protected void build(boolean searchByParts) {
        this.setLayout(new GridBagLayout());
        this._pathnameFilterPanel = new PathnameFilterPanel(this._programName);
        this._pathnameFilterPanel.setSearchMethod(searchByParts);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this._pathnameFilterPanel, gbc);
        this.newTableView(this._listTableType, "");
        this._pathnameScrollPane = new JScrollPane(this._pathnameTable);
        this._pathnameScrollPane.setMinimumSize(new Dimension(300, 80));
        this._splitPane = new JSplitPane(0, this._pathnameScrollPane, this._selectedScrollPane);
        this._splitPane.setDividerSize(4);
        this._splitPane.setDividerLocation(0.8);
        this._pathnameScrollPane.addComponentListener(new ComponentAdapter());
        this._selectedScrollPane.addComponentListener(new ComponentAdapter());
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._splitPane, gbc);
    }

    protected void buildTable() {
        this._pathnameTable = new PathnameTable();
        this._pathnameTable.setDragEnabled(true);
        this._pathnameListSelectionModel = this._pathnameTable.getSelectionModel();
        this._pathnameListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PathnamePanel.this.pathnameSelected();
                }
            }
        });
        MouseListener aMouseListener = new MouseListener();
        this._pathnameTable.addMouseListener(aMouseListener);
        if (this._transferHandler != null) {
            this._pathnameTable.setTransferHandler(this._transferHandler);
        }
    }

    @Override
    public void setColumnNamesForPartsTable(String[] partColumns) {
        this._partColumns = partColumns;
        if (this._tableModel instanceof PathnamePartsTableModel) {
            ((PathnamePartsTableModel)this._tableModel).setColumnNames(partColumns);
            ((PathnamePartsTableModel)this._tableModel).fireTableStructureChanged();
        }
    }

    @Override
    public void setColumnNameForListTable(String listColumn) {
        this._listColumn = listColumn;
        if (this._tableModel instanceof PathnameListTableModel) {
            ((PathnameListTableModel)this._tableModel).setColumnName(listColumn);
            ((PathnameListTableModel)this._tableModel).fireTableStructureChanged();
        }
    }

    @Override
    public void setPartNamesForFilter(String[] names) {
        if (this._pathnameFilterPanel == null) {
            return;
        }
        this._pathnameFilterPanel.setLabelNames(names);
    }

    @Override
    public void catalogUpdated() {
        if (this._pathnameFilterPanel == null) {
            return;
        }
        this._pathnameFilterPanel.catalogUpdated();
    }

    @Override
    public void setSearchMethod(boolean searchByParts) {
        if (this._pathnameFilterPanel == null) {
            return;
        }
        this._pathnameFilterPanel.setSearchMethod(searchByParts);
    }

    @Override
    public boolean getSearchMethod() {
        if (this._pathnameFilterPanel == null) {
            return false;
        }
        return this._pathnameFilterPanel.getSearchMethod();
    }

    @Override
    public void resetSearchString() {
        if (this._pathnameFilterPanel == null) {
            return;
        }
        this._pathnameFilterPanel.reset();
    }

    @Override
    public DssDataManager getDataManager() {
        return this._tableModel.getDataManager();
    }

    @Override
    public void setFilter(String pathFilter) {
        if (this._pathnameFilterPanel == null) {
            return;
        }
        this._pathnameFilterPanel.setFilter(pathFilter);
    }

    @Override
    public void setSelectionMode(int mode) {
        this._pathnameTable.getSelectionModel().setSelectionMode(mode);
    }

    protected void adjustTableWidths() {
        if (ListSelection.debug) {
            System.out.println("Enter PathnamePanel.adjustTableWidths() " + ElapsedTime.elapsedTimeDescription((boolean)true));
        }
        TableColumn column = null;
        int totalPartLength = 0;
        int[] length = new int[7];
        if (this._pathnameTable == null) {
            return;
        }
        Dimension dim = this._pathnameTable.getPreferredScrollableViewportSize();
        int panelWidth = dim.width;
        if (this._tableModel == null) {
            return;
        }
        int[] maxLengths = this._tableModel.getMaxLengths();
        for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            length[i] = maxLengths[i];
            column = this._pathnameTable.getColumnModel().getColumn(i);
            if (length[i] < 8) {
                length[i] = 8;
            }
            if (i == 4 && this._listTableType == 2 && length[i] < 26) {
                length[i] = 26;
            }
            if (i == 4 && this._listTableType == 3 && length[i] < 26) {
                length[i] = 26;
            }
            if (i == 6 && this._listTableType == 3 && length[i] < 26) {
                length[i] = 26;
            }
            totalPartLength += length[i];
        }
        float ratio = (float)panelWidth / (float)totalPartLength;
        int totalWidth = 0;
        for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            column = this._pathnameTable.getColumnModel().getColumn(i);
            int width = i == 0 ? 70 : (int)((double)((float)length[i] * ratio) * 0.7 + (double)((float)panelWidth / (float)this._tableModel.getColumnCount()) * 0.3);
            if (i < this._tableModel.getColumnCount() - 1) {
                column.setPreferredWidth(width);
                totalWidth += width;
                if (i != 0) continue;
                column.setMaxWidth(70);
                column.setMinWidth(70);
                continue;
            }
            column.setPreferredWidth(panelWidth - totalWidth);
        }
    }

    @Override
    public void addObserver(Observer o) {
        if (this._pathnameFilterPanel == null) {
            return;
        }
        if (this._observer != null) {
            this._observer.addObserver(o);
            this._pathnameFilterPanel.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }

    protected void pathnameSelected() {
        ActionEvent event = new ActionEvent(this, 1001, "pathnameSelected");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    protected void runDefaultSelection() {
        ActionEvent event = new ActionEvent(this, 1001, "runDefaultSelection");
        if (this._observer != null) {
            this._observer.notifyObservers(event);
        }
    }

    @Override
    public void setPopup(JPopupMenu popup) {
        this._popup = popup;
    }

    @Override
    public void setVisible(boolean bVis) {
        if (!bVis) {
            this._splitLoc = this._splitPane.getDividerLocation();
        }
        super.setVisible(bVis);
    }

    public int getSplitLocation() {
        return this._splitLoc;
    }

    protected void displayPopup(MouseEvent event, Component invoker) {
        if (this._popup == null) {
            return;
        }
        int n = this._popup.getComponentCount();
        Component deleteMenuItem = null;
        for (int ii = 0; ii < n; ++ii) {
            if (!"Delete".equals(this._popup.getComponent(ii).getName())) continue;
            deleteMenuItem = this._popup.getComponent(ii);
            deleteMenuItem.setVisible(this._popupDeleteActionVisible);
        }
        for (int i = n - 3; i < n; ++i) {
            this._popup.getComponent(i).setVisible(false);
        }
        int x = event.getX();
        int y = event.getY();
        Dimension dim = this._popup.getPreferredSize();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrnsiz = toolkit.getScreenSize();
        Point pt0 = this.getLocationOnScreen();
        int windowsToolBarHeight = 50;
        int offset = scrnsiz.height - (pt0.y + y + dim.height + windowsToolBarHeight);
        if (offset < 0) {
            y += offset;
        }
        this._popup.show(invoker, x, y);
    }

    @Override
    public void setDividerLocation(int dividerLoc) {
        if (this._selectedScrollPane != null) {
            this._splitPane.setBottomComponent(this._selectedScrollPane);
        }
        this._splitPane.setDividerLocation(dividerLoc);
        this._splitPane.revalidate();
    }

    @Override
    public int getDividerLocation() {
        return this._splitPane.getDividerLocation();
    }

    public void setPopupDeleteActionVisible(boolean visible) {
        this._popupDeleteActionVisible = visible;
    }

    @Override
    public List getLinkedTabs() {
        return this.linkedTab;
    }

    @Override
    public void addLinkedTab(Component tab) {
        this.linkedTab.add(tab);
    }

    @Override
    public void setBottom(Component comp) {
    }

    @Override
    public void getTimeWindow() {
    }

    @Override
    public String getSearchText() {
        return this._pathnameFilterPanel.getSearchText();
    }

    @Override
    public boolean showSelectionPanel() {
        return true;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean canClose() {
        return this._canClose;
    }

    public void setClosable(boolean closeable) {
        this._canClose = closeable;
    }

    public final JSplitPane getSplitPane() {
        return this._splitPane;
    }

    public void setCatalogFilter(String catalogFilter) {
        this._catalogFilter = catalogFilter;
    }

    public String getCatalogFilter() {
        return this._catalogFilter;
    }

    @Override
    public Color getTabTextColor() {
        return Color.BLACK;
    }

    class ComponentAdapter
    extends java.awt.event.ComponentAdapter {
        ComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            int splitPaneHeight = 0;
            for (int i = 0; i < PathnamePanel.this._splitPane.getComponentCount(); ++i) {
                splitPaneHeight += PathnamePanel.this._splitPane.getComponent((int)i).getSize().height;
            }
            if (splitPaneHeight == PathnamePanel.this._previousSplitPaneHeight) {
                double dividerLocation = (double)PathnamePanel.this._splitPane.getDividerLocation() / (double)splitPaneHeight;
                if (dividerLocation > 0.05 && dividerLocation < 0.95) {
                    PathnamePanel.this._dividerLocation = dividerLocation;
                }
                return;
            }
            PathnamePanel.this._previousSplitPaneHeight = splitPaneHeight;
            PathnamePanel.this._splitPane.setDividerLocation(PathnamePanel.this._dividerLocation);
        }
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Object object = event.getSource();
            if (object == PathnamePanel.this._pathnameTable) {
                if (event.getClickCount() >= 2) {
                    PathnamePanel.this.runDefaultSelection();
                } else if (SwingUtilities.isRightMouseButton(event)) {
                    PathnamePanel.this.displayPopup(event, PathnamePanel.this._pathnameTable);
                }
            }
        }
    }
}

