/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.DebugExamineFile7;
import hec.dssgui.DebugFileInfo7;
import hec.dssgui.ListSelection;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecDSSUtilities;
import hec.heclib.dss.HecDataManager;
import hec.io.DataContainer;
import hec.util.GeneralTableEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.list.RmaListModel;

public class RecordInternalsDialog
extends RmaJDialog
implements MouseListener {
    protected RmaJComboBox _pathCombo;
    protected JTextField _typeField;
    protected JTextField _recTypeField;
    protected JTextField _pathLengthField;
    protected JTextField _hashField;
    protected JTextField _hashAddressField;
    protected JTextField _tableHashField;
    protected JTextField _binLengthField;
    protected JTextField _binAddressField;
    protected JTextField _infoLengthField;
    protected JTextField _infoAddressField;
    protected JTextField _dataAddressField;
    protected JTextField _dataLengthField;
    protected JPopupMenu _popup;
    protected JMenuItem _gotoLabel;
    protected JTextField _goTo;
    protected ButtonCmdPanel _cmdPanel;
    protected ListSelection _listSelection;
    protected GeneralTableEditor _debugFrame = null;
    protected GeneralTableEditor _infoFrame = null;
    protected GeneralTableEditor _headerFrame = null;
    protected String _title;

    public RecordInternalsDialog(ListSelection parent) {
        super((Frame)parent, false);
        this._listSelection = parent;
        this.buildControls();
        this.pack();
        this.setLocationRelativeTo(this._listSelection);
    }

    protected void buildControls() {
        this._title = "Record Internal Addresses";
        this.setTitle(this._title);
        Color backgroundColor = new Color(245, 245, 245);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets intInsets = RmaInsets.insets((int)2, (int)20, (int)2, (int)0);
        int gridy = 0;
        JLabel label = new JLabel("Data Set:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(15, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this._pathCombo = new RmaJComboBox();
        this._pathCombo.setModifiable(false);
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 5, 0, 5);
        this.getContentPane().add((Component)this._pathCombo, gbc);
        label = new JLabel("Record Type:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._recTypeField = new JTextField();
        this._recTypeField.setEditable(false);
        this._recTypeField.setBackground(backgroundColor);
        label.setLabelFor(this._recTypeField);
        this._recTypeField.setColumns(55);
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._recTypeField, gbc);
        label = new JLabel("Path Length:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._pathLengthField = new JTextField();
        this._pathLengthField.setEditable(false);
        this._pathLengthField.setBackground(backgroundColor);
        label.setLabelFor(this._pathLengthField);
        this._pathLengthField.setMargin(intInsets);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._pathLengthField, gbc);
        label = new JLabel("Table Hash:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._tableHashField = new JTextField();
        this._tableHashField.setEditable(false);
        this._tableHashField.setBackground(backgroundColor);
        label.setLabelFor(this._tableHashField);
        this._tableHashField.setMargin(intInsets);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._tableHashField, gbc);
        label = new JLabel("Hash Address:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._hashAddressField = new JTextField();
        this._hashAddressField.setEditable(false);
        this._hashAddressField.setBackground(backgroundColor);
        label.setLabelFor(this._hashAddressField);
        this._hashAddressField.setMargin(intInsets);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._hashAddressField, gbc);
        label = new JLabel("Hash:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._hashField = new JTextField();
        this._hashField.setEditable(false);
        this._hashField.setBackground(backgroundColor);
        label.setLabelFor(this._hashField);
        this._hashField.setMargin(intInsets);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._hashField, gbc);
        label = new JLabel("Bin Address:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._binAddressField = new JTextField();
        this._binAddressField.setEditable(false);
        this._binAddressField.setBackground(backgroundColor);
        label.setLabelFor(this._binAddressField);
        this._binAddressField.setMargin(intInsets);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._binAddressField, gbc);
        label = new JLabel("Bin Length:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._binLengthField = new JTextField();
        this._binLengthField.setEditable(false);
        this._binLengthField.setBackground(backgroundColor);
        label.setLabelFor(this._binLengthField);
        this._binLengthField.setMargin(intInsets);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._binLengthField, gbc);
        label = new JLabel("Info Address:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._infoAddressField = new JTextField();
        this._infoAddressField.setEditable(false);
        this._infoAddressField.setBackground(backgroundColor);
        label.setLabelFor(this._infoAddressField);
        this._infoAddressField.setMargin(intInsets);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._infoAddressField, gbc);
        label = new JLabel("Info Length:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._infoLengthField = new JTextField();
        this._infoLengthField.setEditable(false);
        this._infoLengthField.setBackground(backgroundColor);
        label.setLabelFor(this._infoLengthField);
        this._infoLengthField.setMargin(intInsets);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._infoLengthField, gbc);
        label = new JLabel("Data Address:");
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._dataAddressField = new JTextField();
        this._dataAddressField.setEditable(false);
        this._dataAddressField.setBackground(backgroundColor);
        label.setLabelFor(this._dataAddressField);
        this._dataAddressField.setMargin(intInsets);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._dataAddressField, gbc);
        label = new JLabel("Data Length:");
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._dataLengthField = new JTextField();
        this._dataLengthField.setEditable(false);
        this._dataLengthField.setBackground(backgroundColor);
        label.setLabelFor(this._dataLengthField);
        this._dataLengthField.setMargin(intInsets);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._dataLengthField, gbc);
        JPanel lowerPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = -1;
        gbc.anchor = 17;
        gbc.fill = 0;
        this.getContentPane().add((Component)lowerPanel, gbc);
        JButton displayInfoButton = new JButton("Display Info");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        lowerPanel.add((Component)displayInfoButton, gbc);
        displayInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordInternalsDialog.this.displayInfoPressed();
            }
        });
        JButton displayHeaderButton = new JButton("Display Header");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        lowerPanel.add((Component)displayHeaderButton, gbc);
        displayHeaderButton.addActionListener(e -> this.displayHeaderPressed());
        JButton button = new JButton("Walk Bins");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        lowerPanel.add((Component)button, gbc);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordInternalsDialog.this.walkBinsPressed();
            }
        });
        JButton goToButton = new JButton(" Go To ");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        lowerPanel.add((Component)goToButton, gbc);
        goToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordInternalsDialog.this.goToPressed();
            }
        });
        this._goTo = new JTextField(8);
        this._goTo.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 10, 2, 0);
        Dimension d = this._goTo.getPreferredSize();
        this._goTo.setMinimumSize(d);
        lowerPanel.add((Component)this._goTo, gbc);
        this._cmdPanel = new ButtonCmdPanel(8);
        gbc.gridx = 5;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        RecordInternalsDialog.this.setVisible(false);
                    }
                }
            }
        });
        this._pathCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                Object obj = RecordInternalsDialog.this._pathCombo.getSelectedItem();
                if (obj instanceof DataContainer) {
                    RecordInternalsDialog.this.fillForm((DataContainer)obj);
                } else if (obj instanceof HecDSSRecordInfo) {
                    RecordInternalsDialog.this.fillForm((HecDSSRecordInfo)obj);
                }
            }
        });
        this._popup = new JPopupMenu();
        this._gotoLabel = new JMenuItem("Go To Address 12345");
        this._popup.add(this._gotoLabel);
        this._gotoLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RecordInternalsDialog.this.goToPressed();
            }
        });
        this._hashAddressField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RecordInternalsDialog.this.setGoToValue(RecordInternalsDialog.this._hashAddressField.getText());
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    RecordInternalsDialog.this._popup.show(RecordInternalsDialog.this._hashAddressField, e.getX(), e.getY());
                }
            }
        });
        this._binAddressField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RecordInternalsDialog.this.setGoToValue(RecordInternalsDialog.this._binAddressField.getText());
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    RecordInternalsDialog.this._popup.show(RecordInternalsDialog.this._binAddressField, e.getX(), e.getY());
                }
            }
        });
        this._infoAddressField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RecordInternalsDialog.this.setGoToValue(RecordInternalsDialog.this._infoAddressField.getText());
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    RecordInternalsDialog.this._popup.show(RecordInternalsDialog.this._infoAddressField, e.getX(), e.getY());
                }
            }
        });
        this._dataAddressField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RecordInternalsDialog.this.setGoToValue(RecordInternalsDialog.this._dataAddressField.getText());
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    RecordInternalsDialog.this._popup.show(RecordInternalsDialog.this._dataAddressField, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this._popup == null) {
            return;
        }
        if (!event.isMetaDown()) {
            return;
        }
        if (!SwingUtilities.isRightMouseButton(event) && this._popup.isVisible()) {
            this._popup.setVisible(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    protected void setGoToValue(String val) {
        this._gotoLabel.setText("Go To Address " + val);
        this._goTo.setText(val);
    }

    protected void goToPressed() {
        long add = Long.parseLong(this._goTo.getText());
        DssDataManager dm = this._listSelection.getDataManager();
        if (dm.dataManager().zinqir("VERS") == 7) {
            this._debugFrame = new DebugExamineFile7((HecDataManager)((HecDSSUtilities)dm.dataManager()), add, 40);
        }
        if (this._debugFrame != null && !this._debugFrame.isVisible()) {
            this._debugFrame.setVisible(true);
        }
    }

    protected void displayInfoPressed() {
        if (this._infoFrame == null) {
            long add = Long.parseLong(this._infoAddressField.getText());
            if (!this.isLocalDSSVersion6()) {
                this._infoFrame = new DebugFileInfo7((HecDataManager)this.getLocalDataManager(), add, DebugFileInfo7.RecordSection.INFO_SECTION);
            }
        }
        if (!this._infoFrame.isVisible()) {
            this._infoFrame.setVisible(true);
        }
    }

    protected void displayHeaderPressed() {
        long add = Long.parseLong(this._infoAddressField.getText());
        if (this.isLocalDSSVersion6()) {
            System.out.println("Not implemented for version 6");
            return;
        }
        this._headerFrame = new DebugFileInfo7((HecDataManager)this.getLocalDataManager(), add, DebugFileInfo7.RecordSection.INTERNAL_HEADER);
        if (!this._headerFrame.isVisible()) {
            this._headerFrame.setVisible(true);
        }
    }

    protected void walkBinsPressed() {
        if (this.isLocalDSSVersion6()) {
            JOptionPane.showMessageDialog(this._listSelection, "Pathname bin exploration not available for DSS-6 files");
            return;
        }
        String sadd = this._binAddressField.getText();
        long address = Long.parseLong(sadd);
        if (address == 0L && (address = Long.parseLong(sadd = this._hashAddressField.getText())) != 0L) {
            long[] add = this.getLocalDataManager().debugLook7(address, 1);
            address = add[0];
        }
        if (address == 0L) {
            String s = JOptionPane.showInputDialog((Component)((Object)this), "Enter bin address", "");
            if (s == null) {
                return;
            }
            address = Long.parseLong(s);
            if (address == 0L) {
                return;
            }
        }
        DebugFileInfo7 frame = new DebugFileInfo7((HecDataManager)this.getLocalDataManager(), address, DebugFileInfo7.RecordSection.PATHNAME_BIN);
        frame.setVisible(true);
    }

    public void fillForm(List list) {
        this.clearForm();
        RmaListModel model = new RmaListModel(false);
        if (list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            model.addElement(list.get(i));
        }
        this._pathCombo.setModel((ComboBoxModel)model);
        this._pathCombo.setSelectedIndex(0);
    }

    public void fillForm(DataContainer dc) {
        if (dc == null) {
            this.clearForm();
            this.setModified(false);
            return;
        }
        if (dc.otherInfo instanceof HecDSSRecordInfo) {
            HecDSSRecordInfo ri = (HecDSSRecordInfo)dc.otherInfo;
            this.fillForm(ri);
        }
    }

    public void fillForm(HecDSSRecordInfo ri) {
        if (ri.recordType == 0) {
            this._recTypeField.setText("Record Not Found");
        } else {
            String type = ri.recordType + ":  " + ri.recordTypeDescription;
            this._recTypeField.setText(type);
        }
        this._pathLengthField.setText(Integer.toString(ri.pathname.length()));
        if (ri.tableHash != 0L) {
            this._tableHashField.setText(Long.toString(ri.tableHash));
        } else {
            this._tableHashField.setText("-- N/A --");
        }
        this._hashField.setText(Long.toString(ri.hashCode));
        this._hashAddressField.setText(Long.toString(ri.hashAddress));
        this._binLengthField.setText(Long.toString(ri.binLength));
        this._binAddressField.setText(Long.toString(ri.binAddress));
        this._infoLengthField.setText(Long.toString(ri.infoLength));
        this._infoAddressField.setText(Long.toString(ri.infoAddress));
        this._dataLengthField.setText(Long.toString(ri.dataLength));
        this._dataAddressField.setText(Long.toString(ri.dataAddress));
    }

    private HecDSSUtilities getLocalDataManager() {
        DssDataManager dm = this._listSelection.getDataManager();
        return (HecDSSUtilities)dm.dataManager();
    }

    private boolean isLocalDSSVersion6() {
        return this.getLocalDataManager().zinqir("VERS") == 6;
    }
}

