/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.MathFrame2;
import hec.dssgui.MathPanel;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.PairedDataMath;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJList;
import rma.swing.list.RmaListModel;

public class RoutingTab
extends MathPanel {
    public static final String MUSKINGUM = "Muskingum Routing";
    public static final String STRADDLE_STAGGER = "Straddle Stagger Routing";
    public static final String MODIFIED_PULS = "Modified Puls Routing";
    public static final String RATING_TABLE = "Rating Table";
    public static final String REVERSE_RATING_TABLE = "Reverse Rating Table";
    public static final String TWO_VARIABLE_RATING_TABLE = "Two Variable Rating Table";
    public static final String DECAYING_BASIN_WETNESS = "Decaying Basin Wetness";
    public static final String SHIFT_ADJUSTMENT = "Shift Adjustment";
    public static final String PERIOD_CONSTANTS = "Period Constants";
    public static final String MULTI_LINEAR_REGRESSION = "Multiple Linear Regression";
    public static final String APPLY_MULTI_LINEAR_REGRESSION = "Apply Multiple Linear Regression";
    public static final String CONIC_INTERPOLATION = "Conic Interpolation";
    public static final String POLYNOMIAL = "Polynomial";
    public static final String POLYNOMIAL_WITH_INTERGRAL = "Polynomial with Integral";
    public static final String FLOW_ACCUMULATOR_GAGE_PROCESSOR = "Flow Accumulator Gage Processor";
    public static String[] _operators = new String[]{"Muskingum Routing", "Straddle Stagger Routing", "Modified Puls Routing", "Rating Table", "Reverse Rating Table", "Two Variable Rating Table", "Decaying Basin Wetness", "Shift Adjustment", "Period Constants", "Multiple Linear Regression", "Apply Multiple Linear Regression", "Conic Interpolation", "Polynomial", "Polynomial with Integral", "Flow Accumulator Gage Processor"};
    protected MuskingumPanel _muskingumPanel;
    protected StraddleStaggerPanel _straddleStaggerPanel;
    protected ModifiedPulsPanel _modifiedPulsPanel;
    private RatingTablePanel _ratingTablePanel;
    private RatingTablePanel _reverseRatingTablePanel;
    private TwoVariableRatingTablePanel _twoVariableRatingTablePanel;
    private DecayingBasinWetnessPanel _decayingBasinWetnessPanel;
    private MathPanel.DataSetPanel _shiftAdjustmentPanel;
    private MathPanel.DataSetPanel _periodConstantsPanel;
    private MultiLinearRegressionPanel _multiLinearRegressionPanel;
    private MultiLinearRegressionPanel _applyMultiLinearRegressionPanel;
    private ConicInterpolationPanel _conicInterpPanel;
    private RatingTablePanel _polynomialPanel;
    private RatingTablePanel _polynomialWithIntergralPanel;
    private MathPanel.DataSetPanel _flowAccumlatorPanel;

    public RoutingTab(MathFrame2 parent) {
        super(parent);
    }

    @Override
    protected void buildPanel() {
        super.buildPanel();
        this._opCombo.setModel(new RmaListModel(false, (Object[])_operators));
        this._opCombo.setMaximumRowCount(_operators.length);
        final CardLayout cl = (CardLayout)this._cardPanel.getLayout();
        this._muskingumPanel = new MuskingumPanel();
        this._cardPanel.add(MUSKINGUM, this._muskingumPanel);
        this._straddleStaggerPanel = new StraddleStaggerPanel();
        this._cardPanel.add(STRADDLE_STAGGER, this._straddleStaggerPanel);
        this._modifiedPulsPanel = new ModifiedPulsPanel();
        this._cardPanel.add(MODIFIED_PULS, this._modifiedPulsPanel);
        this._ratingTablePanel = new RatingTablePanel();
        this._ratingTablePanel.setDataSetLabel(RATING_TABLE, 'R');
        this._cardPanel.add(RATING_TABLE, this._ratingTablePanel);
        this._reverseRatingTablePanel = new RatingTablePanel();
        this._reverseRatingTablePanel.setDataSetLabel(RATING_TABLE, 'R');
        this._cardPanel.add(REVERSE_RATING_TABLE, this._reverseRatingTablePanel);
        this._twoVariableRatingTablePanel = new TwoVariableRatingTablePanel();
        this._twoVariableRatingTablePanel.setSelectedClassType(PairedDataContainer.class);
        this._twoVariableRatingTablePanel.setListClassType(TimeSeriesContainer.class);
        this._cardPanel.add(TWO_VARIABLE_RATING_TABLE, this._twoVariableRatingTablePanel);
        this._decayingBasinWetnessPanel = new DecayingBasinWetnessPanel();
        this._cardPanel.add(DECAYING_BASIN_WETNESS, this._decayingBasinWetnessPanel);
        this._shiftAdjustmentPanel = new MathPanel.DataSetPanel();
        this._shiftAdjustmentPanel.setSelectedClassType(TimeSeriesContainer.class);
        this._shiftAdjustmentPanel.setListClassType(TimeSeriesContainer.class);
        this._cardPanel.add(SHIFT_ADJUSTMENT, this._shiftAdjustmentPanel);
        this._periodConstantsPanel = new MathPanel.DataSetPanel();
        this._periodConstantsPanel.setSelectedClassType(TimeSeriesContainer.class);
        this._periodConstantsPanel.setListClassType(TimeSeriesContainer.class);
        this._cardPanel.add(PERIOD_CONSTANTS, this._periodConstantsPanel);
        boolean applyRegression = false;
        this._multiLinearRegressionPanel = new MultiLinearRegressionPanel(applyRegression);
        this._cardPanel.add(MULTI_LINEAR_REGRESSION, this._multiLinearRegressionPanel);
        applyRegression = true;
        this._applyMultiLinearRegressionPanel = new MultiLinearRegressionPanel(applyRegression);
        this._cardPanel.add(APPLY_MULTI_LINEAR_REGRESSION, this._applyMultiLinearRegressionPanel);
        this._conicInterpPanel = new ConicInterpolationPanel();
        this._conicInterpPanel.setDataSetLabel("Conic Interpolation Table", 'C');
        this._cardPanel.add(CONIC_INTERPOLATION, this._conicInterpPanel);
        this._polynomialPanel = new RatingTablePanel();
        this._polynomialPanel.setDataSetLabel("Polynomial Coefficients", 'P');
        this._cardPanel.add(POLYNOMIAL, this._polynomialPanel);
        this._polynomialWithIntergralPanel = new RatingTablePanel();
        this._polynomialWithIntergralPanel.setDataSetLabel("Polynomial Coefficients", 'P');
        this._cardPanel.add(POLYNOMIAL_WITH_INTERGRAL, this._polynomialWithIntergralPanel);
        this._flowAccumlatorPanel = new MathPanel.DataSetPanel();
        this._flowAccumlatorPanel.setDataSetLabel("Data Set Containing Time Series of Counts", 'D');
        this._flowAccumlatorPanel.setListClassType(TimeSeriesContainer.class);
        this._flowAccumlatorPanel.setSelectedClassType(TimeSeriesContainer.class);
        this._cardPanel.add(FLOW_ACCUMULATOR_GAGE_PROCESSOR, this._flowAccumlatorPanel);
        this._opCombo.setSelectedIndex(-1);
        this._opCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cl.show(RoutingTab.this._cardPanel, (String)RoutingTab.this._opCombo.getSelectedItem());
                RoutingTab.this.setComputeButtonEnabled(RoutingTab.this.isComputable());
            }
        });
        this._opCombo.setSelectedIndex(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean compute() {
        TimeSeriesContainer outputDc = null;
        TimeSeriesMath mathGuy = null;
        Object otherGuy = null;
        String op = (String)this._opCombo.getSelectedItem();
        DataContainer dc = this._parent.getSelectedDataSet();
        if (dc instanceof TimeSeriesContainer) {
            mathGuy = this._tsmath;
            outputDc = new TimeSeriesContainer();
        } else if (dc instanceof PairedDataContainer) {
            mathGuy = this._pdmath;
            outputDc = new PairedDataContainer();
        }
        if (mathGuy == null) {
            return false;
        }
        try {
            mathGuy.setData(dc);
        }
        catch (HecMathException e) {
            System.out.println("compute: Exception : " + e);
            return false;
        }
        HecMath outputMath = null;
        try {
            HecMath tmpMath;
            if (MUSKINGUM.equals(op)) {
                int opt;
                double muskingumX;
                double muskingumK;
                int numReaches = this._muskingumPanel.getNumReaches();
                String msg = mathGuy.isMuskingumRoutingStable(numReaches, muskingumK = this._muskingumPanel.getMuskingumK(), muskingumX = this._muskingumPanel.getMuskingumX());
                if (msg != null && (opt = JOptionPane.showConfirmDialog(this, msg + "\n Do you want to continue with the compute?", "Unstable Routing", 0)) == 1) {
                    return false;
                }
                outputMath = this._tsmath.muskingumRouting(numReaches, muskingumK, muskingumX);
            } else if (STRADDLE_STAGGER.equals(op)) {
                outputMath = this._tsmath.straddleStaggerRouting(this._straddleStaggerPanel.getNumberToAverage(), this._straddleStaggerPanel.getNumberToLag(), this._straddleStaggerPanel.getNumberSubreaches());
            } else if (MODIFIED_PULS.equals(op)) {
                HecMath tmpMath2 = HecMath.createInstance((DataContainer)this._modifiedPulsPanel.getSelectedDataContainer());
                outputMath = ((PairedDataMath)tmpMath2).modifiedPulsRouting(this._tsmath, this._modifiedPulsPanel.getNumberSubreaches(), this._modifiedPulsPanel.getMuskingumX());
                if (outputMath != null) {
                    outputDc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)outputDc);
                    outputDc.modified = true;
                    this._parent.addDataSet((DataContainer)outputDc, false);
                    return true;
                }
            } else if (RATING_TABLE.equals(op)) {
                HecMath tmpMath3 = HecMath.createInstance((DataContainer)this._ratingTablePanel.getSelectedDataContainer());
                outputMath = ((PairedDataMath)tmpMath3).ratingTableInterpolation(this._tsmath);
                if (outputMath != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc, false);
                    return true;
                }
            } else if (REVERSE_RATING_TABLE.equals(op)) {
                HecMath tmpMath4 = HecMath.createInstance((DataContainer)this._reverseRatingTablePanel.getSelectedDataContainer());
                outputMath = ((PairedDataMath)tmpMath4).reverseRatingTableInterpolation(this._tsmath);
                if (outputMath != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc, false);
                    return true;
                }
            } else if (TWO_VARIABLE_RATING_TABLE.equals(op)) {
                TimeSeriesMath tmpMath2;
                HecMath tmpMath5 = HecMath.createInstance((DataContainer)this._twoVariableRatingTablePanel.getSelectedDataContainer());
                outputMath = this._pdmath.twoVariableRatingTableInterpolation((TimeSeriesMath)tmpMath5, tmpMath2 = (TimeSeriesMath)HecMath.createInstance((DataContainer)this._twoVariableRatingTablePanel.get2ndSelectedDataContainer()));
                if (outputMath != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc, false);
                    return true;
                }
            } else if (DECAYING_BASIN_WETNESS.equals(op)) {
                HecMath tmpMath6 = HecMath.createInstance((DataContainer)this._decayingBasinWetnessPanel.getSelectedDataContainer());
                outputMath = this._tsmath.decayingBasinWetnessParameter(tmpMath6, this._decayingBasinWetnessPanel.getDecayRate());
                if (outputMath != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc, false);
                    return true;
                }
            } else if (SHIFT_ADJUSTMENT.equals(op)) {
                outputMath = this._tsmath.shiftAdjustment(HecMath.createInstance((DataContainer)this._shiftAdjustmentPanel.getSelectedDataContainer()));
            } else if (PERIOD_CONSTANTS.equals(op)) {
                outputMath = this._tsmath.periodConstants(HecMath.createInstance((DataContainer)this._periodConstantsPanel.getSelectedDataContainer()));
            } else if (MULTI_LINEAR_REGRESSION.equals(op)) {
                TimeSeriesMath[] tsMathArray = this._multiLinearRegressionPanel.getSelectedDataSets();
                if (tsMathArray == null) {
                    return false;
                }
                if (!(mathGuy instanceof TimeSeriesMath)) return false;
                outputMath = this._tsmath.multipleRegression((HecMath[])tsMathArray, this._multiLinearRegressionPanel.getMinLimit(), this._multiLinearRegressionPanel.getMaxLimit());
                if (outputMath != null) {
                    PairedDataContainer pdc = new PairedDataContainer();
                    outputMath.getData((DataContainer)pdc);
                    pdc.modified = true;
                    this._parent.addDataSet((DataContainer)pdc, false);
                    return true;
                }
            } else if (APPLY_MULTI_LINEAR_REGRESSION.equals(op)) {
                TimeSeriesMath[] tsMathArray = this._applyMultiLinearRegressionPanel.getSelectedDataSets();
                if (tsMathArray == null) {
                    return false;
                }
                if (mathGuy instanceof TimeSeriesMath) {
                    return false;
                }
                HecTime time = this._parent.getListSelection().getStartTime();
                String startTime = "";
                String endTime = "";
                if (time.isDefined()) {
                    startTime = time.dateAndTime();
                }
                if ((time = this._parent.getListSelection().getEndTime()).isDefined()) {
                    endTime = time.dateAndTime();
                }
                if ((outputMath = this._pdmath.applyMultipleLinearRegression(startTime, endTime, tsMathArray, this._applyMultiLinearRegressionPanel.getMinLimit(), this._applyMultiLinearRegressionPanel.getMaxLimit())) != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc, false);
                    return true;
                }
            } else if (CONIC_INTERPOLATION.equals(op)) {
                HecMath tmpMath7 = HecMath.createInstance((DataContainer)this._conicInterpPanel.getSelectedDataContainer());
                outputMath = ((PairedDataMath)tmpMath7).conicInterpolation((HecMath)this._tsmath, this._conicInterpPanel.getInputTypeString(), this._conicInterpPanel.getOutputTypeString(), this._conicInterpPanel.getScaleFactor());
                if (outputMath != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc, false);
                    return true;
                }
            } else if (POLYNOMIAL.equals(op)) {
                HecMath tmpMath8 = HecMath.createInstance((DataContainer)this._polynomialPanel.getSelectedDataContainer());
                outputMath = ((PairedDataMath)tmpMath8).polynomialTransformation(this._tsmath);
                if (outputMath != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc, false);
                    return true;
                }
            } else if (POLYNOMIAL_WITH_INTERGRAL.equals(op)) {
                HecMath tmpMath9 = HecMath.createInstance((DataContainer)this._polynomialWithIntergralPanel.getSelectedDataContainer());
                outputMath = ((PairedDataMath)tmpMath9).polynomialTransformationWithIntegral(this._tsmath);
                if (outputMath != null) {
                    TimeSeriesContainer tsc = new TimeSeriesContainer();
                    outputMath.getData((DataContainer)tsc);
                    tsc.modified = true;
                    this._parent.addDataSet((DataContainer)tsc, false);
                    return true;
                }
            } else if (FLOW_ACCUMULATOR_GAGE_PROCESSOR.equals(op) && (outputMath = this._tsmath.flowAccumulatorGageProcessor(tmpMath = HecMath.createInstance((DataContainer)this._flowAccumlatorPanel.getSelectedDataContainer()))) != null) {
                TimeSeriesContainer tsc = new TimeSeriesContainer();
                outputMath.getData((DataContainer)tsc);
                tsc.modified = true;
                this._parent.addDataSet((DataContainer)tsc, false);
                return true;
            }
            if (outputMath == null) return false;
            outputMath.getData((DataContainer)outputDc);
            this._parent.updateSelectedDataSet((DataContainer)outputDc);
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Compute Error", 0);
            System.out.println("compute: Exception " + e);
            return false;
        }
    }

    @Override
    public String getTabName() {
        return "Hydrologic";
    }

    class MuskingumPanel
    extends MathPanel.MathCardPanel {
        private RmaJIntegerField _numReachesFld;
        private RmaJDecimalField _muskingumKFld;
        private RmaJDecimalField _muskingumXFld;
        private JLabel _numReachesLabel;
        private JLabel _muskingumKLabel;
        private JLabel _muskingumXLabel;

        MuskingumPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._numReachesLabel = new JLabel("Number of Reaches:");
            this._numReachesLabel.setDisplayedMnemonic('N');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._numReachesLabel, gbc);
            this._numReachesFld = new RmaJIntegerField();
            this._numReachesFld.setMinValue(0);
            this._numReachesLabel.setLabelFor((Component)this._numReachesFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._numReachesFld, gbc);
            this._muskingumKLabel = new JLabel("Muskingum K:");
            this._muskingumKLabel.setDisplayedMnemonic('K');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._muskingumKLabel, gbc);
            this._muskingumKFld = new RmaJDecimalField();
            this._muskingumKLabel.setLabelFor((Component)this._muskingumKFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._muskingumKFld, gbc);
            this._muskingumXLabel = new JLabel("Muskingum X:");
            this._muskingumXLabel.setDisplayedMnemonic('X');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._muskingumXLabel, gbc);
            this._muskingumXFld = new RmaJDecimalField();
            this._muskingumXFld.setMinValue(0.0);
            this._muskingumXFld.setMaxValue(0.5);
            this._muskingumXLabel.setLabelFor((Component)this._muskingumXFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._muskingumXFld, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._numReachesFld.addKeyListener((KeyListener)kl);
            this._muskingumKFld.addKeyListener((KeyListener)kl);
            this._muskingumXFld.addKeyListener((KeyListener)kl);
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public boolean isComputable() {
            if (this._numReachesFld.getText().length() == 0) {
                this.setStatusLineText("No ", this._numReachesLabel, " entered");
                return false;
            }
            if (this._muskingumKFld.getText().length() == 0) {
                this.setStatusLineText("No ", this._muskingumKLabel, " entered");
                return false;
            }
            if (this._muskingumXFld.getText().length() == 0) {
                this.setStatusLineText("No ", this._muskingumXLabel, " entered");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public int getNumReaches() {
            return this._numReachesFld.getValue();
        }

        public double getMuskingumK() {
            double d = this._muskingumKFld.getValueUndefined();
            if (d == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return d;
        }

        public double getMuskingumX() {
            double d = this._muskingumXFld.getValueUndefined();
            if (d == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return d;
        }
    }

    class StraddleStaggerPanel
    extends MathPanel.MathCardPanel {
        private RmaJIntegerField _numberToAverageFld;
        private RmaJIntegerField _numberToLagFld;
        private RmaJIntegerField _numberSubreachesFld;
        private JLabel _numberToAverageLabel;
        private JLabel _numberToLagLabel;
        private JLabel _numberSubreachesLabel;

        StraddleStaggerPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._numberToAverageLabel = new JLabel("Number to Average:");
            this._numberToAverageLabel.setDisplayedMnemonic('N');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._numberToAverageLabel, gbc);
            this._numberToAverageFld = new RmaJIntegerField();
            this._numberToAverageFld.setMinValue(0);
            this._numberToAverageLabel.setLabelFor((Component)this._numberToAverageFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._numberToAverageFld, gbc);
            this._numberToLagLabel = new JLabel("Number to Lag:");
            this._numberToLagLabel.setDisplayedMnemonic('L');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._numberToLagLabel, gbc);
            this._numberToLagFld = new RmaJIntegerField();
            this._numberToLagFld.setMinValue(0);
            this._numberToLagLabel.setLabelFor((Component)this._numberToLagFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._numberToLagFld, gbc);
            this._numberSubreachesLabel = new JLabel("Number of SubReaches:");
            this._numberSubreachesLabel.setDisplayedMnemonic('S');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._numberSubreachesLabel, gbc);
            this._numberSubreachesFld = new RmaJIntegerField();
            this._numberSubreachesFld.setMinValue(0);
            this._numberSubreachesLabel.setLabelFor((Component)this._numberSubreachesFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._numberSubreachesFld, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._numberToAverageFld.addKeyListener((KeyListener)kl);
            this._numberToLagFld.addKeyListener((KeyListener)kl);
            this._numberSubreachesFld.addKeyListener((KeyListener)kl);
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public boolean isComputable() {
            if (this._numberToAverageFld.getText().length() == 0) {
                this.setStatusLineText("No ", this._numberToAverageLabel, " entered.");
                return false;
            }
            if (this._numberToLagFld.getText().length() == 0) {
                this.setStatusLineText("No ", this._numberToLagLabel, " entered.");
                return false;
            }
            if (this._numberSubreachesFld.getText().length() == 0) {
                this.setStatusLineText("No ", this._numberSubreachesLabel, " entered.");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public int getNumberToAverage() {
            return this._numberToAverageFld.getValue();
        }

        public int getNumberToLag() {
            return this._numberToLagFld.getValue();
        }

        public int getNumberSubreaches() {
            return this._numberSubreachesFld.getValue();
        }
    }

    class ModifiedPulsPanel
    extends MathPanel.MathCardPanel {
        private RmaJIntegerField _numberSubreachesFld;
        private RmaJDecimalField _muskingumXFld;
        private RmaJList _dataSetList;
        private JLabel _numberSubreachesLabel;
        private JLabel _muskingumXLabel;
        private JLabel _dataSetLabel;
        private JScrollPane _dataSetScrollPane;

        ModifiedPulsPanel() {
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            this._numberSubreachesLabel = new JLabel("Number of SubReaches:");
            this._numberSubreachesLabel.setDisplayedMnemonic('S');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._numberSubreachesLabel, gbc);
            this._numberSubreachesFld = new RmaJIntegerField();
            this._numberSubreachesFld.setMinValue(0);
            this._numberSubreachesLabel.setLabelFor((Component)this._numberSubreachesFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._numberSubreachesFld, gbc);
            this._muskingumXLabel = new JLabel("Muskingum X:");
            this._muskingumXLabel.setDisplayedMnemonic('X');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._muskingumXLabel, gbc);
            this._muskingumXFld = new RmaJDecimalField();
            this._muskingumXFld.setMinValue(0.0);
            this._muskingumXFld.setMaxValue(0.5);
            this._muskingumXLabel.setLabelFor((Component)this._muskingumXFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._muskingumXFld, gbc);
            this._dataSetLabel = new JLabel("Storage-Discharge Paired Data Set");
            this._dataSetLabel.setDisplayedMnemonic('T');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._dataSetLabel, gbc);
            this._dataSetList = new RmaJList(){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    return d;
                }
            };
            this._dataSetLabel.setLabelFor((Component)this._dataSetList);
            this._dataSetList.setSelectionMode(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this._dataSetScrollPane = new JScrollPane((Component)this._dataSetList);
            this.add((Component)this._dataSetScrollPane, gbc);
            this._dataSetList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    RoutingTab.this.setComputeButtonEnabled(ModifiedPulsPanel.this.isComputable());
                }
            });
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._numberSubreachesFld.addKeyListener((KeyListener)kl);
            this._muskingumXFld.addKeyListener((KeyListener)kl);
        }

        @Override
        public void setDataContainers(Vector v) {
            if (v == null) {
                this._dataSetList.setListData((Vector)null);
                return;
            }
            DefaultListModel newModel = new DefaultListModel();
            for (int i = 0; i < v.size(); ++i) {
                Object obj = v.get(i);
                if (obj == null || !(obj instanceof PairedDataContainer)) continue;
                newModel.addElement(v.get(i));
            }
            this._dataSetList.setModel(newModel);
            if (newModel.size() == 1) {
                this._dataSetList.setSelectedIndex(0);
            }
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc != null) {
                boolean enabled = dc instanceof TimeSeriesContainer;
                this.setEnabled(enabled);
                if (!enabled) {
                    this.setStatusLineText("Selected Data Set not a Time Series Data Set");
                } else {
                    this.clearStatusLineText();
                }
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public boolean isComputable() {
            if (!this.isEnabled()) {
                this.setStatusLineText("Selected Data Set not Time Series Data");
                return false;
            }
            if (this._numberSubreachesFld.getText().length() == 0) {
                this.setStatusLineText("No ", this._numberSubreachesLabel, " entered.");
                return false;
            }
            if (this._muskingumXFld.getText().length() == 0) {
                this.setStatusLineText("No ", this._muskingumXLabel, " entered.");
                return false;
            }
            if (this._dataSetList.getSelectedIndex() < 0) {
                this.setStatusLineText("No ", this._dataSetLabel, " selected");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        public double getMuskingumX() {
            double d = this._muskingumXFld.getValueUndefined();
            if (d == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return d;
        }

        public int getNumberSubreaches() {
            return this._numberSubreachesFld.getValue();
        }

        public PairedDataContainer getSelectedDataContainer() {
            return (PairedDataContainer)this._dataSetList.getSelectedValue();
        }
    }

    class RatingTablePanel
    extends MathPanel.DataSetPanel {
        RatingTablePanel() {
            this.setListClassType(PairedDataContainer.class);
        }

        @Override
        public boolean isComputable() {
            if (super.isComputable()) {
                if (!(RoutingTab.this._parent.getSelectedDataSet() instanceof TimeSeriesContainer)) {
                    this.setStatusLineText("Selected Data Set is not a Time Series");
                    return false;
                }
                this.clearStatusLineText();
                return true;
            }
            return false;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            this.setEnabled(dc instanceof TimeSeriesContainer);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this._dataSetList.setEnabled(enabled);
        }
    }

    class TwoVariableRatingTablePanel
    extends MathPanel.DataSetPanel {
        private RmaJList _dataSetList2;

        TwoVariableRatingTablePanel() {
            this.setListClassType(PairedDataContainer.class);
        }

        @Override
        protected void buildPanel() {
            super.buildPanel();
            this._dataSetList2 = new RmaJList(){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    return d;
                }
            };
            this._dataSetList.setSelectionMode(0);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)new JScrollPane((Component)this._dataSetList2), gbc);
            this._dataSetList2.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    RoutingTab.this.setComputeButtonEnabled(TwoVariableRatingTablePanel.this.isComputable());
                }
            });
        }

        @Override
        public boolean isComputable() {
            if (super.isComputable()) {
                if (this._dataSetList2.getSelectedIndex() == -1) {
                    this.setStatusLineText("2nd Data Set is not selected");
                    return false;
                }
                if (this.getSelectedDataContainer() == this.get2ndSelectedDataContainer()) {
                    this.setStatusLineText("1st and 2nd Data Sets can not be the same");
                    return false;
                }
                this.clearStatusLineText();
                return true;
            }
            return false;
        }

        @Override
        public void setDataContainers(Vector dcList) {
            super.setDataContainers(dcList);
            if (dcList == null) {
                this._dataSetList.setListData((Vector)null);
                return;
            }
            DefaultListModel newModel = new DefaultListModel();
            for (int i = 0; i < dcList.size(); ++i) {
                Object obj = dcList.get(i);
                if (obj == null || !obj.getClass().isAssignableFrom(this._containerClass)) continue;
                newModel.addElement(dcList.get(i));
            }
            this._dataSetList2.setModel(newModel);
            if (newModel.getSize() == 1) {
                this._dataSetList2.setSelectedIndex(0);
            }
        }

        public DataContainer get2ndSelectedDataContainer() {
            return (DataContainer)this._dataSetList2.getSelectedValue();
        }
    }

    class DecayingBasinWetnessPanel
    extends MathPanel.DataSetPanel {
        private RmaJDecimalField _decayRateFld;
        private JLabel _decayRateLabel;

        DecayingBasinWetnessPanel() {
            this.setSelectedClassType(TimeSeriesContainer.class);
            this.setListClassType(TimeSeriesContainer.class);
        }

        @Override
        protected void buildPanel() {
            super.buildPanel();
            this._decayRateLabel = new JLabel("Decay Rate:");
            this._decayRateLabel.setDisplayedMnemonic('D');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._decayRateLabel, gbc);
            this._decayRateFld = new RmaJDecimalField();
            this._decayRateLabel.setLabelFor((Component)this._decayRateFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._decayRateFld, gbc);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._decayRateFld.addKeyListener((KeyListener)kl);
        }

        @Override
        public boolean isComputable() {
            if (super.isComputable()) {
                if (this._decayRateFld.getText().length() == 0) {
                    this.setStatusLineText("No ", this._decayRateLabel, " Entered");
                    return false;
                }
                this.clearStatusLineText();
                return true;
            }
            return false;
        }

        public double getDecayRate() {
            double d = this._decayRateFld.getValueUndefined();
            if (d == Double.NEGATIVE_INFINITY) {
                d = -3.4028234663852886E38;
            }
            return d;
        }
    }

    class MultiLinearRegressionPanel
    extends MathPanel.MathCardPanel {
        private RmaJList _dataSetList;
        private RmaJDecimalField _minLimitTxt;
        private RmaJDecimalField _maxLimitTxt;
        private JLabel _dataSetLabel;
        private boolean _applyRegression = false;

        MultiLinearRegressionPanel() {
            this.buildPanel();
        }

        MultiLinearRegressionPanel(boolean applyRegression) {
            this._applyRegression = applyRegression;
            this.buildPanel();
        }

        @Override
        protected void buildPanel() {
            JLabel label = new JLabel("Minimum Limit:");
            label.setDisplayedMnemonic('M');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._minLimitTxt = new RmaJDecimalField();
            label.setLabelFor((Component)this._minLimitTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._minLimitTxt, gbc);
            label = new JLabel("                    ");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)label, gbc);
            label = new JLabel("Maximum Limit:");
            label.setDisplayedMnemonic('a');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)label, gbc);
            this._maxLimitTxt = new RmaJDecimalField();
            label.setLabelFor((Component)this._maxLimitTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._maxLimitTxt, gbc);
            this._dataSetLabel = new JLabel("Independent Time Series Data Sets");
            this._dataSetLabel.setDisplayedMnemonic('D');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._dataSetLabel, gbc);
            this._dataSetList = new RmaJList((ListModel)new RmaListModel(true)){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    return d;
                }
            };
            this._dataSetLabel.setLabelFor((Component)this._dataSetList);
            this._dataSetList.setSelectionMode(2);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 3;
            gbc.weightx = 1.0;
            gbc.weighty = 1.5;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)new JScrollPane((Component)this._dataSetList), gbc);
            this._dataSetList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    RoutingTab.this.setComputeButtonEnabled(MultiLinearRegressionPanel.this.isComputable());
                }
            });
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._minLimitTxt.addKeyListener((KeyListener)kl);
            this._maxLimitTxt.addKeyListener((KeyListener)kl);
        }

        @Override
        public boolean isComputable() {
            if (this._dataSetList.getSelectedIndex() == -1) {
                this.setStatusLineText("No ", this._dataSetLabel, " selected.");
                return false;
            }
            if (this._applyRegression) {
                if (!(RoutingTab.this._parent.getSelectedDataSet() instanceof PairedDataContainer)) {
                    this.setStatusLineText("Selected Data Set is not a Paired Data Set");
                    return false;
                }
            } else if (!(RoutingTab.this._parent.getSelectedDataSet() instanceof TimeSeriesContainer)) {
                this.setStatusLineText("Selected Data Set is not a Time Series");
                return false;
            }
            this.clearStatusLineText();
            return true;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (this._applyRegression) {
                this.setEnabled(dc instanceof PairedDataContainer);
            } else {
                this.setEnabled(dc instanceof TimeSeriesContainer);
            }
            this.setDataContainers(RoutingTab.this._parent.getDataSets());
        }

        @Override
        public void setDataContainers(Vector dcList) {
            Object[] selObjs = this._dataSetList.getSelectedValues();
            if (dcList == null) {
                this._dataSetList.setListData((Vector)null);
                return;
            }
            RmaListModel newModel = new RmaListModel(true);
            DataContainer dc = RoutingTab.this._parent.getSelectedDataSet();
            for (int i = 0; i < dcList.size(); ++i) {
                Object obj = dcList.get(i);
                if (!(obj instanceof TimeSeriesContainer) || obj == dc) continue;
                newModel.addElement(dcList.get(i));
            }
            this._dataSetList.setModel((ListModel)newModel);
            if (selObjs != null && selObjs.length > 0) {
                int[] idxs = new int[selObjs.length];
                Arrays.fill(idxs, -1);
                for (int i = 0; i < selObjs.length; ++i) {
                    idxs[i] = newModel.indexOf(selObjs[i]);
                }
                this._dataSetList.setSelectedIndices(idxs);
            }
            if (newModel.getSize() == 1) {
                this._dataSetList.setSelectedIndex(0);
            }
        }

        public TimeSeriesMath[] getSelectedDataSets() {
            Object[] values = this._dataSetList.getSelectedValues();
            TimeSeriesMath[] mathArray = new TimeSeriesMath[values.length];
            for (int i = 0; i < values.length; ++i) {
                try {
                    mathArray[i] = (TimeSeriesMath)HecMath.createInstance((DataContainer)((DataContainer)values[i]));
                    continue;
                }
                catch (HecMathException hme) {
                    System.out.println("getSelectedDataSets: error creating HecMath object for " + values[i]);
                    JOptionPane.showMessageDialog(this, "Error during compute init" + hme.toString(), "Error", 0);
                    return null;
                }
            }
            return mathArray;
        }

        public double getMinLimit() {
            double value = this._minLimitTxt.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }

        public double getMaxLimit() {
            double value = this._maxLimitTxt.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return -3.4028234663852886E38;
            }
            return value;
        }
    }

    class ConicInterpolationPanel
    extends MathPanel.DataSetPanel {
        static final String STORAGE_TYPE = "Storage";
        static final String ELEVATION_TYPE = "Elevation";
        static final String AREA_TYPE = "Area";
        private String[] _inputTypes;
        private String[] _outputTypes;
        private RmaJComboBox _inputTypeCombo;
        private RmaJComboBox _outputTypeCombo;
        private RmaJDecimalField _storageScaleTxt;
        private JLabel _inputTypeLabel;
        private JLabel _outputTypeLabel;
        private JLabel _storageScaleLabel;

        ConicInterpolationPanel() {
        }

        @Override
        protected void buildPanel() {
            super.buildPanel();
            this._inputTypes = new String[]{STORAGE_TYPE, ELEVATION_TYPE};
            this._outputTypes = new String[]{STORAGE_TYPE, ELEVATION_TYPE, AREA_TYPE};
            this._inputTypeLabel = new JLabel("Input Type:");
            this._inputTypeLabel.setDisplayedMnemonic('I');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._inputTypeLabel, gbc);
            this._inputTypeCombo = new RmaJComboBox((Object[])this._inputTypes);
            this._inputTypeLabel.setLabelFor((Component)this._inputTypeCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._inputTypeCombo, gbc);
            this._outputTypeLabel = new JLabel("Output Type:");
            this._outputTypeLabel.setDisplayedMnemonic('O');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._outputTypeLabel, gbc);
            this._outputTypeCombo = new RmaJComboBox((Object[])this._outputTypes);
            this._outputTypeLabel.setLabelFor((Component)this._outputTypeCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._outputTypeCombo, gbc);
            this._storageScaleLabel = new JLabel("Storage Scale:");
            this._storageScaleLabel.setDisplayedMnemonic('S');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this._storageScaleLabel, gbc);
            this._storageScaleTxt = new RmaJDecimalField(1);
            this._storageScaleLabel.setLabelFor((Component)this._storageScaleTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 0, 5);
            this.add((Component)this._storageScaleTxt, gbc);
            this.setListClassType(PairedDataContainer.class);
            MathPanel.MathCardPanel.ComputeKeyListener kl = new MathPanel.MathCardPanel.ComputeKeyListener();
            this._storageScaleTxt.addKeyListener((KeyListener)kl);
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RoutingTab.this.setComputeButtonEnabled(ConicInterpolationPanel.this.isComputable());
                }
            };
            this._outputTypeCombo.addActionListener(al);
            this._inputTypeCombo.addActionListener(al);
        }

        @Override
        public boolean isComputable() {
            if (super.isComputable()) {
                boolean b;
                int inIdx = this._inputTypeCombo.getSelectedIndex();
                int outIdx = this._outputTypeCombo.getSelectedIndex();
                if (inIdx == -1) {
                    this.setStatusLineText("No ", this._inputTypeLabel, " selected");
                } else if (inIdx != -1 && inIdx == outIdx) {
                    this.setStatusLineText("Input Type can not be the same as Output Type");
                } else if (outIdx == -1) {
                    this.setStatusLineText("No ", this._outputTypeLabel, " selected");
                }
                boolean bl = b = inIdx != outIdx && inIdx != -1 && outIdx != -1 && this._storageScaleTxt.getText().length() > 0;
                if (b) {
                    this.clearStatusLineText();
                }
                return b;
            }
            return false;
        }

        @Override
        public void setSelectedDataContainer(DataContainer dc) {
            if (dc == null) {
                return;
            }
            boolean enabled = dc instanceof TimeSeriesContainer;
            this.setEnabled(enabled);
            if (enabled) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                if (tsc.parameter != null) {
                    if (tsc.parameter.startsWith("ELEV")) {
                        this._inputTypeCombo.setSelectedItem((Object)ELEVATION_TYPE);
                        this._outputTypeCombo.setSelectedIndex(-1);
                    } else if (tsc.parameter.startsWith("STOR")) {
                        this._inputTypeCombo.setSelectedItem((Object)STORAGE_TYPE);
                        this._outputTypeCombo.setSelectedIndex(-1);
                    }
                }
            }
        }

        public String getInputTypeString() {
            return (String)this._inputTypeCombo.getSelectedItem();
        }

        public String getOutputTypeString() {
            return (String)this._outputTypeCombo.getSelectedItem();
        }

        public double getScaleFactor() {
            double value = this._storageScaleTxt.getValueUndefined();
            if (value == Double.NEGATIVE_INFINITY) {
                return 1.0;
            }
            return value;
        }
    }
}

