/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.AbstractSaveAsDialog;
import hec.dssgui.ListSelection;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataManager;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SaveAs
extends AbstractSaveAsDialog {
    protected DssDataManager _dataManager = null;

    public SaveAs(Frame parent, DssDataManager dataManager, DataContainer dataContainer) {
        super(parent, true);
        this._parent = parent;
        this._dataManager = dataManager;
        this._dataContainer = dataContainer;
        this._path = new DSSPathname(this._dataContainer.fullName);
        this.setup();
        this.setText();
        if (this._dataContainer instanceof PairedDataContainer) {
            this.storeAsDoubles.setSelected(((PairedDataContainer)this._dataContainer).storedAsdoubles);
            this.storeAsDoubles.setVisible(true);
        } else if (this._dataContainer instanceof TimeSeriesContainer) {
            if (this._dataContainer.fullName.startsWith("/")) {
                this.DPartTextField.setEnabled(false);
                this.EPartTextField.setEnabled(false);
            }
            this.storeAsDoubles.setSelected(((TimeSeriesContainer)this._dataContainer).storedAsdoubles);
            this.storeAsDoubles.setVisible(true);
        }
        if (this._dataManager.isRemote()) {
            this.disableFileBrowser();
        }
    }

    public SaveAs(Frame parent) {
        super(parent, true);
        this._parent = parent;
        this._path = new DSSPathname();
        this.setup();
    }

    public SaveAs(Frame parent, DSSPathname pathname) {
        super(parent, true);
        this._parent = parent;
        this._path = pathname;
        this.setup();
        this.setText();
    }

    public SaveAs() {
        this((Frame)null);
        this._path = new DSSPathname();
    }

    @Override
    protected void openDssDialog() {
        if (this._parent instanceof ListSelection) {
            ListSelection parent = (ListSelection)this._parent;
            String openFileName = parent.openDSSFileDialog(false, "Save to file");
            if (openFileName == null) {
                return;
            }
            boolean opened = parent.openDSSFile(openFileName, false, false);
            if (!opened) {
                String message = "Error in accessing file:  " + openFileName;
                JOptionPane.showMessageDialog(this._parent, message, "Could Not Save Data Set", 2);
                return;
            }
            Vector files = ((ListSelection)this._parent).getPastFiles();
            this._fileComboBox.removeAllItems();
            for (int i = 0; i < files.size(); ++i) {
                this._fileComboBox.addItem((Object)files.elementAt(i).toString());
            }
            this._fileComboBox.setSelectedItem((Object)openFileName);
        }
    }

    @Override
    public boolean saveData() {
        Object message;
        String sname;
        Object name;
        boolean differentFile = true;
        Vector v = this.getFileList();
        int numberOpened = v.size();
        DssDataManager dataManager = this._dataManager;
        if (this.filePanel.isVisible() && (name = this._fileComboBox.getSelectedItem()) != null && (sname = name.toString()).length() > 0) {
            this._dataContainer.fileName = sname.replace('\\', '/');
        }
        if (dataManager != null && dataManager.DSSFileName() != null && this._dataContainer.fileName != null && this._dataContainer.fileName.equals(dataManager.DSSFileName().replace('\\', '/'))) {
            differentFile = false;
        }
        if (this._dataContainer == null || this._dataContainer.fileName == null || this._dataContainer.fileName.length() == 0) {
            differentFile = false;
        }
        if (this._parent instanceof ListSelection) {
            ListSelection parent = (ListSelection)this._parent;
            if (dataManager == null) {
                dataManager = parent.getDataManager();
            }
            if (differentFile) {
                parent.openDSSFile(this._dataContainer.fileName, false, false);
                dataManager = parent.getSecondDataManager();
                if (dataManager == null) {
                    message = "Error in accessing file:  " + this._dataContainer.fileName;
                    JOptionPane.showMessageDialog(this._parent, message, "Could Not Save Data Set", 2);
                    return false;
                }
            }
        }
        if (this._parent instanceof ListSelection && this._checkOverwrite) {
            Vector<String> paths = new Vector<String>();
            paths.add(this._path.pathname());
            Vector<String> paths2 = new Vector<String>();
            paths2.add(this._path.pathname());
            ListSelection parent = (ListSelection)this._parent;
            int option = parent.checkOverwriteRecords(dataManager, paths, paths2);
            if (option == 2) {
                return true;
            }
            if (option == 1) {
                return false;
            }
        }
        int status = -1;
        if (this._dataContainer != null) {
            this._dataContainer.fullName = this._path.pathname();
            this._dataContainer.fileName = dataManager.DSSFileName();
            if (this._dataContainer instanceof PairedDataContainer) {
                ((PairedDataContainer)this._dataContainer).storedAsdoubles = this.storeAsDoubles.isSelected();
            } else if (this._dataContainer instanceof TimeSeriesContainer) {
                ((TimeSeriesContainer)this._dataContainer).storedAsdoubles = this.storeAsDoubles.isSelected();
            }
            status = dataManager.writeData(this._dataContainer);
            if (differentFile && this._dataManager != null) {
                this._dataContainer.fileName = this._dataManager.DSSFileName();
            }
            if (status == 0) {
                message = new StringBuffer();
                ((StringBuffer)message).append("Saved record:  ");
                ((StringBuffer)message).append(this._path.pathname());
                if (differentFile || numberOpened > 0) {
                    ((StringBuffer)message).append("\nTo file ");
                    ((StringBuffer)message).append(dataManager.DSSFileName());
                }
                JOptionPane.showMessageDialog(this._parent, ((StringBuffer)message).toString(), "Data Set Saved", 1);
                this._dataContainer.modified = false;
                this.hide();
                return true;
            }
            message = "Error in saving record:  " + this._path.pathname() + "\nSee Log for details.";
            JOptionPane.showMessageDialog(this._parent, message, "Could Not Save Data Set", 2);
            return false;
        }
        return false;
    }

    @Override
    protected String getFileName() {
        if (this._dataManager != null) {
            return this._dataManager.DSSFileName();
        }
        return null;
    }

    @Override
    protected Vector getFileList() {
        if (this._parent instanceof ListSelection) {
            return ((ListSelection)this._parent).getDssFilenames();
        }
        return new Vector();
    }
}

