/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.appInterface.FileOpener;
import hec.dssgui.FileTransfer;
import hec.dssgui.ListSelection;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDSSFileDataManager;
import hec.heclib.dss.HecDSSUtilities;
import hec.serversuite.ServerSuiteUtil;
import hec.util.AnimatedWaitGlassPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import mil.army.usace.hec.rmi.heclib.dss.HecDSSUtilitiesRemote;
import mil.army.usace.hec.serversuite.ui.RmiFileDialog;
import rma.util.RMAIO;

public class SaveAsAction
extends AbstractAction {
    private static final String CANCEL = "Cancel";
    private static final Logger LOGGER = Logger.getLogger(ListSelection.class.getName());
    private final ListSelection _parent;
    private final boolean _remote;

    SaveAsAction(String title, ListSelection parent, boolean remote) {
        super(title);
        this._remote = remote;
        this._parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final String filename = this.getNewFileName();
        if (filename != null) {
            SwingWorker<Void, Void> copyWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    if (!SaveAsAction.this._parent.getFirstDataManager().isRemote() && !SaveAsAction.this._remote) {
                        DssDataManager localManager = SaveAsAction.this._parent.createDataManager(SaveAsAction.this._remote);
                        localManager.setDSSFileName(filename, false, 7);
                        SaveAsAction.this._parent.getFirstDataManager().copyFile(localManager, filename);
                    } else if (SaveAsAction.this._parent.getFirstDataManager().isRemote()) {
                        FileTransfer.copyBinaryFile(SaveAsAction.this._parent.getFirstDataManager().isRemote(), SaveAsAction.this._parent.getFirstDataManager().DSSFileName(), SaveAsAction.this._remote, filename);
                    } else {
                        SaveAsAction.this.copyLocalToRemote(filename);
                    }
                    return null;
                }
            };
            AnimatedWaitGlassPane animatedWaitGlassPane = this.getSaveAsGlassPane(copyWorker, "<html>Saving " + this._parent.getFirstDataManager().getDSSFileName() + "<BR>As " + filename + "</html>");
            this._parent.setGlassPane((Component)animatedWaitGlassPane);
            animatedWaitGlassPane.setVisible(true);
            animatedWaitGlassPane.setActive(true);
            copyWorker.addPropertyChangeListener(evt -> {
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    animatedWaitGlassPane.setActive(false);
                    animatedWaitGlassPane.setVisible(false);
                }
            });
            copyWorker.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLocalToRemote(String destFileName) throws IOException {
        DssDataManager localManager = this._parent.createDataManager(false);
        File tempFile = File.createTempFile(this._parent.getFirstDataManager().getDSSFileName(), ".dss");
        String tempToFileName = tempFile.getAbsolutePath();
        try {
            localManager.setDSSFileName(tempToFileName, false, this._parent.getFirstDataManager().getDssFileVersion());
            this._parent.getFirstDataManager().copyFile(localManager, tempToFileName);
            localManager.close();
            localManager.done();
            FileTransfer.copyBinaryFile(this._parent.getFirstDataManager().isRemote(), tempToFileName, this._remote, destFileName);
        }
        finally {
            HecDSSFileDataManager dm = new HecDSSFileDataManager();
            dm.unmapFile(tempToFileName);
            try {
                Files.delete(Paths.get(tempToFileName, new String[0]));
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Failed to delete temporary DSS file {0}.", tempToFileName);
                LOGGER.log(Level.FINE, "Caused by: ", ex);
            }
        }
    }

    private String getNewFileName() {
        String title = "Save As HEC-DSS File";
        Object filename = this._remote ? this.chooseRemoteFile(title) : this.chooseLocalFile(title);
        if (filename != null) {
            boolean bFileExists;
            if (!((String)filename).toLowerCase().endsWith(".dss")) {
                filename = (String)filename + ".dss";
            }
            if (bFileExists = this._remote ? HecDSSUtilitiesRemote.doesDSSFileExist((String)filename) : HecDSSUtilities.doesDSSFileExist((String)filename)) {
                SaveAsAction saveAsAction = this;
                int result = JOptionPane.showConfirmDialog(this._parent, "File " + (String)filename + " already exists. Overwrite existing file?", saveAsAction._parent.getProgramName(), 1);
                if (result != 0) {
                    filename = null;
                } else {
                    this.deleteFile((String)filename);
                }
            }
        }
        return filename;
    }

    private void deleteFile(String filename) {
        if (this._remote) {
            try {
                ServerSuiteUtil.getFileManager().deleteFile(filename);
            }
            catch (RemoteException ex) {
                LOGGER.log(Level.WARNING, "Failed to delete file {0}", filename);
                LOGGER.log(Level.FINE, "Caused by: ", ex);
            }
        } else {
            try {
                Files.delete(Paths.get(filename, new String[0]));
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Failed to delete file {0}", filename);
                LOGGER.log(Level.FINE, "Caused by: ", ex);
            }
            File newFile = new File(filename);
            if (!newFile.delete()) {
                LOGGER.log(Level.WARNING, "Failed to delete file {0}", filename);
            }
        }
    }

    private String chooseLocalFile(String title) {
        File file;
        JFileChooser chooser = this._parent.getDirectory() != null ? new JFileChooser(this._parent.getDirectory()) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(title);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.dss", "dss");
        chooser.addChoosableFileFilter(filter);
        String filePath = null;
        if (chooser.showSaveDialog(this._parent) == 0 && (file = chooser.getSelectedFile()) != null) {
            filePath = file.getAbsolutePath();
        }
        return filePath;
    }

    private String chooseRemoteFile(String title) {
        RmiFileDialog chooser = new RmiFileDialog((Frame)this._parent, true);
        FileOpener fileOpener = this._parent.getFileOpener();
        if (fileOpener == null) {
            RMAIO.postError((Component)this._parent, (String)"FileManager is unavailable.");
            return null;
        }
        chooser.setFileOpener(fileOpener);
        chooser.setTitle(title);
        if (this._parent.getRemoteDirectory() == null) {
            String url = HecDSSUtilitiesRemote.getDSSManagerUrl();
            this._parent.setRemoteDirectory(this._parent.lookupWorkingDir(url));
        }
        chooser.setStartDir(this._parent.getRemoteDirectory());
        ArrayList<String> v = new ArrayList<String>();
        v.add("*.dss");
        chooser.setFileMask(v);
        chooser.setOpenTitle();
        chooser.setVisible(true);
        String filePath = null;
        if (!chooser.isCanceled()) {
            filePath = chooser.getIdentifier().getPath();
        }
        return filePath;
    }

    private AnimatedWaitGlassPane getSaveAsGlassPane(SwingWorker<?, ?> worker, String text) {
        AnimatedWaitGlassPane animatedWaitGlassPane = new AnimatedWaitGlassPane();
        animatedWaitGlassPane.setColor(Color.BLACK);
        JButton cancelBtn = new JButton(CANCEL);
        cancelBtn.addActionListener(event -> worker.cancel(true));
        animatedWaitGlassPane.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 10.0;
        animatedWaitGlassPane.add((Component)new JPanel(), (Object)c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(100, 0, 0, 0);
        c.weighty = 0.0;
        animatedWaitGlassPane.add((Component)cancelBtn, (Object)c);
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.weighty = 0.0;
        animatedWaitGlassPane.add((Component)new JLabel(text), (Object)c);
        c.gridx = 0;
        c.gridy = 3;
        c.weighty = 10.0;
        animatedWaitGlassPane.add((Component)new JPanel(), (Object)c);
        return animatedWaitGlassPane;
    }
}

