/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.dssgui.ListSelection;
import hec.dssgui.ScriptManagerImpl;
import hec.script.AbstractScriptEditor;
import hec.script.ScriptIdentifier;
import hec.script.ScriptManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class ScriptEditor
extends AbstractScriptEditor {
    ScriptManagerImpl _scriptManager;
    AbstractScriptEditor.FolderNode _dssVueNode;
    ListSelection _parent;

    public ScriptEditor(Frame parent, boolean modal) {
        super(parent, modal);
        Dimension d;
        this.setTitle("Script Editor");
        this._parent = (ListSelection)parent;
        TreePath path = new TreePath(this._dssVueNode.getPath());
        this.tree.setSelectionPath(path);
        this.fillGroupCombo();
        this.expandTree(true);
        this._displayScriptInMenu.setVisible(true);
        this._displayScriptInMenu.setToolTipText("Activates HEC-DSSVue's script menu and adds this script to the menu");
        this._bgColorBtn.setVisible(true);
        this._displayScript.setText("Display Script on Toolbar");
        this._displayScript.setToolTipText("Whether this script is displayed on DSSVue's toolbar");
        String str = null;
        Color color = null;
        Font font = null;
        str = this._parent.getScriptEditorForegroundColor();
        color = str == null ? UIManager.getColor("TextArea.foreground") : new Color(RMAIO.parseInt((String)str));
        if (color != null) {
            this._scriptText.setForeground(color);
            this._descriptionText.setForeground(color);
        }
        if ((color = (str = this._parent.getScriptEditorBackgroundColor()) == null ? UIManager.getColor("TextArea.background") : new Color(RMAIO.parseInt((String)str))) != null) {
            this._scriptText.setBackground(color);
            this._descriptionText.setBackground(color);
        }
        if ((font = (str = this._parent.getScriptEditorFont()) == null ? UIManager.getFont("TextField.font") : Font.decode(str)) != null) {
            this._scriptText.setFont(font);
            this._descriptionText.setFont(font);
        }
        this._scriptText.setTabSize(this._parent.getScriptEditorTabSize());
        Point p = this._parent.getscriptBrowserLocation();
        if (p != null) {
            this.setLocation(p);
        }
        if ((d = this._parent.getscriptBrowserSize()) != null) {
            this.setSize(d);
        }
        this._groupCombo.setVisible(true);
        this._groupLabel.setVisible(true);
    }

    protected void fillFolderNodes() {
        this._dssVueNode = new AbstractScriptEditor.FolderNode((AbstractScriptEditor)this, (Object)"HecDssVue");
        DefaultMutableTreeNode root = ((AbstractScriptEditor.ScriptTreeModel)this.tree.getModel()).findNode((Object)"Scripts");
        root.add((MutableTreeNode)this._dssVueNode);
        ((AbstractScriptEditor.ScriptTreeModel)this.tree.getModel()).nodesWereInserted((TreeNode)root, new int[]{0});
    }

    protected String getFileName(String name) {
        if (name == null) {
            return name;
        }
        String path = this.getScriptManager().getPathFromTreePath(this.getModulePath());
        String dir = path.concat("/");
        dir = dir.concat(RMAIO.userNameToFileName((String)name)).concat(".py");
        dir = dir.replace('\\', '/');
        this.msgOut("se:getFileName:name=" + name + " path=" + dir);
        return dir;
    }

    protected ScriptManager getScriptManager() {
        if (this._scriptManager == null) {
            this._scriptManager = ScriptManagerImpl.getInstance();
        }
        return this._scriptManager;
    }

    public void importScript() {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter((FileFilter)new RMAFilenameFilter("py", "JPython Scripts"));
        chooser.showOpenDialog((Component)((Object)this));
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.newScript();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            this._scriptText.read((Reader)reader, null);
            reader.close();
            String name = RMAIO.getFileNameNoExtension((String)file.getPath());
            this._labelDisplayText.setText(name);
            this._scriptNameText.setText(name);
            this._labelDisplayText.requestFocus();
        }
        catch (IOException ioe) {
            System.out.println("se:importScript: IO Error reading " + file.getPath() + " error:" + ioe);
        }
    }

    protected boolean lockScriptFile(boolean lock, String path) {
        return true;
    }

    protected void selectScript(TreePath path) {
    }

    protected String getScriptId(TreePath tpath) {
        if (tpath == null) {
            return null;
        }
        String lastPath = tpath.getLastPathComponent().toString();
        return lastPath;
    }

    protected void saveForegroundColor(String color) {
        this._parent.setScriptEditorForegroundColor(color);
    }

    protected void saveBackgroundColor(String color) {
        this._parent.setScriptEditorBackgroundColor(color);
    }

    protected void saveFont(String font) {
        this._parent.setScriptEditorFont(font);
    }

    protected void saveSizeAndLocation() {
        this._parent.setScriptBrowserSizeAndLocation(this.getSize(), this.getLocation());
    }

    protected void saveTabSize(int tabsize) {
        this._parent.setScriptEditorTabSize(tabsize);
    }

    public boolean runScript(ScriptIdentifier id) {
        if (this._parent != null) {
            return this._parent.runScript(id);
        }
        return super.runScript(id);
    }

    protected void setEditPanelEnabled(boolean b) {
        this._bgColorBtn.setEnabled(b);
        super.setEditPanelEnabled(b);
    }
}

