/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui;

import hec.event.ConfigChangeListener;
import hec.io.Identifier;
import hec.lang.Logger;
import hec.script.Script;
import hec.script.ScriptConstants;
import hec.script.ScriptEngine;
import hec.script.ScriptIdentifier;
import hec.script.ScriptManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import rma.util.RMAIO;
import rma.util.WildCardFileFilter;

public class ScriptManagerImpl
implements ScriptManager,
ScriptConstants {
    public static final String DSS_VUE = "HecDssVue";
    private Hashtable _cache = new Hashtable();
    private static ScriptManagerImpl _scriptManager;
    private Vector _listenerList = new Vector(2);
    Object _cacheDummy = new Object();

    public static boolean debug() {
        return Logger.canDebug((String)"scripting");
    }

    private ScriptManagerImpl() {
    }

    public static ScriptManagerImpl getInstance() {
        if (_scriptManager == null) {
            _scriptManager = new ScriptManagerImpl();
        }
        return _scriptManager;
    }

    public void close() {
    }

    public Script getScript(ScriptIdentifier sid) {
        return this.getScript(sid, false);
    }

    public Script getScript(ScriptIdentifier sid, boolean readAnyway) {
        if (sid == null) {
            throw new IllegalArgumentException("getScript: Null ScriptIdentifier");
        }
        Object obj = this._cache.get(sid);
        if (!readAnyway && obj != null && obj != this._cacheDummy) {
            return (Script)obj;
        }
        Identifier fileId = this.getIdFromScriptId(sid);
        Script newScript = null;
        try {
            newScript = ScriptEngine.getNewScript();
        }
        catch (NoClassDefFoundError nfe) {
            System.out.println("*******************");
            System.out.println("ScriptManager: ERROR " + nfe);
            String cp = System.getProperty("java.class.path");
            if (cp.indexOf("jpython") < 0) {
                System.out.println("ERROR: No jpython.jar in classpath [" + cp + "]");
            }
            if (ScriptManagerImpl.debug()) {
                nfe.printStackTrace();
            }
            System.out.println("*******************");
        }
        if (this.loadScript(newScript, fileId)) {
            this._cache.put(sid, newScript);
            return newScript;
        }
        return null;
    }

    public synchronized boolean deleteScript(ScriptIdentifier sid) {
        return this.deleteScript(sid, true);
    }

    public boolean deleteScript(ScriptIdentifier sid, boolean notify) {
        return this.deleteScript(sid, notify, true);
    }

    public boolean deleteScript(ScriptIdentifier sid, boolean notify, boolean warnUser) {
        boolean removed;
        block5: {
            if (sid == null) {
                return false;
            }
            boolean deleted = false;
            this.msgOut("sm:deleteScript: removing " + sid);
            removed = false;
            File f = new File(sid.getFileName());
            this.msgOut("sm:deleteScript: removal of " + sid + " " + (removed ? "successful" : "failed"));
            try {
                removed = f.delete();
            }
            catch (Exception e) {
                if (!warnUser) break block5;
                System.out.println("deleteScript: Error deleting script " + sid.getFileName() + " Error:" + e);
            }
        }
        if (removed) {
            removed = this._cache.remove(sid) != null;
        } else {
            this.msgOut("sm: got deleteScript:" + sid);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptIdentifier getScriptId(Identifier id) {
        File f = new File(id.getPath());
        if (!f.exists() || f.isDirectory()) {
            return null;
        }
        BufferedReader reader = null;
        ScriptIdentifier sid = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(id.getPath()));
            sid = new ScriptIdentifier();
            sid.setFileName(id.getPath());
            StringBuffer description = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    if ((line = line.substring(1)).indexOf("=") == -1) continue;
                    String type = RMAIO.getType((String)line, (String)"=");
                    String param = RMAIO.getParam((String)line, (String)"=");
                    if ("name".equalsIgnoreCase(type)) {
                        sid.setUserDisplayedName(param);
                        continue;
                    }
                    if ("description".equalsIgnoreCase(type)) {
                        if (description.length() > 0) {
                            description = description.append("\n");
                        }
                        description.append(param);
                        continue;
                    }
                    if ("displayinmenu".equalsIgnoreCase(type)) {
                        sid.setDisplayedInMenu("true".equalsIgnoreCase(param));
                        continue;
                    }
                    if ("displaytouser".equalsIgnoreCase(type)) {
                        sid.setDisplayedToUser("true".equalsIgnoreCase(param));
                        continue;
                    }
                    if ("displayinselector".equalsIgnoreCase(type)) {
                        sid.setDisplayedInSelector("true".equalsIgnoreCase(param));
                        continue;
                    }
                    if ("iconname".equalsIgnoreCase(type)) {
                        sid.setIconName(param);
                        continue;
                    }
                    if ("backgroundColor".equalsIgnoreCase(type)) {
                        sid.setBackgroundColorStr(param);
                        continue;
                    }
                    if (!"group".equalsIgnoreCase(type)) continue;
                    sid.setGroupName(param);
                    continue;
                }
                if (line.length() == 0 || line.startsWith(" ")) continue;
            }
            if (sid.getUserDisplayedName() == null) {
                sid.setUserDisplayedName(RMAIO.getFileNameNoExtension((String)id.getPath()));
            }
            sid.setDescription(description.toString());
        }
        catch (IOException ioe) {
            System.out.println("IOError reading " + id.getPath() + " Error:" + ioe);
            ScriptIdentifier scriptIdentifier = null;
            return scriptIdentifier;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sid;
    }

    public Vector getScriptIdsForMode(String moduleName) {
        StringBuffer path = new StringBuffer("Scripts");
        path.append("/");
        path.append("System");
        path.append("/");
        Vector v = this.getScriptIdsForObject(path.toString());
        Vector retVec = new Vector(v.size());
        this.msgOut("sm:getScriptIdsForMode: found " + v.size() + " scripts ");
        ScriptManagerImpl.buildSortedVector(v, retVec);
        this.msgOut("sm:getScriptIdsForMode: returning " + retVec.size() + " scripts ");
        return retVec;
    }

    public boolean downLoadModule(String moduleName) {
        return false;
    }

    public Identifier getIdFromScriptId(ScriptIdentifier sid) {
        Object s;
        if (sid == null) {
            return null;
        }
        if (sid.getFileName() == null) {
            s = this.getPathFromTreePath(sid.getModulePath());
            s = (String)s + sid.getFileName();
        } else {
            s = sid.getFileName();
        }
        return new Identifier((String)s);
    }

    public String getStartDirectory() {
        String startDir = System.getProperty("profile.user.global");
        if (startDir == null) {
            startDir = System.getProperty("user.dir");
        }
        return startDir;
    }

    public String getPathFromTreePath(String treePath) {
        String dir = System.getProperty("scripts.directory", null);
        if (dir != null) {
            return dir;
        }
        StringBuffer filePath = new StringBuffer();
        filePath.append(this.getStartDirectory());
        filePath.append("/");
        filePath.append(DSS_VUE);
        filePath.append("/");
        filePath.append("scripts");
        return filePath.toString();
    }

    public void reloadScript(ScriptIdentifier sid) {
        if (sid == null) {
            return;
        }
        Script script = (Script)this._cache.get(sid);
        if (script == null) {
            return;
        }
        script = this.getScript(sid, true);
        if (script == null) {
            return;
        }
        this._cache.put(sid, script);
        this.msgOut("sm: got reloadScript:" + sid);
    }

    public void scriptAdded(ScriptIdentifier sid) {
        if (sid == null) {
            return;
        }
        Script script = (Script)this._cache.get(sid);
        if (script == null) {
            return;
        }
        script = this.getScript(sid);
        if (script == null) {
            return;
        }
        this._cache.put(sid, script);
        this.msgOut("sm: got scriptAdded:" + sid);
    }

    public boolean lockScriptFile(boolean lock, String scriptPath) {
        return true;
    }

    public String checkLockedBy(String scriptPath) {
        return null;
    }

    public void addConfigChangeListener(ConfigChangeListener listener) {
        if (this._listenerList.contains(listener)) {
            return;
        }
        this._listenerList.addElement(listener);
    }

    public void removeConfigChangeListener(ConfigChangeListener listener) {
        this._listenerList.removeElement(listener);
    }

    public boolean isUniqueScriptName(String s) {
        if (s == null) {
            return false;
        }
        return this.isUniqueScriptName(s, this._cache);
    }

    public boolean saveScript(ScriptIdentifier sid, Script script) {
        if (sid == null) {
            throw new IllegalArgumentException("Null ScriptIdentifier");
        }
        if (script == null) {
            throw new IllegalArgumentException("Null Script");
        }
        Identifier fileId = this.getIdFromScriptId(sid);
        this.msgOut("sm:saveScript: saving to file " + fileId.getPath());
        try {
            String line;
            this.msgOut("Saving script : " + fileId.getPath() + " contents:\n" + script.getScript());
            File f = new File(fileId.getPath());
            f = f.getParentFile();
            if (!f.exists()) {
                f.mkdirs();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileId.getPath()));
            BufferedReader reader = new BufferedReader(new StringReader(script.getScript()));
            while ((line = reader.readLine()) != null) {
                this.msgOut("writing:" + line);
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
            writer.close();
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("sm:saveScript: IOException saving script to file " + fileId.getPath());
            return false;
        }
        if (this._cache.remove(sid) == null) {
            this.msgOut("sm:saveScript: failed to remove " + sid);
        }
        this._cache.put(sid, script);
        return true;
    }

    public Vector getScriptIdsForObject(String scriptIdPath) {
        Vector v = new Vector();
        if (scriptIdPath == null) {
            return v;
        }
        String newPath = null;
        newPath = this.getPath(scriptIdPath);
        Identifier id = this.getIdentifier(newPath, scriptIdPath);
        boolean success = this.loadScripts(v, id, scriptIdPath);
        return v;
    }

    public Hashtable getCache() {
        return this._cache;
    }

    public boolean isUniqueScriptName(String s, Hashtable cache) {
        Enumeration e = cache.keys();
        while (e.hasMoreElements()) {
            ScriptIdentifier sid;
            Object obj = e.nextElement();
            if (!(obj instanceof ScriptIdentifier) || !(sid = (ScriptIdentifier)obj).getName().equals(s)) continue;
            return false;
        }
        return true;
    }

    protected boolean loadScript(Script newScript, Identifier fileId) {
        if (newScript == null || fileId == null) {
            return false;
        }
        BufferedReader reader = null;
        try {
            String line;
            File f = new File(fileId.getPath());
            reader = new BufferedReader(new FileReader(f));
            StringBuffer text = new StringBuffer((int)f.length());
            this.msgOut("Loading script " + fileId.getPath());
            while ((line = reader.readLine()) != null) {
                text.append(line);
                text.append("\n");
            }
            reader.close();
            newScript.setScript(text.toString());
            this.msgOut("sm:script for " + fileId.getPath() + " is " + newScript.getScript());
        }
        catch (IOException ioe) {
            System.out.println("sm:loadScript: IOException reading file " + fileId.getPath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadScripts(Vector v, Identifier dirId, String scriptTreePath) {
        if (dirId == null) {
            return false;
        }
        this.msgOut("sm:loadScriptIds: reading directory " + dirId.getPath());
        Identifier identifier = dirId;
        synchronized (identifier) {
            boolean success = false;
            String[] scripts = null;
            try {
                File f = new File(dirId.getPath());
                if (!f.exists() || !f.isDirectory()) {
                    return false;
                }
                scripts = f.list((FilenameFilter)new WildCardFileFilter("*.py"));
            }
            catch (Exception re) {
                System.out.println("sm:loadScriptIds: Exception retrieving list of scripts for " + dirId.getPath() + " Error:" + re);
                return false;
            }
            for (int i = 0; i < scripts.length; ++i) {
                Identifier id = new Identifier(dirId.getPath() + "/" + scripts[i]);
                ScriptIdentifier sid = this.getScriptId(id);
                if (sid == null) continue;
                sid.setModulePath(scriptTreePath);
                v.add(sid);
            }
        }
        return true;
    }

    private void msgOut(String msg) {
        if (ScriptManagerImpl.debug()) {
            System.out.println(msg);
        }
    }

    private void fireNotification(int action, ScriptIdentifier sid) {
    }

    public static void buildSortedVector(Vector src, Vector dest) {
        if (src == null || src.size() == 0) {
            return;
        }
        dest.addAll(src);
        Collections.sort(dest);
    }

    private String getPath(String scriptIdPath) {
        String path = this.getPathFromTreePath(scriptIdPath);
        Object newPath = null;
        if (path == null) {
            System.out.println("sm:getPath: can't determine path to directory for " + scriptIdPath);
        }
        return path;
    }

    private Identifier getIdentifier(String path, String scriptIdPath) {
        Object fileId = null;
        if (path == null || scriptIdPath == null) {
            return null;
        }
        path = path.replace('\\', '/');
        return new Identifier(path);
    }
}

